/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.beanutils;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import junitx.framework.ObjectAssert;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.configuration2.BaseConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.MapConfiguration;
import org.apache.commons.configuration2.beanutils.ConfigurationDynaBean;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestConfigurationDynaBean {
    private ConfigurationDynaBean bean;
    String[] properties = new String[]{"booleanProperty", "booleanSecond", "doubleProperty", "floatProperty", "intProperty", "longProperty", "mappedProperty.key1", "mappedProperty.key2", "mappedProperty.key3", "mappedIntProperty.key1", "shortProperty", "stringProperty", "byteProperty", "charProperty"};
    Object[] values = new Object[]{Boolean.TRUE, Boolean.TRUE, Double.MAX_VALUE, Float.valueOf(Float.MAX_VALUE), Integer.MAX_VALUE, Long.MAX_VALUE, "First Value", "Second Value", "Third Value", Integer.MAX_VALUE, (short)Short.MAX_VALUE, "This is a string", (byte)127, Character.valueOf('\uffff')};
    int[] intArray = new int[]{0, 10, 20, 30, 40};
    boolean[] booleanArray = new boolean[]{true, false, true, false, true};
    char[] charArray = new char[]{'a', 'b', 'c', 'd', 'e'};
    byte[] byteArray = new byte[]{0, 10, 20, 30, 40};
    long[] longArray = new long[]{0L, 10L, 20L, 30L, 40L};
    short[] shortArray = new short[]{0, 10, 20, 30, 40};
    float[] floatArray = new float[]{0.0f, 10.0f, 20.0f, 30.0f, 40.0f};
    double[] doubleArray = new double[]{0.0, 10.0, 20.0, 30.0, 40.0};
    String[] stringArray = new String[]{"String 0", "String 1", "String 2", "String 3", "String 4"};

    protected Configuration createConfiguration() {
        return new BaseConfiguration();
    }

    /*
     * WARNING - void declaration
     */
    @Before
    public void setUp() throws Exception {
        void var2_3;
        Configuration configuration = this.createConfiguration();
        boolean bl = false;
        while (var2_3 < this.properties.length) {
            configuration.setProperty(this.properties[var2_3], this.values[var2_3]);
            ++var2_3;
        }
        for (int element : this.intArray) {
            configuration.addProperty("intIndexed", (Object)element);
        }
        for (String element : this.stringArray) {
            configuration.addProperty("stringIndexed", (Object)element);
        }
        List<String> list = Arrays.asList(this.stringArray);
        configuration.addProperty("listIndexed", list);
        this.bean = new ConfigurationDynaBean(configuration);
        this.bean.set("listIndexed", list);
        this.bean.set("intArray", (Object)this.intArray);
        this.bean.set("booleanArray", (Object)this.booleanArray);
        this.bean.set("charArray", (Object)this.charArray);
        this.bean.set("longArray", (Object)this.longArray);
        this.bean.set("shortArray", (Object)this.shortArray);
        this.bean.set("floatArray", (Object)this.floatArray);
        this.bean.set("doubleArray", (Object)this.doubleArray);
        this.bean.set("byteArray", (Object)this.byteArray);
        this.bean.set("stringArray", (Object)this.stringArray);
    }

    @Test(expected=NullPointerException.class)
    public void testAddNullPropertyValue() {
        this.bean.set("nullProperty", null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetDescriptorArguments() {
        DynaProperty descriptor = this.bean.getDynaClass().getDynaProperty("unknown");
        Assert.assertNull((String)"Unknown property descriptor should be null", (Object)descriptor);
        this.bean.getDynaClass().getDynaProperty(null);
    }

    protected void testGetDescriptorBase(String name, Class<?> type) {
        DynaProperty descriptor = this.bean.getDynaClass().getDynaProperty(name);
        Assert.assertNotNull((String)"Failed to get descriptor", (Object)descriptor);
        Assert.assertEquals((String)"Got incorrect type", type, (Object)descriptor.getType());
    }

    @Test
    public void testGetDescriptorBoolean() {
        this.testGetDescriptorBase("booleanProperty", Boolean.TYPE);
    }

    @Test
    public void testGetDescriptorDouble() {
        this.testGetDescriptorBase("doubleProperty", Double.TYPE);
    }

    @Test
    public void testGetDescriptorFloat() {
        this.testGetDescriptorBase("floatProperty", Float.TYPE);
    }

    @Test
    public void testGetDescriptorInt() {
        this.testGetDescriptorBase("intProperty", Integer.TYPE);
    }

    @Test
    public void testGetDescriptorLong() {
        this.testGetDescriptorBase("longProperty", Long.TYPE);
    }

    @Test
    public void testGetDescriptors() {
        DynaProperty[] pd = this.bean.getDynaClass().getDynaProperties();
        Assert.assertNotNull((String)"Got descriptors", (Object)pd);
        int[] count = new int[this.properties.length];
        for (DynaProperty element : pd) {
            String name = element.getName();
            for (int j = 0; j < this.properties.length; ++j) {
                if (!name.equals(this.properties[j])) continue;
                int n = j;
                count[n] = count[n] + 1;
            }
        }
        for (int j = 0; j < this.properties.length; ++j) {
            if (count[j] < 0) {
                Assert.fail((String)("Missing property " + this.properties[j]));
                continue;
            }
            if (count[j] <= 1) continue;
            Assert.fail((String)("Duplicate property " + this.properties[j]));
        }
    }

    @Test
    public void testGetDescriptorSecond() {
        this.testGetDescriptorBase("booleanSecond", Boolean.TYPE);
    }

    @Test
    public void testGetDescriptorShort() {
        this.testGetDescriptorBase("shortProperty", Short.TYPE);
    }

    @Test
    public void testGetDescriptorString() {
        this.testGetDescriptorBase("stringProperty", String.class);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testGetIndexedArguments() {
        this.bean.get("intArray", -1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetIndexedNonExisting() {
        this.bean.get("Non existing property", 0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetIndexedString() {
        this.bean.set("stringProp", (Object)"value");
        this.bean.get("stringProp", 0);
    }

    @Test
    public void testGetIndexedValues() {
        for (int i = 0; i < 5; ++i) {
            Object value = this.bean.get("intArray", i);
            Assert.assertNotNull((String)("intArray index " + i + " did not return value."), (Object)value);
            ObjectAssert.assertInstanceOf((String)("intArray index " + i), Integer.class, (Object)value);
            Assert.assertEquals((String)("intArray " + i + " returned incorrect value."), (long)(i * 10), (long)((Integer)value).intValue());
            value = this.bean.get("intIndexed", i);
            Assert.assertNotNull((String)("intIndexed index " + i + "returned value " + i), (Object)value);
            ObjectAssert.assertInstanceOf((String)("intIndexed index " + i), Integer.class, (Object)value);
            Assert.assertEquals((String)("intIndexed index " + i + "returned correct " + i), (long)(i * 10), (long)((Integer)value).intValue());
            value = this.bean.get("listIndexed", i);
            Assert.assertNotNull((String)("listIndexed index " + i + "returned value " + i), (Object)value);
            ObjectAssert.assertInstanceOf((String)("list index " + i), String.class, (Object)value);
            Assert.assertEquals((String)("listIndexed index " + i + "returned correct " + i), (Object)("String " + i), (Object)value);
            value = this.bean.get("stringArray", i);
            Assert.assertNotNull((String)("stringArray index " + i + " returnde null."), (Object)value);
            Assert.assertFalse((String)("stringArray index " + i + " returned array instead of String."), (boolean)value.getClass().isArray());
            ObjectAssert.assertInstanceOf((String)("stringArray index " + i), String.class, (Object)value);
            Assert.assertEquals((String)("stringArray returned correct " + i), (Object)("String " + i), (Object)value);
            value = this.bean.get("stringIndexed", i);
            Assert.assertNotNull((String)("stringIndexed returned value " + i), (Object)value);
            ObjectAssert.assertInstanceOf((String)"stringIndexed", String.class, (Object)value);
            Assert.assertEquals((String)("stringIndexed returned correct " + i), (Object)("String " + i), (Object)value);
        }
    }

    @Test
    public void testGetMappedArguments() {
        try {
            Object value = this.bean.get("mappedProperty", "unknown");
            Assert.assertNull((String)"Should not return a value", (Object)value);
        }
        catch (Throwable t) {
            Assert.fail((String)("Threw " + t + " instead of returning null"));
        }
    }

    @Test
    public void testGetMappedValues() {
        Object value = this.bean.get("mappedProperty", "key1");
        Assert.assertEquals((String)"Can find first value", (Object)"First Value", (Object)value);
        value = this.bean.get("mappedProperty", "key2");
        Assert.assertEquals((String)"Can find second value", (Object)"Second Value", (Object)value);
        value = this.bean.get("mappedProperty", "key3");
        Assert.assertNotNull((String)"Cannot find third value", (Object)value);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetNonExistentProperty() {
        this.bean.get("nonexistProperty");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetNonIndexedProperties() {
        this.bean.get("booleanProperty", 0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetSimpleArguments() {
        this.bean.get("a non existing property");
    }

    @Test
    public void testGetSimpleBoolean() {
        Object value = this.bean.get("booleanProperty");
        Assert.assertNotNull((String)"Got a value", (Object)value);
        ObjectAssert.assertInstanceOf((String)"Got correct type", Boolean.class, (Object)value);
        Assert.assertTrue((String)"Got correct value", (boolean)((Boolean)value));
    }

    @Test
    public void testGetSimpleDouble() {
        Object value = this.bean.get("doubleProperty");
        Assert.assertNotNull((String)"Got a value", (Object)value);
        ObjectAssert.assertInstanceOf((String)"Got correct type", Double.class, (Object)value);
        Assert.assertEquals((String)"Got correct value", (double)((Double)value), (double)Double.MAX_VALUE, (double)0.005);
    }

    @Test
    public void testGetSimpleFloat() {
        Object value = this.bean.get("floatProperty");
        Assert.assertNotNull((String)"Got a value", (Object)value);
        ObjectAssert.assertInstanceOf((String)"Got correct type", Float.class, (Object)value);
        Assert.assertEquals((String)"Got correct value", (float)((Float)value).floatValue(), (float)Float.MAX_VALUE, (float)0.005f);
    }

    @Test
    public void testGetSimpleInt() {
        Object value = this.bean.get("intProperty");
        Assert.assertNotNull((String)"Failed to get value", (Object)value);
        ObjectAssert.assertInstanceOf((String)"Incorrect type", Integer.class, (Object)value);
        Assert.assertEquals((String)"Incorrect value", (long)((Integer)value).intValue(), (long)Integer.MAX_VALUE);
    }

    @Test
    public void testGetSimpleLong() {
        Object value = this.bean.get("longProperty");
        Assert.assertNotNull((String)"Got a value", (Object)value);
        ObjectAssert.assertInstanceOf((String)"Returned incorrect type", Long.class, (Object)value);
        Assert.assertEquals((String)"Returned value of Incorrect value", (long)((Long)value), (long)Long.MAX_VALUE);
    }

    @Test
    public void testGetSimpleShort() {
        Object value = this.bean.get("shortProperty");
        Assert.assertNotNull((String)"Got a value", (Object)value);
        ObjectAssert.assertInstanceOf((String)"Got correct type", Short.class, (Object)value);
        Assert.assertEquals((String)"Got correct value", (long)((Short)value).shortValue(), (long)32767L);
    }

    @Test
    public void testGetSimpleString() {
        Object value = this.bean.get("stringProperty");
        Assert.assertNotNull((String)"Got a value", (Object)value);
        ObjectAssert.assertInstanceOf((String)"Got correct type", String.class, (Object)value);
        Assert.assertEquals((String)"Got correct value", (Object)value, (Object)"This is a string");
    }

    @Test
    public void testMappedContains() {
        Assert.assertTrue((String)"Can't see first key", (boolean)this.bean.contains("mappedProperty", "key1"));
        Assert.assertFalse((String)"Can see unknown key", (boolean)this.bean.contains("mappedProperty", "Unknown Key"));
    }

    @Test
    public void testMappedRemove() {
        Assert.assertTrue((String)"Can see first key", (boolean)this.bean.contains("mappedProperty", "key1"));
        this.bean.remove("mappedProperty", "key1");
        Assert.assertFalse((String)"Can not see first key", (boolean)this.bean.contains("mappedProperty", "key1"));
        Assert.assertFalse((String)"Can not see unknown key", (boolean)this.bean.contains("mappedProperty", "key4"));
        this.bean.remove("mappedProperty", "key4");
        Assert.assertFalse((String)"Can not see unknown key", (boolean)this.bean.contains("mappedProperty", "key4"));
    }

    @Test
    public void testNestedPropeties() {
        ConfigurationDynaBean nested = (ConfigurationDynaBean)this.bean.get("mappedProperty");
        String value = (String)nested.get("key1");
        Assert.assertEquals((String)"Can find first value", (Object)"First Value", (Object)value);
        nested.set("key1", (Object)"undefined");
        Assert.assertEquals((String)"Incorrect value returned", (Object)"undefined", (Object)this.bean.get("mappedProperty.key1"));
    }

    @Test
    public void testSetArrayValue() {
        MapConfiguration configuration = new MapConfiguration(new HashMap());
        configuration.getMap().put("objectArray", new Object[]{"value1", "value2", "value3"});
        ConfigurationDynaBean bean = new ConfigurationDynaBean((Configuration)configuration);
        bean.set("objectArray", 1, (Object)"New Value 1");
        Object value = bean.get("objectArray", 1);
        Assert.assertNotNull((String)"Returned new value 1", (Object)value);
        ObjectAssert.assertInstanceOf((String)"Returned String new value 1", String.class, (Object)value);
        Assert.assertEquals((String)"Returned correct new value 1", (Object)"New Value 1", (Object)value);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testSetIndexedArguments() {
        this.bean.set("intArray", -1, (Object)0);
    }

    @Test
    public void testSetIndexedValues() {
        this.bean.set("intArray", 0, (Object)1);
        Object value = this.bean.get("intArray", 0);
        Assert.assertNotNull((String)"Returned new value 0", (Object)value);
        ObjectAssert.assertInstanceOf((String)"Returned Integer new value 0", Integer.class, (Object)value);
        Assert.assertEquals((String)"Returned correct new value 0", (long)1L, (long)((Integer)value).intValue());
        this.bean.set("intIndexed", 1, (Object)11);
        value = this.bean.get("intIndexed", 1);
        Assert.assertNotNull((String)"Returned new value 1", (Object)value);
        ObjectAssert.assertInstanceOf((String)"Returned Integer new value 1", Integer.class, (Object)value);
        Assert.assertEquals((String)"Returned correct new value 1", (long)11L, (long)((Integer)value).intValue());
        this.bean.set("listIndexed", 2, (Object)"New Value 2");
        value = this.bean.get("listIndexed", 2);
        Assert.assertNotNull((String)"Returned new value 2", (Object)value);
        ObjectAssert.assertInstanceOf((String)"Returned String new value 2", String.class, (Object)value);
        Assert.assertEquals((String)"Returned correct new value 2", (Object)"New Value 2", (Object)value);
        this.bean.set("stringArray", 3, (Object)"New Value 3");
        value = this.bean.get("stringArray", 3);
        Assert.assertNotNull((String)"Returned new value 3", (Object)value);
        ObjectAssert.assertInstanceOf((String)"Returned String new value 3", String.class, (Object)value);
        Assert.assertEquals((String)"Returned correct new value 3", (Object)"New Value 3", (Object)value);
        this.bean.set("stringIndexed", 4, (Object)"New Value 4");
        value = this.bean.get("stringIndexed", 4);
        Assert.assertNotNull((String)"Returned new value 4", (Object)value);
        ObjectAssert.assertInstanceOf((String)"Returned String new value 4", String.class, (Object)value);
        Assert.assertEquals((String)"Returned correct new value 4", (Object)"New Value 4", (Object)value);
    }

    @Test
    public void testSetMappedValues() {
        this.bean.set("mappedProperty", "First Key", (Object)"New First Value");
        Assert.assertEquals((String)"Can replace old value", (Object)"New First Value", (Object)this.bean.get("mappedProperty", "First Key"));
        this.bean.set("mappedProperty", "Fourth Key", (Object)"Fourth Value");
        Assert.assertEquals((String)"Can set new value", (Object)"Fourth Value", (Object)this.bean.get("mappedProperty", "Fourth Key"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetNonIndexedProperties() {
        this.bean.set("booleanProperty", 1, (Object)Boolean.TRUE);
    }

    @Test
    public void testSetSimpleBoolean() {
        boolean oldValue = (Boolean)this.bean.get("booleanProperty");
        boolean newValue = !oldValue;
        this.bean.set("booleanProperty", (Object)newValue);
        Assert.assertEquals((String)"Matched new value", (Object)newValue, (Object)((Boolean)this.bean.get("booleanProperty")));
    }

    @Test
    public void testSetSimpleDouble() {
        double oldValue = (Double)this.bean.get("doubleProperty");
        double newValue = oldValue + 1.0;
        this.bean.set("doubleProperty", (Object)newValue);
        Assert.assertEquals((String)"Matched new value", (double)newValue, (double)((Double)this.bean.get("doubleProperty")), (double)0.005);
    }

    @Test
    public void testSetSimpleFloat() {
        float oldValue = ((Float)this.bean.get("floatProperty")).floatValue();
        float newValue = oldValue + 1.0f;
        this.bean.set("floatProperty", (Object)Float.valueOf(newValue));
        Assert.assertEquals((String)"Matched new value", (float)newValue, (float)((Float)this.bean.get("floatProperty")).floatValue(), (float)0.005f);
    }

    @Test
    public void testSetSimpleInt() {
        int oldValue = (Integer)this.bean.get("intProperty");
        int newValue = oldValue + 1;
        this.bean.set("intProperty", (Object)newValue);
        Assert.assertEquals((String)"Matched new value", (long)newValue, (long)((Integer)this.bean.get("intProperty")).intValue());
    }

    @Test
    public void testSetSimpleLong() {
        long oldValue = (Long)this.bean.get("longProperty");
        long newValue = oldValue + 1L;
        this.bean.set("longProperty", (Object)newValue);
        Assert.assertEquals((String)"Matched new value", (long)newValue, (long)((Long)this.bean.get("longProperty")));
    }

    @Test
    public void testSetSimpleShort() {
        short oldValue = (Short)this.bean.get("shortProperty");
        short newValue = (short)(oldValue + 1);
        this.bean.set("shortProperty", (Object)newValue);
        Assert.assertEquals((String)"Matched new value", (long)newValue, (long)((Short)this.bean.get("shortProperty")).shortValue());
    }

    @Test
    public void testSetSimpleString() {
        String oldValue = (String)this.bean.get("stringProperty");
        String newValue = oldValue + " Extra Value";
        this.bean.set("stringProperty", (Object)newValue);
        Assert.assertEquals((String)"Matched new value", (Object)newValue, (Object)this.bean.get("stringProperty"));
    }
}

