/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.builder;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.configuration2.builder.ConfigurationBuilderEvent;
import org.apache.commons.configuration2.event.EventListener;
import org.apache.commons.configuration2.event.EventType;
import org.junit.Assert;

public class BuilderEventListenerImpl
implements EventListener<ConfigurationBuilderEvent> {
    private final List<ConfigurationBuilderEvent> events = new LinkedList<ConfigurationBuilderEvent>();
    private Iterator<ConfigurationBuilderEvent> iterator;

    public void assertNoMoreEvents() {
        Assert.assertFalse((String)"Too many events", (boolean)this.initIterator().hasNext());
    }

    private Iterator<ConfigurationBuilderEvent> initIterator() {
        if (this.iterator == null) {
            this.iterator = this.events.iterator();
        }
        return this.iterator;
    }

    public <T extends ConfigurationBuilderEvent> T nextEvent(EventType<T> eventType) {
        Iterator<ConfigurationBuilderEvent> it = this.initIterator();
        Assert.assertTrue((String)"Too few events received", (boolean)it.hasNext());
        ConfigurationBuilderEvent nextEvent = it.next();
        Assert.assertEquals((String)"Wrong event type", eventType, (Object)nextEvent.getEventType());
        ConfigurationBuilderEvent resultEvent = nextEvent;
        return (T)resultEvent;
    }

    public void onEvent(ConfigurationBuilderEvent event) {
        this.events.add(event);
    }
}

