/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.builder;

import org.apache.commons.configuration2.builder.AutoSaveListener;
import org.apache.commons.configuration2.builder.FileBasedConfigurationBuilder;
import org.apache.commons.configuration2.event.ConfigurationEvent;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.io.FileHandler;
import org.apache.commons.configuration2.io.FileHandlerListener;
import org.easymock.EasyMock;
import org.junit.Before;
import org.junit.Test;

public class TestAutoSaveListener {
    private FileBasedConfigurationBuilder<?> builder;
    private AutoSaveListener listener;

    private void fireChangeEvent(boolean before) {
        this.listener.onEvent(new ConfigurationEvent((Object)this, ConfigurationEvent.ADD_PROPERTY, "someProperty", (Object)"someValue", before));
    }

    @Before
    public void setUp() throws Exception {
        this.builder = (FileBasedConfigurationBuilder)EasyMock.createMock(FileBasedConfigurationBuilder.class);
        this.listener = new AutoSaveListener(this.builder);
    }

    @Test
    public void testConfigurationChangedAfterLoading() throws ConfigurationException {
        this.builder.save();
        EasyMock.replay((Object[])new Object[]{this.builder});
        FileHandler handler = new FileHandler();
        this.listener.loading(handler);
        this.fireChangeEvent(false);
        this.listener.loaded(handler);
        this.fireChangeEvent(false);
        EasyMock.verify((Object[])new Object[]{this.builder});
    }

    @Test
    public void testConfigurationChangedAutoSave() throws ConfigurationException {
        this.builder.save();
        EasyMock.replay((Object[])new Object[]{this.builder});
        this.fireChangeEvent(false);
        EasyMock.verify((Object[])new Object[]{this.builder});
    }

    @Test
    public void testConfigurationChangedAutoSaveException() throws ConfigurationException {
        this.builder.save();
        EasyMock.expectLastCall().andThrow((Throwable)new ConfigurationException());
        EasyMock.replay((Object[])new Object[]{this.builder});
        this.fireChangeEvent(false);
        EasyMock.verify((Object[])new Object[]{this.builder});
    }

    @Test
    public void testConfigurationChangedBeforeUpdateNoSave() {
        EasyMock.replay((Object[])new Object[]{this.builder});
        this.fireChangeEvent(true);
    }

    @Test
    public void testConfigurationChangedWhileLoading() {
        EasyMock.replay((Object[])new Object[]{this.builder});
        this.listener.loading(new FileHandler());
        this.fireChangeEvent(false);
    }

    @Test
    public void testUpdateFileHandler() {
        FileHandler handler = (FileHandler)EasyMock.createMock(FileHandler.class);
        FileHandler handler2 = (FileHandler)EasyMock.createMock(FileHandler.class);
        handler.addFileHandlerListener((FileHandlerListener)this.listener);
        handler.removeFileHandlerListener((FileHandlerListener)this.listener);
        handler2.addFileHandlerListener((FileHandlerListener)this.listener);
        EasyMock.replay((Object[])new Object[]{handler, handler2});
        this.listener.updateFileHandler(handler);
        this.listener.updateFileHandler(handler2);
        EasyMock.verify((Object[])new Object[]{handler, handler2});
    }

    @Test
    public void testUpdateFileHandlerNull() {
        FileHandler handler = (FileHandler)EasyMock.createMock(FileHandler.class);
        handler.addFileHandlerListener((FileHandlerListener)this.listener);
        handler.removeFileHandlerListener((FileHandlerListener)this.listener);
        EasyMock.replay((Object[])new Object[]{handler});
        this.listener.updateFileHandler(handler);
        this.listener.updateFileHandler(null);
        EasyMock.verify((Object[])new Object[]{handler});
    }
}

