/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.builder;

import java.util.Collection;
import org.apache.commons.configuration2.BaseHierarchicalConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.builder.BasicConfigurationBuilder;
import org.apache.commons.configuration2.builder.BuilderConfigurationWrapperFactory;
import org.apache.commons.configuration2.builder.ConfigurationBuilder;
import org.apache.commons.configuration2.event.ConfigurationEvent;
import org.apache.commons.configuration2.event.EventListener;
import org.apache.commons.configuration2.event.EventListenerTestImpl;
import org.apache.commons.configuration2.event.EventSource;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public class TestBuilderConfigurationWrapperFactory {
    private ConfigurationBuilder<BaseHierarchicalConfiguration> createBuilderMock(BaseHierarchicalConfiguration conf) {
        ConfigurationBuilder builder = (ConfigurationBuilder)EasyMock.createMock(ConfigurationBuilder.class);
        try {
            EasyMock.expect((Object)builder.getConfiguration()).andReturn((Object)conf).anyTimes();
        }
        catch (ConfigurationException e) {
            Assert.fail((String)("Unexpected exception: " + (Object)((Object)e)));
        }
        return builder;
    }

    @Test
    public void testConfigurationBuilderWrapper() {
        BaseHierarchicalConfiguration conf = new BaseHierarchicalConfiguration();
        ConfigurationBuilder<BaseHierarchicalConfiguration> builder = this.createBuilderMock(conf);
        EasyMock.replay((Object[])new Object[]{builder});
        conf.addProperty("test1", (Object)"value1");
        conf.addProperty("test2", (Object)"42");
        BuilderConfigurationWrapperFactory factory = new BuilderConfigurationWrapperFactory();
        HierarchicalConfiguration wrapper = (HierarchicalConfiguration)factory.createBuilderConfigurationWrapper(HierarchicalConfiguration.class, builder);
        Assert.assertEquals((String)"Wrong value (1)", (Object)"value1", (Object)wrapper.getString("test1"));
        Assert.assertEquals((String)"Wrong value (2)", (long)42L, (long)wrapper.getInt("test2"));
        Assert.assertSame((String)"Wrong root node", (Object)conf.getNodeModel().getNodeHandler().getRootNode(), (Object)wrapper.getNodeModel().getNodeHandler().getRootNode());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCreateBuilderConfigurationWrapperNoBuilder() {
        BuilderConfigurationWrapperFactory factory = new BuilderConfigurationWrapperFactory();
        factory.createBuilderConfigurationWrapper(Configuration.class, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCreateBuilderConfigurationWrapperNoClass() {
        BuilderConfigurationWrapperFactory factory = new BuilderConfigurationWrapperFactory(BuilderConfigurationWrapperFactory.EventSourceSupport.BUILDER);
        factory.createBuilderConfigurationWrapper(null, this.createBuilderMock(new BaseHierarchicalConfiguration()));
    }

    @Test
    public void testDefaultEventSourceSupport() {
        BuilderConfigurationWrapperFactory factory = new BuilderConfigurationWrapperFactory();
        Assert.assertEquals((String)"Wrong result", (Object)BuilderConfigurationWrapperFactory.EventSourceSupport.NONE, (Object)factory.getEventSourceSupport());
    }

    @Test
    public void testEventSourceSupportBuilder() throws ConfigurationException {
        BasicConfigurationBuilder builder = new BasicConfigurationBuilder(PropertiesConfiguration.class);
        EventListenerTestImpl l1 = new EventListenerTestImpl(null);
        EventListenerTestImpl l2 = new EventListenerTestImpl(null);
        BuilderConfigurationWrapperFactory factory = new BuilderConfigurationWrapperFactory(BuilderConfigurationWrapperFactory.EventSourceSupport.BUILDER);
        EventSource src = (EventSource)factory.createBuilderConfigurationWrapper(Configuration.class, (ConfigurationBuilder)builder);
        src.addEventListener(ConfigurationEvent.ANY, (EventListener)l1);
        src.addEventListener(ConfigurationEvent.ANY_HIERARCHICAL, (EventListener)l2);
        Assert.assertTrue((String)"Wrong result for existing listener", (boolean)src.removeEventListener(ConfigurationEvent.ANY_HIERARCHICAL, (EventListener)l2));
        Assert.assertFalse((String)"Wrong result for non-existing listener", (boolean)src.removeEventListener(ConfigurationEvent.ANY_HIERARCHICAL, (EventListener)l2));
        PropertiesConfiguration config = (PropertiesConfiguration)builder.getConfiguration();
        Collection listeners = config.getEventListeners(ConfigurationEvent.ANY_HIERARCHICAL);
        Assert.assertTrue((String)"Registered listener not found", (boolean)listeners.contains(l1));
        Assert.assertFalse((String)"Removed listener still found", (boolean)listeners.contains(l2));
    }

    @Test
    public void testEventSourceSupportDummy() {
        BaseHierarchicalConfiguration conf = new BaseHierarchicalConfiguration();
        ConfigurationBuilder<BaseHierarchicalConfiguration> builder = this.createBuilderMock(conf);
        EasyMock.replay((Object[])new Object[]{builder});
        BuilderConfigurationWrapperFactory factory = new BuilderConfigurationWrapperFactory(BuilderConfigurationWrapperFactory.EventSourceSupport.DUMMY);
        EventSource src = (EventSource)factory.createBuilderConfigurationWrapper(HierarchicalConfiguration.class, builder);
        src.addEventListener(ConfigurationEvent.ANY, null);
    }

    @Test
    public void testEventSourceSupportMockBuilder() {
        BaseHierarchicalConfiguration conf = new BaseHierarchicalConfiguration();
        ConfigurationBuilder<BaseHierarchicalConfiguration> builder = this.createBuilderMock(conf);
        EventListenerTestImpl listener = new EventListenerTestImpl(null);
        builder.addEventListener(ConfigurationEvent.ANY, (EventListener)listener);
        EasyMock.replay((Object[])new Object[]{builder});
        BuilderConfigurationWrapperFactory factory = new BuilderConfigurationWrapperFactory(BuilderConfigurationWrapperFactory.EventSourceSupport.BUILDER);
        EventSource src = (EventSource)factory.createBuilderConfigurationWrapper(HierarchicalConfiguration.class, builder);
        src.addEventListener(ConfigurationEvent.ANY, (EventListener)listener);
        EasyMock.verify((Object[])new Object[]{builder});
    }

    @Test
    public void testEventSourceSupportNone() {
        BaseHierarchicalConfiguration conf = new BaseHierarchicalConfiguration();
        ConfigurationBuilder<BaseHierarchicalConfiguration> builder = this.createBuilderMock(conf);
        EasyMock.replay((Object[])new Object[]{builder});
        BuilderConfigurationWrapperFactory factory = new BuilderConfigurationWrapperFactory();
        HierarchicalConfiguration wrapper = (HierarchicalConfiguration)factory.createBuilderConfigurationWrapper(HierarchicalConfiguration.class, builder);
        Assert.assertFalse((String)"EventSource support", (boolean)(wrapper instanceof EventSource));
    }
}

