/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.builder;

import java.util.Map;
import org.apache.commons.configuration2.beanutils.BeanHelper;
import org.apache.commons.configuration2.builder.HierarchicalBuilderParametersImpl;
import org.apache.commons.configuration2.tree.ExpressionEngine;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestHierarchicalBuilderParametersImpl {
    private HierarchicalBuilderParametersImpl params;

    @Before
    public void setUp() throws Exception {
        this.params = new HierarchicalBuilderParametersImpl();
    }

    @Test
    public void testBeanPropertiesAccess() throws Exception {
        ExpressionEngine engine = (ExpressionEngine)EasyMock.createMock(ExpressionEngine.class);
        BeanHelper.setProperty((Object)this.params, (String)"expressionEngine", (Object)engine);
        BeanHelper.setProperty((Object)this.params, (String)"throwExceptionOnMissing", (Object)Boolean.TRUE);
        Map map = this.params.getParameters();
        Assert.assertSame((String)"Wrong expression engine", (Object)engine, map.get("expressionEngine"));
        Assert.assertEquals((String)"Wrong exception flag", (Object)Boolean.TRUE, map.get("throwExceptionOnMissing"));
    }

    @Test
    public void testInheritFrom() {
        ExpressionEngine engine = (ExpressionEngine)EasyMock.createMock(ExpressionEngine.class);
        HierarchicalBuilderParametersImpl params = new HierarchicalBuilderParametersImpl();
        params.setExpressionEngine(engine);
        params.setThrowExceptionOnMissing(true);
        HierarchicalBuilderParametersImpl params2 = new HierarchicalBuilderParametersImpl();
        params2.inheritFrom(params.getParameters());
        Map parameters = params2.getParameters();
        Assert.assertEquals((String)"Exception flag not set", (Object)Boolean.TRUE, parameters.get("throwExceptionOnMissing"));
        Assert.assertEquals((String)"Expression engine not set", (Object)engine, parameters.get("expressionEngine"));
    }

    @Test
    public void testSetExpressionEngine() {
        ExpressionEngine engine = (ExpressionEngine)EasyMock.createMock(ExpressionEngine.class);
        EasyMock.replay((Object[])new Object[]{engine});
        Assert.assertSame((String)"Wrong result", (Object)this.params, (Object)this.params.setExpressionEngine(engine));
        Assert.assertSame((String)"Wrong expression engine", (Object)engine, this.params.getParameters().get("expressionEngine"));
    }
}

