/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.builder.combined;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.configuration2.ConfigurationAssert;
import org.apache.commons.configuration2.XMLConfiguration;
import org.apache.commons.configuration2.beanutils.BeanHelper;
import org.apache.commons.configuration2.builder.BasicBuilderParameters;
import org.apache.commons.configuration2.builder.BasicConfigurationBuilder;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.builder.ConfigurationBuilder;
import org.apache.commons.configuration2.builder.DefaultParametersHandler;
import org.apache.commons.configuration2.builder.DefaultParametersManager;
import org.apache.commons.configuration2.builder.XMLBuilderParametersImpl;
import org.apache.commons.configuration2.builder.combined.CombinedBuilderParametersImpl;
import org.apache.commons.configuration2.builder.combined.ConfigurationBuilderProvider;
import org.apache.commons.configuration2.builder.fluent.FileBasedBuilderParameters;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public class TestCombinedBuilderParametersImpl {
    private static DefaultParametersHandler<BuilderParameters> createDefaultsHandlerMock() {
        return (DefaultParametersHandler)EasyMock.createMock(DefaultParametersHandler.class);
    }

    @Test
    public void testClone() {
        CombinedBuilderParametersImpl params = new CombinedBuilderParametersImpl();
        params.setBasePath("some base path");
        XMLBuilderParametersImpl defParams = new XMLBuilderParametersImpl();
        defParams.setSystemID("someSysID");
        params.setDefinitionBuilderParameters((BuilderParameters)defParams);
        CombinedBuilderParametersImpl clone = params.clone();
        Assert.assertEquals((String)"Wrong field value", (Object)params.getBasePath(), (Object)clone.getBasePath());
        Assert.assertNotSame((String)"Parameters object not cloned", (Object)params.getDefinitionBuilderParameters(), (Object)clone.getDefinitionBuilderParameters());
        Assert.assertEquals((String)"Wrong field value in parameters object", params.getDefinitionBuilderParameters().getParameters().get("systemID"), clone.getDefinitionBuilderParameters().getParameters().get("systemID"));
    }

    @Test
    public void testFromParametersCreate() {
        CombinedBuilderParametersImpl params = CombinedBuilderParametersImpl.fromParameters(new HashMap(), (boolean)true);
        Assert.assertNotNull((String)"No instance", (Object)params);
        Assert.assertNull((String)"Got data", (Object)params.getDefinitionBuilder());
    }

    @Test
    public void testFromParametersExisting() {
        CombinedBuilderParametersImpl params = new CombinedBuilderParametersImpl();
        Map map = params.getParameters();
        Assert.assertSame((String)"Wrong result", (Object)params, (Object)CombinedBuilderParametersImpl.fromParameters((Map)map));
    }

    @Test
    public void testFromParametersNotFound() {
        Assert.assertNull((String)"Got an instance", (Object)CombinedBuilderParametersImpl.fromParameters(new HashMap()));
    }

    @Test
    public void testGetChildDefaultParametersManagerSpecific() {
        DefaultParametersManager manager = (DefaultParametersManager)EasyMock.createMock(DefaultParametersManager.class);
        EasyMock.replay((Object[])new Object[]{manager});
        CombinedBuilderParametersImpl params = new CombinedBuilderParametersImpl();
        Assert.assertSame((String)"Wrong result", (Object)params, (Object)params.setChildDefaultParametersManager(manager));
        Assert.assertSame((String)"Wrong manager", (Object)manager, (Object)params.getChildDefaultParametersManager());
    }

    @Test
    public void testGetChildDefaultParametersManagerUndefined() {
        CombinedBuilderParametersImpl params = new CombinedBuilderParametersImpl();
        Assert.assertNotNull((String)"No default manager", (Object)params.getChildDefaultParametersManager());
    }

    @Test
    public void testGetParametersInherited() {
        CombinedBuilderParametersImpl params = new CombinedBuilderParametersImpl();
        params.setThrowExceptionOnMissing(true);
        Map map = params.getParameters();
        Assert.assertEquals((String)"Exception flag not found", (Object)Boolean.TRUE, map.get("throwExceptionOnMissing"));
    }

    @Test
    public void testGetProvidersInitial() {
        CombinedBuilderParametersImpl params = new CombinedBuilderParametersImpl();
        Assert.assertTrue((String)"Got providers", (boolean)params.getProviders().isEmpty());
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testGetProvidersModify() {
        CombinedBuilderParametersImpl params = new CombinedBuilderParametersImpl();
        params.getProviders().put("tag", EasyMock.createMock(ConfigurationBuilderProvider.class));
    }

    @Test
    public void testInheritFrom() {
        DefaultParametersManager manager = (DefaultParametersManager)EasyMock.createMock(DefaultParametersManager.class);
        CombinedBuilderParametersImpl params = new CombinedBuilderParametersImpl().setInheritSettings(false).setChildDefaultParametersManager(manager);
        params.setThrowExceptionOnMissing(true);
        CombinedBuilderParametersImpl params2 = new CombinedBuilderParametersImpl();
        params2.inheritFrom(params.getParameters());
        Map parameters = params2.getParameters();
        Assert.assertEquals((String)"Exception flag not set", (Object)Boolean.TRUE, parameters.get("throwExceptionOnMissing"));
        Assert.assertEquals((String)"Default manager not set", (Object)manager, (Object)params2.getChildDefaultParametersManager());
        Assert.assertFalse((String)"Inherit flag not set", (boolean)params2.isInheritSettings());
    }

    @Test
    public void testInheritFromNoParametersInMap() {
        BasicBuilderParameters params = new BasicBuilderParameters().setThrowExceptionOnMissing(true);
        CombinedBuilderParametersImpl params2 = new CombinedBuilderParametersImpl();
        params2.inheritFrom(params.getParameters());
        Map parameters = params2.getParameters();
        Assert.assertEquals((String)"Exception flag not set", (Object)Boolean.TRUE, parameters.get("throwExceptionOnMissing"));
    }

    @Test
    public void testProviderForUnknown() {
        CombinedBuilderParametersImpl params = new CombinedBuilderParametersImpl();
        Assert.assertNull((String)"Got a provider", (Object)params.providerForTag("someTag"));
    }

    @Test
    public void testRegisterChildDefaultsHandler() {
        DefaultParametersManager manager = (DefaultParametersManager)EasyMock.createMock(DefaultParametersManager.class);
        DefaultParametersHandler<BuilderParameters> handler = TestCombinedBuilderParametersImpl.createDefaultsHandlerMock();
        manager.registerDefaultsHandler(BuilderParameters.class, handler);
        EasyMock.replay((Object[])new Object[]{manager, handler});
        CombinedBuilderParametersImpl params = new CombinedBuilderParametersImpl();
        params.setChildDefaultParametersManager(manager);
        Assert.assertSame((String)"Wrong result", (Object)params, (Object)params.registerChildDefaultsHandler(BuilderParameters.class, handler));
        EasyMock.verify((Object[])new Object[]{manager});
    }

    @Test
    public void testRegisterChildDefaultsHandlerWithStartClass() {
        DefaultParametersManager manager = (DefaultParametersManager)EasyMock.createMock(DefaultParametersManager.class);
        DefaultParametersHandler<BuilderParameters> handler = TestCombinedBuilderParametersImpl.createDefaultsHandlerMock();
        manager.registerDefaultsHandler(BuilderParameters.class, handler, FileBasedBuilderParameters.class);
        EasyMock.replay((Object[])new Object[]{manager, handler});
        CombinedBuilderParametersImpl params = new CombinedBuilderParametersImpl();
        params.setChildDefaultParametersManager(manager);
        Assert.assertSame((String)"Wrong result", (Object)params, (Object)params.registerChildDefaultsHandler(BuilderParameters.class, handler, FileBasedBuilderParameters.class));
        EasyMock.verify((Object[])new Object[]{manager});
    }

    @Test
    public void testRegisterMissingProviders() {
        ConfigurationBuilderProvider provider1 = (ConfigurationBuilderProvider)EasyMock.createMock(ConfigurationBuilderProvider.class);
        ConfigurationBuilderProvider provider2 = (ConfigurationBuilderProvider)EasyMock.createMock(ConfigurationBuilderProvider.class);
        ConfigurationBuilderProvider provider3 = (ConfigurationBuilderProvider)EasyMock.createMock(ConfigurationBuilderProvider.class);
        String tagPrefix = "testTag";
        CombinedBuilderParametersImpl params = new CombinedBuilderParametersImpl();
        params.registerProvider("testTag", provider1);
        HashMap<String, ConfigurationBuilderProvider> map = new HashMap<String, ConfigurationBuilderProvider>();
        map.put("testTag", provider2);
        map.put("testTag1", provider3);
        Assert.assertSame((String)"Wrong result", (Object)params, (Object)params.registerMissingProviders(map));
        Assert.assertEquals((String)"Wrong number of providers", (long)2L, (long)params.getProviders().size());
        Assert.assertSame((String)"Wrong provider (1)", (Object)provider1, (Object)params.providerForTag("testTag"));
        Assert.assertSame((String)"Wrong provider (2)", (Object)provider3, (Object)params.providerForTag("testTag1"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRegisterMissingProvidersNullEntry() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tag", null);
        new CombinedBuilderParametersImpl().registerMissingProviders(map);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRegisterMissingProvidersNullMap() {
        Map map = null;
        new CombinedBuilderParametersImpl().registerMissingProviders(map);
    }

    @Test
    public void testRegisterMissingProvidersParams() {
        ConfigurationBuilderProvider provider1 = (ConfigurationBuilderProvider)EasyMock.createMock(ConfigurationBuilderProvider.class);
        ConfigurationBuilderProvider provider2 = (ConfigurationBuilderProvider)EasyMock.createMock(ConfigurationBuilderProvider.class);
        ConfigurationBuilderProvider provider3 = (ConfigurationBuilderProvider)EasyMock.createMock(ConfigurationBuilderProvider.class);
        String tagPrefix = "testTag";
        CombinedBuilderParametersImpl params = new CombinedBuilderParametersImpl();
        CombinedBuilderParametersImpl params2 = new CombinedBuilderParametersImpl();
        params.registerProvider("testTag", provider1);
        params2.registerProvider("testTag", provider2);
        params2.registerProvider("testTag1", provider3);
        Assert.assertSame((String)"Wrong result", (Object)params, (Object)params.registerMissingProviders(params2));
        Assert.assertEquals((String)"Wrong number of providers", (long)2L, (long)params.getProviders().size());
        Assert.assertSame((String)"Wrong provider (1)", (Object)provider1, (Object)params.providerForTag("testTag"));
        Assert.assertSame((String)"Wrong provider (2)", (Object)provider3, (Object)params.providerForTag("testTag1"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRegisterMissingProvidersParamsNull() {
        new CombinedBuilderParametersImpl().registerMissingProviders((CombinedBuilderParametersImpl)null);
    }

    @Test
    public void testRegisterProvider() {
        ConfigurationBuilderProvider provider = (ConfigurationBuilderProvider)EasyMock.createMock(ConfigurationBuilderProvider.class);
        EasyMock.replay((Object[])new Object[]{provider});
        String tagName = "testTag";
        CombinedBuilderParametersImpl params = new CombinedBuilderParametersImpl();
        Assert.assertSame((String)"Wrong result", (Object)params, (Object)params.registerProvider("testTag", provider));
        Map providers = params.getProviders();
        Assert.assertEquals((String)"Wrong number of providers", (long)1L, (long)providers.size());
        Assert.assertSame((String)"Wrong provider (1)", (Object)provider, providers.get("testTag"));
        Assert.assertSame((String)"Wrong provider (2)", (Object)provider, (Object)params.providerForTag("testTag"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRegisterProviderNoProvider() {
        new CombinedBuilderParametersImpl().registerProvider("aTag", null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRegisterProviderNoTag() {
        new CombinedBuilderParametersImpl().registerProvider(null, (ConfigurationBuilderProvider)EasyMock.createMock(ConfigurationBuilderProvider.class));
    }

    @Test
    public void testSetBasePath() {
        CombinedBuilderParametersImpl params = new CombinedBuilderParametersImpl();
        String basePath = ConfigurationAssert.OUT_DIR.getAbsolutePath();
        Assert.assertSame((String)"Wrong result", (Object)params, (Object)params.setBasePath(basePath));
        Assert.assertEquals((String)"Wrong base path", (Object)basePath, (Object)params.getBasePath());
    }

    @Test
    public void testSetBeanProperties() throws Exception {
        BuilderParameters defparams = (BuilderParameters)EasyMock.createMock(BuilderParameters.class);
        EasyMock.replay((Object[])new Object[]{defparams});
        CombinedBuilderParametersImpl params = new CombinedBuilderParametersImpl();
        BeanHelper.setProperty((Object)params, (String)"basePath", (Object)"testPath");
        BeanHelper.setProperty((Object)params, (String)"definitionBuilderParameters", (Object)defparams);
        BeanHelper.setProperty((Object)params, (String)"inheritSettings", (Object)false);
        Assert.assertEquals((String)"Wrong path", (Object)"testPath", (Object)params.getBasePath());
        Assert.assertSame((String)"Wrong def parameters", (Object)defparams, (Object)params.getDefinitionBuilderParameters());
        Assert.assertFalse((String)"Wrong inherit flag", (boolean)params.isInheritSettings());
    }

    @Test
    public void testSetDefinitionBuilder() {
        CombinedBuilderParametersImpl params = new CombinedBuilderParametersImpl();
        Assert.assertNull((String)"Got a definition builder", (Object)params.getDefinitionBuilder());
        BasicConfigurationBuilder builder = new BasicConfigurationBuilder(XMLConfiguration.class);
        Assert.assertSame((String)"Wrong result", (Object)params, (Object)params.setDefinitionBuilder((ConfigurationBuilder)builder));
        Assert.assertSame((String)"Builder was not set", (Object)builder, (Object)params.getDefinitionBuilder());
    }

    @Test
    public void testSetDefinitionBuilderParameters() {
        BuilderParameters defparams = (BuilderParameters)EasyMock.createMock(BuilderParameters.class);
        EasyMock.replay((Object[])new Object[]{defparams});
        CombinedBuilderParametersImpl params = new CombinedBuilderParametersImpl();
        Assert.assertSame((String)"Wrong result", (Object)params, (Object)params.setDefinitionBuilderParameters(defparams));
        Assert.assertSame((String)"Wrong parameters object", (Object)defparams, (Object)params.getDefinitionBuilderParameters());
    }

    @Test
    public void testSetInheritSettings() {
        CombinedBuilderParametersImpl params = new CombinedBuilderParametersImpl();
        Assert.assertTrue((String)"Wrong initial value", (boolean)params.isInheritSettings());
        Assert.assertSame((String)"Wrong result", (Object)params, (Object)params.setInheritSettings(false));
        Assert.assertFalse((String)"Property not set", (boolean)params.isInheritSettings());
    }
}

