/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.builder.combined;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration2.XMLConfiguration;
import org.apache.commons.configuration2.builder.BasicBuilderParameters;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.builder.FileBasedConfigurationBuilder;
import org.apache.commons.configuration2.builder.ReloadingFileBasedConfigurationBuilder;
import org.apache.commons.configuration2.builder.XMLBuilderParametersImpl;
import org.apache.commons.configuration2.builder.combined.AbstractMultiFileConfigurationBuilderTest;
import org.apache.commons.configuration2.builder.combined.ReloadingMultiFileConfigurationBuilder;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.reloading.ReloadingController;
import org.apache.commons.configuration2.tree.ExpressionEngine;
import org.apache.commons.configuration2.tree.xpath.XPathExpressionEngine;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public class TestReloadingMultiFileConfigurationBuilder
extends AbstractMultiFileConfigurationBuilderTest {
    @Test
    public void testCreateManagedBuilder() throws ConfigurationException {
        ReloadingMultiFileConfigurationBuilder builder = new ReloadingMultiFileConfigurationBuilder(XMLConfiguration.class);
        FileBasedConfigurationBuilder managedBuilder = builder.createManagedBuilder("test.xml", TestReloadingMultiFileConfigurationBuilder.createTestBuilderParameters(null).getParameters());
        Assert.assertTrue((String)"Not a reloading builder", (boolean)(managedBuilder instanceof ReloadingFileBasedConfigurationBuilder));
        Assert.assertFalse((String)"Wrong flag value", (boolean)managedBuilder.isAllowFailOnInit());
    }

    @Test
    public void testCreateManagedBuilderWithAllowFailFlag() throws ConfigurationException {
        ReloadingMultiFileConfigurationBuilder builder = new ReloadingMultiFileConfigurationBuilder(XMLConfiguration.class, null, true);
        FileBasedConfigurationBuilder managedBuilder = builder.createManagedBuilder("test.xml", TestReloadingMultiFileConfigurationBuilder.createTestBuilderParameters(null).getParameters());
        Assert.assertTrue((String)"Wrong flag value", (boolean)managedBuilder.isAllowFailOnInit());
    }

    @Test
    public void testInitWithParameters() throws ConfigurationException {
        XPathExpressionEngine engine = new XPathExpressionEngine();
        BasicBuilderParameters params = TestReloadingMultiFileConfigurationBuilder.createTestBuilderParameters((BuilderParameters)new XMLBuilderParametersImpl().setExpressionEngine((ExpressionEngine)engine));
        ReloadingMultiFileConfigurationBuilder builder = new ReloadingMultiFileConfigurationBuilder(XMLConfiguration.class, params.getParameters());
        TestReloadingMultiFileConfigurationBuilder.switchToConfig(1);
        XMLConfiguration config = (XMLConfiguration)builder.getConfiguration();
        Assert.assertSame((String)"Expression engine not set", (Object)engine, (Object)config.getExpressionEngine());
    }

    @Test
    public void testReloadingControllerCheck() throws ConfigurationException {
        ReloadingMultiFileConfigurationBuilderTestImpl builder = new ReloadingMultiFileConfigurationBuilderTestImpl();
        TestReloadingMultiFileConfigurationBuilder.switchToConfig(1);
        builder.getConfiguration();
        TestReloadingMultiFileConfigurationBuilder.switchToConfig(2);
        builder.getConfiguration();
        List<ReloadingController> controllers = builder.getReloadingControllers();
        Assert.assertEquals((String)"Wrong number of reloading controllers", (long)2L, (long)controllers.size());
        EasyMock.reset((Object[])controllers.toArray());
        for (ReloadingController c : controllers) {
            EasyMock.expect((Object)c.checkForReloading(null)).andReturn((Object)Boolean.FALSE);
        }
        EasyMock.replay((Object[])controllers.toArray());
        Assert.assertFalse((String)"Wrong result", (boolean)builder.getReloadingController().checkForReloading((Object)this));
        EasyMock.verify((Object[])controllers.toArray());
    }

    @Test
    public void testReloadingControllerCheckReloadingRequired() throws ConfigurationException {
        ReloadingMultiFileConfigurationBuilderTestImpl builder = new ReloadingMultiFileConfigurationBuilderTestImpl();
        for (int i = 1; i <= 3; ++i) {
            TestReloadingMultiFileConfigurationBuilder.switchToConfig(i);
            builder.getConfiguration();
        }
        List<ReloadingController> controllers = builder.getReloadingControllers();
        EasyMock.reset((Object[])controllers.toArray());
        EasyMock.expect((Object)controllers.get(0).checkForReloading(null)).andReturn((Object)Boolean.FALSE).anyTimes();
        EasyMock.expect((Object)controllers.get(1).checkForReloading(null)).andReturn((Object)Boolean.TRUE);
        EasyMock.expect((Object)controllers.get(2).checkForReloading(null)).andReturn((Object)Boolean.FALSE).anyTimes();
        EasyMock.replay((Object[])controllers.toArray());
        Assert.assertTrue((String)"Wrong result", (boolean)builder.getReloadingController().checkForReloading((Object)this));
        EasyMock.verify((Object[])controllers.toArray());
    }

    @Test
    public void testReloadingControllerResetReloadingState() throws ConfigurationException {
        ReloadingMultiFileConfigurationBuilderTestImpl builder = new ReloadingMultiFileConfigurationBuilderTestImpl();
        TestReloadingMultiFileConfigurationBuilder.switchToConfig(1);
        builder.getConfiguration();
        TestReloadingMultiFileConfigurationBuilder.switchToConfig(2);
        builder.getConfiguration();
        List<ReloadingController> controllers = builder.getReloadingControllers();
        EasyMock.reset((Object[])controllers.toArray());
        for (ReloadingController c : controllers) {
            EasyMock.expect((Object)c.checkForReloading(null)).andReturn((Object)Boolean.TRUE).anyTimes();
            c.resetReloadingState();
        }
        EasyMock.replay((Object[])controllers.toArray());
        builder.getReloadingController().checkForReloading(null);
        builder.getReloadingController().resetReloadingState();
        EasyMock.verify((Object[])controllers.toArray());
    }

    private static class ReloadingMultiFileConfigurationBuilderTestImpl
    extends ReloadingMultiFileConfigurationBuilder<XMLConfiguration> {
        private final List<ReloadingController> reloadingControllers = new ArrayList<ReloadingController>();

        public ReloadingMultiFileConfigurationBuilderTestImpl() {
            super(XMLConfiguration.class, AbstractMultiFileConfigurationBuilderTest.createTestBuilderParameters(null).getParameters());
        }

        protected FileBasedConfigurationBuilder<XMLConfiguration> createManagedBuilder(String fileName, Map<String, Object> params) throws ConfigurationException {
            final ReloadingController ctrl = (ReloadingController)EasyMock.createMock(ReloadingController.class);
            this.reloadingControllers.add(ctrl);
            return new ReloadingFileBasedConfigurationBuilder<XMLConfiguration>(this.getResultClass(), params){

                public ReloadingController getReloadingController() {
                    return ctrl;
                }
            };
        }

        public List<ReloadingController> getReloadingControllers() {
            return this.reloadingControllers;
        }
    }
}

