/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.convert;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.configuration2.convert.DefaultConversionHandler;
import org.apache.commons.configuration2.ex.ConversionException;
import org.apache.commons.configuration2.interpol.ConfigurationInterpolator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestDefaultConversionHandler {
    private static final String VAR = "${test}";
    private static final String REPLACEMENT = "1";
    private DefaultConversionHandler handler;

    private static ConfigurationInterpolator createInterpolator() {
        return new ConfigurationInterpolator(){

            public Object interpolate(Object value) {
                if (TestDefaultConversionHandler.VAR.equals(value)) {
                    return TestDefaultConversionHandler.REPLACEMENT;
                }
                return value;
            }
        };
    }

    private void checkSingleValue(Integer expResult) {
        Assert.assertEquals((String)"Wrong result", (long)Integer.parseInt(REPLACEMENT), (long)expResult.intValue());
    }

    @Before
    public void setUp() throws Exception {
        this.handler = new DefaultConversionHandler();
    }

    @Test
    public void testGetDateFormatNotSet() {
        Assert.assertEquals((String)"Wrong date format", (Object)"yyyy-MM-dd HH:mm:ss", (Object)this.handler.getDateFormat());
    }

    @Test
    public void testSetDateFormat() {
        String dateFormat = "dd.MM.yyyy";
        this.handler.setDateFormat("dd.MM.yyyy");
        Assert.assertEquals((String)"Date format not changed", (Object)"dd.MM.yyyy", (Object)this.handler.getDateFormat());
    }

    @Test
    public void testToArrayEmptyString() {
        int[] array = (int[])this.handler.toArray((Object)"", Integer.TYPE, null);
        Assert.assertEquals((String)"Got elements", (long)0L, (long)array.length);
    }

    @Test
    public void testToArrayNullInput() {
        Assert.assertNull((String)"Wrong result", (Object)this.handler.toArray(null, Integer.class, null));
    }

    @Test
    public void testToArrayObject() {
        List<String> src = Arrays.asList(VAR, "100");
        Integer[] array = (Integer[])this.handler.toArray(src, Integer.class, TestDefaultConversionHandler.createInterpolator());
        Assert.assertEquals((String)"Wrong number of elements", (long)src.size(), (long)array.length);
        Assert.assertEquals((String)"Wrong element (1)", (Object)Integer.valueOf(REPLACEMENT), (Object)array[0]);
        Assert.assertEquals((String)"Wrong element (2)", (Object)Integer.valueOf(src.get(1)), (Object)array[1]);
    }

    @Test
    public void testToArrayPrimitiveOtherType() {
        List<String> src = Arrays.asList(VAR, "100");
        int[] array = (int[])this.handler.toArray(src, Integer.TYPE, TestDefaultConversionHandler.createInterpolator());
        Assert.assertEquals((String)"Wrong element (1)", (long)Integer.parseInt(REPLACEMENT), (long)array[0]);
        Assert.assertEquals((String)"Wrong element (2)", (long)Integer.parseInt(src.get(1)), (long)array[1]);
    }

    @Test
    public void testToArrayPrimitiveSameType() {
        int[] src = new int[]{1, 2, 3, 4, 5, 6};
        int[] array = (int[])this.handler.toArray((Object)src, Integer.TYPE, TestDefaultConversionHandler.createInterpolator());
        Assert.assertArrayEquals((String)"Wrong array result", (int[])src, (int[])array);
    }

    @Test
    public void testToArrayPrimitiveWrapperType() {
        Integer[] src = new Integer[]{0, 1, 2, 4, 8, 16, 32, 64, 128};
        int[] array = (int[])this.handler.toArray((Object)src, Integer.TYPE, TestDefaultConversionHandler.createInterpolator());
        Assert.assertEquals((String)"Wrong array length", (long)src.length, (long)array.length);
        for (int i = 0; i < src.length; ++i) {
            Assert.assertEquals((String)("Wrong element at " + i), (long)src[i].intValue(), (long)array[i]);
        }
    }

    @Test
    public void testToCalendarWithDefaultFormat() {
        Calendar cal = (Calendar)this.handler.to((Object)"2013-08-19 21:17:22", Calendar.class, null);
        Assert.assertEquals((String)"Wrong day", (long)19L, (long)cal.get(5));
        Assert.assertEquals((String)"Wrong month", (long)7L, (long)cal.get(2));
        Assert.assertEquals((String)"Wrong year", (long)2013L, (long)cal.get(1));
        Assert.assertEquals((String)"Wrong hour", (long)21L, (long)cal.get(11));
        Assert.assertEquals((String)"Wrong minute", (long)17L, (long)cal.get(12));
        Assert.assertEquals((String)"Wrong second", (long)22L, (long)cal.get(13));
    }

    @Test
    public void testToCollectionEmptyString() {
        ArrayList col = new ArrayList(1);
        this.handler.toCollection((Object)"", Integer.class, null, col);
        Assert.assertTrue((String)"Got elements", (boolean)col.isEmpty());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testToCollectionNullCollection() {
        this.handler.toCollection(Arrays.asList(1, 2, 3), Integer.class, null, null);
    }

    @Test
    public void testToCollectionNullInput() {
        ArrayList col = new ArrayList();
        this.handler.toCollection(null, Integer.class, null, col);
        Assert.assertTrue((String)"Got elements", (boolean)col.isEmpty());
    }

    @Test
    public void testToCollectionSuccess() {
        Object[] src = new Object[]{VAR, "100"};
        ArrayList col = new ArrayList(src.length);
        this.handler.toCollection((Object)src, Integer.class, TestDefaultConversionHandler.createInterpolator(), col);
        Assert.assertEquals((String)"Wrong number of elements", (long)src.length, (long)col.size());
        Assert.assertEquals((String)"Wrong element (1)", (long)Integer.parseInt(REPLACEMENT), (long)((Integer)col.get(0)).intValue());
        Assert.assertEquals((String)"Wrong element (2)", (long)Integer.parseInt(src[1].toString()), (long)((Integer)col.get(1)).intValue());
    }

    @Test
    public void testToDateWithFormat() {
        this.handler.setDateFormat("dd.MM.yyyy");
        Date dt = (Date)this.handler.to((Object)"19.08.2013", Date.class, null);
        Calendar cal = Calendar.getInstance();
        cal.setTime(dt);
        Assert.assertEquals((String)"Wrong day", (long)19L, (long)cal.get(5));
        Assert.assertEquals((String)"Wrong month", (long)7L, (long)cal.get(2));
        Assert.assertEquals((String)"Wrong year", (long)2013L, (long)cal.get(1));
    }

    @Test(expected=ConversionException.class)
    public void testToFailedConversion() {
        this.handler.to((Object)VAR, Integer.class, null);
    }

    @Test
    public void testToFromArray() {
        Object[] src = new Object[]{VAR, true, 20130808221759L};
        this.checkSingleValue((Integer)this.handler.to((Object)src, Integer.class, TestDefaultConversionHandler.createInterpolator()));
    }

    @Test
    public void testToFromCollection() {
        List<String> src = Arrays.asList(VAR, "true", "1000");
        this.checkSingleValue((Integer)this.handler.to(src, Integer.class, TestDefaultConversionHandler.createInterpolator()));
    }

    @Test
    public void testToFromEmptyCollection() {
        Assert.assertNull((String)"Wrong result", (Object)this.handler.to(new ArrayList(), Integer.class, TestDefaultConversionHandler.createInterpolator()));
    }

    @Test
    public void testToFromIterator() {
        Iterator<String> src = Arrays.asList(VAR, "true", "1000").iterator();
        this.checkSingleValue((Integer)this.handler.to(src, Integer.class, TestDefaultConversionHandler.createInterpolator()));
    }

    @Test
    public void testToNoInterpolator() {
        Integer result = (Integer)this.handler.to((Object)REPLACEMENT, Integer.class, null);
        this.checkSingleValue(result);
    }

    @Test
    public void testToNull() {
        Assert.assertNull((String)"Wrong result", (Object)this.handler.to(null, Integer.class, null));
    }

    @Test
    public void testToPrimitive() {
        Long value = 20130819214935L;
        Object result = this.handler.to((Object)value.toString(), Long.TYPE, null);
        Assert.assertEquals((String)"Wrong conversion result", (Object)value, (Object)result);
    }

    @Test
    public void testToWithInterpolator() {
        Integer result = (Integer)this.handler.to((Object)VAR, Integer.class, TestDefaultConversionHandler.createInterpolator());
        this.checkSingleValue(result);
    }
}

