/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.event;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.configuration2.AbstractConfiguration;
import org.apache.commons.configuration2.BaseHierarchicalConfiguration;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.event.AbstractTestConfigurationEvents;
import org.apache.commons.configuration2.event.ConfigurationEvent;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.configuration2.tree.NodeHandler;
import org.apache.commons.configuration2.tree.NodeStructureHelper;
import org.junit.Assert;
import org.junit.Test;

public class TestHierarchicalConfigurationEvents
extends AbstractTestConfigurationEvents {
    private void checkSubnodeEvent(ConfigurationEvent event, boolean before) {
        Assert.assertEquals((String)"Wrong before flag of nesting event", (Object)before, (Object)event.isBeforeUpdate());
        Assert.assertTrue((String)"No subnode event found in value", (boolean)(event.getPropertyValue() instanceof ConfigurationEvent));
        ConfigurationEvent evSub = (ConfigurationEvent)event.getPropertyValue();
        Assert.assertEquals((String)"Wrong event type", (Object)ConfigurationEvent.ADD_PROPERTY, (Object)evSub.getEventType());
        Assert.assertEquals((String)"Wrong property name", (Object)"newProp", (Object)evSub.getPropertyName());
        Assert.assertEquals((String)"Wrong property value", (Object)"newValue", (Object)evSub.getPropertyValue());
        Assert.assertEquals((String)"Wrong before flag", (Object)before, (Object)evSub.isBeforeUpdate());
    }

    @Override
    protected AbstractConfiguration createConfiguration() {
        return new BaseHierarchicalConfiguration();
    }

    @Test
    public void testAddNodesEmptyEvent() {
        ((BaseHierarchicalConfiguration)this.config).addNodes("event.test", new ArrayList());
        this.listener.done();
    }

    @Test
    public void testAddNodesEvent() {
        BaseHierarchicalConfiguration hc = (BaseHierarchicalConfiguration)this.config;
        ArrayList<ImmutableNode> nodes = new ArrayList<ImmutableNode>(1);
        nodes.add(NodeStructureHelper.createNode("a_key", "a value"));
        hc.addNodes("event.test", nodes);
        this.listener.checkEvent(ConfigurationEvent.ADD_NODES, "event.test", nodes, true);
        this.listener.checkEvent(ConfigurationEvent.ADD_NODES, "event.test", nodes, false);
        this.listener.done();
    }

    @Test
    public void testClearTreeEvent() {
        BaseHierarchicalConfiguration hc = (BaseHierarchicalConfiguration)this.config;
        String key = "event.property".substring(0, "event.property".indexOf(46));
        NodeHandler nodeHandler = hc.getNodeModel().getNodeHandler();
        List nodes = hc.getExpressionEngine().query(nodeHandler.getRootNode(), key, nodeHandler);
        hc.clearTree(key);
        this.listener.checkEvent(ConfigurationEvent.CLEAR_TREE, key, null, true);
        this.listener.checkEvent(ConfigurationEvent.CLEAR_TREE, key, nodes, false);
        this.listener.done();
    }

    @Test
    public void testSubConfigurationChangedEventConnected() {
        HierarchicalConfiguration sub = ((BaseHierarchicalConfiguration)this.config).configurationAt("event.property", true);
        sub.addProperty("newProp", (Object)"newValue");
        this.checkSubnodeEvent((ConfigurationEvent)this.listener.nextEvent(ConfigurationEvent.SUBNODE_CHANGED), true);
        this.checkSubnodeEvent((ConfigurationEvent)this.listener.nextEvent(ConfigurationEvent.SUBNODE_CHANGED), false);
        this.listener.done();
    }

    @Test
    public void testSubConfigurationChangedEventNotConnected() {
        HierarchicalConfiguration sub = ((BaseHierarchicalConfiguration)this.config).configurationAt("event.property");
        sub.addProperty("newProp", (Object)"newValue");
        this.listener.done();
    }
}

