/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.io;

import java.io.File;
import java.net.URL;
import org.apache.commons.configuration2.ConfigurationAssert;
import org.apache.commons.configuration2.io.BasePathLocationStrategy;
import org.apache.commons.configuration2.io.FileLocator;
import org.apache.commons.configuration2.io.FileLocatorUtils;
import org.apache.commons.configuration2.io.FileSystem;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestBasePathLocationStrategy {
    private static final String TEST_FILE = "test.xml";
    private FileSystem fileSystem;
    private BasePathLocationStrategy strategy;

    private static void checkURL(URL url) {
        Assert.assertEquals((String)"Wrong URL", (Object)FileLocatorUtils.fileFromURL((URL)url).getAbsoluteFile(), (Object)ConfigurationAssert.getTestFile(TEST_FILE).getAbsoluteFile());
    }

    @Before
    public void setUp() throws Exception {
        this.fileSystem = (FileSystem)EasyMock.createMock(FileSystem.class);
        EasyMock.replay((Object[])new Object[]{this.fileSystem});
        this.strategy = new BasePathLocationStrategy();
    }

    @Test
    public void testLocateSuccess() {
        File path = ConfigurationAssert.TEST_DIR;
        FileLocator locator = FileLocatorUtils.fileLocator().basePath(path.getAbsolutePath()).fileName(TEST_FILE).create();
        TestBasePathLocationStrategy.checkURL(this.strategy.locate(this.fileSystem, locator));
    }

    @Test
    public void testLocateSuccessRelativePrefix() {
        File path = ConfigurationAssert.TEST_DIR;
        FileLocator locator = FileLocatorUtils.fileLocator().basePath(path.getAbsolutePath()).fileName("." + File.separator + TEST_FILE).create();
        TestBasePathLocationStrategy.checkURL(this.strategy.locate(this.fileSystem, locator));
    }

    @Test
    public void testNullBasePath() {
        FileLocator locator = FileLocatorUtils.fileLocator().fileName(TEST_FILE).create();
        Assert.assertNull((String)"Got a URL", (Object)this.strategy.locate(this.fileSystem, locator));
    }

    @Test
    public void testNullFileName() {
        FileLocator locator = FileLocatorUtils.fileLocator().basePath(ConfigurationAssert.getTestFile(TEST_FILE).getAbsolutePath()).create();
        Assert.assertNull((String)"Got a URL", (Object)this.strategy.locate(this.fileSystem, locator));
    }
}

