/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.io;

import java.net.URL;
import org.apache.commons.configuration2.ConfigurationAssert;
import org.apache.commons.configuration2.io.FileLocationStrategy;
import org.apache.commons.configuration2.io.FileLocator;
import org.apache.commons.configuration2.io.FileLocatorUtils;
import org.apache.commons.configuration2.io.FileSystem;
import org.easymock.EasyMock;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestFileLocator {
    private static final String FILE_NAME = "test.xml";
    private static final String BASE_PATH = "/etc/test/path/";
    private static final String ENCODING = "utf-8";
    private static URL sourceURL;
    private static FileSystem fileSystem;
    private static FileLocationStrategy locationStrategy;

    private static void checkLocator(FileLocator locator) {
        Assert.assertEquals((String)"Wrong base path", (Object)BASE_PATH, (Object)locator.getBasePath());
        Assert.assertEquals((String)"Wrong file name", (Object)FILE_NAME, (Object)locator.getFileName());
        Assert.assertEquals((String)"Wrong encoding", (Object)ENCODING, (Object)locator.getEncoding());
        Assert.assertEquals((String)"Wrong URL", (Object)sourceURL.toExternalForm(), (Object)locator.getSourceURL().toExternalForm());
        Assert.assertSame((String)"Wrong file system", (Object)fileSystem, (Object)locator.getFileSystem());
        Assert.assertSame((String)"Wrong location strategy", (Object)locationStrategy, (Object)locator.getLocationStrategy());
    }

    @BeforeClass
    public static void setUpOnce() throws Exception {
        sourceURL = ConfigurationAssert.getTestURL(FILE_NAME);
        fileSystem = (FileSystem)EasyMock.createMock(FileSystem.class);
        locationStrategy = (FileLocationStrategy)EasyMock.createMock(FileLocationStrategy.class);
        EasyMock.replay((Object[])new Object[]{fileSystem, locationStrategy});
    }

    @Test
    public void testCreateFileLocator() {
        FileLocator locator = FileLocatorUtils.fileLocator().basePath(BASE_PATH).fileName(FILE_NAME).encoding(ENCODING).fileSystem(fileSystem).sourceURL(sourceURL).locationStrategy(locationStrategy).create();
        TestFileLocator.checkLocator(locator);
    }

    @Test
    public void testCreateFileLocatorFromSource() {
        FileLocator locatorSrc = FileLocatorUtils.fileLocator().basePath(BASE_PATH).fileName("someFile").encoding(ENCODING).fileSystem(fileSystem).sourceURL(sourceURL).locationStrategy(locationStrategy).create();
        FileLocator locator = FileLocatorUtils.fileLocator((FileLocator)locatorSrc).fileName(FILE_NAME).create();
        TestFileLocator.checkLocator(locator);
    }

    @Test
    public void testCreateFileLocatorUndefined() {
        FileLocator locator = FileLocatorUtils.fileLocator().create();
        Assert.assertNull((String)"Got a base path", (Object)locator.getBasePath());
        Assert.assertNull((String)"Got a file name", (Object)locator.getFileName());
        Assert.assertNull((String)"Got a URL", (Object)locator.getSourceURL());
        Assert.assertNull((String)"Got an encoding", (Object)locator.getEncoding());
        Assert.assertNull((String)"Got a file system", (Object)locator.getFileSystem());
        Assert.assertNull((String)"Got a location strategy", (Object)locator.getLocationStrategy());
    }

    @Test
    public void testFileLocatorEqualsFalse() {
        FileLocator loc1 = FileLocatorUtils.fileLocator().basePath(BASE_PATH).fileName(FILE_NAME).encoding(ENCODING).fileSystem(fileSystem).sourceURL(sourceURL).locationStrategy(locationStrategy).create();
        FileLocator loc2 = FileLocatorUtils.fileLocator((FileLocator)loc1).basePath("/etc/test/path/_other").create();
        ConfigurationAssert.checkEquals(loc1, loc2, false);
        loc2 = FileLocatorUtils.fileLocator((FileLocator)loc1).fileName("test.xml_other").create();
        ConfigurationAssert.checkEquals(loc1, loc2, false);
        loc2 = FileLocatorUtils.fileLocator((FileLocator)loc1).encoding("utf-8_other").create();
        ConfigurationAssert.checkEquals(loc1, loc2, false);
        loc2 = FileLocatorUtils.fileLocator((FileLocator)loc1).fileSystem((FileSystem)EasyMock.createMock(FileSystem.class)).create();
        ConfigurationAssert.checkEquals(loc1, loc2, false);
        loc2 = FileLocatorUtils.fileLocator((FileLocator)loc1).sourceURL(ConfigurationAssert.getTestURL("test.properties")).create();
        ConfigurationAssert.checkEquals(loc1, loc2, false);
        loc2 = FileLocatorUtils.fileLocator((FileLocator)loc1).locationStrategy((FileLocationStrategy)EasyMock.createMock(FileLocationStrategy.class)).create();
        ConfigurationAssert.checkEquals(loc1, loc2, false);
    }

    @Test
    public void testFileLocatorEqualsNull() {
        FileLocator loc = FileLocatorUtils.fileLocator().fileName(FILE_NAME).create();
        Assert.assertNotEquals((String)"Wrong result", null, (Object)loc);
    }

    @Test
    public void testFileLocatorEqualsOtherClass() {
        FileLocator loc = FileLocatorUtils.fileLocator().fileName(FILE_NAME).create();
        Assert.assertNotEquals((String)"Wrong result", (Object)loc, (Object)this);
    }

    @Test
    public void testFileLocatorEqualsTrue() {
        FileLocator loc1 = FileLocatorUtils.fileLocator().create();
        ConfigurationAssert.checkEquals(loc1, loc1, true);
        FileLocator loc2 = FileLocatorUtils.fileLocator().create();
        ConfigurationAssert.checkEquals(loc1, loc2, true);
        loc1 = FileLocatorUtils.fileLocator().basePath(BASE_PATH).fileName(FILE_NAME).encoding(ENCODING).fileSystem(fileSystem).sourceURL(sourceURL).locationStrategy(locationStrategy).create();
        loc2 = FileLocatorUtils.fileLocator().basePath(BASE_PATH).fileName(FILE_NAME).encoding(ENCODING).fileSystem(fileSystem).sourceURL(sourceURL).locationStrategy(locationStrategy).create();
        ConfigurationAssert.checkEquals(loc1, loc2, true);
    }

    @Test
    public void testFileLocatorToString() {
        FileLocator loc = FileLocatorUtils.fileLocator().basePath(BASE_PATH).fileName(FILE_NAME).encoding(ENCODING).fileSystem(fileSystem).sourceURL(sourceURL).locationStrategy(locationStrategy).create();
        String s = loc.toString();
        Assert.assertThat((Object)s, (Matcher)CoreMatchers.containsString((String)"fileName=test.xml"));
        Assert.assertThat((Object)s, (Matcher)CoreMatchers.containsString((String)"basePath=/etc/test/path/"));
        Assert.assertThat((Object)s, (Matcher)CoreMatchers.containsString((String)("sourceURL=" + sourceURL)));
        Assert.assertThat((Object)s, (Matcher)CoreMatchers.containsString((String)"encoding=utf-8"));
        Assert.assertThat((Object)s, (Matcher)CoreMatchers.containsString((String)("fileSystem=" + fileSystem)));
        Assert.assertThat((Object)s, (Matcher)CoreMatchers.containsString((String)("locationStrategy=" + locationStrategy)));
    }
}

