/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.io;

import java.net.URL;
import org.apache.commons.configuration2.ConfigurationAssert;
import org.apache.commons.configuration2.io.FileLocator;
import org.apache.commons.configuration2.io.FileLocatorUtils;
import org.apache.commons.configuration2.io.FileSystem;
import org.apache.commons.configuration2.io.ProvidedURLLocationStrategy;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestProvidedURLLocationStrategy {
    private ProvidedURLLocationStrategy strategy;

    @Before
    public void setUp() throws Exception {
        this.strategy = new ProvidedURLLocationStrategy();
    }

    @Test
    public void testLocateFail() {
        FileSystem fs = (FileSystem)EasyMock.createMock(FileSystem.class);
        EasyMock.replay((Object[])new Object[]{fs});
        FileLocator locator = FileLocatorUtils.fileLocator().basePath("somePath").fileName("someFile.xml").create();
        Assert.assertNull((String)"Got a URL", (Object)this.strategy.locate(fs, locator));
    }

    @Test
    public void testLocateSuccess() {
        FileSystem fs = (FileSystem)EasyMock.createMock(FileSystem.class);
        EasyMock.replay((Object[])new Object[]{fs});
        URL url = ConfigurationAssert.getTestURL("test.xml");
        FileLocator locator = FileLocatorUtils.fileLocator().sourceURL(url).create();
        Assert.assertSame((String)"Wrong URL", (Object)url, (Object)this.strategy.locate(fs, locator));
    }
}

