/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.reloading;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.configuration2.reloading.PeriodicReloadingTrigger;
import org.apache.commons.configuration2.reloading.ReloadingController;
import org.apache.commons.lang3.mutable.MutableObject;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestPeriodicReloadingTrigger {
    private static final Object CTRL_PARAM = "Test controller parameter";
    private static final long PERIOD = 60L;
    private static final TimeUnit UNIT = TimeUnit.SECONDS;
    private ScheduledExecutorService executor;
    private ReloadingController controller;

    private static ScheduledFuture<Void> createFutureMock() {
        return (ScheduledFuture)EasyMock.createMock(ScheduledFuture.class);
    }

    private PeriodicReloadingTrigger createTrigger() {
        return new PeriodicReloadingTrigger(this.controller, CTRL_PARAM, 60L, UNIT, this.executor);
    }

    private void expectSchedule(ScheduledFuture<Void> future) {
        this.executor.scheduleAtFixedRate((Runnable)EasyMock.anyObject(Runnable.class), EasyMock.eq((long)60L), EasyMock.eq((long)60L), (TimeUnit)((Object)EasyMock.eq((Object)((Object)UNIT))));
        if (future != null) {
            EasyMock.expectLastCall().andReturn(future);
        }
    }

    @Before
    public void setUp() throws Exception {
        this.executor = (ScheduledExecutorService)EasyMock.createMock(ScheduledExecutorService.class);
        this.controller = (ReloadingController)EasyMock.createMock(ReloadingController.class);
    }

    @Test
    public void testDefaultExecutor() {
        PeriodicReloadingTrigger trigger = new PeriodicReloadingTrigger(this.controller, CTRL_PARAM, 60L, UNIT);
        Assert.assertNotNull((String)"No executor service", (Object)trigger.getExecutorService());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInitNoController() {
        new PeriodicReloadingTrigger(null, CTRL_PARAM, 60L, UNIT);
    }

    @Test
    public void testIsRunningAfterInit() {
        Assert.assertFalse((String)"Running", (boolean)this.createTrigger().isRunning());
    }

    @Test
    public void testShutdown() {
        ScheduledFuture<Void> future = TestPeriodicReloadingTrigger.createFutureMock();
        this.expectSchedule(future);
        EasyMock.expect((Object)future.cancel(false)).andReturn((Object)Boolean.TRUE);
        this.executor.shutdown();
        EasyMock.replay((Object[])new Object[]{future, this.controller, this.executor});
        PeriodicReloadingTrigger trigger = this.createTrigger();
        trigger.start();
        trigger.shutdown();
        EasyMock.verify((Object[])new Object[]{future, this.controller, this.executor});
    }

    @Test
    public void testShutdownNoExecutor() {
        EasyMock.replay((Object[])new Object[]{this.controller, this.executor});
        this.createTrigger().shutdown(false);
    }

    @Test
    public void testStart() {
        ScheduledFuture<Void> future = TestPeriodicReloadingTrigger.createFutureMock();
        MutableObject refTask = new MutableObject();
        this.expectSchedule(null);
        EasyMock.expectLastCall().andAnswer(() -> {
            refTask.setValue((Object)((Runnable)EasyMock.getCurrentArguments()[0]));
            return future;
        });
        EasyMock.expect((Object)this.controller.checkForReloading(CTRL_PARAM)).andReturn((Object)Boolean.FALSE);
        EasyMock.replay((Object[])new Object[]{future, this.controller, this.executor});
        PeriodicReloadingTrigger trigger = this.createTrigger();
        trigger.start();
        Assert.assertTrue((String)"Not started", (boolean)trigger.isRunning());
        ((Runnable)refTask.getValue()).run();
        EasyMock.verify((Object[])new Object[]{future, this.controller, this.executor});
    }

    @Test
    public void testStartTwice() {
        ScheduledFuture<Void> future = TestPeriodicReloadingTrigger.createFutureMock();
        this.expectSchedule(future);
        EasyMock.replay((Object[])new Object[]{future, this.controller, this.executor});
        PeriodicReloadingTrigger trigger = this.createTrigger();
        trigger.start();
        trigger.start();
        EasyMock.verify((Object[])new Object[]{future, this.controller, this.executor});
    }

    @Test
    public void testStop() {
        ScheduledFuture<Void> future = TestPeriodicReloadingTrigger.createFutureMock();
        this.expectSchedule(future);
        EasyMock.expect((Object)future.cancel(false)).andReturn((Object)Boolean.TRUE);
        EasyMock.replay((Object[])new Object[]{future, this.controller, this.executor});
        PeriodicReloadingTrigger trigger = this.createTrigger();
        trigger.start();
        trigger.stop();
        Assert.assertFalse((String)"Still running", (boolean)trigger.isRunning());
        EasyMock.verify((Object[])new Object[]{future, this.controller, this.executor});
    }

    @Test
    public void testStopNotRunning() {
        EasyMock.replay((Object[])new Object[]{this.controller, this.executor});
        this.createTrigger().stop();
    }
}

