/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.spring;

import java.io.Reader;
import java.io.StringReader;
import java.util.Properties;
import org.apache.commons.configuration2.BaseConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.PropertiesConfigurationLayout;
import org.apache.commons.configuration2.XMLConfiguration;
import org.apache.commons.configuration2.spring.ConfigurationPropertiesFactoryBean;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class TestConfigurationPropertiesFactoryBean {
    private ConfigurationPropertiesFactoryBean configurationFactory;

    @Before
    public void setUp() {
        this.configurationFactory = new ConfigurationPropertiesFactoryBean();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAfterPropertiesSet() throws Exception {
        this.configurationFactory.afterPropertiesSet();
    }

    @Test
    public void testGetConfigurationDefensiveCopy() {
        Object[] configs = new Configuration[]{new PropertiesConfiguration(), new XMLConfiguration()};
        this.configurationFactory.setConfigurations((Configuration[])configs);
        Configuration[] configsGet = this.configurationFactory.getConfigurations();
        configsGet[0] = null;
        Assert.assertArrayEquals((String)"Configurations were changed", (Object[])configs, (Object[])this.configurationFactory.getConfigurations());
    }

    @Test
    public void testGetLocationsDefensiveCopy() {
        Object[] locations = new Resource[]{new ClassPathResource("f1"), new ClassPathResource("f2")};
        this.configurationFactory.setLocations((Resource[])locations);
        Resource[] locationsGet = this.configurationFactory.getLocations();
        locationsGet[1] = null;
        Assert.assertArrayEquals((String)"Locations were changed", (Object[])locations, (Object[])this.configurationFactory.getLocations());
    }

    @Test
    public void testGetObject() throws Exception {
        this.configurationFactory.setConfigurations(new Configuration[]{new BaseConfiguration()});
        Assert.assertNull((Object)this.configurationFactory.getObject());
        this.configurationFactory.afterPropertiesSet();
        Assert.assertNotNull((Object)this.configurationFactory.getObject());
    }

    @Test
    public void testInitialConfiguration() throws Exception {
        this.configurationFactory = new ConfigurationPropertiesFactoryBean((Configuration)new BaseConfiguration());
        this.configurationFactory.afterPropertiesSet();
        Assert.assertNotNull((Object)this.configurationFactory.getConfiguration());
    }

    @Test
    public void testLoadResources() throws Exception {
        this.configurationFactory.setLocations(new Resource[]{new ClassPathResource("testConfigurationFactoryBean.file")});
        this.configurationFactory.setConfigurations(new Configuration[]{new BaseConfiguration()});
        this.configurationFactory.afterPropertiesSet();
        Properties props = this.configurationFactory.getObject();
        Assert.assertEquals((Object)"duke", (Object)props.getProperty("java"));
    }

    @Test
    public void testMergeConfigurations() throws Exception {
        BaseConfiguration one = new BaseConfiguration();
        one.setProperty("foo", (Object)"bar");
        String properties = "## some header \nfoo = bar1\nbar = foo\n";
        PropertiesConfiguration two = new PropertiesConfiguration();
        PropertiesConfigurationLayout layout = new PropertiesConfigurationLayout();
        layout.load(two, (Reader)new StringReader("## some header \nfoo = bar1\nbar = foo\n"));
        this.configurationFactory.setConfigurations(new Configuration[]{one, two});
        this.configurationFactory.afterPropertiesSet();
        Properties props = this.configurationFactory.getObject();
        Assert.assertEquals((Object)"foo", (Object)props.getProperty("bar"));
        Assert.assertEquals((Object)"bar", (Object)props.getProperty("foo"));
    }

    @Test
    public void testSetConfigurationsDefensiveCopy() {
        Object[] configs = new Configuration[]{new PropertiesConfiguration(), new XMLConfiguration()};
        Configuration[] configsUpdate = (Configuration[])configs.clone();
        this.configurationFactory.setConfigurations(configsUpdate);
        configsUpdate[0] = null;
        Assert.assertArrayEquals((String)"Configurations were changed", (Object[])configs, (Object[])this.configurationFactory.getConfigurations());
    }

    @Test
    public void testSetLocationsDefensiveCopy() {
        Object[] locations = new Resource[]{new ClassPathResource("f1"), new ClassPathResource("f2")};
        Resource[] locationsUpdate = (Resource[])locations.clone();
        this.configurationFactory.setLocations(locationsUpdate);
        locationsUpdate[0] = new ClassPathResource("other");
        Assert.assertArrayEquals((String)"Locations were changed", (Object[])locations, (Object[])this.configurationFactory.getLocations());
    }

    @Test
    public void testSetLocationsNull() {
        this.configurationFactory.setLocations(null);
        Assert.assertNull((String)"Got locations", (Object)this.configurationFactory.getLocations());
    }
}

