/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.test;

import java.io.FileReader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HsqlDB {
    private static final Log log = LogFactory.getLog(HsqlDB.class);
    private final Connection connection;

    public HsqlDB(String uri, String databaseDriver, String loadFile) throws Exception {
        Class.forName(databaseDriver);
        this.connection = DriverManager.getConnection(uri, "sa", "");
        if (StringUtils.isNotEmpty((CharSequence)loadFile)) {
            this.loadSqlFile(loadFile);
        }
        this.connection.commit();
    }

    public void close() {
        try {
            this.connection.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    private String getFileContents(String fileName) throws Exception {
        try (FileReader fr = new FileReader(fileName);){
            char[] fileBuf = new char[1024];
            StringBuilder sb = new StringBuilder(1000);
            int res = -1;
            while ((res = fr.read(fileBuf, 0, 1024)) > -1) {
                sb.append(fileBuf, 0, res);
            }
            String string = sb.toString();
            return string;
        }
    }

    private void loadSqlFile(String fileName) throws Exception {
        try (Statement statement = this.connection.createStatement();){
            String commands = this.getFileContents(fileName);
            int targetPos = commands.indexOf(59);
            while (targetPos > -1) {
                String cmd = commands.substring(0, targetPos + 1);
                try {
                    statement.execute(cmd);
                }
                catch (SQLException sqle) {
                    log.warn((Object)("Statement: " + cmd + ": " + sqle.getMessage()));
                }
                commands = commands.substring(targetPos + 2);
                targetPos = commands.indexOf(59);
            }
        }
    }
}

