/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.tree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.CountDownLatch;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.configuration2.tree.InMemoryNodeModel;
import org.apache.commons.configuration2.tree.NodeAddData;
import org.apache.commons.configuration2.tree.NodeHandler;
import org.apache.commons.configuration2.tree.NodeKeyResolver;
import org.apache.commons.configuration2.tree.NodeStructureHelper;
import org.apache.commons.configuration2.tree.NodeUpdateData;
import org.apache.commons.configuration2.tree.QueryResult;
import org.apache.commons.configuration2.tree.TreeData;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public class TestInMemoryNodeModel {
    private static final String KEY = "aTestKey";

    private static void checkPathToRoot(InMemoryNodeModel model, ImmutableNode node, String ... path) {
        NodeHandler handler = model.getNodeHandler();
        for (int i = path.length - 1; i >= 0; --i) {
            node = (ImmutableNode)handler.getParent((Object)node);
            Assert.assertEquals((String)"Wrong node name", (Object)path[i], (Object)node.getNodeName());
        }
        Assert.assertSame((String)"Wrong root node", (Object)model.getRootNode(), (Object)handler.getParent((Object)node));
    }

    private static NodeKeyResolver<ImmutableNode> createResolver() {
        return (NodeKeyResolver)EasyMock.createMock(NodeKeyResolver.class);
    }

    private void checkAddNodesNoNodes(Collection<ImmutableNode> newNodes) {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModel.createResolver();
        InMemoryNodeModel model = new InMemoryNodeModel(NodeStructureHelper.ROOT_AUTHORS_TREE);
        EasyMock.replay((Object[])new Object[]{resolver});
        model.addNodes(KEY, newNodes, resolver);
        Assert.assertSame((String)"Model was changed", (Object)NodeStructureHelper.ROOT_AUTHORS_TREE, (Object)model.getRootNode());
    }

    private void checkClearTreeUpdatedParentMapping(String pathToRemove, ImmutableNode nodeToCheck) {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModel.createResolver();
        InMemoryNodeModel model = new InMemoryNodeModel(NodeStructureHelper.ROOT_AUTHORS_TREE);
        QueryResult result = QueryResult.createNodeResult((Object)NodeStructureHelper.nodeForKey(model, pathToRemove));
        EasyMock.expect((Object)resolver.resolveKey((Object)NodeStructureHelper.ROOT_AUTHORS_TREE, KEY, model.getNodeHandler())).andReturn(Collections.singletonList(result));
        EasyMock.replay((Object[])new Object[]{resolver});
        model.clearTree(KEY, resolver);
        try {
            model.getNodeHandler().getParent((Object)nodeToCheck);
            Assert.fail((String)"Removed node still in parent mapping!");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testAddNodesEmptyCollection() {
        this.checkAddNodesNoNodes(Collections.emptySet());
    }

    @Test
    public void testAddNodesNullCollection() {
        this.checkAddNodesNoNodes(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddNodesToAttribute() {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModel.createResolver();
        InMemoryNodeModel model = new InMemoryNodeModel(NodeStructureHelper.ROOT_AUTHORS_TREE);
        EasyMock.expect((Object)resolver.resolveKey((Object)NodeStructureHelper.ROOT_AUTHORS_TREE, KEY, model.getNodeHandler())).andReturn(Collections.singletonList(QueryResult.createAttributeResult((Object)NodeStructureHelper.nodeForKey(model, NodeStructureHelper.author(1)), (String)"test")));
        EasyMock.replay((Object[])new Object[]{resolver});
        ImmutableNode newNode = new ImmutableNode.Builder().name("newNode").create();
        model.addNodes(KEY, Collections.singleton(newNode), resolver);
    }

    @Test
    public void testAddNodesToExistingNode() {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModel.createResolver();
        InMemoryNodeModel model = new InMemoryNodeModel(NodeStructureHelper.ROOT_AUTHORS_TREE);
        String key = NodeStructureHelper.author(0);
        ImmutableNode newWork1 = new ImmutableNode.Builder().name("King Lear").create();
        ImmutableNode newWork2 = new ImmutableNode.Builder().name("The Taming of the Shrew").create();
        EasyMock.expect((Object)resolver.resolveKey((Object)NodeStructureHelper.ROOT_AUTHORS_TREE, KEY, model.getNodeHandler())).andReturn(Collections.singletonList(QueryResult.createNodeResult((Object)NodeStructureHelper.nodeForKey(model, key))));
        EasyMock.replay((Object[])new Object[]{resolver});
        model.addNodes(KEY, Arrays.asList(newWork1, newWork2), resolver);
        ImmutableNode node = NodeStructureHelper.nodeForKey(model, key);
        int size = node.getChildren().size();
        Assert.assertSame((String)"New child 1 not added", (Object)newWork1, node.getChildren().get(size - 2));
        Assert.assertSame((String)"New child 2 not added", (Object)newWork2, node.getChildren().get(size - 1));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddNodesToNewAttributeKey() {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModel.createResolver();
        InMemoryNodeModel model = new InMemoryNodeModel(NodeStructureHelper.ROOT_AUTHORS_TREE);
        EasyMock.expect((Object)resolver.resolveKey((Object)NodeStructureHelper.ROOT_AUTHORS_TREE, KEY, model.getNodeHandler())).andReturn(Collections.emptyList());
        EasyMock.expect((Object)resolver.resolveAddKey((Object)NodeStructureHelper.ROOT_AUTHORS_TREE, KEY, model.getNodeHandler())).andReturn((Object)new NodeAddData((Object)NodeStructureHelper.ROOT_AUTHORS_TREE, "test", true, null));
        EasyMock.replay((Object[])new Object[]{resolver});
        ImmutableNode newNode = new ImmutableNode.Builder().name("newNode").create();
        model.addNodes(KEY, Collections.singleton(newNode), resolver);
    }

    @Test
    public void testAddNodesToNewNode() {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModel.createResolver();
        InMemoryNodeModel model = new InMemoryNodeModel(NodeStructureHelper.ROOT_AUTHORS_TREE);
        String newAuthor = "Goethe";
        String newWork = "Faust";
        String newPersona = "Mephisto";
        EasyMock.expect((Object)resolver.resolveKey((Object)NodeStructureHelper.ROOT_AUTHORS_TREE, KEY, model.getNodeHandler())).andReturn(new ArrayList(0));
        EasyMock.expect((Object)resolver.resolveAddKey((Object)NodeStructureHelper.ROOT_AUTHORS_TREE, KEY, model.getNodeHandler())).andReturn((Object)new NodeAddData((Object)NodeStructureHelper.ROOT_AUTHORS_TREE, "Faust", false, Arrays.asList("Goethe")));
        EasyMock.replay((Object[])new Object[]{resolver});
        ImmutableNode personaNode = new ImmutableNode.Builder().name("Mephisto").create();
        model.addNodes(KEY, Collections.singleton(personaNode), resolver);
        Assert.assertSame((String)"Wrong added node", (Object)personaNode, (Object)NodeStructureHelper.nodeForKey(model, "Goethe/Faust/Mephisto"));
    }

    @Test
    public void testAddPropertyAttributeNoPathNodes() {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModel.createResolver();
        NodeAddData addData = new NodeAddData((Object)NodeStructureHelper.nodeForKey(NodeStructureHelper.ROOT_AUTHORS_TREE, "Shakespeare/The Tempest"), "year", true, null);
        InMemoryNodeModel model = new InMemoryNodeModel(NodeStructureHelper.ROOT_AUTHORS_TREE);
        EasyMock.expect((Object)resolver.resolveAddKey((Object)NodeStructureHelper.ROOT_AUTHORS_TREE, KEY, model.getNodeHandler())).andReturn((Object)addData);
        EasyMock.replay((Object[])new Object[]{resolver});
        model.addProperty(KEY, Collections.singleton(1611), resolver);
        ImmutableNode node = NodeStructureHelper.nodeForKey(model, "Shakespeare/The Tempest");
        Assert.assertEquals((String)"Attribute not set", (Object)1611, node.getAttributes().get("year"));
    }

    @Test
    public void testAddPropertyAttributeWithPathNodes() {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModel.createResolver();
        NodeAddData addData = new NodeAddData((Object)NodeStructureHelper.nodeForKey(NodeStructureHelper.ROOT_AUTHORS_TREE, "Homer/Ilias"), "number", true, Arrays.asList("scenes", "scene"));
        InMemoryNodeModel model = new InMemoryNodeModel(NodeStructureHelper.ROOT_AUTHORS_TREE);
        EasyMock.expect((Object)resolver.resolveAddKey((Object)NodeStructureHelper.ROOT_AUTHORS_TREE, KEY, model.getNodeHandler())).andReturn((Object)addData);
        EasyMock.replay((Object[])new Object[]{resolver});
        model.addProperty(KEY, Collections.singleton(1), resolver);
        ImmutableNode node = NodeStructureHelper.nodeForKey(model, "Homer/Ilias/scenes/scene");
        Assert.assertEquals((String)"Attribute not set", (Object)1, node.getAttributes().get("number"));
    }

    @Test
    public void testAddPropertyAttributeWithSinglePathNode() {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModel.createResolver();
        NodeAddData addData = new NodeAddData((Object)NodeStructureHelper.nodeForKey(NodeStructureHelper.ROOT_AUTHORS_TREE, NodeStructureHelper.author(0)), "year", true, Arrays.asList("dateOfBirth"));
        InMemoryNodeModel model = new InMemoryNodeModel(NodeStructureHelper.ROOT_AUTHORS_TREE);
        EasyMock.expect((Object)resolver.resolveAddKey((Object)NodeStructureHelper.ROOT_AUTHORS_TREE, KEY, model.getNodeHandler())).andReturn((Object)addData);
        EasyMock.replay((Object[])new Object[]{resolver});
        Integer year = 1564;
        model.addProperty(KEY, Collections.singleton(year), resolver);
        ImmutableNode node = NodeStructureHelper.nodeForKey(model, "Shakespeare/dateOfBirth");
        Assert.assertEquals((String)"Attribute not set", (Object)year, node.getAttributes().get("year"));
    }

    @Test
    public void testAddPropertyNoPathNodes() {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModel.createResolver();
        NodeAddData addData = new NodeAddData((Object)NodeStructureHelper.nodeForKey(NodeStructureHelper.ROOT_AUTHORS_TREE, "Homer"), "work", false, null);
        InMemoryNodeModel model = new InMemoryNodeModel(NodeStructureHelper.ROOT_AUTHORS_TREE);
        EasyMock.expect((Object)resolver.resolveAddKey((Object)NodeStructureHelper.ROOT_AUTHORS_TREE, KEY, model.getNodeHandler())).andReturn((Object)addData);
        EasyMock.replay((Object[])new Object[]{resolver});
        model.addProperty(KEY, Collections.singleton("Odyssee"), resolver);
        ImmutableNode node = NodeStructureHelper.nodeForKey(model, "Homer/work");
        Assert.assertEquals((String)"Wrong node value", (Object)"Odyssee", (Object)node.getValue());
        Assert.assertNotNull((String)"Could not find other nodes", (Object)NodeStructureHelper.nodeForKey(model, "Homer/Ilias/Hektor"));
    }

    @Test
    public void testAddPropertyNoValues() {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModel.createResolver();
        EasyMock.replay((Object[])new Object[]{resolver});
        InMemoryNodeModel model = new InMemoryNodeModel(NodeStructureHelper.ROOT_AUTHORS_TREE);
        model.addProperty(KEY, Collections.emptySet(), resolver);
        Assert.assertSame((String)"Root node was changed", (Object)NodeStructureHelper.ROOT_AUTHORS_TREE, (Object)model.getRootNode());
    }

    @Test
    public void testAddPropertyUpdateParentReferences() {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModel.createResolver();
        NodeAddData addData = new NodeAddData((Object)NodeStructureHelper.nodeForKey(NodeStructureHelper.ROOT_AUTHORS_TREE, "Homer/Ilias"), "location", false, Collections.singleton("locations"));
        InMemoryNodeModel model = new InMemoryNodeModel(NodeStructureHelper.ROOT_AUTHORS_TREE);
        EasyMock.expect((Object)resolver.resolveAddKey((Object)NodeStructureHelper.ROOT_AUTHORS_TREE, KEY, model.getNodeHandler())).andReturn((Object)addData);
        EasyMock.replay((Object[])new Object[]{resolver});
        String[] locations = new String[]{"Troja", "Beach", "Olympos"};
        model.addProperty(KEY, Arrays.asList(locations), resolver);
        String[] path = new String[]{"Homer", "Ilias", "locations"};
        ImmutableNode node = NodeStructureHelper.nodeForKey(model, NodeStructureHelper.nodePathWithEndNode("location(1)", path));
        TestInMemoryNodeModel.checkPathToRoot(model, node, path);
    }

    @Test
    public void testAddPropertyWithPathNodes() {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModel.createResolver();
        NodeAddData addData = new NodeAddData((Object)NodeStructureHelper.nodeForKey(NodeStructureHelper.ROOT_AUTHORS_TREE, "Homer/Ilias"), "location", false, Collections.singleton("locations"));
        InMemoryNodeModel model = new InMemoryNodeModel(NodeStructureHelper.ROOT_AUTHORS_TREE);
        EasyMock.expect((Object)resolver.resolveAddKey((Object)NodeStructureHelper.ROOT_AUTHORS_TREE, KEY, model.getNodeHandler())).andReturn((Object)addData);
        EasyMock.replay((Object[])new Object[]{resolver});
        String[] locations = new String[]{"Troja", "Beach", "Olympos"};
        model.addProperty(KEY, Arrays.asList(locations), resolver);
        ImmutableNode nodeLocs = NodeStructureHelper.nodeForKey(model, "Homer/Ilias/locations");
        Assert.assertEquals((String)"Wrong number of children", (long)locations.length, (long)nodeLocs.getChildren().size());
        int idx = 0;
        for (ImmutableNode c : nodeLocs) {
            Assert.assertEquals((String)"Wrong node name", (Object)"location", (Object)c.getNodeName());
            Assert.assertEquals((String)"Wrong value", (Object)locations[idx], (Object)c.getValue());
            Assert.assertTrue((String)"Got children", (boolean)c.getChildren().isEmpty());
            Assert.assertTrue((String)"Got attributes", (boolean)c.getAttributes().isEmpty());
            ++idx;
        }
        Assert.assertNotNull((String)"Could not find other nodes", (Object)NodeStructureHelper.nodeForKey(model, "Homer/Ilias/Hektor"));
    }

    @Test
    public void testClear() {
        InMemoryNodeModel model = new InMemoryNodeModel(NodeStructureHelper.ROOT_AUTHORS_TREE);
        model.clear(TestInMemoryNodeModel.createResolver());
        Assert.assertFalse((String)"Got still data", (boolean)model.getNodeHandler().isDefined((Object)model.getRootNode()));
        Assert.assertEquals((String)"Root name was changed", (Object)NodeStructureHelper.ROOT_AUTHORS_TREE.getNodeName(), (Object)model.getRootNode().getNodeName());
    }

    @Test
    public void testClearPropertyAttribute() {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModel.createResolver();
        InMemoryNodeModel model = new InMemoryNodeModel(NodeStructureHelper.ROOT_PERSONAE_TREE);
        String nodeKey = "Prospero/The Tempest/originalValue";
        EasyMock.expect((Object)resolver.resolveKey((Object)model.getRootNode(), KEY, model.getNodeHandler())).andReturn(Collections.singletonList(QueryResult.createAttributeResult((Object)NodeStructureHelper.nodeForKey(model, "Prospero/The Tempest/originalValue"), (String)"tested")));
        EasyMock.replay((Object[])new Object[]{resolver});
        model.clearProperty(KEY, resolver);
        ImmutableNode node = NodeStructureHelper.nodeForKey(model, "Prospero/The Tempest/originalValue");
        Assert.assertTrue((String)"Attribute not removed", (boolean)node.getAttributes().isEmpty());
    }

    @Test
    public void testClearPropertyNode() {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModel.createResolver();
        InMemoryNodeModel model = new InMemoryNodeModel(NodeStructureHelper.ROOT_PERSONAE_TREE);
        String nodeKey = "Ariel/The Tempest/originalValue";
        EasyMock.expect((Object)resolver.resolveKey((Object)model.getRootNode(), KEY, model.getNodeHandler())).andReturn(Collections.singletonList(QueryResult.createNodeResult((Object)NodeStructureHelper.nodeForKey(model, "Ariel/The Tempest/originalValue"))));
        EasyMock.replay((Object[])new Object[]{resolver});
        model.clearProperty(KEY, resolver);
        ImmutableNode node = NodeStructureHelper.nodeForKey(model, "Ariel/The Tempest/originalValue");
        Assert.assertNull((String)"Value not cleared", (Object)node.getValue());
    }

    @Test
    public void testClearPropertyNonExisting() {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModel.createResolver();
        InMemoryNodeModel model = new InMemoryNodeModel(NodeStructureHelper.ROOT_PERSONAE_TREE);
        EasyMock.expect((Object)resolver.resolveKey((Object)model.getRootNode(), KEY, model.getNodeHandler())).andReturn(Collections.emptyList());
        EasyMock.replay((Object[])new Object[]{resolver});
        TreeData treeDataOld = model.getTreeData();
        model.clearProperty(KEY, resolver);
        Assert.assertNotNull((String)"No root node", (Object)model.getNodeHandler().getRootNode());
        Assert.assertSame((String)"Data was changed", (Object)treeDataOld, (Object)model.getTreeData());
    }

    @Test
    public void testClearTreeAttribute() {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModel.createResolver();
        InMemoryNodeModel model = new InMemoryNodeModel(NodeStructureHelper.ROOT_PERSONAE_TREE);
        String nodeName = "Puck";
        QueryResult result = QueryResult.createAttributeResult((Object)NodeStructureHelper.nodeForKey(model, "Puck"), (String)"author");
        EasyMock.expect((Object)resolver.resolveKey((Object)NodeStructureHelper.ROOT_PERSONAE_TREE, KEY, model.getNodeHandler())).andReturn(Collections.singletonList(result));
        EasyMock.replay((Object[])new Object[]{resolver});
        List removed = model.clearTree(KEY, resolver);
        ImmutableNode node = NodeStructureHelper.nodeForKey(model, "Puck");
        Assert.assertTrue((String)"Got still attributes", (boolean)node.getAttributes().isEmpty());
        Assert.assertEquals((String)"Wrong number of removed elements", (long)1L, (long)removed.size());
        Assert.assertTrue((String)"Wrong removed element", (boolean)removed.contains(result));
    }

    @Test
    public void testClearTreeChildrenRemovedFromParentMapping() {
        String path = "Homer/Ilias";
        this.checkClearTreeUpdatedParentMapping("Homer/Ilias", NodeStructureHelper.nodeForKey(NodeStructureHelper.ROOT_AUTHORS_TREE, "Homer/Ilias/Achilles"));
    }

    @Test
    public void testClearTreeNodeRemovedFromParentMapping() {
        String path = "Homer/Ilias/Achilles";
        this.checkClearTreeUpdatedParentMapping("Homer/Ilias/Achilles", NodeStructureHelper.nodeForKey(NodeStructureHelper.ROOT_AUTHORS_TREE, "Homer/Ilias/Achilles"));
    }

    @Test
    public void testClearTreeNodes() {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModel.createResolver();
        InMemoryNodeModel model = new InMemoryNodeModel(NodeStructureHelper.ROOT_AUTHORS_TREE);
        QueryResult result = QueryResult.createNodeResult((Object)NodeStructureHelper.nodeForKey(model, "Homer/Ilias/Achilles"));
        EasyMock.expect((Object)resolver.resolveKey((Object)NodeStructureHelper.ROOT_AUTHORS_TREE, KEY, model.getNodeHandler())).andReturn(Collections.singletonList(result));
        EasyMock.replay((Object[])new Object[]{resolver});
        List removed = model.clearTree(KEY, resolver);
        ImmutableNode node = NodeStructureHelper.nodeForKey(model, "Homer/Ilias");
        Assert.assertEquals((String)"Wrong number of children", (long)2L, (long)node.getChildren().size());
        for (ImmutableNode c : node) {
            Assert.assertNotEquals((String)"Node still found", (Object)((ImmutableNode)result.getNode()).getNodeName(), (Object)c.getNodeName());
        }
        Assert.assertEquals((String)"Wrong number of removed elements", (long)1L, (long)removed.size());
        Assert.assertTrue((String)"Wrong removed element", (boolean)removed.contains(result));
    }

    @Test
    public void testClearTreeNodesAndAttributes() {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModel.createResolver();
        InMemoryNodeModel model = new InMemoryNodeModel(NodeStructureHelper.ROOT_PERSONAE_TREE);
        String nodeName = "Puck";
        ImmutableNode orgNode = NodeStructureHelper.nodeForKey(model, "Puck");
        ArrayList<QueryResult> results = new ArrayList<QueryResult>(2);
        results.add(QueryResult.createAttributeResult((Object)orgNode, (String)"author"));
        results.add(QueryResult.createNodeResult(orgNode.getChildren().get(0)));
        EasyMock.expect((Object)resolver.resolveKey((Object)NodeStructureHelper.ROOT_PERSONAE_TREE, KEY, model.getNodeHandler())).andReturn(results);
        EasyMock.replay((Object[])new Object[]{resolver});
        model.clearTree(KEY, resolver);
        try {
            NodeStructureHelper.nodeForKey(model, "Puck");
            Assert.fail((String)"Node still present!");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    public void testClearTreeNonExistingKey() {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModel.createResolver();
        InMemoryNodeModel model = new InMemoryNodeModel(NodeStructureHelper.ROOT_PERSONAE_TREE);
        EasyMock.expect((Object)resolver.resolveKey((Object)NodeStructureHelper.ROOT_PERSONAE_TREE, KEY, model.getNodeHandler())).andReturn(Collections.emptyList());
        EasyMock.replay((Object[])new Object[]{resolver});
        TreeData treeDataOld = model.getTreeData();
        Assert.assertTrue((String)"Elements removed", (boolean)model.clearTree(KEY, resolver).isEmpty());
        Assert.assertNotNull((String)"No root node", (Object)model.getNodeHandler().getRootNode());
        Assert.assertSame((String)"Data was changed", (Object)treeDataOld, (Object)model.getTreeData());
    }

    @Test
    public void testClearTreeRemoveUndefinedNodes() {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModel.createResolver();
        InMemoryNodeModel model = new InMemoryNodeModel(NodeStructureHelper.ROOT_AUTHORS_TREE);
        ImmutableNode node = NodeStructureHelper.nodeForKey(model, "Homer/Ilias");
        ArrayList<QueryResult> results = new ArrayList<QueryResult>(node.getChildren().size());
        for (ImmutableNode child : node) {
            results.add(QueryResult.createNodeResult((Object)child));
        }
        EasyMock.expect((Object)resolver.resolveKey((Object)NodeStructureHelper.ROOT_AUTHORS_TREE, KEY, model.getNodeHandler())).andReturn(results);
        EasyMock.replay((Object[])new Object[]{resolver});
        model.clearTree(KEY, resolver);
        Assert.assertEquals((String)"Child of root not removed", (long)(NodeStructureHelper.authorsLength() - 1), (long)model.getRootNode().getChildren().size());
        for (ImmutableNode child : model.getRootNode()) {
            Assert.assertNotEquals((String)"Child still found", (Object)"Homer", (Object)child.getNodeName());
        }
    }

    @Test
    public void testClearTreeResultIsEmpty() {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModel.createResolver();
        ImmutableNode child = new ImmutableNode.Builder().name("child").value((Object)"test").create();
        ImmutableNode root = new ImmutableNode.Builder(1).addChild(child).create();
        InMemoryNodeModel model = new InMemoryNodeModel(root);
        EasyMock.expect((Object)resolver.resolveKey((Object)root, KEY, model.getNodeHandler())).andReturn(Collections.singletonList(QueryResult.createNodeResult((Object)child)));
        EasyMock.replay((Object[])new Object[]{resolver});
        model.clearTree(KEY, resolver);
        Assert.assertFalse((String)"Root node still defined", (boolean)model.getNodeHandler().isDefined((Object)model.getRootNode()));
    }

    @Test
    public void testClearTreeRootNode() {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModel.createResolver();
        InMemoryNodeModel model = new InMemoryNodeModel(NodeStructureHelper.ROOT_AUTHORS_TREE);
        ArrayList<QueryResult> results = new ArrayList<QueryResult>(2);
        results.add(QueryResult.createNodeResult((Object)NodeStructureHelper.nodeForKey(model, NodeStructureHelper.author(0))));
        results.add(QueryResult.createNodeResult((Object)NodeStructureHelper.ROOT_AUTHORS_TREE));
        EasyMock.expect((Object)resolver.resolveKey((Object)NodeStructureHelper.ROOT_AUTHORS_TREE, KEY, model.getNodeHandler())).andReturn(results);
        EasyMock.replay((Object[])new Object[]{resolver});
        model.clearTree(KEY, resolver);
        Assert.assertFalse((String)"Got still data", (boolean)model.getNodeHandler().isDefined((Object)model.getRootNode()));
    }

    @Test
    public void testClearTreeUpdateParentReferences() {
        String[] path = new String[]{"Homer", "Ilias"};
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModel.createResolver();
        InMemoryNodeModel model = new InMemoryNodeModel(NodeStructureHelper.ROOT_AUTHORS_TREE);
        QueryResult result = QueryResult.createNodeResult((Object)NodeStructureHelper.nodeForKey(model, NodeStructureHelper.nodePathWithEndNode("Achilles", path)));
        EasyMock.expect((Object)resolver.resolveKey((Object)NodeStructureHelper.ROOT_AUTHORS_TREE, KEY, model.getNodeHandler())).andReturn(Collections.singletonList(result));
        EasyMock.replay((Object[])new Object[]{resolver});
        model.clearTree(KEY, resolver);
        TestInMemoryNodeModel.checkPathToRoot(model, NodeStructureHelper.nodeForKey(model, NodeStructureHelper.nodePathWithEndNode("Hektor", path)), path);
    }

    @Test
    public void testCompactReplacementMapping() {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModel.createResolver();
        InMemoryNodeModel model = new InMemoryNodeModel(NodeStructureHelper.ROOT_AUTHORS_TREE);
        int numberOfOperations = 200;
        String key = "Homer/Ilias";
        int i = 0;
        while (i < 200) {
            int index = i++;
            EasyMock.expect((Object)resolver.resolveAddKey(EasyMock.anyObject(ImmutableNode.class), (String)EasyMock.eq((Object)KEY), (NodeHandler)EasyMock.anyObject(TreeData.class))).andAnswer(() -> {
                Assert.assertSame((String)"Wrong root node", (Object)model.getRootNode(), (Object)EasyMock.getCurrentArguments()[0]);
                ImmutableNode addParent = NodeStructureHelper.nodeForKey(model, "Homer/Ilias");
                return new NodeAddData((Object)addParent, "Warrior" + index, false, null);
            });
        }
        EasyMock.replay((Object[])new Object[]{resolver});
        for (i = 0; i < 200; ++i) {
            model.addProperty(KEY, Collections.singleton(i), resolver);
        }
        ImmutableNode orgNode = NodeStructureHelper.nodeForKey(NodeStructureHelper.ROOT_AUTHORS_TREE, "Homer/Ilias");
        ImmutableNode changedNode = NodeStructureHelper.nodeForKey(model, "Homer/Ilias");
        Assert.assertEquals((String)"Wrong number of children", (long)(orgNode.getChildren().size() + 200), (long)changedNode.getChildren().size());
        Map replacementMapping = model.getTreeData().copyReplacementMapping();
        Assert.assertTrue((String)("Replacement mapping too big: " + replacementMapping.size()), (replacementMapping.size() < 200 ? 1 : 0) != 0);
    }

    @Test
    public void testConcurrentUpdate() throws InterruptedException {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModel.createResolver();
        InMemoryNodeModel model = new InMemoryNodeModel(NodeStructureHelper.ROOT_AUTHORS_TREE);
        EasyMock.expect((Object)resolver.resolveAddKey(EasyMock.anyObject(ImmutableNode.class), (String)EasyMock.eq((Object)KEY), (NodeHandler)EasyMock.anyObject(TreeData.class))).andAnswer(() -> {
            ImmutableNode addParent = (ImmutableNode)EasyMock.getCurrentArguments()[0];
            return new NodeAddData((Object)addParent, "name", false, Collections.singleton("author"));
        }).anyTimes();
        EasyMock.replay((Object[])new Object[]{resolver});
        CountDownLatch latch = new CountDownLatch(1);
        String authorPrefix = "newAuthor";
        int threadCount = 32;
        Thread[] threads = new Thread[32];
        for (int i = 0; i < 32; ++i) {
            String authorName = "newAuthor" + i;
            threads[i] = new Thread(() -> {
                try {
                    latch.await();
                    model.addProperty(KEY, Collections.singleton(authorName), resolver);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            });
            threads[i].start();
        }
        latch.countDown();
        for (Thread t : threads) {
            t.join();
        }
        Pattern patternAuthorName = Pattern.compile(Pattern.quote("newAuthor") + "(\\d+)");
        HashSet<Integer> indices = new HashSet<Integer>();
        for (int i = 0; i < 32; ++i) {
            ImmutableNode node = NodeStructureHelper.nodeForKey(model, "author(" + i + ")/name");
            Matcher m = patternAuthorName.matcher(String.valueOf(node.getValue()));
            Assert.assertTrue((String)("Wrong value: " + node.getValue()), (boolean)m.matches());
            int idx = Integer.parseInt(m.group(1));
            Assert.assertTrue((String)("Invalid index: " + idx), (idx >= 0 && idx < 32 ? 1 : 0) != 0);
            indices.add(idx);
        }
        Assert.assertEquals((String)"Not all authors were created", (long)32L, (long)indices.size());
    }

    @Test
    public void testGetInMemoryRepresentation() {
        InMemoryNodeModel model = new InMemoryNodeModel(NodeStructureHelper.ROOT_AUTHORS_TREE);
        Assert.assertSame((String)"Wrong in-memory representation", (Object)NodeStructureHelper.ROOT_AUTHORS_TREE, (Object)model.getInMemoryRepresentation());
    }

    @Test
    public void testGetNodeHandler() {
        InMemoryNodeModel model = new InMemoryNodeModel(NodeStructureHelper.ROOT_PERSONAE_TREE);
        Assert.assertSame((String)"Wrong node handler", (Object)model.getTreeData(), (Object)model.getNodeHandler());
    }

    @Test
    public void testGetRootNodeFromConstructor() {
        InMemoryNodeModel model = new InMemoryNodeModel(NodeStructureHelper.ROOT_AUTHORS_TREE);
        Assert.assertSame((String)"Wrong root node", (Object)NodeStructureHelper.ROOT_AUTHORS_TREE, (Object)model.getRootNode());
    }

    @Test
    public void testInitDefaultRoot() {
        InMemoryNodeModel model = new InMemoryNodeModel();
        ImmutableNode root = model.getRootNode();
        Assert.assertNull((String)"Got a name", (Object)root.getNodeName());
        Assert.assertNull((String)"Got a value", (Object)root.getValue());
        Assert.assertTrue((String)"Got children", (boolean)root.getChildren().isEmpty());
        Assert.assertTrue((String)"Got attributes", (boolean)root.getAttributes().isEmpty());
    }

    @Test
    public void testSetPropertyChangedValues() {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModel.createResolver();
        InMemoryNodeModel model = new InMemoryNodeModel(NodeStructureHelper.ROOT_PERSONAE_TREE);
        String nodeKey = "Ariel/The Tempest/originalValue";
        HashMap<QueryResult, String> changedValues = new HashMap<QueryResult, String>();
        String newValue = "of course";
        ImmutableNode changedNode = NodeStructureHelper.nodeForKey(model, "Ariel/The Tempest/originalValue");
        changedValues.put(QueryResult.createAttributeResult((Object)changedNode, (String)"tested"), "of course");
        changedValues.put(QueryResult.createNodeResult((Object)changedNode), "of course");
        NodeUpdateData updateData = new NodeUpdateData(changedValues, null, null, null);
        EasyMock.expect((Object)resolver.resolveUpdateKey((Object)NodeStructureHelper.ROOT_PERSONAE_TREE, KEY, (Object)this, model.getNodeHandler())).andReturn((Object)updateData);
        EasyMock.replay((Object[])new Object[]{resolver});
        model.setProperty(KEY, (Object)this, resolver);
        ImmutableNode node = NodeStructureHelper.nodeForKey(model, "Ariel/The Tempest/originalValue");
        Assert.assertEquals((String)"Attribute value not changed", (Object)"of course", node.getAttributes().get("tested"));
        Assert.assertEquals((String)"Node value not changed", (Object)"of course", (Object)node.getValue());
    }

    @Test
    public void testSetPropertyClearValues() {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModel.createResolver();
        InMemoryNodeModel model = new InMemoryNodeModel(NodeStructureHelper.ROOT_PERSONAE_TREE);
        String nodeKey = "Ariel/The Tempest/originalValue";
        NodeUpdateData updateData = new NodeUpdateData(null, null, Collections.singletonList(QueryResult.createNodeResult((Object)NodeStructureHelper.nodeForKey(model, "Ariel/The Tempest/originalValue"))), null);
        EasyMock.expect((Object)resolver.resolveUpdateKey((Object)NodeStructureHelper.ROOT_PERSONAE_TREE, KEY, (Object)this, model.getNodeHandler())).andReturn((Object)updateData);
        EasyMock.replay((Object[])new Object[]{resolver});
        model.setProperty(KEY, (Object)this, resolver);
        ImmutableNode node = NodeStructureHelper.nodeForKey(model, "Ariel/The Tempest/originalValue");
        Assert.assertNull((String)"Value not cleared", (Object)node.getValue());
    }

    @Test
    public void testSetPropertyNewValues() {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModel.createResolver();
        NodeAddData addData = new NodeAddData((Object)NodeStructureHelper.nodeForKey(NodeStructureHelper.ROOT_AUTHORS_TREE, "Homer"), "work", false, null);
        NodeUpdateData updateData = new NodeUpdateData(null, Collections.singleton("Odyssee"), null, KEY);
        InMemoryNodeModel model = new InMemoryNodeModel(NodeStructureHelper.ROOT_AUTHORS_TREE);
        EasyMock.expect((Object)resolver.resolveUpdateKey((Object)NodeStructureHelper.ROOT_AUTHORS_TREE, KEY, (Object)this, model.getNodeHandler())).andReturn((Object)updateData);
        EasyMock.expect((Object)resolver.resolveAddKey((Object)NodeStructureHelper.ROOT_AUTHORS_TREE, KEY, model.getNodeHandler())).andReturn((Object)addData);
        EasyMock.replay((Object[])new Object[]{resolver});
        model.setProperty(KEY, (Object)this, resolver);
        ImmutableNode node = NodeStructureHelper.nodeForKey(model, "Homer/work");
        Assert.assertEquals((String)"Wrong node value", (Object)"Odyssee", (Object)node.getValue());
        Assert.assertNotNull((String)"Could not find other nodes", (Object)NodeStructureHelper.nodeForKey(model, "Homer/Ilias/Hektor"));
    }

    @Test
    public void testSetPropertyNoChanges() {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModel.createResolver();
        InMemoryNodeModel model = new InMemoryNodeModel(NodeStructureHelper.ROOT_PERSONAE_TREE);
        EasyMock.expect((Object)resolver.resolveUpdateKey((Object)NodeStructureHelper.ROOT_PERSONAE_TREE, KEY, (Object)this, model.getNodeHandler())).andReturn((Object)new NodeUpdateData(null, null, null, null));
        EasyMock.replay((Object[])new Object[]{resolver});
        model.setProperty(KEY, (Object)this, resolver);
        Assert.assertSame((String)"Model was changed", (Object)NodeStructureHelper.ROOT_PERSONAE_TREE, (Object)model.getRootNode());
    }

    @Test
    public void testSetRoot() {
        InMemoryNodeModel model = new InMemoryNodeModel(NodeStructureHelper.ROOT_PERSONAE_TREE);
        model.setRootNode(NodeStructureHelper.ROOT_AUTHORS_TREE);
        Assert.assertSame((String)"Root node not changed", (Object)NodeStructureHelper.ROOT_AUTHORS_TREE, (Object)model.getRootNode());
        ImmutableNode node = NodeStructureHelper.nodeForKey(model, "Homer/Ilias");
        Assert.assertEquals((String)"Wrong parent mapping", (Object)NodeStructureHelper.nodeForKey(model, "Homer"), (Object)model.getNodeHandler().getParent((Object)node));
    }

    @Test
    public void testSetRootNull() {
        InMemoryNodeModel model = new InMemoryNodeModel(NodeStructureHelper.ROOT_PERSONAE_TREE);
        model.setRootNode(null);
        ImmutableNode rootNode = model.getRootNode();
        Assert.assertTrue((String)"Got children", (boolean)rootNode.getChildren().isEmpty());
    }
}

