/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.tree;

import java.util.List;
import org.apache.commons.configuration2.BaseHierarchicalConfiguration;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.tree.AbstractCombinerTest;
import org.apache.commons.configuration2.tree.ExpressionEngine;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.configuration2.tree.MergeCombiner;
import org.apache.commons.configuration2.tree.NodeCombiner;
import org.apache.commons.configuration2.tree.NodeHandler;
import org.apache.commons.configuration2.tree.QueryResult;
import org.apache.commons.configuration2.tree.xpath.XPathExpressionEngine;
import org.junit.Assert;
import org.junit.Test;

public class TestMergeCombiner
extends AbstractCombinerTest {
    private ImmutableNode checkTable(HierarchicalConfiguration<ImmutableNode> config) {
        Assert.assertEquals((String)"Wrong number of tables", (long)1L, (long)config.getMaxIndex("database.tables.table"));
        HierarchicalConfiguration c = config.configurationAt("database.tables.table(0)");
        Assert.assertEquals((String)"Wrong table name", (Object)"documents", (Object)c.getString("name"));
        Assert.assertEquals((String)"Wrong number of fields", (long)2L, (long)c.getMaxIndex("fields.field.name"));
        Assert.assertEquals((String)"Wrong field", (Object)"docname", (Object)c.getString("fields.field(1).name"));
        NodeHandler nodeHandler = config.getNodeModel().getNodeHandler();
        List nds = config.getExpressionEngine().query(nodeHandler.getRootNode(), "database.tables.table", nodeHandler);
        Assert.assertFalse((String)"No node found", (boolean)nds.isEmpty());
        Assert.assertFalse((String)"Not a node result", (boolean)((QueryResult)nds.get(0)).isAttributeResult());
        return (ImmutableNode)((QueryResult)nds.get(0)).getNode();
    }

    @Override
    protected NodeCombiner createCombiner() {
        return new MergeCombiner();
    }

    @Test
    public void testAttributes() throws ConfigurationException {
        BaseHierarchicalConfiguration config = this.createCombinedConfiguration();
        Assert.assertEquals((String)"Wrong value of min attribute", (long)1L, (long)config.getInt("gui.level[@min]"));
        Assert.assertEquals((String)"Wrong value of default attribute", (long)2L, (long)config.getInt("gui.level[@default]"));
        Assert.assertEquals((String)"Wrong number of id attributes", (long)0L, (long)config.getMaxIndex("database.tables.table(0)[@id]"));
        Assert.assertEquals((String)"Wrong value of table id", (long)1L, (long)config.getInt("database.tables.table(0)[@id]"));
    }

    @Test
    public void testCombinedTable() throws ConfigurationException {
        this.checkTable((HierarchicalConfiguration<ImmutableNode>)this.createCombinedConfiguration());
    }

    @Test
    public void testListFromFirstStructure() throws ConfigurationException {
        BaseHierarchicalConfiguration config = this.createCombinedConfiguration();
        Assert.assertEquals((String)"Wrong number of services", (long)0L, (long)config.getMaxIndex("net.service.url"));
        Assert.assertEquals((String)"Wrong service", (Object)"http://service1.org", (Object)config.getString("net.service.url"));
        Assert.assertFalse((String)"Type attribute available", (boolean)config.containsKey("net.service.url[@type]"));
    }

    @Test
    public void testListFromSecondStructure() throws ConfigurationException {
        BaseHierarchicalConfiguration config = this.createCombinedConfiguration();
        Assert.assertEquals((String)"Wrong number of servers", (long)3L, (long)config.getMaxIndex("net.server.url"));
        Assert.assertEquals((String)"Wrong server", (Object)"http://testsvr.com", (Object)config.getString("net.server.url(2)"));
    }

    @Test
    public void testMerge() throws ConfigurationException {
        BaseHierarchicalConfiguration config = this.createCombinedConfiguration();
        config.setExpressionEngine((ExpressionEngine)new XPathExpressionEngine());
        Assert.assertEquals((String)"Wrong number of Channels", (long)3L, (long)config.getMaxIndex("Channels/Channel"));
        Assert.assertEquals((String)"Bad Channel 1 Name", (Object)"My Channel", (Object)config.getString("Channels/Channel[@id='1']/Name"));
        Assert.assertEquals((String)"Bad Channel Type", (Object)"half", (Object)config.getString("Channels/Channel[@id='1']/@type"));
        Assert.assertEquals((String)"Bad Channel 2 Name", (Object)"Channel 2", (Object)config.getString("Channels/Channel[@id='2']/Name"));
        Assert.assertEquals((String)"Bad Channel Type", (Object)"full", (Object)config.getString("Channels/Channel[@id='2']/@type"));
        Assert.assertEquals((String)"Bad Channel Data", (Object)"test 1 data", (Object)config.getString("Channels/Channel[@id='1']/ChannelData"));
        Assert.assertEquals((String)"Bad Channel Data", (Object)"test 2 data", (Object)config.getString("Channels/Channel[@id='2']/ChannelData"));
        Assert.assertEquals((String)"Bad Channel Data", (Object)"more test 2 data", (Object)config.getString("Channels/Channel[@id='2']/MoreChannelData"));
    }

    @Test
    public void testOverrideValues() throws ConfigurationException {
        BaseHierarchicalConfiguration config = this.createCombinedConfiguration();
        Assert.assertEquals((String)"Wrong user", (Object)"Admin", (Object)config.getString("base.services.security.login.user"));
        Assert.assertEquals((String)"Wrong user type", (Object)"default", (Object)config.getString("base.services.security.login.user[@type]"));
        Assert.assertNull((String)"Wrong password", (Object)config.getString("base.services.security.login.passwd"));
        Assert.assertEquals((String)"Wrong password type", (Object)"secret", (Object)config.getString("base.services.security.login.passwd[@type]"));
    }

    @Test
    public void testSimpleValues() throws ConfigurationException {
        BaseHierarchicalConfiguration config = this.createCombinedConfiguration();
        Assert.assertEquals((String)"Wrong number of bgcolors", (long)0L, (long)config.getMaxIndex("gui.bgcolor"));
        Assert.assertEquals((String)"Wrong bgcolor", (Object)"green", (Object)config.getString("gui.bgcolor"));
        Assert.assertEquals((String)"Wrong selcolor", (Object)"yellow", (Object)config.getString("gui.selcolor"));
        Assert.assertEquals((String)"Wrong fgcolor", (Object)"blue", (Object)config.getString("gui.fgcolor"));
        Assert.assertEquals((String)"Wrong level", (long)1L, (long)config.getInt("gui.level"));
    }
}

