/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.tree;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.configuration2.tree.NodeUpdateData;
import org.apache.commons.configuration2.tree.QueryResult;
import org.junit.Assert;
import org.junit.Test;

public class TestNodeUpdateData {
    private static QueryResult<Object> result(Object value) {
        return QueryResult.createNodeResult((Object)value);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testGetChangedValuesModify() {
        HashMap<QueryResult<Object>, Integer> map = new HashMap<QueryResult<Object>, Integer>();
        map.put(TestNodeUpdateData.result("n1"), 42);
        NodeUpdateData data = new NodeUpdateData(map, null, null, null);
        data.getChangedValues().put(TestNodeUpdateData.result("n2"), 43);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testGetNewValuesModify() {
        LinkedList<Integer> col = new LinkedList<Integer>();
        col.add(42);
        NodeUpdateData data = new NodeUpdateData(null, col, null, null);
        data.getNewValues().add(43);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testGetRemovedNodesModify() {
        LinkedList<QueryResult<Object>> col = new LinkedList<QueryResult<Object>>();
        col.add(TestNodeUpdateData.result("n1"));
        NodeUpdateData data = new NodeUpdateData(null, null, col, null);
        data.getRemovedNodes().add(TestNodeUpdateData.result("newNode"));
    }

    @Test
    public void testInitChangedValuesDefensiveCopy() {
        HashMap<QueryResult<Object>, String> map = new HashMap<QueryResult<Object>, String>();
        map.put(TestNodeUpdateData.result("test"), "value");
        NodeUpdateData data = new NodeUpdateData(map, null, null, null);
        map.put(TestNodeUpdateData.result("anotherTest"), "anotherValue");
        Map changedValues = data.getChangedValues();
        Assert.assertEquals((String)"Wrong number of changed values", (long)1L, (long)changedValues.size());
        Assert.assertEquals((String)"Wrong changed value", (Object)"value", changedValues.get(TestNodeUpdateData.result("test")));
    }

    @Test
    public void testInitNewValuesDefensiveCopy() {
        LinkedList<Object> col = new LinkedList<Object>();
        col.add(42);
        NodeUpdateData data = new NodeUpdateData(null, col, null, null);
        col.add("anotherValue");
        Collection newValues = data.getNewValues();
        Assert.assertEquals((String)"Wrong number of new values", (long)1L, (long)newValues.size());
        Assert.assertEquals((String)"Wrong value", (Object)42, newValues.iterator().next());
    }

    @Test
    public void testInitNoData() {
        NodeUpdateData data = new NodeUpdateData(null, null, null, null);
        Assert.assertTrue((String)"Got changed values", (boolean)data.getChangedValues().isEmpty());
        Assert.assertTrue((String)"Got new values", (boolean)data.getNewValues().isEmpty());
        Assert.assertTrue((String)"Got removed nodes", (boolean)data.getRemovedNodes().isEmpty());
    }

    @Test
    public void testInitRemovedNodesDefensiveCopy() {
        LinkedList<QueryResult<Object>> col = new LinkedList<QueryResult<Object>>();
        col.add(TestNodeUpdateData.result("n1"));
        NodeUpdateData data = new NodeUpdateData(null, null, col, null);
        col.add(TestNodeUpdateData.result("n2"));
        Collection removedNodes = data.getRemovedNodes();
        Assert.assertEquals((String)"Wrong number of new values", (long)1L, (long)removedNodes.size());
        Assert.assertEquals((String)"Wrong value", TestNodeUpdateData.result("n1"), removedNodes.iterator().next());
    }
}

