/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.tree;

import org.apache.commons.configuration2.ConfigurationAssert;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.configuration2.tree.InMemoryNodeModel;
import org.apache.commons.configuration2.tree.QueryResult;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestQueryResult {
    private static final String ATTR = "testAttribute";
    private static final Object VALUE = "Value of my attribute";
    private static ImmutableNode resultNode;
    private static ImmutableNode attributeNode;

    @BeforeClass
    public static void setUpBeforeClass() {
        resultNode = new ImmutableNode.Builder().name("resultNode").value((Object)42).create();
        attributeNode = new ImmutableNode.Builder().name("attributeNode").addAttribute(ATTR, VALUE).create();
    }

    @Test
    public void testEqualsFalse() {
        QueryResult nodeRes = QueryResult.createNodeResult((Object)resultNode);
        QueryResult attrRes = QueryResult.createAttributeResult((Object)attributeNode, (String)ATTR);
        ConfigurationAssert.checkEquals(nodeRes, attrRes, false);
        QueryResult res = QueryResult.createNodeResult((Object)attributeNode);
        ConfigurationAssert.checkEquals(nodeRes, res, false);
        res = QueryResult.createAttributeResult((Object)attributeNode, (String)"otherAttr");
        ConfigurationAssert.checkEquals(attrRes, res, false);
        res = QueryResult.createAttributeResult((Object)resultNode, (String)ATTR);
        ConfigurationAssert.checkEquals(attrRes, res, false);
    }

    @Test
    public void testEqualsOtherObjects() {
        QueryResult result = QueryResult.createNodeResult((Object)resultNode);
        ConfigurationAssert.checkEquals(result, null, false);
        ConfigurationAssert.checkEquals(result, this, false);
    }

    @Test
    public void testEqualsTrue() {
        QueryResult r1 = QueryResult.createNodeResult((Object)resultNode);
        ConfigurationAssert.checkEquals(r1, r1, true);
        QueryResult r2 = QueryResult.createNodeResult((Object)resultNode);
        ConfigurationAssert.checkEquals(r1, r2, true);
        r1 = QueryResult.createAttributeResult((Object)attributeNode, (String)ATTR);
        r2 = QueryResult.createAttributeResult((Object)attributeNode, (String)ATTR);
        ConfigurationAssert.checkEquals(r1, r2, true);
    }

    @Test
    public void testGetAttributeValue() {
        QueryResult result = QueryResult.createAttributeResult((Object)attributeNode, (String)ATTR);
        Assert.assertEquals((String)"Wrong value", (Object)VALUE, (Object)result.getAttributeValue(new InMemoryNodeModel().getNodeHandler()));
    }

    @Test(expected=IllegalStateException.class)
    public void testGetAttributeValueNoAttributeResult() {
        QueryResult result = QueryResult.createNodeResult((Object)resultNode);
        result.getAttributeValue(new InMemoryNodeModel().getNodeHandler());
    }

    @Test
    public void testIsAttributeResultFalse() {
        QueryResult result = QueryResult.createNodeResult((Object)resultNode);
        Assert.assertFalse((String)"An attribute result", (boolean)result.isAttributeResult());
    }

    @Test
    public void testIsAttributeResultTrue() {
        QueryResult result = QueryResult.createAttributeResult((Object)attributeNode, (String)ATTR);
        Assert.assertTrue((String)"Not an attribute result", (boolean)result.isAttributeResult());
    }

    @Test
    public void testToStringAttributeResult() {
        QueryResult result = QueryResult.createAttributeResult((Object)attributeNode, (String)ATTR);
        String s = result.toString();
        Assert.assertThat((Object)s, (Matcher)CoreMatchers.containsString((String)"attribute=testAttribute"));
        Assert.assertThat((Object)s, (Matcher)CoreMatchers.containsString((String)("parentNode=" + attributeNode)));
    }

    @Test
    public void testToStringNodeResult() {
        QueryResult result = QueryResult.createNodeResult((Object)resultNode);
        Assert.assertThat((Object)result.toString(), (Matcher)CoreMatchers.containsString((String)("resultNode=" + resultNode)));
    }
}

