/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.crypto.cipher;

import java.security.GeneralSecurityException;
import java.util.Properties;
import org.apache.commons.crypto.cipher.CryptoCipher;
import org.apache.commons.crypto.cipher.CryptoCipherFactory;
import org.apache.commons.crypto.cipher.JceCipher;
import org.apache.commons.crypto.cipher.OpenSsl;
import org.apache.commons.crypto.cipher.OpenSslCipher;
import org.junit.Assert;
import org.junit.Test;

public class CryptoCipherFactoryTest {
    @Test
    public void testDefaultCipher() throws GeneralSecurityException {
        CryptoCipher defaultCipher = CryptoCipherFactory.getCryptoCipher((String)"AES/CBC/NoPadding");
        String name = defaultCipher.getClass().getName();
        if (OpenSsl.getLoadingFailureReason() == null) {
            Assert.assertEquals((Object)OpenSslCipher.class.getName(), (Object)name);
        } else {
            Assert.assertEquals((Object)JceCipher.class.getName(), (Object)name);
        }
    }

    @Test
    public void testEmptyCipher() throws GeneralSecurityException {
        Properties properties = new Properties();
        properties.setProperty("commons.crypto.cipher.classes", "");
        CryptoCipher defaultCipher = CryptoCipherFactory.getCryptoCipher((String)"AES/CBC/NoPadding", (Properties)properties);
        String name = defaultCipher.getClass().getName();
        if (OpenSsl.getLoadingFailureReason() == null) {
            Assert.assertEquals((Object)OpenSslCipher.class.getName(), (Object)name);
        } else {
            Assert.assertEquals((Object)JceCipher.class.getName(), (Object)name);
        }
    }

    @Test(expected=GeneralSecurityException.class)
    public void testInvalidCipher() throws GeneralSecurityException {
        Properties properties = new Properties();
        properties.setProperty("commons.crypto.cipher.classes", "InvalidCipherName");
        CryptoCipherFactory.getCryptoCipher((String)"AES/CBC/NoPadding", (Properties)properties);
    }

    @Test(expected=GeneralSecurityException.class)
    public void testInvalidTransformation() throws GeneralSecurityException {
        Properties properties = new Properties();
        CryptoCipherFactory.getCryptoCipher((String)"AES/Invalid/NoPadding", (Properties)properties);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNoCipher() throws Exception {
        Properties properties = new Properties();
        properties.setProperty("commons.crypto.cipher.classes", ",");
        CryptoCipherFactory.getCryptoCipher((String)"AES/CBC/NoPadding", (Properties)properties);
    }
}

