/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.crypto.cipher;

import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import org.apache.commons.crypto.cipher.AbstractCipherTest;
import org.junit.Assert;
import org.junit.BeforeClass;

public class JceCipherTest
extends AbstractCipherTest {
    private static final int MAX_KEY_LEN_LOWER_BOUND = 256;

    @Override
    public void init() {
        this.transformations = new String[]{"AES/CBC/NoPadding", "AES/CBC/PKCS5Padding", "AES/CTR/NoPadding"};
        this.cipherClass = JCE_CIPHER_CLASSNAME;
    }

    @BeforeClass
    public static void checkJceUnlimitedStrength() throws NoSuchAlgorithmException {
        int maxKeyLen = Cipher.getMaxAllowedKeyLength("AES");
        Assert.assertTrue((String)String.format("Testing requires support for an AES key length of %d, but the detected maximum key length is %d.  This may indicate that the test environment is missing the JCE Unlimited Strength Jurisdiction Policy Files.", 256, maxKeyLen), (maxKeyLen >= 256 ? 1 : 0) != 0);
    }
}

