/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.crypto.cipher;

import java.nio.ByteBuffer;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import org.apache.commons.crypto.cipher.AbstractCipherTest;
import org.apache.commons.crypto.cipher.OpenSsl;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class OpenSslCipherTest
extends AbstractCipherTest {
    @Override
    public void init() {
        Assume.assumeTrue((OpenSsl.getLoadingFailureReason() == null ? 1 : 0) != 0);
        this.transformations = new String[]{"AES/CBC/NoPadding", "AES/CBC/PKCS5Padding", "AES/CTR/NoPadding"};
        this.cipherClass = OPENSSL_CIPHER_CLASSNAME;
    }

    @Test(expected=NoSuchAlgorithmException.class, timeout=120000L)
    public void testInvalidAlgorithm() throws Exception {
        Assume.assumeTrue((OpenSsl.getLoadingFailureReason() == null ? 1 : 0) != 0);
        try {
            OpenSsl.getInstance((String)"AES2/CTR/NoPadding");
            Assert.fail((String)"Should specify correct algorithm.");
        }
        catch (NoSuchAlgorithmException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Doesn't support algorithm: AES2 and mode: CTR"));
            throw e;
        }
    }

    @Test(expected=NoSuchPaddingException.class, timeout=120000L)
    public void testInvalidPadding() throws Exception {
        Assume.assumeTrue((OpenSsl.getLoadingFailureReason() == null ? 1 : 0) != 0);
        try {
            OpenSsl.getInstance((String)"AES/CTR/NoPadding2");
            Assert.fail((String)"Should specify correct padding.");
        }
        catch (NoSuchPaddingException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Doesn't support padding: NoPadding2"));
            throw e;
        }
    }

    @Test(expected=NoSuchAlgorithmException.class, timeout=120000L)
    public void testInvalidMode() throws Exception {
        Assume.assumeTrue((OpenSsl.getLoadingFailureReason() == null ? 1 : 0) != 0);
        try {
            OpenSsl.getInstance((String)"AES/CTR2/NoPadding");
            Assert.fail((String)"java.security.NoSuchAlgorithmException should be thrown.");
        }
        catch (NoSuchAlgorithmException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Doesn't support algorithm: AES and mode: CTR2"));
            throw e;
        }
    }

    @Test(timeout=120000L)
    public void testUpdateArguments() throws Exception {
        Assume.assumeTrue((OpenSsl.getLoadingFailureReason() == null ? 1 : 0) != 0);
        OpenSsl cipher = OpenSsl.getInstance((String)"AES/CTR/NoPadding");
        Assert.assertNotNull((Object)cipher);
        cipher.init(1, KEY, IV);
        ByteBuffer input = ByteBuffer.allocate(1024);
        ByteBuffer output = ByteBuffer.allocate(1024);
        try {
            cipher.update(input, output);
            Assert.fail((String)"Input and output buffer should be direct buffer.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Direct buffers are required"));
        }
        input = ByteBuffer.allocateDirect(1024);
        output = ByteBuffer.allocateDirect(1000);
        try {
            cipher.update(input, output);
            Assert.fail((String)"Output buffer length should be sufficient to store output data");
        }
        catch (ShortBufferException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Output buffer is not sufficient"));
        }
    }

    @Test(timeout=120000L)
    public void testDoFinalArguments() throws Exception {
        Assume.assumeTrue((OpenSsl.getLoadingFailureReason() == null ? 1 : 0) != 0);
        OpenSsl cipher = OpenSsl.getInstance((String)"AES/CTR/NoPadding");
        Assert.assertNotNull((Object)cipher);
        cipher.init(1, KEY, IV);
        ByteBuffer output = ByteBuffer.allocate(1024);
        try {
            cipher.doFinal(output);
            Assert.fail((String)"Output buffer should be direct buffer.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Direct buffer is required"));
        }
    }

    @Test(expected=InvalidKeyException.class, timeout=120000L)
    public void testInvalidKey() throws Exception {
        Assume.assumeTrue((OpenSsl.getLoadingFailureReason() == null ? 1 : 0) != 0);
        OpenSsl cipher = OpenSsl.getInstance((String)"AES/CTR/NoPadding");
        Assert.assertNotNull((Object)cipher);
        byte[] invalidKey = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17};
        try {
            cipher.init(1, invalidKey, IV);
            Assert.fail((String)"java.security.InvalidKeyException should be thrown.");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Invalid AES key length: " + invalidKey.length + " bytes"));
            throw e;
        }
    }

    @Test(expected=InvalidAlgorithmParameterException.class, timeout=120000L)
    public void testInvalidIV() throws Exception {
        Assume.assumeTrue((OpenSsl.getLoadingFailureReason() == null ? 1 : 0) != 0);
        OpenSsl cipher = OpenSsl.getInstance((String)"AES/CTR/NoPadding");
        Assert.assertNotNull((Object)cipher);
        byte[] invalidIV = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17};
        try {
            cipher.init(1, KEY, invalidIV);
            Assert.fail((String)"java.security.InvalidAlgorithmParameterException should be thrown.");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Wrong IV length: must be 16 bytes long"));
            throw e;
        }
    }
}

