/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.crypto.examples;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import java.util.Properties;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.crypto.cipher.CryptoCipher;
import org.apache.commons.crypto.utils.Utils;

public class CipherByteBufferExample {
    public static void main(String[] args) throws Exception {
        int finalBytes;
        int updateBytes;
        ByteBuffer outBuffer;
        SecretKeySpec key = new SecretKeySpec(CipherByteBufferExample.getUTF8Bytes("1234567890123456"), "AES");
        IvParameterSpec iv = new IvParameterSpec(CipherByteBufferExample.getUTF8Bytes("1234567890123456"));
        Properties properties = new Properties();
        String transform = "AES/CBC/PKCS5Padding";
        int bufferSize = 1024;
        try (CryptoCipher encipher = Utils.getCipherInstance((String)"AES/CBC/PKCS5Padding", (Properties)properties);){
            ByteBuffer inBuffer = ByteBuffer.allocateDirect(1024);
            outBuffer = ByteBuffer.allocateDirect(1024);
            inBuffer.put(CipherByteBufferExample.getUTF8Bytes("hello world!"));
            inBuffer.flip();
            System.out.println("inBuffer=" + CipherByteBufferExample.asString(inBuffer));
            encipher.init(1, (Key)key, (AlgorithmParameterSpec)iv);
            updateBytes = encipher.update(inBuffer, outBuffer);
            System.out.println(updateBytes);
            finalBytes = encipher.doFinal(inBuffer, outBuffer);
            System.out.println(finalBytes);
        }
        outBuffer.flip();
        byte[] encoded = new byte[updateBytes + finalBytes];
        outBuffer.duplicate().get(encoded);
        System.out.println(Arrays.toString(encoded));
        try (CryptoCipher decipher = Utils.getCipherInstance((String)"AES/CBC/PKCS5Padding", (Properties)properties);){
            decipher.init(2, (Key)key, (AlgorithmParameterSpec)iv);
            ByteBuffer decoded = ByteBuffer.allocateDirect(1024);
            decipher.update(outBuffer, decoded);
            decipher.doFinal(outBuffer, decoded);
            decoded.flip();
            System.out.println("decoded=" + CipherByteBufferExample.asString(decoded));
        }
    }

    private static byte[] getUTF8Bytes(String input) {
        return input.getBytes(StandardCharsets.UTF_8);
    }

    private static String asString(ByteBuffer buffer) {
        ByteBuffer copy = buffer.duplicate();
        byte[] bytes = new byte[Math.min(copy.remaining(), 50)];
        copy.get(bytes);
        return new String(bytes, StandardCharsets.UTF_8);
    }
}

