/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.crypto.jna;

import java.io.ByteArrayOutputStream;
import org.apache.commons.crypto.cipher.AbstractCipherTest;
import org.apache.commons.crypto.jna.OpenSslJna;
import org.apache.commons.crypto.stream.AbstractCipherStreamTest;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractCipherJnaStreamTest
extends AbstractCipherStreamTest {
    private static final String CIPHER_OPENSSL_JNA = OpenSslJna.getCipherClass().getName();

    @Before
    public void init() {
        Assume.assumeTrue((boolean)OpenSslJna.isEnabled());
    }

    @Override
    @Test(timeout=120000L)
    public void testSkip() throws Exception {
        this.doSkipTest(CIPHER_OPENSSL_JNA, false);
        this.doSkipTest(CIPHER_OPENSSL_JNA, true);
    }

    @Override
    @Test(timeout=120000L)
    public void testByteBufferRead() throws Exception {
        this.doByteBufferRead(CIPHER_OPENSSL_JNA, false);
        this.doByteBufferRead(CIPHER_OPENSSL_JNA, true);
    }

    @Override
    @Test(timeout=120000L)
    public void testByteBufferWrite() throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.doByteBufferWrite(CIPHER_OPENSSL_JNA, baos, false);
        this.doByteBufferWrite(CIPHER_OPENSSL_JNA, baos, true);
    }

    @Override
    @Test
    public void testReadWrite() throws Exception {
        this.doReadWriteTest(0, CIPHER_OPENSSL_JNA, CIPHER_OPENSSL_JNA, this.iv);
        this.doReadWriteTest(this.count, CIPHER_OPENSSL_JNA, CIPHER_OPENSSL_JNA, this.iv);
        this.doReadWriteTest(this.count, AbstractCipherTest.JCE_CIPHER_CLASSNAME, CIPHER_OPENSSL_JNA, this.iv);
        this.doReadWriteTest(this.count, CIPHER_OPENSSL_JNA, AbstractCipherTest.JCE_CIPHER_CLASSNAME, this.iv);
        for (int i = 0; i < 8; ++i) {
            this.iv[8 + i] = -1;
        }
        this.doReadWriteTest(this.count, CIPHER_OPENSSL_JNA, CIPHER_OPENSSL_JNA, this.iv);
        this.doReadWriteTest(this.count, AbstractCipherTest.JCE_CIPHER_CLASSNAME, CIPHER_OPENSSL_JNA, this.iv);
        this.doReadWriteTest(this.count, CIPHER_OPENSSL_JNA, AbstractCipherTest.JCE_CIPHER_CLASSNAME, this.iv);
    }
}

