/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.crypto.random;

import java.io.FileNotFoundException;
import java.lang.reflect.InvocationTargetException;
import java.security.GeneralSecurityException;
import java.util.Properties;
import org.apache.commons.crypto.random.AbstractRandomTest;
import org.apache.commons.crypto.random.CryptoRandom;
import org.apache.commons.crypto.random.CryptoRandomFactory;
import org.apache.commons.crypto.random.OsCryptoRandom;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class OsCryptoRandomTest
extends AbstractRandomTest {
    @Override
    public CryptoRandom getCryptoRandom() throws GeneralSecurityException {
        Assume.assumeTrue((!System.getProperty("os.name").contains("Windows") ? 1 : 0) != 0);
        Properties props = new Properties();
        props.setProperty("commons.crypto.secure.random.classes", OsCryptoRandom.class.getName());
        CryptoRandom random = CryptoRandomFactory.getCryptoRandom((Properties)props);
        if (!(random instanceof OsCryptoRandom)) {
            Assert.fail((String)("The CryptoRandom should be: " + OsCryptoRandom.class.getName()));
        }
        return random;
    }

    @Test
    public void testInvalidRansom() {
        Properties props = new Properties();
        props.setProperty("commons.crypto.secure.random.classes", OsCryptoRandom.class.getName());
        props.setProperty("commons.crypto.secure.random.device.file.path", "");
        try {
            CryptoRandomFactory.getCryptoRandom((Properties)props);
            Assert.fail((String)"Expected GeneralSecurityException");
        }
        catch (GeneralSecurityException e) {
            Throwable cause = e.getCause();
            Assert.assertEquals(RuntimeException.class, cause.getClass());
            cause = cause.getCause();
            Assert.assertEquals(InvocationTargetException.class, cause.getClass());
            cause = cause.getCause();
            Assert.assertEquals(RuntimeException.class, cause.getClass());
            cause = cause.getCause();
            Assert.assertEquals(FileNotFoundException.class, cause.getClass());
        }
    }
}

