/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.crypto.stream;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.security.Key;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Properties;
import java.util.Random;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.crypto.Crypto;
import org.apache.commons.crypto.cipher.AbstractCipherTest;
import org.apache.commons.crypto.cipher.CryptoCipher;
import org.apache.commons.crypto.stream.CryptoInputStream;
import org.apache.commons.crypto.stream.CryptoOutputStream;
import org.apache.commons.crypto.utils.ReflectionUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractCipherStreamTest {
    private final int dataLen = 20000;
    private byte[] data = new byte[20000];
    private byte[] encData;
    private Properties props = new Properties();
    protected byte[] key = new byte[16];
    protected byte[] iv = new byte[16];
    protected int count = 10000;
    protected static int defaultBufferSize = 8192;
    protected static int smallBufferSize = 1024;
    protected String transformation;

    public abstract void setUp() throws IOException;

    @Before
    public void before() throws IOException {
        SecureRandom random = new SecureRandom();
        ((Random)random).nextBytes(this.data);
        ((Random)random).nextBytes(this.key);
        ((Random)random).nextBytes(this.iv);
        this.setUp();
        this.prepareData();
    }

    @Test(timeout=120000L)
    public void testSkip() throws Exception {
        this.doSkipTest(AbstractCipherTest.JCE_CIPHER_CLASSNAME, false);
        this.doSkipTest(AbstractCipherTest.OPENSSL_CIPHER_CLASSNAME, false);
        this.doSkipTest(AbstractCipherTest.JCE_CIPHER_CLASSNAME, true);
        this.doSkipTest(AbstractCipherTest.OPENSSL_CIPHER_CLASSNAME, true);
    }

    @Test(timeout=120000L)
    public void testByteBufferRead() throws Exception {
        this.doByteBufferRead(AbstractCipherTest.JCE_CIPHER_CLASSNAME, false);
        this.doByteBufferRead(AbstractCipherTest.OPENSSL_CIPHER_CLASSNAME, false);
        this.doByteBufferRead(AbstractCipherTest.JCE_CIPHER_CLASSNAME, true);
        this.doByteBufferRead(AbstractCipherTest.OPENSSL_CIPHER_CLASSNAME, true);
    }

    @Test(timeout=120000L)
    public void testByteBufferWrite() throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.doByteBufferWrite(AbstractCipherTest.JCE_CIPHER_CLASSNAME, baos, false);
        this.doByteBufferWrite(AbstractCipherTest.OPENSSL_CIPHER_CLASSNAME, baos, false);
        this.doByteBufferWrite(AbstractCipherTest.JCE_CIPHER_CLASSNAME, baos, true);
        this.doByteBufferWrite(AbstractCipherTest.OPENSSL_CIPHER_CLASSNAME, baos, true);
    }

    protected void doSkipTest(String cipherClass, boolean withChannel) throws IOException {
        if (AbstractCipherTest.OPENSSL_CIPHER_CLASSNAME.equals(cipherClass) && !Crypto.isNativeCodeLoaded()) {
            return;
        }
        try (CryptoInputStream in = this.getCryptoInputStream(new ByteArrayInputStream(this.encData), this.getCipher(cipherClass), defaultBufferSize, this.iv, withChannel);){
            byte[] result = new byte[20000];
            int n1 = this.readAll((InputStream)in, result, 0, 6666);
            long skipped = in.skip(6666L);
            int n2 = this.readAll((InputStream)in, result, 0, 20000);
            Assert.assertEquals((long)20000L, (long)((long)n1 + skipped + (long)n2));
            byte[] readData = new byte[n2];
            System.arraycopy(result, 0, readData, 0, n2);
            byte[] expectedData = new byte[n2];
            System.arraycopy(this.data, 20000 - n2, expectedData, 0, n2);
            Assert.assertArrayEquals((byte[])readData, (byte[])expectedData);
            try {
                skipped = in.skip(-3L);
                Assert.fail((String)"Skip Negative length should fail.");
            }
            catch (IllegalArgumentException e) {
                Assert.assertTrue((boolean)e.getMessage().contains("Negative skip length"));
            }
            skipped = in.skip(3L);
            Assert.assertEquals((long)skipped, (long)0L);
        }
    }

    protected void doByteBufferRead(String cipherClass, boolean withChannel) throws Exception {
        if (AbstractCipherTest.OPENSSL_CIPHER_CLASSNAME.equals(cipherClass) && !Crypto.isNativeCodeLoaded()) {
            return;
        }
        CryptoInputStream in = this.getCryptoInputStream(new ByteArrayInputStream(this.encData), this.getCipher(cipherClass), defaultBufferSize, this.iv, withChannel);
        ByteBuffer buf = ByteBuffer.allocate(20100);
        this.byteBufferReadCheck((InputStream)in, buf, 0);
        in.close();
        in = this.getCryptoInputStream(new ByteArrayInputStream(this.encData), this.getCipher(cipherClass), defaultBufferSize, this.iv, withChannel);
        buf.clear();
        this.byteBufferReadCheck((InputStream)in, buf, 11);
        in.close();
        in = this.getCryptoInputStream(new ByteArrayInputStream(this.encData), this.getCipher(cipherClass), smallBufferSize, this.iv, withChannel);
        buf.clear();
        this.byteBufferReadCheck((InputStream)in, buf, 0);
        in.close();
        in = this.getCryptoInputStream(new ByteArrayInputStream(this.encData), this.getCipher(cipherClass), smallBufferSize, this.iv, withChannel);
        buf.clear();
        this.byteBufferReadCheck((InputStream)in, buf, 11);
        in.close();
        in = this.getCryptoInputStream(new ByteArrayInputStream(this.encData), this.getCipher(cipherClass), defaultBufferSize, this.iv, withChannel);
        buf = ByteBuffer.allocateDirect(20100);
        this.byteBufferReadCheck((InputStream)in, buf, 0);
        in.close();
        in = this.getCryptoInputStream(new ByteArrayInputStream(this.encData), this.getCipher(cipherClass), defaultBufferSize, this.iv, withChannel);
        buf.clear();
        this.byteBufferReadCheck((InputStream)in, buf, 11);
        in.close();
        in = this.getCryptoInputStream(new ByteArrayInputStream(this.encData), this.getCipher(cipherClass), smallBufferSize, this.iv, withChannel);
        buf.clear();
        this.byteBufferReadCheck((InputStream)in, buf, 0);
        in.close();
        in = this.getCryptoInputStream(new ByteArrayInputStream(this.encData), this.getCipher(cipherClass), smallBufferSize, this.iv, withChannel);
        buf.clear();
        this.byteBufferReadCheck((InputStream)in, buf, 11);
        in.close();
    }

    protected void doByteBufferWrite(String cipherClass, ByteArrayOutputStream baos, boolean withChannel) throws Exception {
        if (AbstractCipherTest.OPENSSL_CIPHER_CLASSNAME.equals(cipherClass) && !Crypto.isNativeCodeLoaded()) {
            return;
        }
        baos.reset();
        CryptoOutputStream out = this.getCryptoOutputStream(baos, this.getCipher(cipherClass), defaultBufferSize, this.iv, withChannel);
        ByteBuffer buf = ByteBuffer.allocateDirect(10000);
        buf.put(this.data, 0, 10000);
        buf.flip();
        int n1 = out.write(buf);
        buf.clear();
        buf.put(this.data, n1, 6666);
        buf.flip();
        int n2 = out.write(buf);
        buf.clear();
        buf.put(this.data, n1 + n2, 20000 - n1 - n2);
        buf.flip();
        int n3 = out.write(buf);
        Assert.assertEquals((long)20000L, (long)(n1 + n2 + n3));
        out.flush();
        try (CryptoInputStream in = this.getCryptoInputStream(new ByteArrayInputStream(this.encData), this.getCipher(cipherClass), defaultBufferSize, this.iv, withChannel);){
            buf = ByteBuffer.allocate(20100);
            this.byteBufferReadCheck((InputStream)in, buf, 0);
        }
    }

    private void byteBufferReadCheck(InputStream in, ByteBuffer buf, int bufPos) throws Exception {
        buf.position(bufPos);
        int n = ((ReadableByteChannel)((Object)in)).read(buf);
        Assert.assertEquals((long)(bufPos + n), (long)buf.position());
        byte[] readData = new byte[n];
        buf.rewind();
        buf.position(bufPos);
        buf.get(readData);
        byte[] expectedData = new byte[n];
        System.arraycopy(this.data, 0, expectedData, 0, n);
        Assert.assertArrayEquals((byte[])readData, (byte[])expectedData);
    }

    private void prepareData() throws IOException {
        CryptoCipher cipher = null;
        try {
            cipher = (CryptoCipher)ReflectionUtils.newInstance((Class)ReflectionUtils.getClassByName((String)AbstractCipherTest.JCE_CIPHER_CLASSNAME), (Object[])new Object[]{this.props, this.transformation});
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException("Illegal crypto cipher!");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (CryptoOutputStream out = new CryptoOutputStream((OutputStream)baos, cipher, defaultBufferSize, (Key)new SecretKeySpec(this.key, "AES"), (AlgorithmParameterSpec)new IvParameterSpec(this.iv));){
            out.write(this.data);
            out.flush();
        }
        this.encData = baos.toByteArray();
    }

    protected CryptoInputStream getCryptoInputStream(ByteArrayInputStream bais, CryptoCipher cipher, int bufferSize, byte[] iv, boolean withChannel) throws IOException {
        if (withChannel) {
            return new CryptoInputStream(Channels.newChannel(bais), cipher, bufferSize, (Key)new SecretKeySpec(this.key, "AES"), (AlgorithmParameterSpec)new IvParameterSpec(iv));
        }
        return new CryptoInputStream((InputStream)bais, cipher, bufferSize, (Key)new SecretKeySpec(this.key, "AES"), (AlgorithmParameterSpec)new IvParameterSpec(iv));
    }

    protected CryptoOutputStream getCryptoOutputStream(ByteArrayOutputStream baos, CryptoCipher cipher, int bufferSize, byte[] iv, boolean withChannel) throws IOException {
        if (withChannel) {
            return new CryptoOutputStream(Channels.newChannel(baos), cipher, bufferSize, (Key)new SecretKeySpec(this.key, "AES"), (AlgorithmParameterSpec)new IvParameterSpec(iv));
        }
        return new CryptoOutputStream((OutputStream)baos, cipher, bufferSize, (Key)new SecretKeySpec(this.key, "AES"), (AlgorithmParameterSpec)new IvParameterSpec(iv));
    }

    private int readAll(InputStream in, byte[] b, int offset, int len) throws IOException {
        int n = 0;
        int total = 0;
        while (n != -1 && (total += n) < len) {
            n = in.read(b, offset + total, len - total);
        }
        return total;
    }

    protected CryptoCipher getCipher(String cipherClass) throws IOException {
        try {
            return (CryptoCipher)ReflectionUtils.newInstance((Class)ReflectionUtils.getClassByName((String)cipherClass), (Object[])new Object[]{this.props, this.transformation});
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException("Illegal crypto cipher!");
        }
    }

    @Test
    public void testReadWrite() throws Exception {
        this.doReadWriteTest(0, AbstractCipherTest.JCE_CIPHER_CLASSNAME, AbstractCipherTest.JCE_CIPHER_CLASSNAME, this.iv);
        this.doReadWriteTest(0, AbstractCipherTest.OPENSSL_CIPHER_CLASSNAME, AbstractCipherTest.OPENSSL_CIPHER_CLASSNAME, this.iv);
        this.doReadWriteTest(this.count, AbstractCipherTest.JCE_CIPHER_CLASSNAME, AbstractCipherTest.JCE_CIPHER_CLASSNAME, this.iv);
        this.doReadWriteTest(this.count, AbstractCipherTest.OPENSSL_CIPHER_CLASSNAME, AbstractCipherTest.OPENSSL_CIPHER_CLASSNAME, this.iv);
        this.doReadWriteTest(this.count, AbstractCipherTest.JCE_CIPHER_CLASSNAME, AbstractCipherTest.OPENSSL_CIPHER_CLASSNAME, this.iv);
        this.doReadWriteTest(this.count, AbstractCipherTest.OPENSSL_CIPHER_CLASSNAME, AbstractCipherTest.JCE_CIPHER_CLASSNAME, this.iv);
        for (int i = 0; i < 8; ++i) {
            this.iv[8 + i] = -1;
        }
        this.doReadWriteTest(this.count, AbstractCipherTest.JCE_CIPHER_CLASSNAME, AbstractCipherTest.JCE_CIPHER_CLASSNAME, this.iv);
        this.doReadWriteTest(this.count, AbstractCipherTest.OPENSSL_CIPHER_CLASSNAME, AbstractCipherTest.OPENSSL_CIPHER_CLASSNAME, this.iv);
        this.doReadWriteTest(this.count, AbstractCipherTest.JCE_CIPHER_CLASSNAME, AbstractCipherTest.OPENSSL_CIPHER_CLASSNAME, this.iv);
        this.doReadWriteTest(this.count, AbstractCipherTest.OPENSSL_CIPHER_CLASSNAME, AbstractCipherTest.JCE_CIPHER_CLASSNAME, this.iv);
    }

    protected void doReadWriteTest(int count, String encCipherClass, String decCipherClass, byte[] iv) throws IOException {
        this.doReadWriteTestForInputStream(count, encCipherClass, decCipherClass, iv);
        this.doReadWriteTestForReadableByteChannel(count, encCipherClass, decCipherClass, iv);
    }

    private void doReadWriteTestForInputStream(int count, String encCipherClass, String decCipherClass, byte[] iv) throws IOException {
        int expected;
        if ((AbstractCipherTest.OPENSSL_CIPHER_CLASSNAME.equals(encCipherClass) || AbstractCipherTest.OPENSSL_CIPHER_CLASSNAME.equals(decCipherClass)) && !Crypto.isNativeCodeLoaded()) {
            return;
        }
        CryptoCipher encCipher = this.getCipher(encCipherClass);
        SecureRandom random = new SecureRandom();
        byte[] originalData = new byte[count];
        byte[] decryptedData = new byte[count];
        random.nextBytes(originalData);
        ByteArrayOutputStream encryptedData = new ByteArrayOutputStream();
        try (CryptoOutputStream out = this.getCryptoOutputStream(encryptedData, encCipher, defaultBufferSize, iv, false);){
            out.write(originalData, 0, originalData.length);
            out.flush();
        }
        CryptoCipher decCipher = this.getCipher(decCipherClass);
        CryptoInputStream in = this.getCryptoInputStream(new ByteArrayInputStream(encryptedData.toByteArray()), decCipher, defaultBufferSize, iv, false);
        int remainingToRead = count;
        int offset = 0;
        while (remainingToRead > 0) {
            int n = in.read(decryptedData, offset, decryptedData.length - offset);
            if (n < 0) continue;
            remainingToRead -= n;
            offset += n;
        }
        Assert.assertArrayEquals((String)"originalData and decryptedData not equal", (byte[])originalData, (byte[])decryptedData);
        in = this.getCryptoInputStream(new ByteArrayInputStream(encryptedData.toByteArray()), decCipher, defaultBufferSize, iv, false);
        DataInputStream originalIn = new DataInputStream(new BufferedInputStream(new ByteArrayInputStream(originalData)));
        do {
            expected = originalIn.read();
            Assert.assertEquals((String)"Decrypted stream read by byte does not match", (long)expected, (long)in.read());
        } while (expected != -1);
    }

    private void doReadWriteTestForReadableByteChannel(int count, String encCipherClass, String decCipherClass, byte[] iv) throws IOException {
        int expected;
        if ((AbstractCipherTest.OPENSSL_CIPHER_CLASSNAME.equals(encCipherClass) || AbstractCipherTest.OPENSSL_CIPHER_CLASSNAME.equals(decCipherClass)) && !Crypto.isNativeCodeLoaded()) {
            return;
        }
        CryptoCipher encCipher = this.getCipher(encCipherClass);
        SecureRandom random = new SecureRandom();
        byte[] originalData = new byte[count];
        byte[] decryptedData = new byte[count];
        random.nextBytes(originalData);
        ByteArrayOutputStream encryptedData = new ByteArrayOutputStream();
        try (CryptoOutputStream out = this.getCryptoOutputStream(encryptedData, encCipher, defaultBufferSize, iv, true);){
            out.write(originalData, 0, originalData.length);
            out.flush();
        }
        CryptoCipher decCipher = this.getCipher(decCipherClass);
        CryptoInputStream in = this.getCryptoInputStream(new ByteArrayInputStream(encryptedData.toByteArray()), decCipher, defaultBufferSize, iv, true);
        int remainingToRead = count;
        int offset = 0;
        while (remainingToRead > 0) {
            int n = in.read(decryptedData, offset, decryptedData.length - offset);
            if (n < 0) continue;
            remainingToRead -= n;
            offset += n;
        }
        Assert.assertArrayEquals((String)"originalData and decryptedData not equal", (byte[])originalData, (byte[])decryptedData);
        in = this.getCryptoInputStream(new ByteArrayInputStream(encryptedData.toByteArray()), decCipher, defaultBufferSize, iv, true);
        DataInputStream originalIn = new DataInputStream(new BufferedInputStream(new ByteArrayInputStream(originalData)));
        do {
            expected = originalIn.read();
            Assert.assertEquals((String)"Decrypted stream read by byte does not match", (long)expected, (long)in.read());
        } while (expected != -1);
    }
}

