/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.crypto.stream;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channels;
import org.apache.commons.crypto.cipher.CryptoCipher;
import org.apache.commons.crypto.stream.AbstractCipherStreamTest;
import org.apache.commons.crypto.stream.CtrCryptoInputStream;
import org.apache.commons.crypto.stream.CtrCryptoOutputStream;

public class CtrCryptoStreamTest
extends AbstractCipherStreamTest {
    @Override
    public void setUp() throws IOException {
        this.transformation = "AES/CTR/NoPadding";
    }

    protected CtrCryptoInputStream getCryptoInputStream(ByteArrayInputStream bais, CryptoCipher cipher, int bufferSize, byte[] iv, boolean withChannel) throws IOException {
        if (withChannel) {
            return new CtrCryptoInputStream(Channels.newChannel(bais), cipher, bufferSize, this.key, iv);
        }
        return new CtrCryptoInputStream((InputStream)bais, cipher, bufferSize, this.key, iv);
    }

    protected CtrCryptoOutputStream getCryptoOutputStream(ByteArrayOutputStream baos, CryptoCipher cipher, int bufferSize, byte[] iv, boolean withChannel) throws IOException {
        if (withChannel) {
            return new CtrCryptoOutputStream(Channels.newChannel(baos), cipher, bufferSize, this.key, iv);
        }
        return new CtrCryptoOutputStream((OutputStream)baos, cipher, bufferSize, this.key, iv);
    }
}

