/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.crypto.stream;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.security.Key;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import java.util.Properties;
import java.util.Random;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.crypto.Crypto;
import org.apache.commons.crypto.cipher.AbstractCipherTest;
import org.apache.commons.crypto.cipher.CryptoCipher;
import org.apache.commons.crypto.stream.CryptoOutputStream;
import org.apache.commons.crypto.stream.PositionedCryptoInputStream;
import org.apache.commons.crypto.stream.input.Input;
import org.apache.commons.crypto.utils.ReflectionUtils;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class PositionedCryptoInputStreamTest {
    private final int dataLen = 20000;
    private byte[] testData = new byte[20000];
    private byte[] encData;
    private Properties props = new Properties();
    private byte[] key = new byte[16];
    private byte[] iv = new byte[16];
    int bufferSize = 2048;
    int bufferSizeLess = this.bufferSize - 1;
    int bufferSizeMore = this.bufferSize + 1;
    int length = 1024;
    int lengthLess = this.length - 1;
    int lengthMore = this.length + 1;
    private String transformation = "AES/CTR/NoPadding";

    @Before
    public void before() throws IOException {
        SecureRandom random = new SecureRandom();
        ((Random)random).nextBytes(this.testData);
        ((Random)random).nextBytes(this.key);
        ((Random)random).nextBytes(this.iv);
        this.prepareData();
    }

    private void prepareData() throws IOException {
        CryptoCipher cipher = null;
        try {
            cipher = (CryptoCipher)ReflectionUtils.newInstance((Class)ReflectionUtils.getClassByName((String)AbstractCipherTest.JCE_CIPHER_CLASSNAME), (Object[])new Object[]{this.props, this.transformation});
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException("Illegal crypto cipher!");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        CryptoOutputStream out = new CryptoOutputStream((OutputStream)baos, cipher, this.bufferSize, (Key)new SecretKeySpec(this.key, "AES"), (AlgorithmParameterSpec)new IvParameterSpec(this.iv));
        out.write(this.testData);
        out.flush();
        out.close();
        this.encData = baos.toByteArray();
    }

    private PositionedCryptoInputStream getCryptoInputStream(CryptoCipher cipher, int bufferSize) throws IOException {
        return new PositionedCryptoInputStream(this.props, (Input)new PositionedInputForTest(Arrays.copyOf(this.encData, this.encData.length)), cipher, bufferSize, this.key, this.iv, 0L);
    }

    @Test
    public void doTestJCE() throws Exception {
        this.testCipher(AbstractCipherTest.JCE_CIPHER_CLASSNAME);
    }

    @Test
    public void doTestJNI() throws Exception {
        Assume.assumeTrue((boolean)Crypto.isNativeCodeLoaded());
        this.testCipher(AbstractCipherTest.OPENSSL_CIPHER_CLASSNAME);
    }

    protected void testCipher(String cipherClass) throws Exception {
        this.doPositionedReadTests(cipherClass);
        this.doReadFullyTests(cipherClass);
        this.doSeekTests(cipherClass);
        this.doMultipleReadTest(cipherClass);
    }

    private void doMultipleReadTest(String cipherClass) throws Exception {
        try (PositionedCryptoInputStream in = this.getCryptoInputStream(this.getCipher(cipherClass), this.bufferSize);){
            int position = 0;
            while (in.available() > 0) {
                ByteBuffer buf = ByteBuffer.allocate(this.length);
                byte[] bytes1 = new byte[this.length];
                byte[] bytes2 = new byte[this.lengthLess];
                int pn1 = in.read((long)position, bytes1, 0, this.length);
                int n = in.read(buf);
                int pn2 = in.read((long)position, bytes2, 0, this.lengthLess);
                if (pn1 > 0) {
                    this.compareByteArray(this.testData, position, bytes1, pn1);
                }
                if (pn2 > 0) {
                    this.compareByteArray(this.testData, position, bytes2, pn2);
                }
                if (n > 0) {
                    this.compareByteArray(this.testData, position, buf.array(), n);
                    position += n;
                    continue;
                }
                break;
            }
        }
    }

    private void doPositionedReadTests(String cipherClass) throws Exception {
        this.testPositionedReadLoop(cipherClass, 0, this.length, this.bufferSize, 20000);
        this.testPositionedReadLoop(cipherClass, 0, this.length, this.bufferSizeLess, 20000);
        this.testPositionedReadLoop(cipherClass, 0, this.length, this.bufferSizeMore, 20000);
        this.testPositionedReadLoop(cipherClass, 10000, this.length, this.bufferSize, 20000);
        this.testPositionedReadLoop(cipherClass, 9999, this.length, this.bufferSizeLess, 20000);
        this.testPositionedReadLoop(cipherClass, 10001, this.length, this.bufferSizeMore, 20000);
        this.testPositionedReadNone(cipherClass, -1, this.length, this.bufferSize);
        this.testPositionedReadNone(cipherClass, 20000, this.length, this.bufferSize);
    }

    private void doReadFullyTests(String cipherClass) throws Exception {
        this.testReadFullyLoop(cipherClass, 0, this.length, this.bufferSize, 20000);
        this.testReadFullyLoop(cipherClass, 0, this.length, this.bufferSizeLess, 20000);
        this.testReadFullyLoop(cipherClass, 0, this.length, this.bufferSizeMore, 20000);
        this.testReadFullyLoop(cipherClass, 0, this.length, this.bufferSize, 20000);
        this.testReadFullyLoop(cipherClass, 0, this.lengthLess, this.bufferSize, 20000);
        this.testReadFullyLoop(cipherClass, 0, this.lengthMore, this.bufferSize, 20000);
        this.testReadFullyFailed(cipherClass, -1, this.length, this.bufferSize);
        this.testReadFullyFailed(cipherClass, 20000, this.length, this.bufferSize);
        this.testReadFullyFailed(cipherClass, 20000 - this.length + 1, this.length, this.bufferSize);
    }

    private void doSeekTests(String cipherClass) throws Exception {
        this.testSeekLoop(cipherClass, 0, this.length, this.bufferSize);
        this.testSeekLoop(cipherClass, 0, this.lengthLess, this.bufferSize);
        this.testSeekLoop(cipherClass, 0, this.lengthMore, this.bufferSize);
        this.testSeekLoop(cipherClass, 20000, this.length, this.bufferSize);
        this.testSeekFailed(cipherClass, -1, this.bufferSize);
    }

    private void testSeekLoop(String cipherClass, int position, int length, int bufferSize) throws Exception {
        try (PositionedCryptoInputStream in = this.getCryptoInputStream(this.getCipher(cipherClass), bufferSize);){
            while (in.available() > 0) {
                in.seek((long)position);
                ByteBuffer buf = ByteBuffer.allocate(length);
                int n = in.read(buf);
                if (n > 0) {
                    this.compareByteArray(this.testData, position, buf.array(), n);
                    position += n;
                    continue;
                }
                break;
            }
        }
    }

    private void testSeekFailed(String cipherClass, int position, int bufferSize) throws Exception {
        PositionedCryptoInputStream in = this.getCryptoInputStream(this.getCipher(cipherClass), bufferSize);
        try {
            in.seek((long)position);
            Assert.fail((String)"Excepted exception for cannot seek to negative offset.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        in.close();
    }

    private void testPositionedReadLoop(String cipherClass, int position, int length, int bufferSize, int total) throws Exception {
        try (PositionedCryptoInputStream in = this.getCryptoInputStream(this.getCipher(cipherClass), bufferSize);){
            byte[] bytes;
            int n;
            while (position < total && (n = in.read((long)position, bytes = new byte[length], 0, length)) >= 0) {
                this.compareByteArray(this.testData, position, bytes, n);
                position += n;
            }
        }
    }

    private void testPositionedReadNone(String cipherClass, int position, int length, int bufferSize) throws Exception {
        try (PositionedCryptoInputStream in = this.getCryptoInputStream(this.getCipher(cipherClass), bufferSize);){
            byte[] bytes = new byte[length];
            int n = in.read((long)position, bytes, 0, length);
            Assert.assertEquals((long)n, (long)-1L);
        }
    }

    private void testReadFullyLoop(String cipherClass, int position, int length, int bufferSize, int total) throws Exception {
        try (PositionedCryptoInputStream in = this.getCryptoInputStream(this.getCipher(cipherClass), bufferSize);){
            while (position + length <= total) {
                byte[] bytes = new byte[length];
                in.readFully((long)position, bytes, 0, length);
                this.compareByteArray(this.testData, position, bytes, length);
                position += length;
            }
        }
    }

    private void testReadFullyFailed(String cipherClass, int position, int length, int bufferSize) throws Exception {
        PositionedCryptoInputStream in = this.getCryptoInputStream(this.getCipher(cipherClass), bufferSize);
        byte[] bytes = new byte[length];
        try {
            in.readFully((long)position, bytes, 0, length);
            Assert.fail((String)"Excepted EOFException.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        in.close();
    }

    private void compareByteArray(byte[] data1, int pos, byte[] data2, int length) {
        byte[] expectedData = new byte[length];
        byte[] realData = new byte[length];
        System.arraycopy(data1, pos, expectedData, 0, length);
        System.arraycopy(data2, 0, realData, 0, length);
        Assert.assertArrayEquals((byte[])expectedData, (byte[])realData);
    }

    private CryptoCipher getCipher(String cipherClass) throws IOException {
        try {
            return (CryptoCipher)ReflectionUtils.newInstance((Class)ReflectionUtils.getClassByName((String)cipherClass), (Object[])new Object[]{this.props, this.transformation});
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException("Illegal crypto cipher!");
        }
    }

    class PositionedInputForTest
    implements Input {
        byte[] data;
        long pos;
        long count;

        public PositionedInputForTest(byte[] data) {
            this.data = data;
            this.pos = 0L;
            this.count = data.length;
        }

        public int read(ByteBuffer dst) throws IOException {
            int remaining = (int)(this.count - this.pos);
            if (remaining <= 0) {
                return -1;
            }
            int length = Math.min(dst.remaining(), remaining);
            dst.put(this.data, (int)this.pos, length);
            this.pos += (long)length;
            return length;
        }

        public long skip(long n) throws IOException {
            if (n <= 0L) {
                return 0L;
            }
            long remaining = this.count - this.pos;
            if (remaining < n) {
                n = remaining;
            }
            this.pos += n;
            return n;
        }

        public int read(long position, byte[] buffer, int offset, int length) throws IOException {
            if (buffer == null) {
                throw new NullPointerException();
            }
            if (offset < 0 || length < 0 || length > buffer.length - offset) {
                throw new IndexOutOfBoundsException();
            }
            if (position < 0L || position >= this.count) {
                return -1;
            }
            long avail = this.count - position;
            if ((long)length > avail) {
                length = (int)avail;
            }
            if (length <= 0) {
                return 0;
            }
            System.arraycopy(this.data, (int)position, buffer, offset, length);
            return length;
        }

        public void seek(long position) throws IOException {
            if (this.pos < 0L) {
                throw new IOException("Negative seek offset");
            }
            this.pos = position >= 0L && position < this.count ? position : this.count;
        }

        public void close() throws IOException {
        }

        public int available() throws IOException {
            return (int)(this.count - this.pos);
        }
    }
}

