/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2;

import java.util.Properties;
import junit.framework.TestCase;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.dbcp2.BasicDataSourceFactory;

public class TestBasicDataSourceFactory
extends TestCase {
    public TestBasicDataSourceFactory(String testName) {
        super(testName);
    }

    public void testNoProperties() throws Exception {
        Properties properties = new Properties();
        BasicDataSource ds = BasicDataSourceFactory.createDataSource((Properties)properties);
        TestBasicDataSourceFactory.assertNotNull((Object)ds);
    }

    public void testProperties() throws Exception {
        Properties properties = new Properties();
        properties.setProperty("driverClassName", "org.apache.commons.dbcp2.TesterDriver");
        properties.setProperty("url", "jdbc:apache:commons:testdriver");
        properties.setProperty("maxTotal", "10");
        properties.setProperty("maxIdle", "8");
        properties.setProperty("minIdle", "0");
        properties.setProperty("maxWaitMillis", "500");
        properties.setProperty("initialSize", "5");
        properties.setProperty("defaultAutoCommit", "true");
        properties.setProperty("defaultReadOnly", "false");
        properties.setProperty("defaultTransactionIsolation", "READ_COMMITTED");
        properties.setProperty("defaultCatalog", "test");
        properties.setProperty("testOnBorrow", "true");
        properties.setProperty("testOnReturn", "false");
        properties.setProperty("username", "username");
        properties.setProperty("password", "password");
        properties.setProperty("validationQuery", "SELECT DUMMY FROM DUAL");
        properties.setProperty("validationQueryTimeout", "100");
        properties.setProperty("connectionInitSqls", "SELECT 1;SELECT 2");
        properties.setProperty("timeBetweenEvictionRunsMillis", "1000");
        properties.setProperty("minEvictableIdleTimeMillis", "2000");
        properties.setProperty("softMinEvictableIdleTimeMillis", "3000");
        properties.setProperty("numTestsPerEvictionRun", "2");
        properties.setProperty("testWhileIdle", "true");
        properties.setProperty("accessToUnderlyingConnectionAllowed", "true");
        properties.setProperty("removeAbandoned", "true");
        properties.setProperty("removeAbandonedTimeout", "3000");
        properties.setProperty("logAbandoned", "true");
        properties.setProperty("poolPreparedStatements", "true");
        properties.setProperty("maxOpenPreparedStatements", "10");
        properties.setProperty("lifo", "true");
        BasicDataSource ds = BasicDataSourceFactory.createDataSource((Properties)properties);
        TestBasicDataSourceFactory.assertEquals((String)"org.apache.commons.dbcp2.TesterDriver", (String)ds.getDriverClassName());
        TestBasicDataSourceFactory.assertEquals((String)"jdbc:apache:commons:testdriver", (String)ds.getUrl());
        TestBasicDataSourceFactory.assertEquals((int)10, (int)ds.getMaxTotal());
        TestBasicDataSourceFactory.assertEquals((int)8, (int)ds.getMaxIdle());
        TestBasicDataSourceFactory.assertEquals((int)0, (int)ds.getMinIdle());
        TestBasicDataSourceFactory.assertEquals((long)500L, (long)ds.getMaxWaitMillis());
        TestBasicDataSourceFactory.assertEquals((int)5, (int)ds.getInitialSize());
        TestBasicDataSourceFactory.assertEquals((int)5, (int)ds.getNumIdle());
        TestBasicDataSourceFactory.assertEquals((Object)Boolean.TRUE, (Object)ds.getDefaultAutoCommit());
        TestBasicDataSourceFactory.assertEquals((Object)Boolean.FALSE, (Object)ds.getDefaultReadOnly());
        TestBasicDataSourceFactory.assertEquals((int)2, (int)ds.getDefaultTransactionIsolation());
        TestBasicDataSourceFactory.assertEquals((String)"test", (String)ds.getDefaultCatalog());
        TestBasicDataSourceFactory.assertEquals((boolean)true, (boolean)ds.getTestOnBorrow());
        TestBasicDataSourceFactory.assertEquals((boolean)false, (boolean)ds.getTestOnReturn());
        TestBasicDataSourceFactory.assertEquals((String)"username", (String)ds.getUsername());
        TestBasicDataSourceFactory.assertEquals((String)"password", (String)ds.getPassword());
        TestBasicDataSourceFactory.assertEquals((String)"SELECT DUMMY FROM DUAL", (String)ds.getValidationQuery());
        TestBasicDataSourceFactory.assertEquals((int)100, (int)ds.getValidationQueryTimeout());
        TestBasicDataSourceFactory.assertEquals((int)2, (int)ds.getConnectionInitSqls().size());
        TestBasicDataSourceFactory.assertEquals((String)"SELECT 1", (String)((String)ds.getConnectionInitSqls().get(0)));
        TestBasicDataSourceFactory.assertEquals((String)"SELECT 2", (String)((String)ds.getConnectionInitSqls().get(1)));
        TestBasicDataSourceFactory.assertEquals((long)1000L, (long)ds.getTimeBetweenEvictionRunsMillis());
        TestBasicDataSourceFactory.assertEquals((long)2000L, (long)ds.getMinEvictableIdleTimeMillis());
        TestBasicDataSourceFactory.assertEquals((long)3000L, (long)ds.getSoftMinEvictableIdleTimeMillis());
        TestBasicDataSourceFactory.assertEquals((int)2, (int)ds.getNumTestsPerEvictionRun());
        TestBasicDataSourceFactory.assertEquals((boolean)true, (boolean)ds.getTestWhileIdle());
        TestBasicDataSourceFactory.assertEquals((boolean)true, (boolean)ds.isAccessToUnderlyingConnectionAllowed());
        TestBasicDataSourceFactory.assertEquals((boolean)false, (boolean)ds.getRemoveAbandonedOnBorrow());
        TestBasicDataSourceFactory.assertEquals((boolean)false, (boolean)ds.getRemoveAbandonedOnMaintenance());
        TestBasicDataSourceFactory.assertEquals((int)3000, (int)ds.getRemoveAbandonedTimeout());
        TestBasicDataSourceFactory.assertEquals((boolean)true, (boolean)ds.getLogAbandoned());
        TestBasicDataSourceFactory.assertEquals((boolean)true, (boolean)ds.isPoolPreparedStatements());
        TestBasicDataSourceFactory.assertEquals((int)10, (int)ds.getMaxOpenPreparedStatements());
        TestBasicDataSourceFactory.assertEquals((boolean)true, (boolean)ds.getLifo());
    }
}

