/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2;

import java.sql.CallableStatement;
import java.sql.Connection;
import junit.framework.TestCase;
import org.apache.commons.dbcp2.DelegatingCallableStatement;
import org.apache.commons.dbcp2.DelegatingConnection;
import org.apache.commons.dbcp2.TesterCallableStatement;
import org.apache.commons.dbcp2.TesterConnection;

public class TestDelegatingCallableStatement
extends TestCase {
    private DelegatingConnection<Connection> conn = null;
    private Connection delegateConn = null;
    private DelegatingCallableStatement stmt = null;
    private CallableStatement delegateStmt = null;

    public TestDelegatingCallableStatement(String testName) {
        super(testName);
    }

    public void setUp() throws Exception {
        this.delegateConn = new TesterConnection("test", "test");
        this.conn = new DelegatingConnection(this.delegateConn);
    }

    public void testExecuteQueryReturnsNull() throws Exception {
        this.delegateStmt = new TesterCallableStatement(this.delegateConn, "null");
        this.stmt = new DelegatingCallableStatement(this.conn, this.delegateStmt);
        TestDelegatingCallableStatement.assertNull((Object)this.stmt.executeQuery());
    }

    public void testExecuteQueryReturnsNotNull() throws Exception {
        this.delegateStmt = new TesterCallableStatement(this.delegateConn, "select * from foo");
        this.stmt = new DelegatingCallableStatement(this.conn, this.delegateStmt);
        TestDelegatingCallableStatement.assertTrue((null != this.stmt.executeQuery() ? 1 : 0) != 0);
    }

    public void testGetDelegate() throws Exception {
        this.delegateStmt = new TesterCallableStatement(this.delegateConn, "select * from foo");
        this.stmt = new DelegatingCallableStatement(this.conn, this.delegateStmt);
        TestDelegatingCallableStatement.assertEquals((Object)this.delegateStmt, (Object)this.stmt.getDelegate());
    }
}

