/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2;

import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.TestCase;
import org.apache.commons.dbcp2.DelegatingConnection;
import org.apache.commons.dbcp2.DelegatingStatement;
import org.apache.commons.dbcp2.TesterConnection;
import org.apache.commons.dbcp2.TesterStatement;

public class TestDelegatingStatement
extends TestCase {
    private DelegatingConnection<Connection> conn = null;
    private Connection delegateConn = null;
    private DelegatingStatement stmt = null;
    private Statement delegateStmt = null;

    public TestDelegatingStatement(String testName) {
        super(testName);
    }

    public void setUp() throws Exception {
        this.delegateConn = new TesterConnection("test", "test");
        this.delegateStmt = new TesterStatement(this.delegateConn);
        this.conn = new DelegatingConnection(this.delegateConn);
        this.stmt = new DelegatingStatement(this.conn, this.delegateStmt);
    }

    public void testExecuteQueryReturnsNull() throws Exception {
        TestDelegatingStatement.assertNull((Object)this.stmt.executeQuery("null"));
    }

    public void testGetDelegate() throws Exception {
        TestDelegatingStatement.assertEquals((Object)this.delegateStmt, (Object)this.stmt.getDelegate());
    }

    public void testCheckOpen() throws Exception {
        this.stmt.checkOpen();
        this.stmt.close();
        try {
            this.stmt.checkOpen();
            TestDelegatingStatement.fail((String)"Expecting SQLException");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void testIsWrapperFor() throws Exception {
        TesterConnection tstConn = new TesterConnection("test", "test");
        TesterStatementNonWrapping tstStmt = new TesterStatementNonWrapping(tstConn);
        DelegatingConnection dconn = new DelegatingConnection((Connection)tstConn);
        DelegatingStatement stamt = new DelegatingStatement(dconn, (Statement)tstStmt);
        Class<?> stmtProxyClass = Proxy.getProxyClass(((Object)((Object)this)).getClass().getClassLoader(), Statement.class);
        TestDelegatingStatement.assertTrue((boolean)stamt.isWrapperFor(DelegatingStatement.class));
        TestDelegatingStatement.assertTrue((boolean)stamt.isWrapperFor(TesterStatement.class));
        TestDelegatingStatement.assertFalse((boolean)stamt.isWrapperFor(stmtProxyClass));
        stamt.close();
    }

    private static class TesterStatementNonWrapping
    extends TesterStatement {
        public TesterStatementNonWrapping(Connection conn) {
            super(conn);
        }

        @Override
        public boolean isWrapperFor(Class<?> iface) throws SQLException {
            return false;
        }
    }
}

