/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import junit.framework.TestCase;
import org.apache.commons.dbcp2.ConnectionFactory;
import org.apache.commons.dbcp2.DelegatingConnection;
import org.apache.commons.dbcp2.DriverConnectionFactory;
import org.apache.commons.dbcp2.PoolableConnection;
import org.apache.commons.dbcp2.PoolableConnectionFactory;
import org.apache.commons.dbcp2.TesterDriver;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.junit.Assert;

public class TestPoolableConnection
extends TestCase {
    private ObjectPool<PoolableConnection> pool = null;

    public TestPoolableConnection(String testName) {
        super(testName);
    }

    public void setUp() throws Exception {
        PoolableConnectionFactory factory = new PoolableConnectionFactory((ConnectionFactory)new DriverConnectionFactory((Driver)new TesterDriver(), "jdbc:apache:commons:testdriver", null), null);
        factory.setDefaultAutoCommit(Boolean.TRUE);
        factory.setDefaultReadOnly(Boolean.TRUE);
        this.pool = new GenericObjectPool((PooledObjectFactory)factory);
        factory.setPool(this.pool);
    }

    public void testConnectionPool() throws Exception {
        Connection c = (Connection)this.pool.borrowObject();
        TestPoolableConnection.assertNotNull((String)"Connection should be created and should not be null", (Object)c);
        TestPoolableConnection.assertEquals((String)"There should be exactly one active object in the pool", (int)1, (int)this.pool.getNumActive());
        c.close();
        TestPoolableConnection.assertEquals((String)"There should now be zero active objects in the pool", (int)0, (int)this.pool.getNumActive());
    }

    public void testPoolableConnectionLeak() throws Exception {
        Connection conn = (Connection)this.pool.borrowObject();
        ((PoolableConnection)conn).getInnermostDelegate().close();
        try {
            conn.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        TestPoolableConnection.assertEquals((String)"The pool should have no active connections", (int)0, (int)this.pool.getNumActive());
    }

    public void testClosingWrappedInDelegate() throws Exception {
        Assert.assertEquals((long)0L, (long)this.pool.getNumActive());
        Connection conn = (Connection)this.pool.borrowObject();
        DelegatingConnection outer = new DelegatingConnection(conn);
        Assert.assertFalse((boolean)outer.isClosed());
        Assert.assertFalse((boolean)conn.isClosed());
        Assert.assertEquals((long)1L, (long)this.pool.getNumActive());
        outer.close();
        Assert.assertTrue((boolean)outer.isClosed());
        Assert.assertTrue((boolean)conn.isClosed());
        Assert.assertEquals((long)0L, (long)this.pool.getNumActive());
        Assert.assertEquals((long)1L, (long)this.pool.getNumIdle());
    }
}

