/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2.managed;

import java.sql.Connection;
import java.sql.Driver;
import java.util.Properties;
import javax.transaction.TransactionManager;
import org.apache.commons.dbcp2.ConnectionFactory;
import org.apache.commons.dbcp2.DelegatingConnection;
import org.apache.commons.dbcp2.DriverConnectionFactory;
import org.apache.commons.dbcp2.PoolableConnection;
import org.apache.commons.dbcp2.PoolableConnectionFactory;
import org.apache.commons.dbcp2.PoolingDataSource;
import org.apache.commons.dbcp2.TestConnectionPool;
import org.apache.commons.dbcp2.TesterDriver;
import org.apache.commons.dbcp2.managed.LocalXAConnectionFactory;
import org.apache.commons.dbcp2.managed.ManagedConnection;
import org.apache.commons.dbcp2.managed.ManagedDataSource;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.geronimo.transaction.manager.TransactionManagerImpl;
import org.junit.Assert;

public class TestManagedDataSource
extends TestConnectionPool {
    protected PoolingDataSource<PoolableConnection> ds = null;
    private GenericObjectPool<PoolableConnection> pool = null;
    protected TransactionManager transactionManager;

    public TestManagedDataSource(String testName) {
        super(testName);
    }

    @Override
    protected Connection getConnection() throws Exception {
        return this.ds.getConnection();
    }

    public void setUp() throws Exception {
        super.setUp();
        this.transactionManager = new TransactionManagerImpl();
        Properties properties = new Properties();
        properties.setProperty("user", "username");
        properties.setProperty("password", "password");
        DriverConnectionFactory connectionFactory = new DriverConnectionFactory((Driver)new TesterDriver(), "jdbc:apache:commons:testdriver", properties);
        LocalXAConnectionFactory xaConnectionFactory = new LocalXAConnectionFactory(this.transactionManager, (ConnectionFactory)connectionFactory);
        PoolableConnectionFactory factory = new PoolableConnectionFactory((ConnectionFactory)xaConnectionFactory, null);
        factory.setValidationQuery("SELECT DUMMY FROM DUAL");
        factory.setDefaultReadOnly(Boolean.TRUE);
        factory.setDefaultAutoCommit(Boolean.TRUE);
        this.pool = new GenericObjectPool((PooledObjectFactory)factory);
        factory.setPool(this.pool);
        this.pool.setMaxTotal(this.getMaxTotal());
        this.pool.setMaxWaitMillis(this.getMaxWaitMillis());
        this.ds = new ManagedDataSource(this.pool, xaConnectionFactory.getTransactionRegistry());
        this.ds.setAccessToUnderlyingConnectionAllowed(true);
    }

    @Override
    public void tearDown() throws Exception {
        this.pool.close();
        super.tearDown();
    }

    public void testAccessToUnderlyingConnectionAllowed() throws Exception {
        this.ds.setAccessToUnderlyingConnectionAllowed(true);
        ManagedConnection connection = (ManagedConnection)this.newConnection();
        TestManagedDataSource.assertTrue((boolean)connection.isAccessToUnderlyingConnectionAllowed());
        TestManagedDataSource.assertNotNull((Object)connection.getDelegate());
        TestManagedDataSource.assertNotNull((Object)connection.getInnermostDelegate());
        connection.close();
        this.ds.setAccessToUnderlyingConnectionAllowed(false);
        connection = (ManagedConnection)this.newConnection();
        TestManagedDataSource.assertFalse((boolean)connection.isAccessToUnderlyingConnectionAllowed());
        TestManagedDataSource.assertNull((Object)connection.getDelegate());
        TestManagedDataSource.assertNull((Object)connection.getInnermostDelegate());
        connection.close();
    }

    public void testSharedConnection() throws Exception {
        DelegatingConnection connectionA = (DelegatingConnection)this.newConnection();
        DelegatingConnection connectionB = (DelegatingConnection)this.newConnection();
        TestManagedDataSource.assertFalse((boolean)connectionA.equals(connectionB));
        TestManagedDataSource.assertFalse((boolean)connectionB.equals(connectionA));
        TestManagedDataSource.assertFalse((boolean)connectionA.innermostDelegateEquals(connectionB.getInnermostDelegate()));
        TestManagedDataSource.assertFalse((boolean)connectionB.innermostDelegateEquals(connectionA.getInnermostDelegate()));
        connectionA.close();
        connectionB.close();
    }

    public void testConnectionReturnOnCommit() throws Exception {
        this.transactionManager.begin();
        DelegatingConnection connectionA = (DelegatingConnection)this.newConnection();
        connectionA.close();
        this.transactionManager.commit();
        TestManagedDataSource.assertEquals((long)1L, (long)this.pool.getBorrowedCount());
        TestManagedDataSource.assertEquals((long)1L, (long)this.pool.getReturnedCount());
        TestManagedDataSource.assertEquals((int)0, (int)this.pool.getNumActive());
    }

    public void testManagedConnectionEqualsSameDelegateNoUnderlyingAccess() throws Exception {
        Connection[] c = new Connection[this.getMaxTotal()];
        for (int i = 0; i < c.length; ++i) {
            c[i] = this.newConnection();
        }
        ((DelegatingConnection)c[0]).getDelegate().close();
        this.ds.setAccessToUnderlyingConnectionAllowed(false);
        Connection con = this.newConnection();
        Assert.assertNotEquals((Object)c[0], (Object)con);
        Assert.assertEquals((Object)((DelegatingConnection)c[0]).getInnermostDelegateInternal(), (Object)((DelegatingConnection)con).getInnermostDelegateInternal());
        for (Connection element : c) {
            element.close();
        }
        this.ds.setAccessToUnderlyingConnectionAllowed(true);
    }

    public void testManagedConnectionEqualsSameDelegate() throws Exception {
        Connection[] c = new Connection[this.getMaxTotal()];
        for (int i = 0; i < c.length; ++i) {
            c[i] = this.newConnection();
        }
        ((DelegatingConnection)c[0]).getDelegate().close();
        Connection con = this.newConnection();
        Assert.assertNotEquals((Object)c[0], (Object)con);
        Assert.assertEquals((Object)((DelegatingConnection)c[0]).getInnermostDelegateInternal(), (Object)((DelegatingConnection)con).getInnermostDelegateInternal());
        for (Connection element : c) {
            element.close();
        }
    }

    public void testManagedConnectionEqualsReflexive() throws Exception {
        Connection con;
        Connection con2 = con = this.ds.getConnection();
        TestManagedDataSource.assertTrue((boolean)con2.equals(con));
        TestManagedDataSource.assertTrue((boolean)con.equals(con2));
        con.close();
    }

    public void testManagedConnectionEqualsFail() throws Exception {
        Connection con1 = this.ds.getConnection();
        Connection con2 = this.ds.getConnection();
        TestManagedDataSource.assertFalse((boolean)con1.equals(con2));
        con1.close();
        con2.close();
    }

    public void testManagedConnectionEqualsNull() throws Exception {
        Connection con1 = this.ds.getConnection();
        Object con2 = null;
        TestManagedDataSource.assertFalse((boolean)con1.equals(con2));
        con1.close();
    }

    public void testManagedConnectionEqualsType() throws Exception {
        Connection con1 = this.ds.getConnection();
        Integer con2 = 0;
        TestManagedDataSource.assertFalse((boolean)con1.equals(con2));
        con1.close();
    }

    public void testManagedConnectionEqualInnermost() throws Exception {
        this.ds.setAccessToUnderlyingConnectionAllowed(true);
        DelegatingConnection con = (DelegatingConnection)this.ds.getConnection();
        Connection inner = con.getInnermostDelegate();
        this.ds.setAccessToUnderlyingConnectionAllowed(false);
        DelegatingConnection con2 = new DelegatingConnection(inner);
        TestManagedDataSource.assertFalse((boolean)con2.equals(con));
        TestManagedDataSource.assertTrue((boolean)con.innermostDelegateEquals(con2.getInnermostDelegate()));
        TestManagedDataSource.assertTrue((boolean)con2.innermostDelegateEquals(inner));
        TestManagedDataSource.assertFalse((boolean)con.equals(con2));
    }
}

