/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.Duration;
import java.util.Hashtable;
import java.util.Random;
import java.util.Stack;
import org.apache.commons.dbcp2.DelegatingConnection;
import org.apache.commons.dbcp2.Utils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class TestConnectionPool {
    private static final Duration MAX_WAIT_DURATION = Duration.ofMillis(100L);
    private static final boolean DISPLAY_THREAD_DETAILS = Boolean.getBoolean("TestConnectionPool.display.thread.details");
    private static int currentThreadCount;
    private static final String DONE = "Done";
    protected final Stack<Connection> connectionStack = new Stack();

    protected void assertBackPointers(Connection conn, Statement statement) throws SQLException {
        Assertions.assertFalse((boolean)conn.isClosed());
        Assertions.assertFalse((boolean)this.isClosed(statement));
        Assertions.assertSame((Object)conn, (Object)statement.getConnection(), (String)"statement.getConnection() should return the exact same connection instance that was used to create the statement");
        ResultSet resultSet = statement.getResultSet();
        Assertions.assertFalse((boolean)this.isClosed(resultSet));
        Assertions.assertSame((Object)statement, (Object)resultSet.getStatement(), (String)"resultSet.getStatement() should return the exact same statement instance that was used to create the result set");
        ResultSet executeResultSet = statement.executeQuery("select * from dual");
        Assertions.assertFalse((boolean)this.isClosed(executeResultSet));
        Assertions.assertSame((Object)statement, (Object)executeResultSet.getStatement(), (String)"resultSet.getStatement() should return the exact same statement instance that was used to create the result set");
        ResultSet keysResultSet = statement.getGeneratedKeys();
        Assertions.assertFalse((boolean)this.isClosed(keysResultSet));
        Assertions.assertSame((Object)statement, (Object)keysResultSet.getStatement(), (String)"resultSet.getStatement() should return the exact same statement instance that was used to create the result set");
        ResultSet preparedResultSet = null;
        if (statement instanceof PreparedStatement) {
            PreparedStatement preparedStatement = (PreparedStatement)statement;
            preparedResultSet = preparedStatement.executeQuery();
            Assertions.assertFalse((boolean)this.isClosed(preparedResultSet));
            Assertions.assertSame((Object)statement, (Object)preparedResultSet.getStatement(), (String)"resultSet.getStatement() should return the exact same statement instance that was used to create the result set");
        }
        resultSet.getStatement().getConnection().close();
        Assertions.assertTrue((boolean)conn.isClosed());
        Assertions.assertTrue((boolean)this.isClosed(statement));
        Assertions.assertTrue((boolean)this.isClosed(resultSet));
        Assertions.assertTrue((boolean)this.isClosed(executeResultSet));
        Assertions.assertTrue((boolean)this.isClosed(keysResultSet));
        if (preparedResultSet != null) {
            Assertions.assertTrue((boolean)this.isClosed(preparedResultSet));
        }
    }

    protected abstract Connection getConnection() throws Exception;

    protected int getMaxTotal() {
        return 10;
    }

    protected Duration getMaxWaitDuration() {
        return MAX_WAIT_DURATION;
    }

    protected String getUsername(Connection conn) throws SQLException {
        try (Statement stmt = conn.createStatement();
             ResultSet rs = stmt.executeQuery("select username");){
            if (rs.next()) {
                String string = rs.getString(1);
                return string;
            }
        }
        return null;
    }

    protected boolean isClosed(ResultSet resultSet) {
        try {
            resultSet.getWarnings();
            return false;
        }
        catch (SQLException e) {
            return true;
        }
    }

    protected boolean isClosed(Statement statement) {
        try {
            statement.getWarnings();
            return false;
        }
        catch (SQLException e) {
            return true;
        }
    }

    protected void multipleThreads(Duration holdDuration, boolean expectError, boolean loopOnce, Duration maxWaitDuration) throws Exception {
        this.multipleThreads(holdDuration, expectError, loopOnce, maxWaitDuration, 1, 2 * this.getMaxTotal(), 300L);
    }

    protected void multipleThreads(Duration holdDuration, boolean expectError, boolean loopOnce, Duration maxWaitDuration, int numStatements, int numThreads, long duration) throws Exception {
        long startTimeMillis = this.timeStampMillis();
        final PoolTest[] pts = new PoolTest[numThreads];
        ThreadGroup threadGroup = new ThreadGroup("foo"){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                for (PoolTest pt : pts) {
                    pt.stop();
                }
            }
        };
        for (int i = 0; i < pts.length; ++i) {
            pts[i] = new PoolTest(threadGroup, holdDuration, expectError, loopOnce, numStatements);
        }
        for (PoolTest pt : pts) {
            pt.start();
        }
        Thread.sleep(duration);
        for (PoolTest pt : pts) {
            pt.stop();
        }
        int done = 0;
        int failed = 0;
        int didNotRun = 0;
        int loops = 0;
        for (PoolTest poolTest : pts) {
            Throwable thrown;
            poolTest.thread.join();
            loops += poolTest.loops;
            String state = poolTest.state;
            if (DONE.equals(state)) {
                ++done;
            }
            if (poolTest.loops == 0) {
                ++didNotRun;
            }
            if ((thrown = poolTest.thrown) == null) continue;
            ++failed;
            if (expectError && thrown instanceof SQLException) continue;
            System.err.println("Unexpected error: " + thrown.getMessage());
        }
        long timeMillis = this.timeStampMillis() - startTimeMillis;
        this.println("Multithread test time = " + timeMillis + " ms. Threads: " + pts.length + ". Loops: " + loops + ". Hold time: " + holdDuration + ". maxWaitMillis: " + maxWaitDuration + ". Done: " + done + ". Did not run: " + didNotRun + ". Failed: " + failed + ". expectError: " + expectError);
        if (expectError) {
            if (DISPLAY_THREAD_DETAILS || pts.length / 2 != failed) {
                long offset = pts[0].createdMillis - 1000L;
                this.println("Offset: " + offset);
                for (int i = 0; i < pts.length; ++i) {
                    PoolTest pt = pts[i];
                    this.println("Pre: " + (pt.preconnected - offset) + ". Post: " + (pt.postconnected != 0L ? Long.toString(pt.postconnected - offset) : "-") + ". Hash: " + pt.connHash + ". Startup: " + (pt.started - pt.createdMillis) + ". getConn(): " + (pt.connected != 0L ? Long.toString(pt.connected - pt.preconnected) : "-") + ". Runtime: " + (pt.ended - pt.started) + ". IDX: " + i + ". Loops: " + pt.loops + ". State: " + pt.state + ". thrown: " + pt.thrown + ".");
                }
            }
            if (didNotRun > 0) {
                this.println("NOTE: some threads did not run the code: " + didNotRun);
            }
            Assertions.assertTrue((failed > 0 ? 1 : 0) != 0, (String)"Expected some of the threads to fail");
            Assertions.assertEquals((int)(pts.length / 2), (int)(failed + didNotRun), (String)"WARNING: Expected half the threads to fail");
        } else {
            Assertions.assertEquals((int)0, (int)failed, (String)"Did not expect any threads to fail");
        }
    }

    protected Connection newConnection() throws Exception {
        return this.connectionStack.push(this.getConnection());
    }

    void println(String string) {
        if (Boolean.getBoolean(this.getClass().getSimpleName() + ".debug")) {
            System.out.println(string);
        }
    }

    @AfterEach
    public void tearDown() throws Exception {
        while (!this.connectionStack.isEmpty()) {
            Utils.closeQuietly((AutoCloseable)this.connectionStack.pop());
        }
    }

    @Test
    public void testAutoCommitBehavior() throws Exception {
        Connection conn0 = this.newConnection();
        Assertions.assertNotNull((Object)conn0, (String)"connection should not be null");
        Assertions.assertTrue((boolean)conn0.getAutoCommit(), (String)"autocommit should be true for conn0");
        Connection conn1 = this.newConnection();
        Assertions.assertTrue((boolean)conn1.getAutoCommit(), (String)"autocommit should be true for conn1");
        conn1.close();
        Assertions.assertTrue((boolean)conn0.getAutoCommit(), (String)"autocommit should be true for conn0");
        conn0.setAutoCommit(false);
        Assertions.assertFalse((boolean)conn0.getAutoCommit(), (String)"autocommit should be false for conn0");
        conn0.close();
        Connection conn2 = this.newConnection();
        Assertions.assertTrue((boolean)conn2.getAutoCommit(), (String)"autocommit should be true for conn2");
        Connection conn3 = this.newConnection();
        Assertions.assertTrue((boolean)conn3.getAutoCommit(), (String)"autocommit should be true for conn3");
        conn2.close();
        conn3.close();
    }

    @Test
    public void testBackPointers() throws Exception {
        Connection conn = this.newConnection();
        this.assertBackPointers(conn, conn.createStatement());
        conn = this.newConnection();
        this.assertBackPointers(conn, conn.createStatement(0, 0));
        conn = this.newConnection();
        this.assertBackPointers(conn, conn.createStatement(0, 0, 0));
        conn = this.newConnection();
        this.assertBackPointers(conn, conn.prepareStatement("select * from dual"));
        conn = this.newConnection();
        this.assertBackPointers(conn, conn.prepareStatement("select * from dual", 0));
        conn = this.newConnection();
        this.assertBackPointers(conn, conn.prepareStatement("select * from dual", 0, 0));
        conn = this.newConnection();
        this.assertBackPointers(conn, conn.prepareStatement("select * from dual", 0, 0, 0));
        conn = this.newConnection();
        this.assertBackPointers(conn, conn.prepareStatement("select * from dual", new int[0]));
        conn = this.newConnection();
        this.assertBackPointers(conn, conn.prepareStatement("select * from dual", new String[0]));
        conn = this.newConnection();
        this.assertBackPointers(conn, conn.prepareCall("select * from dual"));
        conn = this.newConnection();
        this.assertBackPointers(conn, conn.prepareCall("select * from dual", 0, 0));
        conn = this.newConnection();
        this.assertBackPointers(conn, conn.prepareCall("select * from dual", 0, 0, 0));
    }

    @Test
    public void testCanCloseCallableStatementTwice() throws Exception {
        try (Connection conn = this.newConnection();){
            Assertions.assertNotNull((Object)conn);
            Assertions.assertFalse((boolean)conn.isClosed());
            for (int i = 0; i < 2; ++i) {
                CallableStatement stmt = conn.prepareCall("select * from dual");
                Assertions.assertNotNull((Object)stmt);
                Assertions.assertFalse((boolean)this.isClosed(stmt));
                stmt.close();
                Assertions.assertTrue((boolean)this.isClosed(stmt));
                stmt.close();
                Assertions.assertTrue((boolean)this.isClosed(stmt));
                stmt.close();
                Assertions.assertTrue((boolean)this.isClosed(stmt));
            }
        }
    }

    @Test
    public void testCanCloseConnectionTwice() throws Exception {
        for (int i = 0; i < this.getMaxTotal(); ++i) {
            Connection conn = this.newConnection();
            Assertions.assertNotNull((Object)conn);
            Assertions.assertFalse((boolean)conn.isClosed());
            conn.close();
            Assertions.assertTrue((boolean)conn.isClosed());
            conn.close();
            Assertions.assertTrue((boolean)conn.isClosed());
        }
    }

    @Test
    public void testCanClosePreparedStatementTwice() throws Exception {
        try (Connection conn = this.newConnection();){
            Assertions.assertNotNull((Object)conn);
            Assertions.assertFalse((boolean)conn.isClosed());
            for (int i = 0; i < 2; ++i) {
                PreparedStatement stmt = conn.prepareStatement("select * from dual");
                Assertions.assertNotNull((Object)stmt);
                Assertions.assertFalse((boolean)this.isClosed(stmt));
                stmt.close();
                Assertions.assertTrue((boolean)this.isClosed(stmt));
                stmt.close();
                Assertions.assertTrue((boolean)this.isClosed(stmt));
                stmt.close();
                Assertions.assertTrue((boolean)this.isClosed(stmt));
            }
        }
    }

    @Test
    public void testCanCloseResultSetTwice() throws Exception {
        try (Connection conn = this.newConnection();){
            Assertions.assertNotNull((Object)conn);
            Assertions.assertFalse((boolean)conn.isClosed());
            for (int i = 0; i < 2; ++i) {
                PreparedStatement stmt = conn.prepareStatement("select * from dual");
                Assertions.assertNotNull((Object)stmt);
                ResultSet rset = stmt.executeQuery();
                Assertions.assertNotNull((Object)rset);
                Assertions.assertFalse((boolean)this.isClosed(rset));
                rset.close();
                Assertions.assertTrue((boolean)this.isClosed(rset));
                rset.close();
                Assertions.assertTrue((boolean)this.isClosed(rset));
                rset.close();
                Assertions.assertTrue((boolean)this.isClosed(rset));
            }
        }
    }

    @Test
    public void testCanCloseStatementTwice() throws Exception {
        Connection conn = this.newConnection();
        Assertions.assertNotNull((Object)conn);
        Assertions.assertFalse((boolean)conn.isClosed());
        for (int i = 0; i < 2; ++i) {
            Statement stmt = conn.createStatement();
            Assertions.assertNotNull((Object)stmt);
            Assertions.assertFalse((boolean)this.isClosed(stmt));
            stmt.close();
            Assertions.assertTrue((boolean)this.isClosed(stmt));
            stmt.close();
            Assertions.assertTrue((boolean)this.isClosed(stmt));
            stmt.close();
            Assertions.assertTrue((boolean)this.isClosed(stmt));
        }
        conn.close();
    }

    @Test
    public void testClearWarnings() throws Exception {
        Connection[] c = new Connection[this.getMaxTotal()];
        for (int i = 0; i < c.length; ++i) {
            c[i] = this.newConnection();
            Assertions.assertNotNull((Object)c[i]);
            CallableStatement cs = c[i].prepareCall("warning");
            if (cs == null) continue;
            cs.close();
        }
        for (Connection element : c) {
            Assertions.assertNotNull((Object)element.getWarnings());
        }
        for (Connection element : c) {
            element.close();
        }
        for (int i = 0; i < c.length; ++i) {
            c[i] = this.newConnection();
        }
        for (Connection element : c) {
            Assertions.assertNull((Object)element.getWarnings());
        }
        for (Connection element : c) {
            element.close();
        }
    }

    @Test
    public void testClosing() throws Exception {
        Connection[] c = new Connection[this.getMaxTotal()];
        for (int i = 0; i < c.length; ++i) {
            c[i] = this.newConnection();
        }
        c[0].close();
        Assertions.assertTrue((boolean)c[0].isClosed());
        c[0] = this.newConnection();
        for (Connection element : c) {
            element.close();
        }
    }

    @Test
    public void testConnectionsAreDistinct() throws Exception {
        Connection[] conn = new Connection[this.getMaxTotal()];
        for (int i = 0; i < conn.length; ++i) {
            conn[i] = this.newConnection();
            for (int j = 0; j < i; ++j) {
                Assertions.assertNotSame((Object)conn[j], (Object)conn[i]);
                Assertions.assertNotEquals((Object)conn[j], (Object)conn[i]);
            }
        }
        for (Connection element : conn) {
            element.close();
        }
    }

    @Test
    public void testHashCode() throws Exception {
        Connection conn1 = this.newConnection();
        Assertions.assertNotNull((Object)conn1);
        Connection conn2 = this.newConnection();
        Assertions.assertNotNull((Object)conn2);
        Assertions.assertTrue((conn1.hashCode() != conn2.hashCode() ? 1 : 0) != 0);
    }

    @Test
    public void testHashing() throws Exception {
        Connection con = this.getConnection();
        Hashtable<Connection, String> hash = new Hashtable<Connection, String>();
        hash.put(con, "test");
        Assertions.assertEquals((Object)"test", hash.get(con));
        Assertions.assertTrue((boolean)hash.containsKey(con));
        Assertions.assertTrue((boolean)hash.contains("test"));
        hash.clear();
        con.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIsClosed() throws Exception {
        for (int i = 0; i < this.getMaxTotal(); ++i) {
            try (Connection conn = this.newConnection();){
                Assertions.assertNotNull((Object)conn);
                Assertions.assertFalse((boolean)conn.isClosed());
                try (PreparedStatement stmt = conn.prepareStatement("select * from dual");){
                    Assertions.assertNotNull((Object)stmt);
                    try (ResultSet rset = stmt.executeQuery();){
                        Assertions.assertNotNull((Object)rset);
                        Assertions.assertTrue((boolean)rset.next());
                    }
                }
            }
            Assertions.assertTrue((boolean)conn.isClosed());
        }
    }

    @Test
    public void testMaxTotal() throws Exception {
        Connection[] c = new Connection[this.getMaxTotal()];
        for (int i = 0; i < c.length; ++i) {
            c[i] = this.newConnection();
            Assertions.assertNotNull((Object)c[i]);
        }
        Assertions.assertThrows(SQLException.class, this::newConnection);
        for (Connection element : c) {
            element.close();
        }
    }

    @Test
    public void testNoRsetClose() throws Exception {
        try (Connection conn = this.newConnection();){
            Assertions.assertNotNull((Object)conn);
            try (PreparedStatement stmt = conn.prepareStatement("test");){
                Assertions.assertNotNull((Object)stmt);
                ResultSet rset = stmt.getResultSet();
                Assertions.assertNotNull((Object)rset);
            }
        }
    }

    @Test
    public void testOpening() throws Exception {
        Connection[] c = new Connection[this.getMaxTotal()];
        for (int i = 0; i < c.length; ++i) {
            c[i] = this.newConnection();
            Assertions.assertNotNull((Object)c[i]);
            for (int j = 0; j <= i; ++j) {
                Assertions.assertFalse((boolean)c[j].isClosed());
            }
        }
        for (Connection element : c) {
            element.close();
        }
    }

    @Test
    public void testPooling() throws Exception {
        Connection[] c = new Connection[this.getMaxTotal()];
        Connection[] u = new Connection[this.getMaxTotal()];
        for (int i = 0; i < c.length; ++i) {
            c[i] = this.newConnection();
            if (!(c[i] instanceof DelegatingConnection)) {
                for (int j = 0; j <= i; ++j) {
                    c[j].close();
                }
                return;
            }
            u[i] = ((DelegatingConnection)c[i]).getInnermostDelegate();
        }
        for (Connection element : c) {
            element.close();
            try (Connection con = this.newConnection();){
                Connection underCon = ((DelegatingConnection)con).getInnermostDelegate();
                Assertions.assertNotNull((Object)underCon, (String)"Failed to get connection");
                boolean found = false;
                for (int j = 0; j < c.length; ++j) {
                    if (underCon != u[j]) continue;
                    found = true;
                    break;
                }
                Assertions.assertTrue((boolean)found, (String)"New connection not from pool");
            }
        }
    }

    @Test
    public void testPrepareStatementOptions() throws Exception {
        try (Connection conn = this.newConnection();){
            Assertions.assertNotNull((Object)conn);
            try (PreparedStatement stmt = conn.prepareStatement("select * from dual", 1005, 1008);){
                Assertions.assertNotNull((Object)stmt);
                try (ResultSet rset = stmt.executeQuery();){
                    Assertions.assertNotNull((Object)rset);
                    Assertions.assertTrue((boolean)rset.next());
                    Assertions.assertEquals((int)1005, (int)rset.getType());
                    Assertions.assertEquals((int)1008, (int)rset.getConcurrency());
                }
            }
        }
    }

    @Test
    public void testRepeatedBorrowAndReturn() throws Exception {
        for (int i = 0; i < 100; ++i) {
            try (Connection conn = this.newConnection();){
                Assertions.assertNotNull((Object)conn);
                try (PreparedStatement stmt = conn.prepareStatement("select * from dual");){
                    Assertions.assertNotNull((Object)stmt);
                    try (ResultSet rset = stmt.executeQuery();){
                        Assertions.assertNotNull((Object)rset);
                        Assertions.assertTrue((boolean)rset.next());
                        continue;
                    }
                }
            }
        }
    }

    @Test
    public void testSimple() throws Exception {
        try (Connection conn = this.newConnection();){
            Assertions.assertNotNull((Object)conn);
            try (PreparedStatement stmt = conn.prepareStatement("select * from dual");){
                Assertions.assertNotNull((Object)stmt);
                try (ResultSet rset = stmt.executeQuery();){
                    Assertions.assertNotNull((Object)rset);
                    Assertions.assertTrue((boolean)rset.next());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSimple2() throws Exception {
        Assertions.assertNotNull((Object)conn);
        try (Connection conn = this.newConnection();){
            ResultSet rset;
            try (PreparedStatement stmt = conn.prepareStatement("select * from dual");){
                Assertions.assertNotNull((Object)stmt);
                rset = stmt.executeQuery();
                try {
                    Assertions.assertNotNull((Object)rset);
                    Assertions.assertTrue((boolean)rset.next());
                }
                finally {
                    if (rset != null) {
                        rset.close();
                    }
                }
            }
            stmt = conn.prepareStatement("select * from dual");
            try {
                Assertions.assertNotNull((Object)stmt);
                rset = stmt.executeQuery();
                try {
                    Assertions.assertNotNull((Object)rset);
                    Assertions.assertTrue((boolean)rset.next());
                }
                finally {
                    if (rset != null) {
                        rset.close();
                    }
                }
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        Assertions.assertThrows(SQLException.class, conn::createStatement, (String)"Can't use closed connections");
        try (Connection conn2 = this.newConnection();){
            ResultSet rset;
            Assertions.assertNotNull((Object)conn2);
            try (PreparedStatement stmt = conn2.prepareStatement("select * from dual");){
                Assertions.assertNotNull((Object)stmt);
                rset = stmt.executeQuery();
                try {
                    Assertions.assertNotNull((Object)rset);
                    Assertions.assertTrue((boolean)rset.next());
                }
                finally {
                    if (rset != null) {
                        rset.close();
                    }
                }
            }
            stmt = conn2.prepareStatement("select * from dual");
            try {
                Assertions.assertNotNull((Object)stmt);
                rset = stmt.executeQuery();
                try {
                    Assertions.assertNotNull((Object)rset);
                    Assertions.assertTrue((boolean)rset.next());
                }
                finally {
                    if (rset != null) {
                        rset.close();
                    }
                }
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
    }

    @Test
    public void testThreaded() {
        int i;
        TestThread[] threads = new TestThread[this.getMaxTotal()];
        for (i = 0; i < threads.length; ++i) {
            threads[i] = new TestThread(50, 50);
            Thread t = new Thread(threads[i]);
            t.start();
        }
        for (i = 0; i < threads.length; ++i) {
            while (!threads[i].complete()) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {}
            }
            if (threads[i] == null || !threads[i].failed()) continue;
            Assertions.fail((String)("Thread failed: " + i));
        }
    }

    long timeStampMillis() {
        return System.currentTimeMillis();
    }

    protected class PoolTest
    implements Runnable {
        private final Duration connHoldDuration;
        private final int numStatements;
        private volatile boolean isRun;
        private String state;
        private final Thread thread;
        private Throwable thrown;
        private final Random random = new Random();
        private final long createdMillis;
        private long started;
        private long ended;
        private long preconnected;
        private long connected;
        private long postconnected;
        private int loops;
        private int connHash;
        private final boolean stopOnException;
        private final boolean loopOnce;

        public PoolTest(ThreadGroup threadGroup, Duration connHoldDuration, boolean isStopOnException) {
            this(threadGroup, connHoldDuration, isStopOnException, false, 1);
        }

        private PoolTest(ThreadGroup threadGroup, Duration connHoldDuration, boolean isStopOnException, boolean once, int numStatements) {
            this.loopOnce = once;
            this.connHoldDuration = connHoldDuration;
            this.stopOnException = isStopOnException;
            this.isRun = true;
            this.thrown = null;
            this.thread = new Thread(threadGroup, this, "Thread+" + currentThreadCount++);
            this.thread.setDaemon(false);
            this.createdMillis = TestConnectionPool.this.timeStampMillis();
            this.numStatements = numStatements;
        }

        public PoolTest(ThreadGroup threadGroup, Duration connHoldDuration, boolean isStopOnException, int numStatements) {
            this(threadGroup, connHoldDuration, isStopOnException, false, numStatements);
        }

        public Thread getThread() {
            return this.thread;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.started = TestConnectionPool.this.timeStampMillis();
            try {
                while (this.isRun) {
                    ++this.loops;
                    this.state = "Getting Connection";
                    this.preconnected = TestConnectionPool.this.timeStampMillis();
                    try (Connection conn = TestConnectionPool.this.getConnection();){
                        this.connHash = System.identityHashCode(((DelegatingConnection)conn).getInnermostDelegate());
                        this.connected = TestConnectionPool.this.timeStampMillis();
                        this.state = "Using Connection";
                        Assertions.assertNotNull((Object)conn);
                        String sql = this.numStatements == 1 ? "select * from dual" : "select count " + this.random.nextInt(this.numStatements - 1);
                        try (PreparedStatement stmt = conn.prepareStatement(sql);){
                            Assertions.assertNotNull((Object)stmt);
                            try (ResultSet rset = stmt.executeQuery();){
                                Assertions.assertNotNull((Object)rset);
                                Assertions.assertTrue((boolean)rset.next());
                                this.state = "Holding Connection";
                                Thread.sleep(this.connHoldDuration.toMillis());
                                this.state = "Closing ResultSet";
                            }
                            this.state = "Closing Statement";
                        }
                        this.state = "Closing Connection";
                    }
                    this.postconnected = TestConnectionPool.this.timeStampMillis();
                    this.state = "Closed";
                    if (!this.loopOnce) continue;
                }
                this.state = TestConnectionPool.DONE;
            }
            catch (Throwable t) {
                this.thrown = t;
                if (!this.stopOnException) {
                    throw new RuntimeException();
                }
            }
            finally {
                this.ended = TestConnectionPool.this.timeStampMillis();
            }
        }

        public void start() {
            this.thread.start();
        }

        public void stop() {
            this.isRun = false;
        }
    }

    final class TestThread
    implements Runnable {
        final Random _random = new Random();
        boolean _complete;
        boolean _failed;
        int _iter = 100;
        int _delay = 50;

        public TestThread() {
        }

        public TestThread(int iter) {
            this._iter = iter;
        }

        public TestThread(int iter, int delay) {
            this._iter = iter;
            this._delay = delay;
        }

        public boolean complete() {
            return this._complete;
        }

        public boolean failed() {
            return this._failed;
        }

        @Override
        public void run() {
            for (int i = 0; i < this._iter; ++i) {
                try {
                    Thread.sleep(this._random.nextInt(this._delay));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try (Connection conn = TestConnectionPool.this.newConnection();
                     PreparedStatement stmt = conn.prepareStatement("select 'literal', SYSDATE from dual");
                     ResultSet rset = stmt.executeQuery();){
                    try {
                        Thread.sleep(this._random.nextInt(this._delay));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this._failed = true;
                    this._complete = true;
                    break;
                }
            }
            this._complete = true;
        }
    }
}

