/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.euclidean.twod;

import java.util.List;
import org.apache.commons.geometry.core.RegionEmbedding;
import org.apache.commons.geometry.core.RegionLocation;
import org.apache.commons.geometry.core.partitioning.HyperplaneBoundedRegion;
import org.apache.commons.geometry.core.partitioning.HyperplaneSubset;
import org.apache.commons.geometry.core.partitioning.Split;
import org.apache.commons.geometry.euclidean.oned.Vector1D;
import org.apache.commons.geometry.euclidean.twod.Bounds2D;
import org.apache.commons.geometry.euclidean.twod.Line;
import org.apache.commons.geometry.euclidean.twod.LineConvexSubset;
import org.apache.commons.geometry.euclidean.twod.Vector2D;
import org.apache.commons.numbers.core.Precision;

public abstract class LineSubset
implements HyperplaneSubset<Vector2D>,
RegionEmbedding<Vector2D, Vector1D> {
    private final Line line;

    LineSubset(Line line) {
        this.line = line;
    }

    public Line getLine() {
        return this.getHyperplane();
    }

    public Line getHyperplane() {
        return this.line;
    }

    public Vector1D toSubspace(Vector2D pt) {
        return this.line.toSubspace(pt);
    }

    public abstract Bounds2D getBounds();

    public abstract HyperplaneBoundedRegion<Vector1D> getSubspaceRegion();

    public Vector2D toSpace(Vector1D pt) {
        return this.line.toSpace(pt);
    }

    public abstract List<LineConvexSubset> toConvex();

    public RegionLocation classify(Vector2D pt) {
        if (this.line.contains(pt)) {
            return this.classifyAbscissa(this.line.abscissa(pt));
        }
        return RegionLocation.OUTSIDE;
    }

    public Vector2D intersection(Line inputLine) {
        Vector2D pt = this.line.intersection(inputLine);
        return pt != null && this.contains(pt) ? pt : null;
    }

    public Vector2D intersection(LineSubset subset) {
        Vector2D pt = this.intersection(subset.getLine());
        return pt != null && subset.contains(pt) ? pt : null;
    }

    public Precision.DoubleEquivalence getPrecision() {
        return this.line.getPrecision();
    }

    abstract RegionLocation classifyAbscissa(double var1);

    <T extends LineSubset> Split<T> getNonIntersectingSplitResult(Line splitter, T subset) {
        double offset = splitter.offset(subset.getLine());
        int comp = this.getPrecision().compare(offset, 0.0);
        if (comp < 0) {
            return new Split(subset, null);
        }
        if (comp > 0) {
            return new Split(null, subset);
        }
        return new Split(null, null);
    }

    boolean splitterPlusIsPositiveFacing(Line splitterLine) {
        return this.line.getOffsetDirection().dot(splitterLine.getDirection()) <= 0.0;
    }

    <T extends LineSubset> Split<T> createSplitResult(Line splitter, T low, T high) {
        return this.splitterPlusIsPositiveFacing(splitter) ? new Split(low, high) : new Split(high, low);
    }
}

