/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.color;

public final class ColorCmy {
    public static final ColorCmy CYAN = new ColorCmy(100.0, 0.0, 0.0);
    public static final ColorCmy MAGENTA = new ColorCmy(0.0, 100.0, 0.0);
    public static final ColorCmy YELLOW = new ColorCmy(0.0, 0.0, 100.0);
    public static final ColorCmy BLACK = new ColorCmy(100.0, 100.0, 100.0);
    public static final ColorCmy WHITE = new ColorCmy(0.0, 0.0, 0.0);
    public static final ColorCmy RED = new ColorCmy(0.0, 100.0, 100.0);
    public static final ColorCmy GREEN = new ColorCmy(100.0, 0.0, 100.0);
    public static final ColorCmy BLUE = new ColorCmy(100.0, 100.0, 0.0);
    public final double c;
    public final double m;
    public final double y;

    public ColorCmy(double c, double m, double y) {
        this.c = c;
        this.m = m;
        this.y = y;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColorCmy colorCmy = (ColorCmy)o;
        if (Double.compare(colorCmy.c, this.c) != 0) {
            return false;
        }
        if (Double.compare(colorCmy.m, this.m) != 0) {
            return false;
        }
        return Double.compare(colorCmy.y, this.y) == 0;
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.c);
        int result = (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.m);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.y);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public String toString() {
        return "{C: " + this.c + ", M: " + this.m + ", Y: " + this.y + "}";
    }
}

