/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.common;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.imaging.common.BinaryOutputStream;

final class LittleEndianBinaryOutputStream
extends BinaryOutputStream {
    LittleEndianBinaryOutputStream(OutputStream os) {
        super(os);
    }

    @Override
    public void write2Bytes(int value) throws IOException {
        this.write(0xFF & value);
        this.write(0xFF & value >> 8);
    }

    @Override
    public void write3Bytes(int value) throws IOException {
        this.write(0xFF & value);
        this.write(0xFF & value >> 8);
        this.write(0xFF & value >> 16);
    }

    @Override
    public void write4Bytes(int value) throws IOException {
        this.write(0xFF & value);
        this.write(0xFF & value >> 8);
        this.write(0xFF & value >> 16);
        this.write(0xFF & value >> 24);
    }
}

