/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.jpeg.segments;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.imaging.common.Allocator;
import org.apache.commons.imaging.common.BinaryFunctions;
import org.apache.commons.imaging.formats.jpeg.segments.AbstractSegment;

public class SosSegment
extends AbstractSegment {
    private static final Logger LOGGER = Logger.getLogger(SosSegment.class.getName());
    public final int numberOfComponents;
    private final Component[] components;
    public final int startOfSpectralSelection;
    public final int endOfSpectralSelection;
    public final int successiveApproximationBitHigh;
    public final int successiveApproximationBitLow;

    public SosSegment(int marker, byte[] segmentData) throws IOException {
        this(marker, segmentData.length, new ByteArrayInputStream(segmentData));
    }

    public SosSegment(int marker, int markerLength, InputStream is) throws IOException {
        super(marker, markerLength);
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("SosSegment markerLength: " + markerLength);
        }
        this.numberOfComponents = BinaryFunctions.readByte("numberOfComponents", is, "Not a Valid JPEG File");
        this.components = (Component[])Allocator.array(this.numberOfComponents, Component[]::new, 24);
        for (int i = 0; i < this.numberOfComponents; ++i) {
            byte scanComponentSelector = BinaryFunctions.readByte("scanComponentSelector", is, "Not a Valid JPEG File");
            byte acDcEntropyCodingTableSelector = BinaryFunctions.readByte("acDcEntropyCodingTableSelector", is, "Not a Valid JPEG File");
            int dcCodingTableSelector = acDcEntropyCodingTableSelector >> 4 & 0xF;
            int acCodingTableSelector = acDcEntropyCodingTableSelector & 0xF;
            this.components[i] = new Component(scanComponentSelector, dcCodingTableSelector, acCodingTableSelector);
        }
        this.startOfSpectralSelection = BinaryFunctions.readByte("startOfSpectralSelection", is, "Not a Valid JPEG File");
        this.endOfSpectralSelection = BinaryFunctions.readByte("endOfSpectralSelection", is, "Not a Valid JPEG File");
        byte successiveApproximationBitPosition = BinaryFunctions.readByte("successiveApproximationBitPosition", is, "Not a Valid JPEG File");
        this.successiveApproximationBitHigh = successiveApproximationBitPosition >> 4 & 0xF;
        this.successiveApproximationBitLow = successiveApproximationBitPosition & 0xF;
    }

    public Component[] getComponents() {
        return (Component[])this.components.clone();
    }

    public Component getComponents(int index) {
        return this.components[index];
    }

    @Override
    public String getDescription() {
        return "SOS (" + this.getSegmentType() + ")";
    }

    public static class Component {
        static final int SHALLOW_SIZE = 24;
        public final int scanComponentSelector;
        public final int dcCodingTableSelector;
        public final int acCodingTableSelector;

        public Component(int scanComponentSelector, int dcCodingTableSelector, int acCodingTableSelector) {
            this.scanComponentSelector = scanComponentSelector;
            this.dcCodingTableSelector = dcCodingTableSelector;
            this.acCodingTableSelector = acCodingTableSelector;
        }
    }
}

