/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.tiff;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.imaging.AbstractImageParser;
import org.apache.commons.imaging.FormatCompliance;
import org.apache.commons.imaging.ImageFormat;
import org.apache.commons.imaging.ImageFormats;
import org.apache.commons.imaging.ImageInfo;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.bytesource.ByteSource;
import org.apache.commons.imaging.common.Allocator;
import org.apache.commons.imaging.common.ImageBuilder;
import org.apache.commons.imaging.common.ImageMetadata;
import org.apache.commons.imaging.common.XmpEmbeddable;
import org.apache.commons.imaging.common.XmpImagingParameters;
import org.apache.commons.imaging.formats.tiff.AbstractTiffImageData;
import org.apache.commons.imaging.formats.tiff.TiffContents;
import org.apache.commons.imaging.formats.tiff.TiffDirectory;
import org.apache.commons.imaging.formats.tiff.TiffField;
import org.apache.commons.imaging.formats.tiff.TiffImageMetadata;
import org.apache.commons.imaging.formats.tiff.TiffImagingParameters;
import org.apache.commons.imaging.formats.tiff.TiffRasterData;
import org.apache.commons.imaging.formats.tiff.TiffReader;
import org.apache.commons.imaging.formats.tiff.constants.TiffEpTagConstants;
import org.apache.commons.imaging.formats.tiff.constants.TiffPlanarConfiguration;
import org.apache.commons.imaging.formats.tiff.constants.TiffTagConstants;
import org.apache.commons.imaging.formats.tiff.datareaders.ImageDataReader;
import org.apache.commons.imaging.formats.tiff.photometricinterpreters.PhotometricInterpreter;
import org.apache.commons.imaging.formats.tiff.photometricinterpreters.PhotometricInterpreterBiLevel;
import org.apache.commons.imaging.formats.tiff.photometricinterpreters.PhotometricInterpreterCieLab;
import org.apache.commons.imaging.formats.tiff.photometricinterpreters.PhotometricInterpreterCmyk;
import org.apache.commons.imaging.formats.tiff.photometricinterpreters.PhotometricInterpreterLogLuv;
import org.apache.commons.imaging.formats.tiff.photometricinterpreters.PhotometricInterpreterPalette;
import org.apache.commons.imaging.formats.tiff.photometricinterpreters.PhotometricInterpreterRgb;
import org.apache.commons.imaging.formats.tiff.photometricinterpreters.PhotometricInterpreterYCbCr;
import org.apache.commons.imaging.formats.tiff.write.TiffImageWriterLossy;

public class TiffImageParser
extends AbstractImageParser<TiffImagingParameters>
implements XmpEmbeddable<TiffImagingParameters> {
    private static final String DEFAULT_EXTENSION = ImageFormats.TIFF.getDefaultExtension();
    private static final String[] ACCEPTED_EXTENSIONS = ImageFormats.TIFF.getExtensions();

    private Rectangle checkForSubImage(TiffImagingParameters params) {
        if (params != null && params.isSubImageSet()) {
            int ix0 = params.getSubImageX();
            int iy0 = params.getSubImageY();
            int iwidth = params.getSubImageWidth();
            int iheight = params.getSubImageHeight();
            return new Rectangle(ix0, iy0, iwidth, iheight);
        }
        return null;
    }

    public List<byte[]> collectRawImageData(ByteSource byteSource, TiffImagingParameters params) throws ImagingException, IOException {
        FormatCompliance formatCompliance = FormatCompliance.getDefault();
        TiffContents contents = new TiffReader(params != null && params.isStrict()).readDirectories(byteSource, true, formatCompliance);
        ArrayList<byte[]> result = new ArrayList<byte[]>();
        for (int i = 0; i < contents.directories.size(); ++i) {
            TiffDirectory directory = contents.directories.get(i);
            List<TiffDirectory.ImageDataElement> dataElements = directory.getTiffRawImageDataElements();
            for (TiffDirectory.ImageDataElement element : dataElements) {
                byte[] bytes = byteSource.getByteArray(element.offset, element.length);
                result.add(bytes);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean dumpImageFile(PrintWriter pw, ByteSource byteSource) throws ImagingException, IOException {
        try {
            pw.println("tiff.dumpImageFile");
            ImageInfo imageData = this.getImageInfo(byteSource);
            if (imageData == null) {
                boolean bl = false;
                return bl;
            }
            imageData.toString(pw, "");
            pw.println("");
            FormatCompliance formatCompliance = FormatCompliance.getDefault();
            TiffImagingParameters params = new TiffImagingParameters();
            TiffContents contents = new TiffReader(true).readContents(byteSource, params, formatCompliance);
            List<TiffDirectory> directories = contents.directories;
            if (directories == null) {
                boolean bl = false;
                return bl;
            }
            for (int d = 0; d < directories.size(); ++d) {
                TiffDirectory directory = directories.get(d);
                for (TiffField field : directory) {
                    field.dump(pw, Integer.toString(d));
                }
            }
            pw.println("");
            boolean bl = true;
            return bl;
        }
        finally {
            pw.println("");
        }
    }

    @Override
    protected String[] getAcceptedExtensions() {
        return ACCEPTED_EXTENSIONS;
    }

    @Override
    protected ImageFormat[] getAcceptedTypes() {
        return new ImageFormat[]{ImageFormats.TIFF};
    }

    @Override
    public List<BufferedImage> getAllBufferedImages(ByteSource byteSource) throws ImagingException, IOException {
        FormatCompliance formatCompliance = FormatCompliance.getDefault();
        TiffReader tiffReader = new TiffReader(true);
        TiffContents contents = tiffReader.readDirectories(byteSource, true, formatCompliance);
        ArrayList<BufferedImage> results = new ArrayList<BufferedImage>();
        for (int i = 0; i < contents.directories.size(); ++i) {
            TiffDirectory directory = contents.directories.get(i);
            BufferedImage result = directory.getTiffImage(tiffReader.getByteOrder(), null);
            if (result == null) continue;
            results.add(result);
        }
        return results;
    }

    @Override
    public BufferedImage getBufferedImage(ByteSource byteSource, TiffImagingParameters params) throws ImagingException, IOException {
        if (params == null) {
            params = new TiffImagingParameters();
        }
        FormatCompliance formatCompliance = FormatCompliance.getDefault();
        TiffReader reader = new TiffReader(params.isStrict());
        TiffContents contents = reader.readFirstDirectory(byteSource, true, formatCompliance);
        ByteOrder byteOrder = reader.getByteOrder();
        TiffDirectory directory = contents.directories.get(0);
        BufferedImage result = directory.getTiffImage(byteOrder, params);
        if (null == result) {
            throw new ImagingException("TIFF does not contain an image.");
        }
        return result;
    }

    protected BufferedImage getBufferedImage(TiffDirectory directory, ByteOrder byteOrder, TiffImagingParameters params) throws ImagingException, IOException {
        TiffField pcField;
        TiffPlanarConfiguration planarConfiguration;
        PhotometricInterpreter photometricInterpreter;
        short compressionFieldValue = directory.findField(TiffTagConstants.TIFF_TAG_COMPRESSION) != null ? directory.getFieldValue(TiffTagConstants.TIFF_TAG_COMPRESSION) : (short)1;
        int compression = 0xFFFF & compressionFieldValue;
        int width = directory.getSingleFieldValue(TiffTagConstants.TIFF_TAG_IMAGE_WIDTH);
        int height = directory.getSingleFieldValue(TiffTagConstants.TIFF_TAG_IMAGE_LENGTH);
        Rectangle subImage = this.checkForSubImage(params);
        if (subImage != null) {
            if (subImage.width <= 0) {
                throw new ImagingException("Negative or zero subimage width.");
            }
            if (subImage.height <= 0) {
                throw new ImagingException("Negative or zero subimage height.");
            }
            if (subImage.x < 0 || subImage.x >= width) {
                throw new ImagingException("Subimage x is outside raster.");
            }
            if (subImage.x + subImage.width > width) {
                throw new ImagingException("Subimage (x+width) is outside raster.");
            }
            if (subImage.y < 0 || subImage.y >= height) {
                throw new ImagingException("Subimage y is outside raster.");
            }
            if (subImage.y + subImage.height > height) {
                throw new ImagingException("Subimage (y+height) is outside raster.");
            }
        }
        int samplesPerPixel = 1;
        TiffField samplesPerPixelField = directory.findField(TiffTagConstants.TIFF_TAG_SAMPLES_PER_PIXEL);
        if (samplesPerPixelField != null) {
            samplesPerPixel = samplesPerPixelField.getIntValue();
        }
        int[] bitsPerSample = new int[]{1};
        int bitsPerPixel = samplesPerPixel;
        TiffField bitsPerSampleField = directory.findField(TiffTagConstants.TIFF_TAG_BITS_PER_SAMPLE);
        if (bitsPerSampleField != null) {
            bitsPerSample = bitsPerSampleField.getIntArrayValue();
            bitsPerPixel = bitsPerSampleField.getIntValueOrArraySum();
        }
        int predictor = -1;
        TiffField predictorField = directory.findField(TiffTagConstants.TIFF_TAG_PREDICTOR);
        if (null != predictorField) {
            predictor = predictorField.getIntValueOrArraySum();
        }
        if (samplesPerPixel != bitsPerSample.length) {
            throw new ImagingException("Tiff: samplesPerPixel (" + samplesPerPixel + ")!=fBitsPerSample.length (" + bitsPerSample.length + ")");
        }
        int photometricInterpretation = 0xFFFF & directory.getFieldValue(TiffTagConstants.TIFF_TAG_PHOTOMETRIC_INTERPRETATION);
        boolean hasAlpha = false;
        boolean isAlphaPremultiplied = false;
        if (photometricInterpretation == 2 && samplesPerPixel == 4) {
            TiffField extraSamplesField = directory.findField(TiffTagConstants.TIFF_TAG_EXTRA_SAMPLES);
            if (extraSamplesField == null) {
                hasAlpha = true;
                isAlphaPremultiplied = false;
            } else {
                int extraSamplesValue = extraSamplesField.getIntValue();
                switch (extraSamplesValue) {
                    case 2: {
                        hasAlpha = true;
                        isAlphaPremultiplied = false;
                        break;
                    }
                    case 1: {
                        hasAlpha = true;
                        isAlphaPremultiplied = true;
                        break;
                    }
                    default: {
                        hasAlpha = false;
                        isAlphaPremultiplied = false;
                    }
                }
            }
        }
        PhotometricInterpreter photometricInterpreter2 = photometricInterpreter = params == null ? null : params.getCustomPhotometricInterpreter();
        if (photometricInterpreter == null) {
            photometricInterpreter = this.getPhotometricInterpreter(directory, photometricInterpretation, bitsPerPixel, bitsPerSample, predictor, samplesPerPixel, width, height);
        }
        TiffPlanarConfiguration tiffPlanarConfiguration = planarConfiguration = (pcField = directory.findField(TiffTagConstants.TIFF_TAG_PLANAR_CONFIGURATION)) == null ? TiffPlanarConfiguration.CHUNKY : TiffPlanarConfiguration.lenientValueOf(pcField.getIntValue());
        if (planarConfiguration == TiffPlanarConfiguration.PLANAR) {
            if (photometricInterpretation != 2 || bitsPerPixel != 24) {
                throw new ImagingException("For planar configuration 2, only 24 bit RGB is currently supported");
            }
            if (null == directory.findField(TiffTagConstants.TIFF_TAG_STRIP_OFFSETS)) {
                throw new ImagingException("For planar configuration 2, only strips-organization is supported");
            }
        }
        AbstractTiffImageData imageData = directory.getTiffImageData();
        ImageDataReader dataReader = imageData.getDataReader(directory, photometricInterpreter, bitsPerPixel, bitsPerSample, predictor, samplesPerPixel, width, height, compression, planarConfiguration, byteOrder);
        ImageBuilder iBuilder = dataReader.readImageData(subImage, hasAlpha, isAlphaPremultiplied);
        return iBuilder.getBufferedImage();
    }

    @Override
    public String getDefaultExtension() {
        return DEFAULT_EXTENSION;
    }

    @Override
    public TiffImagingParameters getDefaultParameters() {
        return new TiffImagingParameters();
    }

    @Override
    public FormatCompliance getFormatCompliance(ByteSource byteSource) throws ImagingException, IOException {
        FormatCompliance formatCompliance = FormatCompliance.getDefault();
        TiffImagingParameters params = new TiffImagingParameters();
        new TiffReader(params.isStrict()).readContents(byteSource, params, formatCompliance);
        return formatCompliance;
    }

    @Override
    public byte[] getIccProfileBytes(ByteSource byteSource, TiffImagingParameters params) throws ImagingException, IOException {
        FormatCompliance formatCompliance = FormatCompliance.getDefault();
        TiffContents contents = new TiffReader(params != null && params.isStrict()).readFirstDirectory(byteSource, false, formatCompliance);
        TiffDirectory directory = contents.directories.get(0);
        return directory.getFieldValue(TiffEpTagConstants.EXIF_TAG_INTER_COLOR_PROFILE, false);
    }

    @Override
    public ImageInfo getImageInfo(ByteSource byteSource, TiffImagingParameters params) throws ImagingException, IOException {
        ImageInfo.CompressionAlgorithm compressionAlgorithm;
        ImageInfo.ColorType colorType;
        FormatCompliance formatCompliance = FormatCompliance.getDefault();
        TiffContents contents = new TiffReader(params != null && params.isStrict()).readDirectories(byteSource, false, formatCompliance);
        TiffDirectory directory = contents.directories.get(0);
        TiffField widthField = directory.findField(TiffTagConstants.TIFF_TAG_IMAGE_WIDTH, true);
        TiffField heightField = directory.findField(TiffTagConstants.TIFF_TAG_IMAGE_LENGTH, true);
        if (widthField == null || heightField == null) {
            throw new ImagingException("TIFF image missing size info.");
        }
        int height = heightField.getIntValue();
        int width = widthField.getIntValue();
        TiffField resolutionUnitField = directory.findField(TiffTagConstants.TIFF_TAG_RESOLUTION_UNIT);
        int resolutionUnit = 2;
        if (resolutionUnitField != null && resolutionUnitField.getValue() != null) {
            resolutionUnit = resolutionUnitField.getIntValue();
        }
        double unitsPerInch = -1.0;
        switch (resolutionUnit) {
            case 1: {
                break;
            }
            case 2: {
                unitsPerInch = 1.0;
                break;
            }
            case 3: {
                unitsPerInch = 2.54;
                break;
            }
        }
        int physicalWidthDpi = -1;
        float physicalWidthInch = -1.0f;
        int physicalHeightDpi = -1;
        float physicalHeightInch = -1.0f;
        if (unitsPerInch > 0.0) {
            TiffField xResolutionField = directory.findField(TiffTagConstants.TIFF_TAG_XRESOLUTION);
            TiffField yResolutionField = directory.findField(TiffTagConstants.TIFF_TAG_YRESOLUTION);
            if (xResolutionField != null && xResolutionField.getValue() != null) {
                double xResolutionPixelsPerUnit = xResolutionField.getDoubleValue();
                physicalWidthDpi = (int)Math.round(xResolutionPixelsPerUnit * unitsPerInch);
                physicalWidthInch = (float)((double)width / (xResolutionPixelsPerUnit * unitsPerInch));
            }
            if (yResolutionField != null && yResolutionField.getValue() != null) {
                double yResolutionPixelsPerUnit = yResolutionField.getDoubleValue();
                physicalHeightDpi = (int)Math.round(yResolutionPixelsPerUnit * unitsPerInch);
                physicalHeightInch = (float)((double)height / (yResolutionPixelsPerUnit * unitsPerInch));
            }
        }
        TiffField bitsPerSampleField = directory.findField(TiffTagConstants.TIFF_TAG_BITS_PER_SAMPLE);
        int bitsPerSample = 1;
        if (bitsPerSampleField != null && bitsPerSampleField.getValue() != null) {
            bitsPerSample = bitsPerSampleField.getIntValueOrArraySum();
        }
        int bitsPerPixel = bitsPerSample;
        ArrayList<String> comments = Allocator.arrayList(directory.size());
        for (TiffField field : directory) {
            String comment = field.toString();
            comments.add(comment);
        }
        ImageFormats format = ImageFormats.TIFF;
        String formatName = "TIFF Tag-based Image File Format";
        String mimeType = "image/tiff";
        int numberOfImages = contents.directories.size();
        boolean progressive = false;
        String formatDetails = "TIFF v." + contents.header.tiffVersion;
        boolean transparent = false;
        boolean usesPalette = false;
        TiffField colorMapField = directory.findField(TiffTagConstants.TIFF_TAG_COLOR_MAP);
        if (colorMapField != null) {
            usesPalette = true;
        }
        int photoInterp = 0xFFFF & directory.getFieldValue(TiffTagConstants.TIFF_TAG_PHOTOMETRIC_INTERPRETATION);
        TiffField extraSamplesField = directory.findField(TiffTagConstants.TIFF_TAG_EXTRA_SAMPLES);
        int extraSamples = extraSamplesField == null ? 0 : extraSamplesField.getIntValue();
        TiffField samplesPerPixelField = directory.findField(TiffTagConstants.TIFF_TAG_SAMPLES_PER_PIXEL);
        int samplesPerPixel = samplesPerPixelField == null ? 1 : samplesPerPixelField.getIntValue();
        switch (photoInterp) {
            case 0: 
            case 1: {
                colorType = ImageInfo.ColorType.BW;
                break;
            }
            case 2: {
                colorType = ImageInfo.ColorType.RGB;
                transparent = samplesPerPixel == 4 && extraSamples != 0;
                break;
            }
            case 3: {
                colorType = ImageInfo.ColorType.RGB;
                usesPalette = true;
                break;
            }
            case 5: {
                colorType = ImageInfo.ColorType.CMYK;
                break;
            }
            case 6: {
                colorType = ImageInfo.ColorType.YCbCr;
                break;
            }
            default: {
                colorType = ImageInfo.ColorType.UNKNOWN;
            }
        }
        short compressionFieldValue = directory.findField(TiffTagConstants.TIFF_TAG_COMPRESSION) != null ? directory.getFieldValue(TiffTagConstants.TIFF_TAG_COMPRESSION) : (short)1;
        int compression = 0xFFFF & compressionFieldValue;
        switch (compression) {
            case 1: {
                compressionAlgorithm = ImageInfo.CompressionAlgorithm.NONE;
                break;
            }
            case 2: {
                compressionAlgorithm = ImageInfo.CompressionAlgorithm.CCITT_1D;
                break;
            }
            case 3: {
                compressionAlgorithm = ImageInfo.CompressionAlgorithm.CCITT_GROUP_3;
                break;
            }
            case 4: {
                compressionAlgorithm = ImageInfo.CompressionAlgorithm.CCITT_GROUP_4;
                break;
            }
            case 5: {
                compressionAlgorithm = ImageInfo.CompressionAlgorithm.LZW;
                break;
            }
            case 6: {
                compressionAlgorithm = ImageInfo.CompressionAlgorithm.JPEG_TIFF_OBSOLETE;
                break;
            }
            case 7: {
                compressionAlgorithm = ImageInfo.CompressionAlgorithm.JPEG;
                break;
            }
            case 32771: {
                compressionAlgorithm = ImageInfo.CompressionAlgorithm.NONE;
                break;
            }
            case 32773: {
                compressionAlgorithm = ImageInfo.CompressionAlgorithm.PACKBITS;
                break;
            }
            case 8: 
            case 32946: {
                compressionAlgorithm = ImageInfo.CompressionAlgorithm.DEFLATE;
                break;
            }
            default: {
                compressionAlgorithm = ImageInfo.CompressionAlgorithm.UNKNOWN;
            }
        }
        return new ImageInfo(formatDetails, bitsPerPixel, comments, format, "TIFF Tag-based Image File Format", height, "image/tiff", numberOfImages, physicalHeightDpi, physicalHeightInch, physicalWidthDpi, physicalWidthInch, width, false, transparent, usesPalette, colorType, compressionAlgorithm);
    }

    @Override
    public Dimension getImageSize(ByteSource byteSource, TiffImagingParameters params) throws ImagingException, IOException {
        FormatCompliance formatCompliance = FormatCompliance.getDefault();
        TiffContents contents = new TiffReader(params != null && params.isStrict()).readFirstDirectory(byteSource, false, formatCompliance);
        TiffDirectory directory = contents.directories.get(0);
        TiffField widthField = directory.findField(TiffTagConstants.TIFF_TAG_IMAGE_WIDTH, true);
        TiffField heightField = directory.findField(TiffTagConstants.TIFF_TAG_IMAGE_LENGTH, true);
        if (widthField == null || heightField == null) {
            throw new ImagingException("TIFF image missing size info.");
        }
        int height = heightField.getIntValue();
        int width = widthField.getIntValue();
        return new Dimension(width, height);
    }

    @Override
    public ImageMetadata getMetadata(ByteSource byteSource, TiffImagingParameters params) throws ImagingException, IOException {
        if (params == null) {
            params = this.getDefaultParameters();
        }
        FormatCompliance formatCompliance = FormatCompliance.getDefault();
        TiffReader tiffReader = new TiffReader(params.isStrict());
        TiffContents contents = tiffReader.readContents(byteSource, params, formatCompliance);
        List<TiffDirectory> directories = contents.directories;
        TiffImageMetadata result = new TiffImageMetadata(contents);
        for (TiffDirectory dir : directories) {
            TiffImageMetadata.Directory metadataDirectory = new TiffImageMetadata.Directory(tiffReader.getByteOrder(), dir);
            List<TiffField> entries = dir.getDirectoryEntries();
            for (TiffField entry : entries) {
                metadataDirectory.add(entry);
            }
            result.add(metadataDirectory);
        }
        return result;
    }

    @Override
    public String getName() {
        return "Tiff-Custom";
    }

    private PhotometricInterpreter getPhotometricInterpreter(TiffDirectory directory, int photometricInterpretation, int bitsPerPixel, int[] bitsPerSample, int predictor, int samplesPerPixel, int width, int height) throws ImagingException {
        switch (photometricInterpretation) {
            case 0: 
            case 1: {
                boolean invert = photometricInterpretation == 0;
                return new PhotometricInterpreterBiLevel(samplesPerPixel, bitsPerSample, predictor, width, height, invert);
            }
            case 3: {
                int[] colorMap = directory.findField(TiffTagConstants.TIFF_TAG_COLOR_MAP, true).getIntArrayValue();
                int expectedColormapSize = 3 * (1 << bitsPerPixel);
                if (colorMap.length != expectedColormapSize) {
                    throw new ImagingException("Tiff: fColorMap.length (" + colorMap.length + ") != expectedColormapSize (" + expectedColormapSize + ")");
                }
                return new PhotometricInterpreterPalette(samplesPerPixel, bitsPerSample, predictor, width, height, colorMap);
            }
            case 2: {
                return new PhotometricInterpreterRgb(samplesPerPixel, bitsPerSample, predictor, width, height);
            }
            case 5: {
                return new PhotometricInterpreterCmyk(samplesPerPixel, bitsPerSample, predictor, width, height);
            }
            case 6: {
                return new PhotometricInterpreterYCbCr(samplesPerPixel, bitsPerSample, predictor, width, height);
            }
            case 8: {
                return new PhotometricInterpreterCieLab(samplesPerPixel, bitsPerSample, predictor, width, height);
            }
            case 32844: 
            case 32845: {
                return new PhotometricInterpreterLogLuv(samplesPerPixel, bitsPerSample, predictor, width, height);
            }
        }
        throw new ImagingException("TIFF: Unknown fPhotometricInterpretation: " + photometricInterpretation);
    }

    TiffRasterData getRasterData(TiffDirectory directory, ByteOrder byteOrder, TiffImagingParameters params) throws ImagingException, IOException {
        TiffField pcField;
        TiffPlanarConfiguration planarConfiguration;
        short[] sSampleFmt;
        if (params == null) {
            params = this.getDefaultParameters();
        }
        if ((sSampleFmt = directory.getFieldValue(TiffTagConstants.TIFF_TAG_SAMPLE_FORMAT, true)) == null || sSampleFmt.length < 1) {
            throw new ImagingException("Directory does not specify numeric raster data");
        }
        int samplesPerPixel = 1;
        TiffField samplesPerPixelField = directory.findField(TiffTagConstants.TIFF_TAG_SAMPLES_PER_PIXEL);
        if (samplesPerPixelField != null) {
            samplesPerPixel = samplesPerPixelField.getIntValue();
        }
        int[] bitsPerSample = new int[]{1};
        int bitsPerPixel = samplesPerPixel;
        TiffField bitsPerSampleField = directory.findField(TiffTagConstants.TIFF_TAG_BITS_PER_SAMPLE);
        if (bitsPerSampleField != null) {
            bitsPerSample = bitsPerSampleField.getIntArrayValue();
            bitsPerPixel = bitsPerSampleField.getIntValueOrArraySum();
        }
        short compressionFieldValue = directory.findField(TiffTagConstants.TIFF_TAG_COMPRESSION) != null ? directory.getFieldValue(TiffTagConstants.TIFF_TAG_COMPRESSION) : (short)1;
        int compression = 0xFFFF & compressionFieldValue;
        int width = directory.getSingleFieldValue(TiffTagConstants.TIFF_TAG_IMAGE_WIDTH);
        int height = directory.getSingleFieldValue(TiffTagConstants.TIFF_TAG_IMAGE_LENGTH);
        Rectangle subImage = this.checkForSubImage(params);
        if (subImage != null) {
            if (subImage.width <= 0) {
                throw new ImagingException("Negative or zero subimage width.");
            }
            if (subImage.height <= 0) {
                throw new ImagingException("Negative or zero subimage height.");
            }
            if (subImage.x < 0 || subImage.x >= width) {
                throw new ImagingException("Subimage x is outside raster.");
            }
            if (subImage.x + subImage.width > width) {
                throw new ImagingException("Subimage (x+width) is outside raster.");
            }
            if (subImage.y < 0 || subImage.y >= height) {
                throw new ImagingException("Subimage y is outside raster.");
            }
            if (subImage.y + subImage.height > height) {
                throw new ImagingException("Subimage (y+height) is outside raster.");
            }
            if (subImage.x == 0 && subImage.y == 0 && subImage.width == width && subImage.height == height) {
                subImage = null;
            }
        }
        int predictor = -1;
        TiffField predictorField = directory.findField(TiffTagConstants.TIFF_TAG_PREDICTOR);
        if (null != predictorField) {
            predictor = predictorField.getIntValueOrArraySum();
        }
        TiffPlanarConfiguration tiffPlanarConfiguration = planarConfiguration = (pcField = directory.findField(TiffTagConstants.TIFF_TAG_PLANAR_CONFIGURATION)) == null ? TiffPlanarConfiguration.CHUNKY : TiffPlanarConfiguration.lenientValueOf(pcField.getIntValue());
        if (sSampleFmt[0] == 3) {
            if (bitsPerSample[0] != 32 && bitsPerSample[0] != 64) {
                throw new ImagingException("TIFF floating-point data uses unsupported bits-per-sample: " + bitsPerSample[0]);
            }
            if (predictor != -1 && predictor != 1 && predictor != 3) {
                throw new ImagingException("TIFF floating-point data uses unsupported horizontal-differencing predictor");
            }
        } else if (sSampleFmt[0] == 2) {
            if (samplesPerPixel != 1) {
                throw new ImagingException("TIFF integer data uses unsupported samples per pixel: " + samplesPerPixel);
            }
            if (bitsPerPixel != 16 && bitsPerPixel != 32) {
                throw new ImagingException("TIFF integer data uses unsupported bits-per-pixel: " + bitsPerPixel);
            }
            if (predictor != -1 && predictor != 1 && predictor != 2) {
                throw new ImagingException("TIFF integer data uses unsupported horizontal-differencing predictor");
            }
        } else {
            throw new ImagingException("TIFF does not provide a supported raster-data format");
        }
        PhotometricInterpreterBiLevel photometricInterpreter = new PhotometricInterpreterBiLevel(samplesPerPixel, bitsPerSample, predictor, width, height, false);
        AbstractTiffImageData imageData = directory.getTiffImageData();
        ImageDataReader dataReader = imageData.getDataReader(directory, photometricInterpreter, bitsPerPixel, bitsPerSample, predictor, samplesPerPixel, width, height, compression, planarConfiguration, byteOrder);
        return dataReader.readRasterData(subImage);
    }

    @Override
    public String getXmpXml(ByteSource byteSource, XmpImagingParameters<TiffImagingParameters> params) throws ImagingException, IOException {
        if (params == null) {
            params = new XmpImagingParameters();
        }
        FormatCompliance formatCompliance = FormatCompliance.getDefault();
        TiffContents contents = new TiffReader(params.isStrict()).readDirectories(byteSource, false, formatCompliance);
        TiffDirectory directory = contents.directories.get(0);
        byte[] bytes = directory.getFieldValue(TiffTagConstants.TIFF_TAG_XMP, false);
        if (bytes == null) {
            return null;
        }
        return new String(bytes, StandardCharsets.UTF_8);
    }

    @Override
    public void writeImage(BufferedImage src, OutputStream os, TiffImagingParameters params) throws ImagingException, IOException {
        if (params == null) {
            params = new TiffImagingParameters();
        }
        new TiffImageWriterLossy().writeImage(src, os, params);
    }
}

