/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.webp.chunks;

import java.io.IOException;
import java.io.PrintWriter;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.common.BinaryFileParser;
import org.apache.commons.imaging.internal.SafeOperations;

public abstract class WebPChunk
extends BinaryFileParser {
    private final int type;
    private final int size;
    protected final byte[] bytes;
    private final int chunkSize;

    WebPChunk(int type, int size, byte[] bytes) throws ImagingException {
        super(ByteOrder.LITTLE_ENDIAN);
        if (size != bytes.length) {
            throw new ImagingException("Chunk size must match bytes length");
        }
        this.type = type;
        this.size = size;
        this.bytes = bytes;
        int padding = size % 2 != 0 ? 1 : 0;
        this.chunkSize = SafeOperations.add(4, 4, size, padding);
    }

    public void dump(PrintWriter pw, int offset) throws ImagingException, IOException {
        pw.printf("Chunk %s at offset %s, length %d%n, payload size %d%n", this.getTypeDescription(), offset >= 0 ? String.valueOf(offset) : "unknown", this.getChunkSize(), this.getPayloadSize());
    }

    public byte[] getBytes() {
        return (byte[])this.bytes.clone();
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    public int getPayloadSize() {
        return this.size;
    }

    public int getType() {
        return this.type;
    }

    public String getTypeDescription() {
        return new String(new byte[]{(byte)(this.type & 0xFF), (byte)(this.type >> 8 & 0xFF), (byte)(this.type >> 16 & 0xFF), (byte)(this.type >> 24 & 0xFF)}, StandardCharsets.UTF_8);
    }
}

