/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.icc;

import java.awt.color.ICC_Profile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.bytesource.ByteSource;
import org.apache.commons.imaging.common.Allocator;
import org.apache.commons.imaging.common.BinaryFileParser;
import org.apache.commons.imaging.common.BinaryFunctions;
import org.apache.commons.imaging.icc.CachingInputStream;
import org.apache.commons.imaging.icc.IccProfileInfo;
import org.apache.commons.imaging.icc.IccTag;
import org.apache.commons.imaging.icc.IccTagType;
import org.apache.commons.imaging.icc.IccTagTypes;
import org.apache.commons.io.IOUtils;

public class IccProfileParser
extends BinaryFileParser {
    private static final Logger LOGGER = Logger.getLogger(IccProfileParser.class.getName());

    public IccProfileParser() {
        super(ByteOrder.BIG_ENDIAN);
    }

    public IccProfileInfo getIccProfileInfo(byte[] bytes) throws IOException {
        if (bytes == null) {
            return null;
        }
        return this.getIccProfileInfo(ByteSource.array(bytes));
    }

    public IccProfileInfo getIccProfileInfo(ByteSource byteSource) throws IOException {
        IccProfileInfo result;
        try (InputStream is = byteSource.getInputStream();){
            result = this.readIccProfileInfo(is);
        }
        for (IccTag tag : result.getTags()) {
            byte[] bytes = byteSource.getByteArray(tag.offset, tag.length);
            tag.setData(bytes);
        }
        return result;
    }

    public IccProfileInfo getIccProfileInfo(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return this.getIccProfileInfo(ByteSource.file(file));
    }

    public IccProfileInfo getIccProfileInfo(ICC_Profile iccProfile) throws IOException {
        if (iccProfile == null) {
            return null;
        }
        return this.getIccProfileInfo(ByteSource.array(iccProfile.getData()));
    }

    private IccTagType getIccTagType(int quad) {
        for (IccTagTypes iccTagType : IccTagTypes.values()) {
            if (iccTagType.getSignature() != quad) continue;
            return iccTagType;
        }
        return null;
    }

    public boolean isSrgb(byte[] bytes) throws IOException {
        return this.isSrgb(ByteSource.array(bytes));
    }

    public boolean isSrgb(ByteSource byteSource) throws IOException {
        try (InputStream is = byteSource.getInputStream();){
            BinaryFunctions.read4Bytes("ProfileSize", is, "Not a Valid ICC Profile", this.getByteOrder());
            BinaryFunctions.skipBytes(is, 20L);
            BinaryFunctions.skipBytes(is, 12L, "Not a Valid ICC Profile");
            BinaryFunctions.skipBytes(is, 12L);
            int deviceManufacturer = BinaryFunctions.read4Bytes("ProfileFileSignature", is, "Not a Valid ICC Profile", this.getByteOrder());
            if (LOGGER.isLoggable(Level.FINEST)) {
                BinaryFunctions.logCharQuad("DeviceManufacturer", deviceManufacturer);
            }
            int deviceModel = BinaryFunctions.read4Bytes("DeviceModel", is, "Not a Valid ICC Profile", this.getByteOrder());
            if (LOGGER.isLoggable(Level.FINEST)) {
                BinaryFunctions.logCharQuad("DeviceModel", deviceModel);
            }
            boolean bl = deviceManufacturer == 1229275936 && deviceModel == 1934772034;
            return bl;
        }
    }

    public boolean isSrgb(File file) throws IOException {
        return this.isSrgb(ByteSource.file(file));
    }

    public boolean isSrgb(ICC_Profile iccProfile) throws IOException {
        return this.isSrgb(ByteSource.array(iccProfile.getData()));
    }

    private IccProfileInfo readIccProfileInfo(InputStream is) throws IOException {
        CachingInputStream cis = new CachingInputStream(is);
        is = cis;
        int profileSize = BinaryFunctions.read4Bytes("ProfileSize", is, "Not a Valid ICC Profile", this.getByteOrder());
        int cmmTypeSignature = BinaryFunctions.read4Bytes("Signature", is, "Not a Valid ICC Profile", this.getByteOrder());
        if (LOGGER.isLoggable(Level.FINEST)) {
            BinaryFunctions.logCharQuad("CMMTypeSignature", cmmTypeSignature);
        }
        int profileVersion = BinaryFunctions.read4Bytes("ProfileVersion", is, "Not a Valid ICC Profile", this.getByteOrder());
        int profileDeviceClassSignature = BinaryFunctions.read4Bytes("ProfileDeviceClassSignature", is, "Not a Valid ICC Profile", this.getByteOrder());
        if (LOGGER.isLoggable(Level.FINEST)) {
            BinaryFunctions.logCharQuad("ProfileDeviceClassSignature", profileDeviceClassSignature);
        }
        int colorSpace = BinaryFunctions.read4Bytes("ColorSpace", is, "Not a Valid ICC Profile", this.getByteOrder());
        if (LOGGER.isLoggable(Level.FINEST)) {
            BinaryFunctions.logCharQuad("ColorSpace", colorSpace);
        }
        int profileConnectionSpace = BinaryFunctions.read4Bytes("ProfileConnectionSpace", is, "Not a Valid ICC Profile", this.getByteOrder());
        if (LOGGER.isLoggable(Level.FINEST)) {
            BinaryFunctions.logCharQuad("ProfileConnectionSpace", profileConnectionSpace);
        }
        BinaryFunctions.skipBytes(is, 12L, "Not a Valid ICC Profile");
        int profileFileSignature = BinaryFunctions.read4Bytes("ProfileFileSignature", is, "Not a Valid ICC Profile", this.getByteOrder());
        if (LOGGER.isLoggable(Level.FINEST)) {
            BinaryFunctions.logCharQuad("ProfileFileSignature", profileFileSignature);
        }
        int primaryPlatformSignature = BinaryFunctions.read4Bytes("PrimaryPlatformSignature", is, "Not a Valid ICC Profile", this.getByteOrder());
        if (LOGGER.isLoggable(Level.FINEST)) {
            BinaryFunctions.logCharQuad("PrimaryPlatformSignature", primaryPlatformSignature);
        }
        int variousFlags = BinaryFunctions.read4Bytes("VariousFlags", is, "Not a Valid ICC Profile", this.getByteOrder());
        if (LOGGER.isLoggable(Level.FINEST)) {
            BinaryFunctions.logCharQuad("VariousFlags", profileFileSignature);
        }
        int deviceManufacturer = BinaryFunctions.read4Bytes("DeviceManufacturer", is, "Not a Valid ICC Profile", this.getByteOrder());
        if (LOGGER.isLoggable(Level.FINEST)) {
            BinaryFunctions.logCharQuad("DeviceManufacturer", deviceManufacturer);
        }
        int deviceModel = BinaryFunctions.read4Bytes("DeviceModel", is, "Not a Valid ICC Profile", this.getByteOrder());
        if (LOGGER.isLoggable(Level.FINEST)) {
            BinaryFunctions.logCharQuad("DeviceModel", deviceModel);
        }
        BinaryFunctions.skipBytes(is, 8L, "Not a Valid ICC Profile");
        int renderingIntent = BinaryFunctions.read4Bytes("RenderingIntent", is, "Not a Valid ICC Profile", this.getByteOrder());
        if (LOGGER.isLoggable(Level.FINEST)) {
            BinaryFunctions.logCharQuad("RenderingIntent", renderingIntent);
        }
        BinaryFunctions.skipBytes(is, 12L, "Not a Valid ICC Profile");
        int profileCreatorSignature = BinaryFunctions.read4Bytes("ProfileCreatorSignature", is, "Not a Valid ICC Profile", this.getByteOrder());
        if (LOGGER.isLoggable(Level.FINEST)) {
            BinaryFunctions.logCharQuad("ProfileCreatorSignature", profileCreatorSignature);
        }
        BinaryFunctions.skipBytes(is, 16L, "Not a Valid ICC Profile");
        BinaryFunctions.skipBytes(is, 28L, "Not a Valid ICC Profile");
        int tagCount = BinaryFunctions.read4Bytes("TagCount", is, "Not a Valid ICC Profile", this.getByteOrder());
        IccTag[] tags = (IccTag[])Allocator.array(tagCount, IccTag[]::new, 40);
        for (int i = 0; i < tagCount; ++i) {
            IccTag tag;
            int tagSignature = BinaryFunctions.read4Bytes("TagSignature[" + i + "]", is, "Not a Valid ICC Profile", this.getByteOrder());
            int offsetToData = BinaryFunctions.read4Bytes("OffsetToData[" + i + "]", is, "Not a Valid ICC Profile", this.getByteOrder());
            int elementSize = BinaryFunctions.read4Bytes("ElementSize[" + i + "]", is, "Not a Valid ICC Profile", this.getByteOrder());
            IccTagType fIccTagType = this.getIccTagType(tagSignature);
            tags[i] = tag = new IccTag(tagSignature, offsetToData, elementSize, fIccTagType);
        }
        IOUtils.consume((InputStream)is);
        byte[] data = cis.getCache();
        if (data.length < profileSize) {
            throw new ImagingException("Couldn't read ICC Profile.");
        }
        IccProfileInfo result = new IccProfileInfo(data, profileSize, cmmTypeSignature, profileVersion, profileDeviceClassSignature, colorSpace, profileConnectionSpace, profileFileSignature, primaryPlatformSignature, variousFlags, deviceManufacturer, deviceModel, renderingIntent, profileCreatorSignature, null, tags);
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("issRGB: " + result.isSrgb());
        }
        return result;
    }
}

