/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.sql.Date;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Random;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ArrayUtilsTest {
    private static final long SEED = 16111981L;

    @SafeVarargs
    private static <T> T[] toArrayPropagatingType(T ... items) {
        return ArrayUtils.toArray((Object[])items);
    }

    private void assertIsEquals(Object array1, Object array2, Object array3) {
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)array1, (Object)array1));
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)array2, (Object)array2));
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)array3, (Object)array3));
        Assertions.assertFalse((boolean)ArrayUtils.isEquals((Object)array1, (Object)array2));
        Assertions.assertFalse((boolean)ArrayUtils.isEquals((Object)array2, (Object)array1));
        Assertions.assertFalse((boolean)ArrayUtils.isEquals((Object)array1, (Object)array3));
        Assertions.assertFalse((boolean)ArrayUtils.isEquals((Object)array3, (Object)array1));
        Assertions.assertFalse((boolean)ArrayUtils.isEquals((Object)array1, (Object)array2));
        Assertions.assertFalse((boolean)ArrayUtils.isEquals((Object)array2, (Object)array1));
    }

    @Test
    public void testArrayCreation() {
        String[] array = (String[])ArrayUtils.toArray((Object[])new String[]{"foo", "bar"});
        Assertions.assertEquals((int)2, (int)array.length);
        Assertions.assertEquals((Object)"foo", (Object)array[0]);
        Assertions.assertEquals((Object)"bar", (Object)array[1]);
    }

    @Test
    public void testArrayCreationWithDifferentTypes() {
        Number[] array = (Number[])ArrayUtils.toArray((Object[])new Number[]{42, Math.PI});
        Assertions.assertEquals((int)2, (int)array.length);
        Assertions.assertEquals((Object)42, (Object)array[0]);
        Assertions.assertEquals((Object)Math.PI, (Object)array[1]);
    }

    @Test
    public void testArrayCreationWithGeneralReturnType() {
        Object[] obj = ArrayUtils.toArray((Object[])new String[]{"foo", "bar"});
        Assertions.assertTrue((boolean)(obj instanceof String[]));
    }

    @Test
    public void testClone() {
        Assertions.assertArrayEquals(null, (Object[])ArrayUtils.clone((Object[])null));
        Object[] original1 = new Object[]{};
        Object[] cloned1 = ArrayUtils.clone((Object[])original1);
        Assertions.assertArrayEquals((Object[])original1, (Object[])cloned1);
        Assertions.assertNotSame((Object)original1, (Object)cloned1);
        StringBuilder builder = new StringBuilder("pick");
        original1 = new Object[]{builder, "a", new String[]{"stick"}};
        cloned1 = ArrayUtils.clone((Object[])original1);
        Assertions.assertArrayEquals((Object[])original1, (Object[])cloned1);
        Assertions.assertNotSame((Object)original1, (Object)cloned1);
        Assertions.assertSame((Object)original1[0], (Object)cloned1[0]);
        Assertions.assertSame((Object)original1[1], (Object)cloned1[1]);
        Assertions.assertSame((Object)original1[2], (Object)cloned1[2]);
    }

    @Test
    public void testCloneBoolean() {
        Assertions.assertNull((Object)ArrayUtils.clone((boolean[])null));
        boolean[] original = new boolean[]{true, false};
        boolean[] cloned = ArrayUtils.clone((boolean[])original);
        Assertions.assertArrayEquals((boolean[])original, (boolean[])cloned);
        Assertions.assertNotSame((Object)original, (Object)cloned);
    }

    @Test
    public void testCloneByte() {
        Assertions.assertNull((Object)ArrayUtils.clone((byte[])null));
        byte[] original = new byte[]{1, 6};
        byte[] cloned = ArrayUtils.clone((byte[])original);
        Assertions.assertArrayEquals((byte[])original, (byte[])cloned);
        Assertions.assertNotSame((Object)original, (Object)cloned);
    }

    @Test
    public void testCloneChar() {
        Assertions.assertNull((Object)ArrayUtils.clone((char[])null));
        char[] original = new char[]{'a', '4'};
        char[] cloned = ArrayUtils.clone((char[])original);
        Assertions.assertArrayEquals((char[])original, (char[])cloned);
        Assertions.assertNotSame((Object)original, (Object)cloned);
    }

    @Test
    public void testCloneDouble() {
        Assertions.assertNull((Object)ArrayUtils.clone((double[])null));
        double[] original = new double[]{2.4, 5.7};
        double[] cloned = ArrayUtils.clone((double[])original);
        Assertions.assertArrayEquals((double[])original, (double[])cloned);
        Assertions.assertNotSame((Object)original, (Object)cloned);
    }

    @Test
    public void testCloneFloat() {
        Assertions.assertNull((Object)ArrayUtils.clone((float[])null));
        float[] original = new float[]{2.6f, 6.4f};
        float[] cloned = ArrayUtils.clone((float[])original);
        Assertions.assertArrayEquals((float[])original, (float[])cloned);
        Assertions.assertNotSame((Object)original, (Object)cloned);
    }

    @Test
    public void testCloneInt() {
        Assertions.assertNull((Object)ArrayUtils.clone((int[])null));
        int[] original = new int[]{5, 8};
        int[] cloned = ArrayUtils.clone((int[])original);
        Assertions.assertArrayEquals((int[])original, (int[])cloned);
        Assertions.assertNotSame((Object)original, (Object)cloned);
    }

    @Test
    public void testCloneLong() {
        Assertions.assertNull((Object)ArrayUtils.clone((long[])null));
        long[] original = new long[]{0L, 1L};
        long[] cloned = ArrayUtils.clone((long[])original);
        Assertions.assertArrayEquals((long[])original, (long[])cloned);
        Assertions.assertNotSame((Object)original, (Object)cloned);
    }

    @Test
    public void testCloneShort() {
        Assertions.assertNull((Object)ArrayUtils.clone((short[])null));
        short[] original = new short[]{1, 4};
        short[] cloned = ArrayUtils.clone((short[])original);
        Assertions.assertArrayEquals((short[])original, (short[])cloned);
        Assertions.assertNotSame((Object)original, (Object)cloned);
    }

    @Test
    public void testConstructor() {
        Assertions.assertNotNull((Object)new ArrayUtils());
        Constructor<?>[] cons = ArrayUtils.class.getDeclaredConstructors();
        Assertions.assertEquals((int)1, (int)cons.length);
        Assertions.assertTrue((boolean)Modifier.isPublic(cons[0].getModifiers()));
        Assertions.assertTrue((boolean)Modifier.isPublic(ArrayUtils.class.getModifiers()));
        Assertions.assertFalse((boolean)Modifier.isFinal(ArrayUtils.class.getModifiers()));
    }

    @Test
    public void testContains() {
        Object[] array = new Object[]{"0", "1", "2", "3", null, "0"};
        Assertions.assertFalse((boolean)ArrayUtils.contains(null, null));
        Assertions.assertFalse((boolean)ArrayUtils.contains(null, (Object)"1"));
        Assertions.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)"0"));
        Assertions.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)"1"));
        Assertions.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)"2"));
        Assertions.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)"3"));
        Assertions.assertTrue((boolean)ArrayUtils.contains((Object[])array, null));
        Assertions.assertFalse((boolean)ArrayUtils.contains((Object[])array, (Object)"notInArray"));
    }

    @Test
    public void testContains_LANG_1261() {
        class LANG1261ChildObject
        extends LANG1261ParentObject {
            LANG1261ChildObject() {
                class LANG1261ParentObject {
                    LANG1261ParentObject() {
                    }

                    public boolean equals(Object o) {
                        return true;
                    }
                }
            }
        }
        Object[] array = new LANG1261ChildObject[]{new LANG1261ChildObject()};
        Assertions.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)new LANG1261ParentObject()));
    }

    @Test
    public void testContainsBoolean() {
        boolean[] array = null;
        Assertions.assertFalse((boolean)ArrayUtils.contains(array, (boolean)true));
        array = new boolean[]{true, false, true};
        Assertions.assertTrue((boolean)ArrayUtils.contains((boolean[])array, (boolean)true));
        Assertions.assertTrue((boolean)ArrayUtils.contains((boolean[])array, (boolean)false));
        array = new boolean[]{true, true};
        Assertions.assertTrue((boolean)ArrayUtils.contains((boolean[])array, (boolean)true));
        Assertions.assertFalse((boolean)ArrayUtils.contains((boolean[])array, (boolean)false));
    }

    @Test
    public void testContainsByte() {
        byte[] array = null;
        Assertions.assertFalse((boolean)ArrayUtils.contains(array, (byte)1));
        array = new byte[]{0, 1, 2, 3, 0};
        Assertions.assertTrue((boolean)ArrayUtils.contains((byte[])array, (byte)0));
        Assertions.assertTrue((boolean)ArrayUtils.contains((byte[])array, (byte)1));
        Assertions.assertTrue((boolean)ArrayUtils.contains((byte[])array, (byte)2));
        Assertions.assertTrue((boolean)ArrayUtils.contains((byte[])array, (byte)3));
        Assertions.assertFalse((boolean)ArrayUtils.contains((byte[])array, (byte)99));
    }

    @Test
    public void testContainsChar() {
        char[] array = null;
        Assertions.assertFalse((boolean)ArrayUtils.contains(array, (char)'b'));
        array = new char[]{'a', 'b', 'c', 'd', 'a'};
        Assertions.assertTrue((boolean)ArrayUtils.contains((char[])array, (char)'a'));
        Assertions.assertTrue((boolean)ArrayUtils.contains((char[])array, (char)'b'));
        Assertions.assertTrue((boolean)ArrayUtils.contains((char[])array, (char)'c'));
        Assertions.assertTrue((boolean)ArrayUtils.contains((char[])array, (char)'d'));
        Assertions.assertFalse((boolean)ArrayUtils.contains((char[])array, (char)'e'));
    }

    @Test
    public void testContainsDouble() {
        double[] array = null;
        Assertions.assertFalse((boolean)ArrayUtils.contains(array, (double)1.0));
        array = new double[]{0.0, 1.0, 2.0, 3.0, 0.0};
        Assertions.assertTrue((boolean)ArrayUtils.contains((double[])array, (double)0.0));
        Assertions.assertTrue((boolean)ArrayUtils.contains((double[])array, (double)1.0));
        Assertions.assertTrue((boolean)ArrayUtils.contains((double[])array, (double)2.0));
        Assertions.assertTrue((boolean)ArrayUtils.contains((double[])array, (double)3.0));
        Assertions.assertFalse((boolean)ArrayUtils.contains((double[])array, (double)99.0));
    }

    @Test
    public void testContainsDoubleTolerance() {
        double[] array = null;
        Assertions.assertFalse((boolean)ArrayUtils.contains(array, (double)1.0, (double)0.0));
        array = new double[]{0.0, 1.0, 2.0, 3.0, 0.0};
        Assertions.assertFalse((boolean)ArrayUtils.contains((double[])array, (double)4.0, (double)0.33));
        Assertions.assertFalse((boolean)ArrayUtils.contains((double[])array, (double)2.5, (double)0.49));
        Assertions.assertTrue((boolean)ArrayUtils.contains((double[])array, (double)2.5, (double)0.5));
        Assertions.assertTrue((boolean)ArrayUtils.contains((double[])array, (double)2.5, (double)0.51));
    }

    @Test
    public void testContainsFloat() {
        float[] array = null;
        Assertions.assertFalse((boolean)ArrayUtils.contains(array, (float)1.0f));
        array = new float[]{0.0f, 1.0f, 2.0f, 3.0f, 0.0f};
        Assertions.assertTrue((boolean)ArrayUtils.contains((float[])array, (float)0.0f));
        Assertions.assertTrue((boolean)ArrayUtils.contains((float[])array, (float)1.0f));
        Assertions.assertTrue((boolean)ArrayUtils.contains((float[])array, (float)2.0f));
        Assertions.assertTrue((boolean)ArrayUtils.contains((float[])array, (float)3.0f));
        Assertions.assertFalse((boolean)ArrayUtils.contains((float[])array, (float)99.0f));
    }

    @Test
    public void testContainsInt() {
        int[] array = null;
        Assertions.assertFalse((boolean)ArrayUtils.contains(array, (int)1));
        array = new int[]{0, 1, 2, 3, 0};
        Assertions.assertTrue((boolean)ArrayUtils.contains((int[])array, (int)0));
        Assertions.assertTrue((boolean)ArrayUtils.contains((int[])array, (int)1));
        Assertions.assertTrue((boolean)ArrayUtils.contains((int[])array, (int)2));
        Assertions.assertTrue((boolean)ArrayUtils.contains((int[])array, (int)3));
        Assertions.assertFalse((boolean)ArrayUtils.contains((int[])array, (int)99));
    }

    @Test
    public void testContainsLong() {
        long[] array = null;
        Assertions.assertFalse((boolean)ArrayUtils.contains(array, (long)1L));
        array = new long[]{0L, 1L, 2L, 3L, 0L};
        Assertions.assertTrue((boolean)ArrayUtils.contains((long[])array, (long)0L));
        Assertions.assertTrue((boolean)ArrayUtils.contains((long[])array, (long)1L));
        Assertions.assertTrue((boolean)ArrayUtils.contains((long[])array, (long)2L));
        Assertions.assertTrue((boolean)ArrayUtils.contains((long[])array, (long)3L));
        Assertions.assertFalse((boolean)ArrayUtils.contains((long[])array, (long)99L));
    }

    @Test
    public void testContainsShort() {
        short[] array = null;
        Assertions.assertFalse((boolean)ArrayUtils.contains(array, (short)1));
        array = new short[]{0, 1, 2, 3, 0};
        Assertions.assertTrue((boolean)ArrayUtils.contains((short[])array, (short)0));
        Assertions.assertTrue((boolean)ArrayUtils.contains((short[])array, (short)1));
        Assertions.assertTrue((boolean)ArrayUtils.contains((short[])array, (short)2));
        Assertions.assertTrue((boolean)ArrayUtils.contains((short[])array, (short)3));
        Assertions.assertFalse((boolean)ArrayUtils.contains((short[])array, (short)99));
    }

    @Test
    public void testCreatePrimitiveArray() {
        Assertions.assertNull((Object)ArrayUtils.toPrimitive((Object)null));
        Assertions.assertArrayEquals((int[])new int[0], (int[])ArrayUtils.toPrimitive((Integer[])new Integer[0]));
        Assertions.assertArrayEquals((short[])new short[]{2}, (short[])ArrayUtils.toPrimitive((Short[])new Short[]{(short)2}));
        Assertions.assertArrayEquals((long[])new long[]{2L, 3L}, (long[])ArrayUtils.toPrimitive((Long[])new Long[]{2L, 3L}));
        Assertions.assertArrayEquals((float[])new float[]{3.14f}, (float[])ArrayUtils.toPrimitive((Float[])new Float[]{Float.valueOf(3.14f)}), (float)0.1f);
        Assertions.assertArrayEquals((double[])new double[]{2.718}, (double[])ArrayUtils.toPrimitive((Double[])new Double[]{2.718}), (double)0.1);
    }

    @Test
    public void testEmptyArrayCreation() {
        String[] array = (String[])ArrayUtils.toArray((Object[])new String[0]);
        Assertions.assertEquals((int)0, (int)array.length);
    }

    @Test
    public void testGet() {
        Assertions.assertNull((Object)ArrayUtils.get(null, (int)-1));
        Assertions.assertNull((Object)ArrayUtils.get(null, (int)0));
        Assertions.assertNull((Object)ArrayUtils.get(null, (int)1));
        Object[] array0 = new String[]{};
        Assertions.assertNull((Object)ArrayUtils.get((Object[])array0, (int)-1));
        Assertions.assertNull((Object)ArrayUtils.get((Object[])array0, (int)0));
        Assertions.assertNull((Object)ArrayUtils.get((Object[])array0, (int)1));
        Object[] array1 = new String[]{""};
        Assertions.assertEquals(null, (Object)ArrayUtils.get((Object[])array1, (int)-1));
        Assertions.assertEquals((Object)"", (Object)ArrayUtils.get((Object[])array1, (int)0));
        Assertions.assertEquals(null, (Object)ArrayUtils.get((Object[])array1, (int)1));
    }

    @Test
    public void testGetDefault() {
        Assertions.assertNull((Object)ArrayUtils.get(null, (int)-1, null));
        Assertions.assertNull((Object)ArrayUtils.get(null, (int)0, null));
        Assertions.assertNull((Object)ArrayUtils.get(null, (int)1, null));
        Object[] array0 = new String[]{};
        Assertions.assertNull((Object)ArrayUtils.get((Object[])array0, (int)-1, null));
        Assertions.assertNull((Object)ArrayUtils.get((Object[])array0, (int)0, null));
        Assertions.assertNull((Object)ArrayUtils.get((Object[])array0, (int)1, null));
        Object[] array1 = new String[]{""};
        Assertions.assertEquals(null, (Object)ArrayUtils.get((Object[])array1, (int)-1, null));
        Assertions.assertEquals((Object)"", (Object)ArrayUtils.get((Object[])array1, (int)0, null));
        Assertions.assertEquals(null, (Object)ArrayUtils.get((Object[])array1, (int)1, null));
        String defaultValue = "defaultValue";
        array1 = new String[]{""};
        Assertions.assertEquals((Object)"defaultValue", (Object)ArrayUtils.get((Object[])array1, (int)-1, (Object)"defaultValue"));
        Assertions.assertEquals((Object)"", (Object)ArrayUtils.get((Object[])array1, (int)0, (Object)"defaultValue"));
        Assertions.assertEquals((Object)"defaultValue", (Object)ArrayUtils.get((Object[])array1, (int)1, (Object)"defaultValue"));
    }

    @Test
    public void testGetLength() {
        Assertions.assertEquals((int)0, (int)ArrayUtils.getLength(null));
        Object[] emptyObjectArray = new Object[]{};
        Object[] notEmptyObjectArray = new Object[]{"aValue"};
        Assertions.assertEquals((int)0, (int)ArrayUtils.getLength(null));
        Assertions.assertEquals((int)0, (int)ArrayUtils.getLength((Object)emptyObjectArray));
        Assertions.assertEquals((int)1, (int)ArrayUtils.getLength((Object)notEmptyObjectArray));
        int[] emptyIntArray = new int[]{};
        int[] notEmptyIntArray = new int[]{1};
        Assertions.assertEquals((int)0, (int)ArrayUtils.getLength(null));
        Assertions.assertEquals((int)0, (int)ArrayUtils.getLength((Object)emptyIntArray));
        Assertions.assertEquals((int)1, (int)ArrayUtils.getLength((Object)notEmptyIntArray));
        short[] emptyShortArray = new short[]{};
        short[] notEmptyShortArray = new short[]{1};
        Assertions.assertEquals((int)0, (int)ArrayUtils.getLength(null));
        Assertions.assertEquals((int)0, (int)ArrayUtils.getLength((Object)emptyShortArray));
        Assertions.assertEquals((int)1, (int)ArrayUtils.getLength((Object)notEmptyShortArray));
        char[] emptyCharArray = new char[]{};
        char[] notEmptyCharArray = new char[]{'\u0001'};
        Assertions.assertEquals((int)0, (int)ArrayUtils.getLength(null));
        Assertions.assertEquals((int)0, (int)ArrayUtils.getLength((Object)emptyCharArray));
        Assertions.assertEquals((int)1, (int)ArrayUtils.getLength((Object)notEmptyCharArray));
        byte[] emptyByteArray = new byte[]{};
        byte[] notEmptyByteArray = new byte[]{1};
        Assertions.assertEquals((int)0, (int)ArrayUtils.getLength(null));
        Assertions.assertEquals((int)0, (int)ArrayUtils.getLength((Object)emptyByteArray));
        Assertions.assertEquals((int)1, (int)ArrayUtils.getLength((Object)notEmptyByteArray));
        double[] emptyDoubleArray = new double[]{};
        double[] notEmptyDoubleArray = new double[]{1.0};
        Assertions.assertEquals((int)0, (int)ArrayUtils.getLength(null));
        Assertions.assertEquals((int)0, (int)ArrayUtils.getLength((Object)emptyDoubleArray));
        Assertions.assertEquals((int)1, (int)ArrayUtils.getLength((Object)notEmptyDoubleArray));
        float[] emptyFloatArray = new float[]{};
        float[] notEmptyFloatArray = new float[]{1.0f};
        Assertions.assertEquals((int)0, (int)ArrayUtils.getLength(null));
        Assertions.assertEquals((int)0, (int)ArrayUtils.getLength((Object)emptyFloatArray));
        Assertions.assertEquals((int)1, (int)ArrayUtils.getLength((Object)notEmptyFloatArray));
        boolean[] emptyBooleanArray = new boolean[]{};
        boolean[] notEmptyBooleanArray = new boolean[]{true};
        Assertions.assertEquals((int)0, (int)ArrayUtils.getLength(null));
        Assertions.assertEquals((int)0, (int)ArrayUtils.getLength((Object)emptyBooleanArray));
        Assertions.assertEquals((int)1, (int)ArrayUtils.getLength((Object)notEmptyBooleanArray));
        Assertions.assertThrows(IllegalArgumentException.class, () -> ArrayUtils.getLength((Object)"notAnArray"));
    }

    @Test
    public void testHashCode() {
        long[][] array1 = new long[][]{{2L, 5L}, {4L, 5L}};
        long[][] array2 = new long[][]{{2L, 5L}, {4L, 6L}};
        Assertions.assertEquals((int)ArrayUtils.hashCode((Object)array1), (int)ArrayUtils.hashCode((Object)array1));
        Assertions.assertNotEquals((int)ArrayUtils.hashCode((Object)array1), (int)ArrayUtils.hashCode((Object)array2));
        Object[] array3 = new Object[]{new String(new char[]{'A', 'B'})};
        Object[] array4 = new Object[]{"AB"};
        Assertions.assertEquals((int)ArrayUtils.hashCode((Object)array3), (int)ArrayUtils.hashCode((Object)array3));
        Assertions.assertEquals((int)ArrayUtils.hashCode((Object)array3), (int)ArrayUtils.hashCode((Object)array4));
        Object[] arrayA = new Object[]{new boolean[]{true, false}, new int[]{6, 7}};
        Object[] arrayB = new Object[]{new boolean[]{true, false}, new int[]{6, 7}};
        Assertions.assertEquals((int)ArrayUtils.hashCode((Object)arrayB), (int)ArrayUtils.hashCode((Object)arrayA));
    }

    @Test
    public void testIndexesOf() {
        Object[] array = new Object[]{"0", "1", "2", "3", null, "0"};
        BitSet emptySet = new BitSet();
        BitSet testSet = new BitSet();
        Assertions.assertEquals((Object)emptySet, (Object)ArrayUtils.indexesOf((Object[])null, null));
        Assertions.assertEquals((Object)emptySet, (Object)ArrayUtils.indexesOf((Object[])new Object[0], (Object)"0"));
        testSet.set(5);
        testSet.set(0);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((Object[])array, (Object)"0"));
        testSet.clear();
        testSet.set(2);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((Object[])array, (Object)"2"));
        testSet.clear();
        testSet.set(3);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((Object[])array, (Object)"3"));
        testSet.clear();
        testSet.set(4);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((Object[])array, null));
        Assertions.assertEquals((Object)emptySet, (Object)ArrayUtils.indexesOf((Object[])array, (Object)"notInArray"));
    }

    @Test
    public void testIndexesOfBoolean() {
        boolean[] array = null;
        BitSet emptySet = new BitSet();
        BitSet testSet = new BitSet();
        Assertions.assertEquals((Object)emptySet, (Object)ArrayUtils.indexesOf(array, (boolean)true));
        array = new boolean[]{};
        Assertions.assertEquals((Object)emptySet, (Object)ArrayUtils.indexesOf((boolean[])array, (boolean)true));
        array = new boolean[]{true, false, true};
        testSet.set(0);
        testSet.set(2);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((boolean[])array, (boolean)true));
        testSet.clear();
        testSet.set(1);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((boolean[])array, (boolean)false));
        array = new boolean[]{true, true};
        Assertions.assertEquals((Object)emptySet, (Object)ArrayUtils.indexesOf((boolean[])array, (boolean)false));
    }

    @Test
    public void testIndexesOfBooleanWithStartIndex() {
        boolean[] array = null;
        BitSet emptySet = new BitSet();
        BitSet testSet = new BitSet();
        Assertions.assertEquals((Object)emptySet, (Object)ArrayUtils.indexesOf(array, (boolean)true, (int)0));
        array = new boolean[]{};
        Assertions.assertEquals((Object)emptySet, (Object)ArrayUtils.indexesOf((boolean[])array, (boolean)true, (int)0));
        array = new boolean[]{true, false, true};
        testSet.set(2);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((boolean[])array, (boolean)true, (int)1));
        testSet.set(0);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((boolean[])array, (boolean)true, (int)0));
        testSet.clear();
        testSet.set(1);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((boolean[])array, (boolean)false, (int)1));
        array = new boolean[]{true, true};
        Assertions.assertEquals((Object)emptySet, (Object)ArrayUtils.indexesOf((boolean[])array, (boolean)false, (int)0));
        Assertions.assertEquals((Object)emptySet, (Object)ArrayUtils.indexesOf((boolean[])array, (boolean)false, (int)-1));
    }

    @Test
    public void testIndexesOfByte() {
        byte[] array = null;
        BitSet emptySet = new BitSet();
        BitSet testSet = new BitSet();
        Assertions.assertEquals((Object)emptySet, (Object)ArrayUtils.indexesOf(array, (byte)0));
        array = new byte[]{0, 1, 2, 3, 0};
        testSet.set(0);
        testSet.set(4);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((byte[])array, (byte)0));
        testSet.clear();
        testSet.set(1);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((byte[])array, (byte)1));
        testSet.clear();
        testSet.set(2);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((byte[])array, (byte)2));
        testSet.clear();
        testSet.set(3);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((byte[])array, (byte)3));
        Assertions.assertEquals((Object)emptySet, (Object)ArrayUtils.indexesOf((byte[])array, (byte)99));
    }

    @Test
    public void testIndexesOfByteWithStartIndex() {
        byte[] array = null;
        BitSet emptySet = new BitSet();
        BitSet testSet = new BitSet();
        Assertions.assertEquals((Object)emptySet, (Object)ArrayUtils.indexesOf(array, (byte)0, (int)2));
        array = new byte[]{0, 1, 2, 3, 0};
        testSet.set(4);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((byte[])array, (byte)0, (int)2));
        testSet.set(0);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((byte[])array, (byte)0, (int)0));
        testSet.clear();
        testSet.set(1);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((byte[])array, (byte)1, (int)1));
        testSet.clear();
        testSet.set(2);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((byte[])array, (byte)2, (int)0));
        testSet.clear();
        testSet.set(3);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((byte[])array, (byte)3, (int)0));
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((byte[])array, (byte)3, (int)-1));
        Assertions.assertEquals((Object)emptySet, (Object)ArrayUtils.indexesOf((byte[])array, (byte)99, (int)0));
    }

    @Test
    public void testIndexesOfChar() {
        char[] array = null;
        BitSet emptySet = new BitSet();
        BitSet testSet = new BitSet();
        Assertions.assertEquals((Object)emptySet, (Object)ArrayUtils.indexesOf(array, (char)'a'));
        array = new char[]{'a', 'b', 'c', 'd', 'a'};
        testSet.set(0);
        testSet.set(4);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((char[])array, (char)'a'));
        testSet.clear();
        testSet.set(1);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((char[])array, (char)'b'));
        testSet.clear();
        testSet.set(2);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((char[])array, (char)'c'));
        testSet.clear();
        testSet.set(3);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((char[])array, (char)'d'));
        Assertions.assertEquals((Object)emptySet, (Object)ArrayUtils.indexesOf((char[])array, (char)'e'));
    }

    @Test
    public void testIndexesOfCharWithStartIndex() {
        char[] array = null;
        BitSet emptySet = new BitSet();
        BitSet testSet = new BitSet();
        Assertions.assertEquals((Object)emptySet, (Object)ArrayUtils.indexesOf(array, (char)'a', (int)0));
        array = new char[]{'a', 'b', 'c', 'd', 'a'};
        testSet.set(4);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((char[])array, (char)'a', (int)2));
        testSet.set(0);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((char[])array, (char)'a', (int)0));
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((char[])array, (char)'a', (int)-1));
        testSet.clear();
        testSet.set(1);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((char[])array, (char)'b', (int)1));
        testSet.clear();
        testSet.set(2);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((char[])array, (char)'c', (int)0));
        testSet.clear();
        testSet.set(3);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((char[])array, (char)'d', (int)0));
        Assertions.assertEquals((Object)emptySet, (Object)ArrayUtils.indexesOf((char[])array, (char)'d', (int)5));
        Assertions.assertEquals((Object)emptySet, (Object)ArrayUtils.indexesOf((char[])array, (char)'e', (int)0));
    }

    @Test
    public void testIndexesOfDouble() {
        double[] array = null;
        BitSet emptySet = new BitSet();
        BitSet testSet = new BitSet();
        Assertions.assertEquals((Object)emptySet, (Object)ArrayUtils.indexesOf(array, (double)0.0));
        array = new double[]{0.0, 1.0, 2.0, 3.0, 0.0};
        testSet.set(0);
        testSet.set(4);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((double[])array, (double)0.0));
        testSet.clear();
        testSet.set(1);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((double[])array, (double)1.0));
        testSet.clear();
        testSet.set(2);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((double[])array, (double)2.0));
        testSet.clear();
        testSet.set(3);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((double[])array, (double)3.0));
        Assertions.assertEquals((Object)emptySet, (Object)ArrayUtils.indexesOf((double[])array, (double)99.0));
    }

    @Test
    public void testIndexesOfDoubleTolerance() {
        double[] array = null;
        BitSet emptySet = new BitSet();
        BitSet testSet = new BitSet();
        Assertions.assertEquals((Object)emptySet, (Object)ArrayUtils.indexesOf(array, (double)0.0, (double)0.0));
        array = new double[]{};
        Assertions.assertEquals((Object)emptySet, (Object)ArrayUtils.indexesOf((double[])array, (double)0.0, (double)0.0));
        array = new double[]{0.0, 1.0, 2.0, 3.0, 0.0};
        testSet.set(0);
        testSet.set(4);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((double[])array, (double)0.0, (double)0.3));
        testSet.clear();
        testSet.set(3);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((double[])array, (double)4.15, (double)2.0));
        testSet.clear();
        testSet.set(1);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((double[])array, (double)1.00001324, (double)1.0E-4));
    }

    @Test
    public void testIndexesOfDoubleWithStartIndex() {
        double[] array = null;
        BitSet emptySet = new BitSet();
        BitSet testSet = new BitSet();
        Assertions.assertEquals((Object)emptySet, (Object)ArrayUtils.indexesOf(array, (double)0.0, (int)2));
        array = new double[]{0.0, 1.0, 2.0, 3.0, 0.0};
        testSet.set(4);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((double[])array, (double)0.0, (int)2));
        testSet.set(0);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((double[])array, (double)0.0, (int)0));
        testSet.clear();
        testSet.set(1);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((double[])array, (double)1.0, (int)1));
        testSet.clear();
        testSet.set(2);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((double[])array, (double)2.0, (int)0));
        testSet.clear();
        testSet.set(3);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((double[])array, (double)3.0, (int)0));
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((double[])array, (double)3.0, (int)-1));
        Assertions.assertEquals((Object)emptySet, (Object)ArrayUtils.indexesOf((double[])array, (double)99.0, (int)0));
    }

    @Test
    public void testIndexesOfDoubleWithStartIndexTolerance() {
        double[] array = null;
        BitSet emptySet = new BitSet();
        BitSet testSet = new BitSet();
        Assertions.assertEquals((Object)emptySet, (Object)ArrayUtils.indexesOf(array, (double)0.0, (int)0, (double)0.0));
        array = new double[]{};
        Assertions.assertEquals((Object)emptySet, (Object)ArrayUtils.indexesOf((double[])array, (double)0.0, (int)0, (double)0.0));
        array = new double[]{0.0, 1.0, 2.0, 3.0, 0.0};
        testSet.set(4);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((double[])array, (double)0.0, (int)1, (double)0.3));
        testSet.set(0);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((double[])array, (double)0.0, (int)0, (double)0.3));
        testSet.clear();
        testSet.set(2);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((double[])array, (double)2.0, (int)0, (double)0.35));
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((double[])array, (double)2.0, (int)2, (double)0.35));
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((double[])array, (double)2.0, (int)-1, (double)0.35));
        Assertions.assertEquals((Object)emptySet, (Object)ArrayUtils.indexesOf((double[])array, (double)2.0, (int)3, (double)0.35));
        testSet.clear();
        testSet.set(3);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((double[])array, (double)4.15, (int)0, (double)2.0));
        testSet.clear();
        testSet.set(1);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((double[])array, (double)1.00001324, (int)0, (double)1.0E-4));
    }

    @Test
    public void testIndexesOfFloat() {
        float[] array = null;
        BitSet emptySet = new BitSet();
        BitSet testSet = new BitSet();
        Assertions.assertEquals((Object)emptySet, (Object)ArrayUtils.indexesOf(array, (float)0.0f));
        array = new float[]{0.0f, 1.0f, 2.0f, 3.0f, 0.0f};
        testSet.set(0);
        testSet.set(4);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((float[])array, (float)0.0f));
        testSet.clear();
        testSet.set(1);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((float[])array, (float)1.0f));
        testSet.clear();
        testSet.set(2);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((float[])array, (float)2.0f));
        testSet.clear();
        testSet.set(3);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((float[])array, (float)3.0f));
        Assertions.assertEquals((Object)emptySet, (Object)ArrayUtils.indexesOf((float[])array, (float)99.0f));
    }

    @Test
    public void testIndexesOfFloatWithStartIndex() {
        float[] array = null;
        BitSet emptySet = new BitSet();
        BitSet testSet = new BitSet();
        Assertions.assertEquals((Object)emptySet, (Object)ArrayUtils.indexesOf(array, (float)0.0f, (int)2));
        array = new float[]{0.0f, 1.0f, 2.0f, 3.0f, 0.0f};
        testSet.set(4);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((float[])array, (float)0.0f, (int)2));
        testSet.set(0);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((float[])array, (float)0.0f, (int)0));
        testSet.clear();
        testSet.set(1);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((float[])array, (float)1.0f, (int)1));
        testSet.clear();
        testSet.set(2);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((float[])array, (float)2.0f, (int)0));
        testSet.clear();
        testSet.set(3);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((float[])array, (float)3.0f, (int)0));
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((float[])array, (float)3.0f, (int)-1));
        Assertions.assertEquals((Object)emptySet, (Object)ArrayUtils.indexesOf((float[])array, (float)99.0f, (int)0));
    }

    @Test
    public void testIndexesOfIntWithStartIndex() {
        int[] array = null;
        BitSet emptySet = new BitSet();
        BitSet testSet = new BitSet();
        Assertions.assertEquals((Object)emptySet, (Object)ArrayUtils.indexesOf(array, (int)0, (int)2));
        array = new int[]{0, 1, 2, 3, 0};
        testSet.set(4);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((int[])array, (int)0, (int)2));
        testSet.set(0);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((int[])array, (int)0, (int)0));
        testSet.clear();
        testSet.set(1);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((int[])array, (int)1, (int)1));
        testSet.clear();
        testSet.set(2);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((int[])array, (int)2, (int)0));
        testSet.clear();
        testSet.set(3);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((int[])array, (int)3, (int)0));
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((int[])array, (int)3, (int)-1));
        Assertions.assertEquals((Object)emptySet, (Object)ArrayUtils.indexesOf((int[])array, (int)99, (int)0));
    }

    @Test
    public void testIndexesOfLong() {
        long[] array = new long[]{0L, 1L, 2L, 3L};
        BitSet emptySet = new BitSet();
        BitSet testSet = new BitSet();
        Assertions.assertEquals((Object)emptySet, (Object)ArrayUtils.indexesOf((long[])null, (long)0L));
        Assertions.assertEquals((Object)emptySet, (Object)ArrayUtils.indexesOf((long[])array, (long)4L));
        testSet.set(0);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((long[])array, (long)0L));
        testSet.clear();
        testSet.set(1);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((long[])array, (long)1L));
        testSet.clear();
        testSet.set(2);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((long[])array, (long)2L));
        testSet.clear();
        testSet.set(3);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((long[])array, (long)3L));
    }

    @Test
    public void testIndexesOfLongWithStartIndex() {
        long[] array = new long[]{0L, 1L, 2L, 3L, 2L, 1L, 0L, 1L};
        BitSet emptySet = new BitSet();
        BitSet testSet = new BitSet();
        Assertions.assertEquals((Object)emptySet, (Object)ArrayUtils.indexesOf((long[])null, (long)0L, (int)0));
        Assertions.assertEquals((Object)emptySet, (Object)ArrayUtils.indexesOf((long[])array, (long)4L, (int)0));
        testSet.set(6);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((long[])array, (long)0L, (int)1));
        testSet.set(0);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((long[])array, (long)0L, (int)0));
        testSet.clear();
        testSet.set(1);
        testSet.set(5);
        testSet.set(7);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((long[])array, (long)1L, (int)0));
        testSet.clear();
        testSet.set(2);
        testSet.set(4);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((long[])array, (long)2L, (int)0));
        testSet.clear();
        testSet.set(3);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((long[])array, (long)3L, (int)0));
        Assertions.assertEquals((Object)emptySet, (Object)ArrayUtils.indexesOf((long[])array, (long)3L, (int)8));
    }

    @Test
    public void testIndexesOfShort() {
        short[] array = null;
        BitSet emptySet = new BitSet();
        BitSet testSet = new BitSet();
        Assertions.assertEquals((Object)emptySet, (Object)ArrayUtils.indexesOf(array, (short)0));
        array = new short[]{0, 1, 2, 3, 0};
        testSet.set(0);
        testSet.set(4);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((short[])array, (short)0));
        testSet.clear();
        testSet.set(1);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((short[])array, (short)1));
        testSet.clear();
        testSet.set(2);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((short[])array, (short)2));
        testSet.clear();
        testSet.set(3);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((short[])array, (short)3));
        Assertions.assertEquals((Object)emptySet, (Object)ArrayUtils.indexesOf((short[])array, (short)99));
    }

    @Test
    public void testIndexesOfShortWithStartIndex() {
        short[] array = null;
        BitSet emptySet = new BitSet();
        BitSet testSet = new BitSet();
        Assertions.assertEquals((Object)emptySet, (Object)ArrayUtils.indexesOf(array, (short)0, (int)2));
        array = new short[]{0, 1, 2, 3, 0};
        testSet.set(4);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((short[])array, (short)0, (int)2));
        testSet.set(0);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((short[])array, (short)0, (int)0));
        testSet.clear();
        testSet.set(1);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((short[])array, (short)1, (int)1));
        testSet.clear();
        testSet.set(2);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((short[])array, (short)2, (int)0));
        testSet.clear();
        testSet.set(3);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((short[])array, (short)3, (int)0));
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((short[])array, (short)3, (int)-1));
        Assertions.assertEquals((Object)emptySet, (Object)ArrayUtils.indexesOf((short[])array, (short)99, (int)0));
    }

    @Test
    public void testIndexesOfWithStartIndex() {
        Object[] array = new Object[]{"0", "1", "2", "3", "2", "3", "1", null, "0"};
        BitSet emptySet = new BitSet();
        BitSet testSet = new BitSet();
        Assertions.assertEquals((Object)emptySet, (Object)ArrayUtils.indexesOf(null, null, (int)2));
        Assertions.assertEquals((Object)emptySet, (Object)ArrayUtils.indexesOf((Object[])new Object[0], (Object)"0", (int)0));
        Assertions.assertEquals((Object)emptySet, (Object)ArrayUtils.indexesOf(null, (Object)"0", (int)2));
        testSet.set(8);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((Object[])array, (Object)"0", (int)8));
        testSet.set(0);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((Object[])array, (Object)"0", (int)0));
        testSet.clear();
        testSet.set(6);
        testSet.set(1);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((Object[])array, (Object)"1", (int)0));
        Assertions.assertEquals((Object)emptySet, (Object)ArrayUtils.indexesOf((Object[])array, (Object)"1", (int)9));
        testSet.clear();
        testSet.set(4);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((Object[])array, (Object)"2", (int)3));
        testSet.set(2);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((Object[])array, (Object)"2", (int)0));
        testSet.clear();
        testSet.set(3);
        testSet.set(5);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((Object[])array, (Object)"3", (int)0));
        testSet.clear();
        testSet.set(7);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((Object[])array, null, (int)0));
    }

    @Test
    public void testIndexOf() {
        Object[] array = new Object[]{"0", "1", "2", "3", null, "0"};
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf(null, null));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf(null, (Object)"0"));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf((Object[])new Object[0], (Object)"0"));
        Assertions.assertEquals((int)0, (int)ArrayUtils.indexOf((Object[])array, (Object)"0"));
        Assertions.assertEquals((int)1, (int)ArrayUtils.indexOf((Object[])array, (Object)"1"));
        Assertions.assertEquals((int)2, (int)ArrayUtils.indexOf((Object[])array, (Object)"2"));
        Assertions.assertEquals((int)3, (int)ArrayUtils.indexOf((Object[])array, (Object)"3"));
        Assertions.assertEquals((int)4, (int)ArrayUtils.indexOf((Object[])array, null));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf((Object[])array, (Object)"notInArray"));
    }

    @Test
    public void testIndexOfBoolean() {
        boolean[] array = null;
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf(array, (boolean)true));
        array = new boolean[]{};
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf((boolean[])array, (boolean)true));
        array = new boolean[]{true, false, true};
        Assertions.assertEquals((int)0, (int)ArrayUtils.indexOf((boolean[])array, (boolean)true));
        Assertions.assertEquals((int)1, (int)ArrayUtils.indexOf((boolean[])array, (boolean)false));
        array = new boolean[]{true, true};
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf((boolean[])array, (boolean)false));
    }

    @Test
    public void testIndexOfBooleanWithStartIndex() {
        boolean[] array = null;
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf(array, (boolean)true, (int)2));
        array = new boolean[]{};
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf((boolean[])array, (boolean)true, (int)2));
        array = new boolean[]{true, false, true};
        Assertions.assertEquals((int)2, (int)ArrayUtils.indexOf((boolean[])array, (boolean)true, (int)1));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf((boolean[])array, (boolean)false, (int)2));
        Assertions.assertEquals((int)1, (int)ArrayUtils.indexOf((boolean[])array, (boolean)false, (int)0));
        Assertions.assertEquals((int)1, (int)ArrayUtils.indexOf((boolean[])array, (boolean)false, (int)-1));
        array = new boolean[]{true, true};
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf((boolean[])array, (boolean)false, (int)0));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf((boolean[])array, (boolean)false, (int)-1));
    }

    @Test
    public void testIndexOfByte() {
        byte[] array = null;
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf(array, (byte)0));
        array = new byte[]{0, 1, 2, 3, 0};
        Assertions.assertEquals((int)0, (int)ArrayUtils.indexOf((byte[])array, (byte)0));
        Assertions.assertEquals((int)1, (int)ArrayUtils.indexOf((byte[])array, (byte)1));
        Assertions.assertEquals((int)2, (int)ArrayUtils.indexOf((byte[])array, (byte)2));
        Assertions.assertEquals((int)3, (int)ArrayUtils.indexOf((byte[])array, (byte)3));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf((byte[])array, (byte)99));
    }

    @Test
    public void testIndexOfByteWithStartIndex() {
        byte[] array = null;
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf(array, (byte)0, (int)2));
        array = new byte[]{0, 1, 2, 3, 0};
        Assertions.assertEquals((int)4, (int)ArrayUtils.indexOf((byte[])array, (byte)0, (int)2));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf((byte[])array, (byte)1, (int)2));
        Assertions.assertEquals((int)2, (int)ArrayUtils.indexOf((byte[])array, (byte)2, (int)2));
        Assertions.assertEquals((int)3, (int)ArrayUtils.indexOf((byte[])array, (byte)3, (int)2));
        Assertions.assertEquals((int)3, (int)ArrayUtils.indexOf((byte[])array, (byte)3, (int)-1));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf((byte[])array, (byte)99, (int)0));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf((byte[])array, (byte)0, (int)6));
    }

    @Test
    public void testIndexOfChar() {
        char[] array = null;
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf(array, (char)'a'));
        array = new char[]{'a', 'b', 'c', 'd', 'a'};
        Assertions.assertEquals((int)0, (int)ArrayUtils.indexOf((char[])array, (char)'a'));
        Assertions.assertEquals((int)1, (int)ArrayUtils.indexOf((char[])array, (char)'b'));
        Assertions.assertEquals((int)2, (int)ArrayUtils.indexOf((char[])array, (char)'c'));
        Assertions.assertEquals((int)3, (int)ArrayUtils.indexOf((char[])array, (char)'d'));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf((char[])array, (char)'e'));
    }

    @Test
    public void testIndexOfCharWithStartIndex() {
        char[] array = null;
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf(array, (char)'a', (int)2));
        array = new char[]{'a', 'b', 'c', 'd', 'a'};
        Assertions.assertEquals((int)4, (int)ArrayUtils.indexOf((char[])array, (char)'a', (int)2));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf((char[])array, (char)'b', (int)2));
        Assertions.assertEquals((int)2, (int)ArrayUtils.indexOf((char[])array, (char)'c', (int)2));
        Assertions.assertEquals((int)3, (int)ArrayUtils.indexOf((char[])array, (char)'d', (int)2));
        Assertions.assertEquals((int)3, (int)ArrayUtils.indexOf((char[])array, (char)'d', (int)-1));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf((char[])array, (char)'e', (int)0));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf((char[])array, (char)'a', (int)6));
    }

    @Test
    public void testIndexOfDouble() {
        double[] array = null;
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf(array, (double)0.0));
        array = new double[]{};
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf((double[])array, (double)0.0));
        array = new double[]{0.0, 1.0, 2.0, 3.0, 0.0};
        Assertions.assertEquals((int)0, (int)ArrayUtils.indexOf((double[])array, (double)0.0));
        Assertions.assertEquals((int)1, (int)ArrayUtils.indexOf((double[])array, (double)1.0));
        Assertions.assertEquals((int)2, (int)ArrayUtils.indexOf((double[])array, (double)2.0));
        Assertions.assertEquals((int)3, (int)ArrayUtils.indexOf((double[])array, (double)3.0));
        Assertions.assertEquals((int)3, (int)ArrayUtils.indexOf((double[])array, (double)3.0, (int)-1));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf((double[])array, (double)99.0));
    }

    @Test
    public void testIndexOfDoubleTolerance() {
        double[] array = null;
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf(array, (double)0.0, (double)0.0));
        array = new double[]{};
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf((double[])array, (double)0.0, (double)0.0));
        array = new double[]{0.0, 1.0, 2.0, 3.0, 0.0};
        Assertions.assertEquals((int)0, (int)ArrayUtils.indexOf((double[])array, (double)0.0, (double)0.3));
        Assertions.assertEquals((int)2, (int)ArrayUtils.indexOf((double[])array, (double)2.2, (double)0.35));
        Assertions.assertEquals((int)3, (int)ArrayUtils.indexOf((double[])array, (double)4.15, (double)2.0));
        Assertions.assertEquals((int)1, (int)ArrayUtils.indexOf((double[])array, (double)1.00001324, (double)1.0E-4));
    }

    @Test
    public void testIndexOfDoubleWithStartIndex() {
        double[] array = null;
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf(array, (double)0.0, (int)2));
        array = new double[]{};
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf((double[])array, (double)0.0, (int)2));
        array = new double[]{0.0, 1.0, 2.0, 3.0, 0.0};
        Assertions.assertEquals((int)4, (int)ArrayUtils.indexOf((double[])array, (double)0.0, (int)2));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf((double[])array, (double)1.0, (int)2));
        Assertions.assertEquals((int)2, (int)ArrayUtils.indexOf((double[])array, (double)2.0, (int)2));
        Assertions.assertEquals((int)3, (int)ArrayUtils.indexOf((double[])array, (double)3.0, (int)2));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf((double[])array, (double)99.0, (int)0));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf((double[])array, (double)0.0, (int)6));
    }

    @Test
    public void testIndexOfDoubleWithStartIndexTolerance() {
        double[] array = null;
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf(array, (double)0.0, (int)2, (double)0.0));
        array = new double[]{};
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf((double[])array, (double)0.0, (int)2, (double)0.0));
        array = new double[]{0.0, 1.0, 2.0, 3.0, 0.0};
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf((double[])array, (double)0.0, (int)99, (double)0.3));
        Assertions.assertEquals((int)0, (int)ArrayUtils.indexOf((double[])array, (double)0.0, (int)0, (double)0.3));
        Assertions.assertEquals((int)4, (int)ArrayUtils.indexOf((double[])array, (double)0.0, (int)3, (double)0.3));
        Assertions.assertEquals((int)2, (int)ArrayUtils.indexOf((double[])array, (double)2.2, (int)0, (double)0.35));
        Assertions.assertEquals((int)3, (int)ArrayUtils.indexOf((double[])array, (double)4.15, (int)0, (double)2.0));
        Assertions.assertEquals((int)1, (int)ArrayUtils.indexOf((double[])array, (double)1.00001324, (int)0, (double)1.0E-4));
        Assertions.assertEquals((int)3, (int)ArrayUtils.indexOf((double[])array, (double)4.15, (int)-1, (double)2.0));
        Assertions.assertEquals((int)1, (int)ArrayUtils.indexOf((double[])array, (double)1.00001324, (int)-300, (double)1.0E-4));
    }

    @Test
    public void testIndexOfFloat() {
        float[] array = null;
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf(array, (float)0.0f));
        array = new float[]{};
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf((float[])array, (float)0.0f));
        array = new float[]{0.0f, 1.0f, 2.0f, 3.0f, 0.0f};
        Assertions.assertEquals((int)0, (int)ArrayUtils.indexOf((float[])array, (float)0.0f));
        Assertions.assertEquals((int)1, (int)ArrayUtils.indexOf((float[])array, (float)1.0f));
        Assertions.assertEquals((int)2, (int)ArrayUtils.indexOf((float[])array, (float)2.0f));
        Assertions.assertEquals((int)3, (int)ArrayUtils.indexOf((float[])array, (float)3.0f));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf((float[])array, (float)99.0f));
    }

    @Test
    public void testIndexOfFloatWithStartIndex() {
        float[] array = null;
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf(array, (float)0.0f, (int)2));
        array = new float[]{};
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf((float[])array, (float)0.0f, (int)2));
        array = new float[]{0.0f, 1.0f, 2.0f, 3.0f, 0.0f};
        Assertions.assertEquals((int)4, (int)ArrayUtils.indexOf((float[])array, (float)0.0f, (int)2));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf((float[])array, (float)1.0f, (int)2));
        Assertions.assertEquals((int)2, (int)ArrayUtils.indexOf((float[])array, (float)2.0f, (int)2));
        Assertions.assertEquals((int)3, (int)ArrayUtils.indexOf((float[])array, (float)3.0f, (int)2));
        Assertions.assertEquals((int)3, (int)ArrayUtils.indexOf((float[])array, (float)3.0f, (int)-1));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf((float[])array, (float)99.0f, (int)0));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf((float[])array, (float)0.0f, (int)6));
    }

    @Test
    public void testIndexOfInt() {
        int[] array = null;
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf(array, (int)0));
        array = new int[]{0, 1, 2, 3, 0};
        Assertions.assertEquals((int)0, (int)ArrayUtils.indexOf((int[])array, (int)0));
        Assertions.assertEquals((int)1, (int)ArrayUtils.indexOf((int[])array, (int)1));
        Assertions.assertEquals((int)2, (int)ArrayUtils.indexOf((int[])array, (int)2));
        Assertions.assertEquals((int)3, (int)ArrayUtils.indexOf((int[])array, (int)3));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf((int[])array, (int)99));
    }

    @Test
    public void testIndexOfIntWithStartIndex() {
        int[] array = null;
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf(array, (int)0, (int)2));
        array = new int[]{0, 1, 2, 3, 0};
        Assertions.assertEquals((int)4, (int)ArrayUtils.indexOf((int[])array, (int)0, (int)2));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf((int[])array, (int)1, (int)2));
        Assertions.assertEquals((int)2, (int)ArrayUtils.indexOf((int[])array, (int)2, (int)2));
        Assertions.assertEquals((int)3, (int)ArrayUtils.indexOf((int[])array, (int)3, (int)2));
        Assertions.assertEquals((int)3, (int)ArrayUtils.indexOf((int[])array, (int)3, (int)-1));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf((int[])array, (int)99, (int)0));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf((int[])array, (int)0, (int)6));
    }

    @Test
    public void testIndexOfLong() {
        long[] array = null;
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf(array, (long)0L));
        array = new long[]{0L, 1L, 2L, 3L, 0L};
        Assertions.assertEquals((int)0, (int)ArrayUtils.indexOf((long[])array, (long)0L));
        Assertions.assertEquals((int)1, (int)ArrayUtils.indexOf((long[])array, (long)1L));
        Assertions.assertEquals((int)2, (int)ArrayUtils.indexOf((long[])array, (long)2L));
        Assertions.assertEquals((int)3, (int)ArrayUtils.indexOf((long[])array, (long)3L));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf((long[])array, (long)99L));
    }

    @Test
    public void testIndexOfLongWithStartIndex() {
        long[] array = null;
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf(array, (long)0L, (int)2));
        array = new long[]{0L, 1L, 2L, 3L, 0L};
        Assertions.assertEquals((int)4, (int)ArrayUtils.indexOf((long[])array, (long)0L, (int)2));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf((long[])array, (long)1L, (int)2));
        Assertions.assertEquals((int)2, (int)ArrayUtils.indexOf((long[])array, (long)2L, (int)2));
        Assertions.assertEquals((int)3, (int)ArrayUtils.indexOf((long[])array, (long)3L, (int)2));
        Assertions.assertEquals((int)3, (int)ArrayUtils.indexOf((long[])array, (long)3L, (int)-1));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf((long[])array, (long)99L, (int)0));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf((long[])array, (long)0L, (int)6));
    }

    @Test
    public void testIndexOfShort() {
        short[] array = null;
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf(array, (short)0));
        array = new short[]{0, 1, 2, 3, 0};
        Assertions.assertEquals((int)0, (int)ArrayUtils.indexOf((short[])array, (short)0));
        Assertions.assertEquals((int)1, (int)ArrayUtils.indexOf((short[])array, (short)1));
        Assertions.assertEquals((int)2, (int)ArrayUtils.indexOf((short[])array, (short)2));
        Assertions.assertEquals((int)3, (int)ArrayUtils.indexOf((short[])array, (short)3));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf((short[])array, (short)99));
    }

    @Test
    public void testIndexOfShortWithStartIndex() {
        short[] array = null;
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf(array, (short)0, (int)2));
        array = new short[]{0, 1, 2, 3, 0};
        Assertions.assertEquals((int)4, (int)ArrayUtils.indexOf((short[])array, (short)0, (int)2));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf((short[])array, (short)1, (int)2));
        Assertions.assertEquals((int)2, (int)ArrayUtils.indexOf((short[])array, (short)2, (int)2));
        Assertions.assertEquals((int)3, (int)ArrayUtils.indexOf((short[])array, (short)3, (int)2));
        Assertions.assertEquals((int)3, (int)ArrayUtils.indexOf((short[])array, (short)3, (int)-1));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf((short[])array, (short)99, (int)0));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf((short[])array, (short)0, (int)6));
    }

    @Test
    public void testIndexOfWithStartIndex() {
        Object[] array = new Object[]{"0", "1", "2", "3", null, "0"};
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf(null, null, (int)2));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf((Object[])new Object[0], (Object)"0", (int)0));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf(null, (Object)"0", (int)2));
        Assertions.assertEquals((int)5, (int)ArrayUtils.indexOf((Object[])array, (Object)"0", (int)2));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf((Object[])array, (Object)"1", (int)2));
        Assertions.assertEquals((int)2, (int)ArrayUtils.indexOf((Object[])array, (Object)"2", (int)2));
        Assertions.assertEquals((int)3, (int)ArrayUtils.indexOf((Object[])array, (Object)"3", (int)2));
        Assertions.assertEquals((int)4, (int)ArrayUtils.indexOf((Object[])array, null, (int)2));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf((Object[])array, (Object)"notInArray", (int)2));
        Assertions.assertEquals((int)4, (int)ArrayUtils.indexOf((Object[])array, null, (int)-1));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf((Object[])array, null, (int)8));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf((Object[])array, (Object)"0", (int)8));
    }

    @Test
    public void testIndirectArrayCreation() {
        String[] array = ArrayUtilsTest.toArrayPropagatingType("foo", "bar");
        Assertions.assertEquals((int)2, (int)array.length);
        Assertions.assertEquals((Object)"foo", (Object)array[0]);
        Assertions.assertEquals((Object)"bar", (Object)array[1]);
    }

    @Test
    public void testIndirectEmptyArrayCreation() {
        String[] array = ArrayUtilsTest.toArrayPropagatingType(new String[0]);
        Assertions.assertEquals((int)0, (int)array.length);
    }

    @Test
    public void testIsArrayIndexValid() {
        Assertions.assertFalse((boolean)ArrayUtils.isArrayIndexValid(null, (int)0));
        Object[] array = new String[1];
        Assertions.assertFalse((boolean)ArrayUtils.isArrayIndexValid((Object[])array, (int)1));
        Assertions.assertFalse((boolean)ArrayUtils.isArrayIndexValid((Object[])array, (int)-1));
        Assertions.assertTrue((boolean)ArrayUtils.isArrayIndexValid((Object[])array, (int)0));
    }

    @Test
    public void testIsEmptyObject() {
        Object[] emptyArray = new Object[]{};
        Object[] notEmptyArray = new Object[]{new String("Value")};
        Assertions.assertTrue((boolean)ArrayUtils.isEmpty((Object[])null));
        Assertions.assertTrue((boolean)ArrayUtils.isEmpty((Object[])emptyArray));
        Assertions.assertFalse((boolean)ArrayUtils.isEmpty((Object[])notEmptyArray));
    }

    @Test
    public void testIsEmptyPrimitives() {
        long[] emptyLongArray = new long[]{};
        long[] notEmptyLongArray = new long[]{1L};
        Assertions.assertTrue((boolean)ArrayUtils.isEmpty((long[])null));
        Assertions.assertTrue((boolean)ArrayUtils.isEmpty((long[])emptyLongArray));
        Assertions.assertFalse((boolean)ArrayUtils.isEmpty((long[])notEmptyLongArray));
        int[] emptyIntArray = new int[]{};
        int[] notEmptyIntArray = new int[]{1};
        Assertions.assertTrue((boolean)ArrayUtils.isEmpty((int[])null));
        Assertions.assertTrue((boolean)ArrayUtils.isEmpty((int[])emptyIntArray));
        Assertions.assertFalse((boolean)ArrayUtils.isEmpty((int[])notEmptyIntArray));
        short[] emptyShortArray = new short[]{};
        short[] notEmptyShortArray = new short[]{1};
        Assertions.assertTrue((boolean)ArrayUtils.isEmpty((short[])null));
        Assertions.assertTrue((boolean)ArrayUtils.isEmpty((short[])emptyShortArray));
        Assertions.assertFalse((boolean)ArrayUtils.isEmpty((short[])notEmptyShortArray));
        char[] emptyCharArray = new char[]{};
        char[] notEmptyCharArray = new char[]{'\u0001'};
        Assertions.assertTrue((boolean)ArrayUtils.isEmpty((char[])null));
        Assertions.assertTrue((boolean)ArrayUtils.isEmpty((char[])emptyCharArray));
        Assertions.assertFalse((boolean)ArrayUtils.isEmpty((char[])notEmptyCharArray));
        byte[] emptyByteArray = new byte[]{};
        byte[] notEmptyByteArray = new byte[]{1};
        Assertions.assertTrue((boolean)ArrayUtils.isEmpty((byte[])null));
        Assertions.assertTrue((boolean)ArrayUtils.isEmpty((byte[])emptyByteArray));
        Assertions.assertFalse((boolean)ArrayUtils.isEmpty((byte[])notEmptyByteArray));
        double[] emptyDoubleArray = new double[]{};
        double[] notEmptyDoubleArray = new double[]{1.0};
        Assertions.assertTrue((boolean)ArrayUtils.isEmpty((double[])null));
        Assertions.assertTrue((boolean)ArrayUtils.isEmpty((double[])emptyDoubleArray));
        Assertions.assertFalse((boolean)ArrayUtils.isEmpty((double[])notEmptyDoubleArray));
        float[] emptyFloatArray = new float[]{};
        float[] notEmptyFloatArray = new float[]{1.0f};
        Assertions.assertTrue((boolean)ArrayUtils.isEmpty((float[])null));
        Assertions.assertTrue((boolean)ArrayUtils.isEmpty((float[])emptyFloatArray));
        Assertions.assertFalse((boolean)ArrayUtils.isEmpty((float[])notEmptyFloatArray));
        boolean[] emptyBooleanArray = new boolean[]{};
        boolean[] notEmptyBooleanArray = new boolean[]{true};
        Assertions.assertTrue((boolean)ArrayUtils.isEmpty((boolean[])null));
        Assertions.assertTrue((boolean)ArrayUtils.isEmpty((boolean[])emptyBooleanArray));
        Assertions.assertFalse((boolean)ArrayUtils.isEmpty((boolean[])notEmptyBooleanArray));
    }

    @Test
    public void testIsEquals() {
        long[][] larray1 = new long[][]{{2L, 5L}, {4L, 5L}};
        long[][] larray2 = new long[][]{{2L, 5L}, {4L, 6L}};
        long[] larray3 = new long[]{2L, 5L};
        this.assertIsEquals(larray1, larray2, larray3);
        int[][] iarray1 = new int[][]{{2, 5}, {4, 5}};
        int[][] iarray2 = new int[][]{{2, 5}, {4, 6}};
        int[] iarray3 = new int[]{2, 5};
        this.assertIsEquals(iarray1, iarray2, iarray3);
        short[][] sarray1 = new short[][]{{2, 5}, {4, 5}};
        short[][] sarray2 = new short[][]{{2, 5}, {4, 6}};
        short[] sarray3 = new short[]{2, 5};
        this.assertIsEquals(sarray1, sarray2, sarray3);
        float[][] farray1 = new float[][]{{2.0f, 5.0f}, {4.0f, 5.0f}};
        float[][] farray2 = new float[][]{{2.0f, 5.0f}, {4.0f, 6.0f}};
        float[] farray3 = new float[]{2.0f, 5.0f};
        this.assertIsEquals(farray1, farray2, farray3);
        double[][] darray1 = new double[][]{{2.0, 5.0}, {4.0, 5.0}};
        double[][] darray2 = new double[][]{{2.0, 5.0}, {4.0, 6.0}};
        double[] darray3 = new double[]{2.0, 5.0};
        this.assertIsEquals(darray1, darray2, darray3);
        byte[][] byteArray1 = new byte[][]{{2, 5}, {4, 5}};
        byte[][] byteArray2 = new byte[][]{{2, 5}, {4, 6}};
        byte[] byteArray3 = new byte[]{2, 5};
        this.assertIsEquals(byteArray1, byteArray2, byteArray3);
        char[][] charArray1 = new char[][]{{'\u0002', '\u0005'}, {'\u0004', '\u0005'}};
        char[][] charArray2 = new char[][]{{'\u0002', '\u0005'}, {'\u0004', '\u0006'}};
        char[] charArray3 = new char[]{'\u0002', '\u0005'};
        this.assertIsEquals(charArray1, charArray2, charArray3);
        boolean[][] barray1 = new boolean[][]{{true, false}, {true, true}};
        boolean[][] barray2 = new boolean[][]{{true, false}, {true, false}};
        boolean[] barray3 = new boolean[]{false, true};
        this.assertIsEquals(barray1, barray2, barray3);
        Object[] array3 = new Object[]{new String(new char[]{'A', 'B'})};
        Object[] array4 = new Object[]{"AB"};
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)array3, (Object)array3));
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)array3, (Object)array4));
        Assertions.assertTrue((boolean)ArrayUtils.isEquals(null, null));
        Assertions.assertFalse((boolean)ArrayUtils.isEquals(null, (Object)array4));
    }

    @Test
    public void testIsNotEmptyObject() {
        Object[] emptyArray = new Object[]{};
        Object[] notEmptyArray = new Object[]{new String("Value")};
        Assertions.assertFalse((boolean)ArrayUtils.isNotEmpty((Object[])null));
        Assertions.assertFalse((boolean)ArrayUtils.isNotEmpty((Object[])emptyArray));
        Assertions.assertTrue((boolean)ArrayUtils.isNotEmpty((Object[])notEmptyArray));
    }

    @Test
    public void testIsNotEmptyPrimitives() {
        long[] emptyLongArray = new long[]{};
        long[] notEmptyLongArray = new long[]{1L};
        Assertions.assertFalse((boolean)ArrayUtils.isNotEmpty((long[])null));
        Assertions.assertFalse((boolean)ArrayUtils.isNotEmpty((long[])emptyLongArray));
        Assertions.assertTrue((boolean)ArrayUtils.isNotEmpty((long[])notEmptyLongArray));
        int[] emptyIntArray = new int[]{};
        int[] notEmptyIntArray = new int[]{1};
        Assertions.assertFalse((boolean)ArrayUtils.isNotEmpty((int[])null));
        Assertions.assertFalse((boolean)ArrayUtils.isNotEmpty((int[])emptyIntArray));
        Assertions.assertTrue((boolean)ArrayUtils.isNotEmpty((int[])notEmptyIntArray));
        short[] emptyShortArray = new short[]{};
        short[] notEmptyShortArray = new short[]{1};
        Assertions.assertFalse((boolean)ArrayUtils.isNotEmpty((short[])null));
        Assertions.assertFalse((boolean)ArrayUtils.isNotEmpty((short[])emptyShortArray));
        Assertions.assertTrue((boolean)ArrayUtils.isNotEmpty((short[])notEmptyShortArray));
        char[] emptyCharArray = new char[]{};
        char[] notEmptyCharArray = new char[]{'\u0001'};
        Assertions.assertFalse((boolean)ArrayUtils.isNotEmpty((char[])null));
        Assertions.assertFalse((boolean)ArrayUtils.isNotEmpty((char[])emptyCharArray));
        Assertions.assertTrue((boolean)ArrayUtils.isNotEmpty((char[])notEmptyCharArray));
        byte[] emptyByteArray = new byte[]{};
        byte[] notEmptyByteArray = new byte[]{1};
        Assertions.assertFalse((boolean)ArrayUtils.isNotEmpty((byte[])null));
        Assertions.assertFalse((boolean)ArrayUtils.isNotEmpty((byte[])emptyByteArray));
        Assertions.assertTrue((boolean)ArrayUtils.isNotEmpty((byte[])notEmptyByteArray));
        double[] emptyDoubleArray = new double[]{};
        double[] notEmptyDoubleArray = new double[]{1.0};
        Assertions.assertFalse((boolean)ArrayUtils.isNotEmpty((double[])null));
        Assertions.assertFalse((boolean)ArrayUtils.isNotEmpty((double[])emptyDoubleArray));
        Assertions.assertTrue((boolean)ArrayUtils.isNotEmpty((double[])notEmptyDoubleArray));
        float[] emptyFloatArray = new float[]{};
        float[] notEmptyFloatArray = new float[]{1.0f};
        Assertions.assertFalse((boolean)ArrayUtils.isNotEmpty((float[])null));
        Assertions.assertFalse((boolean)ArrayUtils.isNotEmpty((float[])emptyFloatArray));
        Assertions.assertTrue((boolean)ArrayUtils.isNotEmpty((float[])notEmptyFloatArray));
        boolean[] emptyBooleanArray = new boolean[]{};
        boolean[] notEmptyBooleanArray = new boolean[]{true};
        Assertions.assertFalse((boolean)ArrayUtils.isNotEmpty((boolean[])null));
        Assertions.assertFalse((boolean)ArrayUtils.isNotEmpty((boolean[])emptyBooleanArray));
        Assertions.assertTrue((boolean)ArrayUtils.isNotEmpty((boolean[])notEmptyBooleanArray));
    }

    @Test
    public void testIsSorted() {
        Comparable[] array = null;
        Assertions.assertTrue((boolean)ArrayUtils.isSorted(array));
        array = new Integer[]{1};
        Assertions.assertTrue((boolean)ArrayUtils.isSorted((Comparable[])array));
        array = new Integer[]{1, 2, 3};
        Assertions.assertTrue((boolean)ArrayUtils.isSorted((Comparable[])array));
        array = new Integer[]{1, 3, 2};
        Assertions.assertFalse((boolean)ArrayUtils.isSorted((Comparable[])array));
    }

    @Test
    public void testIsSortedBool() {
        boolean[] array = null;
        Assertions.assertTrue((boolean)ArrayUtils.isSorted(array));
        array = new boolean[]{true};
        Assertions.assertTrue((boolean)ArrayUtils.isSorted((boolean[])array));
        array = new boolean[]{false, true};
        Assertions.assertTrue((boolean)ArrayUtils.isSorted((boolean[])array));
        array = new boolean[]{true, false};
        Assertions.assertFalse((boolean)ArrayUtils.isSorted((boolean[])array));
    }

    @Test
    public void testIsSortedByte() {
        byte[] array = null;
        Assertions.assertTrue((boolean)ArrayUtils.isSorted(array));
        array = new byte[]{16};
        Assertions.assertTrue((boolean)ArrayUtils.isSorted((byte[])array));
        array = new byte[]{16, 32, 48};
        Assertions.assertTrue((boolean)ArrayUtils.isSorted((byte[])array));
        array = new byte[]{16, 48, 32};
        Assertions.assertFalse((boolean)ArrayUtils.isSorted((byte[])array));
    }

    @Test
    public void testIsSortedChar() {
        char[] array = null;
        Assertions.assertTrue((boolean)ArrayUtils.isSorted(array));
        array = new char[]{'a'};
        Assertions.assertTrue((boolean)ArrayUtils.isSorted((char[])array));
        array = new char[]{'a', 'b', 'c'};
        Assertions.assertTrue((boolean)ArrayUtils.isSorted((char[])array));
        array = new char[]{'a', 'c', 'b'};
        Assertions.assertFalse((boolean)ArrayUtils.isSorted((char[])array));
    }

    @Test
    public void testIsSortedComparator() {
        Comparator c = Comparator.reverseOrder();
        Object[] array = null;
        Assertions.assertTrue((boolean)ArrayUtils.isSorted(array, c));
        array = new Integer[]{1};
        Assertions.assertTrue((boolean)ArrayUtils.isSorted((Object[])array, c));
        array = new Integer[]{3, 2, 1};
        Assertions.assertTrue((boolean)ArrayUtils.isSorted((Object[])array, c));
        array = new Integer[]{1, 3, 2};
        Assertions.assertFalse((boolean)ArrayUtils.isSorted((Object[])array, c));
    }

    @Test
    public void testIsSortedDouble() {
        double[] array = null;
        Assertions.assertTrue((boolean)ArrayUtils.isSorted(array));
        array = new double[]{0.0};
        Assertions.assertTrue((boolean)ArrayUtils.isSorted((double[])array));
        array = new double[]{-1.0, 0.0, 0.1, 0.2};
        Assertions.assertTrue((boolean)ArrayUtils.isSorted((double[])array));
        array = new double[]{-1.0, 0.2, 0.1, 0.0};
        Assertions.assertFalse((boolean)ArrayUtils.isSorted((double[])array));
    }

    @Test
    public void testIsSortedFloat() {
        float[] array = null;
        Assertions.assertTrue((boolean)ArrayUtils.isSorted(array));
        array = new float[]{0.0f};
        Assertions.assertTrue((boolean)ArrayUtils.isSorted((float[])array));
        array = new float[]{-1.0f, 0.0f, 0.1f, 0.2f};
        Assertions.assertTrue((boolean)ArrayUtils.isSorted((float[])array));
        array = new float[]{-1.0f, 0.2f, 0.1f, 0.0f};
        Assertions.assertFalse((boolean)ArrayUtils.isSorted((float[])array));
    }

    @Test
    public void testIsSortedInt() {
        int[] array = null;
        Assertions.assertTrue((boolean)ArrayUtils.isSorted(array));
        array = new int[]{1};
        Assertions.assertTrue((boolean)ArrayUtils.isSorted((int[])array));
        array = new int[]{1, 2, 3};
        Assertions.assertTrue((boolean)ArrayUtils.isSorted((int[])array));
        array = new int[]{1, 3, 2};
        Assertions.assertFalse((boolean)ArrayUtils.isSorted((int[])array));
    }

    @Test
    public void testIsSortedLong() {
        long[] array = null;
        Assertions.assertTrue((boolean)ArrayUtils.isSorted(array));
        array = new long[]{0L};
        Assertions.assertTrue((boolean)ArrayUtils.isSorted((long[])array));
        array = new long[]{-1L, 0L, 1L};
        Assertions.assertTrue((boolean)ArrayUtils.isSorted((long[])array));
        array = new long[]{-1L, 1L, 0L};
        Assertions.assertFalse((boolean)ArrayUtils.isSorted((long[])array));
    }

    @Test
    public void testIsSortedNullComparator() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> ArrayUtils.isSorted(null, null));
    }

    @Test
    public void testIsSortedShort() {
        short[] array = null;
        Assertions.assertTrue((boolean)ArrayUtils.isSorted(array));
        array = new short[]{0};
        Assertions.assertTrue((boolean)ArrayUtils.isSorted((short[])array));
        array = new short[]{-1, 0, 1};
        Assertions.assertTrue((boolean)ArrayUtils.isSorted((short[])array));
        array = new short[]{-1, 1, 0};
        Assertions.assertFalse((boolean)ArrayUtils.isSorted((short[])array));
    }

    @Test
    public void testLastIndexOf() {
        Object[] array = new Object[]{"0", "1", "2", "3", null, "0"};
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf(null, null));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf(null, (Object)"0"));
        Assertions.assertEquals((int)5, (int)ArrayUtils.lastIndexOf((Object[])array, (Object)"0"));
        Assertions.assertEquals((int)1, (int)ArrayUtils.lastIndexOf((Object[])array, (Object)"1"));
        Assertions.assertEquals((int)2, (int)ArrayUtils.lastIndexOf((Object[])array, (Object)"2"));
        Assertions.assertEquals((int)3, (int)ArrayUtils.lastIndexOf((Object[])array, (Object)"3"));
        Assertions.assertEquals((int)4, (int)ArrayUtils.lastIndexOf((Object[])array, null));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((Object[])array, (Object)"notInArray"));
    }

    @Test
    public void testLastIndexOfBoolean() {
        boolean[] array = null;
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf(array, (boolean)true));
        array = new boolean[]{};
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((boolean[])array, (boolean)true));
        array = new boolean[]{true, false, true};
        Assertions.assertEquals((int)2, (int)ArrayUtils.lastIndexOf((boolean[])array, (boolean)true));
        Assertions.assertEquals((int)1, (int)ArrayUtils.lastIndexOf((boolean[])array, (boolean)false));
        array = new boolean[]{true, true};
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((boolean[])array, (boolean)false));
    }

    @Test
    public void testLastIndexOfBooleanWithStartIndex() {
        boolean[] array = null;
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf(array, (boolean)true, (int)2));
        array = new boolean[]{};
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((boolean[])array, (boolean)true, (int)2));
        array = new boolean[]{true, false, true};
        Assertions.assertEquals((int)2, (int)ArrayUtils.lastIndexOf((boolean[])array, (boolean)true, (int)2));
        Assertions.assertEquals((int)0, (int)ArrayUtils.lastIndexOf((boolean[])array, (boolean)true, (int)1));
        Assertions.assertEquals((int)1, (int)ArrayUtils.lastIndexOf((boolean[])array, (boolean)false, (int)2));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((boolean[])array, (boolean)true, (int)-1));
        array = new boolean[]{true, true};
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((boolean[])array, (boolean)false, (int)2));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((boolean[])array, (boolean)true, (int)-1));
    }

    @Test
    public void testLastIndexOfByte() {
        byte[] array = null;
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf(array, (byte)0));
        array = new byte[]{0, 1, 2, 3, 0};
        Assertions.assertEquals((int)4, (int)ArrayUtils.lastIndexOf((byte[])array, (byte)0));
        Assertions.assertEquals((int)1, (int)ArrayUtils.lastIndexOf((byte[])array, (byte)1));
        Assertions.assertEquals((int)2, (int)ArrayUtils.lastIndexOf((byte[])array, (byte)2));
        Assertions.assertEquals((int)3, (int)ArrayUtils.lastIndexOf((byte[])array, (byte)3));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((byte[])array, (byte)99));
    }

    @Test
    public void testLastIndexOfByteWithStartIndex() {
        byte[] array = null;
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf(array, (byte)0, (int)2));
        array = new byte[]{0, 1, 2, 3, 0};
        Assertions.assertEquals((int)0, (int)ArrayUtils.lastIndexOf((byte[])array, (byte)0, (int)2));
        Assertions.assertEquals((int)1, (int)ArrayUtils.lastIndexOf((byte[])array, (byte)1, (int)2));
        Assertions.assertEquals((int)2, (int)ArrayUtils.lastIndexOf((byte[])array, (byte)2, (int)2));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((byte[])array, (byte)3, (int)2));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((byte[])array, (byte)3, (int)-1));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((byte[])array, (byte)99));
        Assertions.assertEquals((int)4, (int)ArrayUtils.lastIndexOf((byte[])array, (byte)0, (int)88));
    }

    @Test
    public void testLastIndexOfChar() {
        char[] array = null;
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf(array, (char)'a'));
        array = new char[]{'a', 'b', 'c', 'd', 'a'};
        Assertions.assertEquals((int)4, (int)ArrayUtils.lastIndexOf((char[])array, (char)'a'));
        Assertions.assertEquals((int)1, (int)ArrayUtils.lastIndexOf((char[])array, (char)'b'));
        Assertions.assertEquals((int)2, (int)ArrayUtils.lastIndexOf((char[])array, (char)'c'));
        Assertions.assertEquals((int)3, (int)ArrayUtils.lastIndexOf((char[])array, (char)'d'));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((char[])array, (char)'e'));
    }

    @Test
    public void testLastIndexOfCharWithStartIndex() {
        char[] array = null;
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf(array, (char)'a', (int)2));
        array = new char[]{'a', 'b', 'c', 'd', 'a'};
        Assertions.assertEquals((int)0, (int)ArrayUtils.lastIndexOf((char[])array, (char)'a', (int)2));
        Assertions.assertEquals((int)1, (int)ArrayUtils.lastIndexOf((char[])array, (char)'b', (int)2));
        Assertions.assertEquals((int)2, (int)ArrayUtils.lastIndexOf((char[])array, (char)'c', (int)2));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((char[])array, (char)'d', (int)2));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((char[])array, (char)'d', (int)-1));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((char[])array, (char)'e'));
        Assertions.assertEquals((int)4, (int)ArrayUtils.lastIndexOf((char[])array, (char)'a', (int)88));
    }

    @Test
    public void testLastIndexOfDouble() {
        double[] array = null;
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf(array, (double)0.0));
        array = new double[]{};
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((double[])array, (double)0.0));
        array = new double[]{0.0, 1.0, 2.0, 3.0, 0.0};
        Assertions.assertEquals((int)4, (int)ArrayUtils.lastIndexOf((double[])array, (double)0.0));
        Assertions.assertEquals((int)1, (int)ArrayUtils.lastIndexOf((double[])array, (double)1.0));
        Assertions.assertEquals((int)2, (int)ArrayUtils.lastIndexOf((double[])array, (double)2.0));
        Assertions.assertEquals((int)3, (int)ArrayUtils.lastIndexOf((double[])array, (double)3.0));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((double[])array, (double)99.0));
    }

    @Test
    public void testLastIndexOfDoubleTolerance() {
        double[] array = null;
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf(array, (double)0.0, (double)0.0));
        array = new double[]{};
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((double[])array, (double)0.0, (double)0.0));
        array = new double[]{0.0, 1.0, 2.0, 3.0, 0.0};
        Assertions.assertEquals((int)4, (int)ArrayUtils.lastIndexOf((double[])array, (double)0.0, (double)0.3));
        Assertions.assertEquals((int)2, (int)ArrayUtils.lastIndexOf((double[])array, (double)2.2, (double)0.35));
        Assertions.assertEquals((int)3, (int)ArrayUtils.lastIndexOf((double[])array, (double)4.15, (double)2.0));
        Assertions.assertEquals((int)1, (int)ArrayUtils.lastIndexOf((double[])array, (double)1.00001324, (double)1.0E-4));
    }

    @Test
    public void testLastIndexOfDoubleWithStartIndex() {
        double[] array = null;
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf(array, (double)0.0, (int)2));
        array = new double[]{};
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((double[])array, (double)0.0, (int)2));
        array = new double[]{0.0, 1.0, 2.0, 3.0, 0.0};
        Assertions.assertEquals((int)0, (int)ArrayUtils.lastIndexOf((double[])array, (double)0.0, (int)2));
        Assertions.assertEquals((int)1, (int)ArrayUtils.lastIndexOf((double[])array, (double)1.0, (int)2));
        Assertions.assertEquals((int)2, (int)ArrayUtils.lastIndexOf((double[])array, (double)2.0, (int)2));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((double[])array, (double)3.0, (int)2));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((double[])array, (double)3.0, (int)-1));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((double[])array, (double)99.0));
        Assertions.assertEquals((int)4, (int)ArrayUtils.lastIndexOf((double[])array, (double)0.0, (int)88));
    }

    @Test
    public void testLastIndexOfDoubleWithStartIndexTolerance() {
        double[] array = null;
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf(array, (double)0.0, (int)2, (double)0.0));
        array = new double[]{};
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((double[])array, (double)0.0, (int)2, (double)0.0));
        array = new double[]{3.0};
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((double[])array, (double)1.0, (int)0, (double)0.0));
        array = new double[]{0.0, 1.0, 2.0, 3.0, 0.0};
        Assertions.assertEquals((int)4, (int)ArrayUtils.lastIndexOf((double[])array, (double)0.0, (int)99, (double)0.3));
        Assertions.assertEquals((int)0, (int)ArrayUtils.lastIndexOf((double[])array, (double)0.0, (int)3, (double)0.3));
        Assertions.assertEquals((int)2, (int)ArrayUtils.lastIndexOf((double[])array, (double)2.2, (int)3, (double)0.35));
        Assertions.assertEquals((int)3, (int)ArrayUtils.lastIndexOf((double[])array, (double)4.15, (int)array.length, (double)2.0));
        Assertions.assertEquals((int)1, (int)ArrayUtils.lastIndexOf((double[])array, (double)1.00001324, (int)array.length, (double)1.0E-4));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((double[])array, (double)4.15, (int)-200, (double)2.0));
    }

    @Test
    public void testLastIndexOfFloat() {
        float[] array = null;
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf(array, (float)0.0f));
        array = new float[]{};
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((float[])array, (float)0.0f));
        array = new float[]{0.0f, 1.0f, 2.0f, 3.0f, 0.0f};
        Assertions.assertEquals((int)4, (int)ArrayUtils.lastIndexOf((float[])array, (float)0.0f));
        Assertions.assertEquals((int)1, (int)ArrayUtils.lastIndexOf((float[])array, (float)1.0f));
        Assertions.assertEquals((int)2, (int)ArrayUtils.lastIndexOf((float[])array, (float)2.0f));
        Assertions.assertEquals((int)3, (int)ArrayUtils.lastIndexOf((float[])array, (float)3.0f));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((float[])array, (float)99.0f));
    }

    @Test
    public void testLastIndexOfFloatWithStartIndex() {
        float[] array = null;
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf(array, (float)0.0f, (int)2));
        array = new float[]{};
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((float[])array, (float)0.0f, (int)2));
        array = new float[]{0.0f, 1.0f, 2.0f, 3.0f, 0.0f};
        Assertions.assertEquals((int)0, (int)ArrayUtils.lastIndexOf((float[])array, (float)0.0f, (int)2));
        Assertions.assertEquals((int)1, (int)ArrayUtils.lastIndexOf((float[])array, (float)1.0f, (int)2));
        Assertions.assertEquals((int)2, (int)ArrayUtils.lastIndexOf((float[])array, (float)2.0f, (int)2));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((float[])array, (float)3.0f, (int)2));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((float[])array, (float)3.0f, (int)-1));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((float[])array, (float)99.0f));
        Assertions.assertEquals((int)4, (int)ArrayUtils.lastIndexOf((float[])array, (float)0.0f, (int)88));
    }

    @Test
    public void testLastIndexOfInt() {
        int[] array = null;
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf(array, (int)0));
        array = new int[]{0, 1, 2, 3, 0};
        Assertions.assertEquals((int)4, (int)ArrayUtils.lastIndexOf((int[])array, (int)0));
        Assertions.assertEquals((int)1, (int)ArrayUtils.lastIndexOf((int[])array, (int)1));
        Assertions.assertEquals((int)2, (int)ArrayUtils.lastIndexOf((int[])array, (int)2));
        Assertions.assertEquals((int)3, (int)ArrayUtils.lastIndexOf((int[])array, (int)3));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((int[])array, (int)99));
    }

    @Test
    public void testLastIndexOfIntWithStartIndex() {
        int[] array = null;
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf(array, (int)0, (int)2));
        array = new int[]{0, 1, 2, 3, 0};
        Assertions.assertEquals((int)0, (int)ArrayUtils.lastIndexOf((int[])array, (int)0, (int)2));
        Assertions.assertEquals((int)1, (int)ArrayUtils.lastIndexOf((int[])array, (int)1, (int)2));
        Assertions.assertEquals((int)2, (int)ArrayUtils.lastIndexOf((int[])array, (int)2, (int)2));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((int[])array, (int)3, (int)2));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((int[])array, (int)3, (int)-1));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((int[])array, (int)99));
        Assertions.assertEquals((int)4, (int)ArrayUtils.lastIndexOf((int[])array, (int)0, (int)88));
    }

    @Test
    public void testLastIndexOfLong() {
        long[] array = null;
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf(array, (long)0L));
        array = new long[]{0L, 1L, 2L, 3L, 0L};
        Assertions.assertEquals((int)4, (int)ArrayUtils.lastIndexOf((long[])array, (long)0L));
        Assertions.assertEquals((int)1, (int)ArrayUtils.lastIndexOf((long[])array, (long)1L));
        Assertions.assertEquals((int)2, (int)ArrayUtils.lastIndexOf((long[])array, (long)2L));
        Assertions.assertEquals((int)3, (int)ArrayUtils.lastIndexOf((long[])array, (long)3L));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((long[])array, (long)99L));
    }

    @Test
    public void testLastIndexOfLongWithStartIndex() {
        long[] array = null;
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf(array, (long)0L, (int)2));
        array = new long[]{0L, 1L, 2L, 3L, 0L};
        Assertions.assertEquals((int)0, (int)ArrayUtils.lastIndexOf((long[])array, (long)0L, (int)2));
        Assertions.assertEquals((int)1, (int)ArrayUtils.lastIndexOf((long[])array, (long)1L, (int)2));
        Assertions.assertEquals((int)2, (int)ArrayUtils.lastIndexOf((long[])array, (long)2L, (int)2));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((long[])array, (long)3L, (int)2));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((long[])array, (long)3L, (int)-1));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((long[])array, (long)99L, (int)4));
        Assertions.assertEquals((int)4, (int)ArrayUtils.lastIndexOf((long[])array, (long)0L, (int)88));
    }

    @Test
    public void testLastIndexOfShort() {
        short[] array = null;
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf(array, (short)0));
        array = new short[]{0, 1, 2, 3, 0};
        Assertions.assertEquals((int)4, (int)ArrayUtils.lastIndexOf((short[])array, (short)0));
        Assertions.assertEquals((int)1, (int)ArrayUtils.lastIndexOf((short[])array, (short)1));
        Assertions.assertEquals((int)2, (int)ArrayUtils.lastIndexOf((short[])array, (short)2));
        Assertions.assertEquals((int)3, (int)ArrayUtils.lastIndexOf((short[])array, (short)3));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((short[])array, (short)99));
    }

    @Test
    public void testLastIndexOfShortWithStartIndex() {
        short[] array = null;
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf(array, (short)0, (int)2));
        array = new short[]{0, 1, 2, 3, 0};
        Assertions.assertEquals((int)0, (int)ArrayUtils.lastIndexOf((short[])array, (short)0, (int)2));
        Assertions.assertEquals((int)1, (int)ArrayUtils.lastIndexOf((short[])array, (short)1, (int)2));
        Assertions.assertEquals((int)2, (int)ArrayUtils.lastIndexOf((short[])array, (short)2, (int)2));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((short[])array, (short)3, (int)2));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((short[])array, (short)3, (int)-1));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((short[])array, (short)99));
        Assertions.assertEquals((int)4, (int)ArrayUtils.lastIndexOf((short[])array, (short)0, (int)88));
    }

    @Test
    public void testLastIndexOfWithStartIndex() {
        Object[] array = new Object[]{"0", "1", "2", "3", null, "0"};
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf(null, null, (int)2));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf(null, (Object)"0", (int)2));
        Assertions.assertEquals((int)0, (int)ArrayUtils.lastIndexOf((Object[])array, (Object)"0", (int)2));
        Assertions.assertEquals((int)1, (int)ArrayUtils.lastIndexOf((Object[])array, (Object)"1", (int)2));
        Assertions.assertEquals((int)2, (int)ArrayUtils.lastIndexOf((Object[])array, (Object)"2", (int)2));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((Object[])array, (Object)"3", (int)2));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((Object[])array, (Object)"3", (int)-1));
        Assertions.assertEquals((int)4, (int)ArrayUtils.lastIndexOf((Object[])array, null, (int)5));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((Object[])array, null, (int)2));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((Object[])array, (Object)"notInArray", (int)5));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.lastIndexOf((Object[])array, null, (int)-1));
        Assertions.assertEquals((int)5, (int)ArrayUtils.lastIndexOf((Object[])array, (Object)"0", (int)88));
    }

    @Test
    public void testNullToEmptyBoolean() {
        boolean[] original = new boolean[]{true, false};
        Assertions.assertEquals((Object)original, (Object)ArrayUtils.nullToEmpty((boolean[])original));
    }

    @Test
    public void testNullToEmptyBooleanEmptyArray() {
        boolean[] empty = new boolean[]{};
        boolean[] result = ArrayUtils.nullToEmpty((boolean[])empty);
        Assertions.assertEquals((Object)ArrayUtils.EMPTY_BOOLEAN_ARRAY, (Object)result);
        Assertions.assertNotSame((Object)empty, (Object)result);
    }

    @Test
    public void testNullToEmptyBooleanNull() {
        Assertions.assertEquals((Object)ArrayUtils.EMPTY_BOOLEAN_ARRAY, (Object)ArrayUtils.nullToEmpty((boolean[])null));
    }

    @Test
    public void testNullToEmptyBooleanObject() {
        Object[] original = new Boolean[]{Boolean.TRUE, Boolean.FALSE};
        Assertions.assertArrayEquals((Object[])original, (Object[])ArrayUtils.nullToEmpty((Boolean[])original));
    }

    @Test
    public void testNullToEmptyBooleanObjectEmptyArray() {
        Boolean[] empty = new Boolean[]{};
        Object[] result = ArrayUtils.nullToEmpty((Boolean[])empty);
        Assertions.assertArrayEquals((Object[])ArrayUtils.EMPTY_BOOLEAN_OBJECT_ARRAY, (Object[])result);
        Assertions.assertNotSame((Object)empty, (Object)result);
    }

    @Test
    public void testNullToEmptyBooleanObjectNull() {
        Assertions.assertArrayEquals((Object[])ArrayUtils.EMPTY_BOOLEAN_OBJECT_ARRAY, (Object[])ArrayUtils.nullToEmpty((Boolean[])null));
    }

    @Test
    public void testNullToEmptyByte() {
        byte[] original = new byte[]{15, 14};
        Assertions.assertEquals((Object)original, (Object)ArrayUtils.nullToEmpty((byte[])original));
    }

    @Test
    public void testNullToEmptyByteEmptyArray() {
        byte[] empty = new byte[]{};
        byte[] result = ArrayUtils.nullToEmpty((byte[])empty);
        Assertions.assertEquals((Object)ArrayUtils.EMPTY_BYTE_ARRAY, (Object)result);
        Assertions.assertNotSame((Object)empty, (Object)result);
    }

    @Test
    public void testNullToEmptyByteNull() {
        Assertions.assertEquals((Object)ArrayUtils.EMPTY_BYTE_ARRAY, (Object)ArrayUtils.nullToEmpty((byte[])null));
    }

    @Test
    public void testNullToEmptyByteObject() {
        Object[] original = new Byte[]{(byte)15, (byte)14};
        Assertions.assertArrayEquals((Object[])original, (Object[])ArrayUtils.nullToEmpty((Byte[])original));
    }

    @Test
    public void testNullToEmptyByteObjectEmptyArray() {
        Byte[] empty = new Byte[]{};
        Object[] result = ArrayUtils.nullToEmpty((Byte[])empty);
        Assertions.assertArrayEquals((Object[])ArrayUtils.EMPTY_BYTE_OBJECT_ARRAY, (Object[])result);
        Assertions.assertNotSame((Object)empty, (Object)result);
    }

    @Test
    public void testNullToEmptyByteObjectNull() {
        Assertions.assertArrayEquals((Object[])ArrayUtils.EMPTY_BYTE_OBJECT_ARRAY, (Object[])ArrayUtils.nullToEmpty((Byte[])null));
    }

    @Test
    public void testNullToEmptyChar() {
        char[] original = new char[]{'a', 'b'};
        Assertions.assertEquals((Object)original, (Object)ArrayUtils.nullToEmpty((char[])original));
    }

    @Test
    public void testNullToEmptyCharEmptyArray() {
        char[] empty = new char[]{};
        char[] result = ArrayUtils.nullToEmpty((char[])empty);
        Assertions.assertEquals((Object)ArrayUtils.EMPTY_CHAR_ARRAY, (Object)result);
        Assertions.assertNotSame((Object)empty, (Object)result);
    }

    @Test
    public void testNullToEmptyCharNull() {
        Assertions.assertEquals((Object)ArrayUtils.EMPTY_CHAR_ARRAY, (Object)ArrayUtils.nullToEmpty((char[])null));
    }

    @Test
    public void testNullToEmptyCharObject() {
        Object[] original = new Character[]{Character.valueOf('a'), Character.valueOf('b')};
        Assertions.assertArrayEquals((Object[])original, (Object[])ArrayUtils.nullToEmpty((Character[])original));
    }

    @Test
    public void testNullToEmptyCharObjectEmptyArray() {
        Character[] empty = new Character[]{};
        Object[] result = ArrayUtils.nullToEmpty((Character[])empty);
        Assertions.assertArrayEquals((Object[])ArrayUtils.EMPTY_CHARACTER_OBJECT_ARRAY, (Object[])result);
        Assertions.assertNotSame((Object)empty, (Object)result);
    }

    @Test
    public void testNUllToEmptyCharObjectNull() {
        Assertions.assertArrayEquals((Object[])ArrayUtils.EMPTY_CHARACTER_OBJECT_ARRAY, (Object[])ArrayUtils.nullToEmpty((Character[])null));
    }

    @Test
    public void testNullToEmptyClass() {
        Object[] original = new Class[]{Object.class, String.class};
        Assertions.assertArrayEquals((Object[])original, (Object[])ArrayUtils.nullToEmpty((Class[])original));
    }

    @Test
    public void testNullToEmptyClassEmptyArray() {
        Class[] empty = new Class[]{};
        Object[] result = ArrayUtils.nullToEmpty((Class[])empty);
        Assertions.assertArrayEquals((Object[])ArrayUtils.EMPTY_CLASS_ARRAY, (Object[])result);
        Assertions.assertNotSame((Object)empty, (Object)result);
    }

    @Test
    public void testNullToEmptyClassNull() {
        Assertions.assertArrayEquals((Object[])ArrayUtils.EMPTY_CLASS_ARRAY, (Object[])ArrayUtils.nullToEmpty((Class[])null));
    }

    @Test
    public void testNullToEmptyDouble() {
        double[] original = new double[]{1.0, 2.0};
        Assertions.assertEquals((Object)original, (Object)ArrayUtils.nullToEmpty((double[])original));
    }

    @Test
    public void testNullToEmptyDoubleEmptyArray() {
        double[] empty = new double[]{};
        double[] result = ArrayUtils.nullToEmpty((double[])empty);
        Assertions.assertEquals((Object)ArrayUtils.EMPTY_DOUBLE_ARRAY, (Object)result);
        Assertions.assertNotSame((Object)empty, (Object)result);
    }

    @Test
    public void testNullToEmptyDoubleNull() {
        Assertions.assertEquals((Object)ArrayUtils.EMPTY_DOUBLE_ARRAY, (Object)ArrayUtils.nullToEmpty((double[])null));
    }

    @Test
    public void testNullToEmptyDoubleObject() {
        Object[] original = new Double[]{1.0, 2.0};
        Assertions.assertArrayEquals((Object[])original, (Object[])ArrayUtils.nullToEmpty((Double[])original));
    }

    @Test
    public void testNullToEmptyDoubleObjectEmptyArray() {
        Double[] empty = new Double[]{};
        Object[] result = ArrayUtils.nullToEmpty((Double[])empty);
        Assertions.assertArrayEquals((Object[])ArrayUtils.EMPTY_DOUBLE_OBJECT_ARRAY, (Object[])result);
        Assertions.assertNotSame((Object)empty, (Object)result);
    }

    @Test
    public void testNullToEmptyDoubleObjectNull() {
        Assertions.assertArrayEquals((Object[])ArrayUtils.EMPTY_DOUBLE_OBJECT_ARRAY, (Object[])ArrayUtils.nullToEmpty((Double[])null));
    }

    @Test
    public void testNullToEmptyFloat() {
        float[] original = new float[]{2.6f, 3.8f};
        Assertions.assertEquals((Object)original, (Object)ArrayUtils.nullToEmpty((float[])original));
    }

    @Test
    public void testNullToEmptyFloatEmptyArray() {
        float[] empty = new float[]{};
        float[] result = ArrayUtils.nullToEmpty((float[])empty);
        Assertions.assertEquals((Object)ArrayUtils.EMPTY_FLOAT_ARRAY, (Object)result);
        Assertions.assertNotSame((Object)empty, (Object)result);
    }

    @Test
    public void testNullToEmptyFloatNull() {
        Assertions.assertEquals((Object)ArrayUtils.EMPTY_FLOAT_ARRAY, (Object)ArrayUtils.nullToEmpty((float[])null));
    }

    @Test
    public void testNullToEmptyFloatObject() {
        Object[] original = new Float[]{Float.valueOf(2.6f), Float.valueOf(3.8f)};
        Assertions.assertArrayEquals((Object[])original, (Object[])ArrayUtils.nullToEmpty((Float[])original));
    }

    @Test
    public void testNullToEmptyFloatObjectEmptyArray() {
        Float[] empty = new Float[]{};
        Object[] result = ArrayUtils.nullToEmpty((Float[])empty);
        Assertions.assertArrayEquals((Object[])ArrayUtils.EMPTY_FLOAT_OBJECT_ARRAY, (Object[])result);
        Assertions.assertNotSame((Object)empty, (Object)result);
    }

    @Test
    public void testNullToEmptyFloatObjectNull() {
        Assertions.assertArrayEquals((Object[])ArrayUtils.EMPTY_FLOAT_OBJECT_ARRAY, (Object[])ArrayUtils.nullToEmpty((Float[])null));
    }

    @Test
    public void testNullToEmptyGeneric() {
        Object[] input = new TestClass[]{new TestClass(), new TestClass()};
        TestClass[] output = (TestClass[])ArrayUtils.nullToEmpty((Object[])input, TestClass[].class);
        Assertions.assertSame((Object)input, (Object)output);
    }

    @Test
    public void testNullToEmptyGenericEmpty() {
        Object[] input = new TestClass[]{};
        TestClass[] output = (TestClass[])ArrayUtils.nullToEmpty((Object[])input, TestClass[].class);
        Assertions.assertSame((Object)input, (Object)output);
    }

    @Test
    public void testNullToEmptyGenericNull() {
        TestClass[] output = (TestClass[])ArrayUtils.nullToEmpty(null, TestClass[].class);
        Assertions.assertNotNull((Object)output);
        Assertions.assertEquals((int)0, (int)output.length);
    }

    @Test
    public void testNullToEmptyGenericNullType() {
        TestClass[] input = new TestClass[]{};
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            TestClass[] cfr_ignored_0 = (TestClass[])ArrayUtils.nullToEmpty((Object[])input, null);
        });
    }

    @Test
    public void testNullToEmptyInt() {
        int[] original = new int[]{1, 2};
        Assertions.assertEquals((Object)original, (Object)ArrayUtils.nullToEmpty((int[])original));
    }

    @Test
    public void testNullToEmptyIntEmptyArray() {
        int[] empty = new int[]{};
        int[] result = ArrayUtils.nullToEmpty((int[])empty);
        Assertions.assertEquals((Object)ArrayUtils.EMPTY_INT_ARRAY, (Object)result);
        Assertions.assertNotSame((Object)empty, (Object)result);
    }

    @Test
    public void testNullToEmptyIntNull() {
        Assertions.assertEquals((Object)ArrayUtils.EMPTY_INT_ARRAY, (Object)ArrayUtils.nullToEmpty((int[])null));
    }

    @Test
    public void testNullToEmptyIntObject() {
        Object[] original = new Integer[]{1, 2};
        Assertions.assertArrayEquals((Object[])original, (Object[])ArrayUtils.nullToEmpty((Integer[])original));
    }

    @Test
    public void testNullToEmptyIntObjectEmptyArray() {
        Integer[] empty = new Integer[]{};
        Object[] result = ArrayUtils.nullToEmpty((Integer[])empty);
        Assertions.assertArrayEquals((Object[])ArrayUtils.EMPTY_INTEGER_OBJECT_ARRAY, (Object[])result);
        Assertions.assertNotSame((Object)empty, (Object)result);
    }

    @Test
    public void testNullToEmptyIntObjectNull() {
        Assertions.assertArrayEquals((Object[])ArrayUtils.EMPTY_INTEGER_OBJECT_ARRAY, (Object[])ArrayUtils.nullToEmpty((Integer[])null));
    }

    @Test
    public void testNullToEmptyLong() {
        long[] original = new long[]{1L, 2L};
        Assertions.assertEquals((Object)original, (Object)ArrayUtils.nullToEmpty((long[])original));
    }

    @Test
    public void testNullToEmptyLongEmptyArray() {
        long[] empty = new long[]{};
        long[] result = ArrayUtils.nullToEmpty((long[])empty);
        Assertions.assertEquals((Object)ArrayUtils.EMPTY_LONG_ARRAY, (Object)result);
        Assertions.assertNotSame((Object)empty, (Object)result);
    }

    @Test
    public void testNullToEmptyLongNull() {
        Assertions.assertEquals((Object)ArrayUtils.EMPTY_LONG_ARRAY, (Object)ArrayUtils.nullToEmpty((long[])null));
    }

    @Test
    public void testNullToEmptyLongObject() {
        Object[] original = new Long[]{1L, 2L};
        Assertions.assertArrayEquals((Object[])original, (Object[])ArrayUtils.nullToEmpty((Long[])original));
    }

    @Test
    public void testNullToEmptyLongObjectEmptyArray() {
        Long[] empty = new Long[]{};
        Object[] result = ArrayUtils.nullToEmpty((Long[])empty);
        Assertions.assertArrayEquals((Object[])ArrayUtils.EMPTY_LONG_OBJECT_ARRAY, (Object[])result);
        Assertions.assertNotSame((Object)empty, (Object)result);
    }

    @Test
    public void testNullToEmptyLongObjectNull() {
        Assertions.assertArrayEquals((Object[])ArrayUtils.EMPTY_LONG_OBJECT_ARRAY, (Object[])ArrayUtils.nullToEmpty((Long[])null));
    }

    @Test
    public void testNullToEmptyObject() {
        Object[] original = new Object[]{Boolean.TRUE, Boolean.FALSE};
        Assertions.assertArrayEquals((Object[])original, (Object[])ArrayUtils.nullToEmpty((Object[])original));
    }

    @Test
    public void testNullToEmptyObjectEmptyArray() {
        Object[] empty = new Object[]{};
        Object[] result = ArrayUtils.nullToEmpty((Object[])empty);
        Assertions.assertArrayEquals((Object[])ArrayUtils.EMPTY_OBJECT_ARRAY, (Object[])result);
        Assertions.assertNotSame((Object)empty, (Object)result);
    }

    @Test
    public void testNullToEmptyObjectNull() {
        Assertions.assertArrayEquals((Object[])ArrayUtils.EMPTY_OBJECT_ARRAY, (Object[])ArrayUtils.nullToEmpty((Object[])null));
    }

    @Test
    public void testNullToEmptyShort() {
        short[] original = new short[]{1, 2};
        Assertions.assertEquals((Object)original, (Object)ArrayUtils.nullToEmpty((short[])original));
    }

    @Test
    public void testNullToEmptyShortEmptyArray() {
        short[] empty = new short[]{};
        short[] result = ArrayUtils.nullToEmpty((short[])empty);
        Assertions.assertEquals((Object)ArrayUtils.EMPTY_SHORT_ARRAY, (Object)result);
        Assertions.assertNotSame((Object)empty, (Object)result);
    }

    @Test
    public void testNullToEmptyShortNull() {
        Assertions.assertEquals((Object)ArrayUtils.EMPTY_SHORT_ARRAY, (Object)ArrayUtils.nullToEmpty((short[])null));
    }

    @Test
    public void testNullToEmptyShortObject() {
        Object[] original = new Short[]{(short)1, (short)2};
        Assertions.assertArrayEquals((Object[])original, (Object[])ArrayUtils.nullToEmpty((Short[])original));
    }

    @Test
    public void testNullToEmptyShortObjectEmptyArray() {
        Short[] empty = new Short[]{};
        Object[] result = ArrayUtils.nullToEmpty((Short[])empty);
        Assertions.assertArrayEquals((Object[])ArrayUtils.EMPTY_SHORT_OBJECT_ARRAY, (Object[])result);
        Assertions.assertNotSame((Object)empty, (Object)result);
    }

    @Test
    public void testNullToEmptyShortObjectNull() {
        Assertions.assertArrayEquals((Object[])ArrayUtils.EMPTY_SHORT_OBJECT_ARRAY, (Object[])ArrayUtils.nullToEmpty((Short[])null));
    }

    @Test
    public void testNullToEmptyString() {
        Object[] original = new String[]{"abc", "def"};
        Assertions.assertArrayEquals((Object[])original, (Object[])ArrayUtils.nullToEmpty((String[])original));
    }

    @Test
    public void testNullToEmptyStringEmptyArray() {
        String[] empty = new String[]{};
        Object[] result = ArrayUtils.nullToEmpty((String[])empty);
        Assertions.assertArrayEquals((Object[])ArrayUtils.EMPTY_STRING_ARRAY, (Object[])result);
        Assertions.assertNotSame((Object)empty, (Object)result);
    }

    @Test
    public void testNullToEmptyStringNull() {
        Assertions.assertArrayEquals((Object[])ArrayUtils.EMPTY_STRING_ARRAY, (Object[])ArrayUtils.nullToEmpty((String[])null));
    }

    @Test
    public void testReverse() {
        StringBuffer str1 = new StringBuffer("pick");
        String str2 = "a";
        String[] str3 = new String[]{"stick"};
        String str4 = "up";
        Object[] array = new Object[]{str1, "a", str3};
        ArrayUtils.reverse((Object[])array);
        Assertions.assertEquals((Object)array[0], (Object)str3);
        Assertions.assertEquals((Object)array[1], (Object)"a");
        Assertions.assertEquals((Object)array[2], (Object)str1);
        array = new Object[]{str1, "a", str3, "up"};
        ArrayUtils.reverse((Object[])array);
        Assertions.assertEquals((Object)array[0], (Object)"up");
        Assertions.assertEquals((Object)array[1], (Object)str3);
        Assertions.assertEquals((Object)array[2], (Object)"a");
        Assertions.assertEquals((Object)array[3], (Object)str1);
        array = null;
        ArrayUtils.reverse((Object[])array);
        Assertions.assertArrayEquals(null, (Object[])array);
    }

    @Test
    public void testReverseBoolean() {
        boolean[] array = new boolean[]{false, false, true};
        ArrayUtils.reverse((boolean[])array);
        Assertions.assertTrue((boolean)array[0]);
        Assertions.assertFalse((boolean)array[1]);
        Assertions.assertFalse((boolean)array[2]);
        array = null;
        ArrayUtils.reverse((boolean[])array);
        Assertions.assertNull((Object)array);
    }

    @Test
    public void testReverseBooleanRange() {
        boolean[] array = new boolean[]{false, false, true};
        ArrayUtils.reverse((boolean[])array, (int)0, (int)3);
        Assertions.assertTrue((boolean)array[0]);
        Assertions.assertFalse((boolean)array[1]);
        Assertions.assertFalse((boolean)array[2]);
        array = new boolean[]{false, false, true};
        ArrayUtils.reverse((boolean[])array, (int)0, (int)2);
        Assertions.assertFalse((boolean)array[0]);
        Assertions.assertFalse((boolean)array[1]);
        Assertions.assertTrue((boolean)array[2]);
        array = new boolean[]{false, false, true};
        ArrayUtils.reverse((boolean[])array, (int)-1, (int)3);
        Assertions.assertTrue((boolean)array[0]);
        Assertions.assertFalse((boolean)array[1]);
        Assertions.assertFalse((boolean)array[2]);
        array = new boolean[]{false, false, true};
        ArrayUtils.reverse((boolean[])array, (int)-1, (int)(array.length + 1000));
        Assertions.assertTrue((boolean)array[0]);
        Assertions.assertFalse((boolean)array[1]);
        Assertions.assertFalse((boolean)array[2]);
        array = null;
        ArrayUtils.reverse((boolean[])array, (int)0, (int)3);
        Assertions.assertNull((Object)array);
    }

    @Test
    public void testReverseByte() {
        byte[] array = new byte[]{2, 3, 4};
        ArrayUtils.reverse((byte[])array);
        Assertions.assertEquals((int)array[0], (int)4);
        Assertions.assertEquals((int)array[1], (int)3);
        Assertions.assertEquals((int)array[2], (int)2);
        array = null;
        ArrayUtils.reverse((byte[])array);
        Assertions.assertNull((Object)array);
    }

    @Test
    public void testReverseByteRange() {
        byte[] array = new byte[]{1, 2, 3};
        ArrayUtils.reverse((byte[])array, (int)0, (int)3);
        Assertions.assertEquals((int)3, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)1, (int)array[2]);
        array = new byte[]{1, 2, 3};
        ArrayUtils.reverse((byte[])array, (int)0, (int)2);
        Assertions.assertEquals((int)2, (int)array[0]);
        Assertions.assertEquals((int)1, (int)array[1]);
        Assertions.assertEquals((int)3, (int)array[2]);
        array = new byte[]{1, 2, 3};
        ArrayUtils.reverse((byte[])array, (int)-1, (int)3);
        Assertions.assertEquals((int)3, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)1, (int)array[2]);
        array = new byte[]{1, 2, 3};
        ArrayUtils.reverse((byte[])array, (int)-1, (int)(array.length + 1000));
        Assertions.assertEquals((int)3, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)1, (int)array[2]);
        array = null;
        ArrayUtils.reverse((byte[])array, (int)0, (int)3);
        Assertions.assertNull((Object)array);
    }

    @Test
    public void testReverseChar() {
        char[] array = new char[]{'a', 'f', 'C'};
        ArrayUtils.reverse((char[])array);
        Assertions.assertEquals((char)array[0], (char)'C');
        Assertions.assertEquals((char)array[1], (char)'f');
        Assertions.assertEquals((char)array[2], (char)'a');
        array = null;
        ArrayUtils.reverse((char[])array);
        Assertions.assertNull((Object)array);
    }

    @Test
    public void testReverseCharRange() {
        char[] array = new char[]{'\u0001', '\u0002', '\u0003'};
        ArrayUtils.reverse((char[])array, (int)0, (int)3);
        Assertions.assertEquals((int)3, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)1, (int)array[2]);
        array = new char[]{'\u0001', '\u0002', '\u0003'};
        ArrayUtils.reverse((char[])array, (int)0, (int)2);
        Assertions.assertEquals((int)2, (int)array[0]);
        Assertions.assertEquals((int)1, (int)array[1]);
        Assertions.assertEquals((int)3, (int)array[2]);
        array = new char[]{'\u0001', '\u0002', '\u0003'};
        ArrayUtils.reverse((char[])array, (int)-1, (int)3);
        Assertions.assertEquals((int)3, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)1, (int)array[2]);
        array = new char[]{'\u0001', '\u0002', '\u0003'};
        ArrayUtils.reverse((char[])array, (int)-1, (int)(array.length + 1000));
        Assertions.assertEquals((int)3, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)1, (int)array[2]);
        array = null;
        ArrayUtils.reverse((char[])array, (int)0, (int)3);
        Assertions.assertNull((Object)array);
    }

    @Test
    public void testReverseDouble() {
        double[] array = new double[]{0.3, 0.4, 0.5};
        ArrayUtils.reverse((double[])array);
        Assertions.assertEquals((double)0.5, (double)array[0]);
        Assertions.assertEquals((double)0.4, (double)array[1]);
        Assertions.assertEquals((double)0.3, (double)array[2]);
        array = null;
        ArrayUtils.reverse((double[])array);
        Assertions.assertNull((Object)array);
    }

    @Test
    public void testReverseDoubleRange() {
        double[] array = new double[]{1.0, 2.0, 3.0};
        ArrayUtils.reverse((double[])array, (int)0, (int)3);
        Assertions.assertEquals((double)3.0, (double)array[0]);
        Assertions.assertEquals((double)2.0, (double)array[1]);
        Assertions.assertEquals((double)1.0, (double)array[2]);
        array = new double[]{1.0, 2.0, 3.0};
        ArrayUtils.reverse((double[])array, (int)0, (int)2);
        Assertions.assertEquals((double)2.0, (double)array[0]);
        Assertions.assertEquals((double)1.0, (double)array[1]);
        Assertions.assertEquals((double)3.0, (double)array[2]);
        array = new double[]{1.0, 2.0, 3.0};
        ArrayUtils.reverse((double[])array, (int)-1, (int)3);
        Assertions.assertEquals((double)3.0, (double)array[0]);
        Assertions.assertEquals((double)2.0, (double)array[1]);
        Assertions.assertEquals((double)1.0, (double)array[2]);
        array = new double[]{1.0, 2.0, 3.0};
        ArrayUtils.reverse((double[])array, (int)-1, (int)(array.length + 1000));
        Assertions.assertEquals((double)3.0, (double)array[0]);
        Assertions.assertEquals((double)2.0, (double)array[1]);
        Assertions.assertEquals((double)1.0, (double)array[2]);
        array = null;
        ArrayUtils.reverse((double[])array, (int)0, (int)3);
        Assertions.assertNull((Object)array);
    }

    @Test
    public void testReverseFloat() {
        float[] array = new float[]{0.3f, 0.4f, 0.5f};
        ArrayUtils.reverse((float[])array);
        Assertions.assertEquals((float)0.5f, (float)array[0]);
        Assertions.assertEquals((float)0.4f, (float)array[1]);
        Assertions.assertEquals((float)0.3f, (float)array[2]);
        array = null;
        ArrayUtils.reverse((float[])array);
        Assertions.assertNull((Object)array);
    }

    @Test
    public void testReverseFloatRange() {
        float[] array = new float[]{1.0f, 2.0f, 3.0f};
        ArrayUtils.reverse((float[])array, (int)0, (int)3);
        Assertions.assertEquals((float)3.0f, (float)array[0]);
        Assertions.assertEquals((float)2.0f, (float)array[1]);
        Assertions.assertEquals((float)1.0f, (float)array[2]);
        array = new float[]{1.0f, 2.0f, 3.0f};
        ArrayUtils.reverse((float[])array, (int)0, (int)2);
        Assertions.assertEquals((float)2.0f, (float)array[0]);
        Assertions.assertEquals((float)1.0f, (float)array[1]);
        Assertions.assertEquals((float)3.0f, (float)array[2]);
        array = new float[]{1.0f, 2.0f, 3.0f};
        ArrayUtils.reverse((float[])array, (int)-1, (int)3);
        Assertions.assertEquals((float)3.0f, (float)array[0]);
        Assertions.assertEquals((float)2.0f, (float)array[1]);
        Assertions.assertEquals((float)1.0f, (float)array[2]);
        array = new float[]{1.0f, 2.0f, 3.0f};
        ArrayUtils.reverse((float[])array, (int)-1, (int)(array.length + 1000));
        Assertions.assertEquals((float)3.0f, (float)array[0]);
        Assertions.assertEquals((float)2.0f, (float)array[1]);
        Assertions.assertEquals((float)1.0f, (float)array[2]);
        array = null;
        ArrayUtils.reverse((float[])array, (int)0, (int)3);
        Assertions.assertNull((Object)array);
    }

    @Test
    public void testReverseInt() {
        int[] array = new int[]{1, 2, 3};
        ArrayUtils.reverse((int[])array);
        Assertions.assertEquals((int)array[0], (int)3);
        Assertions.assertEquals((int)array[1], (int)2);
        Assertions.assertEquals((int)array[2], (int)1);
        array = null;
        ArrayUtils.reverse((int[])array);
        Assertions.assertNull((Object)array);
    }

    @Test
    public void testReverseIntRange() {
        int[] array = new int[]{1, 2, 3};
        ArrayUtils.reverse((int[])array, (int)0, (int)3);
        Assertions.assertEquals((int)3, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)1, (int)array[2]);
        array = new int[]{1, 2, 3};
        ArrayUtils.reverse((int[])array, (int)0, (int)2);
        Assertions.assertEquals((int)2, (int)array[0]);
        Assertions.assertEquals((int)1, (int)array[1]);
        Assertions.assertEquals((int)3, (int)array[2]);
        array = new int[]{1, 2, 3};
        ArrayUtils.reverse((int[])array, (int)-1, (int)3);
        Assertions.assertEquals((int)3, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)1, (int)array[2]);
        array = new int[]{1, 2, 3};
        ArrayUtils.reverse((int[])array, (int)-1, (int)(array.length + 1000));
        Assertions.assertEquals((int)3, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)1, (int)array[2]);
        array = null;
        ArrayUtils.reverse((int[])array, (int)0, (int)3);
        Assertions.assertNull((Object)array);
    }

    @Test
    public void testReverseLong() {
        long[] array = new long[]{1L, 2L, 3L};
        ArrayUtils.reverse((long[])array);
        Assertions.assertEquals((long)array[0], (long)3L);
        Assertions.assertEquals((long)array[1], (long)2L);
        Assertions.assertEquals((long)array[2], (long)1L);
        array = null;
        ArrayUtils.reverse((long[])array);
        Assertions.assertNull((Object)array);
    }

    @Test
    public void testReverseLongRange() {
        long[] array = new long[]{1L, 2L, 3L};
        ArrayUtils.reverse((long[])array, (int)0, (int)3);
        Assertions.assertEquals((long)3L, (long)array[0]);
        Assertions.assertEquals((long)2L, (long)array[1]);
        Assertions.assertEquals((long)1L, (long)array[2]);
        array = new long[]{1L, 2L, 3L};
        ArrayUtils.reverse((long[])array, (int)0, (int)2);
        Assertions.assertEquals((long)2L, (long)array[0]);
        Assertions.assertEquals((long)1L, (long)array[1]);
        Assertions.assertEquals((long)3L, (long)array[2]);
        array = new long[]{1L, 2L, 3L};
        ArrayUtils.reverse((long[])array, (int)-1, (int)3);
        Assertions.assertEquals((long)3L, (long)array[0]);
        Assertions.assertEquals((long)2L, (long)array[1]);
        Assertions.assertEquals((long)1L, (long)array[2]);
        array = new long[]{1L, 2L, 3L};
        ArrayUtils.reverse((long[])array, (int)-1, (int)(array.length + 1000));
        Assertions.assertEquals((long)3L, (long)array[0]);
        Assertions.assertEquals((long)2L, (long)array[1]);
        Assertions.assertEquals((long)1L, (long)array[2]);
        array = null;
        ArrayUtils.reverse((long[])array, (int)0, (int)3);
        Assertions.assertNull((Object)array);
    }

    @Test
    public void testReverseObjectRange() {
        Object[] array = new String[]{"1", "2", "3"};
        ArrayUtils.reverse((Object[])array, (int)0, (int)3);
        Assertions.assertEquals((Object)"3", (Object)array[0]);
        Assertions.assertEquals((Object)"2", (Object)array[1]);
        Assertions.assertEquals((Object)"1", (Object)array[2]);
        array = new String[]{"1", "2", "3"};
        ArrayUtils.reverse((Object[])array, (int)0, (int)2);
        Assertions.assertEquals((Object)"2", (Object)array[0]);
        Assertions.assertEquals((Object)"1", (Object)array[1]);
        Assertions.assertEquals((Object)"3", (Object)array[2]);
        array = new String[]{"1", "2", "3"};
        ArrayUtils.reverse((Object[])array, (int)-1, (int)3);
        Assertions.assertEquals((Object)"3", (Object)array[0]);
        Assertions.assertEquals((Object)"2", (Object)array[1]);
        Assertions.assertEquals((Object)"1", (Object)array[2]);
        array = new String[]{"1", "2", "3"};
        ArrayUtils.reverse((Object[])array, (int)-1, (int)(array.length + 1000));
        Assertions.assertEquals((Object)"3", (Object)array[0]);
        Assertions.assertEquals((Object)"2", (Object)array[1]);
        Assertions.assertEquals((Object)"1", (Object)array[2]);
        array = null;
        ArrayUtils.reverse((Object[])array, (int)0, (int)3);
        Assertions.assertNull((Object)array);
    }

    @Test
    public void testReverseShort() {
        short[] array = new short[]{1, 2, 3};
        ArrayUtils.reverse((short[])array);
        Assertions.assertEquals((int)array[0], (int)3);
        Assertions.assertEquals((int)array[1], (int)2);
        Assertions.assertEquals((int)array[2], (int)1);
        array = null;
        ArrayUtils.reverse((short[])array);
        Assertions.assertNull((Object)array);
    }

    @Test
    public void testReverseShortRange() {
        short[] array = new short[]{1, 2, 3};
        ArrayUtils.reverse((short[])array, (int)0, (int)3);
        Assertions.assertEquals((int)3, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)1, (int)array[2]);
        array = new short[]{1, 2, 3};
        ArrayUtils.reverse((short[])array, (int)0, (int)2);
        Assertions.assertEquals((int)2, (int)array[0]);
        Assertions.assertEquals((int)1, (int)array[1]);
        Assertions.assertEquals((int)3, (int)array[2]);
        array = new short[]{1, 2, 3};
        ArrayUtils.reverse((short[])array, (int)-1, (int)3);
        Assertions.assertEquals((int)3, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)1, (int)array[2]);
        array = new short[]{1, 2, 3};
        ArrayUtils.reverse((short[])array, (int)-1, (int)(array.length + 1000));
        Assertions.assertEquals((int)3, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)1, (int)array[2]);
        array = null;
        ArrayUtils.reverse((short[])array, (int)0, (int)3);
        Assertions.assertNull((Object)array);
    }

    @Test
    public void testSameLength() {
        Object[] nullArray = null;
        Object[] emptyArray = new Object[]{};
        Object[] oneArray = new Object[]{"pick"};
        Object[] twoArray = new Object[]{"pick", "stick"};
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArray, nullArray));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArray, (Object[])emptyArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArray, (Object[])oneArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArray, (Object[])twoArray));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object[])emptyArray, nullArray));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object[])emptyArray, (Object[])emptyArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object[])emptyArray, (Object[])oneArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object[])emptyArray, (Object[])twoArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object[])oneArray, nullArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object[])oneArray, (Object[])emptyArray));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object[])oneArray, (Object[])oneArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object[])oneArray, (Object[])twoArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object[])twoArray, nullArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object[])twoArray, (Object[])emptyArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object[])twoArray, (Object[])oneArray));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object[])twoArray, (Object[])twoArray));
    }

    @Test
    public void testSameLengthAll() {
        Object[] nullArrayObject = null;
        Object[] emptyArrayObject = new Object[]{};
        Object[] oneArrayObject = new Object[]{"pick"};
        Object[] twoArrayObject = new Object[]{"pick", "stick"};
        boolean[] nullArrayBoolean = null;
        boolean[] emptyArrayBoolean = new boolean[]{};
        boolean[] oneArrayBoolean = new boolean[]{true};
        boolean[] twoArrayBoolean = new boolean[]{true, false};
        long[] nullArrayLong = null;
        long[] emptyArrayLong = new long[]{};
        long[] oneArrayLong = new long[]{0L};
        long[] twoArrayLong = new long[]{0L, 76L};
        int[] nullArrayInt = null;
        int[] emptyArrayInt = new int[]{};
        int[] oneArrayInt = new int[]{4};
        int[] twoArrayInt = new int[]{5, 7};
        short[] nullArrayShort = null;
        short[] emptyArrayShort = new short[]{};
        short[] oneArrayShort = new short[]{4};
        short[] twoArrayShort = new short[]{6, 8};
        char[] nullArrayChar = null;
        char[] emptyArrayChar = new char[]{};
        char[] oneArrayChar = new char[]{'f'};
        char[] twoArrayChar = new char[]{'d', 't'};
        byte[] nullArrayByte = null;
        byte[] emptyArrayByte = new byte[]{};
        byte[] oneArrayByte = new byte[]{3};
        byte[] twoArrayByte = new byte[]{4, 6};
        double[] nullArrayDouble = null;
        double[] emptyArrayDouble = new double[]{};
        double[] oneArrayDouble = new double[]{1.3};
        double[] twoArrayDouble = new double[]{4.5, 6.3};
        float[] nullArrayFloat = null;
        float[] emptyArrayFloat = new float[]{};
        float[] oneArrayFloat = new float[]{2.5f};
        float[] twoArrayFloat = new float[]{6.4f, 5.8f};
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayObject, nullArrayObject));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayObject, nullArrayBoolean));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayObject, nullArrayLong));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayObject, nullArrayInt));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayObject, nullArrayShort));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayObject, nullArrayChar));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayObject, nullArrayByte));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayObject, nullArrayDouble));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayObject, nullArrayFloat));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayBoolean, nullArrayObject));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayBoolean, nullArrayBoolean));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayBoolean, nullArrayLong));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayBoolean, nullArrayInt));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayBoolean, nullArrayShort));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayBoolean, nullArrayChar));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayBoolean, nullArrayByte));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayBoolean, nullArrayDouble));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayBoolean, nullArrayFloat));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayLong, nullArrayObject));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayLong, nullArrayBoolean));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayLong, nullArrayLong));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayLong, nullArrayInt));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayLong, nullArrayShort));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayLong, nullArrayChar));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayLong, nullArrayByte));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayLong, nullArrayDouble));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayLong, nullArrayFloat));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayInt, nullArrayObject));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayInt, nullArrayBoolean));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayInt, nullArrayLong));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayInt, nullArrayInt));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayInt, nullArrayShort));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayInt, nullArrayChar));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayInt, nullArrayByte));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayInt, nullArrayDouble));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayInt, nullArrayFloat));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayShort, nullArrayObject));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayShort, nullArrayBoolean));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayShort, nullArrayLong));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayShort, nullArrayInt));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayShort, nullArrayShort));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayShort, nullArrayChar));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayShort, nullArrayByte));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayShort, nullArrayDouble));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayShort, nullArrayFloat));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayChar, nullArrayObject));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayChar, nullArrayBoolean));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayChar, nullArrayLong));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayChar, nullArrayInt));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayChar, nullArrayShort));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayChar, nullArrayChar));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayChar, nullArrayByte));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayChar, nullArrayDouble));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayChar, nullArrayFloat));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayByte, nullArrayObject));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayByte, nullArrayBoolean));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayByte, nullArrayLong));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayByte, nullArrayInt));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayByte, nullArrayShort));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayByte, nullArrayChar));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayByte, nullArrayByte));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayByte, nullArrayDouble));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayByte, nullArrayFloat));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayDouble, nullArrayObject));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayDouble, nullArrayBoolean));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayDouble, nullArrayLong));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayDouble, nullArrayInt));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayDouble, nullArrayShort));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayDouble, nullArrayChar));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayDouble, nullArrayByte));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayDouble, nullArrayDouble));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayDouble, nullArrayFloat));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayFloat, nullArrayObject));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayFloat, nullArrayBoolean));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayFloat, nullArrayLong));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayFloat, nullArrayInt));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayFloat, nullArrayShort));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayFloat, nullArrayChar));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayFloat, nullArrayByte));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayFloat, nullArrayDouble));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayFloat, nullArrayFloat));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayObject, (Object[])emptyArrayObject));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayObject, (Object)emptyArrayBoolean));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayObject, (Object)emptyArrayLong));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayObject, (Object)emptyArrayInt));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayObject, (Object)emptyArrayShort));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayObject, (Object)emptyArrayChar));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayObject, (Object)emptyArrayByte));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayObject, (Object)emptyArrayDouble));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayObject, (Object)emptyArrayFloat));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayBoolean, (Object)emptyArrayObject));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayBoolean, (boolean[])emptyArrayBoolean));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayBoolean, (Object)emptyArrayLong));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayBoolean, (Object)emptyArrayInt));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayBoolean, (Object)emptyArrayShort));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayBoolean, (Object)emptyArrayChar));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayBoolean, (Object)emptyArrayByte));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayBoolean, (Object)emptyArrayDouble));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayBoolean, (Object)emptyArrayFloat));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayLong, (Object)emptyArrayObject));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayLong, (Object)emptyArrayBoolean));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayLong, (long[])emptyArrayLong));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayLong, (Object)emptyArrayInt));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayLong, (Object)emptyArrayShort));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayLong, (Object)emptyArrayChar));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayLong, (Object)emptyArrayByte));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayLong, (Object)emptyArrayDouble));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayLong, (Object)emptyArrayFloat));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayInt, (Object)emptyArrayObject));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayInt, (Object)emptyArrayBoolean));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayInt, (Object)emptyArrayLong));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayInt, (int[])emptyArrayInt));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayInt, (Object)emptyArrayShort));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayInt, (Object)emptyArrayChar));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayInt, (Object)emptyArrayByte));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayInt, (Object)emptyArrayDouble));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayInt, (Object)emptyArrayFloat));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayShort, (Object)emptyArrayObject));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayShort, (Object)emptyArrayBoolean));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayShort, (Object)emptyArrayLong));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayShort, (Object)emptyArrayInt));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayShort, (short[])emptyArrayShort));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayShort, (Object)emptyArrayChar));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayShort, (Object)emptyArrayByte));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayShort, (Object)emptyArrayDouble));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayShort, (Object)emptyArrayFloat));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayChar, (Object)emptyArrayObject));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayChar, (Object)emptyArrayBoolean));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayChar, (Object)emptyArrayLong));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayChar, (Object)emptyArrayInt));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayChar, (Object)emptyArrayShort));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayChar, (char[])emptyArrayChar));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayChar, (Object)emptyArrayByte));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayChar, (Object)emptyArrayDouble));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayChar, (Object)emptyArrayFloat));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayByte, (Object)emptyArrayObject));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayByte, (Object)emptyArrayBoolean));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayByte, (Object)emptyArrayLong));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayByte, (Object)emptyArrayInt));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayByte, (Object)emptyArrayShort));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayByte, (Object)emptyArrayChar));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayByte, (byte[])emptyArrayByte));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayByte, (Object)emptyArrayDouble));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayByte, (Object)emptyArrayFloat));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayDouble, (Object)emptyArrayObject));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayDouble, (Object)emptyArrayBoolean));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayDouble, (Object)emptyArrayLong));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayDouble, (Object)emptyArrayInt));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayDouble, (Object)emptyArrayShort));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayDouble, (Object)emptyArrayChar));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayDouble, (Object)emptyArrayByte));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayDouble, (double[])emptyArrayDouble));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayDouble, (Object)emptyArrayFloat));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayFloat, (Object)emptyArrayObject));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayFloat, (Object)emptyArrayBoolean));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayFloat, (Object)emptyArrayLong));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayFloat, (Object)emptyArrayInt));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayFloat, (Object)emptyArrayShort));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayFloat, (Object)emptyArrayChar));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayFloat, (Object)emptyArrayByte));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayFloat, (Object)emptyArrayDouble));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArrayFloat, (float[])emptyArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayObject, (Object[])oneArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayObject, (Object)oneArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayObject, (Object)oneArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayObject, (Object)oneArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayObject, (Object)oneArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayObject, (Object)oneArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayObject, (Object)oneArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayObject, (Object)oneArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayObject, (Object)oneArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayBoolean, (Object)oneArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayBoolean, (boolean[])oneArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayBoolean, (Object)oneArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayBoolean, (Object)oneArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayBoolean, (Object)oneArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayBoolean, (Object)oneArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayBoolean, (Object)oneArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayBoolean, (Object)oneArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayBoolean, (Object)oneArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayLong, (Object)oneArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayLong, (Object)oneArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayLong, (long[])oneArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayLong, (Object)oneArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayLong, (Object)oneArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayLong, (Object)oneArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayLong, (Object)oneArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayLong, (Object)oneArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayLong, (Object)oneArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayInt, (Object)oneArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayInt, (Object)oneArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayInt, (Object)oneArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayInt, (int[])oneArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayInt, (Object)oneArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayInt, (Object)oneArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayInt, (Object)oneArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayInt, (Object)oneArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayInt, (Object)oneArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayShort, (Object)oneArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayShort, (Object)oneArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayShort, (Object)oneArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayShort, (Object)oneArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayShort, (short[])oneArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayShort, (Object)oneArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayShort, (Object)oneArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayShort, (Object)oneArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayShort, (Object)oneArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayChar, (Object)oneArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayChar, (Object)oneArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayChar, (Object)oneArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayChar, (Object)oneArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayChar, (Object)oneArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayChar, (char[])oneArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayChar, (Object)oneArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayChar, (Object)oneArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayChar, (Object)oneArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayByte, (Object)oneArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayByte, (Object)oneArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayByte, (Object)oneArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayByte, (Object)oneArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayByte, (Object)oneArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayByte, (Object)oneArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayByte, (byte[])oneArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayByte, (Object)oneArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayByte, (Object)oneArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayDouble, (Object)oneArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayDouble, (Object)oneArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayDouble, (Object)oneArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayDouble, (Object)oneArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayDouble, (Object)oneArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayDouble, (Object)oneArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayDouble, (Object)oneArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayDouble, (double[])oneArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayDouble, (Object)oneArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayFloat, (Object)oneArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayFloat, (Object)oneArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayFloat, (Object)oneArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayFloat, (Object)oneArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayFloat, (Object)oneArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayFloat, (Object)oneArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayFloat, (Object)oneArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayFloat, (Object)oneArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayFloat, (float[])oneArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayObject, (Object[])twoArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayObject, (Object)twoArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayObject, (Object)twoArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayObject, (Object)twoArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayObject, (Object)twoArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayObject, (Object)twoArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayObject, (Object)twoArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayObject, (Object)twoArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayObject, (Object)twoArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayBoolean, (Object)twoArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayBoolean, (boolean[])twoArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayBoolean, (Object)twoArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayBoolean, (Object)twoArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayBoolean, (Object)twoArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayBoolean, (Object)twoArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayBoolean, (Object)twoArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayBoolean, (Object)twoArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayBoolean, (Object)twoArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayLong, (Object)twoArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayLong, (Object)twoArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayLong, (long[])twoArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayLong, (Object)twoArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayLong, (Object)twoArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayLong, (Object)twoArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayLong, (Object)twoArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayLong, (Object)twoArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayLong, (Object)twoArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayInt, (Object)twoArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayInt, (Object)twoArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayInt, (Object)twoArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayInt, (int[])twoArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayInt, (Object)twoArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayInt, (Object)twoArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayInt, (Object)twoArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayInt, (Object)twoArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayInt, (Object)twoArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayShort, (Object)twoArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayShort, (Object)twoArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayShort, (Object)twoArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayShort, (Object)twoArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayShort, (short[])twoArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayShort, (Object)twoArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayShort, (Object)twoArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayShort, (Object)twoArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayShort, (Object)twoArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayChar, (Object)twoArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayChar, (Object)twoArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayChar, (Object)twoArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayChar, (Object)twoArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayChar, (Object)twoArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayChar, (char[])twoArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayChar, (Object)twoArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayChar, (Object)twoArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayChar, (Object)twoArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayByte, (Object)twoArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayByte, (Object)twoArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayByte, (Object)twoArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayByte, (Object)twoArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayByte, (Object)twoArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayByte, (Object)twoArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayByte, (byte[])twoArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayByte, (Object)twoArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayByte, (Object)twoArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayDouble, (Object)twoArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayDouble, (Object)twoArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayDouble, (Object)twoArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayDouble, (Object)twoArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayDouble, (Object)twoArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayDouble, (Object)twoArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayDouble, (Object)twoArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayDouble, (double[])twoArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayDouble, (Object)twoArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayFloat, (Object)twoArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayFloat, (Object)twoArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayFloat, (Object)twoArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayFloat, (Object)twoArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayFloat, (Object)twoArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayFloat, (Object)twoArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayFloat, (Object)twoArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayFloat, (Object)twoArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArrayFloat, (float[])twoArrayFloat));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object[])emptyArrayObject, nullArrayObject));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayObject, nullArrayBoolean));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayObject, nullArrayLong));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayObject, nullArrayInt));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayObject, nullArrayShort));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayObject, nullArrayChar));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayObject, nullArrayByte));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayObject, nullArrayDouble));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayObject, nullArrayFloat));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayBoolean, nullArrayObject));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((boolean[])emptyArrayBoolean, nullArrayBoolean));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayBoolean, nullArrayLong));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayBoolean, nullArrayInt));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayBoolean, nullArrayShort));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayBoolean, nullArrayChar));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayBoolean, nullArrayByte));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayBoolean, nullArrayDouble));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayBoolean, nullArrayFloat));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayLong, nullArrayObject));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayLong, nullArrayBoolean));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((long[])emptyArrayLong, nullArrayLong));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayLong, nullArrayInt));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayLong, nullArrayShort));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayLong, nullArrayChar));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayLong, nullArrayByte));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayLong, nullArrayDouble));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayLong, nullArrayFloat));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayInt, nullArrayObject));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayInt, nullArrayBoolean));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayInt, nullArrayLong));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((int[])emptyArrayInt, nullArrayInt));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayInt, nullArrayShort));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayInt, nullArrayChar));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayInt, nullArrayByte));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayInt, nullArrayDouble));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayInt, nullArrayFloat));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayShort, nullArrayObject));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayShort, nullArrayBoolean));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayShort, nullArrayLong));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayShort, nullArrayInt));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((short[])emptyArrayShort, nullArrayShort));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayShort, nullArrayChar));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayShort, nullArrayByte));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayShort, nullArrayDouble));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayShort, nullArrayFloat));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayChar, nullArrayObject));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayChar, nullArrayBoolean));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayChar, nullArrayLong));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayChar, nullArrayInt));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayChar, nullArrayShort));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((char[])emptyArrayChar, nullArrayChar));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayChar, nullArrayByte));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayChar, nullArrayDouble));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayChar, nullArrayFloat));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayByte, nullArrayObject));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayByte, nullArrayBoolean));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayByte, nullArrayLong));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayByte, nullArrayInt));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayByte, nullArrayShort));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayByte, nullArrayChar));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((byte[])emptyArrayByte, nullArrayByte));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayByte, nullArrayDouble));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayByte, nullArrayFloat));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayDouble, nullArrayObject));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayDouble, nullArrayBoolean));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayDouble, nullArrayLong));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayDouble, nullArrayInt));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayDouble, nullArrayShort));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayDouble, nullArrayChar));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayDouble, nullArrayByte));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((double[])emptyArrayDouble, nullArrayDouble));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayDouble, nullArrayFloat));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayFloat, nullArrayObject));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayFloat, nullArrayBoolean));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayFloat, nullArrayLong));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayFloat, nullArrayInt));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayFloat, nullArrayShort));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayFloat, nullArrayChar));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayFloat, nullArrayByte));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayFloat, nullArrayDouble));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((float[])emptyArrayFloat, nullArrayFloat));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object[])emptyArrayObject, (Object[])emptyArrayObject));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayObject, (Object)emptyArrayBoolean));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayObject, (Object)emptyArrayLong));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayObject, (Object)emptyArrayInt));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayObject, (Object)emptyArrayShort));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayObject, (Object)emptyArrayChar));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayObject, (Object)emptyArrayByte));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayObject, (Object)emptyArrayDouble));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayObject, (Object)emptyArrayFloat));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayBoolean, (Object)emptyArrayObject));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((boolean[])emptyArrayBoolean, (boolean[])emptyArrayBoolean));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayBoolean, (Object)emptyArrayLong));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayBoolean, (Object)emptyArrayInt));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayBoolean, (Object)emptyArrayShort));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayBoolean, (Object)emptyArrayChar));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayBoolean, (Object)emptyArrayByte));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayBoolean, (Object)emptyArrayDouble));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayBoolean, (Object)emptyArrayFloat));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayLong, (Object)emptyArrayObject));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayLong, (Object)emptyArrayBoolean));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((long[])emptyArrayLong, (long[])emptyArrayLong));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayLong, (Object)emptyArrayInt));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayLong, (Object)emptyArrayShort));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayLong, (Object)emptyArrayChar));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayLong, (Object)emptyArrayByte));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayLong, (Object)emptyArrayDouble));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayLong, (Object)emptyArrayFloat));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayInt, (Object)emptyArrayObject));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayInt, (Object)emptyArrayBoolean));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayInt, (Object)emptyArrayLong));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((int[])emptyArrayInt, (int[])emptyArrayInt));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayInt, (Object)emptyArrayShort));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayInt, (Object)emptyArrayChar));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayInt, (Object)emptyArrayByte));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayInt, (Object)emptyArrayDouble));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayInt, (Object)emptyArrayFloat));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayShort, (Object)emptyArrayObject));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayShort, (Object)emptyArrayBoolean));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayShort, (Object)emptyArrayLong));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayShort, (Object)emptyArrayInt));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((short[])emptyArrayShort, (short[])emptyArrayShort));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayShort, (Object)emptyArrayChar));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayShort, (Object)emptyArrayByte));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayShort, (Object)emptyArrayDouble));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayShort, (Object)emptyArrayFloat));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayChar, (Object)emptyArrayObject));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayChar, (Object)emptyArrayBoolean));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayChar, (Object)emptyArrayLong));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayChar, (Object)emptyArrayInt));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayChar, (Object)emptyArrayShort));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((char[])emptyArrayChar, (char[])emptyArrayChar));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayChar, (Object)emptyArrayByte));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayChar, (Object)emptyArrayDouble));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayChar, (Object)emptyArrayFloat));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayByte, (Object)emptyArrayObject));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayByte, (Object)emptyArrayBoolean));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayByte, (Object)emptyArrayLong));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayByte, (Object)emptyArrayInt));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayByte, (Object)emptyArrayShort));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayByte, (Object)emptyArrayChar));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((byte[])emptyArrayByte, (byte[])emptyArrayByte));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayByte, (Object)emptyArrayDouble));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayByte, (Object)emptyArrayFloat));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayDouble, (Object)emptyArrayObject));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayDouble, (Object)emptyArrayBoolean));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayDouble, (Object)emptyArrayLong));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayDouble, (Object)emptyArrayInt));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayDouble, (Object)emptyArrayShort));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayDouble, (Object)emptyArrayChar));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayDouble, (Object)emptyArrayByte));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((double[])emptyArrayDouble, (double[])emptyArrayDouble));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayDouble, (Object)emptyArrayFloat));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayFloat, (Object)emptyArrayObject));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayFloat, (Object)emptyArrayBoolean));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayFloat, (Object)emptyArrayLong));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayFloat, (Object)emptyArrayInt));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayFloat, (Object)emptyArrayShort));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayFloat, (Object)emptyArrayChar));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayFloat, (Object)emptyArrayByte));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)emptyArrayFloat, (Object)emptyArrayDouble));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((float[])emptyArrayFloat, (float[])emptyArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object[])emptyArrayObject, (Object[])oneArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayObject, (Object)oneArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayObject, (Object)oneArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayObject, (Object)oneArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayObject, (Object)oneArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayObject, (Object)oneArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayObject, (Object)oneArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayObject, (Object)oneArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayObject, (Object)oneArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayBoolean, (Object)oneArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((boolean[])emptyArrayBoolean, (boolean[])oneArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayBoolean, (Object)oneArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayBoolean, (Object)oneArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayBoolean, (Object)oneArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayBoolean, (Object)oneArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayBoolean, (Object)oneArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayBoolean, (Object)oneArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayBoolean, (Object)oneArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayLong, (Object)oneArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayLong, (Object)oneArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((long[])emptyArrayLong, (long[])oneArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayLong, (Object)oneArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayLong, (Object)oneArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayLong, (Object)oneArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayLong, (Object)oneArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayLong, (Object)oneArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayLong, (Object)oneArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayInt, (Object)oneArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayInt, (Object)oneArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayInt, (Object)oneArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((int[])emptyArrayInt, (int[])oneArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayInt, (Object)oneArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayInt, (Object)oneArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayInt, (Object)oneArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayInt, (Object)oneArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayInt, (Object)oneArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayShort, (Object)oneArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayShort, (Object)oneArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayShort, (Object)oneArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayShort, (Object)oneArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((short[])emptyArrayShort, (short[])oneArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayShort, (Object)oneArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayShort, (Object)oneArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayShort, (Object)oneArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayShort, (Object)oneArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayChar, (Object)oneArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayChar, (Object)oneArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayChar, (Object)oneArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayChar, (Object)oneArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayChar, (Object)oneArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((char[])emptyArrayChar, (char[])oneArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayChar, (Object)oneArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayChar, (Object)oneArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayChar, (Object)oneArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayByte, (Object)oneArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayByte, (Object)oneArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayByte, (Object)oneArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayByte, (Object)oneArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayByte, (Object)oneArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayByte, (Object)oneArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((byte[])emptyArrayByte, (byte[])oneArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayByte, (Object)oneArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayByte, (Object)oneArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayDouble, (Object)oneArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayDouble, (Object)oneArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayDouble, (Object)oneArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayDouble, (Object)oneArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayDouble, (Object)oneArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayDouble, (Object)oneArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayDouble, (Object)oneArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((double[])emptyArrayDouble, (double[])oneArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayDouble, (Object)oneArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayFloat, (Object)oneArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayFloat, (Object)oneArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayFloat, (Object)oneArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayFloat, (Object)oneArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayFloat, (Object)oneArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayFloat, (Object)oneArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayFloat, (Object)oneArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayFloat, (Object)oneArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((float[])emptyArrayFloat, (float[])oneArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object[])emptyArrayObject, (Object[])twoArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayObject, (Object)twoArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayObject, (Object)twoArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayObject, (Object)twoArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayObject, (Object)twoArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayObject, (Object)twoArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayObject, (Object)twoArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayObject, (Object)twoArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayObject, (Object)twoArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayBoolean, (Object)twoArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((boolean[])emptyArrayBoolean, (boolean[])twoArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayBoolean, (Object)twoArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayBoolean, (Object)twoArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayBoolean, (Object)twoArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayBoolean, (Object)twoArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayBoolean, (Object)twoArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayBoolean, (Object)twoArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayBoolean, (Object)twoArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayLong, (Object)twoArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayLong, (Object)twoArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((long[])emptyArrayLong, (long[])twoArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayLong, (Object)twoArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayLong, (Object)twoArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayLong, (Object)twoArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayLong, (Object)twoArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayLong, (Object)twoArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayLong, (Object)twoArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayInt, (Object)twoArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayInt, (Object)twoArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayInt, (Object)twoArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((int[])emptyArrayInt, (int[])twoArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayInt, (Object)twoArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayInt, (Object)twoArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayInt, (Object)twoArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayInt, (Object)twoArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayInt, (Object)twoArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayShort, (Object)twoArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayShort, (Object)twoArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayShort, (Object)twoArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayShort, (Object)twoArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((short[])emptyArrayShort, (short[])twoArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayShort, (Object)twoArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayShort, (Object)twoArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayShort, (Object)twoArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayShort, (Object)twoArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayChar, (Object)twoArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayChar, (Object)twoArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayChar, (Object)twoArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayChar, (Object)twoArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayChar, (Object)twoArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((char[])emptyArrayChar, (char[])twoArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayChar, (Object)twoArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayChar, (Object)twoArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayChar, (Object)twoArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayByte, (Object)twoArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayByte, (Object)twoArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayByte, (Object)twoArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayByte, (Object)twoArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayByte, (Object)twoArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayByte, (Object)twoArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((byte[])emptyArrayByte, (byte[])twoArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayByte, (Object)twoArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayByte, (Object)twoArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayDouble, (Object)twoArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayDouble, (Object)twoArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayDouble, (Object)twoArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayDouble, (Object)twoArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayDouble, (Object)twoArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayDouble, (Object)twoArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayDouble, (Object)twoArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((double[])emptyArrayDouble, (double[])twoArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayDouble, (Object)twoArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayFloat, (Object)twoArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayFloat, (Object)twoArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayFloat, (Object)twoArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayFloat, (Object)twoArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayFloat, (Object)twoArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayFloat, (Object)twoArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayFloat, (Object)twoArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)emptyArrayFloat, (Object)twoArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((float[])emptyArrayFloat, (float[])twoArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object[])oneArrayObject, nullArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayObject, nullArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayObject, nullArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayObject, nullArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayObject, nullArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayObject, nullArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayObject, nullArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayObject, nullArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayObject, nullArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayBoolean, nullArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((boolean[])oneArrayBoolean, nullArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayBoolean, nullArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayBoolean, nullArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayBoolean, nullArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayBoolean, nullArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayBoolean, nullArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayBoolean, nullArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayBoolean, nullArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayLong, nullArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayLong, nullArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((long[])oneArrayLong, nullArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayLong, nullArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayLong, nullArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayLong, nullArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayLong, nullArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayLong, nullArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayLong, nullArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayInt, nullArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayInt, nullArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayInt, nullArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((int[])oneArrayInt, nullArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayInt, nullArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayInt, nullArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayInt, nullArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayInt, nullArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayInt, nullArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayShort, nullArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayShort, nullArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayShort, nullArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayShort, nullArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((short[])oneArrayShort, nullArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayShort, nullArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayShort, nullArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayShort, nullArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayShort, nullArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayChar, nullArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayChar, nullArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayChar, nullArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayChar, nullArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayChar, nullArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((char[])oneArrayChar, nullArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayChar, nullArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayChar, nullArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayChar, nullArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayByte, nullArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayByte, nullArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayByte, nullArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayByte, nullArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayByte, nullArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayByte, nullArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((byte[])oneArrayByte, nullArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayByte, nullArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayByte, nullArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayDouble, nullArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayDouble, nullArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayDouble, nullArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayDouble, nullArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayDouble, nullArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayDouble, nullArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayDouble, nullArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((double[])oneArrayDouble, nullArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayDouble, nullArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayFloat, nullArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayFloat, nullArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayFloat, nullArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayFloat, nullArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayFloat, nullArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayFloat, nullArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayFloat, nullArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayFloat, nullArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((float[])oneArrayFloat, nullArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object[])oneArrayObject, (Object[])emptyArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayObject, (Object)emptyArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayObject, (Object)emptyArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayObject, (Object)emptyArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayObject, (Object)emptyArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayObject, (Object)emptyArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayObject, (Object)emptyArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayObject, (Object)emptyArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayObject, (Object)emptyArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayBoolean, (Object)emptyArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((boolean[])oneArrayBoolean, (boolean[])emptyArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayBoolean, (Object)emptyArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayBoolean, (Object)emptyArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayBoolean, (Object)emptyArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayBoolean, (Object)emptyArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayBoolean, (Object)emptyArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayBoolean, (Object)emptyArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayBoolean, (Object)emptyArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayLong, (Object)emptyArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayLong, (Object)emptyArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((long[])oneArrayLong, (long[])emptyArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayLong, (Object)emptyArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayLong, (Object)emptyArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayLong, (Object)emptyArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayLong, (Object)emptyArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayLong, (Object)emptyArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayLong, (Object)emptyArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayInt, (Object)emptyArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayInt, (Object)emptyArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayInt, (Object)emptyArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((int[])oneArrayInt, (int[])emptyArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayInt, (Object)emptyArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayInt, (Object)emptyArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayInt, (Object)emptyArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayInt, (Object)emptyArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayInt, (Object)emptyArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayShort, (Object)emptyArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayShort, (Object)emptyArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayShort, (Object)emptyArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayShort, (Object)emptyArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((short[])oneArrayShort, (short[])emptyArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayShort, (Object)emptyArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayShort, (Object)emptyArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayShort, (Object)emptyArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayShort, (Object)emptyArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayChar, (Object)emptyArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayChar, (Object)emptyArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayChar, (Object)emptyArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayChar, (Object)emptyArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayChar, (Object)emptyArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((char[])oneArrayChar, (char[])emptyArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayChar, (Object)emptyArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayChar, (Object)emptyArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayChar, (Object)emptyArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayByte, (Object)emptyArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayByte, (Object)emptyArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayByte, (Object)emptyArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayByte, (Object)emptyArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayByte, (Object)emptyArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayByte, (Object)emptyArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((byte[])oneArrayByte, (byte[])emptyArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayByte, (Object)emptyArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayByte, (Object)emptyArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayDouble, (Object)emptyArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayDouble, (Object)emptyArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayDouble, (Object)emptyArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayDouble, (Object)emptyArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayDouble, (Object)emptyArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayDouble, (Object)emptyArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayDouble, (Object)emptyArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((double[])oneArrayDouble, (double[])emptyArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayDouble, (Object)emptyArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayFloat, (Object)emptyArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayFloat, (Object)emptyArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayFloat, (Object)emptyArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayFloat, (Object)emptyArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayFloat, (Object)emptyArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayFloat, (Object)emptyArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayFloat, (Object)emptyArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayFloat, (Object)emptyArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((float[])oneArrayFloat, (float[])emptyArrayFloat));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object[])oneArrayObject, (Object[])oneArrayObject));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayObject, (Object)oneArrayBoolean));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayObject, (Object)oneArrayLong));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayObject, (Object)oneArrayInt));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayObject, (Object)oneArrayShort));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayObject, (Object)oneArrayChar));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayObject, (Object)oneArrayByte));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayObject, (Object)oneArrayDouble));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayObject, (Object)oneArrayFloat));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayBoolean, (Object)oneArrayObject));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((boolean[])oneArrayBoolean, (boolean[])oneArrayBoolean));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayBoolean, (Object)oneArrayLong));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayBoolean, (Object)oneArrayInt));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayBoolean, (Object)oneArrayShort));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayBoolean, (Object)oneArrayChar));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayBoolean, (Object)oneArrayByte));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayBoolean, (Object)oneArrayDouble));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayBoolean, (Object)oneArrayFloat));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayLong, (Object)oneArrayObject));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayLong, (Object)oneArrayBoolean));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((long[])oneArrayLong, (long[])oneArrayLong));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayLong, (Object)oneArrayInt));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayLong, (Object)oneArrayShort));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayLong, (Object)oneArrayChar));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayLong, (Object)oneArrayByte));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayLong, (Object)oneArrayDouble));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayLong, (Object)oneArrayFloat));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayInt, (Object)oneArrayObject));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayInt, (Object)oneArrayBoolean));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayInt, (Object)oneArrayLong));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((int[])oneArrayInt, (int[])oneArrayInt));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayInt, (Object)oneArrayShort));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayInt, (Object)oneArrayChar));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayInt, (Object)oneArrayByte));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayInt, (Object)oneArrayDouble));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayInt, (Object)oneArrayFloat));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayShort, (Object)oneArrayObject));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayShort, (Object)oneArrayBoolean));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayShort, (Object)oneArrayLong));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayShort, (Object)oneArrayInt));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((short[])oneArrayShort, (short[])oneArrayShort));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayShort, (Object)oneArrayChar));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayShort, (Object)oneArrayByte));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayShort, (Object)oneArrayDouble));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayShort, (Object)oneArrayFloat));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayChar, (Object)oneArrayObject));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayChar, (Object)oneArrayBoolean));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayChar, (Object)oneArrayLong));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayChar, (Object)oneArrayInt));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayChar, (Object)oneArrayShort));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((char[])oneArrayChar, (char[])oneArrayChar));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayChar, (Object)oneArrayByte));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayChar, (Object)oneArrayDouble));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayChar, (Object)oneArrayFloat));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayByte, (Object)oneArrayObject));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayByte, (Object)oneArrayBoolean));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayByte, (Object)oneArrayLong));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayByte, (Object)oneArrayInt));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayByte, (Object)oneArrayShort));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayByte, (Object)oneArrayChar));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((byte[])oneArrayByte, (byte[])oneArrayByte));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayByte, (Object)oneArrayDouble));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayByte, (Object)oneArrayFloat));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayDouble, (Object)oneArrayObject));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayDouble, (Object)oneArrayBoolean));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayDouble, (Object)oneArrayLong));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayDouble, (Object)oneArrayInt));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayDouble, (Object)oneArrayShort));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayDouble, (Object)oneArrayChar));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayDouble, (Object)oneArrayByte));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((double[])oneArrayDouble, (double[])oneArrayDouble));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayDouble, (Object)oneArrayFloat));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayFloat, (Object)oneArrayObject));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayFloat, (Object)oneArrayBoolean));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayFloat, (Object)oneArrayLong));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayFloat, (Object)oneArrayInt));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayFloat, (Object)oneArrayShort));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayFloat, (Object)oneArrayChar));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayFloat, (Object)oneArrayByte));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)oneArrayFloat, (Object)oneArrayDouble));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((float[])oneArrayFloat, (float[])oneArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object[])oneArrayObject, (Object[])twoArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayObject, (Object)twoArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayObject, (Object)twoArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayObject, (Object)twoArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayObject, (Object)twoArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayObject, (Object)twoArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayObject, (Object)twoArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayObject, (Object)twoArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayObject, (Object)twoArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayBoolean, (Object)twoArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((boolean[])oneArrayBoolean, (boolean[])twoArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayBoolean, (Object)twoArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayBoolean, (Object)twoArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayBoolean, (Object)twoArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayBoolean, (Object)twoArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayBoolean, (Object)twoArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayBoolean, (Object)twoArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayBoolean, (Object)twoArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayLong, (Object)twoArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayLong, (Object)twoArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((long[])oneArrayLong, (long[])twoArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayLong, (Object)twoArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayLong, (Object)twoArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayLong, (Object)twoArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayLong, (Object)twoArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayLong, (Object)twoArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayLong, (Object)twoArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayInt, (Object)twoArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayInt, (Object)twoArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayInt, (Object)twoArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((int[])oneArrayInt, (int[])twoArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayInt, (Object)twoArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayInt, (Object)twoArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayInt, (Object)twoArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayInt, (Object)twoArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayInt, (Object)twoArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayShort, (Object)twoArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayShort, (Object)twoArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayShort, (Object)twoArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayShort, (Object)twoArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((short[])oneArrayShort, (short[])twoArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayShort, (Object)twoArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayShort, (Object)twoArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayShort, (Object)twoArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayShort, (Object)twoArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayChar, (Object)twoArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayChar, (Object)twoArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayChar, (Object)twoArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayChar, (Object)twoArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayChar, (Object)twoArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((char[])oneArrayChar, (char[])twoArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayChar, (Object)twoArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayChar, (Object)twoArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayChar, (Object)twoArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayByte, (Object)twoArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayByte, (Object)twoArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayByte, (Object)twoArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayByte, (Object)twoArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayByte, (Object)twoArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayByte, (Object)twoArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((byte[])oneArrayByte, (byte[])twoArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayByte, (Object)twoArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayByte, (Object)twoArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayDouble, (Object)twoArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayDouble, (Object)twoArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayDouble, (Object)twoArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayDouble, (Object)twoArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayDouble, (Object)twoArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayDouble, (Object)twoArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayDouble, (Object)twoArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((double[])oneArrayDouble, (double[])twoArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayDouble, (Object)twoArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayFloat, (Object)twoArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayFloat, (Object)twoArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayFloat, (Object)twoArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayFloat, (Object)twoArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayFloat, (Object)twoArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayFloat, (Object)twoArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayFloat, (Object)twoArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)oneArrayFloat, (Object)twoArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((float[])oneArrayFloat, (float[])twoArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object[])twoArrayObject, nullArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayObject, nullArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayObject, nullArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayObject, nullArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayObject, nullArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayObject, nullArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayObject, nullArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayObject, nullArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayObject, nullArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayBoolean, nullArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((boolean[])twoArrayBoolean, nullArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayBoolean, nullArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayBoolean, nullArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayBoolean, nullArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayBoolean, nullArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayBoolean, nullArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayBoolean, nullArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayBoolean, nullArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayLong, nullArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayLong, nullArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((long[])twoArrayLong, nullArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayLong, nullArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayLong, nullArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayLong, nullArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayLong, nullArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayLong, nullArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayLong, nullArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayInt, nullArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayInt, nullArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayInt, nullArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((int[])twoArrayInt, nullArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayInt, nullArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayInt, nullArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayInt, nullArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayInt, nullArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayInt, nullArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayShort, nullArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayShort, nullArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayShort, nullArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayShort, nullArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((short[])twoArrayShort, nullArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayShort, nullArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayShort, nullArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayShort, nullArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayShort, nullArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayChar, nullArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayChar, nullArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayChar, nullArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayChar, nullArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayChar, nullArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((char[])twoArrayChar, nullArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayChar, nullArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayChar, nullArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayChar, nullArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayByte, nullArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayByte, nullArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayByte, nullArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayByte, nullArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayByte, nullArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayByte, nullArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((byte[])twoArrayByte, nullArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayByte, nullArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayByte, nullArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayDouble, nullArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayDouble, nullArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayDouble, nullArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayDouble, nullArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayDouble, nullArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayDouble, nullArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayDouble, nullArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((double[])twoArrayDouble, nullArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayDouble, nullArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayFloat, nullArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayFloat, nullArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayFloat, nullArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayFloat, nullArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayFloat, nullArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayFloat, nullArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayFloat, nullArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayFloat, nullArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((float[])twoArrayFloat, nullArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object[])twoArrayObject, (Object[])emptyArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayObject, (Object)emptyArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayObject, (Object)emptyArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayObject, (Object)emptyArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayObject, (Object)emptyArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayObject, (Object)emptyArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayObject, (Object)emptyArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayObject, (Object)emptyArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayObject, (Object)emptyArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayBoolean, (Object)emptyArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((boolean[])twoArrayBoolean, (boolean[])emptyArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayBoolean, (Object)emptyArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayBoolean, (Object)emptyArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayBoolean, (Object)emptyArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayBoolean, (Object)emptyArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayBoolean, (Object)emptyArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayBoolean, (Object)emptyArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayBoolean, (Object)emptyArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayLong, (Object)emptyArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayLong, (Object)emptyArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((long[])twoArrayLong, (long[])emptyArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayLong, (Object)emptyArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayLong, (Object)emptyArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayLong, (Object)emptyArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayLong, (Object)emptyArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayLong, (Object)emptyArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayLong, (Object)emptyArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayInt, (Object)emptyArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayInt, (Object)emptyArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayInt, (Object)emptyArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((int[])twoArrayInt, (int[])emptyArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayInt, (Object)emptyArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayInt, (Object)emptyArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayInt, (Object)emptyArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayInt, (Object)emptyArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayInt, (Object)emptyArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayShort, (Object)emptyArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayShort, (Object)emptyArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayShort, (Object)emptyArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayShort, (Object)emptyArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((short[])twoArrayShort, (short[])emptyArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayShort, (Object)emptyArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayShort, (Object)emptyArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayShort, (Object)emptyArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayShort, (Object)emptyArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayChar, (Object)emptyArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayChar, (Object)emptyArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayChar, (Object)emptyArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayChar, (Object)emptyArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayChar, (Object)emptyArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((char[])twoArrayChar, (char[])emptyArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayChar, (Object)emptyArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayChar, (Object)emptyArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayChar, (Object)emptyArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayByte, (Object)emptyArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayByte, (Object)emptyArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayByte, (Object)emptyArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayByte, (Object)emptyArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayByte, (Object)emptyArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayByte, (Object)emptyArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((byte[])twoArrayByte, (byte[])emptyArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayByte, (Object)emptyArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayByte, (Object)emptyArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayDouble, (Object)emptyArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayDouble, (Object)emptyArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayDouble, (Object)emptyArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayDouble, (Object)emptyArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayDouble, (Object)emptyArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayDouble, (Object)emptyArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayDouble, (Object)emptyArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((double[])twoArrayDouble, (double[])emptyArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayDouble, (Object)emptyArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayFloat, (Object)emptyArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayFloat, (Object)emptyArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayFloat, (Object)emptyArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayFloat, (Object)emptyArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayFloat, (Object)emptyArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayFloat, (Object)emptyArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayFloat, (Object)emptyArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayFloat, (Object)emptyArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((float[])twoArrayFloat, (float[])emptyArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object[])twoArrayObject, (Object[])oneArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayObject, (Object)oneArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayObject, (Object)oneArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayObject, (Object)oneArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayObject, (Object)oneArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayObject, (Object)oneArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayObject, (Object)oneArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayObject, (Object)oneArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayObject, (Object)oneArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayBoolean, (Object)oneArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((boolean[])twoArrayBoolean, (boolean[])oneArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayBoolean, (Object)oneArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayBoolean, (Object)oneArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayBoolean, (Object)oneArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayBoolean, (Object)oneArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayBoolean, (Object)oneArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayBoolean, (Object)oneArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayBoolean, (Object)oneArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayLong, (Object)oneArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayLong, (Object)oneArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((long[])twoArrayLong, (long[])oneArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayLong, (Object)oneArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayLong, (Object)oneArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayLong, (Object)oneArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayLong, (Object)oneArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayLong, (Object)oneArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayLong, (Object)oneArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayInt, (Object)oneArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayInt, (Object)oneArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayInt, (Object)oneArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((int[])twoArrayInt, (int[])oneArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayInt, (Object)oneArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayInt, (Object)oneArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayInt, (Object)oneArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayInt, (Object)oneArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayInt, (Object)oneArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayShort, (Object)oneArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayShort, (Object)oneArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayShort, (Object)oneArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayShort, (Object)oneArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((short[])twoArrayShort, (short[])oneArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayShort, (Object)oneArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayShort, (Object)oneArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayShort, (Object)oneArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayShort, (Object)oneArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayChar, (Object)oneArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayChar, (Object)oneArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayChar, (Object)oneArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayChar, (Object)oneArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayChar, (Object)oneArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((char[])twoArrayChar, (char[])oneArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayChar, (Object)oneArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayChar, (Object)oneArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayChar, (Object)oneArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayByte, (Object)oneArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayByte, (Object)oneArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayByte, (Object)oneArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayByte, (Object)oneArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayByte, (Object)oneArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayByte, (Object)oneArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((byte[])twoArrayByte, (byte[])oneArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayByte, (Object)oneArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayByte, (Object)oneArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayDouble, (Object)oneArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayDouble, (Object)oneArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayDouble, (Object)oneArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayDouble, (Object)oneArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayDouble, (Object)oneArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayDouble, (Object)oneArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayDouble, (Object)oneArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((double[])twoArrayDouble, (double[])oneArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayDouble, (Object)oneArrayFloat));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayFloat, (Object)oneArrayObject));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayFloat, (Object)oneArrayBoolean));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayFloat, (Object)oneArrayLong));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayFloat, (Object)oneArrayInt));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayFloat, (Object)oneArrayShort));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayFloat, (Object)oneArrayChar));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayFloat, (Object)oneArrayByte));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((Object)twoArrayFloat, (Object)oneArrayDouble));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((float[])twoArrayFloat, (float[])oneArrayFloat));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object[])twoArrayObject, (Object[])twoArrayObject));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayObject, (Object)twoArrayBoolean));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayObject, (Object)twoArrayLong));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayObject, (Object)twoArrayInt));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayObject, (Object)twoArrayShort));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayObject, (Object)twoArrayChar));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayObject, (Object)twoArrayByte));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayObject, (Object)twoArrayDouble));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayObject, (Object)twoArrayFloat));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayBoolean, (Object)twoArrayObject));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((boolean[])twoArrayBoolean, (boolean[])twoArrayBoolean));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayBoolean, (Object)twoArrayLong));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayBoolean, (Object)twoArrayInt));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayBoolean, (Object)twoArrayShort));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayBoolean, (Object)twoArrayChar));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayBoolean, (Object)twoArrayByte));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayBoolean, (Object)twoArrayDouble));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayBoolean, (Object)twoArrayFloat));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayLong, (Object)twoArrayObject));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayLong, (Object)twoArrayBoolean));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((long[])twoArrayLong, (long[])twoArrayLong));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayLong, (Object)twoArrayInt));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayLong, (Object)twoArrayShort));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayLong, (Object)twoArrayChar));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayLong, (Object)twoArrayByte));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayLong, (Object)twoArrayDouble));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayLong, (Object)twoArrayFloat));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayInt, (Object)twoArrayObject));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayInt, (Object)twoArrayBoolean));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayInt, (Object)twoArrayLong));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((int[])twoArrayInt, (int[])twoArrayInt));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayInt, (Object)twoArrayShort));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayInt, (Object)twoArrayChar));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayInt, (Object)twoArrayByte));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayInt, (Object)twoArrayDouble));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayInt, (Object)twoArrayFloat));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayShort, (Object)twoArrayObject));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayShort, (Object)twoArrayBoolean));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayShort, (Object)twoArrayLong));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayShort, (Object)twoArrayInt));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((short[])twoArrayShort, (short[])twoArrayShort));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayShort, (Object)twoArrayChar));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayShort, (Object)twoArrayByte));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayShort, (Object)twoArrayDouble));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayShort, (Object)twoArrayFloat));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayChar, (Object)twoArrayObject));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayChar, (Object)twoArrayBoolean));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayChar, (Object)twoArrayLong));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayChar, (Object)twoArrayInt));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayChar, (Object)twoArrayShort));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((char[])twoArrayChar, (char[])twoArrayChar));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayChar, (Object)twoArrayByte));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayChar, (Object)twoArrayDouble));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayChar, (Object)twoArrayFloat));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayByte, (Object)twoArrayObject));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayByte, (Object)twoArrayBoolean));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayByte, (Object)twoArrayLong));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayByte, (Object)twoArrayInt));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayByte, (Object)twoArrayShort));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayByte, (Object)twoArrayChar));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((byte[])twoArrayByte, (byte[])twoArrayByte));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayByte, (Object)twoArrayDouble));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayByte, (Object)twoArrayFloat));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayDouble, (Object)twoArrayObject));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayDouble, (Object)twoArrayBoolean));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayDouble, (Object)twoArrayLong));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayDouble, (Object)twoArrayInt));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayDouble, (Object)twoArrayShort));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayDouble, (Object)twoArrayChar));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayDouble, (Object)twoArrayByte));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((double[])twoArrayDouble, (double[])twoArrayDouble));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayDouble, (Object)twoArrayFloat));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayFloat, (Object)twoArrayObject));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayFloat, (Object)twoArrayBoolean));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayFloat, (Object)twoArrayLong));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayFloat, (Object)twoArrayInt));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayFloat, (Object)twoArrayShort));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayFloat, (Object)twoArrayChar));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayFloat, (Object)twoArrayByte));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((Object)twoArrayFloat, (Object)twoArrayDouble));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((float[])twoArrayFloat, (float[])twoArrayFloat));
    }

    @Test
    public void testSameLengthBoolean() {
        boolean[] nullArray = null;
        boolean[] emptyArray = new boolean[]{};
        boolean[] oneArray = new boolean[]{true};
        boolean[] twoArray = new boolean[]{true, false};
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArray, nullArray));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArray, (boolean[])emptyArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArray, (boolean[])oneArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArray, (boolean[])twoArray));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((boolean[])emptyArray, nullArray));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((boolean[])emptyArray, (boolean[])emptyArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((boolean[])emptyArray, (boolean[])oneArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((boolean[])emptyArray, (boolean[])twoArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((boolean[])oneArray, nullArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((boolean[])oneArray, (boolean[])emptyArray));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((boolean[])oneArray, (boolean[])oneArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((boolean[])oneArray, (boolean[])twoArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((boolean[])twoArray, nullArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((boolean[])twoArray, (boolean[])emptyArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((boolean[])twoArray, (boolean[])oneArray));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((boolean[])twoArray, (boolean[])twoArray));
    }

    @Test
    public void testSameLengthByte() {
        byte[] nullArray = null;
        byte[] emptyArray = new byte[]{};
        byte[] oneArray = new byte[]{3};
        byte[] twoArray = new byte[]{4, 6};
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArray, nullArray));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArray, (byte[])emptyArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArray, (byte[])oneArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArray, (byte[])twoArray));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((byte[])emptyArray, nullArray));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((byte[])emptyArray, (byte[])emptyArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((byte[])emptyArray, (byte[])oneArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((byte[])emptyArray, (byte[])twoArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((byte[])oneArray, nullArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((byte[])oneArray, (byte[])emptyArray));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((byte[])oneArray, (byte[])oneArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((byte[])oneArray, (byte[])twoArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((byte[])twoArray, nullArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((byte[])twoArray, (byte[])emptyArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((byte[])twoArray, (byte[])oneArray));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((byte[])twoArray, (byte[])twoArray));
    }

    @Test
    public void testSameLengthChar() {
        char[] nullArray = null;
        char[] emptyArray = new char[]{};
        char[] oneArray = new char[]{'f'};
        char[] twoArray = new char[]{'d', 't'};
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArray, nullArray));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArray, (char[])emptyArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArray, (char[])oneArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArray, (char[])twoArray));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((char[])emptyArray, nullArray));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((char[])emptyArray, (char[])emptyArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((char[])emptyArray, (char[])oneArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((char[])emptyArray, (char[])twoArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((char[])oneArray, nullArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((char[])oneArray, (char[])emptyArray));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((char[])oneArray, (char[])oneArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((char[])oneArray, (char[])twoArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((char[])twoArray, nullArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((char[])twoArray, (char[])emptyArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((char[])twoArray, (char[])oneArray));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((char[])twoArray, (char[])twoArray));
    }

    @Test
    public void testSameLengthDouble() {
        double[] nullArray = null;
        double[] emptyArray = new double[]{};
        double[] oneArray = new double[]{1.3};
        double[] twoArray = new double[]{4.5, 6.3};
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArray, nullArray));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArray, (double[])emptyArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArray, (double[])oneArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArray, (double[])twoArray));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((double[])emptyArray, nullArray));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((double[])emptyArray, (double[])emptyArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((double[])emptyArray, (double[])oneArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((double[])emptyArray, (double[])twoArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((double[])oneArray, nullArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((double[])oneArray, (double[])emptyArray));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((double[])oneArray, (double[])oneArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((double[])oneArray, (double[])twoArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((double[])twoArray, nullArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((double[])twoArray, (double[])emptyArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((double[])twoArray, (double[])oneArray));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((double[])twoArray, (double[])twoArray));
    }

    @Test
    public void testSameLengthFloat() {
        float[] nullArray = null;
        float[] emptyArray = new float[]{};
        float[] oneArray = new float[]{2.5f};
        float[] twoArray = new float[]{6.4f, 5.8f};
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArray, nullArray));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArray, (float[])emptyArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArray, (float[])oneArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArray, (float[])twoArray));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((float[])emptyArray, nullArray));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((float[])emptyArray, (float[])emptyArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((float[])emptyArray, (float[])oneArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((float[])emptyArray, (float[])twoArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((float[])oneArray, nullArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((float[])oneArray, (float[])emptyArray));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((float[])oneArray, (float[])oneArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((float[])oneArray, (float[])twoArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((float[])twoArray, nullArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((float[])twoArray, (float[])emptyArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((float[])twoArray, (float[])oneArray));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((float[])twoArray, (float[])twoArray));
    }

    @Test
    public void testSameLengthInt() {
        int[] nullArray = null;
        int[] emptyArray = new int[]{};
        int[] oneArray = new int[]{4};
        int[] twoArray = new int[]{5, 7};
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArray, nullArray));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArray, (int[])emptyArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArray, (int[])oneArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArray, (int[])twoArray));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((int[])emptyArray, nullArray));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((int[])emptyArray, (int[])emptyArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((int[])emptyArray, (int[])oneArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((int[])emptyArray, (int[])twoArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((int[])oneArray, nullArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((int[])oneArray, (int[])emptyArray));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((int[])oneArray, (int[])oneArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((int[])oneArray, (int[])twoArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((int[])twoArray, nullArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((int[])twoArray, (int[])emptyArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((int[])twoArray, (int[])oneArray));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((int[])twoArray, (int[])twoArray));
    }

    @Test
    public void testSameLengthLong() {
        long[] nullArray = null;
        long[] emptyArray = new long[]{};
        long[] oneArray = new long[]{0L};
        long[] twoArray = new long[]{0L, 76L};
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArray, nullArray));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArray, (long[])emptyArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArray, (long[])oneArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArray, (long[])twoArray));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((long[])emptyArray, nullArray));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((long[])emptyArray, (long[])emptyArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((long[])emptyArray, (long[])oneArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((long[])emptyArray, (long[])twoArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((long[])oneArray, nullArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((long[])oneArray, (long[])emptyArray));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((long[])oneArray, (long[])oneArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((long[])oneArray, (long[])twoArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((long[])twoArray, nullArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((long[])twoArray, (long[])emptyArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((long[])twoArray, (long[])oneArray));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((long[])twoArray, (long[])twoArray));
    }

    @Test
    public void testSameLengthShort() {
        short[] nullArray = null;
        short[] emptyArray = new short[]{};
        short[] oneArray = new short[]{4};
        short[] twoArray = new short[]{6, 8};
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArray, nullArray));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength(nullArray, (short[])emptyArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArray, (short[])oneArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength(nullArray, (short[])twoArray));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((short[])emptyArray, nullArray));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((short[])emptyArray, (short[])emptyArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((short[])emptyArray, (short[])oneArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((short[])emptyArray, (short[])twoArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((short[])oneArray, nullArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((short[])oneArray, (short[])emptyArray));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((short[])oneArray, (short[])oneArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((short[])oneArray, (short[])twoArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((short[])twoArray, nullArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((short[])twoArray, (short[])emptyArray));
        Assertions.assertFalse((boolean)ArrayUtils.isSameLength((short[])twoArray, (short[])oneArray));
        Assertions.assertTrue((boolean)ArrayUtils.isSameLength((short[])twoArray, (short[])twoArray));
    }

    @Test
    public void testSameType() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> ArrayUtils.isSameType(null, null));
        Assertions.assertThrows(IllegalArgumentException.class, () -> ArrayUtils.isSameType(null, (Object)new Object[0]));
        Assertions.assertThrows(IllegalArgumentException.class, () -> ArrayUtils.isSameType((Object)new Object[0], null));
        Assertions.assertTrue((boolean)ArrayUtils.isSameType((Object)new Object[0], (Object)new Object[0]));
        Assertions.assertFalse((boolean)ArrayUtils.isSameType((Object)new String[0], (Object)new Object[0]));
        Assertions.assertTrue((boolean)ArrayUtils.isSameType((Object)new String[0][0], (Object)new String[0][0]));
        Assertions.assertFalse((boolean)ArrayUtils.isSameType((Object)new String[0], (Object)new String[0][0]));
        Assertions.assertFalse((boolean)ArrayUtils.isSameType((Object)new String[0][0], (Object)new String[0]));
    }

    @Test
    public void testShiftAllByte() {
        byte[] array = new byte[]{1, 2, 3, 4};
        ArrayUtils.shift((byte[])array, (int)4);
        Assertions.assertEquals((int)1, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)3, (int)array[2]);
        Assertions.assertEquals((int)4, (int)array[3]);
        ArrayUtils.shift((byte[])array, (int)-4);
        Assertions.assertEquals((int)1, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)3, (int)array[2]);
        Assertions.assertEquals((int)4, (int)array[3]);
    }

    @Test
    public void testShiftAllChar() {
        char[] array = new char[]{'\u0001', '\u0002', '\u0003', '\u0004'};
        ArrayUtils.shift((char[])array, (int)4);
        Assertions.assertEquals((int)1, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)3, (int)array[2]);
        Assertions.assertEquals((int)4, (int)array[3]);
        ArrayUtils.shift((char[])array, (int)-4);
        Assertions.assertEquals((int)1, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)3, (int)array[2]);
        Assertions.assertEquals((int)4, (int)array[3]);
    }

    @Test
    public void testShiftAllDouble() {
        double[] array = new double[]{1.0, 2.0, 3.0, 4.0};
        ArrayUtils.shift((double[])array, (int)4);
        Assertions.assertEquals((double)1.0, (double)array[0]);
        Assertions.assertEquals((double)2.0, (double)array[1]);
        Assertions.assertEquals((double)3.0, (double)array[2]);
        Assertions.assertEquals((double)4.0, (double)array[3]);
        ArrayUtils.shift((double[])array, (int)-4);
        Assertions.assertEquals((double)1.0, (double)array[0]);
        Assertions.assertEquals((double)2.0, (double)array[1]);
        Assertions.assertEquals((double)3.0, (double)array[2]);
        Assertions.assertEquals((double)4.0, (double)array[3]);
    }

    @Test
    public void testShiftAllFloat() {
        float[] array = new float[]{1.0f, 2.0f, 3.0f, 4.0f};
        ArrayUtils.shift((float[])array, (int)4);
        Assertions.assertEquals((float)1.0f, (float)array[0]);
        Assertions.assertEquals((float)2.0f, (float)array[1]);
        Assertions.assertEquals((float)3.0f, (float)array[2]);
        Assertions.assertEquals((float)4.0f, (float)array[3]);
        ArrayUtils.shift((float[])array, (int)-4);
        Assertions.assertEquals((float)1.0f, (float)array[0]);
        Assertions.assertEquals((float)2.0f, (float)array[1]);
        Assertions.assertEquals((float)3.0f, (float)array[2]);
        Assertions.assertEquals((float)4.0f, (float)array[3]);
    }

    @Test
    public void testShiftAllInt() {
        int[] array = new int[]{1, 2, 3, 4};
        ArrayUtils.shift((int[])array, (int)4);
        Assertions.assertEquals((int)1, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)3, (int)array[2]);
        Assertions.assertEquals((int)4, (int)array[3]);
        ArrayUtils.shift((int[])array, (int)-4);
        Assertions.assertEquals((int)1, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)3, (int)array[2]);
        Assertions.assertEquals((int)4, (int)array[3]);
    }

    @Test
    public void testShiftAllLong() {
        long[] array = new long[]{1L, 2L, 3L, 4L};
        ArrayUtils.shift((long[])array, (int)4);
        Assertions.assertEquals((long)1L, (long)array[0]);
        Assertions.assertEquals((long)2L, (long)array[1]);
        Assertions.assertEquals((long)3L, (long)array[2]);
        Assertions.assertEquals((long)4L, (long)array[3]);
        ArrayUtils.shift((long[])array, (int)-4);
        Assertions.assertEquals((long)1L, (long)array[0]);
        Assertions.assertEquals((long)2L, (long)array[1]);
        Assertions.assertEquals((long)3L, (long)array[2]);
        Assertions.assertEquals((long)4L, (long)array[3]);
    }

    @Test
    public void testShiftAllObject() {
        Object[] array = new String[]{"1", "2", "3", "4"};
        ArrayUtils.shift((Object[])array, (int)4);
        Assertions.assertEquals((Object)"1", (Object)array[0]);
        Assertions.assertEquals((Object)"2", (Object)array[1]);
        Assertions.assertEquals((Object)"3", (Object)array[2]);
        Assertions.assertEquals((Object)"4", (Object)array[3]);
        ArrayUtils.shift((Object[])array, (int)-4);
        Assertions.assertEquals((Object)"1", (Object)array[0]);
        Assertions.assertEquals((Object)"2", (Object)array[1]);
        Assertions.assertEquals((Object)"3", (Object)array[2]);
        Assertions.assertEquals((Object)"4", (Object)array[3]);
    }

    @Test
    public void testShiftAllShort() {
        short[] array = new short[]{1, 2, 3, 4};
        ArrayUtils.shift((short[])array, (int)4);
        Assertions.assertEquals((int)1, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)3, (int)array[2]);
        Assertions.assertEquals((int)4, (int)array[3]);
        ArrayUtils.shift((short[])array, (int)-4);
        Assertions.assertEquals((int)1, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)3, (int)array[2]);
        Assertions.assertEquals((int)4, (int)array[3]);
    }

    @Test
    public void testShiftBoolean() {
        boolean[] array = new boolean[]{true, true, false, false};
        ArrayUtils.shift((boolean[])array, (int)1);
        Assertions.assertFalse((boolean)array[0]);
        Assertions.assertTrue((boolean)array[1]);
        Assertions.assertTrue((boolean)array[2]);
        Assertions.assertFalse((boolean)array[3]);
        ArrayUtils.shift((boolean[])array, (int)-1);
        Assertions.assertTrue((boolean)array[0]);
        Assertions.assertTrue((boolean)array[1]);
        Assertions.assertFalse((boolean)array[2]);
        Assertions.assertFalse((boolean)array[3]);
        ArrayUtils.shift((boolean[])array, (int)5);
        Assertions.assertFalse((boolean)array[0]);
        Assertions.assertTrue((boolean)array[1]);
        Assertions.assertTrue((boolean)array[2]);
        Assertions.assertFalse((boolean)array[3]);
        ArrayUtils.shift((boolean[])array, (int)-3);
        Assertions.assertFalse((boolean)array[0]);
        Assertions.assertFalse((boolean)array[1]);
        Assertions.assertTrue((boolean)array[2]);
        Assertions.assertTrue((boolean)array[3]);
    }

    @Test
    public void testShiftByte() {
        byte[] array = new byte[]{1, 2, 3, 4};
        ArrayUtils.shift((byte[])array, (int)1);
        Assertions.assertEquals((int)4, (int)array[0]);
        Assertions.assertEquals((int)1, (int)array[1]);
        Assertions.assertEquals((int)2, (int)array[2]);
        Assertions.assertEquals((int)3, (int)array[3]);
        ArrayUtils.shift((byte[])array, (int)-1);
        Assertions.assertEquals((int)1, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)3, (int)array[2]);
        Assertions.assertEquals((int)4, (int)array[3]);
        ArrayUtils.shift((byte[])array, (int)5);
        Assertions.assertEquals((int)4, (int)array[0]);
        Assertions.assertEquals((int)1, (int)array[1]);
        Assertions.assertEquals((int)2, (int)array[2]);
        Assertions.assertEquals((int)3, (int)array[3]);
        ArrayUtils.shift((byte[])array, (int)-3);
        Assertions.assertEquals((int)3, (int)array[0]);
        Assertions.assertEquals((int)4, (int)array[1]);
        Assertions.assertEquals((int)1, (int)array[2]);
        Assertions.assertEquals((int)2, (int)array[3]);
    }

    @Test
    public void testShiftChar() {
        char[] array = new char[]{'\u0001', '\u0002', '\u0003', '\u0004'};
        ArrayUtils.shift((char[])array, (int)1);
        Assertions.assertEquals((int)4, (int)array[0]);
        Assertions.assertEquals((int)1, (int)array[1]);
        Assertions.assertEquals((int)2, (int)array[2]);
        Assertions.assertEquals((int)3, (int)array[3]);
        ArrayUtils.shift((char[])array, (int)-1);
        Assertions.assertEquals((int)1, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)3, (int)array[2]);
        Assertions.assertEquals((int)4, (int)array[3]);
        ArrayUtils.shift((char[])array, (int)5);
        Assertions.assertEquals((int)4, (int)array[0]);
        Assertions.assertEquals((int)1, (int)array[1]);
        Assertions.assertEquals((int)2, (int)array[2]);
        Assertions.assertEquals((int)3, (int)array[3]);
        ArrayUtils.shift((char[])array, (int)-3);
        Assertions.assertEquals((int)3, (int)array[0]);
        Assertions.assertEquals((int)4, (int)array[1]);
        Assertions.assertEquals((int)1, (int)array[2]);
        Assertions.assertEquals((int)2, (int)array[3]);
    }

    @Test
    public void testShiftDouble() {
        double[] array = new double[]{1.0, 2.0, 3.0, 4.0};
        ArrayUtils.shift((double[])array, (int)1);
        Assertions.assertEquals((double)4.0, (double)array[0]);
        Assertions.assertEquals((double)1.0, (double)array[1]);
        Assertions.assertEquals((double)2.0, (double)array[2]);
        Assertions.assertEquals((double)3.0, (double)array[3]);
        ArrayUtils.shift((double[])array, (int)-1);
        Assertions.assertEquals((double)1.0, (double)array[0]);
        Assertions.assertEquals((double)2.0, (double)array[1]);
        Assertions.assertEquals((double)3.0, (double)array[2]);
        Assertions.assertEquals((double)4.0, (double)array[3]);
        ArrayUtils.shift((double[])array, (int)5);
        Assertions.assertEquals((double)4.0, (double)array[0]);
        Assertions.assertEquals((double)1.0, (double)array[1]);
        Assertions.assertEquals((double)2.0, (double)array[2]);
        Assertions.assertEquals((double)3.0, (double)array[3]);
        ArrayUtils.shift((double[])array, (int)-3);
        Assertions.assertEquals((double)3.0, (double)array[0]);
        Assertions.assertEquals((double)4.0, (double)array[1]);
        Assertions.assertEquals((double)1.0, (double)array[2]);
        Assertions.assertEquals((double)2.0, (double)array[3]);
    }

    @Test
    public void testShiftFloat() {
        float[] array = new float[]{1.0f, 2.0f, 3.0f, 4.0f};
        ArrayUtils.shift((float[])array, (int)1);
        Assertions.assertEquals((float)4.0f, (float)array[0]);
        Assertions.assertEquals((float)1.0f, (float)array[1]);
        Assertions.assertEquals((float)2.0f, (float)array[2]);
        Assertions.assertEquals((float)3.0f, (float)array[3]);
        ArrayUtils.shift((float[])array, (int)-1);
        Assertions.assertEquals((float)1.0f, (float)array[0]);
        Assertions.assertEquals((float)2.0f, (float)array[1]);
        Assertions.assertEquals((float)3.0f, (float)array[2]);
        Assertions.assertEquals((float)4.0f, (float)array[3]);
        ArrayUtils.shift((float[])array, (int)5);
        Assertions.assertEquals((float)4.0f, (float)array[0]);
        Assertions.assertEquals((float)1.0f, (float)array[1]);
        Assertions.assertEquals((float)2.0f, (float)array[2]);
        Assertions.assertEquals((float)3.0f, (float)array[3]);
        ArrayUtils.shift((float[])array, (int)-3);
        Assertions.assertEquals((float)3.0f, (float)array[0]);
        Assertions.assertEquals((float)4.0f, (float)array[1]);
        Assertions.assertEquals((float)1.0f, (float)array[2]);
        Assertions.assertEquals((float)2.0f, (float)array[3]);
    }

    @Test
    public void testShiftInt() {
        int[] array = new int[]{1, 2, 3, 4};
        ArrayUtils.shift((int[])array, (int)1);
        Assertions.assertEquals((int)4, (int)array[0]);
        Assertions.assertEquals((int)1, (int)array[1]);
        Assertions.assertEquals((int)2, (int)array[2]);
        Assertions.assertEquals((int)3, (int)array[3]);
        ArrayUtils.shift((int[])array, (int)-1);
        Assertions.assertEquals((int)1, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)3, (int)array[2]);
        Assertions.assertEquals((int)4, (int)array[3]);
        ArrayUtils.shift((int[])array, (int)5);
        Assertions.assertEquals((int)4, (int)array[0]);
        Assertions.assertEquals((int)1, (int)array[1]);
        Assertions.assertEquals((int)2, (int)array[2]);
        Assertions.assertEquals((int)3, (int)array[3]);
        ArrayUtils.shift((int[])array, (int)-3);
        Assertions.assertEquals((int)3, (int)array[0]);
        Assertions.assertEquals((int)4, (int)array[1]);
        Assertions.assertEquals((int)1, (int)array[2]);
        Assertions.assertEquals((int)2, (int)array[3]);
    }

    @Test
    public void testShiftLong() {
        long[] array = new long[]{1L, 2L, 3L, 4L};
        ArrayUtils.shift((long[])array, (int)1);
        Assertions.assertEquals((long)4L, (long)array[0]);
        Assertions.assertEquals((long)1L, (long)array[1]);
        Assertions.assertEquals((long)2L, (long)array[2]);
        Assertions.assertEquals((long)3L, (long)array[3]);
        ArrayUtils.shift((long[])array, (int)-1);
        Assertions.assertEquals((long)1L, (long)array[0]);
        Assertions.assertEquals((long)2L, (long)array[1]);
        Assertions.assertEquals((long)3L, (long)array[2]);
        Assertions.assertEquals((long)4L, (long)array[3]);
        ArrayUtils.shift((long[])array, (int)5);
        Assertions.assertEquals((long)4L, (long)array[0]);
        Assertions.assertEquals((long)1L, (long)array[1]);
        Assertions.assertEquals((long)2L, (long)array[2]);
        Assertions.assertEquals((long)3L, (long)array[3]);
        ArrayUtils.shift((long[])array, (int)-3);
        Assertions.assertEquals((long)3L, (long)array[0]);
        Assertions.assertEquals((long)4L, (long)array[1]);
        Assertions.assertEquals((long)1L, (long)array[2]);
        Assertions.assertEquals((long)2L, (long)array[3]);
    }

    @Test
    public void testShiftNullBoolean() {
        boolean[] array = null;
        ArrayUtils.shift(array, (int)1);
        Assertions.assertNull(array);
    }

    @Test
    public void testShiftNullDouble() {
        double[] array = null;
        ArrayUtils.shift(array, (int)1);
        Assertions.assertNull(array);
    }

    @Test
    public void testShiftNullFloat() {
        float[] array = null;
        ArrayUtils.shift(array, (int)1);
        Assertions.assertNull(array);
    }

    @Test
    public void testShiftNullInt() {
        int[] array = null;
        ArrayUtils.shift(array, (int)1);
        Assertions.assertNull(array);
    }

    @Test
    public void testShiftNullLong() {
        long[] array = null;
        ArrayUtils.shift(array, (int)1);
        Assertions.assertNull(array);
    }

    @Test
    public void testShiftNullObject() {
        Object[] array = null;
        ArrayUtils.shift(array, (int)1);
        Assertions.assertNull(array);
    }

    @Test
    public void testShiftNullShort() {
        short[] array = null;
        ArrayUtils.shift(array, (int)1);
        Assertions.assertNull(array);
    }

    @Test
    public void testShiftObject() {
        Object[] array = new String[]{"1", "2", "3", "4"};
        ArrayUtils.shift((Object[])array, (int)1);
        Assertions.assertEquals((Object)"4", (Object)array[0]);
        Assertions.assertEquals((Object)"1", (Object)array[1]);
        Assertions.assertEquals((Object)"2", (Object)array[2]);
        Assertions.assertEquals((Object)"3", (Object)array[3]);
        ArrayUtils.shift((Object[])array, (int)-1);
        Assertions.assertEquals((Object)"1", (Object)array[0]);
        Assertions.assertEquals((Object)"2", (Object)array[1]);
        Assertions.assertEquals((Object)"3", (Object)array[2]);
        Assertions.assertEquals((Object)"4", (Object)array[3]);
        ArrayUtils.shift((Object[])array, (int)5);
        Assertions.assertEquals((Object)"4", (Object)array[0]);
        Assertions.assertEquals((Object)"1", (Object)array[1]);
        Assertions.assertEquals((Object)"2", (Object)array[2]);
        Assertions.assertEquals((Object)"3", (Object)array[3]);
        ArrayUtils.shift((Object[])array, (int)-3);
        Assertions.assertEquals((Object)"3", (Object)array[0]);
        Assertions.assertEquals((Object)"4", (Object)array[1]);
        Assertions.assertEquals((Object)"1", (Object)array[2]);
        Assertions.assertEquals((Object)"2", (Object)array[3]);
    }

    @Test
    public void testShiftRangeByte() {
        byte[] array = new byte[]{1, 2, 3, 4, 5};
        ArrayUtils.shift((byte[])array, (int)1, (int)3, (int)1);
        Assertions.assertEquals((int)1, (int)array[0]);
        Assertions.assertEquals((int)3, (int)array[1]);
        Assertions.assertEquals((int)2, (int)array[2]);
        Assertions.assertEquals((int)4, (int)array[3]);
        Assertions.assertEquals((int)5, (int)array[4]);
        ArrayUtils.shift((byte[])array, (int)1, (int)4, (int)2);
        Assertions.assertEquals((int)1, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)4, (int)array[2]);
        Assertions.assertEquals((int)3, (int)array[3]);
        Assertions.assertEquals((int)5, (int)array[4]);
    }

    @Test
    public void testShiftRangeChar() {
        char[] array = new char[]{'\u0001', '\u0002', '\u0003', '\u0004', '\u0005'};
        ArrayUtils.shift((char[])array, (int)1, (int)3, (int)1);
        Assertions.assertEquals((int)1, (int)array[0]);
        Assertions.assertEquals((int)3, (int)array[1]);
        Assertions.assertEquals((int)2, (int)array[2]);
        Assertions.assertEquals((int)4, (int)array[3]);
        Assertions.assertEquals((int)5, (int)array[4]);
        ArrayUtils.shift((char[])array, (int)1, (int)4, (int)2);
        Assertions.assertEquals((int)1, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)4, (int)array[2]);
        Assertions.assertEquals((int)3, (int)array[3]);
        Assertions.assertEquals((int)5, (int)array[4]);
    }

    @Test
    public void testShiftRangeDouble() {
        double[] array = new double[]{1.0, 2.0, 3.0, 4.0, 5.0};
        ArrayUtils.shift((double[])array, (int)1, (int)3, (int)1);
        Assertions.assertEquals((double)1.0, (double)array[0]);
        Assertions.assertEquals((double)3.0, (double)array[1]);
        Assertions.assertEquals((double)2.0, (double)array[2]);
        Assertions.assertEquals((double)4.0, (double)array[3]);
        Assertions.assertEquals((double)5.0, (double)array[4]);
        ArrayUtils.shift((double[])array, (int)1, (int)4, (int)2);
        Assertions.assertEquals((double)1.0, (double)array[0]);
        Assertions.assertEquals((double)2.0, (double)array[1]);
        Assertions.assertEquals((double)4.0, (double)array[2]);
        Assertions.assertEquals((double)3.0, (double)array[3]);
        Assertions.assertEquals((double)5.0, (double)array[4]);
    }

    @Test
    public void testShiftRangeFloat() {
        float[] array = new float[]{1.0f, 2.0f, 3.0f, 4.0f, 5.0f};
        ArrayUtils.shift((float[])array, (int)1, (int)3, (int)1);
        Assertions.assertEquals((float)1.0f, (float)array[0]);
        Assertions.assertEquals((float)3.0f, (float)array[1]);
        Assertions.assertEquals((float)2.0f, (float)array[2]);
        Assertions.assertEquals((float)4.0f, (float)array[3]);
        Assertions.assertEquals((float)5.0f, (float)array[4]);
        ArrayUtils.shift((float[])array, (int)1, (int)4, (int)2);
        Assertions.assertEquals((float)1.0f, (float)array[0]);
        Assertions.assertEquals((float)2.0f, (float)array[1]);
        Assertions.assertEquals((float)4.0f, (float)array[2]);
        Assertions.assertEquals((float)3.0f, (float)array[3]);
        Assertions.assertEquals((float)5.0f, (float)array[4]);
    }

    @Test
    public void testShiftRangeInt() {
        int[] array = new int[]{1, 2, 3, 4, 5};
        ArrayUtils.shift((int[])array, (int)1, (int)3, (int)1);
        Assertions.assertEquals((int)1, (int)array[0]);
        Assertions.assertEquals((int)3, (int)array[1]);
        Assertions.assertEquals((int)2, (int)array[2]);
        Assertions.assertEquals((int)4, (int)array[3]);
        Assertions.assertEquals((int)5, (int)array[4]);
        ArrayUtils.shift((int[])array, (int)1, (int)4, (int)2);
        Assertions.assertEquals((int)1, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)4, (int)array[2]);
        Assertions.assertEquals((int)3, (int)array[3]);
        Assertions.assertEquals((int)5, (int)array[4]);
    }

    @Test
    public void testShiftRangeLong() {
        long[] array = new long[]{1L, 2L, 3L, 4L, 5L};
        ArrayUtils.shift((long[])array, (int)1, (int)3, (int)1);
        Assertions.assertEquals((long)1L, (long)array[0]);
        Assertions.assertEquals((long)3L, (long)array[1]);
        Assertions.assertEquals((long)2L, (long)array[2]);
        Assertions.assertEquals((long)4L, (long)array[3]);
        Assertions.assertEquals((long)5L, (long)array[4]);
        ArrayUtils.shift((long[])array, (int)1, (int)4, (int)2);
        Assertions.assertEquals((long)1L, (long)array[0]);
        Assertions.assertEquals((long)2L, (long)array[1]);
        Assertions.assertEquals((long)4L, (long)array[2]);
        Assertions.assertEquals((long)3L, (long)array[3]);
        Assertions.assertEquals((long)5L, (long)array[4]);
    }

    @Test
    public void testShiftRangeNoElemByte() {
        byte[] array = new byte[]{1, 2, 3, 4};
        ArrayUtils.shift((byte[])array, (int)1, (int)1, (int)1);
        Assertions.assertEquals((int)1, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)3, (int)array[2]);
        Assertions.assertEquals((int)4, (int)array[3]);
    }

    @Test
    public void testShiftRangeNoElemChar() {
        char[] array = new char[]{'\u0001', '\u0002', '\u0003', '\u0004'};
        ArrayUtils.shift((char[])array, (int)1, (int)1, (int)1);
        Assertions.assertEquals((int)1, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)3, (int)array[2]);
        Assertions.assertEquals((int)4, (int)array[3]);
    }

    @Test
    public void testShiftRangeNoElemDouble() {
        double[] array = new double[]{1.0, 2.0, 3.0, 4.0};
        ArrayUtils.shift((double[])array, (int)1, (int)1, (int)1);
        Assertions.assertEquals((double)1.0, (double)array[0]);
        Assertions.assertEquals((double)2.0, (double)array[1]);
        Assertions.assertEquals((double)3.0, (double)array[2]);
        Assertions.assertEquals((double)4.0, (double)array[3]);
    }

    @Test
    public void testShiftRangeNoElemFloat() {
        float[] array = new float[]{1.0f, 2.0f, 3.0f, 4.0f};
        ArrayUtils.shift((float[])array, (int)1, (int)1, (int)1);
        Assertions.assertEquals((float)1.0f, (float)array[0]);
        Assertions.assertEquals((float)2.0f, (float)array[1]);
        Assertions.assertEquals((float)3.0f, (float)array[2]);
        Assertions.assertEquals((float)4.0f, (float)array[3]);
    }

    @Test
    public void testShiftRangeNoElemInt() {
        int[] array = new int[]{1, 2, 3, 4};
        ArrayUtils.shift((int[])array, (int)1, (int)1, (int)1);
        Assertions.assertEquals((int)1, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)3, (int)array[2]);
        Assertions.assertEquals((int)4, (int)array[3]);
    }

    @Test
    public void testShiftRangeNoElemLong() {
        long[] array = new long[]{1L, 2L, 3L, 4L};
        ArrayUtils.shift((long[])array, (int)1, (int)1, (int)1);
        Assertions.assertEquals((long)1L, (long)array[0]);
        Assertions.assertEquals((long)2L, (long)array[1]);
        Assertions.assertEquals((long)3L, (long)array[2]);
        Assertions.assertEquals((long)4L, (long)array[3]);
    }

    @Test
    public void testShiftRangeNoElemObject() {
        Object[] array = new String[]{"1", "2", "3", "4"};
        ArrayUtils.shift((Object[])array, (int)1, (int)1, (int)1);
        Assertions.assertEquals((Object)"1", (Object)array[0]);
        Assertions.assertEquals((Object)"2", (Object)array[1]);
        Assertions.assertEquals((Object)"3", (Object)array[2]);
        Assertions.assertEquals((Object)"4", (Object)array[3]);
    }

    @Test
    public void testShiftRangeNoElemShort() {
        short[] array = new short[]{1, 2, 3, 4};
        ArrayUtils.shift((short[])array, (int)1, (int)1, (int)1);
        Assertions.assertEquals((int)1, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)3, (int)array[2]);
        Assertions.assertEquals((int)4, (int)array[3]);
    }

    @Test
    public void testShiftRangeNullByte() {
        byte[] array = null;
        ArrayUtils.shift(array, (int)1, (int)1, (int)1);
        Assertions.assertNull(array);
    }

    @Test
    public void testShiftRangeNullChar() {
        char[] array = null;
        ArrayUtils.shift(array, (int)1, (int)1, (int)1);
        Assertions.assertNull(array);
    }

    @Test
    public void testShiftRangeNullDouble() {
        double[] array = null;
        ArrayUtils.shift(array, (int)1, (int)1, (int)1);
        Assertions.assertNull(array);
    }

    @Test
    public void testShiftRangeNullFloat() {
        float[] array = null;
        ArrayUtils.shift(array, (int)1, (int)1, (int)1);
        Assertions.assertNull(array);
    }

    @Test
    public void testShiftRangeNullInt() {
        int[] array = null;
        ArrayUtils.shift(array, (int)1, (int)1, (int)1);
        Assertions.assertNull(array);
    }

    @Test
    public void testShiftRangeNullLong() {
        long[] array = null;
        ArrayUtils.shift(array, (int)1, (int)1, (int)1);
        Assertions.assertNull(array);
    }

    @Test
    public void testShiftRangeNullObject() {
        Object[] array = null;
        ArrayUtils.shift(array, (int)1, (int)1, (int)1);
        Assertions.assertNull(array);
    }

    @Test
    public void testShiftRangeNullShort() {
        short[] array = null;
        ArrayUtils.shift(array, (int)1, (int)1, (int)1);
        Assertions.assertNull(array);
    }

    @Test
    public void testShiftRangeObject() {
        Object[] array = new String[]{"1", "2", "3", "4", "5"};
        ArrayUtils.shift((Object[])array, (int)1, (int)3, (int)1);
        Assertions.assertEquals((Object)"1", (Object)array[0]);
        Assertions.assertEquals((Object)"3", (Object)array[1]);
        Assertions.assertEquals((Object)"2", (Object)array[2]);
        Assertions.assertEquals((Object)"4", (Object)array[3]);
        Assertions.assertEquals((Object)"5", (Object)array[4]);
        ArrayUtils.shift((Object[])array, (int)1, (int)4, (int)2);
        Assertions.assertEquals((Object)"1", (Object)array[0]);
        Assertions.assertEquals((Object)"2", (Object)array[1]);
        Assertions.assertEquals((Object)"4", (Object)array[2]);
        Assertions.assertEquals((Object)"3", (Object)array[3]);
        Assertions.assertEquals((Object)"5", (Object)array[4]);
    }

    @Test
    public void testShiftRangeShort() {
        short[] array = new short[]{1, 2, 3, 4, 5};
        ArrayUtils.shift((short[])array, (int)1, (int)3, (int)1);
        Assertions.assertEquals((int)1, (int)array[0]);
        Assertions.assertEquals((int)3, (int)array[1]);
        Assertions.assertEquals((int)2, (int)array[2]);
        Assertions.assertEquals((int)4, (int)array[3]);
        Assertions.assertEquals((int)5, (int)array[4]);
        ArrayUtils.shift((short[])array, (int)1, (int)4, (int)2);
        Assertions.assertEquals((int)1, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)4, (int)array[2]);
        Assertions.assertEquals((int)3, (int)array[3]);
        Assertions.assertEquals((int)5, (int)array[4]);
    }

    @Test
    public void testShiftShort() {
        short[] array = new short[]{1, 2, 3, 4};
        ArrayUtils.shift((short[])array, (int)1);
        Assertions.assertEquals((int)4, (int)array[0]);
        Assertions.assertEquals((int)1, (int)array[1]);
        Assertions.assertEquals((int)2, (int)array[2]);
        Assertions.assertEquals((int)3, (int)array[3]);
        ArrayUtils.shift((short[])array, (int)-1);
        Assertions.assertEquals((int)1, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)3, (int)array[2]);
        Assertions.assertEquals((int)4, (int)array[3]);
        ArrayUtils.shift((short[])array, (int)5);
        Assertions.assertEquals((int)4, (int)array[0]);
        Assertions.assertEquals((int)1, (int)array[1]);
        Assertions.assertEquals((int)2, (int)array[2]);
        Assertions.assertEquals((int)3, (int)array[3]);
        ArrayUtils.shift((short[])array, (int)-3);
        Assertions.assertEquals((int)3, (int)array[0]);
        Assertions.assertEquals((int)4, (int)array[1]);
        Assertions.assertEquals((int)1, (int)array[2]);
        Assertions.assertEquals((int)2, (int)array[3]);
        array = new short[]{1, 2, 3, 4, 5};
        ArrayUtils.shift((short[])array, (int)2);
        Assertions.assertEquals((int)4, (int)array[0]);
        Assertions.assertEquals((int)5, (int)array[1]);
        Assertions.assertEquals((int)1, (int)array[2]);
        Assertions.assertEquals((int)2, (int)array[3]);
        Assertions.assertEquals((int)3, (int)array[4]);
    }

    @Test
    public void testShuffle() {
        Object[] array1 = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10"};
        Object[] array2 = (String[])ArrayUtils.clone((Object[])array1);
        ArrayUtils.shuffle((Object[])array1, (Random)new Random(16111981L));
        Assertions.assertFalse((boolean)Arrays.equals(array1, array2));
        for (Object element : array2) {
            Assertions.assertTrue((boolean)ArrayUtils.contains((Object[])array1, (Object)element), (String)("Element " + (String)element + " not found"));
        }
    }

    @Test
    public void testShuffleBoolean() {
        boolean[] array1 = new boolean[]{true, false, true, true, false, false, true, false, false, true};
        boolean[] array2 = ArrayUtils.clone((boolean[])array1);
        ArrayUtils.shuffle((boolean[])array1, (Random)new Random(16111981L));
        Assertions.assertFalse((boolean)Arrays.equals(array1, array2));
        Assertions.assertEquals((int)5, (int)ArrayUtils.removeAllOccurrences((boolean[])array1, (boolean)true).length);
    }

    @Test
    public void testShuffleByte() {
        byte[] array1 = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
        byte[] array2 = ArrayUtils.clone((byte[])array1);
        ArrayUtils.shuffle((byte[])array1, (Random)new Random(16111981L));
        Assertions.assertFalse((boolean)Arrays.equals(array1, array2));
        for (byte element : array2) {
            Assertions.assertTrue((boolean)ArrayUtils.contains((byte[])array1, (byte)element), (String)("Element " + element + " not found"));
        }
    }

    @Test
    public void testShuffleChar() {
        char[] array1 = new char[]{'\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n'};
        char[] array2 = ArrayUtils.clone((char[])array1);
        ArrayUtils.shuffle((char[])array1, (Random)new Random(16111981L));
        Assertions.assertFalse((boolean)Arrays.equals(array1, array2));
        for (char element : array2) {
            Assertions.assertTrue((boolean)ArrayUtils.contains((char[])array1, (char)element), (String)("Element " + element + " not found"));
        }
    }

    @Test
    public void testShuffleDouble() {
        double[] array1 = new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0};
        double[] array2 = ArrayUtils.clone((double[])array1);
        ArrayUtils.shuffle((double[])array1, (Random)new Random(16111981L));
        Assertions.assertFalse((boolean)Arrays.equals(array1, array2));
        for (double element : array2) {
            Assertions.assertTrue((boolean)ArrayUtils.contains((double[])array1, (double)element), (String)("Element " + element + " not found"));
        }
    }

    @Test
    public void testShuffleFloat() {
        float[] array1 = new float[]{1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f, 8.0f, 9.0f, 10.0f};
        float[] array2 = ArrayUtils.clone((float[])array1);
        ArrayUtils.shuffle((float[])array1, (Random)new Random(16111981L));
        Assertions.assertFalse((boolean)Arrays.equals(array1, array2));
        for (float element : array2) {
            Assertions.assertTrue((boolean)ArrayUtils.contains((float[])array1, (float)element), (String)("Element " + element + " not found"));
        }
    }

    @Test
    public void testShuffleInt() {
        int[] array1 = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
        int[] array2 = ArrayUtils.clone((int[])array1);
        ArrayUtils.shuffle((int[])array1, (Random)new Random(16111981L));
        Assertions.assertFalse((boolean)Arrays.equals(array1, array2));
        for (int element : array2) {
            Assertions.assertTrue((boolean)ArrayUtils.contains((int[])array1, (int)element), (String)("Element " + element + " not found"));
        }
    }

    @Test
    public void testShuffleLong() {
        long[] array1 = new long[]{1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L};
        long[] array2 = ArrayUtils.clone((long[])array1);
        ArrayUtils.shuffle((long[])array1, (Random)new Random(16111981L));
        Assertions.assertFalse((boolean)Arrays.equals(array1, array2));
        for (long element : array2) {
            Assertions.assertTrue((boolean)ArrayUtils.contains((long[])array1, (long)element), (String)("Element " + element + " not found"));
        }
    }

    @Test
    public void testShuffleShort() {
        short[] array1 = new short[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
        short[] array2 = ArrayUtils.clone((short[])array1);
        ArrayUtils.shuffle((short[])array1, (Random)new Random(16111981L));
        Assertions.assertFalse((boolean)Arrays.equals(array1, array2));
        for (short element : array2) {
            Assertions.assertTrue((boolean)ArrayUtils.contains((short[])array1, (short)element), (String)("Element " + element + " not found"));
        }
    }

    @Test
    public void testSubarrayBoolean() {
        boolean[] nullArray = null;
        boolean[] array = new boolean[]{true, true, false, true, false, true};
        boolean[] leftSubarray = new boolean[]{true, true, false, true};
        boolean[] midSubarray = new boolean[]{true, false, true, false};
        boolean[] rightSubarray = new boolean[]{false, true, false, true};
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)leftSubarray, (Object)ArrayUtils.subarray((boolean[])array, (int)0, (int)4)), (String)"0 start, mid end");
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)array, (Object)ArrayUtils.subarray((boolean[])array, (int)0, (int)array.length)), (String)"0 start, length end");
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)midSubarray, (Object)ArrayUtils.subarray((boolean[])array, (int)1, (int)5)), (String)"mid start, mid end");
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)rightSubarray, (Object)ArrayUtils.subarray((boolean[])array, (int)2, (int)array.length)), (String)"mid start, length end");
        Assertions.assertNull((Object)ArrayUtils.subarray(nullArray, (int)0, (int)3), (String)"null input");
        Assertions.assertEquals((Object)ArrayUtils.EMPTY_BOOLEAN_ARRAY, (Object)ArrayUtils.subarray((boolean[])ArrayUtils.EMPTY_BOOLEAN_ARRAY, (int)1, (int)2), (String)"empty array");
        Assertions.assertEquals((Object)ArrayUtils.EMPTY_BOOLEAN_ARRAY, (Object)ArrayUtils.subarray((boolean[])array, (int)4, (int)2), (String)"start > end");
        Assertions.assertEquals((Object)ArrayUtils.EMPTY_BOOLEAN_ARRAY, (Object)ArrayUtils.subarray((boolean[])array, (int)3, (int)3), (String)"start == end");
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)leftSubarray, (Object)ArrayUtils.subarray((boolean[])array, (int)-2, (int)4)), (String)"start undershoot, normal end");
        Assertions.assertEquals((Object)ArrayUtils.EMPTY_BOOLEAN_ARRAY, (Object)ArrayUtils.subarray((boolean[])array, (int)33, (int)4), (String)"start overshoot, any end");
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)rightSubarray, (Object)ArrayUtils.subarray((boolean[])array, (int)2, (int)33)), (String)"normal start, end overshoot");
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)array, (Object)ArrayUtils.subarray((boolean[])array, (int)-2, (int)12)), (String)"start undershoot, end overshoot");
        Assertions.assertSame((Object)ArrayUtils.EMPTY_BOOLEAN_ARRAY, (Object)ArrayUtils.subarray((boolean[])ArrayUtils.EMPTY_BOOLEAN_ARRAY, (int)1, (int)2), (String)"empty array, object test");
        Assertions.assertSame((Object)ArrayUtils.EMPTY_BOOLEAN_ARRAY, (Object)ArrayUtils.subarray((boolean[])array, (int)4, (int)1), (String)"start > end, object test");
        Assertions.assertSame((Object)ArrayUtils.EMPTY_BOOLEAN_ARRAY, (Object)ArrayUtils.subarray((boolean[])array, (int)3, (int)3), (String)"start == end, object test");
        Assertions.assertSame((Object)ArrayUtils.EMPTY_BOOLEAN_ARRAY, (Object)ArrayUtils.subarray((boolean[])array, (int)8733, (int)4), (String)"start overshoot, any end, object test");
        Assertions.assertSame(Boolean.TYPE, ArrayUtils.subarray((boolean[])array, (int)2, (int)4).getClass().getComponentType(), (String)"boolean type");
    }

    @Test
    public void testSubarrayByte() {
        byte[] nullArray = null;
        byte[] array = new byte[]{10, 11, 12, 13, 14, 15};
        byte[] leftSubarray = new byte[]{10, 11, 12, 13};
        byte[] midSubarray = new byte[]{11, 12, 13, 14};
        byte[] rightSubarray = new byte[]{12, 13, 14, 15};
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)leftSubarray, (Object)ArrayUtils.subarray((byte[])array, (int)0, (int)4)), (String)"0 start, mid end");
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)array, (Object)ArrayUtils.subarray((byte[])array, (int)0, (int)array.length)), (String)"0 start, length end");
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)midSubarray, (Object)ArrayUtils.subarray((byte[])array, (int)1, (int)5)), (String)"mid start, mid end");
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)rightSubarray, (Object)ArrayUtils.subarray((byte[])array, (int)2, (int)array.length)), (String)"mid start, length end");
        Assertions.assertNull((Object)ArrayUtils.subarray(nullArray, (int)0, (int)3), (String)"null input");
        Assertions.assertEquals((Object)ArrayUtils.EMPTY_BYTE_ARRAY, (Object)ArrayUtils.subarray((byte[])ArrayUtils.EMPTY_BYTE_ARRAY, (int)1, (int)2), (String)"empty array");
        Assertions.assertEquals((Object)ArrayUtils.EMPTY_BYTE_ARRAY, (Object)ArrayUtils.subarray((byte[])array, (int)4, (int)2), (String)"start > end");
        Assertions.assertEquals((Object)ArrayUtils.EMPTY_BYTE_ARRAY, (Object)ArrayUtils.subarray((byte[])array, (int)3, (int)3), (String)"start == end");
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)leftSubarray, (Object)ArrayUtils.subarray((byte[])array, (int)-2, (int)4)), (String)"start undershoot, normal end");
        Assertions.assertEquals((Object)ArrayUtils.EMPTY_BYTE_ARRAY, (Object)ArrayUtils.subarray((byte[])array, (int)33, (int)4), (String)"start overshoot, any end");
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)rightSubarray, (Object)ArrayUtils.subarray((byte[])array, (int)2, (int)33)), (String)"normal start, end overshoot");
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)array, (Object)ArrayUtils.subarray((byte[])array, (int)-2, (int)12)), (String)"start undershoot, end overshoot");
        Assertions.assertSame((Object)ArrayUtils.EMPTY_BYTE_ARRAY, (Object)ArrayUtils.subarray((byte[])ArrayUtils.EMPTY_BYTE_ARRAY, (int)1, (int)2), (String)"empty array, object test");
        Assertions.assertSame((Object)ArrayUtils.EMPTY_BYTE_ARRAY, (Object)ArrayUtils.subarray((byte[])array, (int)4, (int)1), (String)"start > end, object test");
        Assertions.assertSame((Object)ArrayUtils.EMPTY_BYTE_ARRAY, (Object)ArrayUtils.subarray((byte[])array, (int)3, (int)3), (String)"start == end, object test");
        Assertions.assertSame((Object)ArrayUtils.EMPTY_BYTE_ARRAY, (Object)ArrayUtils.subarray((byte[])array, (int)8733, (int)4), (String)"start overshoot, any end, object test");
        Assertions.assertSame(Byte.TYPE, ArrayUtils.subarray((byte[])array, (int)2, (int)4).getClass().getComponentType(), (String)"byte type");
    }

    @Test
    public void testSubarrayDouble() {
        double[] nullArray = null;
        double[] array = new double[]{10.123, 11.234, 12.345, 13.456, 14.567, 15.678};
        double[] leftSubarray = new double[]{10.123, 11.234, 12.345, 13.456};
        double[] midSubarray = new double[]{11.234, 12.345, 13.456, 14.567};
        double[] rightSubarray = new double[]{12.345, 13.456, 14.567, 15.678};
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)leftSubarray, (Object)ArrayUtils.subarray((double[])array, (int)0, (int)4)), (String)"0 start, mid end");
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)array, (Object)ArrayUtils.subarray((double[])array, (int)0, (int)array.length)), (String)"0 start, length end");
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)midSubarray, (Object)ArrayUtils.subarray((double[])array, (int)1, (int)5)), (String)"mid start, mid end");
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)rightSubarray, (Object)ArrayUtils.subarray((double[])array, (int)2, (int)array.length)), (String)"mid start, length end");
        Assertions.assertNull((Object)ArrayUtils.subarray(nullArray, (int)0, (int)3), (String)"null input");
        Assertions.assertEquals((Object)ArrayUtils.EMPTY_DOUBLE_ARRAY, (Object)ArrayUtils.subarray((double[])ArrayUtils.EMPTY_DOUBLE_ARRAY, (int)1, (int)2), (String)"empty array");
        Assertions.assertEquals((Object)ArrayUtils.EMPTY_DOUBLE_ARRAY, (Object)ArrayUtils.subarray((double[])array, (int)4, (int)2), (String)"start > end");
        Assertions.assertEquals((Object)ArrayUtils.EMPTY_DOUBLE_ARRAY, (Object)ArrayUtils.subarray((double[])array, (int)3, (int)3), (String)"start == end");
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)leftSubarray, (Object)ArrayUtils.subarray((double[])array, (int)-2, (int)4)), (String)"start undershoot, normal end");
        Assertions.assertEquals((Object)ArrayUtils.EMPTY_DOUBLE_ARRAY, (Object)ArrayUtils.subarray((double[])array, (int)33, (int)4), (String)"start overshoot, any end");
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)rightSubarray, (Object)ArrayUtils.subarray((double[])array, (int)2, (int)33)), (String)"normal start, end overshoot");
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)array, (Object)ArrayUtils.subarray((double[])array, (int)-2, (int)12)), (String)"start undershoot, end overshoot");
        Assertions.assertSame((Object)ArrayUtils.EMPTY_DOUBLE_ARRAY, (Object)ArrayUtils.subarray((double[])ArrayUtils.EMPTY_DOUBLE_ARRAY, (int)1, (int)2), (String)"empty array, object test");
        Assertions.assertSame((Object)ArrayUtils.EMPTY_DOUBLE_ARRAY, (Object)ArrayUtils.subarray((double[])array, (int)4, (int)1), (String)"start > end, object test");
        Assertions.assertSame((Object)ArrayUtils.EMPTY_DOUBLE_ARRAY, (Object)ArrayUtils.subarray((double[])array, (int)3, (int)3), (String)"start == end, object test");
        Assertions.assertSame((Object)ArrayUtils.EMPTY_DOUBLE_ARRAY, (Object)ArrayUtils.subarray((double[])array, (int)8733, (int)4), (String)"start overshoot, any end, object test");
        Assertions.assertSame(Double.TYPE, ArrayUtils.subarray((double[])array, (int)2, (int)4).getClass().getComponentType(), (String)"double type");
    }

    @Test
    public void testSubarrayFloat() {
        float[] nullArray = null;
        float[] array = new float[]{10.0f, 11.0f, 12.0f, 13.0f, 14.0f, 15.0f};
        float[] leftSubarray = new float[]{10.0f, 11.0f, 12.0f, 13.0f};
        float[] midSubarray = new float[]{11.0f, 12.0f, 13.0f, 14.0f};
        float[] rightSubarray = new float[]{12.0f, 13.0f, 14.0f, 15.0f};
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)leftSubarray, (Object)ArrayUtils.subarray((float[])array, (int)0, (int)4)), (String)"0 start, mid end");
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)array, (Object)ArrayUtils.subarray((float[])array, (int)0, (int)array.length)), (String)"0 start, length end");
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)midSubarray, (Object)ArrayUtils.subarray((float[])array, (int)1, (int)5)), (String)"mid start, mid end");
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)rightSubarray, (Object)ArrayUtils.subarray((float[])array, (int)2, (int)array.length)), (String)"mid start, length end");
        Assertions.assertNull((Object)ArrayUtils.subarray(nullArray, (int)0, (int)3), (String)"null input");
        Assertions.assertEquals((Object)ArrayUtils.EMPTY_FLOAT_ARRAY, (Object)ArrayUtils.subarray((float[])ArrayUtils.EMPTY_FLOAT_ARRAY, (int)1, (int)2), (String)"empty array");
        Assertions.assertEquals((Object)ArrayUtils.EMPTY_FLOAT_ARRAY, (Object)ArrayUtils.subarray((float[])array, (int)4, (int)2), (String)"start > end");
        Assertions.assertEquals((Object)ArrayUtils.EMPTY_FLOAT_ARRAY, (Object)ArrayUtils.subarray((float[])array, (int)3, (int)3), (String)"start == end");
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)leftSubarray, (Object)ArrayUtils.subarray((float[])array, (int)-2, (int)4)), (String)"start undershoot, normal end");
        Assertions.assertEquals((Object)ArrayUtils.EMPTY_FLOAT_ARRAY, (Object)ArrayUtils.subarray((float[])array, (int)33, (int)4), (String)"start overshoot, any end");
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)rightSubarray, (Object)ArrayUtils.subarray((float[])array, (int)2, (int)33)), (String)"normal start, end overshoot");
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)array, (Object)ArrayUtils.subarray((float[])array, (int)-2, (int)12)), (String)"start undershoot, end overshoot");
        Assertions.assertSame((Object)ArrayUtils.EMPTY_FLOAT_ARRAY, (Object)ArrayUtils.subarray((float[])ArrayUtils.EMPTY_FLOAT_ARRAY, (int)1, (int)2), (String)"empty array, object test");
        Assertions.assertSame((Object)ArrayUtils.EMPTY_FLOAT_ARRAY, (Object)ArrayUtils.subarray((float[])array, (int)4, (int)1), (String)"start > end, object test");
        Assertions.assertSame((Object)ArrayUtils.EMPTY_FLOAT_ARRAY, (Object)ArrayUtils.subarray((float[])array, (int)3, (int)3), (String)"start == end, object test");
        Assertions.assertSame((Object)ArrayUtils.EMPTY_FLOAT_ARRAY, (Object)ArrayUtils.subarray((float[])array, (int)8733, (int)4), (String)"start overshoot, any end, object test");
        Assertions.assertSame(Float.TYPE, ArrayUtils.subarray((float[])array, (int)2, (int)4).getClass().getComponentType(), (String)"float type");
    }

    @Test
    public void testSubarrayInt() {
        int[] nullArray = null;
        int[] array = new int[]{10, 11, 12, 13, 14, 15};
        int[] leftSubarray = new int[]{10, 11, 12, 13};
        int[] midSubarray = new int[]{11, 12, 13, 14};
        int[] rightSubarray = new int[]{12, 13, 14, 15};
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)leftSubarray, (Object)ArrayUtils.subarray((int[])array, (int)0, (int)4)), (String)"0 start, mid end");
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)array, (Object)ArrayUtils.subarray((int[])array, (int)0, (int)array.length)), (String)"0 start, length end");
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)midSubarray, (Object)ArrayUtils.subarray((int[])array, (int)1, (int)5)), (String)"mid start, mid end");
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)rightSubarray, (Object)ArrayUtils.subarray((int[])array, (int)2, (int)array.length)), (String)"mid start, length end");
        Assertions.assertNull((Object)ArrayUtils.subarray(nullArray, (int)0, (int)3), (String)"null input");
        Assertions.assertEquals((Object)ArrayUtils.EMPTY_INT_ARRAY, (Object)ArrayUtils.subarray((int[])ArrayUtils.EMPTY_INT_ARRAY, (int)1, (int)2), (String)"empty array");
        Assertions.assertEquals((Object)ArrayUtils.EMPTY_INT_ARRAY, (Object)ArrayUtils.subarray((int[])array, (int)4, (int)2), (String)"start > end");
        Assertions.assertEquals((Object)ArrayUtils.EMPTY_INT_ARRAY, (Object)ArrayUtils.subarray((int[])array, (int)3, (int)3), (String)"start == end");
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)leftSubarray, (Object)ArrayUtils.subarray((int[])array, (int)-2, (int)4)), (String)"start undershoot, normal end");
        Assertions.assertEquals((Object)ArrayUtils.EMPTY_INT_ARRAY, (Object)ArrayUtils.subarray((int[])array, (int)33, (int)4), (String)"start overshoot, any end");
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)rightSubarray, (Object)ArrayUtils.subarray((int[])array, (int)2, (int)33)), (String)"normal start, end overshoot");
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)array, (Object)ArrayUtils.subarray((int[])array, (int)-2, (int)12)), (String)"start undershoot, end overshoot");
        Assertions.assertSame((Object)ArrayUtils.EMPTY_INT_ARRAY, (Object)ArrayUtils.subarray((int[])ArrayUtils.EMPTY_INT_ARRAY, (int)1, (int)2), (String)"empty array, object test");
        Assertions.assertSame((Object)ArrayUtils.EMPTY_INT_ARRAY, (Object)ArrayUtils.subarray((int[])array, (int)4, (int)1), (String)"start > end, object test");
        Assertions.assertSame((Object)ArrayUtils.EMPTY_INT_ARRAY, (Object)ArrayUtils.subarray((int[])array, (int)3, (int)3), (String)"start == end, object test");
        Assertions.assertSame((Object)ArrayUtils.EMPTY_INT_ARRAY, (Object)ArrayUtils.subarray((int[])array, (int)8733, (int)4), (String)"start overshoot, any end, object test");
        Assertions.assertSame(Integer.TYPE, ArrayUtils.subarray((int[])array, (int)2, (int)4).getClass().getComponentType(), (String)"int type");
    }

    @Test
    public void testSubarrayLong() {
        long[] nullArray = null;
        long[] array = new long[]{999910L, 999911L, 999912L, 999913L, 999914L, 999915L};
        long[] leftSubarray = new long[]{999910L, 999911L, 999912L, 999913L};
        long[] midSubarray = new long[]{999911L, 999912L, 999913L, 999914L};
        long[] rightSubarray = new long[]{999912L, 999913L, 999914L, 999915L};
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)leftSubarray, (Object)ArrayUtils.subarray((long[])array, (int)0, (int)4)), (String)"0 start, mid end");
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)array, (Object)ArrayUtils.subarray((long[])array, (int)0, (int)array.length)), (String)"0 start, length end");
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)midSubarray, (Object)ArrayUtils.subarray((long[])array, (int)1, (int)5)), (String)"mid start, mid end");
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)rightSubarray, (Object)ArrayUtils.subarray((long[])array, (int)2, (int)array.length)), (String)"mid start, length end");
        Assertions.assertNull((Object)ArrayUtils.subarray(nullArray, (int)0, (int)3), (String)"null input");
        Assertions.assertEquals((Object)ArrayUtils.EMPTY_LONG_ARRAY, (Object)ArrayUtils.subarray((long[])ArrayUtils.EMPTY_LONG_ARRAY, (int)1, (int)2), (String)"empty array");
        Assertions.assertEquals((Object)ArrayUtils.EMPTY_LONG_ARRAY, (Object)ArrayUtils.subarray((long[])array, (int)4, (int)2), (String)"start > end");
        Assertions.assertEquals((Object)ArrayUtils.EMPTY_LONG_ARRAY, (Object)ArrayUtils.subarray((long[])array, (int)3, (int)3), (String)"start == end");
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)leftSubarray, (Object)ArrayUtils.subarray((long[])array, (int)-2, (int)4)), (String)"start undershoot, normal end");
        Assertions.assertEquals((Object)ArrayUtils.EMPTY_LONG_ARRAY, (Object)ArrayUtils.subarray((long[])array, (int)33, (int)4), (String)"start overshoot, any end");
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)rightSubarray, (Object)ArrayUtils.subarray((long[])array, (int)2, (int)33)), (String)"normal start, end overshoot");
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)array, (Object)ArrayUtils.subarray((long[])array, (int)-2, (int)12)), (String)"start undershoot, end overshoot");
        Assertions.assertSame((Object)ArrayUtils.EMPTY_LONG_ARRAY, (Object)ArrayUtils.subarray((long[])ArrayUtils.EMPTY_LONG_ARRAY, (int)1, (int)2), (String)"empty array, object test");
        Assertions.assertSame((Object)ArrayUtils.EMPTY_LONG_ARRAY, (Object)ArrayUtils.subarray((long[])array, (int)4, (int)1), (String)"start > end, object test");
        Assertions.assertSame((Object)ArrayUtils.EMPTY_LONG_ARRAY, (Object)ArrayUtils.subarray((long[])array, (int)3, (int)3), (String)"start == end, object test");
        Assertions.assertSame((Object)ArrayUtils.EMPTY_LONG_ARRAY, (Object)ArrayUtils.subarray((long[])array, (int)8733, (int)4), (String)"start overshoot, any end, object test");
        Assertions.assertSame(Long.TYPE, ArrayUtils.subarray((long[])array, (int)2, (int)4).getClass().getComponentType(), (String)"long type");
    }

    @Test
    public void testSubarrayObject() {
        Object[] nullArray = null;
        Object[] objectArray = new Object[]{"a", "b", "c", "d", "e", "f"};
        Assertions.assertEquals((Object)"abcd", (Object)StringUtils.join((Object[])ArrayUtils.subarray((Object[])objectArray, (int)0, (int)4)), (String)"0 start, mid end");
        Assertions.assertEquals((Object)"abcdef", (Object)StringUtils.join((Object[])ArrayUtils.subarray((Object[])objectArray, (int)0, (int)objectArray.length)), (String)"0 start, length end");
        Assertions.assertEquals((Object)"bcd", (Object)StringUtils.join((Object[])ArrayUtils.subarray((Object[])objectArray, (int)1, (int)4)), (String)"mid start, mid end");
        Assertions.assertEquals((Object)"bcdef", (Object)StringUtils.join((Object[])ArrayUtils.subarray((Object[])objectArray, (int)1, (int)objectArray.length)), (String)"mid start, length end");
        Assertions.assertNull((Object)ArrayUtils.subarray(nullArray, (int)0, (int)3), (String)"null input");
        Assertions.assertEquals((Object)"", (Object)StringUtils.join((Object[])ArrayUtils.subarray((Object[])ArrayUtils.EMPTY_OBJECT_ARRAY, (int)1, (int)2)), (String)"empty array");
        Assertions.assertEquals((Object)"", (Object)StringUtils.join((Object[])ArrayUtils.subarray((Object[])objectArray, (int)4, (int)2)), (String)"start > end");
        Assertions.assertEquals((Object)"", (Object)StringUtils.join((Object[])ArrayUtils.subarray((Object[])objectArray, (int)3, (int)3)), (String)"start == end");
        Assertions.assertEquals((Object)"abcd", (Object)StringUtils.join((Object[])ArrayUtils.subarray((Object[])objectArray, (int)-2, (int)4)), (String)"start undershoot, normal end");
        Assertions.assertEquals((Object)"", (Object)StringUtils.join((Object[])ArrayUtils.subarray((Object[])objectArray, (int)33, (int)4)), (String)"start overshoot, any end");
        Assertions.assertEquals((Object)"cdef", (Object)StringUtils.join((Object[])ArrayUtils.subarray((Object[])objectArray, (int)2, (int)33)), (String)"normal start, end overshoot");
        Assertions.assertEquals((Object)"abcdef", (Object)StringUtils.join((Object[])ArrayUtils.subarray((Object[])objectArray, (int)-2, (int)12)), (String)"start undershoot, end overshoot");
        Object[] dateArray = new java.util.Date[]{new Date(new java.util.Date().getTime()), new java.util.Date(), new java.util.Date(), new java.util.Date(), new java.util.Date()};
        Assertions.assertSame(Object.class, ArrayUtils.subarray((Object[])objectArray, (int)2, (int)4).getClass().getComponentType(), (String)"Object type");
        Assertions.assertSame(java.util.Date.class, ((java.util.Date[])ArrayUtils.subarray((Object[])dateArray, (int)1, (int)4)).getClass().getComponentType(), (String)"java.util.Date type");
        Assertions.assertNotSame(Date.class, ((java.util.Date[])ArrayUtils.subarray((Object[])dateArray, (int)1, (int)4)).getClass().getComponentType(), (String)"java.sql.Date type");
        Assertions.assertThrows(ClassCastException.class, () -> ArrayUtilsTest.lambda$testSubarrayObject$6((java.util.Date[])dateArray), (String)"Invalid downcast");
    }

    @Test
    public void testSubarrayShort() {
        short[] nullArray = null;
        short[] array = new short[]{10, 11, 12, 13, 14, 15};
        short[] leftSubarray = new short[]{10, 11, 12, 13};
        short[] midSubarray = new short[]{11, 12, 13, 14};
        short[] rightSubarray = new short[]{12, 13, 14, 15};
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)leftSubarray, (Object)ArrayUtils.subarray((short[])array, (int)0, (int)4)), (String)"0 start, mid end");
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)array, (Object)ArrayUtils.subarray((short[])array, (int)0, (int)array.length)), (String)"0 start, length end");
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)midSubarray, (Object)ArrayUtils.subarray((short[])array, (int)1, (int)5)), (String)"mid start, mid end");
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)rightSubarray, (Object)ArrayUtils.subarray((short[])array, (int)2, (int)array.length)), (String)"mid start, length end");
        Assertions.assertNull((Object)ArrayUtils.subarray(nullArray, (int)0, (int)3), (String)"null input");
        Assertions.assertEquals((Object)ArrayUtils.EMPTY_SHORT_ARRAY, (Object)ArrayUtils.subarray((short[])ArrayUtils.EMPTY_SHORT_ARRAY, (int)1, (int)2), (String)"empty array");
        Assertions.assertEquals((Object)ArrayUtils.EMPTY_SHORT_ARRAY, (Object)ArrayUtils.subarray((short[])array, (int)4, (int)2), (String)"start > end");
        Assertions.assertEquals((Object)ArrayUtils.EMPTY_SHORT_ARRAY, (Object)ArrayUtils.subarray((short[])array, (int)3, (int)3), (String)"start == end");
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)leftSubarray, (Object)ArrayUtils.subarray((short[])array, (int)-2, (int)4)), (String)"start undershoot, normal end");
        Assertions.assertEquals((Object)ArrayUtils.EMPTY_SHORT_ARRAY, (Object)ArrayUtils.subarray((short[])array, (int)33, (int)4), (String)"start overshoot, any end");
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)rightSubarray, (Object)ArrayUtils.subarray((short[])array, (int)2, (int)33)), (String)"normal start, end overshoot");
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)array, (Object)ArrayUtils.subarray((short[])array, (int)-2, (int)12)), (String)"start undershoot, end overshoot");
        Assertions.assertSame((Object)ArrayUtils.EMPTY_SHORT_ARRAY, (Object)ArrayUtils.subarray((short[])ArrayUtils.EMPTY_SHORT_ARRAY, (int)1, (int)2), (String)"empty array, object test");
        Assertions.assertSame((Object)ArrayUtils.EMPTY_SHORT_ARRAY, (Object)ArrayUtils.subarray((short[])array, (int)4, (int)1), (String)"start > end, object test");
        Assertions.assertSame((Object)ArrayUtils.EMPTY_SHORT_ARRAY, (Object)ArrayUtils.subarray((short[])array, (int)3, (int)3), (String)"start == end, object test");
        Assertions.assertSame((Object)ArrayUtils.EMPTY_SHORT_ARRAY, (Object)ArrayUtils.subarray((short[])array, (int)8733, (int)4), (String)"start overshoot, any end, object test");
        Assertions.assertSame(Short.TYPE, ArrayUtils.subarray((short[])array, (int)2, (int)4).getClass().getComponentType(), (String)"short type");
    }

    @Test
    public void testSubarrChar() {
        char[] nullArray = null;
        char[] array = new char[]{'a', 'b', 'c', 'd', 'e', 'f'};
        char[] leftSubarray = new char[]{'a', 'b', 'c', 'd'};
        char[] midSubarray = new char[]{'b', 'c', 'd', 'e'};
        char[] rightSubarray = new char[]{'c', 'd', 'e', 'f'};
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)leftSubarray, (Object)ArrayUtils.subarray((char[])array, (int)0, (int)4)), (String)"0 start, mid end");
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)array, (Object)ArrayUtils.subarray((char[])array, (int)0, (int)array.length)), (String)"0 start, length end");
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)midSubarray, (Object)ArrayUtils.subarray((char[])array, (int)1, (int)5)), (String)"mid start, mid end");
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)rightSubarray, (Object)ArrayUtils.subarray((char[])array, (int)2, (int)array.length)), (String)"mid start, length end");
        Assertions.assertNull((Object)ArrayUtils.subarray(nullArray, (int)0, (int)3), (String)"null input");
        Assertions.assertEquals((Object)ArrayUtils.EMPTY_CHAR_ARRAY, (Object)ArrayUtils.subarray((char[])ArrayUtils.EMPTY_CHAR_ARRAY, (int)1, (int)2), (String)"empty array");
        Assertions.assertEquals((Object)ArrayUtils.EMPTY_CHAR_ARRAY, (Object)ArrayUtils.subarray((char[])array, (int)4, (int)2), (String)"start > end");
        Assertions.assertEquals((Object)ArrayUtils.EMPTY_CHAR_ARRAY, (Object)ArrayUtils.subarray((char[])array, (int)3, (int)3), (String)"start == end");
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)leftSubarray, (Object)ArrayUtils.subarray((char[])array, (int)-2, (int)4)), (String)"start undershoot, normal end");
        Assertions.assertEquals((Object)ArrayUtils.EMPTY_CHAR_ARRAY, (Object)ArrayUtils.subarray((char[])array, (int)33, (int)4), (String)"start overshoot, any end");
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)rightSubarray, (Object)ArrayUtils.subarray((char[])array, (int)2, (int)33)), (String)"normal start, end overshoot");
        Assertions.assertTrue((boolean)ArrayUtils.isEquals((Object)array, (Object)ArrayUtils.subarray((char[])array, (int)-2, (int)12)), (String)"start undershoot, end overshoot");
        Assertions.assertSame((Object)ArrayUtils.EMPTY_CHAR_ARRAY, (Object)ArrayUtils.subarray((char[])ArrayUtils.EMPTY_CHAR_ARRAY, (int)1, (int)2), (String)"empty array, object test");
        Assertions.assertSame((Object)ArrayUtils.EMPTY_CHAR_ARRAY, (Object)ArrayUtils.subarray((char[])array, (int)4, (int)1), (String)"start > end, object test");
        Assertions.assertSame((Object)ArrayUtils.EMPTY_CHAR_ARRAY, (Object)ArrayUtils.subarray((char[])array, (int)3, (int)3), (String)"start == end, object test");
        Assertions.assertSame((Object)ArrayUtils.EMPTY_CHAR_ARRAY, (Object)ArrayUtils.subarray((char[])array, (int)8733, (int)4), (String)"start overshoot, any end, object test");
        Assertions.assertSame(Character.TYPE, ArrayUtils.subarray((char[])array, (int)2, (int)4).getClass().getComponentType(), (String)"char type");
    }

    @Test
    public void testSwapBoolean() {
        boolean[] array = new boolean[]{true, false, false};
        ArrayUtils.swap((boolean[])array, (int)0, (int)2);
        Assertions.assertFalse((boolean)array[0]);
        Assertions.assertFalse((boolean)array[1]);
        Assertions.assertTrue((boolean)array[2]);
    }

    @Test
    public void testSwapBooleanRange() {
        boolean[] array = new boolean[]{false, false, true, true};
        ArrayUtils.swap((boolean[])array, (int)0, (int)2, (int)2);
        Assertions.assertTrue((boolean)array[0]);
        Assertions.assertTrue((boolean)array[1]);
        Assertions.assertFalse((boolean)array[2]);
        Assertions.assertFalse((boolean)array[3]);
        array = new boolean[]{false, true, false};
        ArrayUtils.swap((boolean[])array, (int)0, (int)3);
        Assertions.assertFalse((boolean)array[0]);
        Assertions.assertTrue((boolean)array[1]);
        Assertions.assertFalse((boolean)array[2]);
        array = new boolean[]{true, true, false};
        ArrayUtils.swap((boolean[])array, (int)0, (int)2, (int)2);
        Assertions.assertFalse((boolean)array[0]);
        Assertions.assertTrue((boolean)array[1]);
        Assertions.assertTrue((boolean)array[2]);
        array = new boolean[]{true, true, false};
        ArrayUtils.swap((boolean[])array, (int)-1, (int)2, (int)2);
        Assertions.assertFalse((boolean)array[0]);
        Assertions.assertTrue((boolean)array[1]);
        Assertions.assertTrue((boolean)array[2]);
        array = new boolean[]{true, true, false};
        ArrayUtils.swap((boolean[])array, (int)0, (int)-1, (int)2);
        Assertions.assertTrue((boolean)array[0]);
        Assertions.assertTrue((boolean)array[1]);
        Assertions.assertFalse((boolean)array[2]);
        array = new boolean[]{true, true, false};
        ArrayUtils.swap((boolean[])array, (int)-1, (int)-1, (int)2);
        Assertions.assertTrue((boolean)array[0]);
        Assertions.assertTrue((boolean)array[1]);
        Assertions.assertFalse((boolean)array[2]);
    }

    @Test
    public void testSwapByte() {
        byte[] array = new byte[]{1, 2, 3};
        ArrayUtils.swap((byte[])array, (int)0, (int)2);
        Assertions.assertEquals((int)3, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)1, (int)array[2]);
    }

    @Test
    public void testSwapByteRange() {
        byte[] array = new byte[]{1, 2, 3, 4};
        ArrayUtils.swap((byte[])array, (int)0, (int)2, (int)2);
        Assertions.assertEquals((int)3, (int)array[0]);
        Assertions.assertEquals((int)4, (int)array[1]);
        Assertions.assertEquals((int)1, (int)array[2]);
        Assertions.assertEquals((int)2, (int)array[3]);
        array = new byte[]{1, 2, 3};
        ArrayUtils.swap((byte[])array, (int)0, (int)3);
        Assertions.assertEquals((int)1, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)3, (int)array[2]);
        array = new byte[]{1, 2, 3};
        ArrayUtils.swap((byte[])array, (int)0, (int)2, (int)2);
        Assertions.assertEquals((int)3, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)1, (int)array[2]);
        array = new byte[]{1, 2, 3};
        ArrayUtils.swap((byte[])array, (int)-1, (int)2, (int)2);
        Assertions.assertEquals((int)3, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)1, (int)array[2]);
        array = new byte[]{1, 2, 3};
        ArrayUtils.swap((byte[])array, (int)0, (int)-1, (int)2);
        Assertions.assertEquals((int)1, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)3, (int)array[2]);
        array = new byte[]{1, 2, 3};
        ArrayUtils.swap((byte[])array, (int)-1, (int)-1, (int)2);
        Assertions.assertEquals((int)1, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)3, (int)array[2]);
    }

    @Test
    public void testSwapChar() {
        char[] array = new char[]{'\u0001', '\u0002', '\u0003'};
        ArrayUtils.swap((char[])array, (int)0, (int)2);
        Assertions.assertArrayEquals((char[])new char[]{'\u0003', '\u0002', '\u0001'}, (char[])array);
        array = new char[]{'\u0001', '\u0002', '\u0003'};
        ArrayUtils.swap((char[])array, (int)0, (int)0);
        Assertions.assertArrayEquals((char[])new char[]{'\u0001', '\u0002', '\u0003'}, (char[])array);
        array = new char[]{'\u0001', '\u0002', '\u0003'};
        ArrayUtils.swap((char[])array, (int)1, (int)0);
        Assertions.assertArrayEquals((char[])new char[]{'\u0002', '\u0001', '\u0003'}, (char[])array);
    }

    @Test
    public void testSwapCharRange() {
        char[] array = new char[]{'\u0001', '\u0002', '\u0003', '\u0004'};
        ArrayUtils.swap((char[])array, (int)0, (int)2, (int)2);
        Assertions.assertEquals((int)3, (int)array[0]);
        Assertions.assertEquals((int)4, (int)array[1]);
        Assertions.assertEquals((int)1, (int)array[2]);
        Assertions.assertEquals((int)2, (int)array[3]);
        array = new char[]{'\u0001', '\u0002', '\u0003'};
        ArrayUtils.swap((char[])array, (int)0, (int)3);
        Assertions.assertEquals((int)1, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)3, (int)array[2]);
        array = new char[]{'\u0001', '\u0002', '\u0003'};
        ArrayUtils.swap((char[])array, (int)0, (int)2, (int)2);
        Assertions.assertEquals((int)3, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)1, (int)array[2]);
        array = new char[]{'\u0001', '\u0002', '\u0003'};
        ArrayUtils.swap((char[])array, (int)-1, (int)2, (int)2);
        Assertions.assertEquals((int)3, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)1, (int)array[2]);
        array = new char[]{'\u0001', '\u0002', '\u0003'};
        ArrayUtils.swap((char[])array, (int)0, (int)-1, (int)2);
        Assertions.assertEquals((int)1, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)3, (int)array[2]);
        array = new char[]{'\u0001', '\u0002', '\u0003'};
        ArrayUtils.swap((char[])array, (int)-1, (int)-1, (int)2);
        Assertions.assertEquals((int)1, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)3, (int)array[2]);
    }

    @Test
    public void testSwapDouble() {
        double[] array = new double[]{1.0, 2.0, 3.0};
        ArrayUtils.swap((double[])array, (int)0, (int)2);
        Assertions.assertEquals((double)3.0, (double)array[0]);
        Assertions.assertEquals((double)2.0, (double)array[1]);
        Assertions.assertEquals((double)1.0, (double)array[2]);
    }

    @Test
    public void testSwapDoubleRange() {
        double[] array = new double[]{1.0, 2.0, 3.0, 4.0};
        ArrayUtils.swap((double[])array, (int)0, (int)2, (int)2);
        Assertions.assertEquals((double)3.0, (double)array[0]);
        Assertions.assertEquals((double)4.0, (double)array[1]);
        Assertions.assertEquals((double)1.0, (double)array[2]);
        Assertions.assertEquals((double)2.0, (double)array[3]);
        array = new double[]{1.0, 2.0, 3.0};
        ArrayUtils.swap((double[])array, (int)0, (int)3);
        Assertions.assertEquals((double)1.0, (double)array[0]);
        Assertions.assertEquals((double)2.0, (double)array[1]);
        Assertions.assertEquals((double)3.0, (double)array[2]);
        array = new double[]{1.0, 2.0, 3.0};
        ArrayUtils.swap((double[])array, (int)0, (int)2, (int)2);
        Assertions.assertEquals((double)3.0, (double)array[0]);
        Assertions.assertEquals((double)2.0, (double)array[1]);
        Assertions.assertEquals((double)1.0, (double)array[2]);
        array = new double[]{1.0, 2.0, 3.0};
        ArrayUtils.swap((double[])array, (int)-1, (int)2, (int)2);
        Assertions.assertEquals((double)3.0, (double)array[0]);
        Assertions.assertEquals((double)2.0, (double)array[1]);
        Assertions.assertEquals((double)1.0, (double)array[2]);
        array = new double[]{1.0, 2.0, 3.0};
        ArrayUtils.swap((double[])array, (int)0, (int)-1, (int)2);
        Assertions.assertEquals((double)1.0, (double)array[0]);
        Assertions.assertEquals((double)2.0, (double)array[1]);
        Assertions.assertEquals((double)3.0, (double)array[2]);
        array = new double[]{1.0, 2.0, 3.0};
        ArrayUtils.swap((double[])array, (int)-1, (int)-1, (int)2);
        Assertions.assertEquals((double)1.0, (double)array[0]);
        Assertions.assertEquals((double)2.0, (double)array[1]);
        Assertions.assertEquals((double)3.0, (double)array[2]);
    }

    @Test
    public void testSwapEmptyBooleanArray() {
        boolean[] array = new boolean[]{};
        ArrayUtils.swap((boolean[])array, (int)0, (int)2);
        Assertions.assertEquals((int)0, (int)array.length);
    }

    @Test
    public void testSwapEmptyByteArray() {
        byte[] array = new byte[]{};
        ArrayUtils.swap((byte[])array, (int)0, (int)2);
        Assertions.assertEquals((int)0, (int)array.length);
    }

    @Test
    public void testSwapEmptyCharArray() {
        char[] array = new char[]{};
        ArrayUtils.swap((char[])array, (int)0, (int)2);
        Assertions.assertEquals((int)0, (int)array.length);
    }

    @Test
    public void testSwapEmptyDoubleArray() {
        double[] array = new double[]{};
        ArrayUtils.swap((double[])array, (int)0, (int)2);
        Assertions.assertEquals((int)0, (int)array.length);
    }

    @Test
    public void testSwapEmptyFloatArray() {
        float[] array = new float[]{};
        ArrayUtils.swap((float[])array, (int)0, (int)2);
        Assertions.assertEquals((int)0, (int)array.length);
    }

    @Test
    public void testSwapEmptyIntArray() {
        int[] array = new int[]{};
        ArrayUtils.swap((int[])array, (int)0, (int)2);
        Assertions.assertEquals((int)0, (int)array.length);
    }

    @Test
    public void testSwapEmptyLongArray() {
        long[] array = new long[]{};
        ArrayUtils.swap((long[])array, (int)0, (int)2);
        Assertions.assertEquals((int)0, (int)array.length);
    }

    @Test
    public void testSwapEmptyObjectArray() {
        Object[] array = new String[]{};
        ArrayUtils.swap((Object[])array, (int)0, (int)2);
        Assertions.assertEquals((int)0, (int)array.length);
    }

    @Test
    public void testSwapEmptyShortArray() {
        short[] array = new short[]{};
        ArrayUtils.swap((short[])array, (int)0, (int)2);
        Assertions.assertEquals((int)0, (int)array.length);
    }

    @Test
    public void testSwapFloat() {
        float[] array = new float[]{1.0f, 2.0f, 3.0f};
        ArrayUtils.swap((float[])array, (int)0, (int)2);
        Assertions.assertEquals((float)3.0f, (float)array[0]);
        Assertions.assertEquals((float)2.0f, (float)array[1]);
        Assertions.assertEquals((float)1.0f, (float)array[2]);
    }

    @Test
    public void testSwapFloatRange() {
        float[] array = new float[]{1.0f, 2.0f, 3.0f, 4.0f};
        ArrayUtils.swap((float[])array, (int)0, (int)2, (int)2);
        Assertions.assertEquals((float)3.0f, (float)array[0]);
        Assertions.assertEquals((float)4.0f, (float)array[1]);
        Assertions.assertEquals((float)1.0f, (float)array[2]);
        Assertions.assertEquals((float)2.0f, (float)array[3]);
        array = new float[]{1.0f, 2.0f, 3.0f};
        ArrayUtils.swap((float[])array, (int)0, (int)3);
        Assertions.assertEquals((float)1.0f, (float)array[0]);
        Assertions.assertEquals((float)2.0f, (float)array[1]);
        Assertions.assertEquals((float)3.0f, (float)array[2]);
        array = new float[]{1.0f, 2.0f, 3.0f};
        ArrayUtils.swap((float[])array, (int)0, (int)2, (int)2);
        Assertions.assertEquals((float)3.0f, (float)array[0]);
        Assertions.assertEquals((float)2.0f, (float)array[1]);
        Assertions.assertEquals((float)1.0f, (float)array[2]);
        array = new float[]{1.0f, 2.0f, 3.0f};
        ArrayUtils.swap((float[])array, (int)-1, (int)2, (int)2);
        Assertions.assertEquals((float)3.0f, (float)array[0]);
        Assertions.assertEquals((float)2.0f, (float)array[1]);
        Assertions.assertEquals((float)1.0f, (float)array[2]);
        array = new float[]{1.0f, 2.0f, 3.0f};
        ArrayUtils.swap((float[])array, (int)0, (int)-1, (int)2);
        Assertions.assertEquals((float)1.0f, (float)array[0]);
        Assertions.assertEquals((float)2.0f, (float)array[1]);
        Assertions.assertEquals((float)3.0f, (float)array[2]);
        array = new float[]{1.0f, 2.0f, 3.0f};
        ArrayUtils.swap((float[])array, (int)-1, (int)-1, (int)2);
        Assertions.assertEquals((float)1.0f, (float)array[0]);
        Assertions.assertEquals((float)2.0f, (float)array[1]);
        Assertions.assertEquals((float)3.0f, (float)array[2]);
    }

    @Test
    public void testSwapInt() {
        int[] array = new int[]{1, 2, 3};
        ArrayUtils.swap((int[])array, (int)0, (int)2);
        Assertions.assertEquals((int)3, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)1, (int)array[2]);
    }

    @Test
    public void testSwapIntExchangedOffsets() {
        int[] array = new int[]{1, 2, 3};
        ArrayUtils.swap((int[])array, (int)0, (int)1, (int)2);
        Assertions.assertArrayEquals((int[])new int[]{2, 3, 1}, (int[])array);
        array = new int[]{1, 2, 3};
        ArrayUtils.swap((int[])array, (int)1, (int)0, (int)2);
        Assertions.assertArrayEquals((int[])new int[]{2, 3, 1}, (int[])array);
    }

    @Test
    public void testSwapIntRange() {
        int[] array = new int[]{1, 2, 3, 4};
        ArrayUtils.swap((int[])array, (int)0, (int)2, (int)2);
        Assertions.assertEquals((int)3, (int)array[0]);
        Assertions.assertEquals((int)4, (int)array[1]);
        Assertions.assertEquals((int)1, (int)array[2]);
        Assertions.assertEquals((int)2, (int)array[3]);
        array = new int[]{1, 2, 3};
        ArrayUtils.swap((int[])array, (int)3, (int)0);
        Assertions.assertEquals((int)1, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)3, (int)array[2]);
        array = new int[]{1, 2, 3};
        ArrayUtils.swap((int[])array, (int)0, (int)2, (int)2);
        Assertions.assertEquals((int)3, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)1, (int)array[2]);
        array = new int[]{1, 2, 3};
        ArrayUtils.swap((int[])array, (int)-1, (int)2, (int)2);
        Assertions.assertEquals((int)3, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)1, (int)array[2]);
        array = new int[]{1, 2, 3};
        ArrayUtils.swap((int[])array, (int)0, (int)-1, (int)2);
        Assertions.assertEquals((int)1, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)3, (int)array[2]);
        array = new int[]{1, 2, 3};
        ArrayUtils.swap((int[])array, (int)-1, (int)-1, (int)2);
        Assertions.assertEquals((int)1, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)3, (int)array[2]);
    }

    @Test
    public void testSwapLong() {
        long[] array = new long[]{1L, 2L, 3L};
        ArrayUtils.swap((long[])array, (int)0, (int)2);
        Assertions.assertEquals((long)3L, (long)array[0]);
        Assertions.assertEquals((long)2L, (long)array[1]);
        Assertions.assertEquals((long)1L, (long)array[2]);
    }

    @Test
    public void testSwapLongRange() {
        long[] array = new long[]{1L, 2L, 3L, 4L};
        ArrayUtils.swap((long[])array, (int)0, (int)2, (int)2);
        Assertions.assertEquals((long)3L, (long)array[0]);
        Assertions.assertEquals((long)4L, (long)array[1]);
        Assertions.assertEquals((long)1L, (long)array[2]);
        Assertions.assertEquals((long)2L, (long)array[3]);
        array = new long[]{1L, 2L, 3L};
        ArrayUtils.swap((long[])array, (int)0, (int)3);
        Assertions.assertEquals((long)1L, (long)array[0]);
        Assertions.assertEquals((long)2L, (long)array[1]);
        Assertions.assertEquals((long)3L, (long)array[2]);
        array = new long[]{1L, 2L, 3L};
        ArrayUtils.swap((long[])array, (int)0, (int)2, (int)2);
        Assertions.assertEquals((long)3L, (long)array[0]);
        Assertions.assertEquals((long)2L, (long)array[1]);
        Assertions.assertEquals((long)1L, (long)array[2]);
        array = new long[]{1L, 2L, 3L};
        ArrayUtils.swap((long[])array, (int)-1, (int)2, (int)2);
        Assertions.assertEquals((long)3L, (long)array[0]);
        Assertions.assertEquals((long)2L, (long)array[1]);
        Assertions.assertEquals((long)1L, (long)array[2]);
        array = new long[]{1L, 2L, 3L};
        ArrayUtils.swap((long[])array, (int)0, (int)-1, (int)2);
        Assertions.assertEquals((long)1L, (long)array[0]);
        Assertions.assertEquals((long)2L, (long)array[1]);
        Assertions.assertEquals((long)3L, (long)array[2]);
        array = new long[]{1L, 2L, 3L};
        ArrayUtils.swap((long[])array, (int)-1, (int)-1, (int)2);
        Assertions.assertEquals((long)1L, (long)array[0]);
        Assertions.assertEquals((long)2L, (long)array[1]);
        Assertions.assertEquals((long)3L, (long)array[2]);
    }

    @Test
    public void testSwapNullBooleanArray() {
        boolean[] array = null;
        ArrayUtils.swap(array, (int)0, (int)2);
        Assertions.assertNull(array);
    }

    @Test
    public void testSwapNullByteArray() {
        byte[] array = null;
        ArrayUtils.swap(array, (int)0, (int)2);
        Assertions.assertNull(array);
    }

    @Test
    public void testSwapNullCharArray() {
        char[] array = null;
        ArrayUtils.swap(array, (int)0, (int)2);
        Assertions.assertNull(array);
    }

    @Test
    public void testSwapNullDoubleArray() {
        double[] array = null;
        ArrayUtils.swap(array, (int)0, (int)2);
        Assertions.assertNull(array);
    }

    @Test
    public void testSwapNullFloatArray() {
        float[] array = null;
        ArrayUtils.swap(array, (int)0, (int)2);
        Assertions.assertNull(array);
    }

    @Test
    public void testSwapNullIntArray() {
        int[] array = null;
        ArrayUtils.swap(array, (int)0, (int)2);
        Assertions.assertNull(array);
    }

    @Test
    public void testSwapNullLongArray() {
        long[] array = null;
        ArrayUtils.swap(array, (int)0, (int)2);
        Assertions.assertNull(array);
    }

    @Test
    public void testSwapNullObjectArray() {
        Object[] array = null;
        ArrayUtils.swap(array, (int)0, (int)2);
        Assertions.assertNull(array);
    }

    @Test
    public void testSwapNullShortArray() {
        short[] array = null;
        ArrayUtils.swap(array, (int)0, (int)2);
        Assertions.assertNull(array);
    }

    @Test
    public void testSwapObject() {
        Object[] array = new String[]{"1", "2", "3"};
        ArrayUtils.swap((Object[])array, (int)0, (int)2);
        Assertions.assertEquals((Object)"3", (Object)array[0]);
        Assertions.assertEquals((Object)"2", (Object)array[1]);
        Assertions.assertEquals((Object)"1", (Object)array[2]);
    }

    @Test
    public void testSwapObjectRange() {
        Object[] array = new String[]{"1", "2", "3", "4"};
        ArrayUtils.swap((Object[])array, (int)0, (int)2, (int)2);
        Assertions.assertEquals((Object)"3", (Object)array[0]);
        Assertions.assertEquals((Object)"4", (Object)array[1]);
        Assertions.assertEquals((Object)"1", (Object)array[2]);
        Assertions.assertEquals((Object)"2", (Object)array[3]);
        array = new String[]{"1", "2", "3", "4"};
        ArrayUtils.swap((Object[])array, (int)-1, (int)2, (int)3);
        Assertions.assertEquals((Object)"3", (Object)array[0]);
        Assertions.assertEquals((Object)"4", (Object)array[1]);
        Assertions.assertEquals((Object)"1", (Object)array[2]);
        Assertions.assertEquals((Object)"2", (Object)array[3]);
        array = new String[]{"1", "2", "3", "4", "5"};
        ArrayUtils.swap((Object[])array, (int)-3, (int)2, (int)3);
        Assertions.assertEquals((Object)"3", (Object)array[0]);
        Assertions.assertEquals((Object)"4", (Object)array[1]);
        Assertions.assertEquals((Object)"5", (Object)array[2]);
        Assertions.assertEquals((Object)"2", (Object)array[3]);
        Assertions.assertEquals((Object)"1", (Object)array[4]);
        array = new String[]{"1", "2", "3", "4", "5"};
        ArrayUtils.swap((Object[])array, (int)2, (int)-2, (int)3);
        Assertions.assertEquals((Object)"3", (Object)array[0]);
        Assertions.assertEquals((Object)"4", (Object)array[1]);
        Assertions.assertEquals((Object)"5", (Object)array[2]);
        Assertions.assertEquals((Object)"2", (Object)array[3]);
        Assertions.assertEquals((Object)"1", (Object)array[4]);
        array = new String[]{};
        ArrayUtils.swap((Object[])array, (int)0, (int)2, (int)2);
        Assertions.assertEquals((int)0, (int)array.length);
        array = null;
        ArrayUtils.swap((Object[])array, (int)0, (int)2, (int)2);
        Assertions.assertNull((Object)array);
    }

    @Test
    public void testSwapShort() {
        short[] array = new short[]{1, 2, 3};
        ArrayUtils.swap((short[])array, (int)0, (int)2);
        Assertions.assertEquals((int)3, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)1, (int)array[2]);
    }

    @Test
    public void testSwapShortRange() {
        short[] array = new short[]{1, 2, 3, 4};
        ArrayUtils.swap((short[])array, (int)0, (int)2, (int)2);
        Assertions.assertEquals((int)3, (int)array[0]);
        Assertions.assertEquals((int)4, (int)array[1]);
        Assertions.assertEquals((int)1, (int)array[2]);
        Assertions.assertEquals((int)2, (int)array[3]);
        array = new short[]{1, 2, 3};
        ArrayUtils.swap((short[])array, (int)3, (int)0);
        Assertions.assertEquals((int)1, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)3, (int)array[2]);
        array = new short[]{1, 2, 3};
        ArrayUtils.swap((short[])array, (int)0, (int)2, (int)2);
        Assertions.assertEquals((int)3, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)1, (int)array[2]);
        array = new short[]{1, 2, 3};
        ArrayUtils.swap((short[])array, (int)-1, (int)2, (int)2);
        Assertions.assertEquals((int)3, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)1, (int)array[2]);
        array = new short[]{1, 2, 3};
        ArrayUtils.swap((short[])array, (int)0, (int)-1, (int)2);
        Assertions.assertEquals((int)1, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)3, (int)array[2]);
        array = new short[]{1, 2, 3};
        ArrayUtils.swap((short[])array, (int)-1, (int)-1, (int)2);
        Assertions.assertEquals((int)1, (int)array[0]);
        Assertions.assertEquals((int)2, (int)array[1]);
        Assertions.assertEquals((int)3, (int)array[2]);
    }

    @Test
    public void testToMap() {
        Map map = ArrayUtils.toMap((Object[])new String[][]{{"foo", "bar"}, {"hello", "world"}});
        Assertions.assertEquals((Object)"bar", map.get("foo"));
        Assertions.assertEquals((Object)"world", map.get("hello"));
        Assertions.assertNull((Object)ArrayUtils.toMap(null));
        Assertions.assertThrows(IllegalArgumentException.class, () -> ArrayUtils.toMap((Object[])new String[][]{{"foo", "bar"}, {"short"}}));
        Assertions.assertThrows(IllegalArgumentException.class, () -> ArrayUtils.toMap((Object[])new Object[]{new Object[]{"foo", "bar"}, "illegal type"}));
        Assertions.assertThrows(IllegalArgumentException.class, () -> ArrayUtils.toMap((Object[])new Object[]{new Object[]{"foo", "bar"}, null}));
        map = ArrayUtils.toMap((Object[])new Object[]{new Map.Entry<Object, Object>(){

            @Override
            public boolean equals(Object o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Object getKey() {
                return "foo";
            }

            @Override
            public Object getValue() {
                return "bar";
            }

            @Override
            public int hashCode() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Object setValue(Object value) {
                throw new UnsupportedOperationException();
            }
        }});
        Assertions.assertEquals((Object)"bar", map.get("foo"));
        Assertions.assertEquals(Collections.emptyMap(), (Object)ArrayUtils.toMap((Object[])new Object[0]));
        map = ArrayUtils.toMap((Object[])new Object[][]{{null, null}, {null, null}});
        Assertions.assertEquals(Collections.singletonMap(null, null), (Object)map);
        map = ArrayUtils.toMap((Object[])new Object[][]{{"key", "value2"}, {"key", "value1"}});
        Assertions.assertEquals(Collections.singletonMap("key", "value1"), (Object)map);
    }

    @Test
    public void testToObject_boolean() {
        boolean[] b = null;
        Assertions.assertArrayEquals(null, (Object[])ArrayUtils.toObject(b));
        Assertions.assertSame((Object)ArrayUtils.EMPTY_BOOLEAN_OBJECT_ARRAY, (Object)ArrayUtils.toObject((boolean[])new boolean[0]));
        Assertions.assertArrayEquals((Object[])new Boolean[]{Boolean.TRUE, Boolean.FALSE, Boolean.TRUE}, (Object[])ArrayUtils.toObject((boolean[])new boolean[]{true, false, true}));
    }

    @Test
    public void testToObject_byte() {
        byte[] b = null;
        Assertions.assertArrayEquals(null, (Object[])ArrayUtils.toObject(b));
        Assertions.assertSame((Object)ArrayUtils.EMPTY_BYTE_OBJECT_ARRAY, (Object)ArrayUtils.toObject((byte[])new byte[0]));
        Assertions.assertArrayEquals((Object[])new Byte[]{(byte)-128, (byte)127, (byte)127}, (Object[])ArrayUtils.toObject((byte[])new byte[]{-128, 127, 127}));
    }

    @Test
    public void testToObject_char() {
        char[] b = null;
        Assertions.assertArrayEquals(null, (Object[])ArrayUtils.toObject(b));
        Assertions.assertSame((Object)ArrayUtils.EMPTY_CHARACTER_OBJECT_ARRAY, (Object)ArrayUtils.toObject((char[])new char[0]));
        Assertions.assertArrayEquals((Object[])new Character[]{Character.valueOf('\u0000'), Character.valueOf('\uffff'), Character.valueOf('0')}, (Object[])ArrayUtils.toObject((char[])new char[]{'\u0000', '\uffff', '0'}));
    }

    @Test
    public void testToObject_double() {
        double[] b = null;
        Assertions.assertArrayEquals(null, (Object[])ArrayUtils.toObject(b));
        Assertions.assertSame((Object)ArrayUtils.EMPTY_DOUBLE_OBJECT_ARRAY, (Object)ArrayUtils.toObject((double[])new double[0]));
        Assertions.assertArrayEquals((Object[])new Double[]{Double.MIN_VALUE, Double.MAX_VALUE, 9999999.0}, (Object[])ArrayUtils.toObject((double[])new double[]{Double.MIN_VALUE, Double.MAX_VALUE, 9999999.0}));
    }

    @Test
    public void testToObject_float() {
        float[] b = null;
        Assertions.assertArrayEquals(null, (Object[])ArrayUtils.toObject(b));
        Assertions.assertSame((Object)ArrayUtils.EMPTY_FLOAT_OBJECT_ARRAY, (Object)ArrayUtils.toObject((float[])new float[0]));
        Assertions.assertArrayEquals((Object[])new Float[]{Float.valueOf(Float.MIN_VALUE), Float.valueOf(Float.MAX_VALUE), Float.valueOf(9999999.0f)}, (Object[])ArrayUtils.toObject((float[])new float[]{Float.MIN_VALUE, Float.MAX_VALUE, 9999999.0f}));
    }

    @Test
    public void testToObject_int() {
        int[] b = null;
        Assertions.assertArrayEquals(null, (Object[])ArrayUtils.toObject(b));
        Assertions.assertSame((Object)ArrayUtils.EMPTY_INTEGER_OBJECT_ARRAY, (Object)ArrayUtils.toObject((int[])new int[0]));
        Assertions.assertArrayEquals((Object[])new Integer[]{Integer.MIN_VALUE, Integer.MAX_VALUE, 9999999}, (Object[])ArrayUtils.toObject((int[])new int[]{Integer.MIN_VALUE, Integer.MAX_VALUE, 9999999}));
    }

    @Test
    public void testToObject_long() {
        long[] b = null;
        Assertions.assertArrayEquals(null, (Object[])ArrayUtils.toObject(b));
        Assertions.assertSame((Object)ArrayUtils.EMPTY_LONG_OBJECT_ARRAY, (Object)ArrayUtils.toObject((long[])new long[0]));
        Assertions.assertArrayEquals((Object[])new Long[]{Long.MIN_VALUE, Long.MAX_VALUE, 9999999L}, (Object[])ArrayUtils.toObject((long[])new long[]{Long.MIN_VALUE, Long.MAX_VALUE, 9999999L}));
    }

    @Test
    public void testToObject_short() {
        short[] b = null;
        Assertions.assertArrayEquals(null, (Object[])ArrayUtils.toObject(b));
        Assertions.assertSame((Object)ArrayUtils.EMPTY_SHORT_OBJECT_ARRAY, (Object)ArrayUtils.toObject((short[])new short[0]));
        Assertions.assertArrayEquals((Object[])new Short[]{(short)Short.MIN_VALUE, (short)Short.MAX_VALUE, (short)-27009}, (Object[])ArrayUtils.toObject((short[])new short[]{Short.MIN_VALUE, Short.MAX_VALUE, -27009}));
    }

    @Test
    public void testToPrimitive_boolean() {
        Boolean[] b = null;
        Assertions.assertNull((Object)ArrayUtils.toPrimitive(b));
        Assertions.assertSame((Object)ArrayUtils.EMPTY_BOOLEAN_ARRAY, (Object)ArrayUtils.toPrimitive((Boolean[])new Boolean[0]));
        Assertions.assertArrayEquals((boolean[])new boolean[]{true, false, true}, (boolean[])ArrayUtils.toPrimitive((Boolean[])new Boolean[]{Boolean.TRUE, Boolean.FALSE, Boolean.TRUE}));
        Assertions.assertThrows(NullPointerException.class, () -> ArrayUtils.toPrimitive((Boolean[])new Boolean[]{Boolean.TRUE, null}));
    }

    @Test
    public void testToPrimitive_boolean_boolean() {
        Assertions.assertNull((Object)ArrayUtils.toPrimitive(null, (boolean)false));
        Assertions.assertSame((Object)ArrayUtils.EMPTY_BOOLEAN_ARRAY, (Object)ArrayUtils.toPrimitive((Boolean[])new Boolean[0], (boolean)false));
        Assertions.assertArrayEquals((boolean[])new boolean[]{true, false, true}, (boolean[])ArrayUtils.toPrimitive((Boolean[])new Boolean[]{Boolean.TRUE, Boolean.FALSE, Boolean.TRUE}, (boolean)false));
        Assertions.assertArrayEquals((boolean[])new boolean[]{true, false, false}, (boolean[])ArrayUtils.toPrimitive((Boolean[])new Boolean[]{Boolean.TRUE, null, Boolean.FALSE}, (boolean)false));
        Assertions.assertArrayEquals((boolean[])new boolean[]{true, true, false}, (boolean[])ArrayUtils.toPrimitive((Boolean[])new Boolean[]{Boolean.TRUE, null, Boolean.FALSE}, (boolean)true));
    }

    @Test
    public void testToPrimitive_byte() {
        Byte[] b = null;
        Assertions.assertNull((Object)ArrayUtils.toPrimitive(b));
        Assertions.assertSame((Object)ArrayUtils.EMPTY_BYTE_ARRAY, (Object)ArrayUtils.toPrimitive((Byte[])new Byte[0]));
        Assertions.assertArrayEquals((byte[])new byte[]{-128, 127, 127}, (byte[])ArrayUtils.toPrimitive((Byte[])new Byte[]{(byte)-128, (byte)127, (byte)127}));
        Assertions.assertThrows(NullPointerException.class, () -> ArrayUtils.toPrimitive((Byte[])new Byte[]{(byte)-128, null}));
    }

    @Test
    public void testToPrimitive_byte_byte() {
        Byte[] b = null;
        Assertions.assertNull((Object)ArrayUtils.toPrimitive(b, (byte)-128));
        Assertions.assertSame((Object)ArrayUtils.EMPTY_BYTE_ARRAY, (Object)ArrayUtils.toPrimitive((Byte[])new Byte[0], (byte)1));
        Assertions.assertArrayEquals((byte[])new byte[]{-128, 127, 127}, (byte[])ArrayUtils.toPrimitive((Byte[])new Byte[]{(byte)-128, (byte)127, (byte)127}, (byte)-128));
        Assertions.assertArrayEquals((byte[])new byte[]{-128, 127, 127}, (byte[])ArrayUtils.toPrimitive((Byte[])new Byte[]{(byte)-128, null, (byte)127}, (byte)127));
    }

    @Test
    public void testToPrimitive_char() {
        Character[] b = null;
        Assertions.assertNull((Object)ArrayUtils.toPrimitive(b));
        Assertions.assertSame((Object)ArrayUtils.EMPTY_CHAR_ARRAY, (Object)ArrayUtils.toPrimitive((Character[])new Character[0]));
        Assertions.assertArrayEquals((char[])new char[]{'\u0000', '\uffff', '0'}, (char[])ArrayUtils.toPrimitive((Character[])new Character[]{Character.valueOf('\u0000'), Character.valueOf('\uffff'), Character.valueOf('0')}));
        Assertions.assertThrows(NullPointerException.class, () -> ArrayUtils.toPrimitive((Character[])new Character[]{Character.valueOf('\u0000'), null}));
    }

    @Test
    public void testToPrimitive_char_char() {
        Character[] b = null;
        Assertions.assertNull((Object)ArrayUtils.toPrimitive(b, (char)'\u0000'));
        Assertions.assertSame((Object)ArrayUtils.EMPTY_CHAR_ARRAY, (Object)ArrayUtils.toPrimitive((Character[])new Character[0], (char)'\u0000'));
        Assertions.assertArrayEquals((char[])new char[]{'\u0000', '\uffff', '0'}, (char[])ArrayUtils.toPrimitive((Character[])new Character[]{Character.valueOf('\u0000'), Character.valueOf('\uffff'), Character.valueOf('0')}, (char)'\u0000'));
        Assertions.assertArrayEquals((char[])new char[]{'\u0000', '\uffff', '0'}, (char[])ArrayUtils.toPrimitive((Character[])new Character[]{Character.valueOf('\u0000'), null, Character.valueOf('0')}, (char)'\uffff'));
    }

    @Test
    public void testToPrimitive_double() {
        Double[] b = null;
        Assertions.assertNull((Object)ArrayUtils.toPrimitive(b));
        Assertions.assertSame((Object)ArrayUtils.EMPTY_DOUBLE_ARRAY, (Object)ArrayUtils.toPrimitive((Double[])new Double[0]));
        Assertions.assertArrayEquals((double[])new double[]{Double.MIN_VALUE, Double.MAX_VALUE, 9999999.0}, (double[])ArrayUtils.toPrimitive((Double[])new Double[]{Double.MIN_VALUE, Double.MAX_VALUE, 9999999.0}));
        Assertions.assertThrows(NullPointerException.class, () -> ArrayUtils.toPrimitive((Float[])new Float[]{Float.valueOf(Float.MIN_VALUE), null}));
    }

    @Test
    public void testToPrimitive_double_double() {
        Double[] l = null;
        Assertions.assertNull((Object)ArrayUtils.toPrimitive(l, (double)Double.MIN_VALUE));
        Assertions.assertSame((Object)ArrayUtils.EMPTY_DOUBLE_ARRAY, (Object)ArrayUtils.toPrimitive((Double[])new Double[0], (double)1.0));
        Assertions.assertArrayEquals((double[])new double[]{Double.MIN_VALUE, Double.MAX_VALUE, 9999999.0}, (double[])ArrayUtils.toPrimitive((Double[])new Double[]{Double.MIN_VALUE, Double.MAX_VALUE, 9999999.0}, (double)1.0));
        Assertions.assertArrayEquals((double[])new double[]{Double.MIN_VALUE, Double.MAX_VALUE, 9999999.0}, (double[])ArrayUtils.toPrimitive((Double[])new Double[]{Double.MIN_VALUE, null, 9999999.0}, (double)Double.MAX_VALUE));
    }

    @Test
    public void testToPrimitive_float() {
        Float[] b = null;
        Assertions.assertNull((Object)ArrayUtils.toPrimitive(b));
        Assertions.assertSame((Object)ArrayUtils.EMPTY_FLOAT_ARRAY, (Object)ArrayUtils.toPrimitive((Float[])new Float[0]));
        Assertions.assertArrayEquals((float[])new float[]{Float.MIN_VALUE, Float.MAX_VALUE, 9999999.0f}, (float[])ArrayUtils.toPrimitive((Float[])new Float[]{Float.valueOf(Float.MIN_VALUE), Float.valueOf(Float.MAX_VALUE), Float.valueOf(9999999.0f)}));
        Assertions.assertThrows(NullPointerException.class, () -> ArrayUtils.toPrimitive((Float[])new Float[]{Float.valueOf(Float.MIN_VALUE), null}));
    }

    @Test
    public void testToPrimitive_float_float() {
        Float[] l = null;
        Assertions.assertNull((Object)ArrayUtils.toPrimitive(l, (float)Float.MIN_VALUE));
        Assertions.assertSame((Object)ArrayUtils.EMPTY_FLOAT_ARRAY, (Object)ArrayUtils.toPrimitive((Float[])new Float[0], (float)1.0f));
        Assertions.assertArrayEquals((float[])new float[]{Float.MIN_VALUE, Float.MAX_VALUE, 9999999.0f}, (float[])ArrayUtils.toPrimitive((Float[])new Float[]{Float.valueOf(Float.MIN_VALUE), Float.valueOf(Float.MAX_VALUE), Float.valueOf(9999999.0f)}, (float)1.0f));
        Assertions.assertArrayEquals((float[])new float[]{Float.MIN_VALUE, Float.MAX_VALUE, 9999999.0f}, (float[])ArrayUtils.toPrimitive((Float[])new Float[]{Float.valueOf(Float.MIN_VALUE), null, Float.valueOf(9999999.0f)}, (float)Float.MAX_VALUE));
    }

    @Test
    public void testToPrimitive_int() {
        Integer[] b = null;
        Assertions.assertNull((Object)ArrayUtils.toPrimitive(b));
        Assertions.assertSame((Object)ArrayUtils.EMPTY_INT_ARRAY, (Object)ArrayUtils.toPrimitive((Integer[])new Integer[0]));
        Assertions.assertArrayEquals((int[])new int[]{Integer.MIN_VALUE, Integer.MAX_VALUE, 9999999}, (int[])ArrayUtils.toPrimitive((Integer[])new Integer[]{Integer.MIN_VALUE, Integer.MAX_VALUE, 9999999}));
        Assertions.assertThrows(NullPointerException.class, () -> ArrayUtils.toPrimitive((Integer[])new Integer[]{Integer.MIN_VALUE, null}));
    }

    @Test
    public void testToPrimitive_int_int() {
        Long[] l = null;
        Assertions.assertNull((Object)ArrayUtils.toPrimitive(l, (long)Integer.MIN_VALUE));
        Assertions.assertSame((Object)ArrayUtils.EMPTY_INT_ARRAY, (Object)ArrayUtils.toPrimitive((Integer[])new Integer[0], (int)1));
        Assertions.assertArrayEquals((int[])new int[]{Integer.MIN_VALUE, Integer.MAX_VALUE, 9999999}, (int[])ArrayUtils.toPrimitive((Integer[])new Integer[]{Integer.MIN_VALUE, Integer.MAX_VALUE, 9999999}, (int)1));
        Assertions.assertArrayEquals((int[])new int[]{Integer.MIN_VALUE, Integer.MAX_VALUE, 9999999}, (int[])ArrayUtils.toPrimitive((Integer[])new Integer[]{Integer.MIN_VALUE, null, 9999999}, (int)Integer.MAX_VALUE));
    }

    @Test
    public void testToPrimitive_intNull() {
        Integer[] iArray = null;
        Assertions.assertNull((Object)ArrayUtils.toPrimitive(iArray, (int)Integer.MIN_VALUE));
    }

    @Test
    public void testToPrimitive_long() {
        Long[] b = null;
        Assertions.assertNull((Object)ArrayUtils.toPrimitive(b));
        Assertions.assertSame((Object)ArrayUtils.EMPTY_LONG_ARRAY, (Object)ArrayUtils.toPrimitive((Long[])new Long[0]));
        Assertions.assertArrayEquals((long[])new long[]{Long.MIN_VALUE, Long.MAX_VALUE, 9999999L}, (long[])ArrayUtils.toPrimitive((Long[])new Long[]{Long.MIN_VALUE, Long.MAX_VALUE, 9999999L}));
        Assertions.assertThrows(NullPointerException.class, () -> ArrayUtils.toPrimitive((Long[])new Long[]{Long.MIN_VALUE, null}));
    }

    @Test
    public void testToPrimitive_long_long() {
        Long[] l = null;
        Assertions.assertNull((Object)ArrayUtils.toPrimitive(l, (long)Long.MIN_VALUE));
        Assertions.assertSame((Object)ArrayUtils.EMPTY_LONG_ARRAY, (Object)ArrayUtils.toPrimitive((Long[])new Long[0], (long)1L));
        Assertions.assertArrayEquals((long[])new long[]{Long.MIN_VALUE, Long.MAX_VALUE, 9999999L}, (long[])ArrayUtils.toPrimitive((Long[])new Long[]{Long.MIN_VALUE, Long.MAX_VALUE, 9999999L}, (long)1L));
        Assertions.assertArrayEquals((long[])new long[]{Long.MIN_VALUE, Long.MAX_VALUE, 9999999L}, (long[])ArrayUtils.toPrimitive((Long[])new Long[]{Long.MIN_VALUE, null, 9999999L}, (long)Long.MAX_VALUE));
    }

    @Test
    public void testToPrimitive_short() {
        Short[] b = null;
        Assertions.assertNull((Object)ArrayUtils.toPrimitive(b));
        Assertions.assertSame((Object)ArrayUtils.EMPTY_SHORT_ARRAY, (Object)ArrayUtils.toPrimitive((Short[])new Short[0]));
        Assertions.assertArrayEquals((short[])new short[]{Short.MIN_VALUE, Short.MAX_VALUE, -27009}, (short[])ArrayUtils.toPrimitive((Short[])new Short[]{(short)Short.MIN_VALUE, (short)Short.MAX_VALUE, (short)-27009}));
        Assertions.assertThrows(NullPointerException.class, () -> ArrayUtils.toPrimitive((Short[])new Short[]{(short)Short.MIN_VALUE, null}));
    }

    @Test
    public void testToPrimitive_short_short() {
        Short[] s = null;
        Assertions.assertNull((Object)ArrayUtils.toPrimitive(s, (short)Short.MIN_VALUE));
        Assertions.assertSame((Object)ArrayUtils.EMPTY_SHORT_ARRAY, (Object)ArrayUtils.toPrimitive((Short[])new Short[0], (short)Short.MIN_VALUE));
        Assertions.assertArrayEquals((short[])new short[]{Short.MIN_VALUE, Short.MAX_VALUE, -27009}, (short[])ArrayUtils.toPrimitive((Short[])new Short[]{(short)Short.MIN_VALUE, (short)Short.MAX_VALUE, (short)-27009}, (short)Short.MIN_VALUE));
        Assertions.assertArrayEquals((short[])new short[]{Short.MIN_VALUE, Short.MAX_VALUE, -27009}, (short[])ArrayUtils.toPrimitive((Short[])new Short[]{(short)Short.MIN_VALUE, null, (short)-27009}, (short)Short.MAX_VALUE));
    }

    @Test
    public void testToString() {
        Assertions.assertEquals((Object)"{}", (Object)ArrayUtils.toString(null));
        Assertions.assertEquals((Object)"{}", (Object)ArrayUtils.toString((Object)new Object[0]));
        Assertions.assertEquals((Object)"{}", (Object)ArrayUtils.toString((Object)new String[0]));
        Assertions.assertEquals((Object)"{<null>}", (Object)ArrayUtils.toString((Object)new String[]{null}));
        Assertions.assertEquals((Object)"{pink,blue}", (Object)ArrayUtils.toString((Object)new String[]{"pink", "blue"}));
        Assertions.assertEquals((Object)"<empty>", (Object)ArrayUtils.toString(null, (String)"<empty>"));
        Assertions.assertEquals((Object)"{}", (Object)ArrayUtils.toString((Object)new Object[0], (String)"<empty>"));
        Assertions.assertEquals((Object)"{}", (Object)ArrayUtils.toString((Object)new String[0], (String)"<empty>"));
        Assertions.assertEquals((Object)"{<null>}", (Object)ArrayUtils.toString((Object)new String[]{null}, (String)"<empty>"));
        Assertions.assertEquals((Object)"{pink,blue}", (Object)ArrayUtils.toString((Object)new String[]{"pink", "blue"}, (String)"<empty>"));
    }

    @Test
    public void testToStringArray_array() {
        Assertions.assertNull((Object)ArrayUtils.toStringArray(null));
        Assertions.assertArrayEquals((Object[])new String[0], (Object[])ArrayUtils.toStringArray((Object[])new Object[0]));
        Object[] array = new Object[]{1, 2, 3, "array", "test"};
        Assertions.assertArrayEquals((Object[])new String[]{"1", "2", "3", "array", "test"}, (Object[])ArrayUtils.toStringArray((Object[])array));
        Assertions.assertThrows(NullPointerException.class, () -> ArrayUtils.toStringArray((Object[])new Object[]{null}));
    }

    @Test
    public void testToStringArray_array_string() {
        Assertions.assertNull((Object)ArrayUtils.toStringArray(null, (String)""));
        Assertions.assertArrayEquals((Object[])new String[0], (Object[])ArrayUtils.toStringArray((Object[])new Object[0], (String)""));
        Object[] array = new Object[]{1, null, "test"};
        Assertions.assertArrayEquals((Object[])new String[]{"1", "valueForNullElements", "test"}, (Object[])ArrayUtils.toStringArray((Object[])array, (String)"valueForNullElements"));
    }

    @Test
    public void textIndexesOfInt() {
        int[] array = null;
        BitSet emptySet = new BitSet();
        BitSet testSet = new BitSet();
        Assertions.assertEquals((Object)emptySet, (Object)ArrayUtils.indexesOf(array, (int)0));
        array = new int[]{0, 1, 2, 3, 0};
        testSet.set(0);
        testSet.set(4);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((int[])array, (int)0));
        testSet.clear();
        testSet.set(1);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((int[])array, (int)1));
        testSet.clear();
        testSet.set(2);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((int[])array, (int)2));
        testSet.clear();
        testSet.set(3);
        Assertions.assertEquals((Object)testSet, (Object)ArrayUtils.indexesOf((int[])array, (int)3));
        Assertions.assertEquals((Object)emptySet, (Object)ArrayUtils.indexesOf((int[])array, (int)99));
    }

    private static /* synthetic */ void lambda$testSubarrayObject$6(java.util.Date[] dateArray) throws Throwable {
        Date[] cfr_ignored_0 = (Date[])Date[].class.cast(ArrayUtils.subarray((Object[])dateArray, (int)1, (int)3));
    }

    private class TestClass {
        private TestClass() {
        }
    }
}

