/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import org.apache.commons.lang3.BooleanUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BooleanUtilsTest {
    @Test
    public void testConstructor() {
        Assertions.assertNotNull((Object)new BooleanUtils());
        Constructor<?>[] cons = BooleanUtils.class.getDeclaredConstructors();
        Assertions.assertEquals((int)1, (int)cons.length);
        Assertions.assertTrue((boolean)Modifier.isPublic(cons[0].getModifiers()));
        Assertions.assertTrue((boolean)Modifier.isPublic(BooleanUtils.class.getModifiers()));
        Assertions.assertFalse((boolean)Modifier.isFinal(BooleanUtils.class.getModifiers()));
    }

    @Test
    public void test_negate_Boolean() {
        Assertions.assertSame(null, (Object)BooleanUtils.negate(null));
        Assertions.assertSame((Object)Boolean.TRUE, (Object)BooleanUtils.negate((Boolean)Boolean.FALSE));
        Assertions.assertSame((Object)Boolean.FALSE, (Object)BooleanUtils.negate((Boolean)Boolean.TRUE));
    }

    @Test
    public void test_isTrue_Boolean() {
        Assertions.assertTrue((boolean)BooleanUtils.isTrue((Boolean)Boolean.TRUE));
        Assertions.assertFalse((boolean)BooleanUtils.isTrue((Boolean)Boolean.FALSE));
        Assertions.assertFalse((boolean)BooleanUtils.isTrue(null));
    }

    @Test
    public void test_isNotTrue_Boolean() {
        Assertions.assertFalse((boolean)BooleanUtils.isNotTrue((Boolean)Boolean.TRUE));
        Assertions.assertTrue((boolean)BooleanUtils.isNotTrue((Boolean)Boolean.FALSE));
        Assertions.assertTrue((boolean)BooleanUtils.isNotTrue(null));
    }

    @Test
    public void test_isFalse_Boolean() {
        Assertions.assertFalse((boolean)BooleanUtils.isFalse((Boolean)Boolean.TRUE));
        Assertions.assertTrue((boolean)BooleanUtils.isFalse((Boolean)Boolean.FALSE));
        Assertions.assertFalse((boolean)BooleanUtils.isFalse(null));
    }

    @Test
    public void test_isNotFalse_Boolean() {
        Assertions.assertTrue((boolean)BooleanUtils.isNotFalse((Boolean)Boolean.TRUE));
        Assertions.assertFalse((boolean)BooleanUtils.isNotFalse((Boolean)Boolean.FALSE));
        Assertions.assertTrue((boolean)BooleanUtils.isNotFalse(null));
    }

    @Test
    public void test_toBoolean_Boolean() {
        Assertions.assertTrue((boolean)BooleanUtils.toBoolean((Boolean)Boolean.TRUE));
        Assertions.assertFalse((boolean)BooleanUtils.toBoolean((Boolean)Boolean.FALSE));
        Assertions.assertFalse((boolean)BooleanUtils.toBoolean((Boolean)null));
    }

    @Test
    public void test_toBooleanDefaultIfNull_Boolean_boolean() {
        Assertions.assertTrue((boolean)BooleanUtils.toBooleanDefaultIfNull((Boolean)Boolean.TRUE, (boolean)true));
        Assertions.assertTrue((boolean)BooleanUtils.toBooleanDefaultIfNull((Boolean)Boolean.TRUE, (boolean)false));
        Assertions.assertFalse((boolean)BooleanUtils.toBooleanDefaultIfNull((Boolean)Boolean.FALSE, (boolean)true));
        Assertions.assertFalse((boolean)BooleanUtils.toBooleanDefaultIfNull((Boolean)Boolean.FALSE, (boolean)false));
        Assertions.assertTrue((boolean)BooleanUtils.toBooleanDefaultIfNull(null, (boolean)true));
        Assertions.assertFalse((boolean)BooleanUtils.toBooleanDefaultIfNull(null, (boolean)false));
    }

    @Test
    public void test_toBoolean_int() {
        Assertions.assertTrue((boolean)BooleanUtils.toBoolean((int)1));
        Assertions.assertTrue((boolean)BooleanUtils.toBoolean((int)-1));
        Assertions.assertFalse((boolean)BooleanUtils.toBoolean((int)0));
    }

    @Test
    public void test_toBooleanObject_int() {
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)BooleanUtils.toBooleanObject((int)1));
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)BooleanUtils.toBooleanObject((int)-1));
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)BooleanUtils.toBooleanObject((int)0));
    }

    @Test
    public void test_toBooleanObject_Integer() {
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)BooleanUtils.toBooleanObject((Integer)1));
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)BooleanUtils.toBooleanObject((Integer)-1));
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)BooleanUtils.toBooleanObject((Integer)0));
        Assertions.assertNull((Object)BooleanUtils.toBooleanObject((Integer)null));
    }

    @Test
    public void test_toBoolean_int_int_int() {
        Assertions.assertTrue((boolean)BooleanUtils.toBoolean((int)6, (int)6, (int)7));
        Assertions.assertFalse((boolean)BooleanUtils.toBoolean((int)7, (int)6, (int)7));
    }

    @Test
    public void test_toBoolean_int_int_int_noMatch() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> BooleanUtils.toBoolean((int)8, (int)6, (int)7));
    }

    @Test
    public void test_toBoolean_Integer_Integer_Integer() {
        Integer six = 6;
        Integer seven = 7;
        Assertions.assertTrue((boolean)BooleanUtils.toBoolean(null, null, (Integer)seven));
        Assertions.assertFalse((boolean)BooleanUtils.toBoolean(null, (Integer)six, null));
        Assertions.assertTrue((boolean)BooleanUtils.toBoolean((Integer)6, (Integer)six, (Integer)seven));
        Assertions.assertFalse((boolean)BooleanUtils.toBoolean((Integer)7, (Integer)six, (Integer)seven));
    }

    @Test
    public void test_toBoolean_Integer_Integer_Integer_nullValue() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> BooleanUtils.toBoolean(null, (Integer)6, (Integer)7));
    }

    @Test
    public void test_toBoolean_Integer_Integer_Integer_noMatch() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> BooleanUtils.toBoolean((Integer)8, (Integer)6, (Integer)7));
    }

    @Test
    public void test_toBooleanObject_int_int_int() {
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)BooleanUtils.toBooleanObject((int)6, (int)6, (int)7, (int)8));
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)BooleanUtils.toBooleanObject((int)7, (int)6, (int)7, (int)8));
        Assertions.assertNull((Object)BooleanUtils.toBooleanObject((int)8, (int)6, (int)7, (int)8));
    }

    @Test
    public void test_toBooleanObject_int_int_int_noMatch() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> BooleanUtils.toBooleanObject((int)9, (int)6, (int)7, (int)8));
    }

    @Test
    public void test_toBooleanObject_Integer_Integer_Integer_Integer() {
        Integer six = 6;
        Integer seven = 7;
        Integer eight = 8;
        Assertions.assertSame((Object)Boolean.TRUE, (Object)BooleanUtils.toBooleanObject(null, null, (Integer)seven, (Integer)eight));
        Assertions.assertSame((Object)Boolean.FALSE, (Object)BooleanUtils.toBooleanObject(null, (Integer)six, null, (Integer)eight));
        Assertions.assertSame(null, (Object)BooleanUtils.toBooleanObject(null, (Integer)six, (Integer)seven, null));
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)BooleanUtils.toBooleanObject((Integer)6, (Integer)six, (Integer)seven, (Integer)eight));
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)BooleanUtils.toBooleanObject((Integer)7, (Integer)six, (Integer)seven, (Integer)eight));
        Assertions.assertNull((Object)BooleanUtils.toBooleanObject((Integer)8, (Integer)six, (Integer)seven, (Integer)eight));
    }

    @Test
    public void test_toBooleanObject_Integer_Integer_Integer_Integer_nullValue() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> BooleanUtils.toBooleanObject(null, (Integer)6, (Integer)7, (Integer)8));
    }

    @Test
    public void test_toBooleanObject_Integer_Integer_Integer_Integer_noMatch() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> BooleanUtils.toBooleanObject((Integer)9, (Integer)6, (Integer)7, (Integer)8));
    }

    @Test
    public void test_toInteger_boolean() {
        Assertions.assertEquals((int)1, (int)BooleanUtils.toInteger((boolean)true));
        Assertions.assertEquals((int)0, (int)BooleanUtils.toInteger((boolean)false));
    }

    @Test
    public void test_toIntegerObject_boolean() {
        Assertions.assertEquals((Integer)1, (Integer)BooleanUtils.toIntegerObject((boolean)true));
        Assertions.assertEquals((Integer)0, (Integer)BooleanUtils.toIntegerObject((boolean)false));
    }

    @Test
    public void test_toIntegerObject_Boolean() {
        Assertions.assertEquals((Integer)1, (Integer)BooleanUtils.toIntegerObject((Boolean)Boolean.TRUE));
        Assertions.assertEquals((Integer)0, (Integer)BooleanUtils.toIntegerObject((Boolean)Boolean.FALSE));
        Assertions.assertNull((Object)BooleanUtils.toIntegerObject(null));
    }

    @Test
    public void test_toInteger_boolean_int_int() {
        Assertions.assertEquals((int)6, (int)BooleanUtils.toInteger((boolean)true, (int)6, (int)7));
        Assertions.assertEquals((int)7, (int)BooleanUtils.toInteger((boolean)false, (int)6, (int)7));
    }

    @Test
    public void test_toInteger_Boolean_int_int_int() {
        Assertions.assertEquals((int)6, (int)BooleanUtils.toInteger((Boolean)Boolean.TRUE, (int)6, (int)7, (int)8));
        Assertions.assertEquals((int)7, (int)BooleanUtils.toInteger((Boolean)Boolean.FALSE, (int)6, (int)7, (int)8));
        Assertions.assertEquals((int)8, (int)BooleanUtils.toInteger(null, (int)6, (int)7, (int)8));
    }

    @Test
    public void test_toIntegerObject_boolean_Integer_Integer() {
        Integer six = 6;
        Integer seven = 7;
        Assertions.assertEquals((Integer)six, (Integer)BooleanUtils.toIntegerObject((boolean)true, (Integer)six, (Integer)seven));
        Assertions.assertEquals((Integer)seven, (Integer)BooleanUtils.toIntegerObject((boolean)false, (Integer)six, (Integer)seven));
    }

    @Test
    public void test_toIntegerObject_Boolean_Integer_Integer_Integer() {
        Integer six = 6;
        Integer seven = 7;
        Integer eight = 8;
        Assertions.assertEquals((Integer)six, (Integer)BooleanUtils.toIntegerObject((Boolean)Boolean.TRUE, (Integer)six, (Integer)seven, (Integer)eight));
        Assertions.assertEquals((Integer)seven, (Integer)BooleanUtils.toIntegerObject((Boolean)Boolean.FALSE, (Integer)six, (Integer)seven, (Integer)eight));
        Assertions.assertEquals((Integer)eight, (Integer)BooleanUtils.toIntegerObject(null, (Integer)six, (Integer)seven, (Integer)eight));
        Assertions.assertNull((Object)BooleanUtils.toIntegerObject(null, (Integer)six, (Integer)seven, null));
    }

    @Test
    public void test_toBooleanObject_String() {
        Assertions.assertNull((Object)BooleanUtils.toBooleanObject((String)null));
        Assertions.assertNull((Object)BooleanUtils.toBooleanObject((String)""));
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)BooleanUtils.toBooleanObject((String)"false"));
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)BooleanUtils.toBooleanObject((String)"no"));
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)BooleanUtils.toBooleanObject((String)"off"));
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)BooleanUtils.toBooleanObject((String)"FALSE"));
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)BooleanUtils.toBooleanObject((String)"NO"));
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)BooleanUtils.toBooleanObject((String)"OFF"));
        Assertions.assertNull((Object)BooleanUtils.toBooleanObject((String)"oof"));
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)BooleanUtils.toBooleanObject((String)"true"));
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)BooleanUtils.toBooleanObject((String)"yes"));
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)BooleanUtils.toBooleanObject((String)"on"));
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)BooleanUtils.toBooleanObject((String)"TRUE"));
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)BooleanUtils.toBooleanObject((String)"ON"));
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)BooleanUtils.toBooleanObject((String)"YES"));
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)BooleanUtils.toBooleanObject((String)"TruE"));
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)BooleanUtils.toBooleanObject((String)"TruE"));
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)BooleanUtils.toBooleanObject((String)"y"));
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)BooleanUtils.toBooleanObject((String)"Y"));
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)BooleanUtils.toBooleanObject((String)"t"));
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)BooleanUtils.toBooleanObject((String)"T"));
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)BooleanUtils.toBooleanObject((String)"1"));
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)BooleanUtils.toBooleanObject((String)"f"));
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)BooleanUtils.toBooleanObject((String)"F"));
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)BooleanUtils.toBooleanObject((String)"n"));
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)BooleanUtils.toBooleanObject((String)"N"));
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)BooleanUtils.toBooleanObject((String)"0"));
        Assertions.assertNull((Object)BooleanUtils.toBooleanObject((String)"z"));
        Assertions.assertNull((Object)BooleanUtils.toBooleanObject((String)"ab"));
        Assertions.assertNull((Object)BooleanUtils.toBooleanObject((String)"yoo"));
        Assertions.assertNull((Object)BooleanUtils.toBooleanObject((String)"true "));
        Assertions.assertNull((Object)BooleanUtils.toBooleanObject((String)"ono"));
    }

    @Test
    public void test_toBooleanObject_String_String_String_String() {
        Assertions.assertSame((Object)Boolean.TRUE, (Object)BooleanUtils.toBooleanObject(null, null, (String)"N", (String)"U"));
        Assertions.assertSame((Object)Boolean.FALSE, (Object)BooleanUtils.toBooleanObject(null, (String)"Y", null, (String)"U"));
        Assertions.assertSame(null, (Object)BooleanUtils.toBooleanObject(null, (String)"Y", (String)"N", null));
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)BooleanUtils.toBooleanObject((String)"Y", (String)"Y", (String)"N", (String)"U"));
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)BooleanUtils.toBooleanObject((String)"N", (String)"Y", (String)"N", (String)"U"));
        Assertions.assertNull((Object)BooleanUtils.toBooleanObject((String)"U", (String)"Y", (String)"N", (String)"U"));
    }

    @Test
    public void test_toBooleanObject_String_String_String_String_nullValue() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> BooleanUtils.toBooleanObject(null, (String)"Y", (String)"N", (String)"U"));
    }

    @Test
    public void test_toBooleanObject_String_String_String_String_noMatch() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> BooleanUtils.toBooleanObject((String)"X", (String)"Y", (String)"N", (String)"U"));
    }

    @Test
    public void test_toBoolean_String() {
        Assertions.assertFalse((boolean)BooleanUtils.toBoolean((String)null));
        Assertions.assertFalse((boolean)BooleanUtils.toBoolean((String)""));
        Assertions.assertFalse((boolean)BooleanUtils.toBoolean((String)"off"));
        Assertions.assertFalse((boolean)BooleanUtils.toBoolean((String)"oof"));
        Assertions.assertFalse((boolean)BooleanUtils.toBoolean((String)"yep"));
        Assertions.assertFalse((boolean)BooleanUtils.toBoolean((String)"trux"));
        Assertions.assertFalse((boolean)BooleanUtils.toBoolean((String)"false"));
        Assertions.assertFalse((boolean)BooleanUtils.toBoolean((String)"a"));
        Assertions.assertTrue((boolean)BooleanUtils.toBoolean((String)"true"));
        Assertions.assertTrue((boolean)BooleanUtils.toBoolean((String)("tr" + "ue")));
        Assertions.assertTrue((boolean)BooleanUtils.toBoolean((String)"truE"));
        Assertions.assertTrue((boolean)BooleanUtils.toBoolean((String)"trUe"));
        Assertions.assertTrue((boolean)BooleanUtils.toBoolean((String)"trUE"));
        Assertions.assertTrue((boolean)BooleanUtils.toBoolean((String)"tRue"));
        Assertions.assertTrue((boolean)BooleanUtils.toBoolean((String)"tRuE"));
        Assertions.assertTrue((boolean)BooleanUtils.toBoolean((String)"tRUe"));
        Assertions.assertTrue((boolean)BooleanUtils.toBoolean((String)"tRUE"));
        Assertions.assertTrue((boolean)BooleanUtils.toBoolean((String)"TRUE"));
        Assertions.assertTrue((boolean)BooleanUtils.toBoolean((String)"TRUe"));
        Assertions.assertTrue((boolean)BooleanUtils.toBoolean((String)"TRuE"));
        Assertions.assertTrue((boolean)BooleanUtils.toBoolean((String)"TRue"));
        Assertions.assertTrue((boolean)BooleanUtils.toBoolean((String)"TrUE"));
        Assertions.assertTrue((boolean)BooleanUtils.toBoolean((String)"TrUe"));
        Assertions.assertTrue((boolean)BooleanUtils.toBoolean((String)"TruE"));
        Assertions.assertTrue((boolean)BooleanUtils.toBoolean((String)"True"));
        Assertions.assertTrue((boolean)BooleanUtils.toBoolean((String)"on"));
        Assertions.assertTrue((boolean)BooleanUtils.toBoolean((String)"oN"));
        Assertions.assertTrue((boolean)BooleanUtils.toBoolean((String)"On"));
        Assertions.assertTrue((boolean)BooleanUtils.toBoolean((String)"ON"));
        Assertions.assertTrue((boolean)BooleanUtils.toBoolean((String)"yes"));
        Assertions.assertTrue((boolean)BooleanUtils.toBoolean((String)"yeS"));
        Assertions.assertTrue((boolean)BooleanUtils.toBoolean((String)"yEs"));
        Assertions.assertTrue((boolean)BooleanUtils.toBoolean((String)"yES"));
        Assertions.assertTrue((boolean)BooleanUtils.toBoolean((String)"Yes"));
        Assertions.assertTrue((boolean)BooleanUtils.toBoolean((String)"YeS"));
        Assertions.assertTrue((boolean)BooleanUtils.toBoolean((String)"YEs"));
        Assertions.assertTrue((boolean)BooleanUtils.toBoolean((String)"YES"));
        Assertions.assertTrue((boolean)BooleanUtils.toBoolean((String)"1"));
        Assertions.assertFalse((boolean)BooleanUtils.toBoolean((String)"yes?"));
        Assertions.assertFalse((boolean)BooleanUtils.toBoolean((String)"0"));
        Assertions.assertFalse((boolean)BooleanUtils.toBoolean((String)"tru"));
        Assertions.assertFalse((boolean)BooleanUtils.toBoolean((String)"no"));
        Assertions.assertFalse((boolean)BooleanUtils.toBoolean((String)"off"));
        Assertions.assertFalse((boolean)BooleanUtils.toBoolean((String)"yoo"));
    }

    @Test
    public void test_toBoolean_String_String_String() {
        Assertions.assertTrue((boolean)BooleanUtils.toBoolean(null, null, (String)"N"));
        Assertions.assertFalse((boolean)BooleanUtils.toBoolean(null, (String)"Y", null));
        Assertions.assertTrue((boolean)BooleanUtils.toBoolean((String)"Y", (String)"Y", (String)"N"));
        Assertions.assertTrue((boolean)BooleanUtils.toBoolean((String)"Y", (String)new String("Y"), (String)new String("N")));
        Assertions.assertFalse((boolean)BooleanUtils.toBoolean((String)"N", (String)"Y", (String)"N"));
        Assertions.assertFalse((boolean)BooleanUtils.toBoolean((String)"N", (String)new String("Y"), (String)new String("N")));
        Assertions.assertTrue((boolean)BooleanUtils.toBoolean((String)null, null, null));
        Assertions.assertTrue((boolean)BooleanUtils.toBoolean((String)"Y", (String)"Y", (String)"Y"));
        Assertions.assertTrue((boolean)BooleanUtils.toBoolean((String)"Y", (String)new String("Y"), (String)new String("Y")));
    }

    @Test
    public void test_toBoolean_String_String_String_nullValue() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> BooleanUtils.toBoolean(null, (String)"Y", (String)"N"));
    }

    @Test
    public void test_toBoolean_String_String_String_noMatch() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> BooleanUtils.toBoolean((String)"X", (String)"Y", (String)"N"));
    }

    @Test
    public void test_toStringTrueFalse_Boolean() {
        Assertions.assertNull((Object)BooleanUtils.toStringTrueFalse(null));
        Assertions.assertEquals((Object)"true", (Object)BooleanUtils.toStringTrueFalse((Boolean)Boolean.TRUE));
        Assertions.assertEquals((Object)"false", (Object)BooleanUtils.toStringTrueFalse((Boolean)Boolean.FALSE));
    }

    @Test
    public void test_toStringOnOff_Boolean() {
        Assertions.assertNull((Object)BooleanUtils.toStringOnOff(null));
        Assertions.assertEquals((Object)"on", (Object)BooleanUtils.toStringOnOff((Boolean)Boolean.TRUE));
        Assertions.assertEquals((Object)"off", (Object)BooleanUtils.toStringOnOff((Boolean)Boolean.FALSE));
    }

    @Test
    public void test_toStringYesNo_Boolean() {
        Assertions.assertNull((Object)BooleanUtils.toStringYesNo(null));
        Assertions.assertEquals((Object)"yes", (Object)BooleanUtils.toStringYesNo((Boolean)Boolean.TRUE));
        Assertions.assertEquals((Object)"no", (Object)BooleanUtils.toStringYesNo((Boolean)Boolean.FALSE));
    }

    @Test
    public void test_toString_Boolean_String_String_String() {
        Assertions.assertEquals((Object)"U", (Object)BooleanUtils.toString(null, (String)"Y", (String)"N", (String)"U"));
        Assertions.assertEquals((Object)"Y", (Object)BooleanUtils.toString((Boolean)Boolean.TRUE, (String)"Y", (String)"N", (String)"U"));
        Assertions.assertEquals((Object)"N", (Object)BooleanUtils.toString((Boolean)Boolean.FALSE, (String)"Y", (String)"N", (String)"U"));
    }

    @Test
    public void test_toStringTrueFalse_boolean() {
        Assertions.assertEquals((Object)"true", (Object)BooleanUtils.toStringTrueFalse((boolean)true));
        Assertions.assertEquals((Object)"false", (Object)BooleanUtils.toStringTrueFalse((boolean)false));
    }

    @Test
    public void test_toStringOnOff_boolean() {
        Assertions.assertEquals((Object)"on", (Object)BooleanUtils.toStringOnOff((boolean)true));
        Assertions.assertEquals((Object)"off", (Object)BooleanUtils.toStringOnOff((boolean)false));
    }

    @Test
    public void test_toStringYesNo_boolean() {
        Assertions.assertEquals((Object)"yes", (Object)BooleanUtils.toStringYesNo((boolean)true));
        Assertions.assertEquals((Object)"no", (Object)BooleanUtils.toStringYesNo((boolean)false));
    }

    @Test
    public void test_toString_boolean_String_String_String() {
        Assertions.assertEquals((Object)"Y", (Object)BooleanUtils.toString((boolean)true, (String)"Y", (String)"N"));
        Assertions.assertEquals((Object)"N", (Object)BooleanUtils.toString((boolean)false, (String)"Y", (String)"N"));
    }

    @Test
    public void testXor_primitive_nullInput() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> BooleanUtils.xor((boolean[])null));
    }

    @Test
    public void testXor_primitive_emptyInput() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> BooleanUtils.xor((boolean[])new boolean[0]));
    }

    @Test
    public void testXor_primitive_validInput_2items() {
        Assertions.assertEquals((Object)false, (Object)BooleanUtils.xor((boolean[])new boolean[]{true, true}), (String)"true ^ true");
        Assertions.assertEquals((Object)false, (Object)BooleanUtils.xor((boolean[])new boolean[]{false, false}), (String)"false ^ false");
        Assertions.assertEquals((Object)true, (Object)BooleanUtils.xor((boolean[])new boolean[]{true, false}), (String)"true ^ false");
        Assertions.assertEquals((Object)true, (Object)BooleanUtils.xor((boolean[])new boolean[]{false, true}), (String)"false ^ true");
    }

    @Test
    public void testXor_primitive_validInput_3items() {
        Assertions.assertEquals((Object)false, (Object)BooleanUtils.xor((boolean[])new boolean[]{false, false, false}), (String)"false ^ false ^ false");
        Assertions.assertEquals((Object)true, (Object)BooleanUtils.xor((boolean[])new boolean[]{false, false, true}), (String)"false ^ false ^ true");
        Assertions.assertEquals((Object)true, (Object)BooleanUtils.xor((boolean[])new boolean[]{false, true, false}), (String)"false ^ true ^ false");
        Assertions.assertEquals((Object)false, (Object)BooleanUtils.xor((boolean[])new boolean[]{false, true, true}), (String)"false ^ true ^ true");
        Assertions.assertEquals((Object)true, (Object)BooleanUtils.xor((boolean[])new boolean[]{true, false, false}), (String)"true ^ false ^ false");
        Assertions.assertEquals((Object)false, (Object)BooleanUtils.xor((boolean[])new boolean[]{true, false, true}), (String)"true ^ false ^ true");
        Assertions.assertEquals((Object)false, (Object)BooleanUtils.xor((boolean[])new boolean[]{true, true, false}), (String)"true ^ true ^ false");
        Assertions.assertEquals((Object)true, (Object)BooleanUtils.xor((boolean[])new boolean[]{true, true, true}), (String)"true ^ true ^ true");
    }

    @Test
    public void testXor_object_nullInput() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> BooleanUtils.xor((Boolean[])null));
    }

    @Test
    public void testXor_object_emptyInput() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> BooleanUtils.xor((Boolean[])new Boolean[0]));
    }

    @Test
    public void testXor_object_nullElementInput() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> BooleanUtils.xor((Boolean[])new Boolean[]{null}));
    }

    @Test
    public void testXor_object_validInput_2items() {
        Assertions.assertEquals((Object)false, (Object)BooleanUtils.xor((Boolean[])new Boolean[]{Boolean.FALSE, Boolean.FALSE}), (String)"false ^ false");
        Assertions.assertEquals((Object)true, (Object)BooleanUtils.xor((Boolean[])new Boolean[]{Boolean.FALSE, Boolean.TRUE}), (String)"false ^ true");
        Assertions.assertEquals((Object)true, (Object)BooleanUtils.xor((Boolean[])new Boolean[]{Boolean.TRUE, Boolean.FALSE}), (String)"true ^ false");
        Assertions.assertEquals((Object)false, (Object)BooleanUtils.xor((Boolean[])new Boolean[]{Boolean.TRUE, Boolean.TRUE}), (String)"true ^ true");
    }

    @Test
    public void testXor_object_validInput_3items() {
        Assertions.assertEquals((Object)false, (Object)BooleanUtils.xor((Boolean[])new Boolean[]{Boolean.FALSE, Boolean.FALSE, Boolean.FALSE}), (String)"false ^ false ^ false");
        Assertions.assertEquals((Object)true, (Object)BooleanUtils.xor((Boolean[])new Boolean[]{Boolean.FALSE, Boolean.FALSE, Boolean.TRUE}), (String)"false ^ false ^ true");
        Assertions.assertEquals((Object)true, (Object)BooleanUtils.xor((Boolean[])new Boolean[]{Boolean.FALSE, Boolean.TRUE, Boolean.FALSE}), (String)"false ^ true ^ false");
        Assertions.assertEquals((Object)true, (Object)BooleanUtils.xor((Boolean[])new Boolean[]{Boolean.TRUE, Boolean.FALSE, Boolean.FALSE}), (String)"true ^ false ^ false");
        Assertions.assertEquals((Object)false, (Object)BooleanUtils.xor((Boolean[])new Boolean[]{Boolean.TRUE, Boolean.FALSE, Boolean.TRUE}), (String)"true ^ false ^ true");
        Assertions.assertEquals((Object)false, (Object)BooleanUtils.xor((Boolean[])new Boolean[]{Boolean.TRUE, Boolean.TRUE, Boolean.FALSE}), (String)"true ^ true ^ false");
        Assertions.assertEquals((Object)false, (Object)BooleanUtils.xor((Boolean[])new Boolean[]{Boolean.FALSE, Boolean.TRUE, Boolean.TRUE}), (String)"false ^ true ^ true");
        Assertions.assertEquals((Object)true, (Object)BooleanUtils.xor((Boolean[])new Boolean[]{Boolean.TRUE, Boolean.TRUE, Boolean.TRUE}), (String)"true ^ true ^ true");
    }

    @Test
    public void testAnd_primitive_nullInput() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> BooleanUtils.and((boolean[])null));
    }

    @Test
    public void testAnd_primitive_emptyInput() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> BooleanUtils.and((boolean[])new boolean[0]));
    }

    @Test
    public void testAnd_primitive_validInput_2items() {
        Assertions.assertTrue((boolean)BooleanUtils.and((boolean[])new boolean[]{true, true}), (String)"False result for (true, true)");
        Assertions.assertTrue((!BooleanUtils.and((boolean[])new boolean[]{false, false}) ? 1 : 0) != 0, (String)"True result for (false, false)");
        Assertions.assertTrue((!BooleanUtils.and((boolean[])new boolean[]{true, false}) ? 1 : 0) != 0, (String)"True result for (true, false)");
        Assertions.assertTrue((!BooleanUtils.and((boolean[])new boolean[]{false, true}) ? 1 : 0) != 0, (String)"True result for (false, true)");
    }

    @Test
    public void testAnd_primitive_validInput_3items() {
        Assertions.assertTrue((!BooleanUtils.and((boolean[])new boolean[]{false, false, true}) ? 1 : 0) != 0, (String)"True result for (false, false, true)");
        Assertions.assertTrue((!BooleanUtils.and((boolean[])new boolean[]{false, true, false}) ? 1 : 0) != 0, (String)"True result for (false, true, false)");
        Assertions.assertTrue((!BooleanUtils.and((boolean[])new boolean[]{true, false, false}) ? 1 : 0) != 0, (String)"True result for (true, false, false)");
        Assertions.assertTrue((boolean)BooleanUtils.and((boolean[])new boolean[]{true, true, true}), (String)"False result for (true, true, true)");
        Assertions.assertTrue((!BooleanUtils.and((boolean[])new boolean[]{false, false, false}) ? 1 : 0) != 0, (String)"True result for (false, false)");
        Assertions.assertTrue((!BooleanUtils.and((boolean[])new boolean[]{true, true, false}) ? 1 : 0) != 0, (String)"True result for (true, true, false)");
        Assertions.assertTrue((!BooleanUtils.and((boolean[])new boolean[]{true, false, true}) ? 1 : 0) != 0, (String)"True result for (true, false, true)");
        Assertions.assertTrue((!BooleanUtils.and((boolean[])new boolean[]{false, true, true}) ? 1 : 0) != 0, (String)"True result for (false, true, true)");
    }

    @Test
    public void testAnd_object_nullInput() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> BooleanUtils.and((Boolean[])null));
    }

    @Test
    public void testAnd_object_emptyInput() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> BooleanUtils.and((Boolean[])new Boolean[0]));
    }

    @Test
    public void testAnd_object_nullElementInput() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> BooleanUtils.and((Boolean[])new Boolean[]{null}));
    }

    @Test
    public void testAnd_object_validInput_2items() {
        Assertions.assertTrue((boolean)BooleanUtils.and((Boolean[])new Boolean[]{Boolean.TRUE, Boolean.TRUE}), (String)"False result for (true, true)");
        Assertions.assertTrue((BooleanUtils.and((Boolean[])new Boolean[]{Boolean.FALSE, Boolean.FALSE}) == false ? 1 : 0) != 0, (String)"True result for (false, false)");
        Assertions.assertTrue((BooleanUtils.and((Boolean[])new Boolean[]{Boolean.TRUE, Boolean.FALSE}) == false ? 1 : 0) != 0, (String)"True result for (true, false)");
        Assertions.assertTrue((BooleanUtils.and((Boolean[])new Boolean[]{Boolean.FALSE, Boolean.TRUE}) == false ? 1 : 0) != 0, (String)"True result for (false, true)");
    }

    @Test
    public void testAnd_object_validInput_3items() {
        Assertions.assertTrue((BooleanUtils.and((Boolean[])new Boolean[]{Boolean.FALSE, Boolean.FALSE, Boolean.TRUE}) == false ? 1 : 0) != 0, (String)"True result for (false, false, true)");
        Assertions.assertTrue((BooleanUtils.and((Boolean[])new Boolean[]{Boolean.FALSE, Boolean.TRUE, Boolean.FALSE}) == false ? 1 : 0) != 0, (String)"True result for (false, true, false)");
        Assertions.assertTrue((BooleanUtils.and((Boolean[])new Boolean[]{Boolean.TRUE, Boolean.FALSE, Boolean.FALSE}) == false ? 1 : 0) != 0, (String)"True result for (true, false, false)");
        Assertions.assertTrue((boolean)BooleanUtils.and((Boolean[])new Boolean[]{Boolean.TRUE, Boolean.TRUE, Boolean.TRUE}), (String)"False result for (true, true, true)");
        Assertions.assertTrue((BooleanUtils.and((Boolean[])new Boolean[]{Boolean.FALSE, Boolean.FALSE, Boolean.FALSE}) == false ? 1 : 0) != 0, (String)"True result for (false, false)");
        Assertions.assertTrue((BooleanUtils.and((Boolean[])new Boolean[]{Boolean.TRUE, Boolean.TRUE, Boolean.FALSE}) == false ? 1 : 0) != 0, (String)"True result for (true, true, false)");
        Assertions.assertTrue((BooleanUtils.and((Boolean[])new Boolean[]{Boolean.TRUE, Boolean.FALSE, Boolean.TRUE}) == false ? 1 : 0) != 0, (String)"True result for (true, false, true)");
        Assertions.assertTrue((BooleanUtils.and((Boolean[])new Boolean[]{Boolean.FALSE, Boolean.TRUE, Boolean.TRUE}) == false ? 1 : 0) != 0, (String)"True result for (false, true, true)");
    }

    @Test
    public void testOr_primitive_nullInput() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> BooleanUtils.or((boolean[])null));
    }

    @Test
    public void testOr_primitive_emptyInput() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> BooleanUtils.or((boolean[])new boolean[0]));
    }

    @Test
    public void testOr_primitive_validInput_2items() {
        Assertions.assertTrue((boolean)BooleanUtils.or((boolean[])new boolean[]{true, true}), (String)"False result for (true, true)");
        Assertions.assertTrue((!BooleanUtils.or((boolean[])new boolean[]{false, false}) ? 1 : 0) != 0, (String)"True result for (false, false)");
        Assertions.assertTrue((boolean)BooleanUtils.or((boolean[])new boolean[]{true, false}), (String)"False result for (true, false)");
        Assertions.assertTrue((boolean)BooleanUtils.or((boolean[])new boolean[]{false, true}), (String)"False result for (false, true)");
    }

    @Test
    public void testOr_primitive_validInput_3items() {
        Assertions.assertTrue((boolean)BooleanUtils.or((boolean[])new boolean[]{false, false, true}), (String)"False result for (false, false, true)");
        Assertions.assertTrue((boolean)BooleanUtils.or((boolean[])new boolean[]{false, true, false}), (String)"False result for (false, true, false)");
        Assertions.assertTrue((boolean)BooleanUtils.or((boolean[])new boolean[]{true, false, false}), (String)"False result for (true, false, false)");
        Assertions.assertTrue((boolean)BooleanUtils.or((boolean[])new boolean[]{true, true, true}), (String)"False result for (true, true, true)");
        Assertions.assertTrue((!BooleanUtils.or((boolean[])new boolean[]{false, false, false}) ? 1 : 0) != 0, (String)"True result for (false, false)");
        Assertions.assertTrue((boolean)BooleanUtils.or((boolean[])new boolean[]{true, true, false}), (String)"False result for (true, true, false)");
        Assertions.assertTrue((boolean)BooleanUtils.or((boolean[])new boolean[]{true, false, true}), (String)"False result for (true, false, true)");
        Assertions.assertTrue((boolean)BooleanUtils.or((boolean[])new boolean[]{false, true, true}), (String)"False result for (false, true, true)");
    }

    @Test
    public void testOr_object_nullInput() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> BooleanUtils.or((Boolean[])null));
    }

    @Test
    public void testOr_object_emptyInput() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> BooleanUtils.or((Boolean[])new Boolean[0]));
    }

    @Test
    public void testOr_object_nullElementInput() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> BooleanUtils.or((Boolean[])new Boolean[]{null}));
    }

    @Test
    public void testOr_object_validInput_2items() {
        Assertions.assertTrue((boolean)BooleanUtils.or((Boolean[])new Boolean[]{Boolean.TRUE, Boolean.TRUE}), (String)"False result for (true, true)");
        Assertions.assertTrue((BooleanUtils.or((Boolean[])new Boolean[]{Boolean.FALSE, Boolean.FALSE}) == false ? 1 : 0) != 0, (String)"True result for (false, false)");
        Assertions.assertTrue((boolean)BooleanUtils.or((Boolean[])new Boolean[]{Boolean.TRUE, Boolean.FALSE}), (String)"False result for (true, false)");
        Assertions.assertTrue((boolean)BooleanUtils.or((Boolean[])new Boolean[]{Boolean.FALSE, Boolean.TRUE}), (String)"False result for (false, true)");
    }

    @Test
    public void testOr_object_validInput_3items() {
        Assertions.assertTrue((boolean)BooleanUtils.or((Boolean[])new Boolean[]{Boolean.FALSE, Boolean.FALSE, Boolean.TRUE}), (String)"False result for (false, false, true)");
        Assertions.assertTrue((boolean)BooleanUtils.or((Boolean[])new Boolean[]{Boolean.FALSE, Boolean.TRUE, Boolean.FALSE}), (String)"False result for (false, true, false)");
        Assertions.assertTrue((boolean)BooleanUtils.or((Boolean[])new Boolean[]{Boolean.TRUE, Boolean.FALSE, Boolean.FALSE}), (String)"False result for (true, false, false)");
        Assertions.assertTrue((boolean)BooleanUtils.or((Boolean[])new Boolean[]{Boolean.TRUE, Boolean.TRUE, Boolean.TRUE}), (String)"False result for (true, true, true)");
        Assertions.assertTrue((BooleanUtils.or((Boolean[])new Boolean[]{Boolean.FALSE, Boolean.FALSE, Boolean.FALSE}) == false ? 1 : 0) != 0, (String)"True result for (false, false)");
        Assertions.assertTrue((boolean)BooleanUtils.or((Boolean[])new Boolean[]{Boolean.TRUE, Boolean.TRUE, Boolean.FALSE}), (String)"False result for (true, true, false)");
        Assertions.assertTrue((boolean)BooleanUtils.or((Boolean[])new Boolean[]{Boolean.TRUE, Boolean.FALSE, Boolean.TRUE}), (String)"False result for (true, false, true)");
        Assertions.assertTrue((boolean)BooleanUtils.or((Boolean[])new Boolean[]{Boolean.FALSE, Boolean.TRUE, Boolean.TRUE}), (String)"False result for (false, true, true)");
    }

    @Test
    public void testCompare() {
        Assertions.assertTrue((BooleanUtils.compare((boolean)true, (boolean)false) > 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)BooleanUtils.compare((boolean)true, (boolean)true));
        Assertions.assertEquals((int)0, (int)BooleanUtils.compare((boolean)false, (boolean)false));
        Assertions.assertTrue((BooleanUtils.compare((boolean)false, (boolean)true) < 0 ? 1 : 0) != 0);
    }
}

