/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.reflect.testbed.GenericConsumer;
import org.apache.commons.lang3.reflect.testbed.GenericParent;
import org.apache.commons.lang3.reflect.testbed.StringParameterizedChild;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

public class ClassUtilsTest {
    private void assertGetClassReturnsClass(Class<?> c) throws Exception {
        Assertions.assertEquals(c, (Object)ClassUtils.getClass((String)c.getName()));
    }

    private void assertGetClassThrowsClassNotFound(String className) {
        this.assertGetClassThrowsException(className, ClassNotFoundException.class);
    }

    private void assertGetClassThrowsException(String className, Class<? extends Exception> exceptionType) {
        Assertions.assertThrows(exceptionType, () -> ClassUtils.getClass((String)className), (String)("ClassUtils.getClass() should fail with an exception of type " + exceptionType.getName() + " when given class name \"" + className + "\"."));
    }

    private void assertGetClassThrowsNullPointerException(String className) {
        this.assertGetClassThrowsException(className, NullPointerException.class);
    }

    @Test
    public void test_convertClassesToClassNames_List() {
        ArrayList<Object> list = new ArrayList<Object>();
        List result = ClassUtils.convertClassesToClassNames(list);
        Assertions.assertEquals((int)0, (int)result.size());
        list.add(String.class);
        list.add(null);
        list.add(Object.class);
        result = ClassUtils.convertClassesToClassNames(list);
        Assertions.assertEquals((int)3, (int)result.size());
        Assertions.assertEquals((Object)"java.lang.String", result.get(0));
        Assertions.assertNull(result.get(1));
        Assertions.assertEquals((Object)"java.lang.Object", result.get(2));
        ArrayList<Object> olist = list;
        olist.add(new Object());
        Assertions.assertThrows(ClassCastException.class, () -> ClassUtils.convertClassesToClassNames((List)list), (String)"Should not have been able to convert list");
        Assertions.assertNull((Object)ClassUtils.convertClassesToClassNames(null));
    }

    @Test
    public void test_convertClassNamesToClasses_List() {
        ArrayList<Object> list = new ArrayList<Object>();
        List result = ClassUtils.convertClassNamesToClasses(list);
        Assertions.assertEquals((int)0, (int)result.size());
        list.add("java.lang.String");
        list.add("java.lang.xxx");
        list.add("java.lang.Object");
        result = ClassUtils.convertClassNamesToClasses(list);
        Assertions.assertEquals((int)3, (int)result.size());
        Assertions.assertEquals(String.class, result.get(0));
        Assertions.assertNull(result.get(1));
        Assertions.assertEquals(Object.class, result.get(2));
        ArrayList<Object> olist = list;
        olist.add(new Object());
        Assertions.assertThrows(ClassCastException.class, () -> ClassUtils.convertClassNamesToClasses((List)list), (String)"Should not have been able to convert list");
        Assertions.assertNull((Object)ClassUtils.convertClassNamesToClasses(null));
    }

    @Test
    public void test_getAbbreviatedName_Class() {
        Assertions.assertEquals((Object)"", (Object)ClassUtils.getAbbreviatedName((Class)null, (int)1));
        Assertions.assertEquals((Object)"j.l.String", (Object)ClassUtils.getAbbreviatedName(String.class, (int)1));
        Assertions.assertEquals((Object)"j.l.String", (Object)ClassUtils.getAbbreviatedName(String.class, (int)5));
        Assertions.assertEquals((Object)"o.a.c.l.ClassUtils", (Object)ClassUtils.getAbbreviatedName(ClassUtils.class, (int)18));
        Assertions.assertEquals((Object)"j.lang.String", (Object)ClassUtils.getAbbreviatedName(String.class, (int)13));
        Assertions.assertEquals((Object)"j.lang.String", (Object)ClassUtils.getAbbreviatedName(String.class, (int)15));
        Assertions.assertEquals((Object)"java.lang.String", (Object)ClassUtils.getAbbreviatedName(String.class, (int)20));
    }

    @Test
    @DisplayName(value="When the length hint is longer than the actual length then the same String object is returned")
    public void test_getAbbreviatedName_TooLongHint() {
        String className = "java.lang.String";
        Assertions.assertSame((Object)"java.lang.String", (Object)ClassUtils.getAbbreviatedName((String)"java.lang.String", (int)("java.lang.String".length() + 1)));
        Assertions.assertSame((Object)"java.lang.String", (Object)ClassUtils.getAbbreviatedName((String)"java.lang.String", (int)"java.lang.String".length()));
    }

    @Test
    @DisplayName(value="When the desired length is negative then exception is thrown")
    public void test_getAbbreviatedName_Class_NegativeLen() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> ClassUtils.getAbbreviatedName(String.class, (int)-10));
    }

    @Test
    @DisplayName(value="When the desired length is zero then exception is thrown")
    public void test_getAbbreviatedName_Class_ZeroLen() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> ClassUtils.getAbbreviatedName(String.class, (int)0));
    }

    @Test
    public void test_getAbbreviatedName_String() {
        Assertions.assertEquals((Object)"", (Object)ClassUtils.getAbbreviatedName((String)null, (int)1));
        Assertions.assertEquals((Object)"", (Object)ClassUtils.getAbbreviatedName((String)"", (int)1));
        Assertions.assertEquals((Object)"WithoutPackage", (Object)ClassUtils.getAbbreviatedName((String)"WithoutPackage", (int)1));
        Assertions.assertEquals((Object)"j.l.String", (Object)ClassUtils.getAbbreviatedName((String)"java.lang.String", (int)1));
        Assertions.assertEquals((Object)"o.a.c.l.ClassUtils", (Object)ClassUtils.getAbbreviatedName((String)"org.apache.commons.lang3.ClassUtils", (int)18));
        Assertions.assertEquals((Object)"org.apache.commons.lang3.ClassUtils", (Object)ClassUtils.getAbbreviatedName((String)"org.apache.commons.lang3.ClassUtils", (int)"org.apache.commons.lang3.ClassUtils".length()));
        Assertions.assertEquals((Object)"o.a.c.l.ClassUtils", (Object)ClassUtils.getAbbreviatedName((String)"o.a.c.l.ClassUtils", (int)18));
        Assertions.assertEquals((Object)"o..c.l.ClassUtils", (Object)ClassUtils.getAbbreviatedName((String)"o..c.l.ClassUtils", (int)18));
        Assertions.assertEquals((Object)".", (Object)ClassUtils.getAbbreviatedName((String)".", (int)18));
        Assertions.assertEquals((Object)".", (Object)ClassUtils.getAbbreviatedName((String)".", (int)1));
        Assertions.assertEquals((Object)"..", (Object)ClassUtils.getAbbreviatedName((String)"..", (int)1));
        Assertions.assertEquals((Object)"...", (Object)ClassUtils.getAbbreviatedName((String)"...", (int)2));
        Assertions.assertEquals((Object)"...", (Object)ClassUtils.getAbbreviatedName((String)"...", (int)3));
        Assertions.assertEquals((Object)"java.lang.String", (Object)ClassUtils.getAbbreviatedName((String)"java.lang.String", (int)Integer.MAX_VALUE));
        Assertions.assertEquals((Object)"j.lang.String", (Object)ClassUtils.getAbbreviatedName((String)"java.lang.String", (int)"j.lang.String".length()));
        Assertions.assertEquals((Object)"j.l.String", (Object)ClassUtils.getAbbreviatedName((String)"java.lang.String", (int)("j.lang.String".length() - 1)));
        Assertions.assertEquals((Object)"j.l.String", (Object)ClassUtils.getAbbreviatedName((String)"java.lang.String", (int)"j.l.String".length()));
        Assertions.assertEquals((Object)"j.l.String", (Object)ClassUtils.getAbbreviatedName((String)"java.lang.String", (int)("j.l.String".length() - 1)));
    }

    @Test
    public void test_getAllInterfaces_Class() {
        List list = ClassUtils.getAllInterfaces(CY.class);
        Assertions.assertEquals((int)6, (int)list.size());
        Assertions.assertEquals(IB.class, list.get(0));
        Assertions.assertEquals(IC.class, list.get(1));
        Assertions.assertEquals(ID.class, list.get(2));
        Assertions.assertEquals(IE.class, list.get(3));
        Assertions.assertEquals(IF.class, list.get(4));
        Assertions.assertEquals(IA.class, list.get(5));
        Assertions.assertNull((Object)ClassUtils.getAllInterfaces(null));
    }

    @Test
    public void test_getAllSuperclasses_Class() {
        List list = ClassUtils.getAllSuperclasses(CY.class);
        Assertions.assertEquals((int)2, (int)list.size());
        Assertions.assertEquals(CX.class, list.get(0));
        Assertions.assertEquals(Object.class, list.get(1));
        Assertions.assertNull((Object)ClassUtils.getAllSuperclasses(null));
    }

    @Test
    public void test_getCanonicalName_Class() {
        Assertions.assertEquals((Object)"org.apache.commons.lang3.ClassUtils", (Object)ClassUtils.getCanonicalName(ClassUtils.class));
        Assertions.assertEquals((Object)"java.util.Map.Entry", (Object)ClassUtils.getCanonicalName(Map.Entry.class));
        Assertions.assertEquals((Object)"", (Object)ClassUtils.getCanonicalName((Class)null));
        Assertions.assertEquals((Object)"java.lang.String[]", (Object)ClassUtils.getCanonicalName(String[].class));
        Assertions.assertEquals((Object)"java.util.Map.Entry[]", (Object)ClassUtils.getCanonicalName(Map.Entry[].class));
        Assertions.assertEquals((Object)"boolean", (Object)ClassUtils.getCanonicalName(Boolean.TYPE));
        Assertions.assertEquals((Object)"byte", (Object)ClassUtils.getCanonicalName(Byte.TYPE));
        Assertions.assertEquals((Object)"char", (Object)ClassUtils.getCanonicalName(Character.TYPE));
        Assertions.assertEquals((Object)"short", (Object)ClassUtils.getCanonicalName(Short.TYPE));
        Assertions.assertEquals((Object)"int", (Object)ClassUtils.getCanonicalName(Integer.TYPE));
        Assertions.assertEquals((Object)"long", (Object)ClassUtils.getCanonicalName(Long.TYPE));
        Assertions.assertEquals((Object)"float", (Object)ClassUtils.getCanonicalName(Float.TYPE));
        Assertions.assertEquals((Object)"double", (Object)ClassUtils.getCanonicalName(Double.TYPE));
        Assertions.assertEquals((Object)"boolean[]", (Object)ClassUtils.getCanonicalName(boolean[].class));
        Assertions.assertEquals((Object)"byte[]", (Object)ClassUtils.getCanonicalName(byte[].class));
        Assertions.assertEquals((Object)"char[]", (Object)ClassUtils.getCanonicalName(char[].class));
        Assertions.assertEquals((Object)"short[]", (Object)ClassUtils.getCanonicalName(short[].class));
        Assertions.assertEquals((Object)"int[]", (Object)ClassUtils.getCanonicalName(int[].class));
        Assertions.assertEquals((Object)"long[]", (Object)ClassUtils.getCanonicalName(long[].class));
        Assertions.assertEquals((Object)"float[]", (Object)ClassUtils.getCanonicalName(float[].class));
        Assertions.assertEquals((Object)"double[]", (Object)ClassUtils.getCanonicalName(double[].class));
        Assertions.assertEquals((Object)"java.lang.String[][]", (Object)ClassUtils.getCanonicalName(String[][].class));
        Assertions.assertEquals((Object)"java.lang.String[][][]", (Object)ClassUtils.getCanonicalName(String[][][].class));
        Assertions.assertEquals((Object)"java.lang.String[][][][]", (Object)ClassUtils.getCanonicalName(String[][][][].class));
        Assertions.assertEquals((Object)"", (Object)ClassUtils.getCanonicalName(new Object(){}.getClass()));
        class Named {
            Named() {
            }
        }
        Assertions.assertEquals((Object)"", (Object)ClassUtils.getCanonicalName(Named.class));
        Assertions.assertEquals((Object)"org.apache.commons.lang3.ClassUtilsTest.Inner", (Object)ClassUtils.getCanonicalName(Inner.class));
    }

    @Test
    public void test_getCanonicalName_Class_String() {
        Assertions.assertEquals((Object)"org.apache.commons.lang3.ClassUtils", (Object)ClassUtils.getCanonicalName(ClassUtils.class, (String)"X"));
        Assertions.assertEquals((Object)"java.util.Map.Entry", (Object)ClassUtils.getCanonicalName(Map.Entry.class, (String)"X"));
        Assertions.assertEquals((Object)"X", (Object)ClassUtils.getCanonicalName((Class)null, (String)"X"));
        Assertions.assertEquals((Object)"java.lang.String[]", (Object)ClassUtils.getCanonicalName(String[].class, (String)"X"));
        Assertions.assertEquals((Object)"java.util.Map.Entry[]", (Object)ClassUtils.getCanonicalName(Map.Entry[].class, (String)"X"));
        Assertions.assertEquals((Object)"boolean", (Object)ClassUtils.getCanonicalName(Boolean.TYPE, (String)"X"));
        Assertions.assertEquals((Object)"byte", (Object)ClassUtils.getCanonicalName(Byte.TYPE, (String)"X"));
        Assertions.assertEquals((Object)"char", (Object)ClassUtils.getCanonicalName(Character.TYPE, (String)"X"));
        Assertions.assertEquals((Object)"short", (Object)ClassUtils.getCanonicalName(Short.TYPE, (String)"X"));
        Assertions.assertEquals((Object)"int", (Object)ClassUtils.getCanonicalName(Integer.TYPE, (String)"X"));
        Assertions.assertEquals((Object)"long", (Object)ClassUtils.getCanonicalName(Long.TYPE, (String)"X"));
        Assertions.assertEquals((Object)"float", (Object)ClassUtils.getCanonicalName(Float.TYPE, (String)"X"));
        Assertions.assertEquals((Object)"double", (Object)ClassUtils.getCanonicalName(Double.TYPE, (String)"X"));
        Assertions.assertEquals((Object)"boolean[]", (Object)ClassUtils.getCanonicalName(boolean[].class, (String)"X"));
        Assertions.assertEquals((Object)"byte[]", (Object)ClassUtils.getCanonicalName(byte[].class, (String)"X"));
        Assertions.assertEquals((Object)"char[]", (Object)ClassUtils.getCanonicalName(char[].class, (String)"X"));
        Assertions.assertEquals((Object)"short[]", (Object)ClassUtils.getCanonicalName(short[].class, (String)"X"));
        Assertions.assertEquals((Object)"int[]", (Object)ClassUtils.getCanonicalName(int[].class, (String)"X"));
        Assertions.assertEquals((Object)"long[]", (Object)ClassUtils.getCanonicalName(long[].class, (String)"X"));
        Assertions.assertEquals((Object)"float[]", (Object)ClassUtils.getCanonicalName(float[].class, (String)"X"));
        Assertions.assertEquals((Object)"double[]", (Object)ClassUtils.getCanonicalName(double[].class, (String)"X"));
        Assertions.assertEquals((Object)"java.lang.String[][]", (Object)ClassUtils.getCanonicalName(String[][].class, (String)"X"));
        Assertions.assertEquals((Object)"java.lang.String[][][]", (Object)ClassUtils.getCanonicalName(String[][][].class, (String)"X"));
        Assertions.assertEquals((Object)"java.lang.String[][][][]", (Object)ClassUtils.getCanonicalName(String[][][][].class, (String)"X"));
        Assertions.assertEquals((Object)"X", (Object)ClassUtils.getCanonicalName(new Object(){}.getClass(), (String)"X"));
        class Named {
            Named() {
            }
        }
        Assertions.assertEquals((Object)"X", (Object)ClassUtils.getCanonicalName(Named.class, (String)"X"));
        Assertions.assertEquals((Object)"org.apache.commons.lang3.ClassUtilsTest.Inner", (Object)ClassUtils.getCanonicalName(Inner.class, (String)"X"));
    }

    @Test
    public void test_getName_Class() {
        Assertions.assertEquals((Object)"org.apache.commons.lang3.ClassUtils", (Object)ClassUtils.getName(ClassUtils.class));
        Assertions.assertEquals((Object)"java.util.Map$Entry", (Object)ClassUtils.getName(Map.Entry.class));
        Assertions.assertEquals((Object)"", (Object)ClassUtils.getName((Class)null));
        Assertions.assertEquals((Object)"[Ljava.lang.String;", (Object)ClassUtils.getName(String[].class));
        Assertions.assertEquals((Object)"[Ljava.util.Map$Entry;", (Object)ClassUtils.getName(Map.Entry[].class));
        Assertions.assertEquals((Object)"boolean", (Object)ClassUtils.getName(Boolean.TYPE));
        Assertions.assertEquals((Object)"byte", (Object)ClassUtils.getName(Byte.TYPE));
        Assertions.assertEquals((Object)"char", (Object)ClassUtils.getName(Character.TYPE));
        Assertions.assertEquals((Object)"short", (Object)ClassUtils.getName(Short.TYPE));
        Assertions.assertEquals((Object)"int", (Object)ClassUtils.getName(Integer.TYPE));
        Assertions.assertEquals((Object)"long", (Object)ClassUtils.getName(Long.TYPE));
        Assertions.assertEquals((Object)"float", (Object)ClassUtils.getName(Float.TYPE));
        Assertions.assertEquals((Object)"double", (Object)ClassUtils.getName(Double.TYPE));
        Assertions.assertEquals((Object)"[Z", (Object)ClassUtils.getName(boolean[].class));
        Assertions.assertEquals((Object)"[B", (Object)ClassUtils.getName(byte[].class));
        Assertions.assertEquals((Object)"[C", (Object)ClassUtils.getName(char[].class));
        Assertions.assertEquals((Object)"[S", (Object)ClassUtils.getName(short[].class));
        Assertions.assertEquals((Object)"[I", (Object)ClassUtils.getName(int[].class));
        Assertions.assertEquals((Object)"[J", (Object)ClassUtils.getName(long[].class));
        Assertions.assertEquals((Object)"[F", (Object)ClassUtils.getName(float[].class));
        Assertions.assertEquals((Object)"[D", (Object)ClassUtils.getName(double[].class));
        Assertions.assertEquals((Object)"[[Ljava.lang.String;", (Object)ClassUtils.getName(String[][].class));
        Assertions.assertEquals((Object)"[[[Ljava.lang.String;", (Object)ClassUtils.getName(String[][][].class));
        Assertions.assertEquals((Object)"[[[[Ljava.lang.String;", (Object)ClassUtils.getName(String[][][][].class));
        Assertions.assertEquals((Object)"org.apache.commons.lang3.ClassUtilsTest$3", (Object)ClassUtils.getName(new Object(){}.getClass()));
        class Named {
            Named() {
            }
        }
        Assertions.assertEquals((Object)"org.apache.commons.lang3.ClassUtilsTest$3Named", (Object)ClassUtils.getName(Named.class));
        Assertions.assertEquals((Object)"org.apache.commons.lang3.ClassUtilsTest$Inner", (Object)ClassUtils.getName(Inner.class));
    }

    @Test
    public void test_getName_Object() {
        Assertions.assertEquals((Object)"org.apache.commons.lang3.ClassUtils", (Object)ClassUtils.getName((Object)new ClassUtils(), (String)"<null>"));
        Assertions.assertEquals((Object)"org.apache.commons.lang3.ClassUtilsTest$Inner", (Object)ClassUtils.getName((Object)new Inner(), (String)"<null>"));
        Assertions.assertEquals((Object)"java.lang.String", (Object)ClassUtils.getName((Object)"hello", (String)"<null>"));
        Assertions.assertEquals((Object)"<null>", (Object)ClassUtils.getName(null, (String)"<null>"));
        Assertions.assertEquals((Object)"org.apache.commons.lang3.ClassUtilsTest$4", (Object)ClassUtils.getName((Object)new Object(){}, (String)"<null>"));
        class Named {
            Named() {
            }
        }
        Assertions.assertEquals((Object)"org.apache.commons.lang3.ClassUtilsTest$4Named", (Object)ClassUtils.getName((Object)new Named(), (String)"<null>"));
        Assertions.assertEquals((Object)"org.apache.commons.lang3.ClassUtilsTest$Inner", (Object)ClassUtils.getName((Object)new Inner(), (String)"<null>"));
    }

    @Test
    public void test_getPackageCanonicalName_Class() {
        Assertions.assertEquals((Object)"org.apache.commons.lang3", (Object)ClassUtils.getPackageCanonicalName(ClassUtils.class));
        Assertions.assertEquals((Object)"org.apache.commons.lang3", (Object)ClassUtils.getPackageCanonicalName(ClassUtils[].class));
        Assertions.assertEquals((Object)"org.apache.commons.lang3", (Object)ClassUtils.getPackageCanonicalName(ClassUtils[][].class));
        Assertions.assertEquals((Object)"", (Object)ClassUtils.getPackageCanonicalName(int[].class));
        Assertions.assertEquals((Object)"", (Object)ClassUtils.getPackageCanonicalName(int[][].class));
        Assertions.assertEquals((Object)"org.apache.commons.lang3", (Object)ClassUtils.getPackageCanonicalName(new Object(){}.getClass()));
        class Named {
            Named() {
            }
        }
        Assertions.assertEquals((Object)"org.apache.commons.lang3", (Object)ClassUtils.getPackageCanonicalName(Named.class));
        Assertions.assertEquals((Object)"org.apache.commons.lang3", (Object)ClassUtils.getPackageCanonicalName(Inner.class));
    }

    @Test
    public void test_getPackageCanonicalName_Object() {
        Assertions.assertEquals((Object)"<null>", (Object)ClassUtils.getPackageCanonicalName(null, (String)"<null>"));
        Assertions.assertEquals((Object)"org.apache.commons.lang3", (Object)ClassUtils.getPackageCanonicalName((Object)new ClassUtils(), (String)"<null>"));
        Assertions.assertEquals((Object)"org.apache.commons.lang3", (Object)ClassUtils.getPackageCanonicalName((Object)new ClassUtils[0], (String)"<null>"));
        Assertions.assertEquals((Object)"org.apache.commons.lang3", (Object)ClassUtils.getPackageCanonicalName((Object)new ClassUtils[0][0], (String)"<null>"));
        Assertions.assertEquals((Object)"", (Object)ClassUtils.getPackageCanonicalName((Object)new int[0], (String)"<null>"));
        Assertions.assertEquals((Object)"", (Object)ClassUtils.getPackageCanonicalName((Object)new int[0][0], (String)"<null>"));
        Assertions.assertEquals((Object)"org.apache.commons.lang3", (Object)ClassUtils.getPackageCanonicalName((Object)new Object(){}, (String)"<null>"));
        class Named {
            Named() {
            }
        }
        Assertions.assertEquals((Object)"org.apache.commons.lang3", (Object)ClassUtils.getPackageCanonicalName((Object)new Named(), (String)"<null>"));
        Assertions.assertEquals((Object)"org.apache.commons.lang3", (Object)ClassUtils.getPackageCanonicalName((Object)new Inner(), (String)"<null>"));
    }

    @Test
    public void test_getPackageCanonicalName_String() {
        Assertions.assertEquals((Object)"org.apache.commons.lang3", (Object)ClassUtils.getPackageCanonicalName((String)"org.apache.commons.lang3.ClassUtils"));
        Assertions.assertEquals((Object)"org.apache.commons.lang3", (Object)ClassUtils.getPackageCanonicalName((String)"[Lorg.apache.commons.lang3.ClassUtils;"));
        Assertions.assertEquals((Object)"org.apache.commons.lang3", (Object)ClassUtils.getPackageCanonicalName((String)"[[Lorg.apache.commons.lang3.ClassUtils;"));
        Assertions.assertEquals((Object)"org.apache.commons.lang3", (Object)ClassUtils.getPackageCanonicalName((String)"org.apache.commons.lang3.ClassUtils[]"));
        Assertions.assertEquals((Object)"org.apache.commons.lang3", (Object)ClassUtils.getPackageCanonicalName((String)"org.apache.commons.lang3.ClassUtils[][]"));
        Assertions.assertEquals((Object)"", (Object)ClassUtils.getPackageCanonicalName((String)"[I"));
        Assertions.assertEquals((Object)"", (Object)ClassUtils.getPackageCanonicalName((String)"[[I"));
        Assertions.assertEquals((Object)"", (Object)ClassUtils.getPackageCanonicalName((String)"int[]"));
        Assertions.assertEquals((Object)"", (Object)ClassUtils.getPackageCanonicalName((String)"int[][]"));
        Assertions.assertEquals((Object)"org.apache.commons.lang3", (Object)ClassUtils.getPackageCanonicalName((String)"org.apache.commons.lang3.ClassUtilsTest$6"));
        Assertions.assertEquals((Object)"org.apache.commons.lang3", (Object)ClassUtils.getPackageCanonicalName((String)"org.apache.commons.lang3.ClassUtilsTest$5Named"));
        Assertions.assertEquals((Object)"org.apache.commons.lang3", (Object)ClassUtils.getPackageCanonicalName((String)"org.apache.commons.lang3.ClassUtilsTest$Inner"));
    }

    @Test
    public void test_getPackageName_Class() {
        Assertions.assertEquals((Object)"java.lang", (Object)ClassUtils.getPackageName(String.class));
        Assertions.assertEquals((Object)"java.util", (Object)ClassUtils.getPackageName(Map.Entry.class));
        Assertions.assertEquals((Object)"", (Object)ClassUtils.getPackageName((Class)null));
        Assertions.assertEquals((Object)"java.lang", (Object)ClassUtils.getPackageName(String[].class));
        Assertions.assertEquals((Object)"", (Object)ClassUtils.getPackageName(boolean[].class));
        Assertions.assertEquals((Object)"", (Object)ClassUtils.getPackageName(byte[].class));
        Assertions.assertEquals((Object)"", (Object)ClassUtils.getPackageName(char[].class));
        Assertions.assertEquals((Object)"", (Object)ClassUtils.getPackageName(short[].class));
        Assertions.assertEquals((Object)"", (Object)ClassUtils.getPackageName(int[].class));
        Assertions.assertEquals((Object)"", (Object)ClassUtils.getPackageName(long[].class));
        Assertions.assertEquals((Object)"", (Object)ClassUtils.getPackageName(float[].class));
        Assertions.assertEquals((Object)"", (Object)ClassUtils.getPackageName(double[].class));
        Assertions.assertEquals((Object)"java.lang", (Object)ClassUtils.getPackageName(String[][].class));
        Assertions.assertEquals((Object)"java.lang", (Object)ClassUtils.getPackageName(String[][][].class));
        Assertions.assertEquals((Object)"java.lang", (Object)ClassUtils.getPackageName(String[][][][].class));
        Assertions.assertEquals((Object)"org.apache.commons.lang3", (Object)ClassUtils.getPackageName(new Object(){}.getClass()));
        class Named {
            Named() {
            }
        }
        Assertions.assertEquals((Object)"org.apache.commons.lang3", (Object)ClassUtils.getPackageName(Named.class));
    }

    @Test
    public void test_getPackageName_Object() {
        Assertions.assertEquals((Object)"org.apache.commons.lang3", (Object)ClassUtils.getPackageName((Object)new ClassUtils(), (String)"<null>"));
        Assertions.assertEquals((Object)"org.apache.commons.lang3", (Object)ClassUtils.getPackageName((Object)new Inner(), (String)"<null>"));
        Assertions.assertEquals((Object)"<null>", (Object)ClassUtils.getPackageName(null, (String)"<null>"));
    }

    @Test
    public void test_getPackageName_String() {
        Assertions.assertEquals((Object)"org.apache.commons.lang3", (Object)ClassUtils.getPackageName((String)ClassUtils.class.getName()));
        Assertions.assertEquals((Object)"java.util", (Object)ClassUtils.getPackageName((String)Map.Entry.class.getName()));
        Assertions.assertEquals((Object)"", (Object)ClassUtils.getPackageName((String)null));
        Assertions.assertEquals((Object)"", (Object)ClassUtils.getPackageName((String)""));
    }

    @Test
    public void test_getShortCanonicalName_Class() {
        Assertions.assertEquals((Object)"ClassUtils", (Object)ClassUtils.getShortCanonicalName(ClassUtils.class));
        Assertions.assertEquals((Object)"ClassUtils[]", (Object)ClassUtils.getShortCanonicalName(ClassUtils[].class));
        Assertions.assertEquals((Object)"ClassUtils[][]", (Object)ClassUtils.getShortCanonicalName(ClassUtils[][].class));
        Assertions.assertEquals((Object)"int[]", (Object)ClassUtils.getShortCanonicalName(int[].class));
        Assertions.assertEquals((Object)"int[][]", (Object)ClassUtils.getShortCanonicalName(int[][].class));
        Assertions.assertEquals((Object)"ClassUtilsTest.8", (Object)ClassUtils.getShortCanonicalName(new Object(){}.getClass()));
        class Named {
            Named() {
            }
        }
        Assertions.assertEquals((Object)"ClassUtilsTest.8Named", (Object)ClassUtils.getShortCanonicalName(Named.class));
        Assertions.assertEquals((Object)"ClassUtilsTest.Inner", (Object)ClassUtils.getShortCanonicalName(Inner.class));
    }

    @Test
    public void test_getShortCanonicalName_Object() {
        Assertions.assertEquals((Object)"<null>", (Object)ClassUtils.getShortCanonicalName(null, (String)"<null>"));
        Assertions.assertEquals((Object)"ClassUtils", (Object)ClassUtils.getShortCanonicalName((Object)new ClassUtils(), (String)"<null>"));
        Assertions.assertEquals((Object)"ClassUtils[]", (Object)ClassUtils.getShortCanonicalName((Object)new ClassUtils[0], (String)"<null>"));
        Assertions.assertEquals((Object)"ClassUtils[][]", (Object)ClassUtils.getShortCanonicalName((Object)new ClassUtils[0][0], (String)"<null>"));
        Assertions.assertEquals((Object)"int[]", (Object)ClassUtils.getShortCanonicalName((Object)new int[0], (String)"<null>"));
        Assertions.assertEquals((Object)"int[][]", (Object)ClassUtils.getShortCanonicalName((Object)new int[0][0], (String)"<null>"));
        Assertions.assertEquals((Object)"ClassUtilsTest.9", (Object)ClassUtils.getShortCanonicalName((Object)new Object(){}, (String)"<null>"));
        class Named {
            Named() {
            }
        }
        Assertions.assertEquals((Object)"ClassUtilsTest.9Named", (Object)ClassUtils.getShortCanonicalName((Object)new Named(), (String)"<null>"));
        Assertions.assertEquals((Object)"ClassUtilsTest.Inner", (Object)ClassUtils.getShortCanonicalName((Object)new Inner(), (String)"<null>"));
    }

    @Test
    public void test_getShortCanonicalName_String() {
        Assertions.assertEquals((Object)"", (Object)ClassUtils.getShortCanonicalName((String)null));
        Assertions.assertEquals((Object)"Map.Entry", (Object)ClassUtils.getShortCanonicalName((String)Map.Entry.class.getName()));
        Assertions.assertEquals((Object)"Entry", (Object)ClassUtils.getShortCanonicalName((String)Map.Entry.class.getCanonicalName()));
        Assertions.assertEquals((Object)"ClassUtils", (Object)ClassUtils.getShortCanonicalName((String)"org.apache.commons.lang3.ClassUtils"));
        Assertions.assertEquals((Object)"ClassUtils[]", (Object)ClassUtils.getShortCanonicalName((String)"[Lorg.apache.commons.lang3.ClassUtils;"));
        Assertions.assertEquals((Object)"ClassUtils[][]", (Object)ClassUtils.getShortCanonicalName((String)"[[Lorg.apache.commons.lang3.ClassUtils;"));
        Assertions.assertEquals((Object)"ClassUtils[]", (Object)ClassUtils.getShortCanonicalName((String)"org.apache.commons.lang3.ClassUtils[]"));
        Assertions.assertEquals((Object)"ClassUtils[][]", (Object)ClassUtils.getShortCanonicalName((String)"org.apache.commons.lang3.ClassUtils[][]"));
        Assertions.assertEquals((Object)"int[]", (Object)ClassUtils.getShortCanonicalName((String)"[I"));
        Assertions.assertEquals((Object)"int[]", (Object)ClassUtils.getShortCanonicalName((String)int[].class.getCanonicalName()));
        Assertions.assertEquals((Object)"int[]", (Object)ClassUtils.getShortCanonicalName((String)int[].class.getName()));
        Assertions.assertEquals((Object)"int[][]", (Object)ClassUtils.getShortCanonicalName((String)"[[I"));
        Assertions.assertEquals((Object)"int[]", (Object)ClassUtils.getShortCanonicalName((String)"int[]"));
        Assertions.assertEquals((Object)"int[][]", (Object)ClassUtils.getShortCanonicalName((String)"int[][]"));
        Assertions.assertEquals((Object)"int[]", (Object)int[].class.getCanonicalName());
        Assertions.assertEquals((Object)"[I", (Object)int[].class.getName());
        Assertions.assertEquals((Object)"ClassUtilsTest.6", (Object)ClassUtils.getShortCanonicalName((String)"org.apache.commons.lang3.ClassUtilsTest$6"));
        Assertions.assertEquals((Object)"ClassUtilsTest.5Named", (Object)ClassUtils.getShortCanonicalName((String)"org.apache.commons.lang3.ClassUtilsTest$5Named"));
        Assertions.assertEquals((Object)"ClassUtilsTest.Inner", (Object)ClassUtils.getShortCanonicalName((String)"org.apache.commons.lang3.ClassUtilsTest$Inner"));
        Assertions.assertEquals((Object)"org.apache.commons.lang3.ClassUtilsTest$10", (Object)new ClassUtilsTest(){}.getClass().getName());
        Assertions.assertNull((Object)new ClassUtilsTest(){}.getClass().getCanonicalName());
    }

    @Test
    public void test_getShortClassName_Class() {
        Assertions.assertEquals((Object)"ClassUtils", (Object)ClassUtils.getShortClassName(ClassUtils.class));
        Assertions.assertEquals((Object)"Map.Entry", (Object)ClassUtils.getShortClassName(Map.Entry.class));
        Assertions.assertEquals((Object)"", (Object)ClassUtils.getShortClassName((Class)null));
        Assertions.assertEquals((Object)"String[]", (Object)ClassUtils.getShortClassName(String[].class));
        Assertions.assertEquals((Object)"Map.Entry[]", (Object)ClassUtils.getShortClassName(Map.Entry[].class));
        Assertions.assertEquals((Object)"boolean", (Object)ClassUtils.getShortClassName(Boolean.TYPE));
        Assertions.assertEquals((Object)"byte", (Object)ClassUtils.getShortClassName(Byte.TYPE));
        Assertions.assertEquals((Object)"char", (Object)ClassUtils.getShortClassName(Character.TYPE));
        Assertions.assertEquals((Object)"short", (Object)ClassUtils.getShortClassName(Short.TYPE));
        Assertions.assertEquals((Object)"int", (Object)ClassUtils.getShortClassName(Integer.TYPE));
        Assertions.assertEquals((Object)"long", (Object)ClassUtils.getShortClassName(Long.TYPE));
        Assertions.assertEquals((Object)"float", (Object)ClassUtils.getShortClassName(Float.TYPE));
        Assertions.assertEquals((Object)"double", (Object)ClassUtils.getShortClassName(Double.TYPE));
        Assertions.assertEquals((Object)"boolean[]", (Object)ClassUtils.getShortClassName(boolean[].class));
        Assertions.assertEquals((Object)"byte[]", (Object)ClassUtils.getShortClassName(byte[].class));
        Assertions.assertEquals((Object)"char[]", (Object)ClassUtils.getShortClassName(char[].class));
        Assertions.assertEquals((Object)"short[]", (Object)ClassUtils.getShortClassName(short[].class));
        Assertions.assertEquals((Object)"int[]", (Object)ClassUtils.getShortClassName(int[].class));
        Assertions.assertEquals((Object)"long[]", (Object)ClassUtils.getShortClassName(long[].class));
        Assertions.assertEquals((Object)"float[]", (Object)ClassUtils.getShortClassName(float[].class));
        Assertions.assertEquals((Object)"double[]", (Object)ClassUtils.getShortClassName(double[].class));
        Assertions.assertEquals((Object)"String[][]", (Object)ClassUtils.getShortClassName(String[][].class));
        Assertions.assertEquals((Object)"String[][][]", (Object)ClassUtils.getShortClassName(String[][][].class));
        Assertions.assertEquals((Object)"String[][][][]", (Object)ClassUtils.getShortClassName(String[][][][].class));
        Assertions.assertEquals((Object)"ClassUtilsTest.12", (Object)ClassUtils.getShortClassName(new Object(){}.getClass()));
        class Named {
            Named() {
            }
        }
        Assertions.assertEquals((Object)"ClassUtilsTest.10Named", (Object)ClassUtils.getShortClassName(Named.class));
        Assertions.assertEquals((Object)"ClassUtilsTest.Inner", (Object)ClassUtils.getShortClassName(Inner.class));
    }

    @Test
    public void test_getShortClassName_Object() {
        Assertions.assertEquals((Object)"ClassUtils", (Object)ClassUtils.getShortClassName((Object)new ClassUtils(), (String)"<null>"));
        Assertions.assertEquals((Object)"ClassUtilsTest.Inner", (Object)ClassUtils.getShortClassName((Object)new Inner(), (String)"<null>"));
        Assertions.assertEquals((Object)"String", (Object)ClassUtils.getShortClassName((Object)"hello", (String)"<null>"));
        Assertions.assertEquals((Object)"<null>", (Object)ClassUtils.getShortClassName(null, (String)"<null>"));
        Assertions.assertEquals((Object)"ClassUtilsTest.13", (Object)ClassUtils.getShortClassName((Object)new Object(){}, (String)"<null>"));
        class Named {
            Named() {
            }
        }
        Assertions.assertEquals((Object)"ClassUtilsTest.11Named", (Object)ClassUtils.getShortClassName((Object)new Named(), (String)"<null>"));
        Assertions.assertEquals((Object)"ClassUtilsTest.Inner", (Object)ClassUtils.getShortClassName((Object)new Inner(), (String)"<null>"));
    }

    @Test
    public void test_getShortClassName_String() {
        Assertions.assertEquals((Object)"ClassUtils", (Object)ClassUtils.getShortClassName((String)ClassUtils.class.getName()));
        Assertions.assertEquals((Object)"Map.Entry", (Object)ClassUtils.getShortClassName((String)Map.Entry.class.getName()));
        Assertions.assertEquals((Object)"", (Object)ClassUtils.getShortClassName((String)null));
        Assertions.assertEquals((Object)"", (Object)ClassUtils.getShortClassName((String)""));
    }

    @Test
    public void test_getSimpleName_Class() {
        Assertions.assertEquals((Object)"ClassUtils", (Object)ClassUtils.getSimpleName(ClassUtils.class));
        Assertions.assertEquals((Object)"Entry", (Object)ClassUtils.getSimpleName(Map.Entry.class));
        Assertions.assertEquals((Object)"", (Object)ClassUtils.getSimpleName(null));
        Assertions.assertEquals((Object)"String[]", (Object)ClassUtils.getSimpleName(String[].class));
        Assertions.assertEquals((Object)"Entry[]", (Object)ClassUtils.getSimpleName(Map.Entry[].class));
        Assertions.assertEquals((Object)"boolean", (Object)ClassUtils.getSimpleName(Boolean.TYPE));
        Assertions.assertEquals((Object)"byte", (Object)ClassUtils.getSimpleName(Byte.TYPE));
        Assertions.assertEquals((Object)"char", (Object)ClassUtils.getSimpleName(Character.TYPE));
        Assertions.assertEquals((Object)"short", (Object)ClassUtils.getSimpleName(Short.TYPE));
        Assertions.assertEquals((Object)"int", (Object)ClassUtils.getSimpleName(Integer.TYPE));
        Assertions.assertEquals((Object)"long", (Object)ClassUtils.getSimpleName(Long.TYPE));
        Assertions.assertEquals((Object)"float", (Object)ClassUtils.getSimpleName(Float.TYPE));
        Assertions.assertEquals((Object)"double", (Object)ClassUtils.getSimpleName(Double.TYPE));
        Assertions.assertEquals((Object)"boolean[]", (Object)ClassUtils.getSimpleName(boolean[].class));
        Assertions.assertEquals((Object)"byte[]", (Object)ClassUtils.getSimpleName(byte[].class));
        Assertions.assertEquals((Object)"char[]", (Object)ClassUtils.getSimpleName(char[].class));
        Assertions.assertEquals((Object)"short[]", (Object)ClassUtils.getSimpleName(short[].class));
        Assertions.assertEquals((Object)"int[]", (Object)ClassUtils.getSimpleName(int[].class));
        Assertions.assertEquals((Object)"long[]", (Object)ClassUtils.getSimpleName(long[].class));
        Assertions.assertEquals((Object)"float[]", (Object)ClassUtils.getSimpleName(float[].class));
        Assertions.assertEquals((Object)"double[]", (Object)ClassUtils.getSimpleName(double[].class));
        Assertions.assertEquals((Object)"String[][]", (Object)ClassUtils.getSimpleName(String[][].class));
        Assertions.assertEquals((Object)"String[][][]", (Object)ClassUtils.getSimpleName(String[][][].class));
        Assertions.assertEquals((Object)"String[][][][]", (Object)ClassUtils.getSimpleName(String[][][][].class));
        Assertions.assertEquals((Object)"", (Object)ClassUtils.getSimpleName(new Object(){}.getClass()));
        class Named {
            Named() {
            }
        }
        Assertions.assertEquals((Object)"Named", (Object)ClassUtils.getSimpleName(Named.class));
    }

    @Test
    public void test_getSimpleName_Object() {
        Assertions.assertEquals((Object)"ClassUtils", (Object)ClassUtils.getSimpleName((Object)new ClassUtils()));
        Assertions.assertEquals((Object)"Inner", (Object)ClassUtils.getSimpleName((Object)new Inner()));
        Assertions.assertEquals((Object)"String", (Object)ClassUtils.getSimpleName((Object)"hello"));
        Assertions.assertEquals((Object)"", (Object)ClassUtils.getSimpleName(null));
        Assertions.assertEquals((Object)"", (Object)ClassUtils.getSimpleName(null));
    }

    @Test
    public void test_getSimpleName_Object_String() {
        Assertions.assertEquals((Object)"ClassUtils", (Object)ClassUtils.getSimpleName((Object)new ClassUtils(), (String)"<null>"));
        Assertions.assertEquals((Object)"Inner", (Object)ClassUtils.getSimpleName((Object)new Inner(), (String)"<null>"));
        Assertions.assertEquals((Object)"String", (Object)ClassUtils.getSimpleName((Object)"hello", (String)"<null>"));
        Assertions.assertEquals((Object)"<null>", (Object)ClassUtils.getSimpleName(null, (String)"<null>"));
        Assertions.assertNull((Object)ClassUtils.getSimpleName(null, null));
    }

    @Test
    public void test_isAssignable() {
        Assertions.assertFalse((boolean)ClassUtils.isAssignable((Class)null, null));
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(String.class, null));
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(null, Object.class));
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(null, Integer.class));
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(null, Integer.TYPE));
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(String.class, Object.class));
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(String.class, String.class));
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Object.class, String.class));
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(Integer.TYPE, Integer.class));
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(Integer.TYPE, Object.class));
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(Integer.class, Integer.TYPE));
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(Integer.class, Object.class));
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(Integer.TYPE, Integer.TYPE));
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(Integer.class, Integer.class));
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(Boolean.TYPE, Boolean.class));
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(Boolean.TYPE, Object.class));
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(Boolean.class, Boolean.TYPE));
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(Boolean.class, Object.class));
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(Boolean.TYPE, Boolean.TYPE));
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(Boolean.class, Boolean.class));
    }

    @Test
    public void test_isAssignable_Autoboxing() {
        Assertions.assertFalse((boolean)ClassUtils.isAssignable((Class)null, null, (boolean)true));
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(String.class, null, (boolean)true));
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(null, Object.class, (boolean)true));
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(null, Integer.class, (boolean)true));
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(null, Integer.TYPE, (boolean)true));
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(String.class, Object.class, (boolean)true));
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(String.class, String.class, (boolean)true));
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Object.class, String.class, (boolean)true));
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(Integer.TYPE, Integer.class, (boolean)true));
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(Integer.TYPE, Object.class, (boolean)true));
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(Integer.class, Integer.TYPE, (boolean)true));
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(Integer.class, Object.class, (boolean)true));
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(Integer.TYPE, Integer.TYPE, (boolean)true));
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(Integer.class, Integer.class, (boolean)true));
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(Boolean.TYPE, Boolean.class, (boolean)true));
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(Boolean.class, Boolean.TYPE, (boolean)true));
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(Boolean.class, Object.class, (boolean)true));
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(Boolean.TYPE, Boolean.TYPE, (boolean)true));
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(Boolean.class, Boolean.class, (boolean)true));
    }

    @Test
    public void test_isAssignable_ClassArray_ClassArray() {
        Class[] array2 = new Class[]{Object.class, Object.class};
        Class[] array1 = new Class[]{Object.class};
        Class[] array1s = new Class[]{String.class};
        Class[] array0 = new Class[]{};
        Class[] arrayPrimitives = new Class[]{Integer.TYPE, Boolean.TYPE};
        Class[] arrayWrappers = new Class[]{Integer.class, Boolean.class};
        Assertions.assertFalse((boolean)ClassUtils.isAssignable((Class[])array1, (Class[])array2));
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(null, (Class[])array2));
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(null, (Class[])array0));
        Assertions.assertTrue((boolean)ClassUtils.isAssignable((Class[])array0, (Class[])array0));
        Assertions.assertTrue((boolean)ClassUtils.isAssignable((Class[])array0, (Class[])null));
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(null, (Class[])null));
        Assertions.assertFalse((boolean)ClassUtils.isAssignable((Class[])array1, (Class[])array1s));
        Assertions.assertTrue((boolean)ClassUtils.isAssignable((Class[])array1s, (Class[])array1s));
        Assertions.assertTrue((boolean)ClassUtils.isAssignable((Class[])array1s, (Class[])array1));
        Assertions.assertTrue((boolean)ClassUtils.isAssignable((Class[])arrayPrimitives, (Class[])arrayWrappers));
        Assertions.assertTrue((boolean)ClassUtils.isAssignable((Class[])arrayWrappers, (Class[])arrayPrimitives));
        Assertions.assertFalse((boolean)ClassUtils.isAssignable((Class[])arrayPrimitives, (Class[])array1));
        Assertions.assertFalse((boolean)ClassUtils.isAssignable((Class[])arrayWrappers, (Class[])array1));
        Assertions.assertTrue((boolean)ClassUtils.isAssignable((Class[])arrayPrimitives, (Class[])array2));
        Assertions.assertTrue((boolean)ClassUtils.isAssignable((Class[])arrayWrappers, (Class[])array2));
    }

    @Test
    public void test_isAssignable_ClassArray_ClassArray_Autoboxing() {
        Class[] array2 = new Class[]{Object.class, Object.class};
        Class[] array1 = new Class[]{Object.class};
        Class[] array1s = new Class[]{String.class};
        Class[] array0 = new Class[]{};
        Class[] arrayPrimitives = new Class[]{Integer.TYPE, Boolean.TYPE};
        Class[] arrayWrappers = new Class[]{Integer.class, Boolean.class};
        Assertions.assertFalse((boolean)ClassUtils.isAssignable((Class[])array1, (Class[])array2, (boolean)true));
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(null, (Class[])array2, (boolean)true));
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(null, (Class[])array0, (boolean)true));
        Assertions.assertTrue((boolean)ClassUtils.isAssignable((Class[])array0, (Class[])array0, (boolean)true));
        Assertions.assertTrue((boolean)ClassUtils.isAssignable((Class[])array0, null, (boolean)true));
        Assertions.assertTrue((boolean)ClassUtils.isAssignable((Class[])null, null, (boolean)true));
        Assertions.assertFalse((boolean)ClassUtils.isAssignable((Class[])array1, (Class[])array1s, (boolean)true));
        Assertions.assertTrue((boolean)ClassUtils.isAssignable((Class[])array1s, (Class[])array1s, (boolean)true));
        Assertions.assertTrue((boolean)ClassUtils.isAssignable((Class[])array1s, (Class[])array1, (boolean)true));
        Assertions.assertTrue((boolean)ClassUtils.isAssignable((Class[])arrayPrimitives, (Class[])arrayWrappers, (boolean)true));
        Assertions.assertTrue((boolean)ClassUtils.isAssignable((Class[])arrayWrappers, (Class[])arrayPrimitives, (boolean)true));
        Assertions.assertFalse((boolean)ClassUtils.isAssignable((Class[])arrayPrimitives, (Class[])array1, (boolean)true));
        Assertions.assertFalse((boolean)ClassUtils.isAssignable((Class[])arrayWrappers, (Class[])array1, (boolean)true));
        Assertions.assertTrue((boolean)ClassUtils.isAssignable((Class[])arrayPrimitives, (Class[])array2, (boolean)true));
        Assertions.assertTrue((boolean)ClassUtils.isAssignable((Class[])arrayWrappers, (Class[])array2, (boolean)true));
    }

    @Test
    public void test_isAssignable_ClassArray_ClassArray_NoAutoboxing() {
        Class[] array2 = new Class[]{Object.class, Object.class};
        Class[] array1 = new Class[]{Object.class};
        Class[] array1s = new Class[]{String.class};
        Class[] array0 = new Class[]{};
        Class[] arrayPrimitives = new Class[]{Integer.TYPE, Boolean.TYPE};
        Class[] arrayWrappers = new Class[]{Integer.class, Boolean.class};
        Assertions.assertFalse((boolean)ClassUtils.isAssignable((Class[])array1, (Class[])array2, (boolean)false));
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(null, (Class[])array2, (boolean)false));
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(null, (Class[])array0, (boolean)false));
        Assertions.assertTrue((boolean)ClassUtils.isAssignable((Class[])array0, (Class[])array0, (boolean)false));
        Assertions.assertTrue((boolean)ClassUtils.isAssignable((Class[])array0, null, (boolean)false));
        Assertions.assertTrue((boolean)ClassUtils.isAssignable((Class[])null, null, (boolean)false));
        Assertions.assertFalse((boolean)ClassUtils.isAssignable((Class[])array1, (Class[])array1s, (boolean)false));
        Assertions.assertTrue((boolean)ClassUtils.isAssignable((Class[])array1s, (Class[])array1s, (boolean)false));
        Assertions.assertTrue((boolean)ClassUtils.isAssignable((Class[])array1s, (Class[])array1, (boolean)false));
        Assertions.assertFalse((boolean)ClassUtils.isAssignable((Class[])arrayPrimitives, (Class[])arrayWrappers, (boolean)false));
        Assertions.assertFalse((boolean)ClassUtils.isAssignable((Class[])arrayWrappers, (Class[])arrayPrimitives, (boolean)false));
        Assertions.assertFalse((boolean)ClassUtils.isAssignable((Class[])arrayPrimitives, (Class[])array1, (boolean)false));
        Assertions.assertFalse((boolean)ClassUtils.isAssignable((Class[])arrayWrappers, (Class[])array1, (boolean)false));
        Assertions.assertTrue((boolean)ClassUtils.isAssignable((Class[])arrayWrappers, (Class[])array2, (boolean)false));
        Assertions.assertFalse((boolean)ClassUtils.isAssignable((Class[])arrayPrimitives, (Class[])array2, (boolean)false));
    }

    @Test
    public void test_isAssignable_DefaultUnboxing_Widening() {
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Byte.class, Character.TYPE), (String)"byte -> char");
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(Byte.class, Byte.TYPE), (String)"byte -> byte");
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(Byte.class, Short.TYPE), (String)"byte -> short");
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(Byte.class, Integer.TYPE), (String)"byte -> int");
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(Byte.class, Long.TYPE), (String)"byte -> long");
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(Byte.class, Float.TYPE), (String)"byte -> float");
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(Byte.class, Double.TYPE), (String)"byte -> double");
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Byte.class, Boolean.TYPE), (String)"byte -> boolean");
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Short.class, Character.TYPE), (String)"short -> char");
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Short.class, Byte.TYPE), (String)"short -> byte");
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(Short.class, Short.TYPE), (String)"short -> short");
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(Short.class, Integer.TYPE), (String)"short -> int");
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(Short.class, Long.TYPE), (String)"short -> long");
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(Short.class, Float.TYPE), (String)"short -> float");
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(Short.class, Double.TYPE), (String)"short -> double");
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Short.class, Boolean.TYPE), (String)"short -> boolean");
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(Character.class, Character.TYPE), (String)"char -> char");
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Character.class, Byte.TYPE), (String)"char -> byte");
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Character.class, Short.TYPE), (String)"char -> short");
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(Character.class, Integer.TYPE), (String)"char -> int");
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(Character.class, Long.TYPE), (String)"char -> long");
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(Character.class, Float.TYPE), (String)"char -> float");
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(Character.class, Double.TYPE), (String)"char -> double");
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Character.class, Boolean.TYPE), (String)"char -> boolean");
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Integer.class, Character.TYPE), (String)"int -> char");
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Integer.class, Byte.TYPE), (String)"int -> byte");
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Integer.class, Short.TYPE), (String)"int -> short");
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(Integer.class, Integer.TYPE), (String)"int -> int");
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(Integer.class, Long.TYPE), (String)"int -> long");
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(Integer.class, Float.TYPE), (String)"int -> float");
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(Integer.class, Double.TYPE), (String)"int -> double");
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Integer.class, Boolean.TYPE), (String)"int -> boolean");
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Long.class, Character.TYPE), (String)"long -> char");
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Long.class, Byte.TYPE), (String)"long -> byte");
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Long.class, Short.TYPE), (String)"long -> short");
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Long.class, Integer.TYPE), (String)"long -> int");
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(Long.class, Long.TYPE), (String)"long -> long");
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(Long.class, Float.TYPE), (String)"long -> float");
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(Long.class, Double.TYPE), (String)"long -> double");
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Long.class, Boolean.TYPE), (String)"long -> boolean");
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Float.class, Character.TYPE), (String)"float -> char");
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Float.class, Byte.TYPE), (String)"float -> byte");
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Float.class, Short.TYPE), (String)"float -> short");
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Float.class, Integer.TYPE), (String)"float -> int");
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Float.class, Long.TYPE), (String)"float -> long");
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(Float.class, Float.TYPE), (String)"float -> float");
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(Float.class, Double.TYPE), (String)"float -> double");
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Float.class, Boolean.TYPE), (String)"float -> boolean");
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Double.class, Character.TYPE), (String)"double -> char");
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Double.class, Byte.TYPE), (String)"double -> byte");
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Double.class, Short.TYPE), (String)"double -> short");
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Double.class, Integer.TYPE), (String)"double -> int");
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Double.class, Long.TYPE), (String)"double -> long");
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Double.class, Float.TYPE), (String)"double -> float");
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(Double.class, Double.TYPE), (String)"double -> double");
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Double.class, Boolean.TYPE), (String)"double -> boolean");
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Boolean.class, Character.TYPE), (String)"boolean -> char");
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Boolean.class, Byte.TYPE), (String)"boolean -> byte");
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Boolean.class, Short.TYPE), (String)"boolean -> short");
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Boolean.class, Integer.TYPE), (String)"boolean -> int");
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Boolean.class, Long.TYPE), (String)"boolean -> long");
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Boolean.class, Float.TYPE), (String)"boolean -> float");
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Boolean.class, Double.TYPE), (String)"boolean -> double");
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(Boolean.class, Boolean.TYPE), (String)"boolean -> boolean");
    }

    @Test
    public void test_isAssignable_NoAutoboxing() {
        Assertions.assertFalse((boolean)ClassUtils.isAssignable((Class)null, null, (boolean)false));
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(String.class, null, (boolean)false));
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(null, Object.class, (boolean)false));
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(null, Integer.class, (boolean)false));
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(null, Integer.TYPE, (boolean)false));
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(String.class, Object.class, (boolean)false));
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(String.class, String.class, (boolean)false));
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Object.class, String.class, (boolean)false));
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Integer.TYPE, Integer.class, (boolean)false));
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Integer.TYPE, Object.class, (boolean)false));
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Integer.class, Integer.TYPE, (boolean)false));
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(Integer.TYPE, Integer.TYPE, (boolean)false));
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(Integer.class, Integer.class, (boolean)false));
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Boolean.TYPE, Boolean.class, (boolean)false));
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Boolean.TYPE, Object.class, (boolean)false));
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Boolean.class, Boolean.TYPE, (boolean)false));
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(Boolean.class, Object.class, (boolean)false));
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(Boolean.TYPE, Boolean.TYPE, (boolean)false));
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(Boolean.class, Boolean.class, (boolean)false));
    }

    @Test
    public void test_isAssignable_Unboxing_Widening() {
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Byte.class, Character.TYPE, (boolean)true), (String)"byte -> char");
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(Byte.class, Byte.TYPE, (boolean)true), (String)"byte -> byte");
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(Byte.class, Short.TYPE, (boolean)true), (String)"byte -> short");
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(Byte.class, Integer.TYPE, (boolean)true), (String)"byte -> int");
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(Byte.class, Long.TYPE, (boolean)true), (String)"byte -> long");
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(Byte.class, Float.TYPE, (boolean)true), (String)"byte -> float");
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(Byte.class, Double.TYPE, (boolean)true), (String)"byte -> double");
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Byte.class, Boolean.TYPE, (boolean)true), (String)"byte -> boolean");
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Short.class, Character.TYPE, (boolean)true), (String)"short -> char");
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Short.class, Byte.TYPE, (boolean)true), (String)"short -> byte");
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(Short.class, Short.TYPE, (boolean)true), (String)"short -> short");
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(Short.class, Integer.TYPE, (boolean)true), (String)"short -> int");
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(Short.class, Long.TYPE, (boolean)true), (String)"short -> long");
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(Short.class, Float.TYPE, (boolean)true), (String)"short -> float");
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(Short.class, Double.TYPE, (boolean)true), (String)"short -> double");
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Short.class, Boolean.TYPE, (boolean)true), (String)"short -> boolean");
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(Character.class, Character.TYPE, (boolean)true), (String)"char -> char");
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Character.class, Byte.TYPE, (boolean)true), (String)"char -> byte");
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Character.class, Short.TYPE, (boolean)true), (String)"char -> short");
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(Character.class, Integer.TYPE, (boolean)true), (String)"char -> int");
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(Character.class, Long.TYPE, (boolean)true), (String)"char -> long");
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(Character.class, Float.TYPE, (boolean)true), (String)"char -> float");
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(Character.class, Double.TYPE, (boolean)true), (String)"char -> double");
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Character.class, Boolean.TYPE, (boolean)true), (String)"char -> boolean");
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Integer.class, Character.TYPE, (boolean)true), (String)"int -> char");
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Integer.class, Byte.TYPE, (boolean)true), (String)"int -> byte");
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Integer.class, Short.TYPE, (boolean)true), (String)"int -> short");
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(Integer.class, Integer.TYPE, (boolean)true), (String)"int -> int");
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(Integer.class, Long.TYPE, (boolean)true), (String)"int -> long");
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(Integer.class, Float.TYPE, (boolean)true), (String)"int -> float");
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(Integer.class, Double.TYPE, (boolean)true), (String)"int -> double");
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Integer.class, Boolean.TYPE, (boolean)true), (String)"int -> boolean");
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Long.class, Character.TYPE, (boolean)true), (String)"long -> char");
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Long.class, Byte.TYPE, (boolean)true), (String)"long -> byte");
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Long.class, Short.TYPE, (boolean)true), (String)"long -> short");
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Long.class, Integer.TYPE, (boolean)true), (String)"long -> int");
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(Long.class, Long.TYPE, (boolean)true), (String)"long -> long");
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(Long.class, Float.TYPE, (boolean)true), (String)"long -> float");
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(Long.class, Double.TYPE, (boolean)true), (String)"long -> double");
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Long.class, Boolean.TYPE, (boolean)true), (String)"long -> boolean");
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Float.class, Character.TYPE, (boolean)true), (String)"float -> char");
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Float.class, Byte.TYPE, (boolean)true), (String)"float -> byte");
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Float.class, Short.TYPE, (boolean)true), (String)"float -> short");
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Float.class, Integer.TYPE, (boolean)true), (String)"float -> int");
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Float.class, Long.TYPE, (boolean)true), (String)"float -> long");
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(Float.class, Float.TYPE, (boolean)true), (String)"float -> float");
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(Float.class, Double.TYPE, (boolean)true), (String)"float -> double");
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Float.class, Boolean.TYPE, (boolean)true), (String)"float -> boolean");
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Double.class, Character.TYPE, (boolean)true), (String)"double -> char");
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Double.class, Byte.TYPE, (boolean)true), (String)"double -> byte");
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Double.class, Short.TYPE, (boolean)true), (String)"double -> short");
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Double.class, Integer.TYPE, (boolean)true), (String)"double -> int");
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Double.class, Long.TYPE, (boolean)true), (String)"double -> long");
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Double.class, Float.TYPE, (boolean)true), (String)"double -> float");
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(Double.class, Double.TYPE, (boolean)true), (String)"double -> double");
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Double.class, Boolean.TYPE, (boolean)true), (String)"double -> boolean");
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Boolean.class, Character.TYPE, (boolean)true), (String)"boolean -> char");
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Boolean.class, Byte.TYPE, (boolean)true), (String)"boolean -> byte");
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Boolean.class, Short.TYPE, (boolean)true), (String)"boolean -> short");
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Boolean.class, Integer.TYPE, (boolean)true), (String)"boolean -> int");
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Boolean.class, Long.TYPE, (boolean)true), (String)"boolean -> long");
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Boolean.class, Float.TYPE, (boolean)true), (String)"boolean -> float");
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Boolean.class, Double.TYPE, (boolean)true), (String)"boolean -> double");
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(Boolean.class, Boolean.TYPE, (boolean)true), (String)"boolean -> boolean");
    }

    @Test
    public void test_isAssignable_Widening() {
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Byte.TYPE, Character.TYPE), (String)"byte -> char");
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(Byte.TYPE, Byte.TYPE), (String)"byte -> byte");
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(Byte.TYPE, Short.TYPE), (String)"byte -> short");
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(Byte.TYPE, Integer.TYPE), (String)"byte -> int");
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(Byte.TYPE, Long.TYPE), (String)"byte -> long");
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(Byte.TYPE, Float.TYPE), (String)"byte -> float");
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(Byte.TYPE, Double.TYPE), (String)"byte -> double");
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Byte.TYPE, Boolean.TYPE), (String)"byte -> boolean");
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Short.TYPE, Character.TYPE), (String)"short -> char");
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Short.TYPE, Byte.TYPE), (String)"short -> byte");
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(Short.TYPE, Short.TYPE), (String)"short -> short");
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(Short.TYPE, Integer.TYPE), (String)"short -> int");
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(Short.TYPE, Long.TYPE), (String)"short -> long");
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(Short.TYPE, Float.TYPE), (String)"short -> float");
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(Short.TYPE, Double.TYPE), (String)"short -> double");
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Short.TYPE, Boolean.TYPE), (String)"short -> boolean");
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(Character.TYPE, Character.TYPE), (String)"char -> char");
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Character.TYPE, Byte.TYPE), (String)"char -> byte");
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Character.TYPE, Short.TYPE), (String)"char -> short");
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(Character.TYPE, Integer.TYPE), (String)"char -> int");
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(Character.TYPE, Long.TYPE), (String)"char -> long");
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(Character.TYPE, Float.TYPE), (String)"char -> float");
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(Character.TYPE, Double.TYPE), (String)"char -> double");
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Character.TYPE, Boolean.TYPE), (String)"char -> boolean");
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Integer.TYPE, Character.TYPE), (String)"int -> char");
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Integer.TYPE, Byte.TYPE), (String)"int -> byte");
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Integer.TYPE, Short.TYPE), (String)"int -> short");
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(Integer.TYPE, Integer.TYPE), (String)"int -> int");
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(Integer.TYPE, Long.TYPE), (String)"int -> long");
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(Integer.TYPE, Float.TYPE), (String)"int -> float");
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(Integer.TYPE, Double.TYPE), (String)"int -> double");
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Integer.TYPE, Boolean.TYPE), (String)"int -> boolean");
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Long.TYPE, Character.TYPE), (String)"long -> char");
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Long.TYPE, Byte.TYPE), (String)"long -> byte");
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Long.TYPE, Short.TYPE), (String)"long -> short");
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Long.TYPE, Integer.TYPE), (String)"long -> int");
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(Long.TYPE, Long.TYPE), (String)"long -> long");
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(Long.TYPE, Float.TYPE), (String)"long -> float");
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(Long.TYPE, Double.TYPE), (String)"long -> double");
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Long.TYPE, Boolean.TYPE), (String)"long -> boolean");
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Float.TYPE, Character.TYPE), (String)"float -> char");
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Float.TYPE, Byte.TYPE), (String)"float -> byte");
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Float.TYPE, Short.TYPE), (String)"float -> short");
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Float.TYPE, Integer.TYPE), (String)"float -> int");
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Float.TYPE, Long.TYPE), (String)"float -> long");
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(Float.TYPE, Float.TYPE), (String)"float -> float");
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(Float.TYPE, Double.TYPE), (String)"float -> double");
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Float.TYPE, Boolean.TYPE), (String)"float -> boolean");
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Double.TYPE, Character.TYPE), (String)"double -> char");
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Double.TYPE, Byte.TYPE), (String)"double -> byte");
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Double.TYPE, Short.TYPE), (String)"double -> short");
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Double.TYPE, Integer.TYPE), (String)"double -> int");
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Double.TYPE, Long.TYPE), (String)"double -> long");
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Double.TYPE, Float.TYPE), (String)"double -> float");
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(Double.TYPE, Double.TYPE), (String)"double -> double");
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Double.TYPE, Boolean.TYPE), (String)"double -> boolean");
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Boolean.TYPE, Character.TYPE), (String)"boolean -> char");
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Boolean.TYPE, Byte.TYPE), (String)"boolean -> byte");
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Boolean.TYPE, Short.TYPE), (String)"boolean -> short");
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Boolean.TYPE, Integer.TYPE), (String)"boolean -> int");
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Boolean.TYPE, Long.TYPE), (String)"boolean -> long");
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Boolean.TYPE, Float.TYPE), (String)"boolean -> float");
        Assertions.assertFalse((boolean)ClassUtils.isAssignable(Boolean.TYPE, Double.TYPE), (String)"boolean -> double");
        Assertions.assertTrue((boolean)ClassUtils.isAssignable(Boolean.TYPE, Boolean.TYPE), (String)"boolean -> boolean");
    }

    @Test
    public void test_isInnerClass_Class() {
        Assertions.assertTrue((boolean)ClassUtils.isInnerClass(Inner.class));
        Assertions.assertTrue((boolean)ClassUtils.isInnerClass(Map.Entry.class));
        Assertions.assertTrue((boolean)ClassUtils.isInnerClass(new Cloneable(){}.getClass()));
        Assertions.assertFalse((boolean)ClassUtils.isInnerClass(this.getClass()));
        Assertions.assertFalse((boolean)ClassUtils.isInnerClass(String.class));
        Assertions.assertFalse((boolean)ClassUtils.isInnerClass(null));
    }

    @Test
    public void testConstructor() {
        Assertions.assertNotNull((Object)new ClassUtils());
        Constructor<?>[] cons = ClassUtils.class.getDeclaredConstructors();
        Assertions.assertEquals((int)1, (int)cons.length);
        Assertions.assertTrue((boolean)Modifier.isPublic(cons[0].getModifiers()));
        Assertions.assertTrue((boolean)Modifier.isPublic(ClassUtils.class.getModifiers()));
        Assertions.assertFalse((boolean)Modifier.isFinal(ClassUtils.class.getModifiers()));
    }

    @Test
    public void testGetClassByNormalNameArrays() throws ClassNotFoundException {
        Assertions.assertEquals(int[].class, (Object)ClassUtils.getClass((String)"int[]"));
        Assertions.assertEquals(long[].class, (Object)ClassUtils.getClass((String)"long[]"));
        Assertions.assertEquals(short[].class, (Object)ClassUtils.getClass((String)"short[]"));
        Assertions.assertEquals(byte[].class, (Object)ClassUtils.getClass((String)"byte[]"));
        Assertions.assertEquals(char[].class, (Object)ClassUtils.getClass((String)"char[]"));
        Assertions.assertEquals(float[].class, (Object)ClassUtils.getClass((String)"float[]"));
        Assertions.assertEquals(double[].class, (Object)ClassUtils.getClass((String)"double[]"));
        Assertions.assertEquals(boolean[].class, (Object)ClassUtils.getClass((String)"boolean[]"));
        Assertions.assertEquals(String[].class, (Object)ClassUtils.getClass((String)"java.lang.String[]"));
        Assertions.assertEquals(Map.Entry[].class, (Object)ClassUtils.getClass((String)"java.util.Map.Entry[]"));
        Assertions.assertEquals(Map.Entry[].class, (Object)ClassUtils.getClass((String)"java.util.Map$Entry[]"));
        Assertions.assertEquals(Map.Entry[].class, (Object)ClassUtils.getClass((String)"[Ljava.util.Map.Entry;"));
        Assertions.assertEquals(Map.Entry[].class, (Object)ClassUtils.getClass((String)"[Ljava.util.Map$Entry;"));
    }

    @Test
    public void testGetClassByNormalNameArrays2D() throws ClassNotFoundException {
        Assertions.assertEquals(int[][].class, (Object)ClassUtils.getClass((String)"int[][]"));
        Assertions.assertEquals(long[][].class, (Object)ClassUtils.getClass((String)"long[][]"));
        Assertions.assertEquals(short[][].class, (Object)ClassUtils.getClass((String)"short[][]"));
        Assertions.assertEquals(byte[][].class, (Object)ClassUtils.getClass((String)"byte[][]"));
        Assertions.assertEquals(char[][].class, (Object)ClassUtils.getClass((String)"char[][]"));
        Assertions.assertEquals(float[][].class, (Object)ClassUtils.getClass((String)"float[][]"));
        Assertions.assertEquals(double[][].class, (Object)ClassUtils.getClass((String)"double[][]"));
        Assertions.assertEquals(boolean[][].class, (Object)ClassUtils.getClass((String)"boolean[][]"));
        Assertions.assertEquals(String[][].class, (Object)ClassUtils.getClass((String)"java.lang.String[][]"));
    }

    @Test
    public void testGetClassClassNotFound() throws Exception {
        this.assertGetClassThrowsClassNotFound("bool");
        this.assertGetClassThrowsClassNotFound("bool[]");
        this.assertGetClassThrowsClassNotFound("integer[]");
    }

    @Test
    public void testGetClassInvalidArguments() throws Exception {
        this.assertGetClassThrowsNullPointerException(null);
        this.assertGetClassThrowsClassNotFound("[][][]");
        this.assertGetClassThrowsClassNotFound("[[]");
        this.assertGetClassThrowsClassNotFound("[");
        this.assertGetClassThrowsClassNotFound("java.lang.String][");
        this.assertGetClassThrowsClassNotFound(".hello.world");
        this.assertGetClassThrowsClassNotFound("hello..world");
    }

    @Test
    public void testGetClassRawPrimitives() throws ClassNotFoundException {
        Assertions.assertEquals(Integer.TYPE, (Object)ClassUtils.getClass((String)"int"));
        Assertions.assertEquals(Long.TYPE, (Object)ClassUtils.getClass((String)"long"));
        Assertions.assertEquals(Short.TYPE, (Object)ClassUtils.getClass((String)"short"));
        Assertions.assertEquals(Byte.TYPE, (Object)ClassUtils.getClass((String)"byte"));
        Assertions.assertEquals(Character.TYPE, (Object)ClassUtils.getClass((String)"char"));
        Assertions.assertEquals(Float.TYPE, (Object)ClassUtils.getClass((String)"float"));
        Assertions.assertEquals(Double.TYPE, (Object)ClassUtils.getClass((String)"double"));
        Assertions.assertEquals(Boolean.TYPE, (Object)ClassUtils.getClass((String)"boolean"));
        Assertions.assertEquals(Void.TYPE, (Object)ClassUtils.getClass((String)"void"));
    }

    @Test
    public void testGetClassWithArrayClasses() throws Exception {
        this.assertGetClassReturnsClass(String[].class);
        this.assertGetClassReturnsClass(int[].class);
        this.assertGetClassReturnsClass(long[].class);
        this.assertGetClassReturnsClass(short[].class);
        this.assertGetClassReturnsClass(byte[].class);
        this.assertGetClassReturnsClass(char[].class);
        this.assertGetClassReturnsClass(float[].class);
        this.assertGetClassReturnsClass(double[].class);
        this.assertGetClassReturnsClass(boolean[].class);
    }

    @Test
    public void testGetClassWithArrayClasses2D() throws Exception {
        this.assertGetClassReturnsClass(String[][].class);
        this.assertGetClassReturnsClass(int[][].class);
        this.assertGetClassReturnsClass(long[][].class);
        this.assertGetClassReturnsClass(short[][].class);
        this.assertGetClassReturnsClass(byte[][].class);
        this.assertGetClassReturnsClass(char[][].class);
        this.assertGetClassReturnsClass(float[][].class);
        this.assertGetClassReturnsClass(double[][].class);
        this.assertGetClassReturnsClass(boolean[][].class);
    }

    @Test
    public void testGetInnerClass() throws ClassNotFoundException {
        Assertions.assertEquals(Inner.DeeplyNested.class, (Object)ClassUtils.getClass((String)"org.apache.commons.lang3.ClassUtilsTest.Inner.DeeplyNested"));
        Assertions.assertEquals(Inner.DeeplyNested.class, (Object)ClassUtils.getClass((String)"org.apache.commons.lang3.ClassUtilsTest.Inner$DeeplyNested"));
        Assertions.assertEquals(Inner.DeeplyNested.class, (Object)ClassUtils.getClass((String)"org.apache.commons.lang3.ClassUtilsTest$Inner$DeeplyNested"));
        Assertions.assertEquals(Inner.DeeplyNested.class, (Object)ClassUtils.getClass((String)"org.apache.commons.lang3.ClassUtilsTest$Inner.DeeplyNested"));
    }

    @Test
    public void testGetPublicMethod() throws Exception {
        Set set = Collections.unmodifiableSet(new HashSet());
        Method isEmptyMethod = ClassUtils.getPublicMethod(set.getClass(), (String)"isEmpty", (Class[])new Class[0]);
        Assertions.assertTrue((boolean)Modifier.isPublic(isEmptyMethod.getDeclaringClass().getModifiers()));
        Assertions.assertTrue((boolean)((Boolean)isEmptyMethod.invoke(set, new Object[0])));
        Method toStringMethod = ClassUtils.getPublicMethod(Object.class, (String)"toString", (Class[])new Class[0]);
        Assertions.assertEquals((Object)Object.class.getMethod("toString", new Class[0]), (Object)toStringMethod);
    }

    @Test
    public void testHierarchyExcludingInterfaces() {
        Iterator iter = ClassUtils.hierarchy(StringParameterizedChild.class).iterator();
        Assertions.assertEquals(StringParameterizedChild.class, iter.next());
        Assertions.assertEquals(GenericParent.class, iter.next());
        Assertions.assertEquals(Object.class, iter.next());
        Assertions.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void testHierarchyIncludingInterfaces() {
        Iterator iter = ClassUtils.hierarchy(StringParameterizedChild.class, (ClassUtils.Interfaces)ClassUtils.Interfaces.INCLUDE).iterator();
        Assertions.assertEquals(StringParameterizedChild.class, iter.next());
        Assertions.assertEquals(GenericParent.class, iter.next());
        Assertions.assertEquals(GenericConsumer.class, iter.next());
        Assertions.assertEquals(Object.class, iter.next());
        Assertions.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void testIsPrimitiveOrWrapper() {
        Assertions.assertTrue((boolean)ClassUtils.isPrimitiveOrWrapper(Boolean.class), (String)"Boolean.class");
        Assertions.assertTrue((boolean)ClassUtils.isPrimitiveOrWrapper(Byte.class), (String)"Byte.class");
        Assertions.assertTrue((boolean)ClassUtils.isPrimitiveOrWrapper(Character.class), (String)"Character.class");
        Assertions.assertTrue((boolean)ClassUtils.isPrimitiveOrWrapper(Short.class), (String)"Short.class");
        Assertions.assertTrue((boolean)ClassUtils.isPrimitiveOrWrapper(Integer.class), (String)"Integer.class");
        Assertions.assertTrue((boolean)ClassUtils.isPrimitiveOrWrapper(Long.class), (String)"Long.class");
        Assertions.assertTrue((boolean)ClassUtils.isPrimitiveOrWrapper(Double.class), (String)"Double.class");
        Assertions.assertTrue((boolean)ClassUtils.isPrimitiveOrWrapper(Float.class), (String)"Float.class");
        Assertions.assertTrue((boolean)ClassUtils.isPrimitiveOrWrapper(Boolean.TYPE), (String)"boolean");
        Assertions.assertTrue((boolean)ClassUtils.isPrimitiveOrWrapper(Byte.TYPE), (String)"byte");
        Assertions.assertTrue((boolean)ClassUtils.isPrimitiveOrWrapper(Character.TYPE), (String)"char");
        Assertions.assertTrue((boolean)ClassUtils.isPrimitiveOrWrapper(Short.TYPE), (String)"short");
        Assertions.assertTrue((boolean)ClassUtils.isPrimitiveOrWrapper(Integer.TYPE), (String)"int");
        Assertions.assertTrue((boolean)ClassUtils.isPrimitiveOrWrapper(Long.TYPE), (String)"long");
        Assertions.assertTrue((boolean)ClassUtils.isPrimitiveOrWrapper(Double.TYPE), (String)"double");
        Assertions.assertTrue((boolean)ClassUtils.isPrimitiveOrWrapper(Float.TYPE), (String)"float");
        Assertions.assertTrue((boolean)ClassUtils.isPrimitiveOrWrapper(Void.TYPE), (String)"Void.TYPE");
        Assertions.assertFalse((boolean)ClassUtils.isPrimitiveOrWrapper(null), (String)"null");
        Assertions.assertFalse((boolean)ClassUtils.isPrimitiveOrWrapper(Void.class), (String)"Void.class");
        Assertions.assertFalse((boolean)ClassUtils.isPrimitiveOrWrapper(String.class), (String)"String.class");
        Assertions.assertFalse((boolean)ClassUtils.isPrimitiveOrWrapper(this.getClass()), (String)"this.getClass()");
    }

    @Test
    public void testIsPrimitiveWrapper() {
        Assertions.assertTrue((boolean)ClassUtils.isPrimitiveWrapper(Boolean.class), (String)"Boolean.class");
        Assertions.assertTrue((boolean)ClassUtils.isPrimitiveWrapper(Byte.class), (String)"Byte.class");
        Assertions.assertTrue((boolean)ClassUtils.isPrimitiveWrapper(Character.class), (String)"Character.class");
        Assertions.assertTrue((boolean)ClassUtils.isPrimitiveWrapper(Short.class), (String)"Short.class");
        Assertions.assertTrue((boolean)ClassUtils.isPrimitiveWrapper(Integer.class), (String)"Integer.class");
        Assertions.assertTrue((boolean)ClassUtils.isPrimitiveWrapper(Long.class), (String)"Long.class");
        Assertions.assertTrue((boolean)ClassUtils.isPrimitiveWrapper(Double.class), (String)"Double.class");
        Assertions.assertTrue((boolean)ClassUtils.isPrimitiveWrapper(Float.class), (String)"Float.class");
        Assertions.assertFalse((boolean)ClassUtils.isPrimitiveWrapper(Boolean.TYPE), (String)"boolean");
        Assertions.assertFalse((boolean)ClassUtils.isPrimitiveWrapper(Byte.TYPE), (String)"byte");
        Assertions.assertFalse((boolean)ClassUtils.isPrimitiveWrapper(Character.TYPE), (String)"char");
        Assertions.assertFalse((boolean)ClassUtils.isPrimitiveWrapper(Short.TYPE), (String)"short");
        Assertions.assertFalse((boolean)ClassUtils.isPrimitiveWrapper(Integer.TYPE), (String)"int");
        Assertions.assertFalse((boolean)ClassUtils.isPrimitiveWrapper(Long.TYPE), (String)"long");
        Assertions.assertFalse((boolean)ClassUtils.isPrimitiveWrapper(Double.TYPE), (String)"double");
        Assertions.assertFalse((boolean)ClassUtils.isPrimitiveWrapper(Float.TYPE), (String)"float");
        Assertions.assertFalse((boolean)ClassUtils.isPrimitiveWrapper(null), (String)"null");
        Assertions.assertFalse((boolean)ClassUtils.isPrimitiveWrapper(Void.class), (String)"Void.class");
        Assertions.assertFalse((boolean)ClassUtils.isPrimitiveWrapper(Void.TYPE), (String)"Void.TYPE");
        Assertions.assertFalse((boolean)ClassUtils.isPrimitiveWrapper(String.class), (String)"String.class");
        Assertions.assertFalse((boolean)ClassUtils.isPrimitiveWrapper(this.getClass()), (String)"this.getClass()");
    }

    @Test
    public void testPrimitivesToWrappers() {
        Assertions.assertNull((Object)ClassUtils.primitivesToWrappers((Class[])null), (String)"null -> null");
        Assertions.assertArrayEquals((Object[])ArrayUtils.EMPTY_CLASS_ARRAY, (Object[])ClassUtils.primitivesToWrappers((Class[])new Class[0]), (String)"empty -> empty");
        Object[] castNull = ClassUtils.primitivesToWrappers((Class[])new Class[]{null});
        Assertions.assertArrayEquals((Object[])new Class[]{null}, (Object[])castNull, (String)"(Class<?>) null -> [null]");
        Assertions.assertArrayEquals((Object[])ArrayUtils.EMPTY_CLASS_ARRAY, (Object[])ClassUtils.primitivesToWrappers((Class[])ArrayUtils.EMPTY_CLASS_ARRAY), (String)"empty -> empty");
        Class[] primitives = new Class[]{Boolean.TYPE, Byte.TYPE, Character.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Double.TYPE, Float.TYPE, String.class, ClassUtils.class};
        Class[] wrappers = ClassUtils.primitivesToWrappers((Class[])primitives);
        for (int i = 0; i < primitives.length; ++i) {
            Class primitive = primitives[i];
            Class expectedWrapper = ClassUtils.primitiveToWrapper((Class)primitive);
            Assertions.assertEquals((Object)expectedWrapper, (Object)wrappers[i], (String)(primitive + " -> " + expectedWrapper));
        }
        Class[] noPrimitives = new Class[]{String.class, ClassUtils.class, Void.TYPE};
        Assertions.assertNotSame((Object)noPrimitives, (Object)ClassUtils.primitivesToWrappers((Class[])noPrimitives), (String)"unmodified");
    }

    @Test
    public void testPrimitiveToWrapper() {
        Assertions.assertEquals(Boolean.class, (Object)ClassUtils.primitiveToWrapper(Boolean.TYPE), (String)"boolean -> Boolean.class");
        Assertions.assertEquals(Byte.class, (Object)ClassUtils.primitiveToWrapper(Byte.TYPE), (String)"byte -> Byte.class");
        Assertions.assertEquals(Character.class, (Object)ClassUtils.primitiveToWrapper(Character.TYPE), (String)"char -> Character.class");
        Assertions.assertEquals(Short.class, (Object)ClassUtils.primitiveToWrapper(Short.TYPE), (String)"short -> Short.class");
        Assertions.assertEquals(Integer.class, (Object)ClassUtils.primitiveToWrapper(Integer.TYPE), (String)"int -> Integer.class");
        Assertions.assertEquals(Long.class, (Object)ClassUtils.primitiveToWrapper(Long.TYPE), (String)"long -> Long.class");
        Assertions.assertEquals(Double.class, (Object)ClassUtils.primitiveToWrapper(Double.TYPE), (String)"double -> Double.class");
        Assertions.assertEquals(Float.class, (Object)ClassUtils.primitiveToWrapper(Float.TYPE), (String)"float -> Float.class");
        Assertions.assertEquals(String.class, (Object)ClassUtils.primitiveToWrapper(String.class), (String)"String.class -> String.class");
        Assertions.assertEquals(ClassUtils.class, (Object)ClassUtils.primitiveToWrapper(ClassUtils.class), (String)"ClassUtils.class -> ClassUtils.class");
        Assertions.assertEquals(Void.TYPE, (Object)ClassUtils.primitiveToWrapper(Void.TYPE), (String)"Void.TYPE -> Void.TYPE");
        Assertions.assertNull((Object)ClassUtils.primitiveToWrapper(null), (String)"null -> null");
    }

    @Test
    public void testShowJavaBug() throws Exception {
        Set set = Collections.unmodifiableSet(new HashSet());
        Method isEmptyMethod = set.getClass().getMethod("isEmpty", new Class[0]);
        Assertions.assertThrows(IllegalAccessException.class, () -> isEmptyMethod.invoke((Object)set, new Object[0]));
    }

    @Test
    public void testToClass_object() {
        Assertions.assertNull((Object)ClassUtils.toClass((Object[])null));
        Assertions.assertArrayEquals((Object[])ArrayUtils.EMPTY_CLASS_ARRAY, (Object[])ClassUtils.toClass((Object[])new Object[0]), (String)"empty -> empty");
        Object[] castNull = ClassUtils.toClass((Object[])new Object[]{null});
        Assertions.assertArrayEquals((Object[])new Object[]{null}, (Object[])castNull, (String)"(Object) null -> [null]");
        Assertions.assertSame((Object)ArrayUtils.EMPTY_CLASS_ARRAY, (Object)ClassUtils.toClass((Object[])ArrayUtils.EMPTY_OBJECT_ARRAY));
        Assertions.assertArrayEquals((Object[])new Class[]{String.class, Integer.class, Double.class}, (Object[])ClassUtils.toClass((Object[])new Object[]{"Test", 1, 99.0}));
        Assertions.assertArrayEquals((Object[])new Class[]{String.class, null, Double.class}, (Object[])ClassUtils.toClass((Object[])new Object[]{"Test", null, 99.0}));
    }

    @Test
    public void testWithInterleavingWhitespace() throws ClassNotFoundException {
        Assertions.assertEquals(int[].class, (Object)ClassUtils.getClass((String)" int [ ] "));
        Assertions.assertEquals(long[].class, (Object)ClassUtils.getClass((String)"\rlong\t[\n]\r"));
        Assertions.assertEquals(short[].class, (Object)ClassUtils.getClass((String)"\tshort                \t\t[]"));
        Assertions.assertEquals(byte[].class, (Object)ClassUtils.getClass((String)"byte[\t\t\n\r]   "));
    }

    @Test
    public void testWrappersToPrimitives() {
        Class[] classes = new Class[]{Boolean.class, Byte.class, Character.class, Short.class, Integer.class, Long.class, Float.class, Double.class, String.class, ClassUtils.class, null};
        Class[] primitives = ClassUtils.wrappersToPrimitives((Class[])classes);
        Assertions.assertEquals((int)classes.length, (int)primitives.length, (String)"Wrong length of result array");
        for (int i = 0; i < classes.length; ++i) {
            Class expectedPrimitive = ClassUtils.wrapperToPrimitive((Class)classes[i]);
            Assertions.assertEquals((Object)expectedPrimitive, (Object)primitives[i], (String)(classes[i] + " -> " + expectedPrimitive));
        }
    }

    @Test
    public void testWrappersToPrimitivesEmpty() {
        Object[] empty = new Class[]{};
        Assertions.assertArrayEquals((Object[])empty, (Object[])ClassUtils.wrappersToPrimitives((Class[])empty), (String)"Wrong result for empty input");
    }

    @Test
    public void testWrappersToPrimitivesNull() {
        Assertions.assertNull((Object)ClassUtils.wrappersToPrimitives((Class[])null), (String)"Wrong result for null input");
        Assertions.assertArrayEquals((Object[])ArrayUtils.EMPTY_CLASS_ARRAY, (Object[])ClassUtils.wrappersToPrimitives((Class[])new Class[0]), (String)"empty -> empty");
        Object[] castNull = ClassUtils.wrappersToPrimitives((Class[])new Class[]{null});
        Assertions.assertArrayEquals((Object[])new Class[]{null}, (Object[])castNull, (String)"(Class<?>) null -> [null]");
    }

    @Test
    public void testWrapperToPrimitive() {
        Class[] primitives;
        for (Class primitive : primitives = new Class[]{Boolean.TYPE, Byte.TYPE, Character.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE}) {
            Class wrapperCls = ClassUtils.primitiveToWrapper((Class)primitive);
            Assertions.assertFalse((boolean)wrapperCls.isPrimitive(), (String)"Still primitive");
            Assertions.assertEquals((Object)primitive, (Object)ClassUtils.wrapperToPrimitive((Class)wrapperCls), (String)(wrapperCls + " -> " + primitive));
        }
    }

    @Test
    public void testWrapperToPrimitiveNoWrapper() {
        Assertions.assertNull((Object)ClassUtils.wrapperToPrimitive(String.class), (String)"Wrong result for non wrapper class");
    }

    @Test
    public void testWrapperToPrimitiveNull() {
        Assertions.assertNull((Object)ClassUtils.wrapperToPrimitive(null), (String)"Wrong result for null class");
    }

    private static class Inner {
        private Inner() {
        }

        private class DeeplyNested {
            private DeeplyNested() {
            }
        }
    }

    private static interface IF {
    }

    private static interface IE
    extends IF {
    }

    private static interface ID {
    }

    private static interface IC
    extends ID,
    IE {
    }

    private static interface IB {
    }

    private static interface IA {
    }

    private static class CY
    extends CX
    implements IB,
    IC {
        private CY() {
        }
    }

    private static class CX
    implements IB,
    IA,
    IE {
        private CX() {
        }
    }
}

