/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.concurrent.Callable;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.commons.lang3.Functions;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

public class FunctionsTest {
    @Test
    public void testAcceptBiConsumer() {
        IllegalStateException ise = new IllegalStateException();
        Testable testable = new Testable(null);
        Throwable e = Assertions.assertThrows(IllegalStateException.class, () -> Functions.accept(Testable::test, (Object)testable, (Object)ise));
        Assertions.assertSame((Object)ise, (Object)e);
        OutOfMemoryError error = new OutOfMemoryError();
        e = Assertions.assertThrows(OutOfMemoryError.class, () -> Functions.accept(Testable::test, (Object)testable, (Object)error));
        Assertions.assertSame((Object)error, (Object)e);
        IOException ioe = new IOException("Unknown I/O error");
        testable.setThrowable(ioe);
        e = Assertions.assertThrows(UncheckedIOException.class, () -> Functions.accept(Testable::test, (Object)testable, (Object)ioe));
        Throwable t = e.getCause();
        Assertions.assertNotNull((Object)t);
        Assertions.assertSame((Object)ioe, (Object)t);
        testable.setThrowable(null);
        Functions.accept(Testable::test, testable, (Object)null);
    }

    @Test
    public void testAcceptConsumer() {
        IllegalStateException ise = new IllegalStateException();
        Testable testable = new Testable(ise);
        Throwable e = Assertions.assertThrows(IllegalStateException.class, () -> Functions.accept(Testable::test, (Object)testable));
        Assertions.assertSame((Object)ise, (Object)e);
        OutOfMemoryError error = new OutOfMemoryError();
        testable.setThrowable(error);
        e = Assertions.assertThrows(OutOfMemoryError.class, () -> Functions.accept(Testable::test, (Object)testable));
        Assertions.assertSame((Object)error, (Object)e);
        IOException ioe = new IOException("Unknown I/O error");
        testable.setThrowable(ioe);
        e = Assertions.assertThrows(UncheckedIOException.class, () -> Functions.accept(Testable::test, (Object)testable));
        Throwable t = e.getCause();
        Assertions.assertNotNull((Object)t);
        Assertions.assertSame((Object)ioe, (Object)t);
        testable.setThrowable(null);
        Functions.accept(Testable::test, testable);
    }

    @Test
    public void testAcceptDoubleConsumer() {
        IllegalStateException ise = new IllegalStateException();
        Testable testable = new Testable(ise);
        Throwable e = Assertions.assertThrows(IllegalStateException.class, () -> Functions.accept(testable::testDouble, (Object)1.0));
        Assertions.assertSame((Object)ise, (Object)e);
        Assertions.assertNull(testable.getAcceptedPrimitiveObject1());
        OutOfMemoryError error = new OutOfMemoryError();
        testable.setThrowable(error);
        e = Assertions.assertThrows(OutOfMemoryError.class, () -> Functions.accept(testable::testDouble, (Object)1.0));
        Assertions.assertSame((Object)error, (Object)e);
        Assertions.assertNull(testable.getAcceptedPrimitiveObject1());
        IOException ioe = new IOException("Unknown I/O error");
        testable.setThrowable(ioe);
        e = Assertions.assertThrows(UncheckedIOException.class, () -> Functions.accept(testable::testDouble, (Object)1.0));
        Throwable t = e.getCause();
        Assertions.assertNotNull((Object)t);
        Assertions.assertSame((Object)ioe, (Object)t);
        Assertions.assertNull(testable.getAcceptedPrimitiveObject1());
        testable.setThrowable(null);
        Functions.accept(testable::testDouble, (Object)1.0);
        Assertions.assertEquals((double)1.0, (Double)((Double)testable.getAcceptedPrimitiveObject1()));
    }

    @Test
    public void testAcceptIntConsumer() {
        IllegalStateException ise = new IllegalStateException();
        Testable testable = new Testable(ise);
        Throwable e = Assertions.assertThrows(IllegalStateException.class, () -> Functions.accept(testable::testInt, (Object)1));
        Assertions.assertSame((Object)ise, (Object)e);
        Assertions.assertNull(testable.getAcceptedPrimitiveObject1());
        OutOfMemoryError error = new OutOfMemoryError();
        testable.setThrowable(error);
        e = Assertions.assertThrows(OutOfMemoryError.class, () -> Functions.accept(testable::testInt, (Object)1));
        Assertions.assertSame((Object)error, (Object)e);
        Assertions.assertNull(testable.getAcceptedPrimitiveObject1());
        IOException ioe = new IOException("Unknown I/O error");
        testable.setThrowable(ioe);
        e = Assertions.assertThrows(UncheckedIOException.class, () -> Functions.accept(testable::testInt, (Object)1));
        Throwable t = e.getCause();
        Assertions.assertNotNull((Object)t);
        Assertions.assertSame((Object)ioe, (Object)t);
        Assertions.assertNull(testable.getAcceptedPrimitiveObject1());
        testable.setThrowable(null);
        Functions.accept(testable::testInt, (Object)1);
        Assertions.assertEquals((int)1, (Integer)((Integer)testable.getAcceptedPrimitiveObject1()));
    }

    @Test
    public void testAcceptLongConsumer() {
        IllegalStateException ise = new IllegalStateException();
        Testable testable = new Testable(ise);
        Throwable e = Assertions.assertThrows(IllegalStateException.class, () -> Functions.accept(testable::testLong, (Object)1L));
        Assertions.assertSame((Object)ise, (Object)e);
        Assertions.assertNull(testable.getAcceptedPrimitiveObject1());
        OutOfMemoryError error = new OutOfMemoryError();
        testable.setThrowable(error);
        e = Assertions.assertThrows(OutOfMemoryError.class, () -> Functions.accept(testable::testLong, (Object)1L));
        Assertions.assertSame((Object)error, (Object)e);
        Assertions.assertNull(testable.getAcceptedPrimitiveObject1());
        IOException ioe = new IOException("Unknown I/O error");
        testable.setThrowable(ioe);
        e = Assertions.assertThrows(UncheckedIOException.class, () -> Functions.accept(testable::testLong, (Object)1L));
        Throwable t = e.getCause();
        Assertions.assertNotNull((Object)t);
        Assertions.assertSame((Object)ioe, (Object)t);
        Assertions.assertNull(testable.getAcceptedPrimitiveObject1());
        testable.setThrowable(null);
        Functions.accept(testable::testLong, (Object)1L);
        Assertions.assertEquals((long)1L, (Long)((Long)testable.getAcceptedPrimitiveObject1()));
    }

    @Test
    public void testAcceptObjDoubleConsumer() {
        IllegalStateException ise = new IllegalStateException();
        Testable testable = new Testable(ise);
        Throwable e = Assertions.assertThrows(IllegalStateException.class, () -> Functions.accept(testable::testObjDouble, (Object)"X", (Object)1.0));
        Assertions.assertSame((Object)ise, (Object)e);
        Assertions.assertNull(testable.getAcceptedObject());
        Assertions.assertNull(testable.getAcceptedPrimitiveObject1());
        OutOfMemoryError error = new OutOfMemoryError();
        testable.setThrowable(error);
        e = Assertions.assertThrows(OutOfMemoryError.class, () -> Functions.accept(testable::testObjDouble, (Object)"X", (Object)1.0));
        Assertions.assertSame((Object)error, (Object)e);
        Assertions.assertNull(testable.getAcceptedObject());
        Assertions.assertNull(testable.getAcceptedPrimitiveObject1());
        IOException ioe = new IOException("Unknown I/O error");
        testable.setThrowable(ioe);
        e = Assertions.assertThrows(UncheckedIOException.class, () -> Functions.accept(testable::testObjDouble, (Object)"X", (Object)1.0));
        Throwable t = e.getCause();
        Assertions.assertNotNull((Object)t);
        Assertions.assertSame((Object)ioe, (Object)t);
        Assertions.assertNull(testable.getAcceptedObject());
        Assertions.assertNull(testable.getAcceptedPrimitiveObject1());
        testable.setThrowable(null);
        Functions.accept(testable::testObjDouble, (Object)"X", (Object)1.0);
        Assertions.assertEquals((Object)"X", testable.getAcceptedObject());
        Assertions.assertEquals((double)1.0, (Double)((Double)testable.getAcceptedPrimitiveObject1()));
    }

    @Test
    public void testAcceptObjIntConsumer() {
        IllegalStateException ise = new IllegalStateException();
        Testable testable = new Testable(ise);
        Throwable e = Assertions.assertThrows(IllegalStateException.class, () -> Functions.accept(testable::testObjInt, (Object)"X", (Object)1));
        Assertions.assertSame((Object)ise, (Object)e);
        Assertions.assertNull(testable.getAcceptedObject());
        Assertions.assertNull(testable.getAcceptedPrimitiveObject1());
        OutOfMemoryError error = new OutOfMemoryError();
        testable.setThrowable(error);
        e = Assertions.assertThrows(OutOfMemoryError.class, () -> Functions.accept(testable::testObjInt, (Object)"X", (Object)1));
        Assertions.assertSame((Object)error, (Object)e);
        Assertions.assertNull(testable.getAcceptedObject());
        Assertions.assertNull(testable.getAcceptedPrimitiveObject1());
        IOException ioe = new IOException("Unknown I/O error");
        testable.setThrowable(ioe);
        e = Assertions.assertThrows(UncheckedIOException.class, () -> Functions.accept(testable::testObjInt, (Object)"X", (Object)1));
        Throwable t = e.getCause();
        Assertions.assertNotNull((Object)t);
        Assertions.assertSame((Object)ioe, (Object)t);
        Assertions.assertNull(testable.getAcceptedObject());
        Assertions.assertNull(testable.getAcceptedPrimitiveObject1());
        testable.setThrowable(null);
        Functions.accept(testable::testObjInt, (Object)"X", (Object)1);
        Assertions.assertEquals((Object)"X", testable.getAcceptedObject());
        Assertions.assertEquals((int)1, (Integer)((Integer)testable.getAcceptedPrimitiveObject1()));
    }

    @Test
    public void testAcceptObjLongConsumer() {
        IllegalStateException ise = new IllegalStateException();
        Testable testable = new Testable(ise);
        Throwable e = Assertions.assertThrows(IllegalStateException.class, () -> Functions.accept(testable::testObjLong, (Object)"X", (Object)1L));
        Assertions.assertSame((Object)ise, (Object)e);
        Assertions.assertNull(testable.getAcceptedObject());
        Assertions.assertNull(testable.getAcceptedPrimitiveObject1());
        OutOfMemoryError error = new OutOfMemoryError();
        testable.setThrowable(error);
        e = Assertions.assertThrows(OutOfMemoryError.class, () -> Functions.accept(testable::testObjLong, (Object)"X", (Object)1L));
        Assertions.assertSame((Object)error, (Object)e);
        Assertions.assertNull(testable.getAcceptedObject());
        Assertions.assertNull(testable.getAcceptedPrimitiveObject1());
        IOException ioe = new IOException("Unknown I/O error");
        testable.setThrowable(ioe);
        e = Assertions.assertThrows(UncheckedIOException.class, () -> Functions.accept(testable::testObjLong, (Object)"X", (Object)1L));
        Throwable t = e.getCause();
        Assertions.assertNotNull((Object)t);
        Assertions.assertSame((Object)ioe, (Object)t);
        Assertions.assertNull(testable.getAcceptedObject());
        Assertions.assertNull(testable.getAcceptedPrimitiveObject1());
        testable.setThrowable(null);
        Functions.accept(testable::testObjLong, (Object)"X", (Object)1L);
        Assertions.assertEquals((Object)"X", testable.getAcceptedObject());
        Assertions.assertEquals((long)1L, (Long)((Long)testable.getAcceptedPrimitiveObject1()));
    }

    @Test
    public void testApplyBiFunction() {
        IllegalStateException ise = new IllegalStateException();
        Testable testable = new Testable(null);
        Throwable e = Assertions.assertThrows(IllegalStateException.class, () -> {
            Integer cfr_ignored_0 = (Integer)Functions.apply(Testable::testAsInteger, (Object)testable, (Object)ise);
        });
        Assertions.assertSame((Object)ise, (Object)e);
        OutOfMemoryError error = new OutOfMemoryError();
        e = Assertions.assertThrows(OutOfMemoryError.class, () -> {
            Integer cfr_ignored_0 = (Integer)Functions.apply(Testable::testAsInteger, (Object)testable, (Object)error);
        });
        Assertions.assertSame((Object)error, (Object)e);
        IOException ioe = new IOException("Unknown I/O error");
        e = Assertions.assertThrows(UncheckedIOException.class, () -> {
            Integer cfr_ignored_0 = (Integer)Functions.apply(Testable::testAsInteger, (Object)testable, (Object)ioe);
        });
        Throwable t = e.getCause();
        Assertions.assertNotNull((Object)t);
        Assertions.assertSame((Object)ioe, (Object)t);
        Integer i = (Integer)Functions.apply(Testable::testAsInteger, testable, (Object)null);
        Assertions.assertNotNull((Object)i);
        Assertions.assertEquals((int)0, (int)i);
    }

    @Test
    public void testApplyFunction() {
        IllegalStateException ise = new IllegalStateException();
        Testable testable = new Testable(ise);
        Throwable e = Assertions.assertThrows(IllegalStateException.class, () -> {
            Integer cfr_ignored_0 = (Integer)Functions.apply(Testable::testAsInteger, (Object)testable);
        });
        Assertions.assertSame((Object)ise, (Object)e);
        OutOfMemoryError error = new OutOfMemoryError();
        testable.setThrowable(error);
        e = Assertions.assertThrows(OutOfMemoryError.class, () -> {
            Integer cfr_ignored_0 = (Integer)Functions.apply(Testable::testAsInteger, (Object)testable);
        });
        Assertions.assertSame((Object)error, (Object)e);
        IOException ioe = new IOException("Unknown I/O error");
        testable.setThrowable(ioe);
        e = Assertions.assertThrows(UncheckedIOException.class, () -> {
            Integer cfr_ignored_0 = (Integer)Functions.apply(Testable::testAsInteger, (Object)testable);
        });
        Throwable t = e.getCause();
        Assertions.assertNotNull((Object)t);
        Assertions.assertSame((Object)ioe, (Object)t);
        testable.setThrowable(null);
        Integer i = (Integer)Functions.apply(Testable::testAsInteger, testable);
        Assertions.assertNotNull((Object)i);
        Assertions.assertEquals((int)0, (int)i);
    }

    @Test
    public void testAsCallable() {
        FailureOnOddInvocations instance;
        FailureOnOddInvocations.invocations = 0;
        Functions.FailableCallable failableCallable = FailureOnOddInvocations::new;
        Callable callable = Functions.asCallable((Functions.FailableCallable)failableCallable);
        UndeclaredThrowableException e = (UndeclaredThrowableException)Assertions.assertThrows(UndeclaredThrowableException.class, callable::call);
        Throwable cause = e.getCause();
        Assertions.assertNotNull((Object)cause);
        Assertions.assertTrue((boolean)(cause instanceof SomeException));
        Assertions.assertEquals((Object)"Odd Invocation: 1", (Object)cause.getMessage());
        try {
            instance = (FailureOnOddInvocations)callable.call();
        }
        catch (Exception ex) {
            throw Functions.rethrow((Throwable)ex);
        }
        Assertions.assertNotNull((Object)instance);
    }

    @Test
    public void testAsConsumer() {
        IllegalStateException ise = new IllegalStateException();
        Testable testable = new Testable(ise);
        Consumer consumer = Functions.asConsumer(Testable::test);
        Throwable e = Assertions.assertThrows(IllegalStateException.class, () -> consumer.accept(testable));
        Assertions.assertSame((Object)ise, (Object)e);
        OutOfMemoryError error = new OutOfMemoryError();
        testable.setThrowable(error);
        e = Assertions.assertThrows(OutOfMemoryError.class, () -> consumer.accept(testable));
        Assertions.assertSame((Object)error, (Object)e);
        IOException ioe = new IOException("Unknown I/O error");
        testable.setThrowable(ioe);
        e = Assertions.assertThrows(UncheckedIOException.class, () -> consumer.accept(testable));
        Throwable t = e.getCause();
        Assertions.assertNotNull((Object)t);
        Assertions.assertSame((Object)ioe, (Object)t);
        testable.setThrowable(null);
        Functions.accept(Testable::test, testable);
    }

    @Test
    public void testAsRunnable() {
        FailureOnOddInvocations.invocations = 0;
        Runnable runnable = Functions.asRunnable(FailureOnOddInvocations::new);
        UndeclaredThrowableException e = (UndeclaredThrowableException)Assertions.assertThrows(UndeclaredThrowableException.class, runnable::run);
        Throwable cause = e.getCause();
        Assertions.assertNotNull((Object)cause);
        Assertions.assertTrue((boolean)(cause instanceof SomeException));
        Assertions.assertEquals((Object)"Odd Invocation: 1", (Object)cause.getMessage());
        runnable.run();
    }

    @Test
    public void testAsSupplier() {
        FailureOnOddInvocations.invocations = 0;
        Functions.FailableSupplier failableSupplier = FailureOnOddInvocations::new;
        Supplier supplier = Functions.asSupplier((Functions.FailableSupplier)failableSupplier);
        UndeclaredThrowableException e = (UndeclaredThrowableException)Assertions.assertThrows(UndeclaredThrowableException.class, ((Supplier)supplier)::get);
        Throwable cause = e.getCause();
        Assertions.assertNotNull((Object)cause);
        Assertions.assertTrue((boolean)(cause instanceof SomeException));
        Assertions.assertEquals((Object)"Odd Invocation: 1", (Object)cause.getMessage());
        Assertions.assertNotNull(supplier.get());
    }

    @Test
    public void testBiConsumer() {
        IllegalStateException ise = new IllegalStateException();
        Testable testable = new Testable(null);
        Functions.FailableBiConsumer failableBiConsumer = (t, th) -> {
            t.setThrowable((Throwable)th);
            t.test();
        };
        BiConsumer consumer = Functions.asBiConsumer((Functions.FailableBiConsumer)failableBiConsumer);
        Throwable e = Assertions.assertThrows(IllegalStateException.class, () -> consumer.accept(testable, ise));
        Assertions.assertSame((Object)ise, (Object)e);
        OutOfMemoryError error = new OutOfMemoryError();
        e = Assertions.assertThrows(OutOfMemoryError.class, () -> consumer.accept(testable, error));
        Assertions.assertSame((Object)error, (Object)e);
        IOException ioe = new IOException("Unknown I/O error");
        testable.setThrowable(ioe);
        e = Assertions.assertThrows(UncheckedIOException.class, () -> consumer.accept(testable, ioe));
        Throwable t2 = e.getCause();
        Assertions.assertNotNull((Object)t2);
        Assertions.assertSame((Object)ioe, (Object)t2);
        consumer.accept(testable, null);
    }

    @Test
    public void testBiFunction() {
        IllegalStateException ise = new IllegalStateException();
        Testable testable = new Testable(ise);
        Functions.FailableBiFunction failableBiFunction = (t, th) -> {
            t.setThrowable((Throwable)th);
            return (int)t.testAsInteger();
        };
        BiFunction biFunction = Functions.asBiFunction((Functions.FailableBiFunction)failableBiFunction);
        Throwable e = Assertions.assertThrows(IllegalStateException.class, () -> {
            Integer cfr_ignored_0 = (Integer)biFunction.apply(testable, ise);
        });
        Assertions.assertSame((Object)ise, (Object)e);
        OutOfMemoryError error = new OutOfMemoryError();
        testable.setThrowable(error);
        e = Assertions.assertThrows(OutOfMemoryError.class, () -> {
            Integer cfr_ignored_0 = (Integer)biFunction.apply(testable, error);
        });
        Assertions.assertSame((Object)error, (Object)e);
        IOException ioe = new IOException("Unknown I/O error");
        testable.setThrowable(ioe);
        e = Assertions.assertThrows(UncheckedIOException.class, () -> {
            Integer cfr_ignored_0 = (Integer)biFunction.apply(testable, ioe);
        });
        Throwable t2 = e.getCause();
        Assertions.assertNotNull((Object)t2);
        Assertions.assertSame((Object)ioe, (Object)t2);
        Assertions.assertEquals((int)0, (int)((Integer)biFunction.apply(testable, null)));
    }

    @Test
    @DisplayName(value="Test that asPredicate(FailableBiPredicate) is converted to -> BiPredicate ")
    public void testBiPredicate() {
        FailureOnOddInvocations.invocations = 0;
        Functions.FailableBiPredicate failableBiPredicate = (t1, t2) -> FailureOnOddInvocations.failingBool();
        BiPredicate predicate = Functions.asBiPredicate((Functions.FailableBiPredicate)failableBiPredicate);
        UndeclaredThrowableException e = (UndeclaredThrowableException)Assertions.assertThrows(UndeclaredThrowableException.class, () -> predicate.test(null, null));
        Throwable cause = e.getCause();
        Assertions.assertNotNull((Object)cause);
        Assertions.assertTrue((boolean)(cause instanceof SomeException));
        Assertions.assertEquals((Object)"Odd Invocation: 1", (Object)cause.getMessage());
        boolean instance = predicate.test(null, null);
        Assertions.assertNotNull((Object)instance);
    }

    @Test
    public void testCallable() {
        FailureOnOddInvocations.invocations = 0;
        UndeclaredThrowableException e = (UndeclaredThrowableException)Assertions.assertThrows(UndeclaredThrowableException.class, () -> Functions.run(FailureOnOddInvocations::new));
        Throwable cause = e.getCause();
        Assertions.assertNotNull((Object)cause);
        Assertions.assertTrue((boolean)(cause instanceof SomeException));
        Assertions.assertEquals((Object)"Odd Invocation: 1", (Object)cause.getMessage());
        FailureOnOddInvocations instance = (FailureOnOddInvocations)Functions.call(FailureOnOddInvocations::new);
        Assertions.assertNotNull((Object)instance);
    }

    @Test
    public void testConstructor() {
        new Functions();
    }

    @Test
    public void testFunction() {
        IllegalStateException ise = new IllegalStateException();
        Testable testable = new Testable(ise);
        Functions.FailableFunction failableFunction = th -> {
            testable.setThrowable((Throwable)th);
            return (int)testable.testAsInteger();
        };
        Function function = Functions.asFunction((Functions.FailableFunction)failableFunction);
        Throwable e = Assertions.assertThrows(IllegalStateException.class, () -> {
            Integer cfr_ignored_0 = (Integer)function.apply(ise);
        });
        Assertions.assertSame((Object)ise, (Object)e);
        OutOfMemoryError error = new OutOfMemoryError();
        testable.setThrowable(error);
        e = Assertions.assertThrows(OutOfMemoryError.class, () -> {
            Integer cfr_ignored_0 = (Integer)function.apply(error);
        });
        Assertions.assertSame((Object)error, (Object)e);
        IOException ioe = new IOException("Unknown I/O error");
        testable.setThrowable(ioe);
        e = Assertions.assertThrows(UncheckedIOException.class, () -> {
            Integer cfr_ignored_0 = (Integer)function.apply(ioe);
        });
        Throwable t = e.getCause();
        Assertions.assertNotNull((Object)t);
        Assertions.assertSame((Object)ioe, (Object)t);
        Assertions.assertEquals((int)0, (int)((Integer)function.apply(null)));
    }

    @Test
    public void testGetFromSupplier() {
        FailureOnOddInvocations.invocations = 0;
        UndeclaredThrowableException e = (UndeclaredThrowableException)Assertions.assertThrows(UndeclaredThrowableException.class, () -> Functions.run(FailureOnOddInvocations::new));
        Throwable cause = e.getCause();
        Assertions.assertNotNull((Object)cause);
        Assertions.assertTrue((boolean)(cause instanceof SomeException));
        Assertions.assertEquals((Object)"Odd Invocation: 1", (Object)cause.getMessage());
        FailureOnOddInvocations instance = (FailureOnOddInvocations)Functions.call(FailureOnOddInvocations::new);
        Assertions.assertNotNull((Object)instance);
    }

    @Test
    public void testGetSupplier() {
        IllegalStateException ise = new IllegalStateException();
        Testable testable = new Testable(ise);
        Throwable e = Assertions.assertThrows(IllegalStateException.class, () -> {
            Integer cfr_ignored_0 = (Integer)Functions.get(testable::testAsInteger);
        });
        Assertions.assertSame((Object)ise, (Object)e);
        OutOfMemoryError error = new OutOfMemoryError();
        testable.setThrowable(error);
        e = Assertions.assertThrows(OutOfMemoryError.class, () -> {
            Integer cfr_ignored_0 = (Integer)Functions.get(testable::testAsInteger);
        });
        Assertions.assertSame((Object)error, (Object)e);
        IOException ioe = new IOException("Unknown I/O error");
        testable.setThrowable(ioe);
        e = Assertions.assertThrows(UncheckedIOException.class, () -> {
            Integer cfr_ignored_0 = (Integer)Functions.get(testable::testAsInteger);
        });
        Throwable t = e.getCause();
        Assertions.assertNotNull((Object)t);
        Assertions.assertSame((Object)ioe, (Object)t);
        testable.setThrowable(null);
        Integer i = (Integer)Functions.apply(Testable::testAsInteger, testable);
        Assertions.assertNotNull((Object)i);
        Assertions.assertEquals((int)0, (int)i);
    }

    @Test
    @DisplayName(value="Test that asPredicate(FailablePredicate) is converted to -> Predicate ")
    public void testPredicate() {
        FailureOnOddInvocations.invocations = 0;
        Functions.FailablePredicate failablePredicate = t -> FailureOnOddInvocations.failingBool();
        Predicate predicate = Functions.asPredicate((Functions.FailablePredicate)failablePredicate);
        UndeclaredThrowableException e = (UndeclaredThrowableException)Assertions.assertThrows(UndeclaredThrowableException.class, () -> predicate.test(null));
        Throwable cause = e.getCause();
        Assertions.assertNotNull((Object)cause);
        Assertions.assertTrue((boolean)(cause instanceof SomeException));
        Assertions.assertEquals((Object)"Odd Invocation: 1", (Object)cause.getMessage());
        boolean instance = predicate.test(null);
        Assertions.assertNotNull((Object)instance);
    }

    @Test
    public void testRunnable() {
        FailureOnOddInvocations.invocations = 0;
        UndeclaredThrowableException e = (UndeclaredThrowableException)Assertions.assertThrows(UndeclaredThrowableException.class, () -> Functions.run(FailureOnOddInvocations::new));
        Throwable cause = e.getCause();
        Assertions.assertNotNull((Object)cause);
        Assertions.assertTrue((boolean)(cause instanceof SomeException));
        Assertions.assertEquals((Object)"Odd Invocation: 1", (Object)cause.getMessage());
        Functions.run(FailureOnOddInvocations::new);
    }

    @Test
    public void testThrows_FailableBiConsumer_Object_Throwable() {
        new Functions.FailableBiConsumer<Object, Object, Throwable>(){

            public void accept(Object object1, Object object2) throws Throwable {
                throw new IOException("test");
            }
        };
    }

    @Test
    public void testThrows_FailableBiConsumer_String_IOException() {
        new Functions.FailableBiConsumer<String, String, IOException>(){

            public void accept(String object1, String object2) throws IOException {
                throw new IOException("test");
            }
        };
    }

    @Test
    public void testThrows_FailableBiFunction_Object_Throwable() {
        new Functions.FailableBiFunction<Object, Object, Object, Throwable>(){

            public Object apply(Object input1, Object input2) throws Throwable {
                throw new IOException("test");
            }
        };
    }

    @Test
    public void testThrows_FailableBiFunction_String_IOException() {
        new Functions.FailableBiFunction<String, String, String, IOException>(){

            public String apply(String input1, String input2) throws IOException {
                throw new IOException("test");
            }
        };
    }

    @Test
    public void testThrows_FailableBiPredicate_Object_Throwable() {
        new Functions.FailableBiPredicate<Object, Object, Throwable>(){

            public boolean test(Object object1, Object object2) throws Throwable {
                throw new IOException("test");
            }
        };
    }

    @Test
    public void testThrows_FailableBiPredicate_String_IOException() {
        new Functions.FailableBiPredicate<String, String, IOException>(){

            public boolean test(String object1, String object2) throws IOException {
                throw new IOException("test");
            }
        };
    }

    @Test
    public void testThrows_FailableCallable_Object_Throwable() {
        new Functions.FailableCallable<Object, Throwable>(){

            public Object call() throws Throwable {
                throw new IOException("test");
            }
        };
    }

    @Test
    public void testThrows_FailableCallable_String_IOException() {
        new Functions.FailableCallable<String, IOException>(){

            public String call() throws IOException {
                throw new IOException("test");
            }
        };
    }

    @Test
    public void testThrows_FailableConsumer_Object_Throwable() {
        new Functions.FailableConsumer<Object, Throwable>(){

            public void accept(Object object) throws Throwable {
                throw new IOException("test");
            }
        };
    }

    @Test
    public void testThrows_FailableConsumer_String_IOException() {
        new Functions.FailableConsumer<String, IOException>(){

            public void accept(String object) throws IOException {
                throw new IOException("test");
            }
        };
    }

    @Test
    public void testThrows_FailableFunction_Object_Throwable() {
        new Functions.FailableFunction<Object, Object, Throwable>(){

            public Object apply(Object input) throws Throwable {
                throw new IOException("test");
            }
        };
    }

    @Test
    public void testThrows_FailableFunction_String_IOException() {
        new Functions.FailableFunction<String, String, IOException>(){

            public String apply(String input) throws IOException {
                throw new IOException("test");
            }
        };
    }

    @Test
    public void testThrows_FailablePredicate_Object_Throwable() {
        new Functions.FailablePredicate<Object, Throwable>(){

            public boolean test(Object object) throws Throwable {
                throw new IOException("test");
            }
        };
    }

    @Test
    public void testThrows_FailablePredicate_String_IOException() {
        new Functions.FailablePredicate<String, IOException>(){

            public boolean test(String object) throws IOException {
                throw new IOException("test");
            }
        };
    }

    @Test
    public void testThrows_FailableRunnable_Object_Throwable() {
        new Functions.FailableRunnable<Throwable>(){

            public void run() throws Throwable {
                throw new IOException("test");
            }
        };
    }

    @Test
    public void testThrows_FailableRunnable_String_IOException() {
        new Functions.FailableRunnable<IOException>(){

            public void run() throws IOException {
                throw new IOException("test");
            }
        };
    }

    @Test
    public void testThrows_FailableSupplier_Object_Throwable() {
        new Functions.FailableSupplier<Object, Throwable>(){

            public Object get() throws Throwable {
                throw new IOException("test");
            }
        };
    }

    @Test
    public void testThrows_FailableSupplier_String_IOException() {
        new Functions.FailableSupplier<String, IOException>(){

            public String get() throws IOException {
                throw new IOException("test");
            }
        };
    }

    @Test
    public void testTryWithResources() {
        CloseableObject co = new CloseableObject();
        Functions.FailableConsumer consumer = co::run;
        IllegalStateException ise = new IllegalStateException();
        Throwable e = Assertions.assertThrows(IllegalStateException.class, () -> {
            Functions.FailableRunnable[] failableRunnableArray = new Functions.FailableRunnable[1];
            failableRunnableArray[0] = co::close;
            Functions.tryWithResources(() -> consumer.accept((Object)ise), (Functions.FailableRunnable[])failableRunnableArray);
        });
        Assertions.assertSame((Object)ise, (Object)e);
        Assertions.assertTrue((boolean)co.isClosed());
        co.reset();
        OutOfMemoryError error = new OutOfMemoryError();
        e = Assertions.assertThrows(OutOfMemoryError.class, () -> {
            Functions.FailableRunnable[] failableRunnableArray = new Functions.FailableRunnable[1];
            failableRunnableArray[0] = co::close;
            Functions.tryWithResources(() -> consumer.accept((Object)error), (Functions.FailableRunnable[])failableRunnableArray);
        });
        Assertions.assertSame((Object)error, (Object)e);
        Assertions.assertTrue((boolean)co.isClosed());
        co.reset();
        IOException ioe = new IOException("Unknown I/O error");
        UncheckedIOException uioe = (UncheckedIOException)Assertions.assertThrows(UncheckedIOException.class, () -> {
            Functions.FailableRunnable[] failableRunnableArray = new Functions.FailableRunnable[1];
            failableRunnableArray[0] = co::close;
            Functions.tryWithResources(() -> consumer.accept((Object)ioe), (Functions.FailableRunnable[])failableRunnableArray);
        });
        IOException cause = uioe.getCause();
        Assertions.assertSame((Object)ioe, (Object)cause);
        Assertions.assertTrue((boolean)co.isClosed());
        co.reset();
        Functions.FailableRunnable[] failableRunnableArray = new Functions.FailableRunnable[1];
        failableRunnableArray[0] = co::close;
        Functions.tryWithResources(() -> consumer.accept(null), (Functions.FailableRunnable[])failableRunnableArray);
        Assertions.assertTrue((boolean)co.isClosed());
    }

    public static class Testable<T, P> {
        private T acceptedObject;
        private P acceptedPrimitiveObject1;
        private P acceptedPrimitiveObject2;
        private Throwable throwable;

        Testable(Throwable throwable) {
            this.throwable = throwable;
        }

        public T getAcceptedObject() {
            return this.acceptedObject;
        }

        public P getAcceptedPrimitiveObject1() {
            return this.acceptedPrimitiveObject1;
        }

        public P getAcceptedPrimitiveObject2() {
            return this.acceptedPrimitiveObject2;
        }

        public void setThrowable(Throwable throwable) {
            this.throwable = throwable;
        }

        public void test() throws Throwable {
            this.test(this.throwable);
        }

        public Object test(Object input1, Object input2) throws Throwable {
            this.test(this.throwable);
            return this.acceptedObject;
        }

        public void test(Throwable throwable) throws Throwable {
            if (throwable != null) {
                throw throwable;
            }
        }

        public boolean testAsBooleanPrimitive() throws Throwable {
            return this.testAsBooleanPrimitive(this.throwable);
        }

        public boolean testAsBooleanPrimitive(Throwable throwable) throws Throwable {
            if (throwable != null) {
                throw throwable;
            }
            return false;
        }

        public double testAsDoublePrimitive() throws Throwable {
            return this.testAsDoublePrimitive(this.throwable);
        }

        public double testAsDoublePrimitive(Throwable throwable) throws Throwable {
            if (throwable != null) {
                throw throwable;
            }
            return 0.0;
        }

        public Integer testAsInteger() throws Throwable {
            return this.testAsInteger(this.throwable);
        }

        public Integer testAsInteger(Throwable throwable) throws Throwable {
            if (throwable != null) {
                throw throwable;
            }
            return 0;
        }

        public int testAsIntPrimitive() throws Throwable {
            return this.testAsIntPrimitive(this.throwable);
        }

        public int testAsIntPrimitive(Throwable throwable) throws Throwable {
            if (throwable != null) {
                throw throwable;
            }
            return 0;
        }

        public long testAsLongPrimitive() throws Throwable {
            return this.testAsLongPrimitive(this.throwable);
        }

        public long testAsLongPrimitive(Throwable throwable) throws Throwable {
            if (throwable != null) {
                throw throwable;
            }
            return 0L;
        }

        public void testDouble(double i) throws Throwable {
            this.test(this.throwable);
            this.acceptedPrimitiveObject1 = i;
        }

        public double testDoubleDouble(double i, double j) throws Throwable {
            this.test(this.throwable);
            this.acceptedPrimitiveObject1 = i;
            this.acceptedPrimitiveObject2 = j;
            return 3.0;
        }

        public void testInt(int i) throws Throwable {
            this.test(this.throwable);
            this.acceptedPrimitiveObject1 = i;
        }

        public void testLong(long i) throws Throwable {
            this.test(this.throwable);
            this.acceptedPrimitiveObject1 = i;
        }

        public void testObjDouble(T object, double i) throws Throwable {
            this.test(this.throwable);
            this.acceptedObject = object;
            this.acceptedPrimitiveObject1 = i;
        }

        public void testObjInt(T object, int i) throws Throwable {
            this.test(this.throwable);
            this.acceptedObject = object;
            this.acceptedPrimitiveObject1 = i;
        }

        public void testObjLong(T object, long i) throws Throwable {
            this.test(this.throwable);
            this.acceptedObject = object;
            this.acceptedPrimitiveObject1 = i;
        }
    }

    public static class SomeException
    extends Exception {
        private static final long serialVersionUID = -4965704778119283411L;
        private Throwable t;

        SomeException(String message) {
            super(message);
        }

        public void setThrowable(Throwable throwable) {
            this.t = throwable;
        }

        public void test() throws Throwable {
            if (this.t != null) {
                throw this.t;
            }
        }
    }

    public static class FailureOnOddInvocations {
        private static int invocations;

        static boolean failingBool() throws SomeException {
            FailureOnOddInvocations.throwOnOdd();
            return true;
        }

        static boolean testDouble(double value) throws SomeException {
            FailureOnOddInvocations.throwOnOdd();
            return true;
        }

        static boolean testInt(int value) throws SomeException {
            FailureOnOddInvocations.throwOnOdd();
            return true;
        }

        static boolean testLong(long value) throws SomeException {
            FailureOnOddInvocations.throwOnOdd();
            return true;
        }

        private static void throwOnOdd() throws SomeException {
            int i;
            if ((i = ++invocations) % 2 == 1) {
                throw new SomeException("Odd Invocation: " + i);
            }
        }

        FailureOnOddInvocations() throws SomeException {
            FailureOnOddInvocations.throwOnOdd();
        }

        boolean getAsBoolean() throws SomeException {
            FailureOnOddInvocations.throwOnOdd();
            return true;
        }
    }

    public static class CloseableObject {
        private boolean closed;

        public void close() {
            this.closed = true;
        }

        public boolean isClosed() {
            return this.closed;
        }

        public void reset() {
            this.closed = false;
        }

        public void run(Throwable pTh) throws Throwable {
            if (pTh != null) {
                throw pTh;
            }
        }
    }
}

