/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Random;
import org.apache.commons.lang3.RandomStringUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RandomStringUtilsTest {
    @Test
    public void testConstructor() {
        Assertions.assertNotNull((Object)new RandomStringUtils());
        Constructor<?>[] cons = RandomStringUtils.class.getDeclaredConstructors();
        Assertions.assertEquals((int)1, (int)cons.length);
        Assertions.assertTrue((boolean)Modifier.isPublic(cons[0].getModifiers()));
        Assertions.assertTrue((boolean)Modifier.isPublic(RandomStringUtils.class.getModifiers()));
        Assertions.assertFalse((boolean)Modifier.isFinal(RandomStringUtils.class.getModifiers()));
    }

    @Test
    public void testRandomStringUtils() {
        int i;
        int i2;
        String r1 = RandomStringUtils.random((int)50);
        Assertions.assertEquals((int)50, (int)r1.length(), (String)"random(50) length");
        String r2 = RandomStringUtils.random((int)50);
        Assertions.assertEquals((int)50, (int)r2.length(), (String)"random(50) length");
        Assertions.assertTrue((!r1.equals(r2) ? 1 : 0) != 0, (String)"!r1.equals(r2)");
        r1 = RandomStringUtils.randomAscii((int)50);
        Assertions.assertEquals((int)50, (int)r1.length(), (String)"randomAscii(50) length");
        for (i2 = 0; i2 < r1.length(); ++i2) {
            Assertions.assertTrue((r1.charAt(i2) >= ' ' && r1.charAt(i2) <= '\u007f' ? 1 : 0) != 0, (String)"char between 32 and 127");
        }
        r2 = RandomStringUtils.randomAscii((int)50);
        Assertions.assertTrue((!r1.equals(r2) ? 1 : 0) != 0, (String)"!r1.equals(r2)");
        r1 = RandomStringUtils.randomAlphabetic((int)50);
        Assertions.assertEquals((int)50, (int)r1.length(), (String)"randomAlphabetic(50)");
        for (i2 = 0; i2 < r1.length(); ++i2) {
            Assertions.assertTrue((Character.isLetter(r1.charAt(i2)) && !Character.isDigit(r1.charAt(i2)) ? 1 : 0) != 0, (String)"r1 contains alphabetic");
        }
        r2 = RandomStringUtils.randomAlphabetic((int)50);
        Assertions.assertTrue((!r1.equals(r2) ? 1 : 0) != 0, (String)"!r1.equals(r2)");
        r1 = RandomStringUtils.randomAlphanumeric((int)50);
        Assertions.assertEquals((int)50, (int)r1.length(), (String)"randomAlphanumeric(50)");
        for (i2 = 0; i2 < r1.length(); ++i2) {
            Assertions.assertTrue((boolean)Character.isLetterOrDigit(r1.charAt(i2)), (String)"r1 contains alphanumeric");
        }
        r2 = RandomStringUtils.randomAlphabetic((int)50);
        Assertions.assertTrue((!r1.equals(r2) ? 1 : 0) != 0, (String)"!r1.equals(r2)");
        r1 = RandomStringUtils.randomGraph((int)50);
        Assertions.assertEquals((int)50, (int)r1.length(), (String)"randomGraph(50) length");
        for (i2 = 0; i2 < r1.length(); ++i2) {
            Assertions.assertTrue((r1.charAt(i2) >= '!' && r1.charAt(i2) <= '~' ? 1 : 0) != 0, (String)"char between 33 and 126");
        }
        r2 = RandomStringUtils.randomGraph((int)50);
        Assertions.assertTrue((!r1.equals(r2) ? 1 : 0) != 0, (String)"!r1.equals(r2)");
        r1 = RandomStringUtils.randomNumeric((int)50);
        Assertions.assertEquals((int)50, (int)r1.length(), (String)"randomNumeric(50)");
        for (i2 = 0; i2 < r1.length(); ++i2) {
            Assertions.assertTrue((Character.isDigit(r1.charAt(i2)) && !Character.isLetter(r1.charAt(i2)) ? 1 : 0) != 0, (String)"r1 contains numeric");
        }
        r2 = RandomStringUtils.randomNumeric((int)50);
        Assertions.assertTrue((!r1.equals(r2) ? 1 : 0) != 0, (String)"!r1.equals(r2)");
        r1 = RandomStringUtils.randomPrint((int)50);
        Assertions.assertEquals((int)50, (int)r1.length(), (String)"randomPrint(50) length");
        for (i2 = 0; i2 < r1.length(); ++i2) {
            Assertions.assertTrue((r1.charAt(i2) >= ' ' && r1.charAt(i2) <= '~' ? 1 : 0) != 0, (String)"char between 32 and 126");
        }
        r2 = RandomStringUtils.randomPrint((int)50);
        Assertions.assertTrue((!r1.equals(r2) ? 1 : 0) != 0, (String)"!r1.equals(r2)");
        String set = "abcdefg";
        r1 = RandomStringUtils.random((int)50, (String)set);
        Assertions.assertEquals((int)50, (int)r1.length(), (String)"random(50, \"abcdefg\")");
        for (i = 0; i < r1.length(); ++i) {
            Assertions.assertTrue((set.indexOf(r1.charAt(i)) > -1 ? 1 : 0) != 0, (String)"random char in set");
        }
        r2 = RandomStringUtils.random((int)50, (String)set);
        Assertions.assertTrue((!r1.equals(r2) ? 1 : 0) != 0, (String)"!r1.equals(r2)");
        r1 = RandomStringUtils.random((int)50, (String)null);
        Assertions.assertEquals((int)50, (int)r1.length(), (String)"random(50) length");
        r2 = RandomStringUtils.random((int)50, (String)null);
        Assertions.assertEquals((int)50, (int)r2.length(), (String)"random(50) length");
        Assertions.assertTrue((!r1.equals(r2) ? 1 : 0) != 0, (String)"!r1.equals(r2)");
        set = "stuvwxyz";
        r1 = RandomStringUtils.random((int)50, (char[])set.toCharArray());
        Assertions.assertEquals((int)50, (int)r1.length(), (String)"random(50, \"stuvwxyz\")");
        for (i = 0; i < r1.length(); ++i) {
            Assertions.assertTrue((set.indexOf(r1.charAt(i)) > -1 ? 1 : 0) != 0, (String)"random char in set");
        }
        r2 = RandomStringUtils.random((int)50, (String)set);
        Assertions.assertTrue((!r1.equals(r2) ? 1 : 0) != 0, (String)"!r1.equals(r2)");
        r1 = RandomStringUtils.random((int)50, (char[])null);
        Assertions.assertEquals((int)50, (int)r1.length(), (String)"random(50) length");
        r2 = RandomStringUtils.random((int)50, (char[])null);
        Assertions.assertEquals((int)50, (int)r2.length(), (String)"random(50) length");
        Assertions.assertTrue((!r1.equals(r2) ? 1 : 0) != 0, (String)"!r1.equals(r2)");
        long seed = System.currentTimeMillis();
        r1 = RandomStringUtils.random((int)50, (int)0, (int)0, (boolean)true, (boolean)true, null, (Random)new Random(seed));
        r2 = RandomStringUtils.random((int)50, (int)0, (int)0, (boolean)true, (boolean)true, null, (Random)new Random(seed));
        Assertions.assertEquals((Object)r1, (Object)r2, (String)"r1.equals(r2)");
        r1 = RandomStringUtils.random((int)0);
        Assertions.assertEquals((Object)"", (Object)r1, (String)"random(0).equals(\"\")");
    }

    @Test
    public void testLANG805() {
        long seed = System.currentTimeMillis();
        Assertions.assertEquals((Object)"aaa", (Object)RandomStringUtils.random((int)3, (int)0, (int)0, (boolean)false, (boolean)false, (char[])new char[]{'a'}, (Random)new Random(seed)));
    }

    @Test
    public void testLANG807() {
        IllegalArgumentException ex = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> RandomStringUtils.random((int)3, (int)5, (int)5, (boolean)false, (boolean)false));
        String msg = ex.getMessage();
        Assertions.assertTrue((boolean)msg.contains("start"), (String)("Message (" + msg + ") must contain 'start'"));
        Assertions.assertTrue((boolean)msg.contains("end"), (String)("Message (" + msg + ") must contain 'end'"));
    }

    @Test
    public void testExceptions() {
        char[] DUMMY = new char[]{'a'};
        Assertions.assertThrows(IllegalArgumentException.class, () -> RandomStringUtils.random((int)-1));
        Assertions.assertThrows(IllegalArgumentException.class, () -> RandomStringUtils.random((int)-1, (boolean)true, (boolean)true));
        Assertions.assertThrows(IllegalArgumentException.class, () -> RandomStringUtils.random((int)-1, (char[])DUMMY));
        Assertions.assertThrows(IllegalArgumentException.class, () -> RandomStringUtils.random((int)1, (char[])new char[0]));
        Assertions.assertThrows(IllegalArgumentException.class, () -> RandomStringUtils.random((int)-1, (String)""));
        Assertions.assertThrows(IllegalArgumentException.class, () -> RandomStringUtils.random((int)-1, (String)null));
        Assertions.assertThrows(IllegalArgumentException.class, () -> RandomStringUtils.random((int)-1, (int)97, (int)122, (boolean)false, (boolean)false));
        Assertions.assertThrows(IllegalArgumentException.class, () -> RandomStringUtils.random((int)-1, (int)97, (int)122, (boolean)false, (boolean)false, (char[])DUMMY));
        Assertions.assertThrows(IllegalArgumentException.class, () -> RandomStringUtils.random((int)-1, (int)97, (int)122, (boolean)false, (boolean)false, (char[])DUMMY, (Random)new Random()));
        Assertions.assertThrows(IllegalArgumentException.class, () -> RandomStringUtils.random((int)8, (int)32, (int)48, (boolean)false, (boolean)true));
        Assertions.assertThrows(IllegalArgumentException.class, () -> RandomStringUtils.random((int)8, (int)32, (int)65, (boolean)true, (boolean)false));
    }

    @Test
    public void testRandomAlphaNumeric() {
        int i;
        char[] testChars = new char[]{'a', 'z', 'A', 'Z', '0', '9'};
        boolean[] found = new boolean[]{false, false, false, false, false, false};
        for (i = 0; i < 100; ++i) {
            String randString = RandomStringUtils.randomAlphanumeric((int)10);
            for (int j = 0; j < testChars.length; ++j) {
                if (randString.indexOf(testChars[j]) <= 0) continue;
                found[j] = true;
            }
        }
        for (i = 0; i < testChars.length; ++i) {
            Assertions.assertTrue((boolean)found[i], (String)("alphanumeric character not generated in 1000 attempts: " + testChars[i] + " -- repeated failures indicate a problem "));
        }
    }

    @Test
    public void testRandomNumeric() {
        int i;
        char[] testChars = new char[]{'0', '9'};
        boolean[] found = new boolean[]{false, false};
        for (i = 0; i < 100; ++i) {
            String randString = RandomStringUtils.randomNumeric((int)10);
            for (int j = 0; j < testChars.length; ++j) {
                if (randString.indexOf(testChars[j]) <= 0) continue;
                found[j] = true;
            }
        }
        for (i = 0; i < testChars.length; ++i) {
            Assertions.assertTrue((boolean)found[i], (String)("digit not generated in 1000 attempts: " + testChars[i] + " -- repeated failures indicate a problem "));
        }
    }

    @Test
    public void testRandomAlphabetic() {
        int i;
        char[] testChars = new char[]{'a', 'z', 'A', 'Z'};
        boolean[] found = new boolean[]{false, false, false, false};
        for (i = 0; i < 100; ++i) {
            String randString = RandomStringUtils.randomAlphabetic((int)10);
            for (int j = 0; j < testChars.length; ++j) {
                if (randString.indexOf(testChars[j]) <= 0) continue;
                found[j] = true;
            }
        }
        for (i = 0; i < testChars.length; ++i) {
            Assertions.assertTrue((boolean)found[i], (String)("alphanumeric character not generated in 1000 attempts: " + testChars[i] + " -- repeated failures indicate a problem "));
        }
    }

    @Test
    public void testRandomAscii() {
        int i;
        char[] testChars = new char[]{' ', '~'};
        boolean[] found = new boolean[]{false, false};
        for (i = 0; i < 100; ++i) {
            String randString = RandomStringUtils.randomAscii((int)10);
            for (int j = 0; j < testChars.length; ++j) {
                if (randString.indexOf(testChars[j]) <= 0) continue;
                found[j] = true;
            }
        }
        for (i = 0; i < testChars.length; ++i) {
            Assertions.assertTrue((boolean)found[i], (String)("ascii character not generated in 1000 attempts: " + testChars[i] + " -- repeated failures indicate a problem"));
        }
    }

    @Test
    public void testRandomAsciiRange() {
        boolean expectedMinLengthInclusive = true;
        int expectedMaxLengthExclusive = 11;
        String pattern = "^\\p{ASCII}{1,11}$";
        int maxCreatedLength = 1;
        int minCreatedLength = 10;
        for (int i = 0; i < 1000; ++i) {
            String s = RandomStringUtils.randomAscii((int)1, (int)11);
            MatcherAssert.assertThat((String)"within range", (Object)s.length(), (Matcher)Matchers.allOf((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(10))));
            Assertions.assertTrue((boolean)s.matches("^\\p{ASCII}{1,11}$"), (String)s);
            if (s.length() < minCreatedLength) {
                minCreatedLength = s.length();
            }
            if (s.length() <= maxCreatedLength) continue;
            maxCreatedLength = s.length();
        }
        MatcherAssert.assertThat((String)"min generated, may fail randomly rarely", (Object)minCreatedLength, (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((String)"max generated, may fail randomly rarely", (Object)maxCreatedLength, (Matcher)Matchers.is((Object)10));
    }

    @Test
    public void testRandomAlphabeticRange() {
        boolean expectedMinLengthInclusive = true;
        int expectedMaxLengthExclusive = 11;
        String pattern = "^\\p{Alpha}{1,11}$";
        int maxCreatedLength = 1;
        int minCreatedLength = 10;
        for (int i = 0; i < 1000; ++i) {
            String s = RandomStringUtils.randomAlphabetic((int)1, (int)11);
            MatcherAssert.assertThat((String)"within range", (Object)s.length(), (Matcher)Matchers.allOf((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(10))));
            Assertions.assertTrue((boolean)s.matches("^\\p{Alpha}{1,11}$"), (String)s);
            if (s.length() < minCreatedLength) {
                minCreatedLength = s.length();
            }
            if (s.length() <= maxCreatedLength) continue;
            maxCreatedLength = s.length();
        }
        MatcherAssert.assertThat((String)"min generated, may fail randomly rarely", (Object)minCreatedLength, (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((String)"max generated, may fail randomly rarely", (Object)maxCreatedLength, (Matcher)Matchers.is((Object)10));
    }

    @Test
    public void testRandomAlphanumericRange() {
        boolean expectedMinLengthInclusive = true;
        int expectedMaxLengthExclusive = 11;
        String pattern = "^\\p{Alnum}{1,11}$";
        int maxCreatedLength = 1;
        int minCreatedLength = 10;
        for (int i = 0; i < 1000; ++i) {
            String s = RandomStringUtils.randomAlphanumeric((int)1, (int)11);
            MatcherAssert.assertThat((String)"within range", (Object)s.length(), (Matcher)Matchers.allOf((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(10))));
            Assertions.assertTrue((boolean)s.matches("^\\p{Alnum}{1,11}$"), (String)s);
            if (s.length() < minCreatedLength) {
                minCreatedLength = s.length();
            }
            if (s.length() <= maxCreatedLength) continue;
            maxCreatedLength = s.length();
        }
        MatcherAssert.assertThat((String)"min generated, may fail randomly rarely", (Object)minCreatedLength, (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((String)"max generated, may fail randomly rarely", (Object)maxCreatedLength, (Matcher)Matchers.is((Object)10));
    }

    @Test
    public void testRandomGraphRange() {
        boolean expectedMinLengthInclusive = true;
        int expectedMaxLengthExclusive = 11;
        String pattern = "^\\p{Graph}{1,11}$";
        int maxCreatedLength = 1;
        int minCreatedLength = 10;
        for (int i = 0; i < 1000; ++i) {
            String s = RandomStringUtils.randomGraph((int)1, (int)11);
            MatcherAssert.assertThat((String)"within range", (Object)s.length(), (Matcher)Matchers.allOf((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(10))));
            Assertions.assertTrue((boolean)s.matches("^\\p{Graph}{1,11}$"), (String)s);
            if (s.length() < minCreatedLength) {
                minCreatedLength = s.length();
            }
            if (s.length() <= maxCreatedLength) continue;
            maxCreatedLength = s.length();
        }
        MatcherAssert.assertThat((String)"min generated, may fail randomly rarely", (Object)minCreatedLength, (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((String)"max generated, may fail randomly rarely", (Object)maxCreatedLength, (Matcher)Matchers.is((Object)10));
    }

    @Test
    public void testRandomNumericRange() {
        boolean expectedMinLengthInclusive = true;
        int expectedMaxLengthExclusive = 11;
        String pattern = "^\\p{Digit}{1,11}$";
        int maxCreatedLength = 1;
        int minCreatedLength = 10;
        for (int i = 0; i < 1000; ++i) {
            String s = RandomStringUtils.randomNumeric((int)1, (int)11);
            MatcherAssert.assertThat((String)"within range", (Object)s.length(), (Matcher)Matchers.allOf((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(10))));
            Assertions.assertTrue((boolean)s.matches("^\\p{Digit}{1,11}$"), (String)s);
            if (s.length() < minCreatedLength) {
                minCreatedLength = s.length();
            }
            if (s.length() <= maxCreatedLength) continue;
            maxCreatedLength = s.length();
        }
        MatcherAssert.assertThat((String)"min generated, may fail randomly rarely", (Object)minCreatedLength, (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((String)"max generated, may fail randomly rarely", (Object)maxCreatedLength, (Matcher)Matchers.is((Object)10));
    }

    @Test
    public void testRandomPrintRange() {
        boolean expectedMinLengthInclusive = true;
        int expectedMaxLengthExclusive = 11;
        String pattern = "^\\p{Print}{1,11}$";
        int maxCreatedLength = 1;
        int minCreatedLength = 10;
        for (int i = 0; i < 1000; ++i) {
            String s = RandomStringUtils.randomPrint((int)1, (int)11);
            MatcherAssert.assertThat((String)"within range", (Object)s.length(), (Matcher)Matchers.allOf((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(10))));
            Assertions.assertTrue((boolean)s.matches("^\\p{Print}{1,11}$"), (String)s);
            if (s.length() < minCreatedLength) {
                minCreatedLength = s.length();
            }
            if (s.length() <= maxCreatedLength) continue;
            maxCreatedLength = s.length();
        }
        MatcherAssert.assertThat((String)"min generated, may fail randomly rarely", (Object)minCreatedLength, (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((String)"max generated, may fail randomly rarely", (Object)maxCreatedLength, (Matcher)Matchers.is((Object)10));
    }

    @Test
    public void testRandomStringUtilsHomog() {
        String set = "abc";
        char[] chars = "abc".toCharArray();
        String gen = "";
        int[] counts = new int[]{0, 0, 0};
        int[] expected = new int[]{200, 200, 200};
        for (int i = 0; i < 100; ++i) {
            gen = RandomStringUtils.random((int)6, (char[])chars);
            block6: for (int j = 0; j < 6; ++j) {
                switch (gen.charAt(j)) {
                    case 'a': {
                        counts[0] = counts[0] + 1;
                        continue block6;
                    }
                    case 'b': {
                        counts[1] = counts[1] + 1;
                        continue block6;
                    }
                    case 'c': {
                        counts[2] = counts[2] + 1;
                        continue block6;
                    }
                    default: {
                        Assertions.fail((String)"generated character not in set");
                    }
                }
            }
        }
        Assertions.assertTrue((this.chiSquare(expected, counts) < 13.82 ? 1 : 0) != 0, (String)"test homogeneity -- will fail about 1 in 1000 times");
    }

    private double chiSquare(int[] expected, int[] observed) {
        double sumSq = 0.0;
        double dev = 0.0;
        for (int i = 0; i < observed.length; ++i) {
            dev = observed[i] - expected[i];
            sumSq += dev * dev / (double)expected[i];
        }
        return sumSq;
    }

    @Test
    public void testLang100() {
        int size = 5000;
        Charset charset = StandardCharsets.UTF_8;
        String orig = RandomStringUtils.random((int)5000);
        byte[] bytes = orig.getBytes(charset);
        String copy = new String(bytes, charset);
        for (int i = 0; i < orig.length() && i < copy.length(); ++i) {
            char o = orig.charAt(i);
            char c = copy.charAt(i);
            Assertions.assertEquals((char)o, (char)c, (String)("differs at " + i + "(" + Integer.toHexString(Character.valueOf(o).hashCode()) + "," + Integer.toHexString(Character.valueOf(c).hashCode()) + ")"));
        }
        Assertions.assertEquals((int)orig.length(), (int)copy.length());
        Assertions.assertEquals((Object)orig, (Object)copy);
    }

    @Test
    public void testCharOverflow() {
        int start = 65535;
        int end = Integer.MAX_VALUE;
        Random fixedRandom = new Random(){

            @Override
            public int nextInt(int n) {
                return super.nextInt(n - 1) + 1;
            }
        };
        String result = RandomStringUtils.random((int)2, (int)65535, (int)Integer.MAX_VALUE, (boolean)false, (boolean)false, null, (Random)fixedRandom);
        int c = result.codePointAt(0);
        Assertions.assertTrue((c >= 65535 && c < Integer.MAX_VALUE ? 1 : 0) != 0, (String)String.format("Character '%d' not in range [%d,%d).", c, 65535, Integer.MAX_VALUE));
    }
}

