/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.compare;

import java.math.BigDecimal;
import org.apache.commons.lang3.compare.ComparableUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.DisplayNameGeneration;
import org.junit.jupiter.api.DisplayNameGenerator;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

@DisplayNameGeneration(value=DisplayNameGenerator.ReplaceUnderscores.class)
public class ComparableUtilsTest {

    @Nested
    class A_is_1 {
        BigDecimal a = BigDecimal.ONE;

        A_is_1() {
        }

        @DisplayName(value="B is 10 (B > A)")
        @Nested
        class B_is_10 {
            BigDecimal b = BigDecimal.TEN;

            B_is_10() {
            }

            @Test
            void equalTo_returns_false() {
                Assertions.assertFalse((boolean)ComparableUtils.is((Comparable)A_is_1.this.a).equalTo((Comparable)this.b));
            }

            @Test
            void greaterThan_returns_false() {
                Assertions.assertFalse((boolean)ComparableUtils.is((Comparable)A_is_1.this.a).greaterThan((Comparable)this.b));
            }

            @Test
            void greaterThanOrEqualTo_returns_false() {
                Assertions.assertFalse((boolean)ComparableUtils.is((Comparable)A_is_1.this.a).greaterThanOrEqualTo((Comparable)this.b));
            }

            @Test
            void lessThan_returns_true() {
                Assertions.assertTrue((boolean)ComparableUtils.is((Comparable)A_is_1.this.a).lessThan((Comparable)this.b));
            }

            @Test
            void lessThanOrEqualTo_returns_true() {
                Assertions.assertTrue((boolean)ComparableUtils.is((Comparable)A_is_1.this.a).lessThanOrEqualTo((Comparable)this.b));
            }

            @DisplayName(value="C is 10 ([B,C] > A)")
            @Nested
            class C_is_10 {
                BigDecimal c = BigDecimal.TEN;

                C_is_10() {
                }

                @Test
                void between_returns_false() {
                    Assertions.assertFalse((boolean)ComparableUtils.is((Comparable)A_is_1.this.a).between((Comparable)B_is_10.this.b, (Comparable)this.c));
                }

                @Test
                void betweenExclusive_returns_false() {
                    Assertions.assertFalse((boolean)ComparableUtils.is((Comparable)A_is_1.this.a).betweenExclusive((Comparable)B_is_10.this.b, (Comparable)this.c));
                }
            }

            @DisplayName(value="C is 1 (B > A = C)")
            @Nested
            class C_is_1 {
                BigDecimal c = BigDecimal.ONE;

                C_is_1() {
                }

                @Test
                void between_returns_true() {
                    Assertions.assertTrue((boolean)ComparableUtils.is((Comparable)A_is_1.this.a).between((Comparable)B_is_10.this.b, (Comparable)this.c));
                }

                @Test
                void betweenExclusive_returns_false() {
                    Assertions.assertFalse((boolean)ComparableUtils.is((Comparable)A_is_1.this.a).betweenExclusive((Comparable)B_is_10.this.b, (Comparable)this.c));
                }
            }

            @DisplayName(value="C is 0 (B > A > C)")
            @Nested
            class C_is_0 {
                BigDecimal c = BigDecimal.ZERO;

                C_is_0() {
                }

                @Test
                void between_returns_true() {
                    Assertions.assertTrue((boolean)ComparableUtils.is((Comparable)A_is_1.this.a).between((Comparable)B_is_10.this.b, (Comparable)this.c));
                }

                @Test
                void betweenExclusive_returns_true() {
                    Assertions.assertTrue((boolean)ComparableUtils.is((Comparable)A_is_1.this.a).betweenExclusive((Comparable)B_is_10.this.b, (Comparable)this.c));
                }
            }
        }

        @DisplayName(value="B is 1 (B = A)")
        @Nested
        class B_is_1 {
            BigDecimal b = BigDecimal.ONE;

            B_is_1() {
            }

            @Test
            void equalTo_returns_true() {
                Assertions.assertTrue((boolean)ComparableUtils.is((Comparable)A_is_1.this.a).equalTo((Comparable)this.b));
            }

            @Test
            void greaterThan_returns_false() {
                Assertions.assertFalse((boolean)ComparableUtils.is((Comparable)A_is_1.this.a).greaterThan((Comparable)this.b));
            }

            @Test
            void greaterThanOrEqualTo_returns_true() {
                Assertions.assertTrue((boolean)ComparableUtils.is((Comparable)A_is_1.this.a).greaterThanOrEqualTo((Comparable)this.b));
            }

            @Test
            void lessThan_returns_false() {
                Assertions.assertFalse((boolean)ComparableUtils.is((Comparable)A_is_1.this.a).lessThan((Comparable)this.b));
            }

            @Test
            void lessThanOrEqualTo_returns_true() {
                Assertions.assertTrue((boolean)ComparableUtils.is((Comparable)A_is_1.this.a).lessThanOrEqualTo((Comparable)this.b));
            }

            @DisplayName(value="C is 10 (B = A < C)")
            @Nested
            class C_is_10 {
                BigDecimal c = BigDecimal.TEN;

                C_is_10() {
                }

                @Test
                void between_returns_true() {
                    Assertions.assertTrue((boolean)ComparableUtils.is((Comparable)A_is_1.this.a).between((Comparable)B_is_1.this.b, (Comparable)this.c));
                }

                @Test
                void betweenExclusive_returns_false() {
                    Assertions.assertFalse((boolean)ComparableUtils.is((Comparable)A_is_1.this.a).betweenExclusive((Comparable)B_is_1.this.b, (Comparable)this.c));
                }
            }

            @DisplayName(value="C is 1 (B = A = C)")
            @Nested
            class C_is_1 {
                BigDecimal c = BigDecimal.ONE;

                C_is_1() {
                }

                @Test
                void between_returns_true() {
                    Assertions.assertTrue((boolean)ComparableUtils.is((Comparable)A_is_1.this.a).between((Comparable)B_is_1.this.b, (Comparable)this.c));
                }

                @Test
                void betweenExclusive_returns_false() {
                    Assertions.assertFalse((boolean)ComparableUtils.is((Comparable)A_is_1.this.a).betweenExclusive((Comparable)B_is_1.this.b, (Comparable)this.c));
                }
            }

            @DisplayName(value="C is 0 (B = A > C)")
            @Nested
            class C_is_0 {
                BigDecimal c = BigDecimal.ZERO;

                C_is_0() {
                }

                @Test
                void between_returns_true() {
                    Assertions.assertTrue((boolean)ComparableUtils.is((Comparable)A_is_1.this.a).between((Comparable)B_is_1.this.b, (Comparable)this.c));
                }

                @Test
                void betweenExclusive_returns_false() {
                    Assertions.assertFalse((boolean)ComparableUtils.is((Comparable)A_is_1.this.a).betweenExclusive((Comparable)B_is_1.this.b, (Comparable)this.c));
                }
            }
        }

        @DisplayName(value="B is 0 (B < A)")
        @Nested
        class B_is_0 {
            BigDecimal b = BigDecimal.ZERO;

            B_is_0() {
            }

            @Test
            void equalTo_returns_false() {
                Assertions.assertFalse((boolean)ComparableUtils.is((Comparable)A_is_1.this.a).equalTo((Comparable)this.b));
            }

            @Test
            void greaterThan_returns_true() {
                Assertions.assertTrue((boolean)ComparableUtils.is((Comparable)A_is_1.this.a).greaterThan((Comparable)this.b));
            }

            @Test
            void greaterThanOrEqualTo_returns_true() {
                Assertions.assertTrue((boolean)ComparableUtils.is((Comparable)A_is_1.this.a).greaterThanOrEqualTo((Comparable)this.b));
            }

            @Test
            void lessThan_returns_false() {
                Assertions.assertFalse((boolean)ComparableUtils.is((Comparable)A_is_1.this.a).lessThan((Comparable)this.b));
            }

            @Test
            void lessThanOrEqualTo_returns_false() {
                Assertions.assertFalse((boolean)ComparableUtils.is((Comparable)A_is_1.this.a).lessThanOrEqualTo((Comparable)this.b));
            }

            @DisplayName(value="C is 10 (B < A < C)")
            @Nested
            class C_is_10 {
                BigDecimal c = BigDecimal.TEN;

                C_is_10() {
                }

                @Test
                void between_returns_true() {
                    Assertions.assertTrue((boolean)ComparableUtils.is((Comparable)A_is_1.this.a).between((Comparable)B_is_0.this.b, (Comparable)this.c));
                }

                @Test
                void betweenExclusive_returns_true() {
                    Assertions.assertTrue((boolean)ComparableUtils.is((Comparable)A_is_1.this.a).betweenExclusive((Comparable)B_is_0.this.b, (Comparable)this.c));
                }
            }

            @DisplayName(value="C is 1 (B < A = C)")
            @Nested
            class C_is_1 {
                BigDecimal c = BigDecimal.ONE;

                C_is_1() {
                }

                @Test
                void between_returns_true() {
                    Assertions.assertTrue((boolean)ComparableUtils.is((Comparable)A_is_1.this.a).between((Comparable)B_is_0.this.b, (Comparable)this.c));
                }

                @Test
                void betweenExclusive_returns_false() {
                    Assertions.assertFalse((boolean)ComparableUtils.is((Comparable)A_is_1.this.a).betweenExclusive((Comparable)B_is_0.this.b, (Comparable)this.c));
                }
            }

            @DisplayName(value="C is 0 ([B=C] < A)")
            @Nested
            class C_is_0 {
                BigDecimal c = BigDecimal.ZERO;

                C_is_0() {
                }

                @Test
                void between_returns_false() {
                    Assertions.assertFalse((boolean)ComparableUtils.is((Comparable)A_is_1.this.a).between((Comparable)B_is_0.this.b, (Comparable)this.c));
                }

                @Test
                void betweenExclusive_returns_false() {
                    Assertions.assertFalse((boolean)ComparableUtils.is((Comparable)A_is_1.this.a).betweenExclusive((Comparable)B_is_0.this.b, (Comparable)this.c));
                }
            }
        }
    }
}

