/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.concurrent.locks;

import java.util.function.LongConsumer;
import org.apache.commons.lang3.concurrent.locks.LockingVisitors;
import org.apache.commons.lang3.function.FailableConsumer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class LockingVisitorsTest {
    private static final int NUMBER_OF_THREADS = 10;
    private static final long DELAY_MILLIS = 3000L;
    private static final long TOTAL_DELAY_MILLIS = 30000L;

    @Test
    public void testStampedLockNotExclusive() throws Exception {
        boolean[] booleanValues = new boolean[10];
        this.runTest(3000L, false, l -> Assertions.assertTrue((l < 30000L ? 1 : 0) != 0), booleanValues, (LockingVisitors.LockVisitor<boolean[], ?>)LockingVisitors.stampedLockVisitor((Object)booleanValues));
    }

    @Test
    public void testReentrantReadWriteLockNotExclusive() throws Exception {
        boolean[] booleanValues = new boolean[10];
        this.runTest(3000L, false, l -> Assertions.assertTrue((l < 30000L ? 1 : 0) != 0), booleanValues, (LockingVisitors.LockVisitor<boolean[], ?>)LockingVisitors.reentrantReadWriteLockVisitor((Object)booleanValues));
    }

    @Test
    public void testStampedLockExclusive() throws Exception {
        boolean[] booleanValues = new boolean[10];
        this.runTest(3000L, true, l -> Assertions.assertTrue((l >= 30000L ? 1 : 0) != 0), booleanValues, (LockingVisitors.LockVisitor<boolean[], ?>)LockingVisitors.stampedLockVisitor((Object)booleanValues));
    }

    @Test
    public void testReentrantReadWriteLockExclusive() throws Exception {
        boolean[] booleanValues = new boolean[10];
        this.runTest(3000L, true, l -> Assertions.assertTrue((l >= 30000L ? 1 : 0) != 0), booleanValues, (LockingVisitors.LockVisitor<boolean[], ?>)LockingVisitors.reentrantReadWriteLockVisitor((Object)booleanValues));
    }

    @Test
    public void testResultValidation() {
        Object hidden = new Object();
        LockingVisitors.StampedLockVisitor lock = LockingVisitors.stampedLockVisitor((Object)hidden);
        Object o1 = lock.applyReadLocked(h -> new Object());
        Assertions.assertNotNull((Object)o1);
        Assertions.assertNotSame((Object)hidden, (Object)o1);
        Object o2 = lock.applyWriteLocked(h -> new Object());
        Assertions.assertNotNull((Object)o2);
        Assertions.assertNotSame((Object)hidden, (Object)o2);
    }

    private void runTest(long delayMillis, boolean exclusiveLock, LongConsumer runTimeCheck, boolean[] booleanValues, LockingVisitors.LockVisitor<boolean[], ?> visitor) throws InterruptedException {
        boolean[] runningValues = new boolean[10];
        long startTime = System.currentTimeMillis();
        for (int i = 0; i < booleanValues.length; ++i) {
            int index = i;
            FailableConsumer consumer = b -> {
                b[index] = false;
                Thread.sleep(delayMillis);
                b[index] = true;
                this.modify(runningValues, index, false);
            };
            Thread t = new Thread(() -> {
                if (exclusiveLock) {
                    visitor.acceptWriteLocked(consumer);
                } else {
                    visitor.acceptReadLocked(consumer);
                }
            });
            this.modify(runningValues, i, true);
            t.start();
        }
        while (this.someValueIsTrue(runningValues)) {
            Thread.sleep(100L);
        }
        long endTime = System.currentTimeMillis();
        for (int i = 0; i < booleanValues.length; ++i) {
            Assertions.assertTrue((boolean)booleanValues[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void modify(boolean[] booleanArray, int offset, boolean value) {
        boolean[] blArray = booleanArray;
        synchronized (booleanArray) {
            booleanArray[offset] = value;
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean someValueIsTrue(boolean[] booleanArray) {
        boolean[] blArray = booleanArray;
        synchronized (booleanArray) {
            for (int i = 0; i < booleanArray.length; ++i) {
                if (!booleanArray[i]) continue;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return true;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return false;
        }
    }
}

