/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.mutable;

import org.apache.commons.lang3.mutable.MutableDouble;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MutableDoubleTest {
    @Test
    public void testConstructors() {
        Assertions.assertEquals((double)0.0, (double)new MutableDouble().doubleValue(), (double)1.0E-4);
        Assertions.assertEquals((double)1.0, (double)new MutableDouble(1.0).doubleValue(), (double)1.0E-4);
        Assertions.assertEquals((double)2.0, (double)new MutableDouble((Number)2.0).doubleValue(), (double)1.0E-4);
        Assertions.assertEquals((double)3.0, (double)new MutableDouble((Number)new MutableDouble(3.0)).doubleValue(), (double)1.0E-4);
        Assertions.assertEquals((double)2.0, (double)new MutableDouble("2.0").doubleValue(), (double)1.0E-4);
    }

    @Test
    public void testConstructorNull() {
        Assertions.assertThrows(NullPointerException.class, () -> new MutableDouble((Number)null));
    }

    @Test
    public void testGetSet() {
        MutableDouble mutNum = new MutableDouble(0.0);
        Assertions.assertEquals((double)0.0, (double)new MutableDouble().doubleValue(), (double)1.0E-4);
        Assertions.assertEquals((Double)0.0, (Double)new MutableDouble().getValue());
        mutNum.setValue(1.0);
        Assertions.assertEquals((double)1.0, (double)mutNum.doubleValue(), (double)1.0E-4);
        Assertions.assertEquals((Double)1.0, (Double)mutNum.getValue());
        mutNum.setValue((Number)2.0);
        Assertions.assertEquals((double)2.0, (double)mutNum.doubleValue(), (double)1.0E-4);
        Assertions.assertEquals((Double)2.0, (Double)mutNum.getValue());
        mutNum.setValue((Number)new MutableDouble(3.0));
        Assertions.assertEquals((double)3.0, (double)mutNum.doubleValue(), (double)1.0E-4);
        Assertions.assertEquals((Double)3.0, (Double)mutNum.getValue());
    }

    @Test
    public void testSetNull() {
        MutableDouble mutNum = new MutableDouble(0.0);
        Assertions.assertThrows(NullPointerException.class, () -> mutNum.setValue(null));
    }

    @Test
    public void testNanInfinite() {
        MutableDouble mutNum = new MutableDouble(Double.NaN);
        Assertions.assertTrue((boolean)mutNum.isNaN());
        mutNum = new MutableDouble(Double.POSITIVE_INFINITY);
        Assertions.assertTrue((boolean)mutNum.isInfinite());
        mutNum = new MutableDouble(Double.NEGATIVE_INFINITY);
        Assertions.assertTrue((boolean)mutNum.isInfinite());
    }

    @Test
    public void testEquals() {
        MutableDouble mutNumA = new MutableDouble(0.0);
        MutableDouble mutNumB = new MutableDouble(0.0);
        MutableDouble mutNumC = new MutableDouble(1.0);
        Assertions.assertEquals((Object)mutNumA, (Object)mutNumA);
        Assertions.assertEquals((Object)mutNumA, (Object)mutNumB);
        Assertions.assertEquals((Object)mutNumB, (Object)mutNumA);
        Assertions.assertEquals((Object)mutNumB, (Object)mutNumB);
        Assertions.assertNotEquals((Object)mutNumA, (Object)mutNumC);
        Assertions.assertNotEquals((Object)mutNumB, (Object)mutNumC);
        Assertions.assertEquals((Object)mutNumC, (Object)mutNumC);
        Assertions.assertNotEquals(null, (Object)mutNumA);
        Assertions.assertNotEquals((Object)mutNumA, (Object)0.0);
        Assertions.assertNotEquals((Object)"0", (Object)mutNumA);
    }

    @Test
    public void testHashCode() {
        MutableDouble mutNumA = new MutableDouble(0.0);
        MutableDouble mutNumB = new MutableDouble(0.0);
        MutableDouble mutNumC = new MutableDouble(1.0);
        Assertions.assertEquals((int)mutNumA.hashCode(), (int)mutNumA.hashCode());
        Assertions.assertEquals((int)mutNumA.hashCode(), (int)mutNumB.hashCode());
        Assertions.assertNotEquals((int)mutNumA.hashCode(), (int)mutNumC.hashCode());
        Assertions.assertEquals((int)mutNumA.hashCode(), (int)Double.valueOf(0.0).hashCode());
    }

    @Test
    public void testCompareTo() {
        MutableDouble mutNum = new MutableDouble(0.0);
        Assertions.assertEquals((int)0, (int)mutNum.compareTo(new MutableDouble(0.0)));
        Assertions.assertEquals((int)1, (int)mutNum.compareTo(new MutableDouble(-1.0)));
        Assertions.assertEquals((int)-1, (int)mutNum.compareTo(new MutableDouble(1.0)));
    }

    @Test
    public void testCompareToNull() {
        MutableDouble mutNum = new MutableDouble(0.0);
        Assertions.assertThrows(NullPointerException.class, () -> mutNum.compareTo(null));
    }

    @Test
    public void testPrimitiveValues() {
        MutableDouble mutNum = new MutableDouble(1.7);
        Assertions.assertEquals((float)1.7f, (float)mutNum.floatValue());
        Assertions.assertEquals((double)1.7, (double)mutNum.doubleValue());
        Assertions.assertEquals((byte)1, (byte)mutNum.byteValue());
        Assertions.assertEquals((short)1, (short)mutNum.shortValue());
        Assertions.assertEquals((int)1, (int)mutNum.intValue());
        Assertions.assertEquals((long)1L, (long)mutNum.longValue());
    }

    @Test
    public void testToDouble() {
        Assertions.assertEquals((Double)0.0, (Double)new MutableDouble(0.0).toDouble());
        Assertions.assertEquals((Double)12.3, (Double)new MutableDouble(12.3).toDouble());
    }

    @Test
    public void testIncrement() {
        MutableDouble mutNum = new MutableDouble(1.0);
        mutNum.increment();
        Assertions.assertEquals((int)2, (int)mutNum.intValue());
        Assertions.assertEquals((long)2L, (long)mutNum.longValue());
    }

    @Test
    public void testIncrementAndGet() {
        MutableDouble mutNum = new MutableDouble(1.0);
        double result = mutNum.incrementAndGet();
        Assertions.assertEquals((double)2.0, (double)result, (double)0.01);
        Assertions.assertEquals((int)2, (int)mutNum.intValue());
        Assertions.assertEquals((long)2L, (long)mutNum.longValue());
    }

    @Test
    public void testGetAndIncrement() {
        MutableDouble mutNum = new MutableDouble(1.0);
        double result = mutNum.getAndIncrement();
        Assertions.assertEquals((double)1.0, (double)result, (double)0.01);
        Assertions.assertEquals((int)2, (int)mutNum.intValue());
        Assertions.assertEquals((long)2L, (long)mutNum.longValue());
    }

    @Test
    public void testDecrement() {
        MutableDouble mutNum = new MutableDouble(1.0);
        mutNum.decrement();
        Assertions.assertEquals((int)0, (int)mutNum.intValue());
        Assertions.assertEquals((long)0L, (long)mutNum.longValue());
    }

    @Test
    public void testDecrementAndGet() {
        MutableDouble mutNum = new MutableDouble(1.0);
        double result = mutNum.decrementAndGet();
        Assertions.assertEquals((double)0.0, (double)result, (double)0.01);
        Assertions.assertEquals((int)0, (int)mutNum.intValue());
        Assertions.assertEquals((long)0L, (long)mutNum.longValue());
    }

    @Test
    public void testGetAndDecrement() {
        MutableDouble mutNum = new MutableDouble(1.0);
        double result = mutNum.getAndDecrement();
        Assertions.assertEquals((double)1.0, (double)result, (double)0.01);
        Assertions.assertEquals((int)0, (int)mutNum.intValue());
        Assertions.assertEquals((long)0L, (long)mutNum.longValue());
    }

    @Test
    public void testAddValuePrimitive() {
        MutableDouble mutNum = new MutableDouble(1.0);
        mutNum.add(1.1);
        Assertions.assertEquals((double)2.1, (double)mutNum.doubleValue(), (double)0.01);
    }

    @Test
    public void testAddValueObject() {
        MutableDouble mutNum = new MutableDouble(1.0);
        mutNum.add((Number)1.1);
        Assertions.assertEquals((double)2.1, (double)mutNum.doubleValue(), (double)0.01);
    }

    @Test
    public void testGetAndAddValuePrimitive() {
        MutableDouble mutableDouble = new MutableDouble(0.5);
        double result = mutableDouble.getAndAdd(1.0);
        Assertions.assertEquals((double)0.5, (double)result, (double)0.01);
        Assertions.assertEquals((double)1.5, (double)mutableDouble.doubleValue(), (double)0.01);
    }

    @Test
    public void testGetAndAddValueObject() {
        MutableDouble mutableDouble = new MutableDouble(0.5);
        double result = mutableDouble.getAndAdd((Number)2.0);
        Assertions.assertEquals((double)0.5, (double)result, (double)0.01);
        Assertions.assertEquals((double)2.5, (double)mutableDouble.doubleValue(), (double)0.01);
    }

    @Test
    public void testAddAndGetValuePrimitive() {
        MutableDouble mutableDouble = new MutableDouble(10.5);
        double result = mutableDouble.addAndGet(-0.5);
        Assertions.assertEquals((double)10.0, (double)result, (double)0.01);
        Assertions.assertEquals((double)10.0, (double)mutableDouble.doubleValue(), (double)0.01);
    }

    @Test
    public void testAddAndGetValueObject() {
        MutableDouble mutableDouble = new MutableDouble(7.5);
        double result = mutableDouble.addAndGet((Number)-2.5);
        Assertions.assertEquals((double)5.0, (double)result, (double)0.01);
        Assertions.assertEquals((double)5.0, (double)mutableDouble.doubleValue(), (double)0.01);
    }

    @Test
    public void testSubtractValuePrimitive() {
        MutableDouble mutNum = new MutableDouble(1.0);
        mutNum.subtract(0.9);
        Assertions.assertEquals((double)0.1, (double)mutNum.doubleValue(), (double)0.01);
    }

    @Test
    public void testSubtractValueObject() {
        MutableDouble mutNum = new MutableDouble(1.0);
        mutNum.subtract((Number)0.9);
        Assertions.assertEquals((double)0.1, (double)mutNum.doubleValue(), (double)0.01);
    }

    @Test
    public void testToString() {
        Assertions.assertEquals((Object)"0.0", (Object)new MutableDouble(0.0).toString());
        Assertions.assertEquals((Object)"10.0", (Object)new MutableDouble(10.0).toString());
        Assertions.assertEquals((Object)"-123.0", (Object)new MutableDouble(-123.0).toString());
    }
}

