/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.time;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.TimeZone;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junitpioneer.jupiter.DefaultLocale;

public class DateUtilsTest {
    private static Date BASE_DATE;
    private DateFormat dateParser = null;
    private DateFormat dateTimeParser = null;
    private Date dateAmPm1 = null;
    private Date dateAmPm2 = null;
    private Date dateAmPm3 = null;
    private Date dateAmPm4 = null;
    private Date date0 = null;
    private Date date1 = null;
    private Date date2 = null;
    private Date date3 = null;
    private Date date4 = null;
    private Date date5 = null;
    private Date date6 = null;
    private Date date7 = null;
    private Date date8 = null;
    private Calendar calAmPm1 = null;
    private Calendar calAmPm2 = null;
    private Calendar calAmPm3 = null;
    private Calendar calAmPm4 = null;
    private Calendar cal1 = null;
    private Calendar cal2 = null;
    private Calendar cal3 = null;
    private Calendar cal4 = null;
    private Calendar cal5 = null;
    private Calendar cal6 = null;
    private Calendar cal7 = null;
    private Calendar cal8 = null;
    private TimeZone zone = null;
    private TimeZone defaultZone = null;

    @BeforeAll
    public static void classSetup() {
        GregorianCalendar cal = new GregorianCalendar(2000, 6, 5, 4, 3, 2);
        cal.set(14, 1);
        BASE_DATE = cal.getTime();
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.dateParser = new SimpleDateFormat("MMM dd, yyyy", Locale.ENGLISH);
        this.dateTimeParser = new SimpleDateFormat("MMM dd, yyyy H:mm:ss.SSS", Locale.ENGLISH);
        this.dateAmPm1 = this.dateTimeParser.parse("February 3, 2002 01:10:00.000");
        this.dateAmPm2 = this.dateTimeParser.parse("February 3, 2002 11:10:00.000");
        this.dateAmPm3 = this.dateTimeParser.parse("February 3, 2002 13:10:00.000");
        this.dateAmPm4 = this.dateTimeParser.parse("February 3, 2002 19:10:00.000");
        this.date0 = this.dateTimeParser.parse("February 3, 2002 12:34:56.789");
        this.date1 = this.dateTimeParser.parse("February 12, 2002 12:34:56.789");
        this.date2 = this.dateTimeParser.parse("November 18, 2001 1:23:11.321");
        this.defaultZone = TimeZone.getDefault();
        this.zone = TimeZone.getTimeZone("MET");
        try {
            TimeZone.setDefault(this.zone);
            this.dateTimeParser.setTimeZone(this.zone);
            this.date3 = this.dateTimeParser.parse("March 30, 2003 05:30:45.000");
            this.date4 = this.dateTimeParser.parse("March 30, 2003 01:10:00.000");
            this.date5 = this.dateTimeParser.parse("March 30, 2003 01:40:00.000");
            this.date6 = this.dateTimeParser.parse("March 30, 2003 02:10:00.000");
            this.date7 = this.dateTimeParser.parse("March 30, 2003 02:40:00.000");
            this.date8 = this.dateTimeParser.parse("October 26, 2003 05:30:45.000");
        }
        finally {
            this.dateTimeParser.setTimeZone(this.defaultZone);
            TimeZone.setDefault(this.defaultZone);
        }
        this.calAmPm1 = Calendar.getInstance();
        this.calAmPm1.setTime(this.dateAmPm1);
        this.calAmPm2 = Calendar.getInstance();
        this.calAmPm2.setTime(this.dateAmPm2);
        this.calAmPm3 = Calendar.getInstance();
        this.calAmPm3.setTime(this.dateAmPm3);
        this.calAmPm4 = Calendar.getInstance();
        this.calAmPm4.setTime(this.dateAmPm4);
        this.cal1 = Calendar.getInstance();
        this.cal1.setTime(this.date1);
        this.cal2 = Calendar.getInstance();
        this.cal2.setTime(this.date2);
        try {
            TimeZone.setDefault(this.zone);
            this.cal3 = Calendar.getInstance();
            this.cal3.setTime(this.date3);
            this.cal4 = Calendar.getInstance();
            this.cal4.setTime(this.date4);
            this.cal5 = Calendar.getInstance();
            this.cal5.setTime(this.date5);
            this.cal6 = Calendar.getInstance();
            this.cal6.setTime(this.date6);
            this.cal7 = Calendar.getInstance();
            this.cal7.setTime(this.date7);
            this.cal8 = Calendar.getInstance();
            this.cal8.setTime(this.date8);
        }
        finally {
            TimeZone.setDefault(this.defaultZone);
        }
    }

    @Test
    public void testConstructor() {
        Assertions.assertNotNull((Object)new DateUtils());
        Constructor<?>[] cons = DateUtils.class.getDeclaredConstructors();
        Assertions.assertEquals((int)1, (int)cons.length);
        Assertions.assertTrue((boolean)Modifier.isPublic(cons[0].getModifiers()));
        Assertions.assertTrue((boolean)Modifier.isPublic(DateUtils.class.getModifiers()));
        Assertions.assertFalse((boolean)Modifier.isFinal(DateUtils.class.getModifiers()));
    }

    @Test
    public void testIsSameDay_Date() {
        Date datea = new GregorianCalendar(2004, 6, 9, 13, 45).getTime();
        Date dateb = new GregorianCalendar(2004, 6, 9, 13, 45).getTime();
        Assertions.assertTrue((boolean)DateUtils.isSameDay((Date)datea, (Date)dateb));
        dateb = new GregorianCalendar(2004, 6, 10, 13, 45).getTime();
        Assertions.assertFalse((boolean)DateUtils.isSameDay((Date)datea, (Date)dateb));
        datea = new GregorianCalendar(2004, 6, 10, 13, 45).getTime();
        Assertions.assertTrue((boolean)DateUtils.isSameDay((Date)datea, (Date)dateb));
        dateb = new GregorianCalendar(2005, 6, 10, 13, 45).getTime();
        Assertions.assertFalse((boolean)DateUtils.isSameDay((Date)datea, (Date)dateb));
    }

    @Test
    public void testIsSameDay_DateNullNull() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> DateUtils.isSameDay((Date)null, null));
    }

    @Test
    public void testIsSameDay_DateNullNotNull() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> DateUtils.isSameDay(null, (Date)new Date()));
    }

    @Test
    public void testIsSameDay_DateNotNullNull() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> DateUtils.isSameDay((Date)new Date(), null));
    }

    @Test
    public void testIsSameDay_Cal() {
        GregorianCalendar cala = new GregorianCalendar(2004, 6, 9, 13, 45);
        GregorianCalendar calb = new GregorianCalendar(2004, 6, 9, 13, 45);
        Assertions.assertTrue((boolean)DateUtils.isSameDay((Calendar)cala, (Calendar)calb));
        calb.add(6, 1);
        Assertions.assertFalse((boolean)DateUtils.isSameDay((Calendar)cala, (Calendar)calb));
        cala.add(6, 1);
        Assertions.assertTrue((boolean)DateUtils.isSameDay((Calendar)cala, (Calendar)calb));
        calb.add(1, 1);
        Assertions.assertFalse((boolean)DateUtils.isSameDay((Calendar)cala, (Calendar)calb));
    }

    @Test
    public void testIsSameDay_CalNullNull() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> DateUtils.isSameDay((Calendar)null, null));
    }

    @Test
    public void testIsSameDay_CalNullNotNull() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> DateUtils.isSameDay(null, (Calendar)Calendar.getInstance()));
    }

    @Test
    public void testIsSameDay_CalNotNullNull() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> DateUtils.isSameDay((Calendar)Calendar.getInstance(), null));
    }

    @Test
    public void testIsSameInstant_Date() {
        Date datea = new GregorianCalendar(2004, 6, 9, 13, 45).getTime();
        Date dateb = new GregorianCalendar(2004, 6, 9, 13, 45).getTime();
        Assertions.assertTrue((boolean)DateUtils.isSameInstant((Date)datea, (Date)dateb));
        dateb = new GregorianCalendar(2004, 6, 10, 13, 45).getTime();
        Assertions.assertFalse((boolean)DateUtils.isSameInstant((Date)datea, (Date)dateb));
        datea = new GregorianCalendar(2004, 6, 10, 13, 45).getTime();
        Assertions.assertTrue((boolean)DateUtils.isSameInstant((Date)datea, (Date)dateb));
        dateb = new GregorianCalendar(2005, 6, 10, 13, 45).getTime();
        Assertions.assertFalse((boolean)DateUtils.isSameInstant((Date)datea, (Date)dateb));
    }

    @Test
    public void testIsSameInstant_DateNullNull() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> DateUtils.isSameInstant((Date)null, null));
    }

    @Test
    public void testIsSameInstant_DateNullNotNull() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> DateUtils.isSameInstant(null, (Date)new Date()));
    }

    @Test
    public void testIsSameInstant_DateNotNullNull() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> DateUtils.isSameInstant((Date)new Date(), null));
    }

    @Test
    public void testIsSameInstant_Cal() {
        GregorianCalendar cala = new GregorianCalendar(TimeZone.getTimeZone("GMT+1"));
        GregorianCalendar calb = new GregorianCalendar(TimeZone.getTimeZone("GMT-1"));
        cala.set(2004, 6, 9, 13, 45, 0);
        cala.set(14, 0);
        calb.set(2004, 6, 9, 13, 45, 0);
        calb.set(14, 0);
        Assertions.assertFalse((boolean)DateUtils.isSameInstant((Calendar)cala, (Calendar)calb));
        calb.set(2004, 6, 9, 11, 45, 0);
        Assertions.assertTrue((boolean)DateUtils.isSameInstant((Calendar)cala, (Calendar)calb));
    }

    @Test
    public void testIsSameInstant_CalNullNull() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> DateUtils.isSameInstant((Calendar)null, null));
    }

    @Test
    public void testIsSameInstant_CalNullNotNull() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> DateUtils.isSameInstant(null, (Calendar)Calendar.getInstance()));
    }

    @Test
    public void testIsSameInstant_CalNotNullNull() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> DateUtils.isSameInstant((Calendar)Calendar.getInstance(), null));
    }

    @Test
    public void testIsSameLocalTime_Cal() {
        GregorianCalendar cala = new GregorianCalendar(TimeZone.getTimeZone("GMT+1"));
        GregorianCalendar calb = new GregorianCalendar(TimeZone.getTimeZone("GMT-1"));
        cala.set(2004, 6, 9, 13, 45, 0);
        cala.set(14, 0);
        calb.set(2004, 6, 9, 13, 45, 0);
        calb.set(14, 0);
        Assertions.assertTrue((boolean)DateUtils.isSameLocalTime((Calendar)cala, (Calendar)calb));
        Calendar calc = Calendar.getInstance();
        Calendar cald = Calendar.getInstance();
        calc.set(2004, 6, 9, 4, 0, 0);
        cald.set(2004, 6, 9, 16, 0, 0);
        calc.set(14, 0);
        cald.set(14, 0);
        Assertions.assertFalse((boolean)DateUtils.isSameLocalTime((Calendar)calc, (Calendar)cald), (String)"LANG-677");
        calb.set(2004, 6, 9, 11, 45, 0);
        Assertions.assertFalse((boolean)DateUtils.isSameLocalTime((Calendar)cala, (Calendar)calb));
    }

    @Test
    public void testIsSameLocalTime_CalNullNull() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> DateUtils.isSameLocalTime(null, null));
    }

    @Test
    public void testIsSameLocalTime_CalNullNotNull() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> DateUtils.isSameLocalTime(null, (Calendar)Calendar.getInstance()));
    }

    @Test
    public void testIsSameLocalTime_CalNotNullNull() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> DateUtils.isSameLocalTime((Calendar)Calendar.getInstance(), null));
    }

    @Test
    public void testParseDate() throws Exception {
        GregorianCalendar cal = new GregorianCalendar(1972, 11, 3);
        String dateStr = "1972-12-03";
        String[] parsers = new String[]{"yyyy'-'DDD", "yyyy'-'MM'-'dd", "yyyyMMdd"};
        Date date = DateUtils.parseDate((String)dateStr, (String[])parsers);
        Assertions.assertEquals((Object)cal.getTime(), (Object)date);
        dateStr = "1972-338";
        date = DateUtils.parseDate((String)dateStr, (String[])parsers);
        Assertions.assertEquals((Object)cal.getTime(), (Object)date);
        dateStr = "19721203";
        date = DateUtils.parseDate((String)dateStr, (String[])parsers);
        Assertions.assertEquals((Object)cal.getTime(), (Object)date);
    }

    @Test
    public void testParseDate_NoDateString() {
        String[] parsers = new String[]{"yyyy'-'DDD", "yyyy'-'MM'-'dd", "yyyyMMdd"};
        Assertions.assertThrows(ParseException.class, () -> DateUtils.parseDate((String)"PURPLE", (String[])parsers));
    }

    @Test
    public void testParseDate_InvalidDateString() {
        String[] parsers = new String[]{"yyyy'-'DDD", "yyyy'-'MM'-'dd", "yyyyMMdd"};
        Assertions.assertThrows(ParseException.class, () -> DateUtils.parseDate((String)"197212AB", (String[])parsers));
    }

    @Test
    public void testParseDate_Null() {
        String[] parsers = new String[]{"yyyy'-'DDD", "yyyy'-'MM'-'dd", "yyyyMMdd"};
        Assertions.assertThrows(IllegalArgumentException.class, () -> DateUtils.parseDate(null, (String[])parsers));
    }

    @Test
    public void testParse_NullParsers() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> DateUtils.parseDate((String)"19721203", (String[])null));
    }

    @Test
    public void testParse_EmptyParsers() {
        Assertions.assertThrows(ParseException.class, () -> DateUtils.parseDate((String)"19721203", (String[])new String[0]));
    }

    @Test
    public void testParseDateWithLeniency() throws Exception {
        GregorianCalendar cal = new GregorianCalendar(1998, 6, 30);
        String dateStr = "02 942, 1996";
        String[] parsers = new String[]{"MM DDD, yyyy"};
        Date date = DateUtils.parseDate((String)"02 942, 1996", (String[])parsers);
        Assertions.assertEquals((Object)cal.getTime(), (Object)date);
        Assertions.assertThrows(ParseException.class, () -> DateUtils.parseDateStrictly((String)"02 942, 1996", (String[])parsers));
    }

    @Test
    public void testAddYears() throws Exception {
        Date result = DateUtils.addYears((Date)BASE_DATE, (int)0);
        Assertions.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2000, 6, 5, 4, 3, 2, 1);
        result = DateUtils.addYears((Date)BASE_DATE, (int)1);
        Assertions.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2001, 6, 5, 4, 3, 2, 1);
        result = DateUtils.addYears((Date)BASE_DATE, (int)-1);
        Assertions.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 1999, 6, 5, 4, 3, 2, 1);
    }

    @Test
    public void testAddMonths() throws Exception {
        Date result = DateUtils.addMonths((Date)BASE_DATE, (int)0);
        Assertions.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2000, 6, 5, 4, 3, 2, 1);
        result = DateUtils.addMonths((Date)BASE_DATE, (int)1);
        Assertions.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2000, 7, 5, 4, 3, 2, 1);
        result = DateUtils.addMonths((Date)BASE_DATE, (int)-1);
        Assertions.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2000, 5, 5, 4, 3, 2, 1);
    }

    @Test
    public void testAddWeeks() throws Exception {
        Date result = DateUtils.addWeeks((Date)BASE_DATE, (int)0);
        Assertions.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2000, 6, 5, 4, 3, 2, 1);
        result = DateUtils.addWeeks((Date)BASE_DATE, (int)1);
        Assertions.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2000, 6, 12, 4, 3, 2, 1);
        result = DateUtils.addWeeks((Date)BASE_DATE, (int)-1);
        Assertions.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2000, 5, 28, 4, 3, 2, 1);
    }

    @Test
    public void testAddDays() throws Exception {
        Date result = DateUtils.addDays((Date)BASE_DATE, (int)0);
        Assertions.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2000, 6, 5, 4, 3, 2, 1);
        result = DateUtils.addDays((Date)BASE_DATE, (int)1);
        Assertions.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2000, 6, 6, 4, 3, 2, 1);
        result = DateUtils.addDays((Date)BASE_DATE, (int)-1);
        Assertions.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2000, 6, 4, 4, 3, 2, 1);
    }

    @Test
    public void testAddHours() throws Exception {
        Date result = DateUtils.addHours((Date)BASE_DATE, (int)0);
        Assertions.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2000, 6, 5, 4, 3, 2, 1);
        result = DateUtils.addHours((Date)BASE_DATE, (int)1);
        Assertions.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2000, 6, 5, 5, 3, 2, 1);
        result = DateUtils.addHours((Date)BASE_DATE, (int)-1);
        Assertions.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2000, 6, 5, 3, 3, 2, 1);
    }

    @Test
    public void testAddMinutes() throws Exception {
        Date result = DateUtils.addMinutes((Date)BASE_DATE, (int)0);
        Assertions.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2000, 6, 5, 4, 3, 2, 1);
        result = DateUtils.addMinutes((Date)BASE_DATE, (int)1);
        Assertions.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2000, 6, 5, 4, 4, 2, 1);
        result = DateUtils.addMinutes((Date)BASE_DATE, (int)-1);
        Assertions.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2000, 6, 5, 4, 2, 2, 1);
    }

    @Test
    public void testAddSeconds() throws Exception {
        Date result = DateUtils.addSeconds((Date)BASE_DATE, (int)0);
        Assertions.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2000, 6, 5, 4, 3, 2, 1);
        result = DateUtils.addSeconds((Date)BASE_DATE, (int)1);
        Assertions.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2000, 6, 5, 4, 3, 3, 1);
        result = DateUtils.addSeconds((Date)BASE_DATE, (int)-1);
        Assertions.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2000, 6, 5, 4, 3, 1, 1);
    }

    @Test
    public void testAddMilliseconds() throws Exception {
        Date result = DateUtils.addMilliseconds((Date)BASE_DATE, (int)0);
        Assertions.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2000, 6, 5, 4, 3, 2, 1);
        result = DateUtils.addMilliseconds((Date)BASE_DATE, (int)1);
        Assertions.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2000, 6, 5, 4, 3, 2, 2);
        result = DateUtils.addMilliseconds((Date)BASE_DATE, (int)-1);
        Assertions.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2000, 6, 5, 4, 3, 2, 0);
    }

    @Test
    public void testSetYears() throws Exception {
        Date result = DateUtils.setYears((Date)BASE_DATE, (int)2000);
        Assertions.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2000, 6, 5, 4, 3, 2, 1);
        result = DateUtils.setYears((Date)BASE_DATE, (int)2008);
        Assertions.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2008, 6, 5, 4, 3, 2, 1);
        result = DateUtils.setYears((Date)BASE_DATE, (int)2005);
        Assertions.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2005, 6, 5, 4, 3, 2, 1);
    }

    @Test
    public void testSetMonths() throws Exception {
        Date result = DateUtils.setMonths((Date)BASE_DATE, (int)5);
        Assertions.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2000, 5, 5, 4, 3, 2, 1);
        result = DateUtils.setMonths((Date)BASE_DATE, (int)1);
        Assertions.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2000, 1, 5, 4, 3, 2, 1);
        Assertions.assertThrows(IllegalArgumentException.class, () -> DateUtils.setMonths((Date)BASE_DATE, (int)12), (String)"DateUtils.setMonths did not throw an expected IllegalArgumentException.");
    }

    @Test
    public void testSetDays() throws Exception {
        Date result = DateUtils.setDays((Date)BASE_DATE, (int)1);
        Assertions.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2000, 6, 1, 4, 3, 2, 1);
        result = DateUtils.setDays((Date)BASE_DATE, (int)29);
        Assertions.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2000, 6, 29, 4, 3, 2, 1);
        Assertions.assertThrows(IllegalArgumentException.class, () -> DateUtils.setDays((Date)BASE_DATE, (int)32), (String)"DateUtils.setDays did not throw an expected IllegalArgumentException.");
    }

    @Test
    public void testSetHours() throws Exception {
        Date result = DateUtils.setHours((Date)BASE_DATE, (int)0);
        Assertions.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2000, 6, 5, 0, 3, 2, 1);
        result = DateUtils.setHours((Date)BASE_DATE, (int)23);
        Assertions.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2000, 6, 5, 23, 3, 2, 1);
        Assertions.assertThrows(IllegalArgumentException.class, () -> DateUtils.setHours((Date)BASE_DATE, (int)24), (String)"DateUtils.setHours did not throw an expected IllegalArgumentException.");
    }

    @Test
    public void testSetMinutes() throws Exception {
        Date result = DateUtils.setMinutes((Date)BASE_DATE, (int)0);
        Assertions.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2000, 6, 5, 4, 0, 2, 1);
        result = DateUtils.setMinutes((Date)BASE_DATE, (int)59);
        Assertions.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2000, 6, 5, 4, 59, 2, 1);
        Assertions.assertThrows(IllegalArgumentException.class, () -> DateUtils.setMinutes((Date)BASE_DATE, (int)60), (String)"DateUtils.setMinutes did not throw an expected IllegalArgumentException.");
    }

    @Test
    public void testSetSeconds() throws Exception {
        Date result = DateUtils.setSeconds((Date)BASE_DATE, (int)0);
        Assertions.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2000, 6, 5, 4, 3, 0, 1);
        result = DateUtils.setSeconds((Date)BASE_DATE, (int)59);
        Assertions.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2000, 6, 5, 4, 3, 59, 1);
        Assertions.assertThrows(IllegalArgumentException.class, () -> DateUtils.setSeconds((Date)BASE_DATE, (int)60), (String)"DateUtils.setSeconds did not throw an expected IllegalArgumentException.");
    }

    @Test
    public void testSetMilliseconds() throws Exception {
        Date result = DateUtils.setMilliseconds((Date)BASE_DATE, (int)0);
        Assertions.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2000, 6, 5, 4, 3, 2, 0);
        result = DateUtils.setMilliseconds((Date)BASE_DATE, (int)999);
        Assertions.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2000, 6, 5, 4, 3, 2, 999);
        Assertions.assertThrows(IllegalArgumentException.class, () -> DateUtils.setMilliseconds((Date)BASE_DATE, (int)1000), (String)"DateUtils.setMilliseconds did not throw an expected IllegalArgumentException.");
    }

    private void assertDate(Date date, int year, int month, int day, int hour, int min, int sec, int mil) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        Assertions.assertEquals((int)year, (int)cal.get(1));
        Assertions.assertEquals((int)month, (int)cal.get(2));
        Assertions.assertEquals((int)day, (int)cal.get(5));
        Assertions.assertEquals((int)hour, (int)cal.get(11));
        Assertions.assertEquals((int)min, (int)cal.get(12));
        Assertions.assertEquals((int)sec, (int)cal.get(13));
        Assertions.assertEquals((int)mil, (int)cal.get(14));
    }

    @Test
    public void testToCalendar() {
        Assertions.assertEquals((Object)this.date1, (Object)DateUtils.toCalendar((Date)this.date1).getTime(), (String)"Failed to convert to a Calendar and back");
        Assertions.assertThrows(NullPointerException.class, () -> DateUtils.toCalendar(null));
    }

    @Test
    public void testToCalendarWithDateNull() {
        Assertions.assertThrows(NullPointerException.class, () -> DateUtils.toCalendar(null, (TimeZone)this.zone));
    }

    @Test
    public void testToCalendarWithTimeZoneNull() {
        Assertions.assertThrows(NullPointerException.class, () -> DateUtils.toCalendar((Date)this.date1, null));
    }

    @Test
    public void testToCalendarWithDateAndTimeZoneNotNull() {
        Calendar c = DateUtils.toCalendar((Date)this.date2, (TimeZone)this.defaultZone);
        Assertions.assertEquals((Object)this.date2, (Object)c.getTime(), (String)"Convert Date and TimeZone to a Calendar, but failed to get the Date back");
        Assertions.assertEquals((Object)this.defaultZone, (Object)c.getTimeZone(), (String)"Convert Date and TimeZone to a Calendar, but failed to get the TimeZone back");
    }

    @Test
    public void testToCalendarWithDateAndTimeZoneNull() {
        Assertions.assertThrows(NullPointerException.class, () -> DateUtils.toCalendar(null, null));
    }

    @Test
    public void testRound() throws Exception {
        Assertions.assertEquals((Object)this.dateParser.parse("January 1, 2002"), (Object)DateUtils.round((Date)this.date1, (int)1), (String)"round year-1 failed");
        Assertions.assertEquals((Object)this.dateParser.parse("January 1, 2002"), (Object)DateUtils.round((Date)this.date2, (int)1), (String)"round year-2 failed");
        Assertions.assertEquals((Object)this.dateParser.parse("February 1, 2002"), (Object)DateUtils.round((Date)this.date1, (int)2), (String)"round month-1 failed");
        Assertions.assertEquals((Object)this.dateParser.parse("December 1, 2001"), (Object)DateUtils.round((Date)this.date2, (int)2), (String)"round month-2 failed");
        Assertions.assertEquals((Object)this.dateParser.parse("February 1, 2002"), (Object)DateUtils.round((Date)this.date0, (int)1001), (String)"round semimonth-0 failed");
        Assertions.assertEquals((Object)this.dateParser.parse("February 16, 2002"), (Object)DateUtils.round((Date)this.date1, (int)1001), (String)"round semimonth-1 failed");
        Assertions.assertEquals((Object)this.dateParser.parse("November 16, 2001"), (Object)DateUtils.round((Date)this.date2, (int)1001), (String)"round semimonth-2 failed");
        Assertions.assertEquals((Object)this.dateParser.parse("February 13, 2002"), (Object)DateUtils.round((Date)this.date1, (int)5), (String)"round date-1 failed");
        Assertions.assertEquals((Object)this.dateParser.parse("November 18, 2001"), (Object)DateUtils.round((Date)this.date2, (int)5), (String)"round date-2 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 12, 2002 13:00:00.000"), (Object)DateUtils.round((Date)this.date1, (int)10), (String)"round hour-1 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("November 18, 2001 1:00:00.000"), (Object)DateUtils.round((Date)this.date2, (int)10), (String)"round hour-2 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 12, 2002 12:35:00.000"), (Object)DateUtils.round((Date)this.date1, (int)12), (String)"round minute-1 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("November 18, 2001 1:23:00.000"), (Object)DateUtils.round((Date)this.date2, (int)12), (String)"round minute-2 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 12, 2002 12:34:57.000"), (Object)DateUtils.round((Date)this.date1, (int)13), (String)"round second-1 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("November 18, 2001 1:23:11.000"), (Object)DateUtils.round((Date)this.date2, (int)13), (String)"round second-2 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 3, 2002 00:00:00.000"), (Object)DateUtils.round((Date)this.dateAmPm1, (int)9), (String)"round ampm-1 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 3, 2002 12:00:00.000"), (Object)DateUtils.round((Date)this.dateAmPm2, (int)9), (String)"round ampm-2 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 3, 2002 12:00:00.000"), (Object)DateUtils.round((Date)this.dateAmPm3, (int)9), (String)"round ampm-3 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 4, 2002 00:00:00.000"), (Object)DateUtils.round((Date)this.dateAmPm4, (int)9), (String)"round ampm-4 failed");
        Assertions.assertEquals((Object)this.dateParser.parse("January 1, 2002"), (Object)DateUtils.round((Object)this.date1, (int)1), (String)"round year-1 failed");
        Assertions.assertEquals((Object)this.dateParser.parse("January 1, 2002"), (Object)DateUtils.round((Object)this.date2, (int)1), (String)"round year-2 failed");
        Assertions.assertEquals((Object)this.dateParser.parse("February 1, 2002"), (Object)DateUtils.round((Object)this.date1, (int)2), (String)"round month-1 failed");
        Assertions.assertEquals((Object)this.dateParser.parse("December 1, 2001"), (Object)DateUtils.round((Object)this.date2, (int)2), (String)"round month-2 failed");
        Assertions.assertEquals((Object)this.dateParser.parse("February 16, 2002"), (Object)DateUtils.round((Object)this.date1, (int)1001), (String)"round semimonth-1 failed");
        Assertions.assertEquals((Object)this.dateParser.parse("November 16, 2001"), (Object)DateUtils.round((Object)this.date2, (int)1001), (String)"round semimonth-2 failed");
        Assertions.assertEquals((Object)this.dateParser.parse("February 13, 2002"), (Object)DateUtils.round((Object)this.date1, (int)5), (String)"round date-1 failed");
        Assertions.assertEquals((Object)this.dateParser.parse("November 18, 2001"), (Object)DateUtils.round((Object)this.date2, (int)5), (String)"round date-2 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 12, 2002 13:00:00.000"), (Object)DateUtils.round((Object)this.date1, (int)10), (String)"round hour-1 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("November 18, 2001 1:00:00.000"), (Object)DateUtils.round((Object)this.date2, (int)10), (String)"round hour-2 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 12, 2002 12:35:00.000"), (Object)DateUtils.round((Object)this.date1, (int)12), (String)"round minute-1 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("November 18, 2001 1:23:00.000"), (Object)DateUtils.round((Object)this.date2, (int)12), (String)"round minute-2 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 12, 2002 12:34:57.000"), (Object)DateUtils.round((Object)this.date1, (int)13), (String)"round second-1 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("November 18, 2001 1:23:11.000"), (Object)DateUtils.round((Object)this.date2, (int)13), (String)"round second-2 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 12, 2002 12:34:57.000"), (Object)DateUtils.round((Object)this.cal1, (int)13), (String)"round calendar second-1 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("November 18, 2001 1:23:11.000"), (Object)DateUtils.round((Object)this.cal2, (int)13), (String)"round calendar second-2 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 3, 2002 00:00:00.000"), (Object)DateUtils.round((Object)this.dateAmPm1, (int)9), (String)"round ampm-1 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 3, 2002 12:00:00.000"), (Object)DateUtils.round((Object)this.dateAmPm2, (int)9), (String)"round ampm-2 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 3, 2002 12:00:00.000"), (Object)DateUtils.round((Object)this.dateAmPm3, (int)9), (String)"round ampm-3 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 4, 2002 00:00:00.000"), (Object)DateUtils.round((Object)this.dateAmPm4, (int)9), (String)"round ampm-4 failed");
        Assertions.assertThrows(NullPointerException.class, () -> DateUtils.round((Date)null, (int)13));
        Assertions.assertThrows(IllegalArgumentException.class, () -> DateUtils.round((Calendar)null, (int)13));
        Assertions.assertThrows(IllegalArgumentException.class, () -> DateUtils.round(null, (int)13));
        Assertions.assertThrows(ClassCastException.class, () -> DateUtils.round((Object)"", (int)13));
        Assertions.assertThrows(IllegalArgumentException.class, () -> DateUtils.round((Date)this.date1, (int)-9999));
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 3, 2002 00:00:00.000"), (Object)DateUtils.round((Object)this.calAmPm1, (int)9), (String)"round ampm-1 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 3, 2002 12:00:00.000"), (Object)DateUtils.round((Object)this.calAmPm2, (int)9), (String)"round ampm-2 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 3, 2002 12:00:00.000"), (Object)DateUtils.round((Object)this.calAmPm3, (int)9), (String)"round ampm-3 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 4, 2002 00:00:00.000"), (Object)DateUtils.round((Object)this.calAmPm4, (int)9), (String)"round ampm-4 failed");
        try {
            TimeZone.setDefault(this.zone);
            this.dateTimeParser.setTimeZone(this.zone);
            Assertions.assertEquals((Object)this.dateTimeParser.parse("March 30, 2003 00:00:00.000"), (Object)DateUtils.round((Date)this.date4, (int)5), (String)"round MET date across DST change-over");
            Assertions.assertEquals((Object)this.dateTimeParser.parse("March 30, 2003 00:00:00.000"), (Object)DateUtils.round((Object)this.cal4, (int)5), (String)"round MET date across DST change-over");
            Assertions.assertEquals((Object)this.dateTimeParser.parse("March 30, 2003 00:00:00.000"), (Object)DateUtils.round((Date)this.date5, (int)5), (String)"round MET date across DST change-over");
            Assertions.assertEquals((Object)this.dateTimeParser.parse("March 30, 2003 00:00:00.000"), (Object)DateUtils.round((Object)this.cal5, (int)5), (String)"round MET date across DST change-over");
            Assertions.assertEquals((Object)this.dateTimeParser.parse("March 30, 2003 00:00:00.000"), (Object)DateUtils.round((Date)this.date6, (int)5), (String)"round MET date across DST change-over");
            Assertions.assertEquals((Object)this.dateTimeParser.parse("March 30, 2003 00:00:00.000"), (Object)DateUtils.round((Object)this.cal6, (int)5), (String)"round MET date across DST change-over");
            Assertions.assertEquals((Object)this.dateTimeParser.parse("March 30, 2003 00:00:00.000"), (Object)DateUtils.round((Date)this.date7, (int)5), (String)"round MET date across DST change-over");
            Assertions.assertEquals((Object)this.dateTimeParser.parse("March 30, 2003 00:00:00.000"), (Object)DateUtils.round((Object)this.cal7, (int)5), (String)"round MET date across DST change-over");
            Assertions.assertEquals((Object)this.dateTimeParser.parse("March 30, 2003 01:00:00.000"), (Object)DateUtils.round((Date)this.date4, (int)11), (String)"round MET date across DST change-over");
            Assertions.assertEquals((Object)this.dateTimeParser.parse("March 30, 2003 01:00:00.000"), (Object)DateUtils.round((Object)this.cal4, (int)11), (String)"round MET date across DST change-over");
            Assertions.assertEquals((Object)this.dateTimeParser.parse("March 30, 2003 03:00:00.000"), (Object)DateUtils.round((Date)this.date5, (int)11), (String)"round MET date across DST change-over");
            Assertions.assertEquals((Object)this.dateTimeParser.parse("March 30, 2003 03:00:00.000"), (Object)DateUtils.round((Object)this.cal5, (int)11), (String)"round MET date across DST change-over");
            Assertions.assertEquals((Object)this.dateTimeParser.parse("March 30, 2003 03:00:00.000"), (Object)DateUtils.round((Date)this.date6, (int)11), (String)"round MET date across DST change-over");
            Assertions.assertEquals((Object)this.dateTimeParser.parse("March 30, 2003 03:00:00.000"), (Object)DateUtils.round((Object)this.cal6, (int)11), (String)"round MET date across DST change-over");
            Assertions.assertEquals((Object)this.dateTimeParser.parse("March 30, 2003 04:00:00.000"), (Object)DateUtils.round((Date)this.date7, (int)11), (String)"round MET date across DST change-over");
            Assertions.assertEquals((Object)this.dateTimeParser.parse("March 30, 2003 04:00:00.000"), (Object)DateUtils.round((Object)this.cal7, (int)11), (String)"round MET date across DST change-over");
        }
        finally {
            TimeZone.setDefault(this.defaultZone);
            this.dateTimeParser.setTimeZone(this.defaultZone);
        }
    }

    @Test
    public void testRoundLang346() throws Exception {
        Calendar testCalendar = Calendar.getInstance();
        testCalendar.set(2007, 6, 2, 8, 8, 50);
        Date date = testCalendar.getTime();
        Assertions.assertEquals((Object)this.dateTimeParser.parse("July 2, 2007 08:09:00.000"), (Object)DateUtils.round((Date)date, (int)12), (String)"Minute Round Up Failed");
        testCalendar.set(2007, 6, 2, 8, 8, 20);
        date = testCalendar.getTime();
        Assertions.assertEquals((Object)this.dateTimeParser.parse("July 2, 2007 08:08:00.000"), (Object)DateUtils.round((Date)date, (int)12), (String)"Minute No Round Failed");
        testCalendar.set(2007, 6, 2, 8, 8, 50);
        testCalendar.set(14, 600);
        date = testCalendar.getTime();
        Assertions.assertEquals((Object)this.dateTimeParser.parse("July 2, 2007 08:08:51.000"), (Object)DateUtils.round((Date)date, (int)13), (String)"Second Round Up with 600 Milli Seconds Failed");
        testCalendar.set(2007, 6, 2, 8, 8, 50);
        testCalendar.set(14, 200);
        date = testCalendar.getTime();
        Assertions.assertEquals((Object)this.dateTimeParser.parse("July 2, 2007 08:08:50.000"), (Object)DateUtils.round((Date)date, (int)13), (String)"Second Round Down with 200 Milli Seconds Failed");
        testCalendar.set(2007, 6, 2, 8, 8, 20);
        testCalendar.set(14, 600);
        date = testCalendar.getTime();
        Assertions.assertEquals((Object)this.dateTimeParser.parse("July 2, 2007 08:08:21.000"), (Object)DateUtils.round((Date)date, (int)13), (String)"Second Round Up with 200 Milli Seconds Failed");
        testCalendar.set(2007, 6, 2, 8, 8, 20);
        testCalendar.set(14, 200);
        date = testCalendar.getTime();
        Assertions.assertEquals((Object)this.dateTimeParser.parse("July 2, 2007 08:08:20.000"), (Object)DateUtils.round((Date)date, (int)13), (String)"Second Round Down with 200 Milli Seconds Failed");
        testCalendar.set(2007, 6, 2, 8, 8, 50);
        date = testCalendar.getTime();
        Assertions.assertEquals((Object)this.dateTimeParser.parse("July 2, 2007 08:00:00.000"), (Object)DateUtils.round((Date)date, (int)10), (String)"Hour Round Down Failed");
        testCalendar.set(2007, 6, 2, 8, 31, 50);
        date = testCalendar.getTime();
        Assertions.assertEquals((Object)this.dateTimeParser.parse("July 2, 2007 09:00:00.000"), (Object)DateUtils.round((Date)date, (int)10), (String)"Hour Round Up Failed");
    }

    @Test
    public void testTruncate() throws Exception {
        Assertions.assertEquals((Object)this.dateParser.parse("January 1, 2002"), (Object)DateUtils.truncate((Date)this.date1, (int)1), (String)"truncate year-1 failed");
        Assertions.assertEquals((Object)this.dateParser.parse("January 1, 2001"), (Object)DateUtils.truncate((Date)this.date2, (int)1), (String)"truncate year-2 failed");
        Assertions.assertEquals((Object)this.dateParser.parse("February 1, 2002"), (Object)DateUtils.truncate((Date)this.date1, (int)2), (String)"truncate month-1 failed");
        Assertions.assertEquals((Object)this.dateParser.parse("November 1, 2001"), (Object)DateUtils.truncate((Date)this.date2, (int)2), (String)"truncate month-2 failed");
        Assertions.assertEquals((Object)this.dateParser.parse("February 1, 2002"), (Object)DateUtils.truncate((Date)this.date1, (int)1001), (String)"truncate semimonth-1 failed");
        Assertions.assertEquals((Object)this.dateParser.parse("November 16, 2001"), (Object)DateUtils.truncate((Date)this.date2, (int)1001), (String)"truncate semimonth-2 failed");
        Assertions.assertEquals((Object)this.dateParser.parse("February 12, 2002"), (Object)DateUtils.truncate((Date)this.date1, (int)5), (String)"truncate date-1 failed");
        Assertions.assertEquals((Object)this.dateParser.parse("November 18, 2001"), (Object)DateUtils.truncate((Date)this.date2, (int)5), (String)"truncate date-2 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 12, 2002 12:00:00.000"), (Object)DateUtils.truncate((Date)this.date1, (int)10), (String)"truncate hour-1 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("November 18, 2001 1:00:00.000"), (Object)DateUtils.truncate((Date)this.date2, (int)10), (String)"truncate hour-2 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 12, 2002 12:34:00.000"), (Object)DateUtils.truncate((Date)this.date1, (int)12), (String)"truncate minute-1 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("November 18, 2001 1:23:00.000"), (Object)DateUtils.truncate((Date)this.date2, (int)12), (String)"truncate minute-2 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 12, 2002 12:34:56.000"), (Object)DateUtils.truncate((Date)this.date1, (int)13), (String)"truncate second-1 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("November 18, 2001 1:23:11.000"), (Object)DateUtils.truncate((Date)this.date2, (int)13), (String)"truncate second-2 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 3, 2002 00:00:00.000"), (Object)DateUtils.truncate((Date)this.dateAmPm1, (int)9), (String)"truncate ampm-1 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 3, 2002 00:00:00.000"), (Object)DateUtils.truncate((Date)this.dateAmPm2, (int)9), (String)"truncate ampm-2 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 3, 2002 12:00:00.000"), (Object)DateUtils.truncate((Date)this.dateAmPm3, (int)9), (String)"truncate ampm-3 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 3, 2002 12:00:00.000"), (Object)DateUtils.truncate((Date)this.dateAmPm4, (int)9), (String)"truncate ampm-4 failed");
        Assertions.assertEquals((Object)this.dateParser.parse("January 1, 2002"), (Object)DateUtils.truncate((Object)this.date1, (int)1), (String)"truncate year-1 failed");
        Assertions.assertEquals((Object)this.dateParser.parse("January 1, 2001"), (Object)DateUtils.truncate((Object)this.date2, (int)1), (String)"truncate year-2 failed");
        Assertions.assertEquals((Object)this.dateParser.parse("February 1, 2002"), (Object)DateUtils.truncate((Object)this.date1, (int)2), (String)"truncate month-1 failed");
        Assertions.assertEquals((Object)this.dateParser.parse("November 1, 2001"), (Object)DateUtils.truncate((Object)this.date2, (int)2), (String)"truncate month-2 failed");
        Assertions.assertEquals((Object)this.dateParser.parse("February 1, 2002"), (Object)DateUtils.truncate((Object)this.date1, (int)1001), (String)"truncate semimonth-1 failed");
        Assertions.assertEquals((Object)this.dateParser.parse("November 16, 2001"), (Object)DateUtils.truncate((Object)this.date2, (int)1001), (String)"truncate semimonth-2 failed");
        Assertions.assertEquals((Object)this.dateParser.parse("February 12, 2002"), (Object)DateUtils.truncate((Object)this.date1, (int)5), (String)"truncate date-1 failed");
        Assertions.assertEquals((Object)this.dateParser.parse("November 18, 2001"), (Object)DateUtils.truncate((Object)this.date2, (int)5), (String)"truncate date-2 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 12, 2002 12:00:00.000"), (Object)DateUtils.truncate((Object)this.date1, (int)10), (String)"truncate hour-1 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("November 18, 2001 1:00:00.000"), (Object)DateUtils.truncate((Object)this.date2, (int)10), (String)"truncate hour-2 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 12, 2002 12:34:00.000"), (Object)DateUtils.truncate((Object)this.date1, (int)12), (String)"truncate minute-1 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("November 18, 2001 1:23:00.000"), (Object)DateUtils.truncate((Object)this.date2, (int)12), (String)"truncate minute-2 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 12, 2002 12:34:56.000"), (Object)DateUtils.truncate((Object)this.date1, (int)13), (String)"truncate second-1 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("November 18, 2001 1:23:11.000"), (Object)DateUtils.truncate((Object)this.date2, (int)13), (String)"truncate second-2 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 3, 2002 00:00:00.000"), (Object)DateUtils.truncate((Object)this.dateAmPm1, (int)9), (String)"truncate ampm-1 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 3, 2002 00:00:00.000"), (Object)DateUtils.truncate((Object)this.dateAmPm2, (int)9), (String)"truncate ampm-2 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 3, 2002 12:00:00.000"), (Object)DateUtils.truncate((Object)this.dateAmPm3, (int)9), (String)"truncate ampm-3 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 3, 2002 12:00:00.000"), (Object)DateUtils.truncate((Object)this.dateAmPm4, (int)9), (String)"truncate ampm-4 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 12, 2002 12:34:56.000"), (Object)DateUtils.truncate((Object)this.cal1, (int)13), (String)"truncate calendar second-1 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("November 18, 2001 1:23:11.000"), (Object)DateUtils.truncate((Object)this.cal2, (int)13), (String)"truncate calendar second-2 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 3, 2002 00:00:00.000"), (Object)DateUtils.truncate((Object)this.calAmPm1, (int)9), (String)"truncate ampm-1 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 3, 2002 00:00:00.000"), (Object)DateUtils.truncate((Object)this.calAmPm2, (int)9), (String)"truncate ampm-2 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 3, 2002 12:00:00.000"), (Object)DateUtils.truncate((Object)this.calAmPm3, (int)9), (String)"truncate ampm-3 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 3, 2002 12:00:00.000"), (Object)DateUtils.truncate((Object)this.calAmPm4, (int)9), (String)"truncate ampm-4 failed");
        Assertions.assertThrows(NullPointerException.class, () -> DateUtils.truncate((Date)null, (int)13));
        Assertions.assertThrows(IllegalArgumentException.class, () -> DateUtils.truncate((Calendar)null, (int)13));
        Assertions.assertThrows(IllegalArgumentException.class, () -> DateUtils.truncate(null, (int)13));
        Assertions.assertThrows(ClassCastException.class, () -> DateUtils.truncate((Object)"", (int)13));
        try {
            TimeZone.setDefault(this.zone);
            this.dateTimeParser.setTimeZone(this.zone);
            Assertions.assertEquals((Object)this.dateTimeParser.parse("March 30, 2003 00:00:00.000"), (Object)DateUtils.truncate((Date)this.date3, (int)5), (String)"truncate MET date across DST change-over");
            Assertions.assertEquals((Object)this.dateTimeParser.parse("March 30, 2003 00:00:00.000"), (Object)DateUtils.truncate((Object)this.cal3, (int)5), (String)"truncate MET date across DST change-over");
            Assertions.assertEquals((Object)this.dateTimeParser.parse("October 26, 2003 00:00:00.000"), (Object)DateUtils.truncate((Date)this.date8, (int)5), (String)"truncate MET date across DST change-over");
            Assertions.assertEquals((Object)this.dateTimeParser.parse("October 26, 2003 00:00:00.000"), (Object)DateUtils.truncate((Object)this.cal8, (int)5), (String)"truncate MET date across DST change-over");
        }
        finally {
            TimeZone.setDefault(this.defaultZone);
            this.dateTimeParser.setTimeZone(this.defaultZone);
        }
        Date endOfTime = new Date(Long.MAX_VALUE);
        GregorianCalendar endCal = new GregorianCalendar();
        endCal.setTime(endOfTime);
        Assertions.assertThrows(ArithmeticException.class, () -> DateUtils.truncate((Calendar)endCal, (int)5));
        endCal.set(1, 280000001);
        Assertions.assertThrows(ArithmeticException.class, () -> DateUtils.truncate((Calendar)endCal, (int)5));
        endCal.set(1, 280000000);
        Calendar cal = DateUtils.truncate((Calendar)endCal, (int)5);
        Assertions.assertEquals((int)0, (int)cal.get(10));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTruncateLang59() {
        try {
            TimeZone denverZone = TimeZone.getTimeZone("America/Denver");
            TimeZone.setDefault(denverZone);
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS XXX");
            format.setTimeZone(denverZone);
            Date oct31_01MDT = new Date(1099206000000L);
            Date oct31MDT = new Date(oct31_01MDT.getTime() - 3600000L);
            Date oct31_01_02MDT = new Date(oct31_01MDT.getTime() + 120000L);
            Date oct31_01_02_03MDT = new Date(oct31_01_02MDT.getTime() + 3000L);
            Date oct31_01_02_03_04MDT = new Date(oct31_01_02_03MDT.getTime() + 4L);
            Assertions.assertEquals((Object)"2004-10-31 00:00:00.000 -06:00", (Object)format.format(oct31MDT), (String)"Check 00:00:00.000");
            Assertions.assertEquals((Object)"2004-10-31 01:00:00.000 -06:00", (Object)format.format(oct31_01MDT), (String)"Check 01:00:00.000");
            Assertions.assertEquals((Object)"2004-10-31 01:02:00.000 -06:00", (Object)format.format(oct31_01_02MDT), (String)"Check 01:02:00.000");
            Assertions.assertEquals((Object)"2004-10-31 01:02:03.000 -06:00", (Object)format.format(oct31_01_02_03MDT), (String)"Check 01:02:03.000");
            Assertions.assertEquals((Object)"2004-10-31 01:02:03.004 -06:00", (Object)format.format(oct31_01_02_03_04MDT), (String)"Check 01:02:03.004");
            Calendar gval = Calendar.getInstance();
            gval.setTime(new Date(oct31_01MDT.getTime()));
            gval.set(12, gval.get(12));
            Assertions.assertEquals((long)gval.getTime().getTime(), (long)(oct31_01MDT.getTime() + 3600000L), (String)"Demonstrate Problem");
            Assertions.assertEquals((Object)oct31_01_02_03_04MDT, (Object)DateUtils.truncate((Date)oct31_01_02_03_04MDT, (int)14), (String)"Truncate Calendar.MILLISECOND");
            Assertions.assertEquals((Object)oct31_01_02_03MDT, (Object)DateUtils.truncate((Date)oct31_01_02_03_04MDT, (int)13), (String)"Truncate Calendar.SECOND");
            Assertions.assertEquals((Object)oct31_01_02MDT, (Object)DateUtils.truncate((Date)oct31_01_02_03_04MDT, (int)12), (String)"Truncate Calendar.MINUTE");
            Assertions.assertEquals((Object)oct31_01MDT, (Object)DateUtils.truncate((Date)oct31_01_02_03_04MDT, (int)11), (String)"Truncate Calendar.HOUR_OF_DAY");
            Assertions.assertEquals((Object)oct31_01MDT, (Object)DateUtils.truncate((Date)oct31_01_02_03_04MDT, (int)10), (String)"Truncate Calendar.HOUR");
            Assertions.assertEquals((Object)oct31MDT, (Object)DateUtils.truncate((Date)oct31_01_02_03_04MDT, (int)5), (String)"Truncate Calendar.DATE");
            Assertions.assertEquals((Object)oct31_01_02_03_04MDT, (Object)DateUtils.round((Date)oct31_01_02_03_04MDT, (int)14), (String)"Round Calendar.MILLISECOND");
            Assertions.assertEquals((Object)oct31_01_02_03MDT, (Object)DateUtils.round((Date)oct31_01_02_03_04MDT, (int)13), (String)"Round Calendar.SECOND");
            Assertions.assertEquals((Object)oct31_01_02MDT, (Object)DateUtils.round((Date)oct31_01_02_03_04MDT, (int)12), (String)"Round Calendar.MINUTE");
            Assertions.assertEquals((Object)oct31_01MDT, (Object)DateUtils.round((Date)oct31_01_02_03_04MDT, (int)11), (String)"Round Calendar.HOUR_OF_DAY");
            Assertions.assertEquals((Object)oct31_01MDT, (Object)DateUtils.round((Date)oct31_01_02_03_04MDT, (int)10), (String)"Round Calendar.HOUR");
            Assertions.assertEquals((Object)oct31MDT, (Object)DateUtils.round((Date)oct31_01_02_03_04MDT, (int)5), (String)"Round Calendar.DATE");
        }
        finally {
            TimeZone.setDefault(this.defaultZone);
        }
    }

    @Test
    public void testLang530() throws ParseException {
        Date d = new Date();
        String isoDateStr = DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.format(d);
        Date d2 = DateUtils.parseDate((String)isoDateStr, (String[])new String[]{DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.getPattern()});
        Assertions.assertEquals((long)d.getTime(), (long)(d2.getTime() + d.getTime() % 1000L), (String)"Date not equal to itself ISO formatted and parsed");
    }

    @Test
    public void testCeil() throws Exception {
        Assertions.assertEquals((Object)this.dateTimeParser.parse("March 28, 2002 14:00:00.000"), (Object)DateUtils.ceiling((Date)this.dateTimeParser.parse("March 28, 2002 13:45:01.231"), (int)10), (String)"ceiling javadoc-1 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("April 1, 2002 00:00:00.000"), (Object)DateUtils.ceiling((Date)this.dateTimeParser.parse("March 28, 2002 13:45:01.231"), (int)2), (String)"ceiling javadoc-2 failed");
        Assertions.assertEquals((Object)this.dateParser.parse("January 1, 2003"), (Object)DateUtils.ceiling((Date)this.date1, (int)1), (String)"ceiling year-1 failed");
        Assertions.assertEquals((Object)this.dateParser.parse("January 1, 2002"), (Object)DateUtils.ceiling((Date)this.date2, (int)1), (String)"ceiling year-2 failed");
        Assertions.assertEquals((Object)this.dateParser.parse("March 1, 2002"), (Object)DateUtils.ceiling((Date)this.date1, (int)2), (String)"ceiling month-1 failed");
        Assertions.assertEquals((Object)this.dateParser.parse("December 1, 2001"), (Object)DateUtils.ceiling((Date)this.date2, (int)2), (String)"ceiling month-2 failed");
        Assertions.assertEquals((Object)this.dateParser.parse("February 16, 2002"), (Object)DateUtils.ceiling((Date)this.date1, (int)1001), (String)"ceiling semimonth-1 failed");
        Assertions.assertEquals((Object)this.dateParser.parse("December 1, 2001"), (Object)DateUtils.ceiling((Date)this.date2, (int)1001), (String)"ceiling semimonth-2 failed");
        Assertions.assertEquals((Object)this.dateParser.parse("February 13, 2002"), (Object)DateUtils.ceiling((Date)this.date1, (int)5), (String)"ceiling date-1 failed");
        Assertions.assertEquals((Object)this.dateParser.parse("November 19, 2001"), (Object)DateUtils.ceiling((Date)this.date2, (int)5), (String)"ceiling date-2 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 12, 2002 13:00:00.000"), (Object)DateUtils.ceiling((Date)this.date1, (int)10), (String)"ceiling hour-1 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("November 18, 2001 2:00:00.000"), (Object)DateUtils.ceiling((Date)this.date2, (int)10), (String)"ceiling hour-2 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 12, 2002 12:35:00.000"), (Object)DateUtils.ceiling((Date)this.date1, (int)12), (String)"ceiling minute-1 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("November 18, 2001 1:24:00.000"), (Object)DateUtils.ceiling((Date)this.date2, (int)12), (String)"ceiling minute-2 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 12, 2002 12:34:57.000"), (Object)DateUtils.ceiling((Date)this.date1, (int)13), (String)"ceiling second-1 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("November 18, 2001 1:23:12.000"), (Object)DateUtils.ceiling((Date)this.date2, (int)13), (String)"ceiling second-2 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 3, 2002 12:00:00.000"), (Object)DateUtils.ceiling((Date)this.dateAmPm1, (int)9), (String)"ceiling ampm-1 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 3, 2002 12:00:00.000"), (Object)DateUtils.ceiling((Date)this.dateAmPm2, (int)9), (String)"ceiling ampm-2 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 4, 2002 00:00:00.000"), (Object)DateUtils.ceiling((Date)this.dateAmPm3, (int)9), (String)"ceiling ampm-3 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 4, 2002 00:00:00.000"), (Object)DateUtils.ceiling((Date)this.dateAmPm4, (int)9), (String)"ceiling ampm-4 failed");
        Assertions.assertEquals((Object)this.dateParser.parse("January 1, 2003"), (Object)DateUtils.ceiling((Object)this.date1, (int)1), (String)"ceiling year-1 failed");
        Assertions.assertEquals((Object)this.dateParser.parse("January 1, 2002"), (Object)DateUtils.ceiling((Object)this.date2, (int)1), (String)"ceiling year-2 failed");
        Assertions.assertEquals((Object)this.dateParser.parse("March 1, 2002"), (Object)DateUtils.ceiling((Object)this.date1, (int)2), (String)"ceiling month-1 failed");
        Assertions.assertEquals((Object)this.dateParser.parse("December 1, 2001"), (Object)DateUtils.ceiling((Object)this.date2, (int)2), (String)"ceiling month-2 failed");
        Assertions.assertEquals((Object)this.dateParser.parse("February 16, 2002"), (Object)DateUtils.ceiling((Object)this.date1, (int)1001), (String)"ceiling semimonth-1 failed");
        Assertions.assertEquals((Object)this.dateParser.parse("December 1, 2001"), (Object)DateUtils.ceiling((Object)this.date2, (int)1001), (String)"ceiling semimonth-2 failed");
        Assertions.assertEquals((Object)this.dateParser.parse("February 13, 2002"), (Object)DateUtils.ceiling((Object)this.date1, (int)5), (String)"ceiling date-1 failed");
        Assertions.assertEquals((Object)this.dateParser.parse("November 19, 2001"), (Object)DateUtils.ceiling((Object)this.date2, (int)5), (String)"ceiling date-2 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 12, 2002 13:00:00.000"), (Object)DateUtils.ceiling((Object)this.date1, (int)10), (String)"ceiling hour-1 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("November 18, 2001 2:00:00.000"), (Object)DateUtils.ceiling((Object)this.date2, (int)10), (String)"ceiling hour-2 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 12, 2002 12:35:00.000"), (Object)DateUtils.ceiling((Object)this.date1, (int)12), (String)"ceiling minute-1 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("November 18, 2001 1:24:00.000"), (Object)DateUtils.ceiling((Object)this.date2, (int)12), (String)"ceiling minute-2 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 12, 2002 12:34:57.000"), (Object)DateUtils.ceiling((Object)this.date1, (int)13), (String)"ceiling second-1 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("November 18, 2001 1:23:12.000"), (Object)DateUtils.ceiling((Object)this.date2, (int)13), (String)"ceiling second-2 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 3, 2002 12:00:00.000"), (Object)DateUtils.ceiling((Object)this.dateAmPm1, (int)9), (String)"ceiling ampm-1 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 3, 2002 12:00:00.000"), (Object)DateUtils.ceiling((Object)this.dateAmPm2, (int)9), (String)"ceiling ampm-2 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 4, 2002 00:00:00.000"), (Object)DateUtils.ceiling((Object)this.dateAmPm3, (int)9), (String)"ceiling ampm-3 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 4, 2002 00:00:00.000"), (Object)DateUtils.ceiling((Object)this.dateAmPm4, (int)9), (String)"ceiling ampm-4 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 12, 2002 12:34:57.000"), (Object)DateUtils.ceiling((Object)this.cal1, (int)13), (String)"ceiling calendar second-1 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("November 18, 2001 1:23:12.000"), (Object)DateUtils.ceiling((Object)this.cal2, (int)13), (String)"ceiling calendar second-2 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 3, 2002 12:00:00.000"), (Object)DateUtils.ceiling((Object)this.calAmPm1, (int)9), (String)"ceiling ampm-1 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 3, 2002 12:00:00.000"), (Object)DateUtils.ceiling((Object)this.calAmPm2, (int)9), (String)"ceiling ampm-2 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 4, 2002 00:00:00.000"), (Object)DateUtils.ceiling((Object)this.calAmPm3, (int)9), (String)"ceiling ampm-3 failed");
        Assertions.assertEquals((Object)this.dateTimeParser.parse("February 4, 2002 00:00:00.000"), (Object)DateUtils.ceiling((Object)this.calAmPm4, (int)9), (String)"ceiling ampm-4 failed");
        Assertions.assertThrows(NullPointerException.class, () -> DateUtils.ceiling((Date)null, (int)13));
        Assertions.assertThrows(IllegalArgumentException.class, () -> DateUtils.ceiling((Calendar)null, (int)13));
        Assertions.assertThrows(IllegalArgumentException.class, () -> DateUtils.ceiling(null, (int)13));
        Assertions.assertThrows(ClassCastException.class, () -> DateUtils.ceiling((Object)"", (int)13));
        Assertions.assertThrows(IllegalArgumentException.class, () -> DateUtils.ceiling((Date)this.date1, (int)-9999));
        try {
            TimeZone.setDefault(this.zone);
            this.dateTimeParser.setTimeZone(this.zone);
            Assertions.assertEquals((Object)this.dateTimeParser.parse("March 31, 2003 00:00:00.000"), (Object)DateUtils.ceiling((Date)this.date4, (int)5), (String)"ceiling MET date across DST change-over");
            Assertions.assertEquals((Object)this.dateTimeParser.parse("March 31, 2003 00:00:00.000"), (Object)DateUtils.ceiling((Object)this.cal4, (int)5), (String)"ceiling MET date across DST change-over");
            Assertions.assertEquals((Object)this.dateTimeParser.parse("March 31, 2003 00:00:00.000"), (Object)DateUtils.ceiling((Date)this.date5, (int)5), (String)"ceiling MET date across DST change-over");
            Assertions.assertEquals((Object)this.dateTimeParser.parse("March 31, 2003 00:00:00.000"), (Object)DateUtils.ceiling((Object)this.cal5, (int)5), (String)"ceiling MET date across DST change-over");
            Assertions.assertEquals((Object)this.dateTimeParser.parse("March 31, 2003 00:00:00.000"), (Object)DateUtils.ceiling((Date)this.date6, (int)5), (String)"ceiling MET date across DST change-over");
            Assertions.assertEquals((Object)this.dateTimeParser.parse("March 31, 2003 00:00:00.000"), (Object)DateUtils.ceiling((Object)this.cal6, (int)5), (String)"ceiling MET date across DST change-over");
            Assertions.assertEquals((Object)this.dateTimeParser.parse("March 31, 2003 00:00:00.000"), (Object)DateUtils.ceiling((Date)this.date7, (int)5), (String)"ceiling MET date across DST change-over");
            Assertions.assertEquals((Object)this.dateTimeParser.parse("March 31, 2003 00:00:00.000"), (Object)DateUtils.ceiling((Object)this.cal7, (int)5), (String)"ceiling MET date across DST change-over");
            Assertions.assertEquals((Object)this.dateTimeParser.parse("March 30, 2003 03:00:00.000"), (Object)DateUtils.ceiling((Date)this.date4, (int)11), (String)"ceiling MET date across DST change-over");
            Assertions.assertEquals((Object)this.dateTimeParser.parse("March 30, 2003 03:00:00.000"), (Object)DateUtils.ceiling((Object)this.cal4, (int)11), (String)"ceiling MET date across DST change-over");
            Assertions.assertEquals((Object)this.dateTimeParser.parse("March 30, 2003 03:00:00.000"), (Object)DateUtils.ceiling((Date)this.date5, (int)11), (String)"ceiling MET date across DST change-over");
            Assertions.assertEquals((Object)this.dateTimeParser.parse("March 30, 2003 03:00:00.000"), (Object)DateUtils.ceiling((Object)this.cal5, (int)11), (String)"ceiling MET date across DST change-over");
            Assertions.assertEquals((Object)this.dateTimeParser.parse("March 30, 2003 04:00:00.000"), (Object)DateUtils.ceiling((Date)this.date6, (int)11), (String)"ceiling MET date across DST change-over");
            Assertions.assertEquals((Object)this.dateTimeParser.parse("March 30, 2003 04:00:00.000"), (Object)DateUtils.ceiling((Object)this.cal6, (int)11), (String)"ceiling MET date across DST change-over");
            Assertions.assertEquals((Object)this.dateTimeParser.parse("March 30, 2003 04:00:00.000"), (Object)DateUtils.ceiling((Date)this.date7, (int)11), (String)"ceiling MET date across DST change-over");
            Assertions.assertEquals((Object)this.dateTimeParser.parse("March 30, 2003 04:00:00.000"), (Object)DateUtils.ceiling((Object)this.cal7, (int)11), (String)"ceiling MET date across DST change-over");
        }
        finally {
            TimeZone.setDefault(this.defaultZone);
            this.dateTimeParser.setTimeZone(this.defaultZone);
        }
        Date endOfTime = new Date(Long.MAX_VALUE);
        GregorianCalendar endCal = new GregorianCalendar();
        endCal.setTime(endOfTime);
        Assertions.assertThrows(ArithmeticException.class, () -> DateUtils.ceiling((Calendar)endCal, (int)5));
        endCal.set(1, 280000001);
        Assertions.assertThrows(ArithmeticException.class, () -> DateUtils.ceiling((Calendar)endCal, (int)5));
        endCal.set(1, 280000000);
        Calendar cal = DateUtils.ceiling((Calendar)endCal, (int)5);
        Assertions.assertEquals((int)0, (int)cal.get(10));
    }

    @Test
    public void testIteratorEx() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> DateUtils.iterator((Calendar)Calendar.getInstance(), (int)-9999));
        Assertions.assertThrows(NullPointerException.class, () -> DateUtils.iterator((Date)null, (int)4));
        Assertions.assertThrows(IllegalArgumentException.class, () -> DateUtils.iterator((Calendar)null, (int)4));
        Assertions.assertThrows(IllegalArgumentException.class, () -> DateUtils.iterator(null, (int)4));
        Assertions.assertThrows(ClassCastException.class, () -> DateUtils.iterator((Object)"", (int)4));
    }

    @Test
    public void testWeekIterator() {
        Calendar now = Calendar.getInstance();
        for (int i = 0; i < 7; ++i) {
            Calendar today = DateUtils.truncate((Calendar)now, (int)5);
            Calendar sunday = DateUtils.truncate((Calendar)now, (int)5);
            sunday.add(5, 1 - sunday.get(7));
            Calendar monday = DateUtils.truncate((Calendar)now, (int)5);
            if (monday.get(7) == 1) {
                monday.add(5, -6);
            } else {
                monday.add(5, 2 - monday.get(7));
            }
            Calendar centered = DateUtils.truncate((Calendar)now, (int)5);
            centered.add(5, -3);
            Iterator it = DateUtils.iterator((Calendar)now, (int)1);
            DateUtilsTest.assertWeekIterator(it, sunday);
            it = DateUtils.iterator((Calendar)now, (int)2);
            DateUtilsTest.assertWeekIterator(it, monday);
            it = DateUtils.iterator((Calendar)now, (int)3);
            DateUtilsTest.assertWeekIterator(it, today);
            it = DateUtils.iterator((Calendar)now, (int)4);
            DateUtilsTest.assertWeekIterator(it, centered);
            it = DateUtils.iterator((Object)now, (int)4);
            DateUtilsTest.assertWeekIterator(it, centered);
            Iterator it2 = DateUtils.iterator((Object)now.getTime(), (int)4);
            DateUtilsTest.assertWeekIterator(it2, centered);
            Assertions.assertThrows(NoSuchElementException.class, it2::next);
            Iterator it3 = DateUtils.iterator((Calendar)now, (int)4);
            it3.next();
            Assertions.assertThrows(UnsupportedOperationException.class, it3::remove);
            now.add(5, 1);
        }
    }

    @Test
    public void testMonthIterator() throws Exception {
        Iterator it = DateUtils.iterator((Date)this.date1, (int)5);
        DateUtilsTest.assertWeekIterator(it, this.dateParser.parse("January 27, 2002"), this.dateParser.parse("March 2, 2002"));
        it = DateUtils.iterator((Date)this.date1, (int)6);
        DateUtilsTest.assertWeekIterator(it, this.dateParser.parse("January 28, 2002"), this.dateParser.parse("March 3, 2002"));
        it = DateUtils.iterator((Date)this.date2, (int)5);
        DateUtilsTest.assertWeekIterator(it, this.dateParser.parse("October 28, 2001"), this.dateParser.parse("December 1, 2001"));
        it = DateUtils.iterator((Date)this.date2, (int)6);
        DateUtilsTest.assertWeekIterator(it, this.dateParser.parse("October 29, 2001"), this.dateParser.parse("December 2, 2001"));
    }

    @DefaultLocale(language="en")
    @Test
    public void testLANG799_EN_OK() throws ParseException {
        DateUtils.parseDate((String)"Wed, 09 Apr 2008 23:55:38 GMT", (String[])new String[]{"EEE, dd MMM yyyy HH:mm:ss zzz"});
        DateUtils.parseDateStrictly((String)"Wed, 09 Apr 2008 23:55:38 GMT", (String[])new String[]{"EEE, dd MMM yyyy HH:mm:ss zzz"});
    }

    @DefaultLocale(language="en")
    @Test
    public void testLANG799_EN_FAIL() {
        Assertions.assertThrows(ParseException.class, () -> DateUtils.parseDate((String)"Mi, 09 Apr 2008 23:55:38 GMT", (String[])new String[]{"EEE, dd MMM yyyy HH:mm:ss zzz"}));
    }

    @DefaultLocale(language="de")
    @Test
    public void testLANG799_DE_OK() throws ParseException {
        DateUtils.parseDate((String)"Mi, 09 Apr 2008 23:55:38 GMT", (String[])new String[]{"EEE, dd MMM yyyy HH:mm:ss zzz"});
        DateUtils.parseDateStrictly((String)"Mi, 09 Apr 2008 23:55:38 GMT", (String[])new String[]{"EEE, dd MMM yyyy HH:mm:ss zzz"});
    }

    @DefaultLocale(language="de")
    @Test
    public void testLANG799_DE_FAIL() {
        Assertions.assertThrows(ParseException.class, () -> DateUtils.parseDate((String)"Wed, 09 Apr 2008 23:55:38 GMT", (String[])new String[]{"EEE, dd MMM yyyy HH:mm:ss zzz"}));
    }

    @DefaultLocale(language="en")
    @Test
    public void testLANG799_EN_WITH_DE_LOCALE() throws ParseException {
        DateUtils.parseDate((String)"Mi, 09 Apr 2008 23:55:38 GMT", (Locale)Locale.GERMAN, (String[])new String[]{"EEE, dd MMM yyyy HH:mm:ss zzz"});
    }

    private static void assertWeekIterator(Iterator<?> it, Calendar start) {
        Calendar end = (Calendar)start.clone();
        end.add(5, 6);
        DateUtilsTest.assertWeekIterator(it, start, end);
    }

    private static void assertWeekIterator(Iterator<?> it, Date start, Date end) {
        Calendar calStart = Calendar.getInstance();
        calStart.setTime(start);
        Calendar calEnd = Calendar.getInstance();
        calEnd.setTime(end);
        DateUtilsTest.assertWeekIterator(it, calStart, calEnd);
    }

    private static void assertWeekIterator(Iterator<?> it, Calendar start, Calendar end) {
        Calendar cal = (Calendar)it.next();
        DateUtilsTest.assertCalendarsEquals("", start, cal, 0L);
        Calendar last = null;
        int count = 1;
        while (it.hasNext()) {
            DateUtilsTest.assertCalendarsEquals("", cal, DateUtils.truncate((Calendar)cal, (int)5), 0L);
            last = cal;
            cal = (Calendar)it.next();
            ++count;
            last.add(5, 1);
            DateUtilsTest.assertCalendarsEquals("", last, cal, 0L);
        }
        Assertions.assertFalse((count % 7 != 0 ? 1 : 0) != 0, (String)("There were " + count + " days in this iterator"));
        DateUtilsTest.assertCalendarsEquals("", end, cal, 0L);
    }

    private static void assertCalendarsEquals(String message, Calendar cal1, Calendar cal2, long delta) {
        Assertions.assertFalse((Math.abs(cal1.getTime().getTime() - cal2.getTime().getTime()) > delta ? 1 : 0) != 0, (String)(message + " expected " + cal1.getTime() + " but got " + cal2.getTime()));
    }

    @Test
    public void testLANG799() throws ParseException {
        DateUtils.parseDateStrictly((String)"09 abril 2008 23:55:38 GMT", (Locale)new Locale("es"), (String[])new String[]{"dd MMM yyyy HH:mm:ss zzz"});
    }
}

